/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs.lucene90;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongCompanionObject;
import kotlin.jvm.internal.ShortCompanionObject;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.index.KnnVectorValues;
import org.gnit.lucenekmp.jdkport.LongExtKt;
import org.gnit.lucenekmp.jdkport.ShortExtKt;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.store.IndexInput;
import org.gnit.lucenekmp.store.IndexOutput;
import org.gnit.lucenekmp.store.RandomAccessInput;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.BitSetIterator;
import org.gnit.lucenekmp.util.FixedBitSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\t\n\u0002\b\u0010\n\u0002\u0010\u0012\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u001b\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 ]2\u00020\u0001:\u0002\\]B3\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rB9\b\u0016\u0012\u0006\u0010\u000e\u001a\u00020\u0003\u0012\u0006\u0010\u000f\u001a\u00020\u000b\u0012\u0006\u0010\u0010\u001a\u00020\u000b\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\u0011J\b\u0010S\u001a\u00020\u0007H\u0016J\u0010\u0010T\u001a\u00020\u00072\u0006\u0010U\u001a\u00020\u0007H\u0016J\u000e\u0010V\u001a\u00020<2\u0006\u0010U\u001a\u00020\u0007J\u0010\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020\u0007H\u0002J\b\u0010Z\u001a\u00020XH\u0002J\b\u0010[\u001a\u00020\u0007H\u0016J\u0006\u00108\u001a\u00020\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0012\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\u001b\u001a\u0004\u0018\u00010\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0016\"\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010 \"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010 \"\u0004\b+\u0010(R\u001a\u0010,\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u0016\"\u0004\b.\u0010$R\u001c\u0010/\u001a\u0004\u0018\u000100X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u001a\u00105\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010\u0016\"\u0004\b7\u0010$R\u001a\u00108\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010\u0016\"\u0004\b:\u0010$R\u001a\u0010;\u001a\u00020<X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R\u001a\u0010A\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010\u0016\"\u0004\bC\u0010$R\u001a\u0010D\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010 \"\u0004\bF\u0010(R\u001a\u0010G\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bH\u0010\u0016\"\u0004\bI\u0010$R\u001a\u0010J\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010\u0016\"\u0004\bL\u0010$R\u001a\u0010M\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bN\u0010\u0016\"\u0004\bO\u0010$R\u001a\u0010P\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bQ\u0010\u0016\"\u0004\bR\u0010$\u00a8\u0006^"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/IndexedDISI;", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "blockSlice", "Lorg/gnit/lucenekmp/store/IndexInput;", "jumpTable", "Lorg/gnit/lucenekmp/store/RandomAccessInput;", "jumpTableEntryCount", "", "denseRankPower", "", "cost", "", "<init>", "(Lorg/gnit/lucenekmp/store/IndexInput;Lorg/gnit/lucenekmp/store/RandomAccessInput;IBJ)V", "in", "offset", "length", "(Lorg/gnit/lucenekmp/store/IndexInput;JJIBJ)V", "slice", "getSlice", "()Lorg/gnit/lucenekmp/store/IndexInput;", "getJumpTableEntryCount", "()I", "getDenseRankPower", "()B", "getJumpTable", "()Lorg/gnit/lucenekmp/store/RandomAccessInput;", "denseRankTable", "", "getDenseRankTable", "()[B", "getCost", "()J", "block", "getBlock", "setBlock", "(I)V", "blockEnd", "getBlockEnd", "setBlockEnd", "(J)V", "denseBitmapOffset", "getDenseBitmapOffset", "setDenseBitmapOffset", "nextBlockIndex", "getNextBlockIndex", "setNextBlockIndex", "method", "Lorg/gnit/lucenekmp/codecs/lucene90/IndexedDISI$Method;", "getMethod", "()Lorg/gnit/lucenekmp/codecs/lucene90/IndexedDISI$Method;", "setMethod", "(Lorg/gnit/lucenekmp/codecs/lucene90/IndexedDISI$Method;)V", "doc", "getDoc", "setDoc", "index", "getIndex", "setIndex", "exists", "", "getExists", "()Z", "setExists", "(Z)V", "nextExistDocInBlock", "getNextExistDocInBlock", "setNextExistDocInBlock", "word", "getWord", "setWord", "wordIndex", "getWordIndex", "setWordIndex", "numberOfOnes", "getNumberOfOnes", "setNumberOfOnes", "denseOrigoIndex", "getDenseOrigoIndex", "setDenseOrigoIndex", "gap", "getGap", "setGap", "docID", "advance", "target", "advanceExact", "advanceBlock", "", "targetBlock", "readBlockHeader", "nextDoc", "Method", "Companion", "core"})
public final class IndexedDISI
extends DocIdSetIterator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IndexInput slice;
    private final int jumpTableEntryCount;
    private final byte denseRankPower;
    @Nullable
    private final RandomAccessInput jumpTable;
    @Nullable
    private final byte[] denseRankTable;
    private final long cost;
    private int block;
    private long blockEnd;
    private long denseBitmapOffset;
    private int nextBlockIndex;
    @Nullable
    private Method method;
    private int doc;
    private int index;
    private boolean exists;
    private int nextExistDocInBlock;
    private long word;
    private int wordIndex;
    private int numberOfOnes;
    private int denseOrigoIndex;
    private int gap;
    private static final int BLOCK_SIZE = 65536;
    private static final int DENSE_BLOCK_LONGS = 1024;
    public static final byte DEFAULT_DENSE_RANK_POWER = 9;
    public static final int MAX_ARRAY_LENGTH = 4095;

    public IndexedDISI(@NotNull IndexInput blockSlice, @Nullable RandomAccessInput jumpTable, int jumpTableEntryCount, byte denseRankPower, long cost) {
        Intrinsics.checkNotNullParameter((Object)blockSlice, (String)"blockSlice");
        this.block = -1;
        this.denseBitmapOffset = -1L;
        this.nextBlockIndex = -1;
        this.doc = -1;
        this.index = -1;
        this.nextExistDocInBlock = -1;
        this.wordIndex = -1;
        if (!(denseRankPower >= 7 && denseRankPower <= 15 || denseRankPower == -1)) {
            boolean bl = false;
            String string = "Acceptable values for denseRankPower are 7-15 (every 128-32768 docIDs). The provided power was " + denseRankPower + " (every " + (int)Math.pow(2.0, denseRankPower) + " docIDs). ";
            throw new IllegalArgumentException(string.toString());
        }
        this.slice = blockSlice;
        this.jumpTable = jumpTable;
        if (this.slice.length() > 0L) {
            this.slice.prefetch(0L, 1L);
        }
        if (jumpTable != null && jumpTable.length() > 0L) {
            jumpTable.prefetch(0L, 1L);
        }
        this.jumpTableEntryCount = jumpTableEntryCount;
        this.denseRankPower = denseRankPower;
        int rankIndexShift = denseRankPower - 7;
        this.denseRankTable = denseRankPower == -1 ? null : new byte[1024 >> rankIndexShift];
        this.cost = cost;
    }

    @NotNull
    public final IndexInput getSlice() {
        return this.slice;
    }

    public final int getJumpTableEntryCount() {
        return this.jumpTableEntryCount;
    }

    public final byte getDenseRankPower() {
        return this.denseRankPower;
    }

    @Nullable
    public final RandomAccessInput getJumpTable() {
        return this.jumpTable;
    }

    @Nullable
    public final byte[] getDenseRankTable() {
        return this.denseRankTable;
    }

    public final long getCost() {
        return this.cost;
    }

    public IndexedDISI(@NotNull IndexInput in, long offset, long length, int jumpTableEntryCount, byte denseRankPower, long cost) {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        this(Companion.createBlockSlice(in, "docs", offset, length, jumpTableEntryCount), Companion.createJumpTable(in, offset, length, jumpTableEntryCount), jumpTableEntryCount, denseRankPower, cost);
    }

    public final int getBlock() {
        return this.block;
    }

    public final void setBlock(int n) {
        this.block = n;
    }

    public final long getBlockEnd() {
        return this.blockEnd;
    }

    public final void setBlockEnd(long l) {
        this.blockEnd = l;
    }

    public final long getDenseBitmapOffset() {
        return this.denseBitmapOffset;
    }

    public final void setDenseBitmapOffset(long l) {
        this.denseBitmapOffset = l;
    }

    public final int getNextBlockIndex() {
        return this.nextBlockIndex;
    }

    public final void setNextBlockIndex(int n) {
        this.nextBlockIndex = n;
    }

    @Nullable
    public final Method getMethod() {
        return this.method;
    }

    public final void setMethod(@Nullable Method method) {
        this.method = method;
    }

    public final int getDoc() {
        return this.doc;
    }

    public final void setDoc(int n) {
        this.doc = n;
    }

    public final int getIndex() {
        return this.index;
    }

    public final void setIndex(int n) {
        this.index = n;
    }

    public final boolean getExists() {
        return this.exists;
    }

    public final void setExists(boolean bl) {
        this.exists = bl;
    }

    public final int getNextExistDocInBlock() {
        return this.nextExistDocInBlock;
    }

    public final void setNextExistDocInBlock(int n) {
        this.nextExistDocInBlock = n;
    }

    public final long getWord() {
        return this.word;
    }

    public final void setWord(long l) {
        this.word = l;
    }

    public final int getWordIndex() {
        return this.wordIndex;
    }

    public final void setWordIndex(int n) {
        this.wordIndex = n;
    }

    public final int getNumberOfOnes() {
        return this.numberOfOnes;
    }

    public final void setNumberOfOnes(int n) {
        this.numberOfOnes = n;
    }

    public final int getDenseOrigoIndex() {
        return this.denseOrigoIndex;
    }

    public final void setDenseOrigoIndex(int n) {
        this.denseOrigoIndex = n;
    }

    public final int getGap() {
        return this.gap;
    }

    public final void setGap(int n) {
        this.gap = n;
    }

    @Override
    public int docID() {
        return this.doc;
    }

    @Override
    public int advance(int target) throws IOException {
        int targetBlock = target & 0xFFFF0000;
        if (this.block < targetBlock) {
            this.advanceBlock(targetBlock);
        }
        if (this.block == targetBlock) {
            Method method = this.method;
            Intrinsics.checkNotNull((Object)((Object)method));
            if (method.advanceWithinBlock(this, target)) {
                return this.doc;
            }
            this.readBlockHeader();
        }
        Method method = this.method;
        Intrinsics.checkNotNull((Object)((Object)method));
        boolean found = method.advanceWithinBlock(this, this.block);
        if (!found) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return this.doc;
    }

    /*
     * Unable to fully structure code
     */
    public final boolean advanceExact(int target) throws IOException {
        targetBlock = target & -65536;
        if (this.block < targetBlock) {
            this.advanceBlock(targetBlock);
        }
        if (this.block != targetBlock) ** GOTO lbl-1000
        v0 = this.method;
        Intrinsics.checkNotNull((Object)v0);
        if (v0.advanceExactWithinBlock(this, target)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        found = v1;
        this.doc = target;
        return found;
    }

    private final void advanceBlock(int targetBlock) throws IOException {
        int blockIndex = targetBlock >> 16;
        if (this.jumpTable != null && blockIndex >= (this.block >> 16) + 2) {
            int inRangeBlockIndex = blockIndex < this.jumpTableEntryCount ? blockIndex : this.jumpTableEntryCount - 1;
            int index = this.jumpTable.readInt((long)inRangeBlockIndex * 4L * (long)2);
            int offset = this.jumpTable.readInt((long)inRangeBlockIndex * 4L * (long)2 + (long)4);
            this.nextBlockIndex = index - 1;
            this.slice.seek(offset);
            this.readBlockHeader();
            return;
        }
        do {
            this.slice.seek(this.blockEnd);
            this.readBlockHeader();
        } while (this.block < targetBlock);
    }

    private final void readBlockHeader() throws IOException {
        this.block = ShortExtKt.toUnsignedInt(ShortCompanionObject.INSTANCE, this.slice.readShort()) << 16;
        if (!(this.block >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int numValues = 1 + ShortExtKt.toUnsignedInt(ShortCompanionObject.INSTANCE, this.slice.readShort());
        this.index = this.nextBlockIndex;
        this.nextBlockIndex = this.index + numValues;
        if (numValues <= 4095) {
            this.method = Method.SPARSE;
            this.blockEnd = this.slice.getFilePointer() + (long)(numValues << 1);
            this.nextExistDocInBlock = -1;
        } else if (numValues == 65536) {
            this.method = Method.ALL;
            this.blockEnd = this.slice.getFilePointer();
            this.gap = this.block - this.index - 1;
        } else {
            this.method = Method.DENSE;
            this.denseBitmapOffset = this.slice.getFilePointer() + (long)(this.denseRankTable != null ? this.denseRankTable.length : 0);
            this.blockEnd = this.denseBitmapOffset + (long)8192;
            if (this.denseRankPower != -1) {
                Intrinsics.checkNotNull((Object)this.denseRankTable);
                this.slice.readBytes(this.denseRankTable, 0, this.denseRankTable.length);
            }
            this.wordIndex = -1;
            this.denseOrigoIndex = this.numberOfOnes = this.index + 1;
        }
    }

    @Override
    public int nextDoc() throws IOException {
        return this.advance(this.doc + 1);
    }

    public final int index() {
        return this.index;
    }

    @Override
    public long cost() {
        return this.cost;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\bH\u0002J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0012J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\bJ0\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0005H\u0002J \u0010!\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J.\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020\u0005J(\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010%\u001a\u00020$2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020\u0005J\u000e\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/J\u0018\u00100\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020/2\u0006\u00101\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/IndexedDISI$Companion;", "", "<init>", "()V", "BLOCK_SIZE", "", "DENSE_BLOCK_LONGS", "DEFAULT_DENSE_RANK_POWER", "", "MAX_ARRAY_LENGTH", "flush", "", "block", "buffer", "Lorg/gnit/lucenekmp/util/FixedBitSet;", "cardinality", "denseRankPower", "out", "Lorg/gnit/lucenekmp/store/IndexOutput;", "createRank", "", "writeBitSet", "", "it", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "addJumps", "", "jumps", "offset", "", "index", "startBlock", "endBlock", "flushBlockJumps", "blockCount", "createBlockSlice", "Lorg/gnit/lucenekmp/store/IndexInput;", "slice", "sliceDescription", "", "length", "jumpTableEntryCount", "createJumpTable", "Lorg/gnit/lucenekmp/store/RandomAccessInput;", "asDocIndexIterator", "Lorg/gnit/lucenekmp/index/KnnVectorValues$DocIndexIterator;", "disi", "Lorg/gnit/lucenekmp/codecs/lucene90/IndexedDISI;", "rankSkip", "targetInBlock", "core"})
    @SourceDebugExtension(value={"SMAP\nIndexedDISI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexedDISI.kt\norg/gnit/lucenekmp/codecs/lucene90/IndexedDISI$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,771:1\n1#2:772\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final void flush(int block2, FixedBitSet buffer, int cardinality, byte denseRankPower, IndexOutput out) throws IOException {
            block6: {
                block5: {
                    if (!(block2 >= 0 && block2 < 65536)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    out.writeShort((short)block2);
                    if (!(cardinality > 0 && cardinality <= 65536)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    out.writeShort((short)(cardinality - 1));
                    if (cardinality <= 4095) break block5;
                    if (cardinality == 65536) break block6;
                    if (denseRankPower != -1) {
                        byte[] byArray = this.createRank(buffer, denseRankPower);
                        out.writeBytes(byArray, byArray.length);
                    }
                    for (long word : buffer.getBits()) {
                        out.writeLong(word);
                    }
                    break block6;
                }
                BitSetIterator bitSetIterator = new BitSetIterator(buffer, cardinality);
                Companion $this$flush_u24lambda_u240 = this;
                boolean bl = false;
                int doc = bitSetIterator.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    out.writeShort((short)doc);
                    doc = bitSetIterator.nextDoc();
                }
            }
        }

        private final byte[] createRank(FixedBitSet buffer, byte denseRankPower) {
            int longsPerRank = 1 << denseRankPower - 6;
            int rankMark = longsPerRank - 1;
            int rankIndexShift = denseRankPower - 7;
            byte[] rank = new byte[1024 >> rankIndexShift];
            long[] bits = buffer.getBits();
            int bitCount = 0;
            for (int word = 0; word < 1024; ++word) {
                if ((word & rankMark) == 0) {
                    rank[word >> rankIndexShift] = (byte)(bitCount >> 8);
                    rank[(word >> rankIndexShift) + 1] = (byte)(bitCount & 0xFF);
                }
                bitCount += LongExtKt.bitCount(LongCompanionObject.INSTANCE, bits[word]);
            }
            return rank;
        }

        public final short writeBitSet(@NotNull DocIdSetIterator it, @NotNull IndexOutput out) throws IOException {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            return this.writeBitSet(it, out, (byte)9);
        }

        public final short writeBitSet(@NotNull DocIdSetIterator it, @NotNull IndexOutput out, byte denseRankPower) throws IOException {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            long origo = out.getFilePointer();
            if (!(denseRankPower >= 7 && denseRankPower <= 15 || denseRankPower == -1)) {
                boolean $i$a$-require-IndexedDISI$Companion$writeBitSet$22 = false;
                String $i$a$-require-IndexedDISI$Companion$writeBitSet$22 = "Acceptable values for denseRankPower are 7-15 (every 128-32768 docIDs). The provided power was " + denseRankPower + " (every " + (int)Math.pow(2.0, denseRankPower) + " docIDs)";
                throw new IllegalArgumentException($i$a$-require-IndexedDISI$Companion$writeBitSet$22.toString());
            }
            int totalCardinality = 0;
            int blockCardinality = 0;
            FixedBitSet buffer = new FixedBitSet(65536);
            int[] jumps = null;
            jumps = new int[ArrayUtil.Companion.oversize(1, 8)];
            int prevBlock = 0;
            prevBlock = -1;
            int jumpBlockIndex = 0;
            Companion $this$writeBitSet_u24lambda_u242 = this;
            boolean bl = false;
            int doc = it.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                int block2 = doc >>> 16;
                if (prevBlock != -1 && block2 != prevBlock) {
                    jumps = $this$writeBitSet_u24lambda_u242.addJumps(jumps, out.getFilePointer() - origo, totalCardinality, jumpBlockIndex, prevBlock + 1);
                    jumpBlockIndex = prevBlock + 1;
                    $this$writeBitSet_u24lambda_u242.flush(prevBlock, buffer, blockCardinality, denseRankPower, out);
                    buffer.clear();
                    totalCardinality += blockCardinality;
                    blockCardinality = 0;
                }
                buffer.set(doc & 0xFFFF);
                ++blockCardinality;
                prevBlock = block2;
                doc = it.nextDoc();
            }
            if (blockCardinality > 0) {
                jumps = this.addJumps(jumps, out.getFilePointer() - origo, totalCardinality, jumpBlockIndex, prevBlock + 1);
                totalCardinality += blockCardinality;
                this.flush(prevBlock, buffer, blockCardinality, denseRankPower, out);
                buffer.clear();
                int n = prevBlock;
                prevBlock = n + 1;
            }
            int lastBlock = prevBlock == -1 ? 0 : prevBlock;
            jumps = this.addJumps(jumps, out.getFilePointer() - origo, totalCardinality, lastBlock, lastBlock + 1);
            buffer.set(65535);
            this.flush(Short.MAX_VALUE, buffer, 1, denseRankPower, out);
            return this.flushBlockJumps(jumps, lastBlock + 1, out);
        }

        private final int[] addJumps(int[] jumps, long offset, int index, int startBlock, int endBlock) {
            int[] jumps2 = jumps;
            if (!(offset < Integer.MAX_VALUE)) {
                boolean bl = false;
                String string = "Logically the offset should not exceed 2^30 but was >= Integer.MAX_VALUE";
                throw new IllegalArgumentException(string.toString());
            }
            jumps2 = ArrayUtil.Companion.grow(jumps2, (endBlock + 1) * 2);
            for (int b = startBlock; b < endBlock; ++b) {
                jumps2[b * 2] = index;
                jumps2[b * 2 + 1] = (int)offset;
            }
            return jumps2;
        }

        private final short flushBlockJumps(int[] jumps, int blockCount, IndexOutput out) throws IOException {
            int blockCount2 = blockCount;
            if (blockCount2 == 2) {
                blockCount2 = 0;
            }
            int n = blockCount2;
            for (int i = 0; i < n; ++i) {
                out.writeInt(jumps[i * 2]);
                out.writeInt(jumps[i * 2 + 1]);
            }
            return (short)blockCount2;
        }

        @NotNull
        public final IndexInput createBlockSlice(@NotNull IndexInput slice, @NotNull String sliceDescription, long offset, long length, int jumpTableEntryCount) throws IOException {
            Intrinsics.checkNotNullParameter((Object)slice, (String)"slice");
            Intrinsics.checkNotNullParameter((Object)sliceDescription, (String)"sliceDescription");
            long jumpTableBytes = jumpTableEntryCount < 0 ? 0 : jumpTableEntryCount * 4 * 2;
            return slice.slice(sliceDescription, offset, length - jumpTableBytes);
        }

        @Nullable
        public final RandomAccessInput createJumpTable(@NotNull IndexInput slice, long offset, long length, int jumpTableEntryCount) throws IOException {
            Intrinsics.checkNotNullParameter((Object)slice, (String)"slice");
            if (jumpTableEntryCount <= 0) {
                return null;
            }
            int jumpTableBytes = jumpTableEntryCount * 4 * 2;
            return slice.randomAccessSlice(offset + length - (long)jumpTableBytes, jumpTableBytes);
        }

        @NotNull
        public final KnnVectorValues.DocIndexIterator asDocIndexIterator(@NotNull IndexedDISI disi) {
            Intrinsics.checkNotNullParameter((Object)disi, (String)"disi");
            return new KnnVectorValues.DocIndexIterator(disi){
                final /* synthetic */ IndexedDISI $disi;
                {
                    this.$disi = $disi;
                }

                public int docID() {
                    return this.$disi.docID();
                }

                public int index() {
                    return this.$disi.index();
                }

                public int nextDoc() throws IOException {
                    return this.$disi.nextDoc();
                }

                public int advance(int target) throws IOException {
                    return this.$disi.advance(target);
                }

                public long cost() {
                    return this.$disi.cost();
                }
            };
        }

        private final void rankSkip(IndexedDISI disi, int targetInBlock) throws IOException {
            if (!(disi.getDenseRankPower() >= 0)) {
                boolean $i$a$-require-IndexedDISI$Companion$rankSkip$22 = false;
                Byte $i$a$-require-IndexedDISI$Companion$rankSkip$22 = disi.getDenseRankPower();
                throw new IllegalArgumentException(((Object)$i$a$-require-IndexedDISI$Companion$rankSkip$22).toString());
            }
            int rankIndex = targetInBlock >> disi.getDenseRankPower();
            byte[] byArray = disi.getDenseRankTable();
            Intrinsics.checkNotNull((Object)byArray);
            int rank = (byArray[rankIndex << 1] & 0xFF) << 8 | disi.getDenseRankTable()[(rankIndex << 1) + 1] & 0xFF;
            int rankAlignedWordIndex = rankIndex << disi.getDenseRankPower() >> 6;
            disi.getSlice().seek(disi.getDenseBitmapOffset() + (long)rankAlignedWordIndex * 8L);
            long rankWord = disi.getSlice().readLong();
            int denseNOO = rank + LongExtKt.bitCount(LongCompanionObject.INSTANCE, rankWord);
            disi.setWordIndex(rankAlignedWordIndex);
            disi.setWord(rankWord);
            disi.setNumberOfOnes(disi.getDenseOrigoIndex() + denseNOO);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH&J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH&j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/IndexedDISI$Method;", "", "<init>", "(Ljava/lang/String;I)V", "SPARSE", "DENSE", "ALL", "advanceWithinBlock", "", "disi", "Lorg/gnit/lucenekmp/codecs/lucene90/IndexedDISI;", "target", "", "advanceExactWithinBlock", "core"})
    public static final abstract class Method
    extends Enum<Method> {
        public static final /* enum */ Method SPARSE = new SPARSE("SPARSE", 0);
        public static final /* enum */ Method DENSE = new DENSE("DENSE", 1);
        public static final /* enum */ Method ALL = new ALL("ALL", 2);
        private static final /* synthetic */ Method[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Method() {
        }

        public abstract boolean advanceWithinBlock(@NotNull IndexedDISI var1, int var2) throws IOException;

        public abstract boolean advanceExactWithinBlock(@NotNull IndexedDISI var1, int var2) throws IOException;

        public static Method[] values() {
            return (Method[])$VALUES.clone();
        }

        public static Method valueOf(String value) {
            return Enum.valueOf(Method.class, value);
        }

        @NotNull
        public static EnumEntries<Method> getEntries() {
            return $ENTRIES;
        }

        public /* synthetic */ Method(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            $VALUES = methodArray = new Method[]{Method.SPARSE, Method.DENSE, Method.ALL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"org/gnit/lucenekmp/codecs/lucene90/IndexedDISI.Method.ALL", "Lorg/gnit/lucenekmp/codecs/lucene90/IndexedDISI$Method;", "advanceWithinBlock", "", "disi", "Lorg/gnit/lucenekmp/codecs/lucene90/IndexedDISI;", "target", "", "advanceExactWithinBlock", "core"})
        static final class ALL
        extends Method {
            /*
             * WARNING - void declaration
             */
            ALL() {
                void var1_1;
            }

            @Override
            public boolean advanceWithinBlock(@NotNull IndexedDISI disi, int target) {
                Intrinsics.checkNotNullParameter((Object)disi, (String)"disi");
                disi.setDoc(target);
                disi.setIndex(target - disi.getGap());
                return true;
            }

            @Override
            public boolean advanceExactWithinBlock(@NotNull IndexedDISI disi, int target) {
                Intrinsics.checkNotNullParameter((Object)disi, (String)"disi");
                disi.setIndex(target - disi.getGap());
                return true;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"org/gnit/lucenekmp/codecs/lucene90/IndexedDISI.Method.DENSE", "Lorg/gnit/lucenekmp/codecs/lucene90/IndexedDISI$Method;", "advanceWithinBlock", "", "disi", "Lorg/gnit/lucenekmp/codecs/lucene90/IndexedDISI;", "target", "", "advanceExactWithinBlock", "core"})
        static final class DENSE
        extends Method {
            /*
             * WARNING - void declaration
             */
            DENSE() {
                void var1_1;
            }

            @Override
            public boolean advanceWithinBlock(@NotNull IndexedDISI disi, int target) throws IOException {
                block5: {
                    int i;
                    Intrinsics.checkNotNullParameter((Object)disi, (String)"disi");
                    int targetInBlock = target & 0xFFFF;
                    int targetWordIndex = targetInBlock >>> 6;
                    if (disi.getDenseRankPower() != -1 && targetWordIndex - disi.getWordIndex() >= 1 << disi.getDenseRankPower() - 6) {
                        Companion.rankSkip(disi, targetInBlock);
                    }
                    if ((i = disi.getWordIndex() + 1) <= targetWordIndex) {
                        while (true) {
                            disi.setWord(disi.getSlice().readLong());
                            disi.setNumberOfOnes(disi.getNumberOfOnes() + LongExtKt.bitCount(LongCompanionObject.INSTANCE, disi.getWord()));
                            if (i == targetWordIndex) break;
                            ++i;
                        }
                    }
                    disi.setWordIndex(targetWordIndex);
                    long leftBits = disi.getWord() >>> target;
                    if (leftBits != 0L) {
                        disi.setDoc(target + LongExtKt.numberOfTrailingZeros(LongCompanionObject.INSTANCE, leftBits));
                        disi.setIndex(disi.getNumberOfOnes() - LongExtKt.bitCount(LongCompanionObject.INSTANCE, leftBits));
                        return true;
                    }
                    do {
                        disi.setWordIndex(disi.getWordIndex() + 1);
                        if (disi.getWordIndex() >= 1024) break block5;
                        disi.setWord(disi.getSlice().readLong());
                    } while (disi.getWord() == 0L);
                    disi.setIndex(disi.getNumberOfOnes());
                    disi.setNumberOfOnes(disi.getNumberOfOnes() + LongExtKt.bitCount(LongCompanionObject.INSTANCE, disi.getWord()));
                    disi.setDoc(disi.getBlock() | disi.getWordIndex() << 6 | LongExtKt.numberOfTrailingZeros(LongCompanionObject.INSTANCE, disi.getWord()));
                    return true;
                }
                return false;
            }

            @Override
            public boolean advanceExactWithinBlock(@NotNull IndexedDISI disi, int target) throws IOException {
                int i;
                Intrinsics.checkNotNullParameter((Object)disi, (String)"disi");
                int targetInBlock = target & 0xFFFF;
                int targetWordIndex = targetInBlock >>> 6;
                if (disi.getDenseRankPower() != -1 && targetWordIndex - disi.getWordIndex() >= 1 << disi.getDenseRankPower() - 6) {
                    Companion.rankSkip(disi, targetInBlock);
                }
                if ((i = disi.getWordIndex() + 1) <= targetWordIndex) {
                    while (true) {
                        disi.setWord(disi.getSlice().readLong());
                        disi.setNumberOfOnes(disi.getNumberOfOnes() + LongExtKt.bitCount(LongCompanionObject.INSTANCE, disi.getWord()));
                        if (i == targetWordIndex) break;
                        ++i;
                    }
                }
                disi.setWordIndex(targetWordIndex);
                long leftBits = disi.getWord() >>> target;
                disi.setIndex(disi.getNumberOfOnes() - LongExtKt.bitCount(LongCompanionObject.INSTANCE, leftBits));
                return (leftBits & 1L) != 0L;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"org/gnit/lucenekmp/codecs/lucene90/IndexedDISI.Method.SPARSE", "Lorg/gnit/lucenekmp/codecs/lucene90/IndexedDISI$Method;", "advanceWithinBlock", "", "disi", "Lorg/gnit/lucenekmp/codecs/lucene90/IndexedDISI;", "target", "", "advanceExactWithinBlock", "core"})
        static final class SPARSE
        extends Method {
            /*
             * WARNING - void declaration
             */
            SPARSE() {
                void var1_1;
            }

            @Override
            public boolean advanceWithinBlock(@NotNull IndexedDISI disi, int target) throws IOException {
                Intrinsics.checkNotNullParameter((Object)disi, (String)"disi");
                int targetInBlock = target & 0xFFFF;
                while (disi.getIndex() < disi.getNextBlockIndex()) {
                    int doc = ShortExtKt.toUnsignedInt(ShortCompanionObject.INSTANCE, disi.getSlice().readShort());
                    int n = disi.getIndex();
                    disi.setIndex(n + 1);
                    if (doc < targetInBlock) continue;
                    disi.setDoc(disi.getBlock() | doc);
                    disi.setExists(true);
                    disi.setNextExistDocInBlock(doc);
                    return true;
                }
                return false;
            }

            @Override
            public boolean advanceExactWithinBlock(@NotNull IndexedDISI disi, int target) throws IOException {
                Intrinsics.checkNotNullParameter((Object)disi, (String)"disi");
                int targetInBlock = target & 0xFFFF;
                if (disi.getNextExistDocInBlock() > targetInBlock) {
                    if (!(!disi.getExists())) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    return false;
                }
                if (target == disi.getDoc()) {
                    return disi.getExists();
                }
                while (disi.getIndex() < disi.getNextBlockIndex()) {
                    int doc = ShortExtKt.toUnsignedInt(ShortCompanionObject.INSTANCE, disi.getSlice().readShort());
                    int n = disi.getIndex();
                    disi.setIndex(n + 1);
                    if (doc < targetInBlock) continue;
                    disi.setNextExistDocInBlock(doc);
                    if (doc != targetInBlock) {
                        n = disi.getIndex();
                        disi.setIndex(n + -1);
                        disi.getSlice().seek(disi.getSlice().getFilePointer() - (long)2);
                        break;
                    }
                    disi.setExists(true);
                    return true;
                }
                disi.setExists(false);
                return false;
            }
        }
    }
}

