/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs.lucene90;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.codecs.compressing.CompressionMode;
import org.gnit.lucenekmp.codecs.compressing.Compressor;
import org.gnit.lucenekmp.codecs.compressing.Decompressor;
import org.gnit.lucenekmp.index.CorruptIndexException;
import org.gnit.lucenekmp.jdkport.Math;
import org.gnit.lucenekmp.jdkport.System;
import org.gnit.lucenekmp.store.ByteBuffersDataInput;
import org.gnit.lucenekmp.store.ByteBuffersDataOutput;
import org.gnit.lucenekmp.store.DataInput;
import org.gnit.lucenekmp.store.DataOutput;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.compress.LZ4;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \f2\u00020\u0001:\u0003\n\u000b\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\r"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/LZ4WithPresetDictCompressionMode;", "Lorg/gnit/lucenekmp/codecs/compressing/CompressionMode;", "<init>", "()V", "newCompressor", "Lorg/gnit/lucenekmp/codecs/compressing/Compressor;", "newDecompressor", "Lorg/gnit/lucenekmp/codecs/compressing/Decompressor;", "toString", "", "LZ4WithPresetDictDecompressor", "LZ4WithPresetDictCompressor", "Companion", "core"})
public final class LZ4WithPresetDictCompressionMode
extends CompressionMode {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int NUM_SUB_BLOCKS = 10;
    private static final int DICT_SIZE_FACTOR = 2;

    @Override
    @NotNull
    public Compressor newCompressor() {
        return new LZ4WithPresetDictCompressor();
    }

    @Override
    @NotNull
    public Decompressor newDecompressor() {
        return new LZ4WithPresetDictDecompressor();
    }

    @NotNull
    public String toString() {
        return "BEST_SPEED";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/LZ4WithPresetDictCompressionMode$Companion;", "", "<init>", "()V", "NUM_SUB_BLOCKS", "", "DICT_SIZE_FACTOR", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019J\u0018\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001d\u001a\u00020\u0013H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/LZ4WithPresetDictCompressionMode$LZ4WithPresetDictCompressor;", "Lorg/gnit/lucenekmp/codecs/compressing/Compressor;", "<init>", "()V", "compressed", "Lorg/gnit/lucenekmp/store/ByteBuffersDataOutput;", "getCompressed", "()Lorg/gnit/lucenekmp/store/ByteBuffersDataOutput;", "hashTable", "Lorg/gnit/lucenekmp/util/compress/LZ4$FastCompressionHashTable;", "getHashTable", "()Lorg/gnit/lucenekmp/util/compress/LZ4$FastCompressionHashTable;", "buffer", "", "getBuffer", "()[B", "setBuffer", "([B)V", "doCompress", "", "bytes", "dictLen", "", "len", "out", "Lorg/gnit/lucenekmp/store/DataOutput;", "compress", "buffersInput", "Lorg/gnit/lucenekmp/store/ByteBuffersDataInput;", "close", "core"})
    private static final class LZ4WithPresetDictCompressor
    extends Compressor {
        @NotNull
        private final ByteBuffersDataOutput compressed = ByteBuffersDataOutput.Companion.newResettableInstance();
        @NotNull
        private final LZ4.FastCompressionHashTable hashTable = new LZ4.FastCompressionHashTable();
        @NotNull
        private byte[] buffer = BytesRef.Companion.getEMPTY_BYTES();

        @NotNull
        public final ByteBuffersDataOutput getCompressed() {
            return this.compressed;
        }

        @NotNull
        public final LZ4.FastCompressionHashTable getHashTable() {
            return this.hashTable;
        }

        @NotNull
        public final byte[] getBuffer() {
            return this.buffer;
        }

        public final void setBuffer(@NotNull byte[] byArray) {
            Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
            this.buffer = byArray;
        }

        public final void doCompress(@NotNull byte[] bytes, int dictLen, int len, @NotNull DataOutput out) throws IOException {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            long prevCompressedSize = this.compressed.size();
            LZ4.INSTANCE.compressWithDictionary(bytes, 0, dictLen, len, this.compressed, this.hashTable);
            out.writeVInt(Math.INSTANCE.toIntExact(this.compressed.size() - prevCompressedSize));
        }

        @Override
        public void compress(@NotNull ByteBuffersDataInput buffersInput, @NotNull DataOutput out) throws IOException {
            Intrinsics.checkNotNullParameter((Object)buffersInput, (String)"buffersInput");
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            int len = (int)(buffersInput.length() - buffersInput.position());
            int dictLength = java.lang.Math.min(65536, len / 20);
            int blockLength = (len - dictLength + 10 - 1) / 10;
            this.buffer = ArrayUtil.Companion.growNoCopy(this.buffer, dictLength + blockLength);
            out.writeVInt(dictLength);
            out.writeVInt(blockLength);
            this.compressed.reset();
            buffersInput.readBytes(this.buffer, 0, dictLength);
            this.doCompress(this.buffer, 0, dictLength, out);
            for (int start = dictLength; start < len; start += blockLength) {
                int l = java.lang.Math.min(blockLength, len - start);
                buffersInput.readBytes(this.buffer, dictLength, l);
                this.doCompress(this.buffer, dictLength, l, out);
            }
            this.compressed.copyTo(out);
        }

        @Override
        public void close() throws IOException {
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tJ0\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0001H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/LZ4WithPresetDictCompressionMode$LZ4WithPresetDictDecompressor;", "Lorg/gnit/lucenekmp/codecs/compressing/Decompressor;", "<init>", "()V", "compressedLengths", "", "buffer", "", "readCompressedLengths", "", "in", "Lorg/gnit/lucenekmp/store/DataInput;", "originalLength", "dictLength", "blockLength", "decompress", "", "offset", "length", "bytes", "Lorg/gnit/lucenekmp/util/BytesRef;", "clone", "core"})
    private static final class LZ4WithPresetDictDecompressor
    extends Decompressor {
        @NotNull
        private int[] compressedLengths = new int[0];
        @NotNull
        private byte[] buffer = new byte[0];

        public final int readCompressedLengths(@NotNull DataInput in, int originalLength, int dictLength, int blockLength) throws IOException {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            in.readVInt();
            int i = 0;
            this.compressedLengths = ArrayUtil.Companion.growNoCopy(this.compressedLengths, originalLength / blockLength + 1);
            for (int totalLength = dictLength; totalLength < originalLength; totalLength += blockLength) {
                this.compressedLengths[i++] = in.readVInt();
            }
            return i;
        }

        @Override
        public void decompress(@NotNull DataInput in, int originalLength, int offset, int length, @NotNull BytesRef bytes) throws IOException {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            if (!(offset + length <= originalLength)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (length == 0) {
                bytes.setLength(0);
                return;
            }
            int dictLength = in.readVInt();
            int blockLength = in.readVInt();
            int numBlocks = this.readCompressedLengths(in, originalLength, dictLength, blockLength);
            this.buffer = ArrayUtil.Companion.growNoCopy(this.buffer, dictLength + blockLength);
            bytes.setLength(0);
            if (LZ4.INSTANCE.decompress(in, dictLength, this.buffer, 0) != dictLength) {
                throw new CorruptIndexException("Illegal dict length", in);
            }
            int offsetInBlock = dictLength;
            int offsetInBytesRef = offset;
            if (offset >= dictLength) {
                offsetInBytesRef -= dictLength;
                int numBytesToSkip = 0;
                for (int i = 0; i < numBlocks && offsetInBlock + blockLength < offset; ++i) {
                    int compressedBlockLength = this.compressedLengths[i];
                    numBytesToSkip += compressedBlockLength;
                    offsetInBlock += blockLength;
                    offsetInBytesRef -= blockLength;
                }
                in.skipBytes(numBytesToSkip);
            } else {
                bytes.setBytes(ArrayUtil.Companion.growNoCopy(bytes.getBytes(), dictLength));
                System.INSTANCE.arraycopy(this.buffer, 0, bytes.getBytes(), 0, dictLength);
                bytes.setLength(dictLength);
            }
            if (offsetInBlock < offset + length) {
                bytes.setBytes(ArrayUtil.Companion.grow(bytes.getBytes(), bytes.getLength() + offset + length - offsetInBlock));
            }
            while (offsetInBlock < offset + length) {
                int bytesToDecompress = java.lang.Math.min(blockLength, offset + length - offsetInBlock);
                LZ4.INSTANCE.decompress(in, bytesToDecompress, this.buffer, dictLength);
                System.INSTANCE.arraycopy(this.buffer, dictLength, bytes.getBytes(), bytes.getLength(), bytesToDecompress);
                bytes.setLength(bytes.getLength() + bytesToDecompress);
                offsetInBlock += blockLength;
            }
            bytes.setOffset(offsetInBytesRef);
            bytes.setLength(length);
            if (!bytes.isValid()) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
        }

        @Override
        @NotNull
        public Decompressor clone() {
            return new LZ4WithPresetDictDecompressor();
        }
    }
}

