/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs.lucene90;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.codecs.CodecUtil;
import org.gnit.lucenekmp.codecs.CompoundDirectory;
import org.gnit.lucenekmp.codecs.CompoundFormat;
import org.gnit.lucenekmp.codecs.lucene90.Lucene90CompoundReader;
import org.gnit.lucenekmp.index.IndexFileNames;
import org.gnit.lucenekmp.index.SegmentInfo;
import org.gnit.lucenekmp.store.ChecksumIndexInput;
import org.gnit.lucenekmp.store.Directory;
import org.gnit.lucenekmp.store.IOContext;
import org.gnit.lucenekmp.store.IndexOutput;
import org.gnit.lucenekmp.util.PriorityQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00142\u00020\u0001:\u0003\u0012\u0013\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016J(\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0015"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90CompoundFormat;", "Lorg/gnit/lucenekmp/codecs/CompoundFormat;", "<init>", "()V", "getCompoundReader", "Lorg/gnit/lucenekmp/codecs/CompoundDirectory;", "dir", "Lorg/gnit/lucenekmp/store/Directory;", "si", "Lorg/gnit/lucenekmp/index/SegmentInfo;", "write", "", "context", "Lorg/gnit/lucenekmp/store/IOContext;", "writeCompoundFile", "entries", "Lorg/gnit/lucenekmp/store/IndexOutput;", "data", "SizedFile", "SizedFileQueue", "Companion", "core"})
public final class Lucene90CompoundFormat
extends CompoundFormat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String DATA_EXTENSION = "cfs";
    @NotNull
    public static final String ENTRIES_EXTENSION = "cfe";
    @NotNull
    public static final String DATA_CODEC = "Lucene90CompoundData";
    @NotNull
    public static final String ENTRY_CODEC = "Lucene90CompoundEntries";
    public static final int VERSION_START = 0;
    public static final int VERSION_CURRENT = 0;

    @Override
    @NotNull
    public CompoundDirectory getCompoundReader(@NotNull Directory dir, @NotNull SegmentInfo si) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)si, (String)"si");
        return new Lucene90CompoundReader(dir, si);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(@NotNull Directory dir, @NotNull SegmentInfo si, @NotNull IOContext context) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)si, (String)"si");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String dataFile = IndexFileNames.INSTANCE.segmentFileName(si.getName(), "", DATA_EXTENSION);
        String entriesFile = IndexFileNames.INSTANCE.segmentFileName(si.getName(), "", ENTRIES_EXTENSION);
        AutoCloseable autoCloseable = dir.createOutput(dataFile, context);
        Throwable throwable = null;
        try {
            IndexOutput data = (IndexOutput)autoCloseable;
            boolean bl = false;
            AutoCloseable autoCloseable2 = dir.createOutput(entriesFile, context);
            Throwable throwable2 = null;
            try {
                IndexOutput entries2 = (IndexOutput)autoCloseable2;
                boolean bl2 = false;
                CodecUtil.INSTANCE.writeIndexHeader(data, DATA_CODEC, 0, si.getId(), "");
                CodecUtil.INSTANCE.writeIndexHeader(entries2, ENTRY_CODEC, 0, si.getId(), "");
                this.writeCompoundFile(entries2, data, dir, si);
                CodecUtil.INSTANCE.writeFooter(data);
                CodecUtil.INSTANCE.writeFooter(entries2);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeCompoundFile(IndexOutput entries2, IndexOutput data, Directory dir, SegmentInfo si) throws IOException {
        int numFiles = si.files().size();
        entries2.writeVInt(numFiles);
        SizedFileQueue pq2 = new SizedFileQueue(numFiles);
        for (String filename : si.files()) {
            pq2.add(new SizedFile(filename, dir.fileLength(filename)));
        }
        while (pq2.size() > 0) {
            Object t = pq2.pop();
            Intrinsics.checkNotNull(t);
            SizedFile sizedFile = (SizedFile)t;
            String file = sizedFile.getName();
            long startOffset = data.alignFilePointer(8);
            AutoCloseable autoCloseable = dir.openChecksumInput(file);
            Throwable throwable = null;
            try {
                ChecksumIndexInput in = (ChecksumIndexInput)autoCloseable;
                boolean bl = false;
                CodecUtil.INSTANCE.verifyAndCopyIndexHeader(in, data, si.getId());
                long numBytesToCopy = in.length() - (long)CodecUtil.INSTANCE.footerLength() - in.getFilePointer();
                data.copyBytes(in, numBytesToCopy);
                long checksum = CodecUtil.INSTANCE.checkFooter(in);
                CodecUtil.INSTANCE.writeBEInt(data, -1071082520);
                CodecUtil.INSTANCE.writeBEInt(data, 0);
                CodecUtil.INSTANCE.writeBELong(data, checksum);
                in = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            long endOffset = data.getFilePointer();
            long length = endOffset - startOffset;
            entries2.writeString(IndexFileNames.INSTANCE.stripSegmentName(file));
            entries2.writeLong(startOffset);
            entries2.writeLong(length);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90CompoundFormat$Companion;", "", "<init>", "()V", "DATA_EXTENSION", "", "ENTRIES_EXTENSION", "DATA_CODEC", "ENTRY_CODEC", "VERSION_START", "", "VERSION_CURRENT", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90CompoundFormat$SizedFile;", "", "name", "", "length", "", "<init>", "(Ljava/lang/String;J)V", "getName", "()Ljava/lang/String;", "getLength", "()J", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "core"})
    private static final class SizedFile {
        @NotNull
        private final String name;
        private final long length;

        public SizedFile(@NotNull String name, long length) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.length = length;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final long getLength() {
            return this.length;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        public final long component2() {
            return this.length;
        }

        @NotNull
        public final SizedFile copy(@NotNull String name, long length) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new SizedFile(name, length);
        }

        public static /* synthetic */ SizedFile copy$default(SizedFile sizedFile, String string, long l, int n, Object object) {
            if ((n & 1) != 0) {
                string = sizedFile.name;
            }
            if ((n & 2) != 0) {
                l = sizedFile.length;
            }
            return sizedFile.copy(string, l);
        }

        @NotNull
        public String toString() {
            return "SizedFile(name=" + this.name + ", length=" + this.length + ")";
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + Long.hashCode(this.length);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SizedFile)) {
                return false;
            }
            SizedFile sizedFile = (SizedFile)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)sizedFile.name)) {
                return false;
            }
            return this.length == sizedFile.length;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90CompoundFormat$SizedFileQueue;", "Lorg/gnit/lucenekmp/util/PriorityQueue;", "Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90CompoundFormat$SizedFile;", "maxSize", "", "<init>", "(I)V", "lessThan", "", "sf1", "sf2", "core"})
    private static final class SizedFileQueue
    extends PriorityQueue<SizedFile> {
        public SizedFileQueue(int maxSize) {
            super(maxSize, null, 2, null);
        }

        @Override
        public boolean lessThan(@NotNull SizedFile sf1, @NotNull SizedFile sf2) {
            Intrinsics.checkNotNullParameter((Object)sf1, (String)"sf1");
            Intrinsics.checkNotNullParameter((Object)sf2, (String)"sf2");
            return sf1.getLength() < sf2.getLength();
        }
    }
}

