/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs.lucene90;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.codecs.CodecUtil;
import org.gnit.lucenekmp.codecs.CompoundDirectory;
import org.gnit.lucenekmp.index.CorruptIndexException;
import org.gnit.lucenekmp.index.IndexFileNames;
import org.gnit.lucenekmp.index.SegmentInfo;
import org.gnit.lucenekmp.store.ChecksumIndexInput;
import org.gnit.lucenekmp.store.Directory;
import org.gnit.lucenekmp.store.IOContext;
import org.gnit.lucenekmp.store.IndexInput;
import org.gnit.lucenekmp.store.ReadAdvice;
import org.gnit.lucenekmp.util.CollectionUtil;
import org.gnit.lucenekmp.util.IOUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0001)B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J,\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\tH\u0002J\u001c\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0017\u001a\u00020\u000eH\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0013\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\t0\u001fH\u0016\u00a2\u0006\u0002\u0010 J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u001b\u001a\u00020\tH\u0016J\b\u0010#\u001a\u00020\tH\u0016J\b\u0010(\u001a\u00020\u0019H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020\t0%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u0006*"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90CompoundReader;", "Lorg/gnit/lucenekmp/codecs/CompoundDirectory;", "directory", "Lorg/gnit/lucenekmp/store/Directory;", "si", "Lorg/gnit/lucenekmp/index/SegmentInfo;", "<init>", "(Lorg/gnit/lucenekmp/store/Directory;Lorg/gnit/lucenekmp/index/SegmentInfo;)V", "segmentName", "", "entries", "", "Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90CompoundReader$FileEntry;", "handle", "Lorg/gnit/lucenekmp/store/IndexInput;", "version", "", "readEntries", "segmentID", "", "dir", "entriesFileName", "readMapping", "entriesStream", "close", "", "openInput", "name", "context", "Lorg/gnit/lucenekmp/store/IOContext;", "listAll", "", "()[Ljava/lang/String;", "fileLength", "", "toString", "pendingDeletions", "", "getPendingDeletions", "()Ljava/util/Set;", "checkIntegrity", "FileEntry", "core"})
@SourceDebugExtension(value={"SMAP\nLucene90CompoundReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Lucene90CompoundReader.kt\norg/gnit/lucenekmp/codecs/lucene90/Lucene90CompoundReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,191:1\n1#2:192\n37#3:193\n36#3,3:194\n*S KotlinDebug\n*F\n+ 1 Lucene90CompoundReader.kt\norg/gnit/lucenekmp/codecs/lucene90/Lucene90CompoundReader\n*L\n157#1:193\n157#1:194,3\n*E\n"})
public final class Lucene90CompoundReader
extends CompoundDirectory {
    @NotNull
    private final Directory directory;
    @NotNull
    private final String segmentName;
    @NotNull
    private final Map<String, FileEntry> entries;
    @NotNull
    private final IndexInput handle;
    private int version;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lucene90CompoundReader(@NotNull Directory directory, @NotNull SegmentInfo si) {
        Number number;
        Comparable comparable;
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)si, (String)"si");
        this.directory = directory;
        this.segmentName = si.getName();
        String dataFileName = IndexFileNames.INSTANCE.segmentFileName(this.segmentName, "", "cfs");
        String entriesFileName = IndexFileNames.INSTANCE.segmentFileName(this.segmentName, "", "cfe");
        this.entries = this.readEntries(si.getId(), this.directory, entriesFileName);
        boolean success = false;
        Iterator iterator2 = ((Iterable)this.entries.values()).iterator();
        if (!iterator2.hasNext()) {
            comparable = null;
        } else {
            FileEntry e = (FileEntry)iterator2.next();
            boolean bl = false;
            Comparable comparable2 = Long.valueOf(e.getOffset() + e.getLength());
            while (iterator2.hasNext()) {
                FileEntry e2 = (FileEntry)iterator2.next();
                $i$a$-maxOfOrNull-Lucene90CompoundReader$expectedLength$1 = false;
                Comparable comparable3 = Long.valueOf(e2.getOffset() + e2.getLength());
                if (comparable2.compareTo(comparable3) >= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        if ((number = (Long)comparable) == null) {
            number = CodecUtil.INSTANCE.indexHeaderLength("Lucene90CompoundData", "");
        }
        long expectedLength = ((Number)number).longValue() + (long)CodecUtil.INSTANCE.footerLength();
        this.handle = this.directory.openInput(dataFileName, IOContext.Companion.getDEFAULT().withReadAdvice(ReadAdvice.NORMAL));
        try {
            CodecUtil.INSTANCE.checkIndexHeader(this.handle, "Lucene90CompoundData", this.version, this.version, si.getId(), "");
            CodecUtil.INSTANCE.retrieveChecksum(this.handle);
            if (this.handle.length() != expectedLength) {
                throw new CorruptIndexException("length should be " + expectedLength + " bytes, but is " + this.handle.length() + " instead", this.handle);
            }
            success = true;
        }
        catch (Throwable throwable) {
            AutoCloseable[] autoCloseableArray = new AutoCloseable[]{this.handle};
            IOUtils.INSTANCE.closeWhileHandlingException(autoCloseableArray);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<String, FileEntry> readEntries(byte[] segmentID, Directory dir, String entriesFileName) throws IOException {
        Map<String, FileEntry> mapping = null;
        AutoCloseable autoCloseable = dir.openChecksumInput(entriesFileName);
        Throwable throwable = null;
        try {
            ChecksumIndexInput entriesStream = (ChecksumIndexInput)autoCloseable;
            boolean bl = false;
            Throwable priorE = null;
            try {
                this.version = CodecUtil.INSTANCE.checkIndexHeader(entriesStream, "Lucene90CompoundEntries", 0, 0, segmentID, "");
                mapping = this.readMapping(entriesStream);
            }
            catch (Throwable exception) {
                priorE = exception;
            }
            finally {
                CodecUtil.INSTANCE.checkFooter(entriesStream, priorE);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        Map<String, FileEntry> map2 = mapping;
        Intrinsics.checkNotNull(map2);
        return map2;
    }

    private final Map<String, FileEntry> readMapping(IndexInput entriesStream) throws IOException {
        int numEntries = entriesStream.readVInt();
        Map<String, FileEntry> mapping = CollectionUtil.INSTANCE.newHashMap(numEntries);
        for (int i = 0; i < numEntries; ++i) {
            FileEntry fileEntry = new FileEntry();
            String id = entriesStream.readString();
            FileEntry previous = mapping.put(id, fileEntry);
            if (previous != null) {
                throw new CorruptIndexException("Duplicate cfs entry id=" + id + " in CFS ", entriesStream);
            }
            fileEntry.setOffset(entriesStream.readLong());
            fileEntry.setLength(entriesStream.readLong());
        }
        return mapping;
    }

    @Override
    public void close() throws IOException {
        AutoCloseable[] autoCloseableArray = new AutoCloseable[]{this.handle};
        IOUtils.INSTANCE.close(autoCloseableArray);
    }

    @Override
    @NotNull
    public IndexInput openInput(@NotNull String name, @NotNull IOContext context) throws IOException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.ensureOpen();
        String id = IndexFileNames.INSTANCE.stripSegmentName(name);
        FileEntry entry = this.entries.get(id);
        if (entry == null) {
            String datFileName = IndexFileNames.INSTANCE.segmentFileName(this.segmentName, "", "cfs");
            throw new FileNotFoundException("No sub-file with id " + id + " found in compound file \"" + datFileName + "\" (fileName=" + name + " files: " + this.entries.keySet() + ")");
        }
        return this.handle.slice(name, entry.getOffset(), entry.getLength(), context.getReadAdvice());
    }

    @Override
    @NotNull
    public String[] listAll() {
        this.ensureOpen();
        Collection $this$toTypedArray$iv = this.entries.keySet();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] res = thisCollection$iv.toArray(new String[0]);
        int n = res.length;
        for (int i = 0; i < n; ++i) {
            res[i] = this.segmentName + res[i];
        }
        return res;
    }

    @Override
    public long fileLength(@NotNull String name) throws IOException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.ensureOpen();
        FileEntry e = this.entries.get(IndexFileNames.INSTANCE.stripSegmentName(name));
        if (e == null) {
            throw new FileNotFoundException(name);
        }
        return e.getLength();
    }

    @Override
    @NotNull
    public String toString() {
        return "CompoundFileDirectory(segment=\"" + this.segmentName + "\" in dir=" + this.directory + ")";
    }

    @Override
    @NotNull
    public Set<String> getPendingDeletions() {
        return new LinkedHashSet();
    }

    @Override
    public void checkIntegrity() throws IOException {
        CodecUtil.INSTANCE.checksumEntireFile(this.handle);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\t\u00a8\u0006\r"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90CompoundReader$FileEntry;", "", "<init>", "()V", "offset", "", "getOffset", "()J", "setOffset", "(J)V", "length", "getLength", "setLength", "core"})
    public static final class FileEntry {
        private long offset;
        private long length;

        public final long getOffset() {
            return this.offset;
        }

        public final void setOffset(long l) {
            this.offset = l;
        }

        public final long getLength() {
            return this.length;
        }

        public final void setLength(long l) {
            this.length = l;
        }
    }
}

