/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs.lucene90;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.ByteCompanionObject;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.codecs.CodecUtil;
import org.gnit.lucenekmp.codecs.DocValuesProducer;
import org.gnit.lucenekmp.codecs.lucene90.IndexedDISI;
import org.gnit.lucenekmp.codecs.lucene90.Lucene90DocValuesFormat;
import org.gnit.lucenekmp.index.BaseTermsEnum;
import org.gnit.lucenekmp.index.BinaryDocValues;
import org.gnit.lucenekmp.index.CorruptIndexException;
import org.gnit.lucenekmp.index.DocValues;
import org.gnit.lucenekmp.index.DocValuesSkipIndexType;
import org.gnit.lucenekmp.index.DocValuesSkipper;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.FieldInfos;
import org.gnit.lucenekmp.index.ImpactsEnum;
import org.gnit.lucenekmp.index.IndexFileNames;
import org.gnit.lucenekmp.index.NumericDocValues;
import org.gnit.lucenekmp.index.PostingsEnum;
import org.gnit.lucenekmp.index.SegmentReadState;
import org.gnit.lucenekmp.index.SortedDocValues;
import org.gnit.lucenekmp.index.SortedNumericDocValues;
import org.gnit.lucenekmp.index.SortedSetDocValues;
import org.gnit.lucenekmp.index.TermsEnum;
import org.gnit.lucenekmp.internal.hppc.IntObjectHashMap;
import org.gnit.lucenekmp.jdkport.ByteExtKt;
import org.gnit.lucenekmp.jdkport.Math;
import org.gnit.lucenekmp.store.ByteArrayDataInput;
import org.gnit.lucenekmp.store.ChecksumIndexInput;
import org.gnit.lucenekmp.store.DataInput;
import org.gnit.lucenekmp.store.IndexInput;
import org.gnit.lucenekmp.store.RandomAccessInput;
import org.gnit.lucenekmp.store.ReadAdvice;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.IOUtils;
import org.gnit.lucenekmp.util.LongValues;
import org.gnit.lucenekmp.util.compress.LZ4;
import org.gnit.lucenekmp.util.packed.DirectMonotonicReader;
import org.gnit.lucenekmp.util.packed.DirectReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0000\u0018\u0000 Z2\u00020\u0001:\u0010KLMNOPQRSTUVWXYZB1\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nB}\b\u0012\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\f\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\f\u0012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\f\u0012\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\f\u0012\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\f\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\u001c\u001a\u00020\u001b\u0012\u0006\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\u0004\b\t\u0010\u001fJ\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020\r2\u0006\u0010%\u001a\u00020\u0019H\u0002J\u0010\u0010)\u001a\u00020\u00172\u0006\u0010%\u001a\u00020\u0019H\u0002J\u0018\u0010(\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\rH\u0002J\u0010\u0010+\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u0019H\u0002J\u0010\u0010,\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u0019H\u0002J\u0010\u0010-\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u0019H\u0002J\u0010\u0010.\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u0019H\u0002J\u0018\u0010.\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\u0015H\u0002J\b\u0010/\u001a\u00020$H\u0016J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0016J(\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u001b2\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020:H\u0002J\u0010\u00100\u001a\u0002012\u0006\u0010*\u001a\u00020\rH\u0002J\u0010\u0010<\u001a\u0002052\u0006\u0010*\u001a\u00020\rH\u0002J\u0010\u0010=\u001a\u00020>2\u0006\u00102\u001a\u000203H\u0016J\u0010\u0010?\u001a\u00020@2\u0006\u00102\u001a\u000203H\u0016J\u0010\u0010?\u001a\u00020@2\u0006\u0010*\u001a\u00020\u0011H\u0002J\u0010\u0010D\u001a\u00020E2\u0006\u00102\u001a\u000203H\u0016J\u0010\u0010D\u001a\u00020E2\u0006\u0010*\u001a\u00020\u0015H\u0002J\u0010\u0010F\u001a\u00020G2\u0006\u00102\u001a\u000203H\u0016J\b\u0010H\u001a\u00020$H\u0016J\u0010\u0010I\u001a\u00020J2\u0006\u00102\u001a\u000203H\u0016R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0014\u0010A\u001a\u00020\u001bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010C\u00a8\u0006["}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer;", "Lorg/gnit/lucenekmp/codecs/DocValuesProducer;", "state", "Lorg/gnit/lucenekmp/index/SegmentReadState;", "dataCodec", "", "dataExtension", "metaCodec", "metaExtension", "<init>", "(Lorg/gnit/lucenekmp/index/SegmentReadState;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "numerics", "Lorg/gnit/lucenekmp/internal/hppc/IntObjectHashMap;", "Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$NumericEntry;", "binaries", "Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$BinaryEntry;", "sorted", "Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$SortedEntry;", "sortedSets", "Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$SortedSetEntry;", "sortedNumerics", "Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$SortedNumericEntry;", "skippers", "Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$DocValuesSkipperEntry;", "data", "Lorg/gnit/lucenekmp/store/IndexInput;", "maxDoc", "", "version", "merging", "", "(Lorg/gnit/lucenekmp/internal/hppc/IntObjectHashMap;Lorg/gnit/lucenekmp/internal/hppc/IntObjectHashMap;Lorg/gnit/lucenekmp/internal/hppc/IntObjectHashMap;Lorg/gnit/lucenekmp/internal/hppc/IntObjectHashMap;Lorg/gnit/lucenekmp/internal/hppc/IntObjectHashMap;Lorg/gnit/lucenekmp/internal/hppc/IntObjectHashMap;Lorg/gnit/lucenekmp/store/IndexInput;IIZ)V", "mergeInstance", "getMergeInstance", "()Lorg/gnit/lucenekmp/codecs/DocValuesProducer;", "readFields", "", "meta", "infos", "Lorg/gnit/lucenekmp/index/FieldInfos;", "readNumeric", "readDocValueSkipperMeta", "entry", "readBinary", "readSorted", "readSortedSet", "readSortedNumeric", "close", "getNumeric", "Lorg/gnit/lucenekmp/index/NumericDocValues;", "field", "Lorg/gnit/lucenekmp/index/FieldInfo;", "getDirectReaderInstance", "Lorg/gnit/lucenekmp/util/LongValues;", "slice", "Lorg/gnit/lucenekmp/store/RandomAccessInput;", "bitsPerValue", "offset", "", "numValues", "getNumericValues", "getBinary", "Lorg/gnit/lucenekmp/index/BinaryDocValues;", "getSorted", "Lorg/gnit/lucenekmp/index/SortedDocValues;", "LZ4_DECOMPRESSOR_PADDING", "getLZ4_DECOMPRESSOR_PADDING", "()I", "getSortedNumeric", "Lorg/gnit/lucenekmp/index/SortedNumericDocValues;", "getSortedSet", "Lorg/gnit/lucenekmp/index/SortedSetDocValues;", "checkIntegrity", "getSkipper", "Lorg/gnit/lucenekmp/index/DocValuesSkipper;", "DocValuesSkipperEntry", "NumericEntry", "BinaryEntry", "TermsDictEntry", "SortedEntry", "SortedSetEntry", "SortedNumericEntry", "DenseNumericDocValues", "SparseNumericDocValues", "DenseBinaryDocValues", "SparseBinaryDocValues", "BaseSortedDocValues", "BaseSortedSetDocValues", "TermsDict", "VaryingBPVReader", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nLucene90DocValuesProducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Lucene90DocValuesProducer.kt\norg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1832:1\n1#2:1833\n*E\n"})
public final class Lucene90DocValuesProducer
extends DocValuesProducer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IntObjectHashMap<NumericEntry> numerics;
    @NotNull
    private final IntObjectHashMap<BinaryEntry> binaries;
    @NotNull
    private final IntObjectHashMap<SortedEntry> sorted;
    @NotNull
    private final IntObjectHashMap<SortedSetEntry> sortedSets;
    @NotNull
    private final IntObjectHashMap<SortedNumericEntry> sortedNumerics;
    @NotNull
    private final IntObjectHashMap<DocValuesSkipperEntry> skippers;
    @NotNull
    private final IndexInput data;
    private final int maxDoc;
    private int version;
    private final boolean merging;
    private final int LZ4_DECOMPRESSOR_PADDING;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lucene90DocValuesProducer(@NotNull SegmentReadState state2, @NotNull String dataCodec, @NotNull String dataExtension, @NotNull String metaCodec, @NotNull String metaExtension) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)dataCodec, (String)"dataCodec");
        Intrinsics.checkNotNullParameter((Object)dataExtension, (String)"dataExtension");
        Intrinsics.checkNotNullParameter((Object)metaCodec, (String)"metaCodec");
        Intrinsics.checkNotNullParameter((Object)metaExtension, (String)"metaExtension");
        this.version = -1;
        this.LZ4_DECOMPRESSOR_PADDING = 7;
        String metaName = IndexFileNames.INSTANCE.segmentFileName(state2.getSegmentInfo().getName(), state2.getSegmentSuffix(), metaExtension);
        this.maxDoc = state2.getSegmentInfo().maxDoc();
        this.numerics = new IntObjectHashMap();
        this.binaries = new IntObjectHashMap();
        this.sorted = new IntObjectHashMap();
        this.sortedSets = new IntObjectHashMap();
        this.sortedNumerics = new IntObjectHashMap();
        this.skippers = new IntObjectHashMap();
        this.merging = false;
        AutoCloseable autoCloseable = state2.getDirectory().openChecksumInput(metaName);
        Throwable throwable = null;
        try {
            ChecksumIndexInput in = (ChecksumIndexInput)autoCloseable;
            boolean bl = false;
            Throwable priorE = null;
            try {
                this.version = CodecUtil.INSTANCE.checkIndexHeader(in, metaCodec, 0, 0, state2.getSegmentInfo().getId(), state2.getSegmentSuffix());
                this.readFields(in, state2.getFieldInfos());
            }
            catch (Throwable exception) {
                priorE = exception;
            }
            finally {
                CodecUtil.INSTANCE.checkFooter(in, priorE);
            }
            in = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        String dataName = IndexFileNames.INSTANCE.segmentFileName(state2.getSegmentInfo().getName(), state2.getSegmentSuffix(), dataExtension);
        this.data = state2.getDirectory().openInput(dataName, state2.getContext().withReadAdvice(ReadAdvice.NORMAL));
        boolean success = false;
        try {
            int version2 = CodecUtil.INSTANCE.checkIndexHeader(this.data, dataCodec, 0, 0, state2.getSegmentInfo().getId(), state2.getSegmentSuffix());
            if (this.version != version2) {
                throw new CorruptIndexException("Format versions mismatch: meta=" + this.version + ", data=" + version2, this.data);
            }
            CodecUtil.INSTANCE.retrieveChecksum(this.data);
            success = true;
        }
        catch (Throwable throwable3) {
            AutoCloseable[] autoCloseableArray = new AutoCloseable[]{this.data};
            IOUtils.INSTANCE.closeWhileHandlingException(autoCloseableArray);
            throw throwable3;
        }
    }

    private Lucene90DocValuesProducer(IntObjectHashMap<NumericEntry> numerics, IntObjectHashMap<BinaryEntry> binaries, IntObjectHashMap<SortedEntry> sorted, IntObjectHashMap<SortedSetEntry> sortedSets, IntObjectHashMap<SortedNumericEntry> sortedNumerics, IntObjectHashMap<DocValuesSkipperEntry> skippers, IndexInput data, int maxDoc, int version, boolean merging) {
        this.version = -1;
        this.LZ4_DECOMPRESSOR_PADDING = 7;
        this.numerics = numerics;
        this.binaries = binaries;
        this.sorted = sorted;
        this.sortedSets = sortedSets;
        this.sortedNumerics = sortedNumerics;
        this.skippers = skippers;
        this.data = data.clone();
        this.maxDoc = maxDoc;
        this.version = version;
        this.merging = merging;
    }

    @Override
    @NotNull
    public DocValuesProducer getMergeInstance() {
        return new Lucene90DocValuesProducer(this.numerics, this.binaries, this.sorted, this.sortedSets, this.sortedNumerics, this.skippers, this.data, this.maxDoc, this.version, true);
    }

    private final void readFields(IndexInput meta, FieldInfos infos) throws IOException {
        int fieldNumber = meta.readInt();
        while (fieldNumber != -1) {
            FieldInfo info = infos.fieldInfo(fieldNumber);
            if (info == null) {
                throw new CorruptIndexException("Invalid field number: " + fieldNumber, meta);
            }
            byte type = meta.readByte();
            if (info.docValuesSkipIndexType() != DocValuesSkipIndexType.NONE) {
                this.skippers.put(info.getNumber(), this.readDocValueSkipperMeta(meta));
            }
            if (type == 0) {
                v0 = this.numerics.put(info.getNumber(), this.readNumeric(meta));
            } else if (type == 1) {
                v0 = this.binaries.put(info.getNumber(), this.readBinary(meta));
            } else if (type == 2) {
                v0 = this.sorted.put(info.getNumber(), this.readSorted(meta));
            } else if (type == 3) {
                v0 = this.sortedSets.put(info.getNumber(), this.readSortedSet(meta));
            } else if (type == 4) {
                v0 = this.sortedNumerics.put(info.getNumber(), this.readSortedNumeric(meta));
            } else {
                throw new CorruptIndexException("invalid type: " + type, meta);
            }
            fieldNumber = meta.readInt();
        }
    }

    private final NumericEntry readNumeric(IndexInput meta) throws IOException {
        NumericEntry entry = new NumericEntry();
        this.readNumeric(meta, entry);
        return entry;
    }

    private final DocValuesSkipperEntry readDocValueSkipperMeta(IndexInput meta) throws IOException {
        long offset = meta.readLong();
        long length = meta.readLong();
        long maxValue = meta.readLong();
        long minValue = meta.readLong();
        int docCount = meta.readInt();
        int maxDocID = meta.readInt();
        return new DocValuesSkipperEntry(offset, length, minValue, maxValue, docCount, maxDocID);
    }

    private final void readNumeric(IndexInput meta, NumericEntry entry) throws IOException {
        entry.setDocsWithFieldOffset(meta.readLong());
        entry.setDocsWithFieldLength(meta.readLong());
        entry.setJumpTableEntryCount(meta.readShort());
        entry.setDenseRankPower(meta.readByte());
        entry.setNumValues(meta.readLong());
        int tableSize = meta.readInt();
        if (tableSize > 256) {
            throw new CorruptIndexException("invalid table size: " + tableSize, meta);
        }
        if (tableSize >= 0) {
            entry.setTable(new long[tableSize]);
            for (int i = 0; i < tableSize; ++i) {
                long[] lArray = entry.getTable();
                Intrinsics.checkNotNull((Object)lArray);
                lArray[i] = meta.readLong();
            }
        }
        if (tableSize < -1) {
            entry.setBlockShift(-2 - tableSize);
        } else {
            entry.setBlockShift(-1);
        }
        entry.setBitsPerValue(meta.readByte());
        entry.setMinValue(meta.readLong());
        entry.setGcd(meta.readLong());
        entry.setValuesOffset(meta.readLong());
        entry.setValuesLength(meta.readLong());
        entry.setValueJumpTableOffset(meta.readLong());
    }

    private final BinaryEntry readBinary(IndexInput meta) throws IOException {
        BinaryEntry entry = new BinaryEntry();
        entry.setDataOffset(meta.readLong());
        entry.setDataLength(meta.readLong());
        entry.setDocsWithFieldOffset(meta.readLong());
        entry.setDocsWithFieldLength(meta.readLong());
        entry.setJumpTableEntryCount(meta.readShort());
        entry.setDenseRankPower(meta.readByte());
        entry.setNumDocsWithField(meta.readInt());
        entry.setMinLength(meta.readInt());
        entry.setMaxLength(meta.readInt());
        if (entry.getMinLength() < entry.getMaxLength()) {
            entry.setAddressesOffset(meta.readLong());
            long numAddresses = (long)entry.getNumDocsWithField() + 1L;
            int blockShift = meta.readVInt();
            entry.setAddressesMeta(DirectMonotonicReader.Companion.loadMeta(meta, numAddresses, blockShift));
            entry.setAddressesLength(meta.readLong());
        }
        return entry;
    }

    private final SortedEntry readSorted(IndexInput meta) throws IOException {
        SortedEntry entry = new SortedEntry();
        entry.setOrdsEntry(new NumericEntry());
        this.readNumeric(meta, entry.getOrdsEntry());
        entry.setTermsDictEntry(new TermsDictEntry());
        Lucene90DocValuesProducer.Companion.readTermDict(meta, entry.getTermsDictEntry());
        return entry;
    }

    private final SortedSetEntry readSortedSet(IndexInput meta) throws IOException {
        SortedSetEntry entry = new SortedSetEntry();
        byte multiValued = meta.readByte();
        byte by = multiValued;
        if (by == 0) {
            entry.setSingleValueEntry(this.readSorted(meta));
            return entry;
        }
        if (by != 1) {
            throw new CorruptIndexException("Invalid multiValued flag: " + multiValued, meta);
        }
        entry.setOrdsEntry(new SortedNumericEntry());
        this.readSortedNumeric(meta, entry.getOrdsEntry());
        entry.setTermsDictEntry(new TermsDictEntry());
        Lucene90DocValuesProducer.Companion.readTermDict(meta, entry.getTermsDictEntry());
        return entry;
    }

    private final SortedNumericEntry readSortedNumeric(IndexInput meta) throws IOException {
        SortedNumericEntry entry = new SortedNumericEntry();
        this.readSortedNumeric(meta, entry);
        return entry;
    }

    private final SortedNumericEntry readSortedNumeric(IndexInput meta, SortedNumericEntry entry) throws IOException {
        this.readNumeric(meta, entry);
        entry.setNumDocsWithField(meta.readInt());
        if ((long)entry.getNumDocsWithField() != entry.getNumValues()) {
            entry.setAddressesOffset(meta.readLong());
            int blockShift = meta.readVInt();
            entry.setAddressesMeta(DirectMonotonicReader.Companion.loadMeta(meta, (long)entry.getNumDocsWithField() + 1L, blockShift));
            entry.setAddressesLength(meta.readLong());
        }
        return entry;
    }

    @Override
    public void close() throws IOException {
        this.data.close();
    }

    @Override
    @NotNull
    public NumericDocValues getNumeric(@NotNull FieldInfo field) throws IOException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        NumericEntry numericEntry = this.numerics.get(field.getNumber());
        Intrinsics.checkNotNull((Object)numericEntry);
        NumericEntry entry = numericEntry;
        return this.getNumeric(entry);
    }

    private final LongValues getDirectReaderInstance(RandomAccessInput slice, int bitsPerValue, long offset, long numValues) {
        LongValues longValues;
        if (this.merging) {
            LongValues longValues2 = DirectReader.INSTANCE.getMergeInstance(slice, bitsPerValue, offset, numValues);
            longValues = longValues2;
            Intrinsics.checkNotNull((Object)longValues2);
        } else {
            longValues = DirectReader.INSTANCE.getInstance(slice, bitsPerValue, offset);
        }
        return longValues;
    }

    private final NumericDocValues getNumeric(NumericEntry entry) throws IOException {
        if (entry.getDocsWithFieldOffset() == -2L) {
            return DocValues.INSTANCE.emptyNumeric();
        }
        if (entry.getDocsWithFieldOffset() == -1L) {
            if (entry.getBitsPerValue() == 0) {
                int n = this.maxDoc;
                return new DenseNumericDocValues(entry, n){
                    final /* synthetic */ NumericEntry $entry;
                    {
                        this.$entry = $entry;
                        super($super_call_param$1);
                    }

                    public long longValue() throws IOException {
                        return this.$entry.getMinValue();
                    }
                };
            }
            RandomAccessInput slice = this.data.randomAccessSlice(entry.getValuesOffset(), entry.getValuesLength());
            if (slice.length() > 0L) {
                slice.prefetch(0L, 1L);
            }
            if (entry.getBlockShift() >= 0) {
                int n = this.maxDoc;
                return new DenseNumericDocValues(this, entry, slice, n){
                    private final VaryingBPVReader vBPVReader;
                    {
                        this.vBPVReader = $receiver.new VaryingBPVReader($entry, $slice);
                    }

                    public final VaryingBPVReader getVBPVReader() {
                        return this.vBPVReader;
                    }

                    public long longValue() throws IOException {
                        return this.vBPVReader.getLongValue(this.getDoc());
                    }
                };
            }
            LongValues values2 = this.getDirectReaderInstance(slice, entry.getBitsPerValue(), 0L, entry.getNumValues());
            if (entry.getTable() != null) {
                long[] table = entry.getTable();
                int n = this.maxDoc;
                return new DenseNumericDocValues(table, values2, n){
                    final /* synthetic */ long[] $table;
                    final /* synthetic */ LongValues $values;
                    {
                        this.$table = $table;
                        this.$values = $values;
                        super($super_call_param$1);
                    }

                    public long longValue() throws IOException {
                        Intrinsics.checkNotNull((Object)this.$table);
                        return this.$table[(int)this.$values.get(this.getDoc())];
                    }
                };
            }
            if (entry.getGcd() == 1L && entry.getMinValue() == 0L) {
                int table = this.maxDoc;
                return new DenseNumericDocValues(values2, table){
                    final /* synthetic */ LongValues $values;
                    {
                        this.$values = $values;
                        super($super_call_param$1);
                    }

                    public long longValue() throws IOException {
                        return this.$values.get(this.getDoc());
                    }
                };
            }
            long mul = entry.getGcd();
            long delta = entry.getMinValue();
            int n = this.maxDoc;
            return new DenseNumericDocValues(mul, values2, delta, n){
                final /* synthetic */ long $mul;
                final /* synthetic */ LongValues $values;
                final /* synthetic */ long $delta;
                {
                    this.$mul = $mul;
                    this.$values = $values;
                    this.$delta = $delta;
                    super($super_call_param$1);
                }

                public long longValue() throws IOException {
                    return this.$mul * this.$values.get(this.getDoc()) + this.$delta;
                }
            };
        }
        IndexedDISI disi = new IndexedDISI(this.data, entry.getDocsWithFieldOffset(), entry.getDocsWithFieldLength(), entry.getJumpTableEntryCount(), entry.getDenseRankPower(), entry.getNumValues());
        if (entry.getBitsPerValue() == 0) {
            return new SparseNumericDocValues(disi, entry){
                final /* synthetic */ NumericEntry $entry;
                {
                    this.$entry = $entry;
                    super($disi);
                }

                public long longValue() throws IOException {
                    return this.$entry.getMinValue();
                }
            };
        }
        RandomAccessInput slice = this.data.randomAccessSlice(entry.getValuesOffset(), entry.getValuesLength());
        if (slice.length() > 0L) {
            slice.prefetch(0L, 1L);
        }
        if (entry.getBlockShift() >= 0) {
            return new SparseNumericDocValues(this, entry, slice, disi){
                private final VaryingBPVReader vBPVReader;
                final /* synthetic */ IndexedDISI $disi;
                {
                    this.$disi = $disi;
                    super($disi);
                    this.vBPVReader = $receiver.new VaryingBPVReader($entry, $slice);
                }

                public final VaryingBPVReader getVBPVReader() {
                    return this.vBPVReader;
                }

                public long longValue() throws IOException {
                    int index = this.$disi.index();
                    return this.vBPVReader.getLongValue(index);
                }
            };
        }
        LongValues values3 = this.getDirectReaderInstance(slice, entry.getBitsPerValue(), 0L, entry.getNumValues());
        if (entry.getTable() != null) {
            long[] table = entry.getTable();
            return new SparseNumericDocValues(disi, table, values3){
                final /* synthetic */ IndexedDISI $disi;
                final /* synthetic */ long[] $table;
                final /* synthetic */ LongValues $values;
                {
                    this.$disi = $disi;
                    this.$table = $table;
                    this.$values = $values;
                    super($disi);
                }

                public long longValue() throws IOException {
                    Intrinsics.checkNotNull((Object)this.$table);
                    return this.$table[(int)this.$values.get(this.$disi.index())];
                }
            };
        }
        if (entry.getGcd() == 1L && entry.getMinValue() == 0L) {
            return new SparseNumericDocValues(disi, values3){
                final /* synthetic */ IndexedDISI $disi;
                final /* synthetic */ LongValues $values;
                {
                    this.$disi = $disi;
                    this.$values = $values;
                    super($disi);
                }

                public long longValue() throws IOException {
                    return this.$values.get(this.$disi.index());
                }
            };
        }
        long mul = entry.getGcd();
        long delta = entry.getMinValue();
        return new SparseNumericDocValues(disi, mul, values3, delta){
            final /* synthetic */ IndexedDISI $disi;
            final /* synthetic */ long $mul;
            final /* synthetic */ LongValues $values;
            final /* synthetic */ long $delta;
            {
                this.$disi = $disi;
                this.$mul = $mul;
                this.$values = $values;
                this.$delta = $delta;
                super($disi);
            }

            public long longValue() throws IOException {
                return this.$mul * this.$values.get(this.$disi.index()) + this.$delta;
            }
        };
    }

    private final LongValues getNumericValues(NumericEntry entry) throws IOException {
        if (entry.getBitsPerValue() == 0) {
            return new LongValues(entry){
                final /* synthetic */ NumericEntry $entry;
                {
                    this.$entry = $entry;
                }

                public long get(long index) {
                    return this.$entry.getMinValue();
                }
            };
        }
        RandomAccessInput slice = this.data.randomAccessSlice(entry.getValuesOffset(), entry.getValuesLength());
        if (slice.length() > 0L) {
            slice.prefetch(0L, 1L);
        }
        if (entry.getBlockShift() >= 0) {
            return new LongValues(this, entry, slice){
                private final VaryingBPVReader vBPVReader;
                {
                    this.vBPVReader = $receiver.new VaryingBPVReader($entry, $slice);
                }

                public final VaryingBPVReader getVBPVReader() {
                    return this.vBPVReader;
                }

                public long get(long index) {
                    try {
                        return this.vBPVReader.getLongValue(index);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }
        LongValues values2 = this.getDirectReaderInstance(slice, entry.getBitsPerValue(), 0L, entry.getNumValues());
        if (entry.getTable() != null) {
            long[] table = entry.getTable();
            return new LongValues(table, values2){
                final /* synthetic */ long[] $table;
                final /* synthetic */ LongValues $values;
                {
                    this.$table = $table;
                    this.$values = $values;
                }

                public long get(long index) {
                    Intrinsics.checkNotNull((Object)this.$table);
                    return this.$table[(int)this.$values.get(index)];
                }
            };
        }
        if (entry.getGcd() != 1L) {
            long gcd = entry.getGcd();
            long minValue = entry.getMinValue();
            return new LongValues(values2, gcd, minValue){
                final /* synthetic */ LongValues $values;
                final /* synthetic */ long $gcd;
                final /* synthetic */ long $minValue;
                {
                    this.$values = $values;
                    this.$gcd = $gcd;
                    this.$minValue = $minValue;
                }

                public long get(long index) {
                    return this.$values.get(index) * this.$gcd + this.$minValue;
                }
            };
        }
        if (entry.getMinValue() != 0L) {
            long minValue = entry.getMinValue();
            return new LongValues(values2, minValue){
                final /* synthetic */ LongValues $values;
                final /* synthetic */ long $minValue;
                {
                    this.$values = $values;
                    this.$minValue = $minValue;
                }

                public long get(long index) {
                    return this.$values.get(index) + this.$minValue;
                }
            };
        }
        return values2;
    }

    @Override
    @NotNull
    public BinaryDocValues getBinary(@NotNull FieldInfo field) throws IOException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        BinaryEntry binaryEntry = this.binaries.get(field.getNumber());
        Intrinsics.checkNotNull((Object)binaryEntry);
        BinaryEntry entry = binaryEntry;
        if (entry.getDocsWithFieldOffset() == -2L) {
            return DocValues.INSTANCE.emptyBinary();
        }
        RandomAccessInput bytesSlice = this.data.randomAccessSlice(entry.getDataOffset(), entry.getDataLength());
        if (bytesSlice.length() > 0L) {
            bytesSlice.prefetch(0L, 1L);
        }
        if (entry.getDocsWithFieldOffset() == -1L) {
            if (entry.getMinLength() == entry.getMaxLength()) {
                int length = entry.getMaxLength();
                int n = this.maxDoc;
                return new DenseBinaryDocValues(length, bytesSlice, n){
                    private final BytesRef bytes;
                    final /* synthetic */ int $length;
                    final /* synthetic */ RandomAccessInput $bytesSlice;
                    {
                        this.$length = $length;
                        this.$bytesSlice = $bytesSlice;
                        super($super_call_param$1);
                        this.bytes = new BytesRef(new byte[$length], 0, $length);
                    }

                    public final BytesRef getBytes() {
                        return this.bytes;
                    }

                    public BytesRef binaryValue() throws IOException {
                        this.$bytesSlice.readBytes((long)this.getDoc() * (long)this.$length, this.bytes.getBytes(), 0, this.$length);
                        return this.bytes;
                    }
                };
            }
            RandomAccessInput addressesData = this.data.randomAccessSlice(entry.getAddressesOffset(), entry.getAddressesLength());
            if (addressesData.length() > 0L) {
                addressesData.prefetch(0L, 1L);
            }
            LongValues addresses = DirectMonotonicReader.Companion.getInstance(entry.getAddressesMeta(), addressesData, this.merging);
            int n = this.maxDoc;
            return new DenseBinaryDocValues(entry, addresses, bytesSlice, n){
                private final BytesRef bytes;
                final /* synthetic */ LongValues $addresses;
                final /* synthetic */ RandomAccessInput $bytesSlice;
                {
                    this.$addresses = $addresses;
                    this.$bytesSlice = $bytesSlice;
                    super($super_call_param$1);
                    this.bytes = new BytesRef(new byte[$entry.getMaxLength()], 0, $entry.getMaxLength());
                }

                public final BytesRef getBytes() {
                    return this.bytes;
                }

                public BytesRef binaryValue() throws IOException {
                    long startOffset = this.$addresses.get(this.getDoc());
                    this.bytes.setLength((int)(this.$addresses.get((long)this.getDoc() + 1L) - startOffset));
                    this.$bytesSlice.readBytes(startOffset, this.bytes.getBytes(), 0, this.bytes.getLength());
                    return this.bytes;
                }
            };
        }
        IndexedDISI disi = new IndexedDISI(this.data, entry.getDocsWithFieldOffset(), entry.getDocsWithFieldLength(), entry.getJumpTableEntryCount(), entry.getDenseRankPower(), entry.getNumDocsWithField());
        if (entry.getMinLength() == entry.getMaxLength()) {
            int length = entry.getMaxLength();
            return new SparseBinaryDocValues(length, disi, bytesSlice){
                private final BytesRef bytes;
                final /* synthetic */ int $length;
                final /* synthetic */ IndexedDISI $disi;
                final /* synthetic */ RandomAccessInput $bytesSlice;
                {
                    this.$length = $length;
                    this.$disi = $disi;
                    this.$bytesSlice = $bytesSlice;
                    super($disi);
                    this.bytes = new BytesRef(new byte[$length], 0, $length);
                }

                public final BytesRef getBytes() {
                    return this.bytes;
                }

                public BytesRef binaryValue() throws IOException {
                    this.$bytesSlice.readBytes((long)this.$disi.index() * (long)this.$length, this.bytes.getBytes(), 0, this.$length);
                    return this.bytes;
                }
            };
        }
        RandomAccessInput addressesData = this.data.randomAccessSlice(entry.getAddressesOffset(), entry.getAddressesLength());
        if (addressesData.length() > 0L) {
            addressesData.prefetch(0L, 1L);
        }
        LongValues addresses = DirectMonotonicReader.Companion.getInstance(entry.getAddressesMeta(), addressesData);
        return new SparseBinaryDocValues(entry, disi, addresses, bytesSlice){
            private final BytesRef bytes;
            final /* synthetic */ IndexedDISI $disi;
            final /* synthetic */ LongValues $addresses;
            final /* synthetic */ RandomAccessInput $bytesSlice;
            {
                this.$disi = $disi;
                this.$addresses = $addresses;
                this.$bytesSlice = $bytesSlice;
                super($disi);
                this.bytes = new BytesRef(new byte[$entry.getMaxLength()], 0, $entry.getMaxLength());
            }

            public final BytesRef getBytes() {
                return this.bytes;
            }

            public BytesRef binaryValue() throws IOException {
                int index = this.$disi.index();
                long startOffset = this.$addresses.get(index);
                this.bytes.setLength((int)(this.$addresses.get((long)index + 1L) - startOffset));
                this.$bytesSlice.readBytes(startOffset, this.bytes.getBytes(), 0, this.bytes.getLength());
                return this.bytes;
            }
        };
    }

    @Override
    @NotNull
    public SortedDocValues getSorted(@NotNull FieldInfo field) throws IOException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        SortedEntry sortedEntry = this.sorted.get(field.getNumber());
        Intrinsics.checkNotNull((Object)sortedEntry);
        SortedEntry entry = sortedEntry;
        return this.getSorted(entry);
    }

    private final SortedDocValues getSorted(SortedEntry entry) throws IOException {
        NumericEntry ordsEntry = entry.getOrdsEntry();
        if (ordsEntry.getBlockShift() < 0 && ordsEntry.getBitsPerValue() > 0) {
            if (!(ordsEntry.getGcd() == 1L && ordsEntry.getMinValue() == 0L && ordsEntry.getTable() == null)) {
                boolean $i$a$-check-Lucene90DocValuesProducer$getSorted$22 = false;
                String $i$a$-check-Lucene90DocValuesProducer$getSorted$22 = "Ordinals shouldn't use GCD, offset or table compression";
                throw new IllegalStateException($i$a$-check-Lucene90DocValuesProducer$getSorted$22.toString());
            }
            RandomAccessInput slice = this.data.randomAccessSlice(ordsEntry.getValuesOffset(), ordsEntry.getValuesLength());
            if (slice.length() > 0L) {
                slice.prefetch(0L, 1L);
            }
            LongValues values2 = this.getDirectReaderInstance(slice, ordsEntry.getBitsPerValue(), 0L, ordsEntry.getNumValues());
            if (ordsEntry.getDocsWithFieldOffset() == -1L) {
                return new BaseSortedDocValues(this, entry, values2){
                    private final int maxDoc;
                    private int doc;
                    final /* synthetic */ LongValues $values;
                    {
                        this.$values = $values;
                        super($entry);
                        this.maxDoc = Lucene90DocValuesProducer.access$getMaxDoc$p($receiver);
                        this.doc = -1;
                    }

                    public int ordValue() throws IOException {
                        return (int)this.$values.get(this.doc);
                    }

                    public boolean advanceExact(int target) throws IOException {
                        this.doc = target;
                        return true;
                    }

                    public int docID() {
                        return this.doc;
                    }

                    public int nextDoc() throws IOException {
                        return this.advance(this.doc + 1);
                    }

                    public int advance(int target) throws IOException {
                        int n;
                        if (target >= this.maxDoc) {
                            int n2;
                            int it = n2 = Integer.MAX_VALUE;
                            boolean bl = false;
                            this.doc = it;
                            return n2;
                        }
                        int it = n = target;
                        boolean bl = false;
                        this.doc = it;
                        return n;
                    }

                    public long cost() {
                        return this.maxDoc;
                    }
                };
            }
            if (ordsEntry.getDocsWithFieldOffset() >= 0L) {
                IndexedDISI disi = new IndexedDISI(this.data, ordsEntry.getDocsWithFieldOffset(), ordsEntry.getDocsWithFieldLength(), ordsEntry.getJumpTableEntryCount(), ordsEntry.getDenseRankPower(), ordsEntry.getNumValues());
                return new BaseSortedDocValues(this, entry, values2, disi){
                    final /* synthetic */ LongValues $values;
                    final /* synthetic */ IndexedDISI $disi;
                    {
                        this.$values = $values;
                        this.$disi = $disi;
                        super($entry);
                    }

                    public int ordValue() throws IOException {
                        return (int)this.$values.get(this.$disi.index());
                    }

                    public boolean advanceExact(int target) throws IOException {
                        return this.$disi.advanceExact(target);
                    }

                    public int docID() {
                        return this.$disi.docID();
                    }

                    public int nextDoc() throws IOException {
                        return this.$disi.nextDoc();
                    }

                    public int advance(int target) throws IOException {
                        return this.$disi.advance(target);
                    }

                    public long cost() {
                        return this.$disi.cost();
                    }
                };
            }
        }
        NumericDocValues ords = this.getNumeric(entry.getOrdsEntry());
        return new BaseSortedDocValues(this, entry, ords){
            final /* synthetic */ NumericDocValues $ords;
            {
                this.$ords = $ords;
                super($entry);
            }

            public int ordValue() throws IOException {
                return (int)this.$ords.longValue();
            }

            public boolean advanceExact(int target) throws IOException {
                return this.$ords.advanceExact(target);
            }

            public int docID() {
                return this.$ords.docID();
            }

            public int nextDoc() throws IOException {
                return this.$ords.nextDoc();
            }

            public int advance(int target) throws IOException {
                return this.$ords.advance(target);
            }

            public long cost() {
                return this.$ords.cost();
            }
        };
    }

    public final int getLZ4_DECOMPRESSOR_PADDING() {
        return this.LZ4_DECOMPRESSOR_PADDING;
    }

    @Override
    @NotNull
    public SortedNumericDocValues getSortedNumeric(@NotNull FieldInfo field) throws IOException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        SortedNumericEntry sortedNumericEntry = this.sortedNumerics.get(field.getNumber());
        Intrinsics.checkNotNull((Object)sortedNumericEntry);
        SortedNumericEntry entry = sortedNumericEntry;
        return this.getSortedNumeric(entry);
    }

    private final SortedNumericDocValues getSortedNumeric(SortedNumericEntry entry) throws IOException {
        if (entry.getNumValues() == (long)entry.getNumDocsWithField()) {
            return DocValues.INSTANCE.singleton(this.getNumeric(entry));
        }
        RandomAccessInput addressesInput = this.data.randomAccessSlice(entry.getAddressesOffset(), entry.getAddressesLength());
        if (addressesInput.length() > 0L) {
            addressesInput.prefetch(0L, 1L);
        }
        LongValues addresses = DirectMonotonicReader.Companion.getInstance(entry.getAddressesMeta(), addressesInput, this.merging);
        LongValues values2 = this.getNumericValues(entry);
        if (entry.getDocsWithFieldOffset() == -1L) {
            return new SortedNumericDocValues(this, addresses, values2){
                private int doc;
                private long start;
                private long end;
                private int count;
                final /* synthetic */ Lucene90DocValuesProducer this$0;
                final /* synthetic */ LongValues $addresses;
                final /* synthetic */ LongValues $values;
                {
                    this.this$0 = $receiver;
                    this.$addresses = $addresses;
                    this.$values = $values;
                    this.doc = -1;
                }

                public final int getDoc() {
                    return this.doc;
                }

                public final void setDoc(int n) {
                    this.doc = n;
                }

                public final long getStart() {
                    return this.start;
                }

                public final void setStart(long l) {
                    this.start = l;
                }

                public final long getEnd() {
                    return this.end;
                }

                public final void setEnd(long l) {
                    this.end = l;
                }

                public final int getCount() {
                    return this.count;
                }

                public final void setCount(int n) {
                    this.count = n;
                }

                public int nextDoc() throws IOException {
                    return this.advance(this.doc + 1);
                }

                public int docID() {
                    return this.doc;
                }

                public long cost() {
                    return Lucene90DocValuesProducer.access$getMaxDoc$p(this.this$0);
                }

                public int advance(int target) throws IOException {
                    int n;
                    if (target >= Lucene90DocValuesProducer.access$getMaxDoc$p(this.this$0)) {
                        int n2;
                        int it = n2 = Integer.MAX_VALUE;
                        boolean bl = false;
                        this.doc = it;
                        return n2;
                    }
                    this.start = this.$addresses.get(target);
                    this.end = this.$addresses.get((long)target + 1L);
                    this.count = (int)(this.end - this.start);
                    int it = n = target;
                    boolean bl = false;
                    this.doc = it;
                    return n;
                }

                public boolean advanceExact(int target) throws IOException {
                    this.start = this.$addresses.get(target);
                    this.end = this.$addresses.get((long)target + 1L);
                    this.count = (int)(this.end - this.start);
                    this.doc = target;
                    return true;
                }

                public long nextValue() throws IOException {
                    long l = this.start;
                    this.start = l + 1L;
                    return this.$values.get(l);
                }

                public int docValueCount() {
                    return this.count;
                }
            };
        }
        IndexedDISI disi = new IndexedDISI(this.data, entry.getDocsWithFieldOffset(), entry.getDocsWithFieldLength(), entry.getJumpTableEntryCount(), entry.getDenseRankPower(), entry.getNumDocsWithField());
        return new SortedNumericDocValues(disi, values2, addresses){
            private boolean set;
            private long start;
            private long end;
            private int count;
            final /* synthetic */ IndexedDISI $disi;
            final /* synthetic */ LongValues $values;
            final /* synthetic */ LongValues $addresses;
            {
                this.$disi = $disi;
                this.$values = $values;
                this.$addresses = $addresses;
            }

            public final boolean getSet() {
                return this.set;
            }

            public final void setSet(boolean bl) {
                this.set = bl;
            }

            public final long getStart() {
                return this.start;
            }

            public final void setStart(long l) {
                this.start = l;
            }

            public final long getEnd() {
                return this.end;
            }

            public final void setEnd(long l) {
                this.end = l;
            }

            public final int getCount() {
                return this.count;
            }

            public final void setCount(int n) {
                this.count = n;
            }

            public int nextDoc() throws IOException {
                this.set = false;
                return this.$disi.nextDoc();
            }

            public int docID() {
                return this.$disi.docID();
            }

            public long cost() {
                return this.$disi.cost();
            }

            public int advance(int target) throws IOException {
                this.set = false;
                return this.$disi.advance(target);
            }

            public boolean advanceExact(int target) throws IOException {
                this.set = false;
                return this.$disi.advanceExact(target);
            }

            public long nextValue() throws IOException {
                this.set();
                long l = this.start;
                this.start = l + 1L;
                return this.$values.get(l);
            }

            public int docValueCount() {
                this.set();
                return this.count;
            }

            public final void set() {
                if (!this.set) {
                    int index = this.$disi.index();
                    this.start = this.$addresses.get(index);
                    this.end = this.$addresses.get((long)index + 1L);
                    this.count = (int)(this.end - this.start);
                    this.set = true;
                }
            }
        };
    }

    @Override
    @NotNull
    public SortedSetDocValues getSortedSet(@NotNull FieldInfo field) throws IOException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        SortedSetEntry sortedSetEntry = this.sortedSets.get(field.getNumber());
        Intrinsics.checkNotNull((Object)sortedSetEntry);
        SortedSetEntry entry = sortedSetEntry;
        if (entry.getSingleValueEntry() != null) {
            return DocValues.INSTANCE.singleton(this.getSorted(entry.getSingleValueEntry()));
        }
        SortedNumericEntry ordsEntry = entry.getOrdsEntry();
        if (ordsEntry.getBlockShift() < 0 && ordsEntry.getBitsPerValue() > 0) {
            if (!(ordsEntry.getGcd() == 1L && ordsEntry.getMinValue() == 0L && ordsEntry.getTable() == null)) {
                boolean $i$a$-check-Lucene90DocValuesProducer$getSortedSet$22 = false;
                String $i$a$-check-Lucene90DocValuesProducer$getSortedSet$22 = "Ordinals shouldn't use GCD, offset or table compression";
                throw new IllegalStateException($i$a$-check-Lucene90DocValuesProducer$getSortedSet$22.toString());
            }
            RandomAccessInput addressesInput = this.data.randomAccessSlice(ordsEntry.getAddressesOffset(), ordsEntry.getAddressesLength());
            if (addressesInput.length() > 0L) {
                addressesInput.prefetch(0L, 1L);
            }
            LongValues addresses = DirectMonotonicReader.Companion.getInstance(ordsEntry.getAddressesMeta(), addressesInput);
            RandomAccessInput slice = this.data.randomAccessSlice(ordsEntry.getValuesOffset(), ordsEntry.getValuesLength());
            if (slice.length() > 0L) {
                slice.prefetch(0L, 1L);
            }
            LongValues values2 = DirectReader.INSTANCE.getInstance(slice, ordsEntry.getBitsPerValue());
            if (ordsEntry.getDocsWithFieldOffset() == -1L) {
                IndexInput indexInput = this.data;
                return new BaseSortedSetDocValues(this, entry, values2, addresses, indexInput){
                    private final int maxDoc;
                    private int doc;
                    private long curr;
                    private int count;
                    final /* synthetic */ LongValues $values;
                    final /* synthetic */ LongValues $addresses;
                    {
                        this.$values = $values;
                        this.$addresses = $addresses;
                        super($entry, $super_call_param$1);
                        this.maxDoc = Lucene90DocValuesProducer.access$getMaxDoc$p($receiver);
                        this.doc = -1;
                    }

                    public long nextOrd() throws IOException {
                        long l = this.curr;
                        this.curr = l + 1L;
                        return this.$values.get(l);
                    }

                    public boolean advanceExact(int target) throws IOException {
                        this.curr = this.$addresses.get(target);
                        long end = this.$addresses.get((long)target + 1L);
                        this.count = (int)(end - this.curr);
                        this.doc = target;
                        return true;
                    }

                    public int docValueCount() {
                        return this.count;
                    }

                    public int docID() {
                        return this.doc;
                    }

                    public int nextDoc() throws IOException {
                        return this.advance(this.doc + 1);
                    }

                    public int advance(int target) throws IOException {
                        int n;
                        if (target >= this.maxDoc) {
                            int n2;
                            int it = n2 = Integer.MAX_VALUE;
                            boolean bl = false;
                            this.doc = it;
                            return n2;
                        }
                        this.curr = this.$addresses.get(target);
                        long end = this.$addresses.get((long)target + 1L);
                        this.count = (int)(end - this.curr);
                        int it = n = target;
                        boolean bl = false;
                        this.doc = it;
                        return n;
                    }

                    public long cost() {
                        return this.maxDoc;
                    }
                };
            }
            if (ordsEntry.getDocsWithFieldOffset() >= 0L) {
                IndexedDISI disi = new IndexedDISI(this.data, ordsEntry.getDocsWithFieldOffset(), ordsEntry.getDocsWithFieldLength(), ordsEntry.getJumpTableEntryCount(), ordsEntry.getDenseRankPower(), ordsEntry.getNumValues());
                IndexInput indexInput = this.data;
                return new BaseSortedSetDocValues(this, entry, values2, disi, addresses, indexInput){
                    private boolean set;
                    private long curr;
                    private int count;
                    final /* synthetic */ LongValues $values;
                    final /* synthetic */ IndexedDISI $disi;
                    final /* synthetic */ LongValues $addresses;
                    {
                        this.$values = $values;
                        this.$disi = $disi;
                        this.$addresses = $addresses;
                        super($entry, $super_call_param$1);
                    }

                    public final boolean getSet() {
                        return this.set;
                    }

                    public final void setSet(boolean bl) {
                        this.set = bl;
                    }

                    public final long getCurr() {
                        return this.curr;
                    }

                    public final void setCurr(long l) {
                        this.curr = l;
                    }

                    public final int getCount() {
                        return this.count;
                    }

                    public final void setCount(int n) {
                        this.count = n;
                    }

                    public long nextOrd() throws IOException {
                        this.set();
                        long l = this.curr;
                        this.curr = l + 1L;
                        return this.$values.get(l);
                    }

                    public boolean advanceExact(int target) throws IOException {
                        this.set = false;
                        return this.$disi.advanceExact(target);
                    }

                    public int docValueCount() {
                        this.set();
                        return this.count;
                    }

                    public int docID() {
                        return this.$disi.docID();
                    }

                    public int nextDoc() throws IOException {
                        this.set = false;
                        return this.$disi.nextDoc();
                    }

                    public int advance(int target) throws IOException {
                        this.set = false;
                        return this.$disi.advance(target);
                    }

                    public long cost() {
                        return this.$disi.cost();
                    }

                    public final void set() {
                        if (!this.set) {
                            int index = this.$disi.index();
                            this.curr = this.$addresses.get(index);
                            long end = this.$addresses.get((long)index + 1L);
                            this.count = (int)(end - this.curr);
                            this.set = true;
                        }
                    }
                };
            }
        }
        SortedNumericDocValues ords = this.getSortedNumeric(ordsEntry);
        IndexInput indexInput = this.data;
        return new BaseSortedSetDocValues(this, entry, ords, indexInput){
            final /* synthetic */ SortedNumericDocValues $ords;
            {
                this.$ords = $ords;
                super($entry, $super_call_param$1);
            }

            public long nextOrd() throws IOException {
                return this.$ords.nextValue();
            }

            public int docValueCount() {
                return this.$ords.docValueCount();
            }

            public boolean advanceExact(int target) throws IOException {
                return this.$ords.advanceExact(target);
            }

            public int docID() {
                return this.$ords.docID();
            }

            public int nextDoc() throws IOException {
                return this.$ords.nextDoc();
            }

            public int advance(int target) throws IOException {
                return this.$ords.advance(target);
            }

            public long cost() {
                return this.$ords.cost();
            }
        };
    }

    @Override
    public void checkIntegrity() throws IOException {
        CodecUtil.INSTANCE.checksumEntireFile(this.data);
    }

    @Override
    @NotNull
    public DocValuesSkipper getSkipper(@NotNull FieldInfo field) throws IOException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        DocValuesSkipperEntry docValuesSkipperEntry = this.skippers.get(field.getNumber());
        Intrinsics.checkNotNull((Object)docValuesSkipperEntry);
        DocValuesSkipperEntry entry = docValuesSkipperEntry;
        IndexInput input = this.data.slice("doc value skipper", entry.getOffset(), entry.getLength());
        if (input.length() > 0L) {
            input.prefetch(0L, 1L);
        }
        return new DocValuesSkipper(entry, input){
            private final int[] minDocID;
            private final int[] maxDocID;
            private final long[] minValue;
            private final long[] maxValue;
            private final int[] docCount;
            private int levels;
            final /* synthetic */ DocValuesSkipperEntry $entry;
            final /* synthetic */ IndexInput $input;
            {
                this.$entry = $entry;
                this.$input = $input;
                this.minDocID = new int[4];
                this.maxDocID = new int[4];
                for (int i = 0; i < 4; ++i) {
                    this.maxDocID[i] = -1;
                    this.minDocID[i] = this.maxDocID[i];
                }
                this.minValue = new long[4];
                this.maxValue = new long[4];
                this.docCount = new int[4];
                this.levels = 1;
            }

            public final int[] getMinDocID() {
                return this.minDocID;
            }

            public final int[] getMaxDocID() {
                return this.maxDocID;
            }

            public final long[] getMinValue() {
                return this.minValue;
            }

            public final long[] getMaxValue() {
                return this.maxValue;
            }

            public final int[] getDocCount() {
                return this.docCount;
            }

            public final int getLevels() {
                return this.levels;
            }

            public final void setLevels(int n) {
                this.levels = n;
            }

            public void advance(int target) throws IOException {
                if (target > this.$entry.getMaxDocId()) {
                    for (int i = 0; i < 4; ++i) {
                        this.maxDocID[i] = Integer.MAX_VALUE;
                        this.minDocID[i] = this.maxDocID[i];
                    }
                } else {
                    boolean valid;
                    if (!(target > this.maxDocID[0])) {
                        boolean $i$a$-require-Lucene90DocValuesProducer$getSkipper$1$advance$32 = false;
                        String $i$a$-require-Lucene90DocValuesProducer$getSkipper$1$advance$32 = "target must be bigger that current interval";
                        throw new IllegalArgumentException($i$a$-require-Lucene90DocValuesProducer$getSkipper$1$advance$32.toString());
                    }
                    block1: do {
                        this.levels = this.$input.readByte();
                        if (!(this.levels <= 4 && this.levels > 0)) {
                            boolean $i$a$-require-Lucene90DocValuesProducer$getSkipper$1$advance$42 = false;
                            String $i$a$-require-Lucene90DocValuesProducer$getSkipper$1$advance$42 = "level out of range [" + this.levels + "]";
                            throw new IllegalArgumentException($i$a$-require-Lucene90DocValuesProducer$getSkipper$1$advance$42.toString());
                        }
                        valid = true;
                        for (int level = this.levels - 1; -1 < level; --level) {
                            int n;
                            int it = n = this.$input.readInt();
                            boolean bl = false;
                            this.maxDocID[level] = it;
                            if (n < target) {
                                this.$input.skipBytes(Lucene90DocValuesFormat.Companion.getSKIP_INDEX_JUMP_LENGTH_PER_LEVEL()[level]);
                                valid = false;
                                continue block1;
                            }
                            this.minDocID[level] = this.$input.readInt();
                            this.maxValue[level] = this.$input.readLong();
                            this.minValue[level] = this.$input.readLong();
                            this.docCount[level] = this.$input.readInt();
                        }
                    } while (!valid);
                    while (this.levels < 4 && this.maxDocID[this.levels] >= target) {
                        int n = this.levels;
                        this.levels = n + 1;
                    }
                }
            }

            public int numLevels() {
                return this.levels;
            }

            public int minDocID(int level) {
                return this.minDocID[level];
            }

            public int maxDocID(int level) {
                return this.maxDocID[level];
            }

            public long minValue(int level) {
                return this.minValue[level];
            }

            public long maxValue(int level) {
                return this.maxValue[level];
            }

            public int docCount(int level) {
                return this.docCount[level];
            }

            public long minValue() {
                return this.$entry.getMinValue();
            }

            public long maxValue() {
                return this.$entry.getMaxValue();
            }

            public int docCount() {
                return this.$entry.getDocCount();
            }
        };
    }

    public static final /* synthetic */ int access$getMaxDoc$p(Lucene90DocValuesProducer $this) {
        return $this.maxDoc;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00a2\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\rH\u0016J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0011H\u0016J\b\u0010\b\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$BaseSortedDocValues;", "Lorg/gnit/lucenekmp/index/SortedDocValues;", "entry", "Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$SortedEntry;", "<init>", "(Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer;Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$SortedEntry;)V", "getEntry", "()Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$SortedEntry;", "termsEnum", "Lorg/gnit/lucenekmp/index/TermsEnum;", "getTermsEnum", "()Lorg/gnit/lucenekmp/index/TermsEnum;", "valueCount", "", "getValueCount", "()I", "lookupOrd", "Lorg/gnit/lucenekmp/util/BytesRef;", "ord", "lookupTerm", "key", "core"})
    private abstract class BaseSortedDocValues
    extends SortedDocValues {
        @NotNull
        private final SortedEntry entry;
        @NotNull
        private final TermsEnum termsEnum;

        public BaseSortedDocValues(SortedEntry entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            this.entry = entry;
            this.termsEnum = this.termsEnum();
        }

        @NotNull
        public final SortedEntry getEntry() {
            return this.entry;
        }

        @NotNull
        public final TermsEnum getTermsEnum() {
            return this.termsEnum;
        }

        @Override
        public int getValueCount() {
            return Math.INSTANCE.toIntExact(this.entry.getTermsDictEntry().getTermsDictSize());
        }

        @Override
        @Nullable
        public BytesRef lookupOrd(int ord) throws IOException {
            this.termsEnum.seekExact(ord);
            return this.termsEnum.term();
        }

        @Override
        public int lookupTerm(@NotNull BytesRef key) throws IOException {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            TermsEnum.SeekStatus status = this.termsEnum.seekCeil(key);
            return switch (WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
                case 1 -> Math.INSTANCE.toIntExact(this.termsEnum.ord());
                case 2, 3 -> Math.INSTANCE.toIntExact(-1L - this.termsEnum.ord());
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        @Override
        @NotNull
        public TermsEnum termsEnum() throws IOException {
            return new TermsDict(this.entry.getTermsDictEntry(), Lucene90DocValuesProducer.this.data);
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[TermsEnum.SeekStatus.values().length];
                try {
                    nArray[TermsEnum.SeekStatus.FOUND.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TermsEnum.SeekStatus.NOT_FOUND.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TermsEnum.SeekStatus.END.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00a2\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0011H\u0016J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0015H\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0019"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$BaseSortedSetDocValues;", "Lorg/gnit/lucenekmp/index/SortedSetDocValues;", "entry", "Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$SortedSetEntry;", "data", "Lorg/gnit/lucenekmp/store/IndexInput;", "<init>", "(Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer;Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$SortedSetEntry;Lorg/gnit/lucenekmp/store/IndexInput;)V", "getEntry", "()Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$SortedSetEntry;", "getData", "()Lorg/gnit/lucenekmp/store/IndexInput;", "termsEnum", "Lorg/gnit/lucenekmp/index/TermsEnum;", "getTermsEnum", "()Lorg/gnit/lucenekmp/index/TermsEnum;", "valueCount", "", "getValueCount", "()J", "lookupOrd", "Lorg/gnit/lucenekmp/util/BytesRef;", "ord", "lookupTerm", "key", "core"})
    private abstract class BaseSortedSetDocValues
    extends SortedSetDocValues {
        @NotNull
        private final SortedSetEntry entry;
        @NotNull
        private final IndexInput data;
        @NotNull
        private final TermsEnum termsEnum;

        public BaseSortedSetDocValues(@NotNull SortedSetEntry entry, IndexInput data) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.entry = entry;
            this.data = data;
            this.termsEnum = this.termsEnum();
        }

        @NotNull
        public final SortedSetEntry getEntry() {
            return this.entry;
        }

        @NotNull
        public final IndexInput getData() {
            return this.data;
        }

        @NotNull
        public final TermsEnum getTermsEnum() {
            return this.termsEnum;
        }

        @Override
        public long getValueCount() {
            return this.entry.getTermsDictEntry().getTermsDictSize();
        }

        @Override
        @Nullable
        public BytesRef lookupOrd(long ord) throws IOException {
            this.termsEnum.seekExact(ord);
            return this.termsEnum.term();
        }

        @Override
        public long lookupTerm(@NotNull BytesRef key) throws IOException {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            TermsEnum.SeekStatus status = this.termsEnum.seekCeil(key);
            return switch (WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
                case 1 -> this.termsEnum.ord();
                case 2, 3 -> -1L - this.termsEnum.ord();
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        @Override
        @NotNull
        public TermsEnum termsEnum() throws IOException {
            return new TermsDict(this.entry.getTermsDictEntry(), this.data);
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[TermsEnum.SeekStatus.values().length];
                try {
                    nArray[TermsEnum.SeekStatus.FOUND.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TermsEnum.SeekStatus.NOT_FOUND.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TermsEnum.SeekStatus.END.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0010\n\n\u0002\b\u0005\n\u0002\u0010\u0005\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR\u001a\u0010\u0010\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\tR\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\"\"\u0004\b'\u0010$R\u001a\u0010(\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\"\"\u0004\b*\u0010$R\u001a\u0010+\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u0007\"\u0004\b-\u0010\tR\u001a\u0010.\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u0007\"\u0004\b0\u0010\tR\u001a\u00101\u001a\u000202X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106\u00a8\u00067"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$BinaryEntry;", "", "<init>", "()V", "dataOffset", "", "getDataOffset", "()J", "setDataOffset", "(J)V", "dataLength", "getDataLength", "setDataLength", "docsWithFieldOffset", "getDocsWithFieldOffset", "setDocsWithFieldOffset", "docsWithFieldLength", "getDocsWithFieldLength", "setDocsWithFieldLength", "jumpTableEntryCount", "", "getJumpTableEntryCount", "()S", "setJumpTableEntryCount", "(S)V", "denseRankPower", "", "getDenseRankPower", "()B", "setDenseRankPower", "(B)V", "numDocsWithField", "", "getNumDocsWithField", "()I", "setNumDocsWithField", "(I)V", "minLength", "getMinLength", "setMinLength", "maxLength", "getMaxLength", "setMaxLength", "addressesOffset", "getAddressesOffset", "setAddressesOffset", "addressesLength", "getAddressesLength", "setAddressesLength", "addressesMeta", "Lorg/gnit/lucenekmp/util/packed/DirectMonotonicReader$Meta;", "getAddressesMeta", "()Lorg/gnit/lucenekmp/util/packed/DirectMonotonicReader$Meta;", "setAddressesMeta", "(Lorg/gnit/lucenekmp/util/packed/DirectMonotonicReader$Meta;)V", "core"})
    private static final class BinaryEntry {
        private long dataOffset;
        private long dataLength;
        private long docsWithFieldOffset;
        private long docsWithFieldLength;
        private short jumpTableEntryCount;
        private byte denseRankPower;
        private int numDocsWithField;
        private int minLength;
        private int maxLength;
        private long addressesOffset;
        private long addressesLength;
        public DirectMonotonicReader.Meta addressesMeta;

        public final long getDataOffset() {
            return this.dataOffset;
        }

        public final void setDataOffset(long l) {
            this.dataOffset = l;
        }

        public final long getDataLength() {
            return this.dataLength;
        }

        public final void setDataLength(long l) {
            this.dataLength = l;
        }

        public final long getDocsWithFieldOffset() {
            return this.docsWithFieldOffset;
        }

        public final void setDocsWithFieldOffset(long l) {
            this.docsWithFieldOffset = l;
        }

        public final long getDocsWithFieldLength() {
            return this.docsWithFieldLength;
        }

        public final void setDocsWithFieldLength(long l) {
            this.docsWithFieldLength = l;
        }

        public final short getJumpTableEntryCount() {
            return this.jumpTableEntryCount;
        }

        public final void setJumpTableEntryCount(short s) {
            this.jumpTableEntryCount = s;
        }

        public final byte getDenseRankPower() {
            return this.denseRankPower;
        }

        public final void setDenseRankPower(byte by) {
            this.denseRankPower = by;
        }

        public final int getNumDocsWithField() {
            return this.numDocsWithField;
        }

        public final void setNumDocsWithField(int n) {
            this.numDocsWithField = n;
        }

        public final int getMinLength() {
            return this.minLength;
        }

        public final void setMinLength(int n) {
            this.minLength = n;
        }

        public final int getMaxLength() {
            return this.maxLength;
        }

        public final void setMaxLength(int n) {
            this.maxLength = n;
        }

        public final long getAddressesOffset() {
            return this.addressesOffset;
        }

        public final void setAddressesOffset(long l) {
            this.addressesOffset = l;
        }

        public final long getAddressesLength() {
            return this.addressesLength;
        }

        public final void setAddressesLength(long l) {
            this.addressesLength = l;
        }

        @NotNull
        public final DirectMonotonicReader.Meta getAddressesMeta() {
            DirectMonotonicReader.Meta meta = this.addressesMeta;
            if (meta != null) {
                return meta;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"addressesMeta");
            return null;
        }

        public final void setAddressesMeta(@NotNull DirectMonotonicReader.Meta meta) {
            Intrinsics.checkNotNullParameter((Object)meta, (String)"<set-?>");
            this.addressesMeta = meta;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$Companion;", "", "<init>", "()V", "readTermDict", "", "meta", "Lorg/gnit/lucenekmp/store/IndexInput;", "entry", "Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$TermsDictEntry;", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final void readTermDict(IndexInput meta, TermsDictEntry entry) throws IOException {
            entry.setTermsDictSize(meta.readVLong());
            int blockShift = meta.readInt();
            long addressesSize = entry.getTermsDictSize() + 64L - 1L >>> 6;
            entry.setTermsAddressesMeta(DirectMonotonicReader.Companion.loadMeta(meta, addressesSize, blockShift));
            entry.setMaxTermLength(meta.readInt());
            entry.setMaxBlockLength(meta.readInt());
            entry.setTermsDataOffset(meta.readLong());
            entry.setTermsDataLength(meta.readLong());
            entry.setTermsAddressesOffset(meta.readLong());
            entry.setTermsAddressesLength(meta.readLong());
            entry.setTermsDictIndexShift(meta.readInt());
            long indexSize = entry.getTermsDictSize() + (1L << entry.getTermsDictIndexShift()) - 1L >>> entry.getTermsDictIndexShift();
            entry.setTermsIndexAddressesMeta(DirectMonotonicReader.Companion.loadMeta(meta, 1L + indexSize, blockShift));
            entry.setTermsIndexOffset(meta.readLong());
            entry.setTermsIndexLength(meta.readLong());
            entry.setTermsIndexAddressesOffset(meta.readLong());
            entry.setTermsIndexAddressesLength(meta.readLong());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\"\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\b\u0010\f\u001a\u00020\u0003H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u0007\"\u0004\b\n\u0010\u0005\u00a8\u0006\u0013"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$DenseBinaryDocValues;", "Lorg/gnit/lucenekmp/index/BinaryDocValues;", "maxDoc", "", "<init>", "(I)V", "getMaxDoc", "()I", "doc", "getDoc", "setDoc", "nextDoc", "docID", "cost", "", "advance", "target", "advanceExact", "", "core"})
    @SourceDebugExtension(value={"SMAP\nLucene90DocValuesProducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Lucene90DocValuesProducer.kt\norg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$DenseBinaryDocValues\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1832:1\n1#2:1833\n*E\n"})
    private static abstract class DenseBinaryDocValues
    extends BinaryDocValues {
        private final int maxDoc;
        private int doc;

        public DenseBinaryDocValues(int maxDoc) {
            this.maxDoc = maxDoc;
            this.doc = -1;
        }

        public final int getMaxDoc() {
            return this.maxDoc;
        }

        public final int getDoc() {
            return this.doc;
        }

        public final void setDoc(int n) {
            this.doc = n;
        }

        @Override
        public int nextDoc() throws IOException {
            return this.advance(this.doc + 1);
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public long cost() {
            return this.maxDoc;
        }

        @Override
        public int advance(int target) throws IOException {
            int n;
            if (target >= this.maxDoc) {
                int n2;
                int it = n2 = Integer.MAX_VALUE;
                boolean bl = false;
                this.doc = it;
                return n2;
            }
            int it = n = target;
            boolean bl = false;
            this.doc = it;
            return n;
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            this.doc = target;
            return true;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\b\"\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\b\u0010\f\u001a\u00020\u0003H\u0016J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u0007\"\u0004\b\n\u0010\u0005\u00a8\u0006\u0013"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$DenseNumericDocValues;", "Lorg/gnit/lucenekmp/index/NumericDocValues;", "maxDoc", "", "<init>", "(I)V", "getMaxDoc", "()I", "doc", "getDoc", "setDoc", "docID", "nextDoc", "advance", "target", "advanceExact", "", "cost", "", "core"})
    @SourceDebugExtension(value={"SMAP\nLucene90DocValuesProducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Lucene90DocValuesProducer.kt\norg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$DenseNumericDocValues\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1832:1\n1#2:1833\n*E\n"})
    private static abstract class DenseNumericDocValues
    extends NumericDocValues {
        private final int maxDoc;
        private int doc;

        public DenseNumericDocValues(int maxDoc) {
            this.maxDoc = maxDoc;
            this.doc = -1;
        }

        public final int getMaxDoc() {
            return this.maxDoc;
        }

        public final int getDoc() {
            return this.doc;
        }

        public final void setDoc(int n) {
            this.doc = n;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int nextDoc() throws IOException {
            return this.advance(this.doc + 1);
        }

        @Override
        public int advance(int target) throws IOException {
            int n;
            if (target >= this.maxDoc) {
                int n2;
                int it = n2 = Integer.MAX_VALUE;
                boolean bl = false;
                this.doc = it;
                return n2;
            }
            int it = n = target;
            boolean bl = false;
            this.doc = it;
            return n;
        }

        @Override
        public boolean advanceExact(int target) {
            this.doc = target;
            return true;
        }

        @Override
        public long cost() {
            return this.maxDoc;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0019\u001a\u00020\bH\u00c6\u0003JE\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\bH\u00d6\u0001J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012\u00a8\u0006!"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$DocValuesSkipperEntry;", "", "offset", "", "length", "minValue", "maxValue", "docCount", "", "maxDocId", "<init>", "(JJJJII)V", "getOffset", "()J", "getLength", "getMinValue", "getMaxValue", "getDocCount", "()I", "getMaxDocId", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "", "core"})
    private static final class DocValuesSkipperEntry {
        private final long offset;
        private final long length;
        private final long minValue;
        private final long maxValue;
        private final int docCount;
        private final int maxDocId;

        public DocValuesSkipperEntry(long offset, long length, long minValue, long maxValue, int docCount, int maxDocId) {
            this.offset = offset;
            this.length = length;
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.docCount = docCount;
            this.maxDocId = maxDocId;
        }

        public final long getOffset() {
            return this.offset;
        }

        public final long getLength() {
            return this.length;
        }

        public final long getMinValue() {
            return this.minValue;
        }

        public final long getMaxValue() {
            return this.maxValue;
        }

        public final int getDocCount() {
            return this.docCount;
        }

        public final int getMaxDocId() {
            return this.maxDocId;
        }

        public final long component1() {
            return this.offset;
        }

        public final long component2() {
            return this.length;
        }

        public final long component3() {
            return this.minValue;
        }

        public final long component4() {
            return this.maxValue;
        }

        public final int component5() {
            return this.docCount;
        }

        public final int component6() {
            return this.maxDocId;
        }

        @NotNull
        public final DocValuesSkipperEntry copy(long offset, long length, long minValue, long maxValue, int docCount, int maxDocId) {
            return new DocValuesSkipperEntry(offset, length, minValue, maxValue, docCount, maxDocId);
        }

        public static /* synthetic */ DocValuesSkipperEntry copy$default(DocValuesSkipperEntry docValuesSkipperEntry, long l, long l2, long l3, long l4, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                l = docValuesSkipperEntry.offset;
            }
            if ((n3 & 2) != 0) {
                l2 = docValuesSkipperEntry.length;
            }
            if ((n3 & 4) != 0) {
                l3 = docValuesSkipperEntry.minValue;
            }
            if ((n3 & 8) != 0) {
                l4 = docValuesSkipperEntry.maxValue;
            }
            if ((n3 & 0x10) != 0) {
                n = docValuesSkipperEntry.docCount;
            }
            if ((n3 & 0x20) != 0) {
                n2 = docValuesSkipperEntry.maxDocId;
            }
            return docValuesSkipperEntry.copy(l, l2, l3, l4, n, n2);
        }

        @NotNull
        public String toString() {
            return "DocValuesSkipperEntry(offset=" + this.offset + ", length=" + this.length + ", minValue=" + this.minValue + ", maxValue=" + this.maxValue + ", docCount=" + this.docCount + ", maxDocId=" + this.maxDocId + ")";
        }

        public int hashCode() {
            int result = Long.hashCode(this.offset);
            result = result * 31 + Long.hashCode(this.length);
            result = result * 31 + Long.hashCode(this.minValue);
            result = result * 31 + Long.hashCode(this.maxValue);
            result = result * 31 + Integer.hashCode(this.docCount);
            result = result * 31 + Integer.hashCode(this.maxDocId);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DocValuesSkipperEntry)) {
                return false;
            }
            DocValuesSkipperEntry docValuesSkipperEntry = (DocValuesSkipperEntry)other;
            if (this.offset != docValuesSkipperEntry.offset) {
                return false;
            }
            if (this.length != docValuesSkipperEntry.length) {
                return false;
            }
            if (this.minValue != docValuesSkipperEntry.minValue) {
                return false;
            }
            if (this.maxValue != docValuesSkipperEntry.maxValue) {
                return false;
            }
            if (this.docCount != docValuesSkipperEntry.docCount) {
                return false;
            }
            return this.maxDocId == docValuesSkipperEntry.maxDocId;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0005\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\n\n\u0002\b\u001a\b\u0012\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0019\"\u0004\b\u001e\u0010\u001bR\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0013\"\u0004\b'\u0010\u0015R\u001a\u0010(\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0019\"\u0004\b*\u0010\u001bR\u001a\u0010+\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u0019\"\u0004\b-\u0010\u001bR\u001a\u0010.\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u0019\"\u0004\b0\u0010\u001bR\u001a\u00101\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u0019\"\u0004\b3\u0010\u001bR\u001a\u00104\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010\u0019\"\u0004\b6\u0010\u001bR\u001a\u00107\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010\u0019\"\u0004\b9\u0010\u001b\u00a8\u0006:"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$NumericEntry;", "", "<init>", "()V", "table", "", "getTable", "()[J", "setTable", "([J)V", "blockShift", "", "getBlockShift", "()I", "setBlockShift", "(I)V", "bitsPerValue", "", "getBitsPerValue", "()B", "setBitsPerValue", "(B)V", "docsWithFieldOffset", "", "getDocsWithFieldOffset", "()J", "setDocsWithFieldOffset", "(J)V", "docsWithFieldLength", "getDocsWithFieldLength", "setDocsWithFieldLength", "jumpTableEntryCount", "", "getJumpTableEntryCount", "()S", "setJumpTableEntryCount", "(S)V", "denseRankPower", "getDenseRankPower", "setDenseRankPower", "numValues", "getNumValues", "setNumValues", "minValue", "getMinValue", "setMinValue", "gcd", "getGcd", "setGcd", "valuesOffset", "getValuesOffset", "setValuesOffset", "valuesLength", "getValuesLength", "setValuesLength", "valueJumpTableOffset", "getValueJumpTableOffset", "setValueJumpTableOffset", "core"})
    private static class NumericEntry {
        @Nullable
        private long[] table;
        private int blockShift;
        private byte bitsPerValue;
        private long docsWithFieldOffset;
        private long docsWithFieldLength;
        private short jumpTableEntryCount;
        private byte denseRankPower;
        private long numValues;
        private long minValue;
        private long gcd;
        private long valuesOffset;
        private long valuesLength;
        private long valueJumpTableOffset;

        @Nullable
        public final long[] getTable() {
            return this.table;
        }

        public final void setTable(@Nullable long[] lArray) {
            this.table = lArray;
        }

        public final int getBlockShift() {
            return this.blockShift;
        }

        public final void setBlockShift(int n) {
            this.blockShift = n;
        }

        public final byte getBitsPerValue() {
            return this.bitsPerValue;
        }

        public final void setBitsPerValue(byte by) {
            this.bitsPerValue = by;
        }

        public final long getDocsWithFieldOffset() {
            return this.docsWithFieldOffset;
        }

        public final void setDocsWithFieldOffset(long l) {
            this.docsWithFieldOffset = l;
        }

        public final long getDocsWithFieldLength() {
            return this.docsWithFieldLength;
        }

        public final void setDocsWithFieldLength(long l) {
            this.docsWithFieldLength = l;
        }

        public final short getJumpTableEntryCount() {
            return this.jumpTableEntryCount;
        }

        public final void setJumpTableEntryCount(short s) {
            this.jumpTableEntryCount = s;
        }

        public final byte getDenseRankPower() {
            return this.denseRankPower;
        }

        public final void setDenseRankPower(byte by) {
            this.denseRankPower = by;
        }

        public final long getNumValues() {
            return this.numValues;
        }

        public final void setNumValues(long l) {
            this.numValues = l;
        }

        public final long getMinValue() {
            return this.minValue;
        }

        public final void setMinValue(long l) {
            this.minValue = l;
        }

        public final long getGcd() {
            return this.gcd;
        }

        public final void setGcd(long l) {
            this.gcd = l;
        }

        public final long getValuesOffset() {
            return this.valuesOffset;
        }

        public final void setValuesOffset(long l) {
            this.valuesOffset = l;
        }

        public final long getValuesLength() {
            return this.valuesLength;
        }

        public final void setValuesLength(long l) {
            this.valuesLength = l;
        }

        public final long getValueJumpTableOffset() {
            return this.valueJumpTableOffset;
        }

        public final void setValueJumpTableOffset(long l) {
            this.valueJumpTableOffset = l;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$SortedEntry;", "", "<init>", "()V", "ordsEntry", "Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$NumericEntry;", "getOrdsEntry", "()Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$NumericEntry;", "setOrdsEntry", "(Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$NumericEntry;)V", "termsDictEntry", "Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$TermsDictEntry;", "getTermsDictEntry", "()Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$TermsDictEntry;", "setTermsDictEntry", "(Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$TermsDictEntry;)V", "core"})
    private static final class SortedEntry {
        public NumericEntry ordsEntry;
        public TermsDictEntry termsDictEntry;

        @NotNull
        public final NumericEntry getOrdsEntry() {
            NumericEntry numericEntry = this.ordsEntry;
            if (numericEntry != null) {
                return numericEntry;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"ordsEntry");
            return null;
        }

        public final void setOrdsEntry(@NotNull NumericEntry numericEntry) {
            Intrinsics.checkNotNullParameter((Object)numericEntry, (String)"<set-?>");
            this.ordsEntry = numericEntry;
        }

        @NotNull
        public final TermsDictEntry getTermsDictEntry() {
            TermsDictEntry termsDictEntry = this.termsDictEntry;
            if (termsDictEntry != null) {
                return termsDictEntry;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"termsDictEntry");
            return null;
        }

        public final void setTermsDictEntry(@NotNull TermsDictEntry termsDictEntry) {
            Intrinsics.checkNotNullParameter((Object)termsDictEntry, (String)"<set-?>");
            this.termsDictEntry = termsDictEntry;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015\u00a8\u0006\u0019"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$SortedNumericEntry;", "Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$NumericEntry;", "<init>", "()V", "numDocsWithField", "", "getNumDocsWithField", "()I", "setNumDocsWithField", "(I)V", "addressesMeta", "Lorg/gnit/lucenekmp/util/packed/DirectMonotonicReader$Meta;", "getAddressesMeta", "()Lorg/gnit/lucenekmp/util/packed/DirectMonotonicReader$Meta;", "setAddressesMeta", "(Lorg/gnit/lucenekmp/util/packed/DirectMonotonicReader$Meta;)V", "addressesOffset", "", "getAddressesOffset", "()J", "setAddressesOffset", "(J)V", "addressesLength", "getAddressesLength", "setAddressesLength", "core"})
    private static final class SortedNumericEntry
    extends NumericEntry {
        private int numDocsWithField;
        public DirectMonotonicReader.Meta addressesMeta;
        private long addressesOffset;
        private long addressesLength;

        public final int getNumDocsWithField() {
            return this.numDocsWithField;
        }

        public final void setNumDocsWithField(int n) {
            this.numDocsWithField = n;
        }

        @NotNull
        public final DirectMonotonicReader.Meta getAddressesMeta() {
            DirectMonotonicReader.Meta meta = this.addressesMeta;
            if (meta != null) {
                return meta;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"addressesMeta");
            return null;
        }

        public final void setAddressesMeta(@NotNull DirectMonotonicReader.Meta meta) {
            Intrinsics.checkNotNullParameter((Object)meta, (String)"<set-?>");
            this.addressesMeta = meta;
        }

        public final long getAddressesOffset() {
            return this.addressesOffset;
        }

        public final void setAddressesOffset(long l) {
            this.addressesOffset = l;
        }

        public final long getAddressesLength() {
            return this.addressesLength;
        }

        public final void setAddressesLength(long l) {
            this.addressesLength = l;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$SortedSetEntry;", "", "<init>", "()V", "singleValueEntry", "Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$SortedEntry;", "getSingleValueEntry", "()Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$SortedEntry;", "setSingleValueEntry", "(Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$SortedEntry;)V", "ordsEntry", "Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$SortedNumericEntry;", "getOrdsEntry", "()Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$SortedNumericEntry;", "setOrdsEntry", "(Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$SortedNumericEntry;)V", "termsDictEntry", "Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$TermsDictEntry;", "getTermsDictEntry", "()Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$TermsDictEntry;", "setTermsDictEntry", "(Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$TermsDictEntry;)V", "core"})
    private static final class SortedSetEntry {
        public SortedEntry singleValueEntry;
        public SortedNumericEntry ordsEntry;
        public TermsDictEntry termsDictEntry;

        @NotNull
        public final SortedEntry getSingleValueEntry() {
            SortedEntry sortedEntry = this.singleValueEntry;
            if (sortedEntry != null) {
                return sortedEntry;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"singleValueEntry");
            return null;
        }

        public final void setSingleValueEntry(@NotNull SortedEntry sortedEntry) {
            Intrinsics.checkNotNullParameter((Object)sortedEntry, (String)"<set-?>");
            this.singleValueEntry = sortedEntry;
        }

        @NotNull
        public final SortedNumericEntry getOrdsEntry() {
            SortedNumericEntry sortedNumericEntry = this.ordsEntry;
            if (sortedNumericEntry != null) {
                return sortedNumericEntry;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"ordsEntry");
            return null;
        }

        public final void setOrdsEntry(@NotNull SortedNumericEntry sortedNumericEntry) {
            Intrinsics.checkNotNullParameter((Object)sortedNumericEntry, (String)"<set-?>");
            this.ordsEntry = sortedNumericEntry;
        }

        @NotNull
        public final TermsDictEntry getTermsDictEntry() {
            TermsDictEntry termsDictEntry = this.termsDictEntry;
            if (termsDictEntry != null) {
                return termsDictEntry;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"termsDictEntry");
            return null;
        }

        public final void setTermsDictEntry(@NotNull TermsDictEntry termsDictEntry) {
            Intrinsics.checkNotNullParameter((Object)termsDictEntry, (String)"<set-?>");
            this.termsDictEntry = termsDictEntry;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\"\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$SparseBinaryDocValues;", "Lorg/gnit/lucenekmp/index/BinaryDocValues;", "disi", "Lorg/gnit/lucenekmp/codecs/lucene90/IndexedDISI;", "<init>", "(Lorg/gnit/lucenekmp/codecs/lucene90/IndexedDISI;)V", "getDisi", "()Lorg/gnit/lucenekmp/codecs/lucene90/IndexedDISI;", "nextDoc", "", "docID", "cost", "", "advance", "target", "advanceExact", "", "core"})
    private static abstract class SparseBinaryDocValues
    extends BinaryDocValues {
        @NotNull
        private final IndexedDISI disi;

        public SparseBinaryDocValues(@NotNull IndexedDISI disi) {
            Intrinsics.checkNotNullParameter((Object)disi, (String)"disi");
            this.disi = disi;
        }

        @NotNull
        public final IndexedDISI getDisi() {
            return this.disi;
        }

        @Override
        public int nextDoc() throws IOException {
            return this.disi.nextDoc();
        }

        @Override
        public int docID() {
            return this.disi.docID();
        }

        @Override
        public long cost() {
            return this.disi.cost();
        }

        @Override
        public int advance(int target) throws IOException {
            return this.disi.advance(target);
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            return this.disi.advanceExact(target);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\"\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\tH\u0016J\b\u0010\r\u001a\u00020\tH\u0016J\b\u0010\u000e\u001a\u00020\tH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$SparseNumericDocValues;", "Lorg/gnit/lucenekmp/index/NumericDocValues;", "disi", "Lorg/gnit/lucenekmp/codecs/lucene90/IndexedDISI;", "<init>", "(Lorg/gnit/lucenekmp/codecs/lucene90/IndexedDISI;)V", "getDisi", "()Lorg/gnit/lucenekmp/codecs/lucene90/IndexedDISI;", "advance", "", "target", "advanceExact", "", "nextDoc", "docID", "cost", "", "core"})
    private static abstract class SparseNumericDocValues
    extends NumericDocValues {
        @NotNull
        private final IndexedDISI disi;

        public SparseNumericDocValues(@NotNull IndexedDISI disi) {
            Intrinsics.checkNotNullParameter((Object)disi, (String)"disi");
            this.disi = disi;
        }

        @NotNull
        public final IndexedDISI getDisi() {
            return this.disi;
        }

        @Override
        public int advance(int target) throws IOException {
            return this.disi.advance(target);
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            return this.disi.advanceExact(target);
        }

        @Override
        public int nextDoc() throws IOException {
            return this.disi.nextDoc();
        }

        @Override
        public int docID() {
            return this.disi.docID();
        }

        @Override
        public long cost() {
            return this.disi.cost();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010/\u001a\u0004\u0018\u00010\u001cH\u0016J\u0010\u00100\u001a\u0002012\u0006\u0010%\u001a\u00020\u0012H\u0016J\u000e\u00102\u001a\u00020\u001c2\u0006\u00103\u001a\u00020\u0012J\u000e\u00104\u001a\u00020\u00122\u0006\u00105\u001a\u00020\u001cJ\u000e\u00106\u001a\u00020\u001c2\u0006\u00107\u001a\u00020\u0012J\u000e\u00108\u001a\u00020\u00122\u0006\u00105\u001a\u00020\u001cJ\u0010\u00109\u001a\u00020:2\u0006\u00105\u001a\u00020\u001cH\u0016J\u0006\u0010;\u001a\u000201J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010%\u001a\u00020\u0012H\u0016J\b\u0010<\u001a\u00020\u0012H\u0016J\u001a\u0010=\u001a\u00020>2\b\u0010?\u001a\u0004\u0018\u00010>2\u0006\u0010@\u001a\u00020AH\u0016J\u0010\u0010B\u001a\u00020C2\u0006\u0010@\u001a\u00020AH\u0016J\b\u0010D\u001a\u00020AH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\rR\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001eR\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0014\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u0014\"\u0004\b+\u0010(R\u001a\u0010,\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u0014\"\u0004\b.\u0010(\u00a8\u0006E"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$TermsDict;", "Lorg/gnit/lucenekmp/index/BaseTermsEnum;", "entry", "Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$TermsDictEntry;", "data", "Lorg/gnit/lucenekmp/store/IndexInput;", "<init>", "(Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer;Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$TermsDictEntry;Lorg/gnit/lucenekmp/store/IndexInput;)V", "getEntry", "()Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$TermsDictEntry;", "blockAddresses", "Lorg/gnit/lucenekmp/util/LongValues;", "getBlockAddresses", "()Lorg/gnit/lucenekmp/util/LongValues;", "bytes", "getBytes", "()Lorg/gnit/lucenekmp/store/IndexInput;", "blockMask", "", "getBlockMask", "()J", "indexAddresses", "getIndexAddresses", "indexBytes", "Lorg/gnit/lucenekmp/store/RandomAccessInput;", "getIndexBytes", "()Lorg/gnit/lucenekmp/store/RandomAccessInput;", "term", "Lorg/gnit/lucenekmp/util/BytesRef;", "getTerm", "()Lorg/gnit/lucenekmp/util/BytesRef;", "blockBuffer", "getBlockBuffer", "blockInput", "Lorg/gnit/lucenekmp/store/ByteArrayDataInput;", "getBlockInput", "()Lorg/gnit/lucenekmp/store/ByteArrayDataInput;", "ord", "getOrd", "setOrd", "(J)V", "currentCompressedBlockStart", "getCurrentCompressedBlockStart", "setCurrentCompressedBlockStart", "currentCompressedBlockEnd", "getCurrentCompressedBlockEnd", "setCurrentCompressedBlockEnd", "next", "seekExact", "", "getTermFromIndex", "index", "seekTermsIndex", "text", "getFirstTermFromBlock", "block", "seekBlock", "seekCeil", "Lorg/gnit/lucenekmp/index/TermsEnum$SeekStatus;", "decompressBlock", "totalTermFreq", "postings", "Lorg/gnit/lucenekmp/index/PostingsEnum;", "reuse", "flags", "", "impacts", "Lorg/gnit/lucenekmp/index/ImpactsEnum;", "docFreq", "core"})
    private final class TermsDict
    extends BaseTermsEnum {
        @NotNull
        private final TermsDictEntry entry;
        @NotNull
        private final LongValues blockAddresses;
        @NotNull
        private final IndexInput bytes;
        private final long blockMask;
        @NotNull
        private final LongValues indexAddresses;
        @NotNull
        private final RandomAccessInput indexBytes;
        @NotNull
        private final BytesRef term;
        @NotNull
        private final BytesRef blockBuffer;
        @NotNull
        private final ByteArrayDataInput blockInput;
        private long ord;
        private long currentCompressedBlockStart;
        private long currentCompressedBlockEnd;

        public TermsDict(@NotNull TermsDictEntry entry, IndexInput data) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.entry = entry;
            this.ord = -1L;
            this.currentCompressedBlockStart = -1L;
            this.currentCompressedBlockEnd = -1L;
            RandomAccessInput addressesSlice = data.randomAccessSlice(this.entry.getTermsAddressesOffset(), this.entry.getTermsAddressesLength());
            this.blockAddresses = DirectMonotonicReader.Companion.getInstance(this.entry.getTermsAddressesMeta(), addressesSlice, Lucene90DocValuesProducer.this.merging);
            this.bytes = data.slice("terms", this.entry.getTermsDataOffset(), this.entry.getTermsDataLength());
            this.blockMask = 63L;
            RandomAccessInput indexAddressesSlice = data.randomAccessSlice(this.entry.getTermsIndexAddressesOffset(), this.entry.getTermsIndexAddressesLength());
            this.indexAddresses = DirectMonotonicReader.Companion.getInstance(this.entry.getTermsIndexAddressesMeta(), indexAddressesSlice, Lucene90DocValuesProducer.this.merging);
            this.indexBytes = data.randomAccessSlice(this.entry.getTermsIndexOffset(), this.entry.getTermsIndexLength());
            this.term = new BytesRef(this.entry.getMaxTermLength());
            int bufferSize = this.entry.getMaxBlockLength() + this.entry.getMaxTermLength() + Lucene90DocValuesProducer.this.getLZ4_DECOMPRESSOR_PADDING();
            this.blockBuffer = new BytesRef(new byte[bufferSize], 0, bufferSize);
            this.blockInput = new ByteArrayDataInput();
        }

        @NotNull
        public final TermsDictEntry getEntry() {
            return this.entry;
        }

        @NotNull
        public final LongValues getBlockAddresses() {
            return this.blockAddresses;
        }

        @NotNull
        public final IndexInput getBytes() {
            return this.bytes;
        }

        public final long getBlockMask() {
            return this.blockMask;
        }

        @NotNull
        public final LongValues getIndexAddresses() {
            return this.indexAddresses;
        }

        @NotNull
        public final RandomAccessInput getIndexBytes() {
            return this.indexBytes;
        }

        @NotNull
        public final BytesRef getTerm() {
            return this.term;
        }

        @NotNull
        public final BytesRef getBlockBuffer() {
            return this.blockBuffer;
        }

        @NotNull
        public final ByteArrayDataInput getBlockInput() {
            return this.blockInput;
        }

        public final long getOrd() {
            return this.ord;
        }

        public final void setOrd(long l) {
            this.ord = l;
        }

        public final long getCurrentCompressedBlockStart() {
            return this.currentCompressedBlockStart;
        }

        public final void setCurrentCompressedBlockStart(long l) {
            this.currentCompressedBlockStart = l;
        }

        public final long getCurrentCompressedBlockEnd() {
            return this.currentCompressedBlockEnd;
        }

        public final void setCurrentCompressedBlockEnd(long l) {
            this.currentCompressedBlockEnd = l;
        }

        @Override
        @Nullable
        public BytesRef next() throws IOException {
            ++this.ord;
            if (this.ord >= this.entry.getTermsDictSize()) {
                return null;
            }
            if ((this.ord & this.blockMask) == 0L) {
                this.decompressBlock();
            } else {
                DataInput input = this.blockInput;
                int token = ByteExtKt.toUnsignedInt(ByteCompanionObject.INSTANCE, input.readByte());
                int prefixLength = token & 0xF;
                int suffixLength = 1 + (token >>> 4);
                if (prefixLength == 15) {
                    prefixLength += input.readVInt();
                }
                if (suffixLength == 16) {
                    suffixLength += input.readVInt();
                }
                this.term.setLength(prefixLength + suffixLength);
                input.readBytes(this.term.getBytes(), prefixLength, suffixLength);
            }
            return this.term;
        }

        @Override
        public void seekExact(long ord) throws IOException {
            if (ord < 0L || ord >= this.entry.getTermsDictSize()) {
                throw new IndexOutOfBoundsException();
            }
            long currentBlockIndex = this.ord >> 6;
            long blockIndex = ord >> 6;
            if (ord < this.ord || blockIndex != currentBlockIndex) {
                long blockAddress = this.blockAddresses.get(blockIndex);
                this.bytes.seek(blockAddress);
                this.ord = (blockIndex << 6) - 1L;
            }
            while (this.ord < ord) {
                this.next();
            }
        }

        @NotNull
        public final BytesRef getTermFromIndex(long index) throws IOException {
            if (!(index >= 0L && index <= this.entry.getTermsDictSize() - 1L >>> this.entry.getTermsDictIndexShift())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            long start = this.indexAddresses.get(index);
            this.term.setLength((int)(this.indexAddresses.get(index + 1L) - start));
            this.indexBytes.readBytes(start, this.term.getBytes(), 0, this.term.getLength());
            return this.term;
        }

        public final long seekTermsIndex(@NotNull BytesRef text) throws IOException {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            long lo = 0L;
            long hi = this.entry.getTermsDictSize() - 1L >> this.entry.getTermsDictIndexShift();
            while (lo <= hi) {
                long mid = lo + hi >>> 1;
                this.getTermFromIndex(mid);
                int cmp = this.term.compareTo(text);
                if (cmp <= 0) {
                    lo = mid + 1L;
                    continue;
                }
                hi = mid - 1L;
            }
            if (!(hi < 0L || this.getTermFromIndex(hi).compareTo(text) <= 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(hi == this.entry.getTermsDictSize() - 1L >> this.entry.getTermsDictIndexShift() || this.getTermFromIndex(hi + 1L).compareTo(text) > 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(hi < 0L ^ this.entry.getTermsDictSize() > 0L)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            return hi;
        }

        @NotNull
        public final BytesRef getFirstTermFromBlock(long block2) throws IOException {
            if (!(block2 >= 0L && block2 <= this.entry.getTermsDictSize() - 1L >>> 6)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            long blockAddress = this.blockAddresses.get(block2);
            this.bytes.seek(blockAddress);
            this.term.setLength(this.bytes.readVInt());
            this.bytes.readBytes(this.term.getBytes(), 0, this.term.getLength());
            return this.term;
        }

        public final long seekBlock(@NotNull BytesRef text) throws IOException {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            long index = this.seekTermsIndex(text);
            if (index == -1L) {
                this.ord = 0L;
                return -2L;
            }
            long ordLo = index << this.entry.getTermsDictIndexShift();
            long ordHi = java.lang.Math.min(this.entry.getTermsDictSize(), ordLo + (1L << this.entry.getTermsDictIndexShift())) - 1L;
            long blockLo = ordLo >>> 6;
            long blockHi = ordHi >>> 6;
            while (blockLo <= blockHi) {
                long blockMid = blockLo + blockHi >>> 1;
                this.getFirstTermFromBlock(blockMid);
                int cmp = this.term.compareTo(text);
                if (cmp <= 0) {
                    blockLo = blockMid + 1L;
                    continue;
                }
                blockHi = blockMid - 1L;
            }
            if (!(blockHi < 0L || this.getFirstTermFromBlock(blockHi).compareTo(text) <= 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(blockHi == this.entry.getTermsDictSize() - 1L >>> 6 || this.getFirstTermFromBlock(blockHi + 1L).compareTo(text) > 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(this.entry.getTermsDictSize() > 0L)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            long block2 = java.lang.Math.max(blockHi, 0L);
            long blockAddress = this.blockAddresses.get(block2);
            this.ord = block2 << 6;
            this.bytes.seek(blockAddress);
            this.decompressBlock();
            return blockHi;
        }

        @Override
        @NotNull
        public TermsEnum.SeekStatus seekCeil(@NotNull BytesRef text) throws IOException {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            long block2 = this.seekBlock(text);
            if (block2 == -2L) {
                if (!(this.entry.getTermsDictSize() == 0L)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                return TermsEnum.SeekStatus.END;
            }
            if (block2 == -1L) {
                return TermsEnum.SeekStatus.NOT_FOUND;
            }
            do {
                int cmp;
                if ((cmp = this.term.compareTo(text)) == 0) {
                    return TermsEnum.SeekStatus.FOUND;
                }
                if (cmp <= 0) continue;
                return TermsEnum.SeekStatus.NOT_FOUND;
            } while (this.next() != null);
            return TermsEnum.SeekStatus.END;
        }

        public final void decompressBlock() throws IOException {
            this.term.setLength(this.bytes.readVInt());
            this.bytes.readBytes(this.term.getBytes(), 0, this.term.getLength());
            long offset = this.bytes.getFilePointer();
            if (offset < this.entry.getTermsDataLength() - 1L) {
                if (this.currentCompressedBlockStart != offset) {
                    this.blockBuffer.setOffset(this.term.getLength());
                    this.blockBuffer.setLength(this.bytes.readVInt());
                    ArraysKt.copyInto((byte[])this.term.getBytes(), (byte[])this.blockBuffer.getBytes(), (int)0, (int)0, (int)this.blockBuffer.getOffset());
                    LZ4.INSTANCE.decompress(this.bytes, this.blockBuffer.getLength(), this.blockBuffer.getBytes(), this.blockBuffer.getOffset());
                    this.currentCompressedBlockStart = offset;
                    this.currentCompressedBlockEnd = this.bytes.getFilePointer();
                } else {
                    this.bytes.seek(this.currentCompressedBlockEnd);
                }
                this.blockInput.reset(this.blockBuffer.getBytes(), this.blockBuffer.getOffset(), this.blockBuffer.getLength());
            }
        }

        @Override
        @NotNull
        public BytesRef term() throws IOException {
            return this.term;
        }

        @Override
        public long ord() throws IOException {
            return this.ord;
        }

        @Override
        public long totalTermFreq() throws IOException {
            return -1L;
        }

        @Override
        @NotNull
        public PostingsEnum postings(@Nullable PostingsEnum reuse, int flags) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public ImpactsEnum impacts(int flags) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int docFreq() throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b&\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0007\"\u0004\b\u0018\u0010\tR\u001a\u0010\u0019\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0007\"\u0004\b\u001b\u0010\tR\u001a\u0010\u001c\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0007\"\u0004\b\u001e\u0010\tR\u001a\u0010\u001f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0007\"\u0004\b!\u0010\tR\u001a\u0010\"\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0013\"\u0004\b$\u0010\u0015R\u001a\u0010%\u001a\u00020\u000bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\r\"\u0004\b'\u0010\u000fR\u001a\u0010(\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0007\"\u0004\b*\u0010\tR\u001a\u0010+\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u0007\"\u0004\b-\u0010\tR\u001a\u0010.\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u0007\"\u0004\b0\u0010\tR\u001a\u00101\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u0007\"\u0004\b3\u0010\tR\u001a\u00104\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010\u0013\"\u0004\b6\u0010\u0015\u00a8\u00067"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$TermsDictEntry;", "", "<init>", "()V", "termsDictSize", "", "getTermsDictSize", "()J", "setTermsDictSize", "(J)V", "termsAddressesMeta", "Lorg/gnit/lucenekmp/util/packed/DirectMonotonicReader$Meta;", "getTermsAddressesMeta", "()Lorg/gnit/lucenekmp/util/packed/DirectMonotonicReader$Meta;", "setTermsAddressesMeta", "(Lorg/gnit/lucenekmp/util/packed/DirectMonotonicReader$Meta;)V", "maxTermLength", "", "getMaxTermLength", "()I", "setMaxTermLength", "(I)V", "termsDataOffset", "getTermsDataOffset", "setTermsDataOffset", "termsDataLength", "getTermsDataLength", "setTermsDataLength", "termsAddressesOffset", "getTermsAddressesOffset", "setTermsAddressesOffset", "termsAddressesLength", "getTermsAddressesLength", "setTermsAddressesLength", "termsDictIndexShift", "getTermsDictIndexShift", "setTermsDictIndexShift", "termsIndexAddressesMeta", "getTermsIndexAddressesMeta", "setTermsIndexAddressesMeta", "termsIndexOffset", "getTermsIndexOffset", "setTermsIndexOffset", "termsIndexLength", "getTermsIndexLength", "setTermsIndexLength", "termsIndexAddressesOffset", "getTermsIndexAddressesOffset", "setTermsIndexAddressesOffset", "termsIndexAddressesLength", "getTermsIndexAddressesLength", "setTermsIndexAddressesLength", "maxBlockLength", "getMaxBlockLength", "setMaxBlockLength", "core"})
    private static final class TermsDictEntry {
        private long termsDictSize;
        public DirectMonotonicReader.Meta termsAddressesMeta;
        private int maxTermLength;
        private long termsDataOffset;
        private long termsDataLength;
        private long termsAddressesOffset;
        private long termsAddressesLength;
        private int termsDictIndexShift;
        public DirectMonotonicReader.Meta termsIndexAddressesMeta;
        private long termsIndexOffset;
        private long termsIndexLength;
        private long termsIndexAddressesOffset;
        private long termsIndexAddressesLength;
        private int maxBlockLength;

        public final long getTermsDictSize() {
            return this.termsDictSize;
        }

        public final void setTermsDictSize(long l) {
            this.termsDictSize = l;
        }

        @NotNull
        public final DirectMonotonicReader.Meta getTermsAddressesMeta() {
            DirectMonotonicReader.Meta meta = this.termsAddressesMeta;
            if (meta != null) {
                return meta;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"termsAddressesMeta");
            return null;
        }

        public final void setTermsAddressesMeta(@NotNull DirectMonotonicReader.Meta meta) {
            Intrinsics.checkNotNullParameter((Object)meta, (String)"<set-?>");
            this.termsAddressesMeta = meta;
        }

        public final int getMaxTermLength() {
            return this.maxTermLength;
        }

        public final void setMaxTermLength(int n) {
            this.maxTermLength = n;
        }

        public final long getTermsDataOffset() {
            return this.termsDataOffset;
        }

        public final void setTermsDataOffset(long l) {
            this.termsDataOffset = l;
        }

        public final long getTermsDataLength() {
            return this.termsDataLength;
        }

        public final void setTermsDataLength(long l) {
            this.termsDataLength = l;
        }

        public final long getTermsAddressesOffset() {
            return this.termsAddressesOffset;
        }

        public final void setTermsAddressesOffset(long l) {
            this.termsAddressesOffset = l;
        }

        public final long getTermsAddressesLength() {
            return this.termsAddressesLength;
        }

        public final void setTermsAddressesLength(long l) {
            this.termsAddressesLength = l;
        }

        public final int getTermsDictIndexShift() {
            return this.termsDictIndexShift;
        }

        public final void setTermsDictIndexShift(int n) {
            this.termsDictIndexShift = n;
        }

        @NotNull
        public final DirectMonotonicReader.Meta getTermsIndexAddressesMeta() {
            DirectMonotonicReader.Meta meta = this.termsIndexAddressesMeta;
            if (meta != null) {
                return meta;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"termsIndexAddressesMeta");
            return null;
        }

        public final void setTermsIndexAddressesMeta(@NotNull DirectMonotonicReader.Meta meta) {
            Intrinsics.checkNotNullParameter((Object)meta, (String)"<set-?>");
            this.termsIndexAddressesMeta = meta;
        }

        public final long getTermsIndexOffset() {
            return this.termsIndexOffset;
        }

        public final void setTermsIndexOffset(long l) {
            this.termsIndexOffset = l;
        }

        public final long getTermsIndexLength() {
            return this.termsIndexLength;
        }

        public final void setTermsIndexLength(long l) {
            this.termsIndexLength = l;
        }

        public final long getTermsIndexAddressesOffset() {
            return this.termsIndexAddressesOffset;
        }

        public final void setTermsIndexAddressesOffset(long l) {
            this.termsIndexAddressesOffset = l;
        }

        public final long getTermsIndexAddressesLength() {
            return this.termsIndexAddressesLength;
        }

        public final void setTermsIndexAddressesLength(long l) {
            this.termsIndexAddressesLength = l;
        }

        public final int getMaxBlockLength() {
            return this.maxBlockLength;
        }

        public final void setMaxBlockLength(int n) {
            this.maxBlockLength = n;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010+\u001a\u00020\u00132\u0006\u0010,\u001a\u00020\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\f\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011R\u001a\u0010\u0018\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0015\"\u0004\b\u001e\u0010\u001bR\u001a\u0010\u001f\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0015\"\u0004\b!\u0010\u001bR\u001a\u0010\"\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0015\"\u0004\b$\u0010\u001bR\u001c\u0010%\u001a\u0004\u0018\u00010&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*\u00a8\u0006-"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$VaryingBPVReader;", "", "entry", "Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$NumericEntry;", "slice", "Lorg/gnit/lucenekmp/store/RandomAccessInput;", "<init>", "(Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer;Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$NumericEntry;Lorg/gnit/lucenekmp/store/RandomAccessInput;)V", "getEntry", "()Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90DocValuesProducer$NumericEntry;", "getSlice", "()Lorg/gnit/lucenekmp/store/RandomAccessInput;", "rankSlice", "getRankSlice", "shift", "", "getShift", "()I", "mul", "", "getMul", "()J", "mask", "getMask", "block", "getBlock", "setBlock", "(J)V", "delta", "getDelta", "setDelta", "offset", "getOffset", "setOffset", "blockEndOffset", "getBlockEndOffset", "setBlockEndOffset", "values", "Lorg/gnit/lucenekmp/util/LongValues;", "getValues", "()Lorg/gnit/lucenekmp/util/LongValues;", "setValues", "(Lorg/gnit/lucenekmp/util/LongValues;)V", "getLongValue", "index", "core"})
    private final class VaryingBPVReader {
        @NotNull
        private final NumericEntry entry;
        @NotNull
        private final RandomAccessInput slice;
        @Nullable
        private final RandomAccessInput rankSlice;
        private final int shift;
        private final long mul;
        private final int mask;
        private long block;
        private long delta;
        private long offset;
        private long blockEndOffset;
        @Nullable
        private LongValues values;

        public VaryingBPVReader(@NotNull NumericEntry entry, RandomAccessInput slice) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            Intrinsics.checkNotNullParameter((Object)slice, (String)"slice");
            this.entry = entry;
            this.slice = slice;
            this.rankSlice = this.entry.getValueJumpTableOffset() == -1L ? null : Lucene90DocValuesProducer.this.data.randomAccessSlice(this.entry.getValueJumpTableOffset(), Lucene90DocValuesProducer.this.data.length() - this.entry.getValueJumpTableOffset());
            this.shift = this.entry.getBlockShift();
            this.mul = this.entry.getGcd();
            this.mask = (1 << this.shift) - 1;
            this.block = -1L;
            if (this.rankSlice != null && this.rankSlice.length() > 0L) {
                this.rankSlice.prefetch(0L, 1L);
            }
        }

        @NotNull
        public final NumericEntry getEntry() {
            return this.entry;
        }

        @NotNull
        public final RandomAccessInput getSlice() {
            return this.slice;
        }

        @Nullable
        public final RandomAccessInput getRankSlice() {
            return this.rankSlice;
        }

        public final int getShift() {
            return this.shift;
        }

        public final long getMul() {
            return this.mul;
        }

        public final int getMask() {
            return this.mask;
        }

        public final long getBlock() {
            return this.block;
        }

        public final void setBlock(long l) {
            this.block = l;
        }

        public final long getDelta() {
            return this.delta;
        }

        public final void setDelta(long l) {
            this.delta = l;
        }

        public final long getOffset() {
            return this.offset;
        }

        public final void setOffset(long l) {
            this.offset = l;
        }

        public final long getBlockEndOffset() {
            return this.blockEndOffset;
        }

        public final void setBlockEndOffset(long l) {
            this.blockEndOffset = l;
        }

        @Nullable
        public final LongValues getValues() {
            return this.values;
        }

        public final void setValues(@Nullable LongValues longValues) {
            this.values = longValues;
        }

        public final long getLongValue(long index) throws IOException {
            long block2 = index >>> this.shift;
            if (this.block != block2) {
                byte bitsPerValue = 0;
                do {
                    if (this.rankSlice != null && block2 != this.block + 1L) {
                        this.blockEndOffset = this.rankSlice.readLong(block2 * (long)8) - this.entry.getValuesOffset();
                        this.block = block2 - 1L;
                    }
                    long l = this.offset = this.blockEndOffset;
                    this.offset = l + 1L;
                    bitsPerValue = this.slice.readByte(l);
                    this.delta = this.slice.readLong(this.offset);
                    this.offset += 8L;
                    if (bitsPerValue == 0) {
                        this.blockEndOffset = this.offset;
                    } else {
                        int length = this.slice.readInt(this.offset);
                        this.offset += 4L;
                        this.blockEndOffset = this.offset + (long)length;
                    }
                    long length = this.block;
                    this.block = length + 1L;
                } while (this.block != block2);
                int numValues = Math.INSTANCE.toIntExact(java.lang.Math.min(1L << this.shift, this.entry.getNumValues() - (block2 << this.shift)));
                this.values = bitsPerValue == 0 ? LongValues.Companion.getZEROES() : Lucene90DocValuesProducer.this.getDirectReaderInstance(this.slice, bitsPerValue, this.offset, numValues);
            }
            LongValues longValues = this.values;
            Intrinsics.checkNotNull((Object)longValues);
            return this.mul * longValues.get(index & (long)this.mask) + this.delta;
        }
    }
}

