/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs.lucene90;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.codecs.CodecUtil;
import org.gnit.lucenekmp.codecs.NormsConsumer;
import org.gnit.lucenekmp.codecs.NormsProducer;
import org.gnit.lucenekmp.codecs.lucene90.IndexedDISI;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.IndexFileNames;
import org.gnit.lucenekmp.index.NumericDocValues;
import org.gnit.lucenekmp.index.SegmentWriteState;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.store.IndexOutput;
import org.gnit.lucenekmp.util.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0002J \u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020'2\u0006\u0010!\u001a\u00020\u00152\u0006\u0010(\u001a\u00020\fH\u0002R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006)"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90NormsConsumer;", "Lorg/gnit/lucenekmp/codecs/NormsConsumer;", "state", "Lorg/gnit/lucenekmp/index/SegmentWriteState;", "dataCodec", "", "dataExtension", "metaCodec", "metaExtension", "<init>", "(Lorg/gnit/lucenekmp/index/SegmentWriteState;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "data", "Lorg/gnit/lucenekmp/store/IndexOutput;", "getData", "()Lorg/gnit/lucenekmp/store/IndexOutput;", "setData", "(Lorg/gnit/lucenekmp/store/IndexOutput;)V", "meta", "getMeta", "setMeta", "maxDoc", "", "getMaxDoc", "()I", "setMaxDoc", "(I)V", "close", "", "addNormsField", "field", "Lorg/gnit/lucenekmp/index/FieldInfo;", "normsProducer", "Lorg/gnit/lucenekmp/codecs/NormsProducer;", "numBytesPerValue", "min", "", "max", "writeValues", "values", "Lorg/gnit/lucenekmp/index/NumericDocValues;", "out", "core"})
public final class Lucene90NormsConsumer
extends NormsConsumer {
    @Nullable
    private IndexOutput data;
    @Nullable
    private IndexOutput meta;
    private int maxDoc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lucene90NormsConsumer(@NotNull SegmentWriteState state2, @NotNull String dataCodec, @NotNull String dataExtension, @NotNull String metaCodec, @NotNull String metaExtension) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)dataCodec, (String)"dataCodec");
        Intrinsics.checkNotNullParameter((Object)dataExtension, (String)"dataExtension");
        Intrinsics.checkNotNullParameter((Object)metaCodec, (String)"metaCodec");
        Intrinsics.checkNotNullParameter((Object)metaExtension, (String)"metaExtension");
        boolean success = false;
        try {
            String dataName = IndexFileNames.INSTANCE.segmentFileName(state2.getSegmentInfo().getName(), state2.getSegmentSuffix(), dataExtension);
            IndexOutput indexOutput = this.data = state2.getDirectory().createOutput(dataName, state2.getContext());
            Intrinsics.checkNotNull((Object)indexOutput);
            CodecUtil.INSTANCE.writeIndexHeader(indexOutput, dataCodec, 0, state2.getSegmentInfo().getId(), state2.getSegmentSuffix());
            String metaName = IndexFileNames.INSTANCE.segmentFileName(state2.getSegmentInfo().getName(), state2.getSegmentSuffix(), metaExtension);
            IndexOutput indexOutput2 = this.meta = state2.getDirectory().createOutput(metaName, state2.getContext());
            Intrinsics.checkNotNull((Object)indexOutput2);
            CodecUtil.INSTANCE.writeIndexHeader(indexOutput2, metaCodec, 0, state2.getSegmentInfo().getId(), state2.getSegmentSuffix());
            this.maxDoc = state2.getSegmentInfo().maxDoc();
            success = true;
        }
        catch (Throwable throwable) {
            AutoCloseable[] autoCloseableArray = new AutoCloseable[]{this};
            IOUtils.INSTANCE.closeWhileHandlingException(autoCloseableArray);
            throw throwable;
        }
    }

    @Nullable
    public final IndexOutput getData() {
        return this.data;
    }

    public final void setData(@Nullable IndexOutput indexOutput) {
        this.data = indexOutput;
    }

    @Nullable
    public final IndexOutput getMeta() {
        return this.meta;
    }

    public final void setMeta(@Nullable IndexOutput indexOutput) {
        this.meta = indexOutput;
    }

    public final int getMaxDoc() {
        return this.maxDoc;
    }

    public final void setMaxDoc(int n) {
        this.maxDoc = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        boolean success = false;
        try {
            if (this.meta != null) {
                IndexOutput indexOutput = this.meta;
                if (indexOutput != null) {
                    indexOutput.writeInt(-1);
                }
                IndexOutput indexOutput2 = this.meta;
                Intrinsics.checkNotNull((Object)indexOutput2);
                CodecUtil.INSTANCE.writeFooter(indexOutput2);
            }
            if (this.data != null) {
                IndexOutput indexOutput = this.data;
                Intrinsics.checkNotNull((Object)indexOutput);
                CodecUtil.INSTANCE.writeFooter(indexOutput);
            }
            success = true;
        }
        catch (Throwable throwable) {
            AutoCloseable[] autoCloseableArray = new AutoCloseable[2];
            Intrinsics.checkNotNull((Object)this.data);
            Intrinsics.checkNotNull((Object)this.meta);
            IOUtils.INSTANCE.closeWhileHandlingException(autoCloseableArray);
            this.meta = this.data = null;
            throw throwable;
        }
        AutoCloseable[] autoCloseableArray = new AutoCloseable[2];
        Intrinsics.checkNotNull((Object)this.data);
        Intrinsics.checkNotNull((Object)this.meta);
        IOUtils.INSTANCE.close(autoCloseableArray);
        this.meta = this.data = null;
    }

    @Override
    public void addNormsField(@NotNull FieldInfo field, @NotNull NormsProducer normsProducer) throws IOException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)normsProducer, (String)"normsProducer");
        NumericDocValues values2 = normsProducer.getNorms(field);
        int numDocsWithValue = 0;
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        int doc = values2.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            ++numDocsWithValue;
            long v = values2.longValue();
            min = Math.min(min, v);
            max = Math.max(max, v);
            doc = values2.nextDoc();
        }
        if (!(numDocsWithValue <= this.maxDoc)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        IndexOutput indexOutput = this.meta;
        if (indexOutput != null) {
            indexOutput.writeInt(field.getNumber());
        }
        if (numDocsWithValue == 0) {
            IndexOutput indexOutput2 = this.meta;
            if (indexOutput2 != null) {
                indexOutput2.writeLong(-2L);
            }
            IndexOutput indexOutput3 = this.meta;
            if (indexOutput3 != null) {
                indexOutput3.writeLong(0L);
            }
            IndexOutput indexOutput4 = this.meta;
            if (indexOutput4 != null) {
                indexOutput4.writeShort((short)-1);
            }
            IndexOutput indexOutput5 = this.meta;
            if (indexOutput5 != null) {
                indexOutput5.writeByte((byte)-1);
            }
        } else if (numDocsWithValue == this.maxDoc) {
            IndexOutput indexOutput6 = this.meta;
            if (indexOutput6 != null) {
                indexOutput6.writeLong(-1L);
            }
            IndexOutput indexOutput7 = this.meta;
            if (indexOutput7 != null) {
                indexOutput7.writeLong(0L);
            }
            IndexOutput indexOutput8 = this.meta;
            if (indexOutput8 != null) {
                indexOutput8.writeShort((short)-1);
            }
            IndexOutput indexOutput9 = this.meta;
            if (indexOutput9 != null) {
                indexOutput9.writeByte((byte)-1);
            }
        } else {
            IndexOutput indexOutput10 = this.data;
            Intrinsics.checkNotNull((Object)indexOutput10);
            long offset = indexOutput10.getFilePointer();
            IndexOutput indexOutput11 = this.meta;
            if (indexOutput11 != null) {
                indexOutput11.writeLong(offset);
            }
            values2 = normsProducer.getNorms(field);
            DocIdSetIterator docIdSetIterator = values2;
            IndexOutput indexOutput12 = this.data;
            Intrinsics.checkNotNull((Object)indexOutput12);
            short jumpTableEntryCount = IndexedDISI.Companion.writeBitSet(docIdSetIterator, indexOutput12, (byte)9);
            IndexOutput indexOutput13 = this.meta;
            if (indexOutput13 != null) {
                IndexOutput indexOutput14 = this.data;
                Intrinsics.checkNotNull((Object)indexOutput14);
                indexOutput13.writeLong(indexOutput14.getFilePointer() - offset);
            }
            IndexOutput indexOutput15 = this.meta;
            if (indexOutput15 != null) {
                indexOutput15.writeShort(jumpTableEntryCount);
            }
            IndexOutput indexOutput16 = this.meta;
            if (indexOutput16 != null) {
                indexOutput16.writeByte((byte)9);
            }
        }
        IndexOutput indexOutput17 = this.meta;
        if (indexOutput17 != null) {
            indexOutput17.writeInt(numDocsWithValue);
        }
        int numBytesPerValue = this.numBytesPerValue(min, max);
        IndexOutput indexOutput18 = this.meta;
        if (indexOutput18 != null) {
            indexOutput18.writeByte((byte)numBytesPerValue);
        }
        if (numBytesPerValue == 0) {
            IndexOutput indexOutput19 = this.meta;
            if (indexOutput19 != null) {
                indexOutput19.writeLong(min);
            }
        } else {
            IndexOutput indexOutput20 = this.meta;
            if (indexOutput20 != null) {
                IndexOutput indexOutput21 = this.data;
                Intrinsics.checkNotNull((Object)indexOutput21);
                indexOutput20.writeLong(indexOutput21.getFilePointer());
            }
            values2 = normsProducer.getNorms(field);
            IndexOutput indexOutput22 = this.data;
            Intrinsics.checkNotNull((Object)indexOutput22);
            this.writeValues(values2, numBytesPerValue, indexOutput22);
        }
    }

    private final int numBytesPerValue(long min, long max) {
        return min >= max ? 0 : (min >= -128L && max <= 127L ? 1 : (min >= -32768L && max <= 32767L ? 2 : (min >= Integer.MIN_VALUE && max <= Integer.MAX_VALUE ? 4 : 8)));
    }

    private final void writeValues(NumericDocValues values2, int numBytesPerValue, IndexOutput out) throws IOException, AssertionError {
        int doc = values2.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            long value = values2.longValue();
            switch (numBytesPerValue) {
                case 1: {
                    out.writeByte((byte)value);
                    break;
                }
                case 2: {
                    out.writeShort((short)value);
                    break;
                }
                case 4: {
                    out.writeInt((int)value);
                    break;
                }
                case 8: {
                    out.writeLong(value);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            doc = values2.nextDoc();
        }
    }
}

