/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs.lucene90;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.codecs.CodecUtil;
import org.gnit.lucenekmp.codecs.NormsProducer;
import org.gnit.lucenekmp.codecs.lucene90.IndexedDISI;
import org.gnit.lucenekmp.index.CorruptIndexException;
import org.gnit.lucenekmp.index.DocValues;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.FieldInfos;
import org.gnit.lucenekmp.index.IndexFileNames;
import org.gnit.lucenekmp.index.NumericDocValues;
import org.gnit.lucenekmp.index.SegmentReadState;
import org.gnit.lucenekmp.internal.hppc.IntObjectHashMap;
import org.gnit.lucenekmp.jdkport.Cloneable;
import org.gnit.lucenekmp.store.ChecksumIndexInput;
import org.gnit.lucenekmp.store.IndexInput;
import org.gnit.lucenekmp.store.RandomAccessInput;
import org.gnit.lucenekmp.store.ReadAdvice;
import org.gnit.lucenekmp.util.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0003-./B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u000eH\u0002J\u0018\u0010%\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u000eH\u0002J\u0018\u0010&\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u000eH\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010)\u001a\u00020\u001dH\u0016J\b\u0010*\u001a\u00020\u001dH\u0016J\b\u0010+\u001a\u00020\u0006H\u0016J\b\u0010,\u001a\u00020\u0000H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u00060"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90NormsProducer;", "Lorg/gnit/lucenekmp/codecs/NormsProducer;", "Lorg/gnit/lucenekmp/jdkport/Cloneable;", "state", "Lorg/gnit/lucenekmp/index/SegmentReadState;", "dataCodec", "", "dataExtension", "metaCodec", "metaExtension", "<init>", "(Lorg/gnit/lucenekmp/index/SegmentReadState;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "norms", "Lorg/gnit/lucenekmp/internal/hppc/IntObjectHashMap;", "Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90NormsProducer$NormsEntry;", "maxDoc", "", "data", "Lorg/gnit/lucenekmp/store/IndexInput;", "merging", "", "disiInputs", "disiJumpTables", "Lorg/gnit/lucenekmp/store/RandomAccessInput;", "dataInputs", "mergeInstance", "getMergeInstance", "()Lorg/gnit/lucenekmp/codecs/NormsProducer;", "readFields", "", "meta", "infos", "Lorg/gnit/lucenekmp/index/FieldInfos;", "getDataInput", "field", "Lorg/gnit/lucenekmp/index/FieldInfo;", "entry", "getDisiInput", "getDisiJumpTable", "getNorms", "Lorg/gnit/lucenekmp/index/NumericDocValues;", "close", "checkIntegrity", "toString", "clone", "NormsEntry", "DenseNormsIterator", "SparseNormsIterator", "core"})
@SourceDebugExtension(value={"SMAP\nLucene90NormsProducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Lucene90NormsProducer.kt\norg/gnit/lucenekmp/codecs/lucene90/Lucene90NormsProducer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,507:1\n1869#2,2:508\n1869#2,2:510\n1869#2,2:512\n1869#2,2:514\n*S KotlinDebug\n*F\n+ 1 Lucene90NormsProducer.kt\norg/gnit/lucenekmp/codecs/lucene90/Lucene90NormsProducer\n*L\n472#1:508,2\n482#1:510,2\n490#1:512,2\n498#1:514,2\n*E\n"})
public final class Lucene90NormsProducer
extends NormsProducer
implements Cloneable<Lucene90NormsProducer> {
    @NotNull
    private final SegmentReadState state;
    @NotNull
    private final String dataCodec;
    @NotNull
    private final String dataExtension;
    @NotNull
    private final String metaCodec;
    @NotNull
    private final String metaExtension;
    @NotNull
    private final IntObjectHashMap<NormsEntry> norms;
    private final int maxDoc;
    @NotNull
    private IndexInput data;
    private boolean merging;
    @Nullable
    private IntObjectHashMap<IndexInput> disiInputs;
    @Nullable
    private IntObjectHashMap<RandomAccessInput> disiJumpTables;
    @Nullable
    private IntObjectHashMap<RandomAccessInput> dataInputs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lucene90NormsProducer(@NotNull SegmentReadState state2, @NotNull String dataCodec, @NotNull String dataExtension, @NotNull String metaCodec, @NotNull String metaExtension) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)dataCodec, (String)"dataCodec");
        Intrinsics.checkNotNullParameter((Object)dataExtension, (String)"dataExtension");
        Intrinsics.checkNotNullParameter((Object)metaCodec, (String)"metaCodec");
        Intrinsics.checkNotNullParameter((Object)metaExtension, (String)"metaExtension");
        this.state = state2;
        this.dataCodec = dataCodec;
        this.dataExtension = dataExtension;
        this.metaCodec = metaCodec;
        this.metaExtension = metaExtension;
        this.norms = new IntObjectHashMap();
        this.maxDoc = this.state.getSegmentInfo().maxDoc();
        String metaName = IndexFileNames.INSTANCE.segmentFileName(this.state.getSegmentInfo().getName(), this.state.getSegmentSuffix(), this.metaExtension);
        int version = 0;
        version = -1;
        AutoCloseable autoCloseable = this.state.getDirectory().openChecksumInput(metaName);
        Throwable throwable = null;
        try {
            ChecksumIndexInput in = (ChecksumIndexInput)autoCloseable;
            boolean bl = false;
            Throwable priorE = null;
            try {
                version = CodecUtil.INSTANCE.checkIndexHeader(in, this.metaCodec, 0, 0, this.state.getSegmentInfo().getId(), this.state.getSegmentSuffix());
                this.readFields(in, this.state.getFieldInfos());
            }
            catch (Throwable exception) {
                priorE = exception;
            }
            finally {
                CodecUtil.INSTANCE.checkFooter(in, priorE);
            }
            in = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        String dataName = IndexFileNames.INSTANCE.segmentFileName(this.state.getSegmentInfo().getName(), this.state.getSegmentSuffix(), this.dataExtension);
        this.data = this.state.getDirectory().openInput(dataName, this.state.getContext().withReadAdvice(ReadAdvice.NORMAL));
        boolean success = false;
        try {
            int version2 = CodecUtil.INSTANCE.checkIndexHeader(this.data, this.dataCodec, 0, 0, this.state.getSegmentInfo().getId(), this.state.getSegmentSuffix());
            if (version != version2) {
                throw new CorruptIndexException("Format versions mismatch: meta=" + version + ",data=" + version2, this.data);
            }
            CodecUtil.INSTANCE.retrieveChecksum(this.data);
            success = true;
        }
        catch (Throwable throwable3) {
            AutoCloseable[] autoCloseableArray = new AutoCloseable[]{this.data};
            IOUtils.INSTANCE.closeWhileHandlingException(autoCloseableArray);
            throw throwable3;
        }
    }

    @Override
    @NotNull
    public NormsProducer getMergeInstance() {
        Lucene90NormsProducer clone = null;
        try {
            clone = this.clone();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        clone.data = this.data.clone();
        clone.disiInputs = new IntObjectHashMap();
        clone.disiJumpTables = new IntObjectHashMap();
        clone.dataInputs = new IntObjectHashMap();
        clone.merging = true;
        return clone;
    }

    private final void readFields(IndexInput meta, FieldInfos infos) throws IOException {
        int fieldNumber = meta.readInt();
        while (fieldNumber != -1) {
            FieldInfo info = infos.fieldInfo(fieldNumber);
            if (info == null) {
                throw new CorruptIndexException("Invalid field number: " + fieldNumber, meta);
            }
            if (!info.hasNorms()) {
                throw new CorruptIndexException("Invalid field: " + info.getName(), meta);
            }
            NormsEntry entry = new NormsEntry();
            entry.setDocsWithFieldOffset(meta.readLong());
            entry.setDocsWithFieldLength(meta.readLong());
            entry.setJumpTableEntryCount(meta.readShort());
            entry.setDenseRankPower(meta.readByte());
            entry.setNumDocsWithField(meta.readInt());
            entry.setBytesPerNorm(meta.readByte());
            byte by = entry.getBytesPerNorm();
            if (by != 0 && by != 1 && by != 2 && by != 4 && by != 8) {
                throw new CorruptIndexException("Invalid bytesPerValue: " + entry.getBytesPerNorm() + ", field: " + info.getName(), meta);
            }
            entry.setNormsOffset(meta.readLong());
            this.norms.put(info.getNumber(), entry);
            fieldNumber = meta.readInt();
        }
    }

    private final RandomAccessInput getDataInput(FieldInfo field, NormsEntry entry) throws IOException {
        RandomAccessInput slice = null;
        if (this.merging) {
            IntObjectHashMap<RandomAccessInput> intObjectHashMap = this.dataInputs;
            Intrinsics.checkNotNull(intObjectHashMap);
            slice = intObjectHashMap.get(field.getNumber());
        }
        if (slice == null) {
            slice = this.data.randomAccessSlice(entry.getNormsOffset(), (long)entry.getNumDocsWithField() * (long)entry.getBytesPerNorm());
            if (this.merging) {
                IntObjectHashMap<RandomAccessInput> intObjectHashMap = this.dataInputs;
                Intrinsics.checkNotNull(intObjectHashMap);
                intObjectHashMap.put(field.getNumber(), slice);
            }
            if (slice.length() > 0L) {
                slice.prefetch(0L, 1L);
            }
        }
        return slice;
    }

    private final IndexInput getDisiInput(FieldInfo field, NormsEntry entry) throws IOException {
        if (!this.merging) {
            return IndexedDISI.Companion.createBlockSlice(this.data, "docs", entry.getDocsWithFieldOffset(), entry.getDocsWithFieldLength(), entry.getJumpTableEntryCount());
        }
        IntObjectHashMap<IndexInput> intObjectHashMap = this.disiInputs;
        Intrinsics.checkNotNull(intObjectHashMap);
        IndexInput in = intObjectHashMap.get(field.getNumber());
        if (in == null) {
            in = IndexedDISI.Companion.createBlockSlice(this.data, "docs", entry.getDocsWithFieldOffset(), entry.getDocsWithFieldLength(), entry.getJumpTableEntryCount());
            IntObjectHashMap<IndexInput> intObjectHashMap2 = this.disiInputs;
            Intrinsics.checkNotNull(intObjectHashMap2);
            intObjectHashMap2.put(field.getNumber(), in);
        }
        IndexInput inF = in;
        return new IndexInput(inF){
            private long filePointer;
            final /* synthetic */ IndexInput $inF;
            {
                this.$inF = $inF;
                super("docs");
            }

            public long getFilePointer() {
                return this.filePointer;
            }

            public void setFilePointer(long l) {
                this.filePointer = l;
            }

            public void readBytes(byte[] b, int off, int len) throws IOException {
                Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                this.$inF.seek(this.getFilePointer());
                this.setFilePointer(this.getFilePointer() + (long)len);
                this.$inF.readBytes(b, off, len);
            }

            public byte readByte() throws IOException {
                throw new UnsupportedOperationException("Unused by IndexedDISI");
            }

            public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
                Intrinsics.checkNotNullParameter((Object)sliceDescription, (String)"sliceDescription");
                throw new UnsupportedOperationException("Unused by IndexedDISI");
            }

            public short readShort() throws IOException {
                this.$inF.seek(this.getFilePointer());
                this.setFilePointer(this.getFilePointer() + 2L);
                return this.$inF.readShort();
            }

            public long readLong() throws IOException {
                this.$inF.seek(this.getFilePointer());
                this.setFilePointer(this.getFilePointer() + 8L);
                return this.$inF.readLong();
            }

            public void seek(long pos) throws IOException {
                this.setFilePointer(pos);
            }

            public long length() {
                return this.$inF.length();
            }

            public void close() throws IOException {
                throw new UnsupportedOperationException("Unused by IndexedDISI");
            }

            public void prefetch(long offset, long length) throws IOException {
            }
        };
    }

    private final RandomAccessInput getDisiJumpTable(FieldInfo field, NormsEntry entry) throws IOException {
        RandomAccessInput jumpTable = null;
        if (this.merging) {
            IntObjectHashMap<RandomAccessInput> intObjectHashMap = this.disiJumpTables;
            Intrinsics.checkNotNull(intObjectHashMap);
            jumpTable = intObjectHashMap.get(field.getNumber());
        }
        if (jumpTable == null) {
            jumpTable = IndexedDISI.Companion.createJumpTable(this.data, entry.getDocsWithFieldOffset(), entry.getDocsWithFieldLength(), entry.getJumpTableEntryCount());
            if (this.merging) {
                IntObjectHashMap<RandomAccessInput> intObjectHashMap = this.disiJumpTables;
                Intrinsics.checkNotNull(intObjectHashMap);
                intObjectHashMap.put(field.getNumber(), jumpTable);
            }
        }
        RandomAccessInput randomAccessInput = jumpTable;
        Intrinsics.checkNotNull(randomAccessInput);
        return randomAccessInput;
    }

    @Override
    @NotNull
    public NumericDocValues getNorms(@NotNull FieldInfo field) throws IOException {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        NormsEntry normsEntry = this.norms.get(field.getNumber());
        Intrinsics.checkNotNull((Object)normsEntry);
        NormsEntry entry = normsEntry;
        if (entry.getDocsWithFieldOffset() == -2L) {
            return DocValues.INSTANCE.emptyNumeric();
        }
        if (entry.getDocsWithFieldOffset() == -1L) {
            if (entry.getBytesPerNorm() == 0) {
                int n = this.maxDoc;
                return new DenseNormsIterator(entry, n){
                    final /* synthetic */ NormsEntry $entry;
                    {
                        this.$entry = $entry;
                        super($super_call_param$1);
                    }

                    public long longValue() throws IOException {
                        return this.$entry.getNormsOffset();
                    }
                };
            }
            RandomAccessInput slice = this.getDataInput(field, entry);
            byte by = entry.getBytesPerNorm();
            if (by == 1) {
                int n = this.maxDoc;
                return new DenseNormsIterator(slice, n){
                    final /* synthetic */ RandomAccessInput $slice;
                    {
                        this.$slice = $slice;
                        super($super_call_param$1);
                    }

                    public long longValue() throws IOException {
                        return this.$slice.readByte(this.getDoc());
                    }
                };
            }
            if (by == 2) {
                int n = this.maxDoc;
                return new DenseNormsIterator(slice, n){
                    final /* synthetic */ RandomAccessInput $slice;
                    {
                        this.$slice = $slice;
                        super($super_call_param$1);
                    }

                    public long longValue() throws IOException {
                        return this.$slice.readShort((long)this.getDoc() << 1);
                    }
                };
            }
            if (by == 4) {
                int n = this.maxDoc;
                return new DenseNormsIterator(slice, n){
                    final /* synthetic */ RandomAccessInput $slice;
                    {
                        this.$slice = $slice;
                        super($super_call_param$1);
                    }

                    public long longValue() throws IOException {
                        return this.$slice.readInt((long)this.getDoc() << 2);
                    }
                };
            }
            if (by == 8) {
                int n = this.maxDoc;
                return new DenseNormsIterator(slice, n){
                    final /* synthetic */ RandomAccessInput $slice;
                    {
                        this.$slice = $slice;
                        super($super_call_param$1);
                    }

                    public long longValue() throws IOException {
                        return this.$slice.readLong((long)this.getDoc() << 3);
                    }
                };
            }
            throw new AssertionError();
        }
        IndexInput disiInput = this.getDisiInput(field, entry);
        RandomAccessInput disiJumpTable = this.getDisiJumpTable(field, entry);
        IndexedDISI disi = new IndexedDISI(disiInput, disiJumpTable, entry.getJumpTableEntryCount(), entry.getDenseRankPower(), entry.getNumDocsWithField());
        if (entry.getBytesPerNorm() == 0) {
            return new SparseNormsIterator(disi, entry){
                final /* synthetic */ NormsEntry $entry;
                {
                    this.$entry = $entry;
                    super($disi);
                }

                public long longValue() throws IOException {
                    return this.$entry.getNormsOffset();
                }
            };
        }
        RandomAccessInput slice = this.getDataInput(field, entry);
        byte by = entry.getBytesPerNorm();
        if (by == 1) {
            return new SparseNormsIterator(disi, slice){
                final /* synthetic */ IndexedDISI $disi;
                final /* synthetic */ RandomAccessInput $slice;
                {
                    this.$disi = $disi;
                    this.$slice = $slice;
                    super($disi);
                }

                public long longValue() throws IOException {
                    return this.$slice.readByte(this.$disi.index());
                }
            };
        }
        if (by == 2) {
            return new SparseNormsIterator(disi, slice){
                final /* synthetic */ IndexedDISI $disi;
                final /* synthetic */ RandomAccessInput $slice;
                {
                    this.$disi = $disi;
                    this.$slice = $slice;
                    super($disi);
                }

                public long longValue() throws IOException {
                    return this.$slice.readShort((long)this.$disi.index() << 1);
                }
            };
        }
        if (by == 4) {
            return new SparseNormsIterator(disi, slice){
                final /* synthetic */ IndexedDISI $disi;
                final /* synthetic */ RandomAccessInput $slice;
                {
                    this.$disi = $disi;
                    this.$slice = $slice;
                    super($disi);
                }

                public long longValue() throws IOException {
                    return this.$slice.readInt((long)this.$disi.index() << 2);
                }
            };
        }
        if (by == 8) {
            return new SparseNormsIterator(disi, slice){
                final /* synthetic */ IndexedDISI $disi;
                final /* synthetic */ RandomAccessInput $slice;
                {
                    this.$disi = $disi;
                    this.$slice = $slice;
                    super($disi);
                }

                public long longValue() throws IOException {
                    return this.$slice.readLong((long)this.$disi.index() << 3);
                }
            };
        }
        throw new AssertionError();
    }

    @Override
    public void close() throws IOException {
        this.data.close();
    }

    @Override
    public void checkIntegrity() throws IOException {
        CodecUtil.INSTANCE.checksumEntireFile(this.data);
    }

    @NotNull
    public String toString() {
        return Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + "(fields=" + this.norms.size() + ")";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Lucene90NormsProducer clone() {
        IntObjectHashMap.IntObjectCursor entry;
        Iterable $this$forEach$iv;
        Lucene90NormsProducer lucene90NormsProducer;
        IntObjectHashMap intObjectHashMap;
        Lucene90NormsProducer clone = new Lucene90NormsProducer(this.state, this.dataCodec, this.dataExtension, this.metaCodec, this.metaExtension);
        Iterable $this$forEach$iv2 = this.norms;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            IntObjectHashMap.IntObjectCursor entry2 = (IntObjectHashMap.IntObjectCursor)element$iv;
            boolean bl = false;
            clone.norms.put(entry2.getKey(), (NormsEntry)entry2.getValue());
        }
        clone.data = this.data.clone();
        clone.merging = this.merging;
        if (this.disiInputs != null) {
            IntObjectHashMap $i$f$forEach2 = intObjectHashMap = new IntObjectHashMap();
            lucene90NormsProducer = clone;
            boolean bl = false;
            IntObjectHashMap<IndexInput> intObjectHashMap2 = this.disiInputs;
            Intrinsics.checkNotNull(intObjectHashMap2);
            $this$forEach$iv = intObjectHashMap2;
            boolean $i$f$forEach3 = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$clone_u24lambda_u243;
                entry = (IntObjectHashMap.IntObjectCursor)element$iv;
                boolean bl2 = false;
                $this$clone_u24lambda_u243.put(entry.getKey(), entry.getValue());
            }
            lucene90NormsProducer.disiInputs = intObjectHashMap;
        }
        if (this.disiJumpTables != null) {
            IntObjectHashMap $this$clone_u24lambda_u243 = intObjectHashMap = new IntObjectHashMap();
            lucene90NormsProducer = clone;
            boolean bl = false;
            IntObjectHashMap<RandomAccessInput> intObjectHashMap3 = this.disiJumpTables;
            Intrinsics.checkNotNull(intObjectHashMap3);
            $this$forEach$iv = intObjectHashMap3;
            boolean $i$f$forEach4 = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$clone_u24lambda_u245;
                entry = (IntObjectHashMap.IntObjectCursor)element$iv;
                boolean bl3 = false;
                $this$clone_u24lambda_u245.put(entry.getKey(), entry.getValue());
            }
            lucene90NormsProducer.disiJumpTables = intObjectHashMap;
        }
        if (this.dataInputs != null) {
            IntObjectHashMap $this$clone_u24lambda_u245 = intObjectHashMap = new IntObjectHashMap();
            lucene90NormsProducer = clone;
            boolean bl = false;
            IntObjectHashMap<RandomAccessInput> intObjectHashMap4 = this.dataInputs;
            Intrinsics.checkNotNull(intObjectHashMap4);
            $this$forEach$iv = intObjectHashMap4;
            boolean $i$f$forEach5 = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$clone_u24lambda_u247;
                entry = (IntObjectHashMap.IntObjectCursor)element$iv;
                boolean bl4 = false;
                $this$clone_u24lambda_u247.put(entry.getKey(), entry.getValue());
            }
            lucene90NormsProducer.dataInputs = intObjectHashMap;
        }
        return clone;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\b \u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\b\u0010\f\u001a\u00020\u0003H\u0016J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u0007\"\u0004\b\n\u0010\u0005\u00a8\u0006\u0013"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90NormsProducer$DenseNormsIterator;", "Lorg/gnit/lucenekmp/index/NumericDocValues;", "maxDoc", "", "<init>", "(I)V", "getMaxDoc", "()I", "doc", "getDoc", "setDoc", "docID", "nextDoc", "advance", "target", "advanceExact", "", "cost", "", "core"})
    @SourceDebugExtension(value={"SMAP\nLucene90NormsProducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Lucene90NormsProducer.kt\norg/gnit/lucenekmp/codecs/lucene90/Lucene90NormsProducer$DenseNormsIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,507:1\n1#2:508\n*E\n"})
    public static abstract class DenseNormsIterator
    extends NumericDocValues {
        private final int maxDoc;
        private int doc;

        public DenseNormsIterator(int maxDoc) {
            this.maxDoc = maxDoc;
            this.doc = -1;
        }

        public final int getMaxDoc() {
            return this.maxDoc;
        }

        public final int getDoc() {
            return this.doc;
        }

        public final void setDoc(int n) {
            this.doc = n;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int nextDoc() throws IOException {
            return this.advance(this.doc + 1);
        }

        @Override
        public int advance(int target) throws IOException {
            int n;
            if (target >= this.maxDoc) {
                int n2;
                int it = n2 = Integer.MAX_VALUE;
                boolean bl = false;
                this.doc = it;
                return n2;
            }
            int it = n = target;
            boolean bl = false;
            this.doc = it;
            return n;
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            this.doc = target;
            return true;
        }

        @Override
        public long cost() {
            return this.maxDoc;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\n\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0010\"\u0004\b$\u0010\u0012\u00a8\u0006%"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90NormsProducer$NormsEntry;", "", "<init>", "()V", "denseRankPower", "", "getDenseRankPower", "()B", "setDenseRankPower", "(B)V", "bytesPerNorm", "getBytesPerNorm", "setBytesPerNorm", "docsWithFieldOffset", "", "getDocsWithFieldOffset", "()J", "setDocsWithFieldOffset", "(J)V", "docsWithFieldLength", "getDocsWithFieldLength", "setDocsWithFieldLength", "jumpTableEntryCount", "", "getJumpTableEntryCount", "()S", "setJumpTableEntryCount", "(S)V", "numDocsWithField", "", "getNumDocsWithField", "()I", "setNumDocsWithField", "(I)V", "normsOffset", "getNormsOffset", "setNormsOffset", "core"})
    public static final class NormsEntry {
        private byte denseRankPower;
        private byte bytesPerNorm;
        private long docsWithFieldOffset;
        private long docsWithFieldLength;
        private short jumpTableEntryCount;
        private int numDocsWithField;
        private long normsOffset;

        public final byte getDenseRankPower() {
            return this.denseRankPower;
        }

        public final void setDenseRankPower(byte by) {
            this.denseRankPower = by;
        }

        public final byte getBytesPerNorm() {
            return this.bytesPerNorm;
        }

        public final void setBytesPerNorm(byte by) {
            this.bytesPerNorm = by;
        }

        public final long getDocsWithFieldOffset() {
            return this.docsWithFieldOffset;
        }

        public final void setDocsWithFieldOffset(long l) {
            this.docsWithFieldOffset = l;
        }

        public final long getDocsWithFieldLength() {
            return this.docsWithFieldLength;
        }

        public final void setDocsWithFieldLength(long l) {
            this.docsWithFieldLength = l;
        }

        public final short getJumpTableEntryCount() {
            return this.jumpTableEntryCount;
        }

        public final void setJumpTableEntryCount(short s) {
            this.jumpTableEntryCount = s;
        }

        public final int getNumDocsWithField() {
            return this.numDocsWithField;
        }

        public final void setNumDocsWithField(int n) {
            this.numDocsWithField = n;
        }

        public final long getNormsOffset() {
            return this.normsOffset;
        }

        public final void setNormsOffset(long l) {
            this.normsOffset = l;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\b \u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\tH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90NormsProducer$SparseNormsIterator;", "Lorg/gnit/lucenekmp/index/NumericDocValues;", "disi", "Lorg/gnit/lucenekmp/codecs/lucene90/IndexedDISI;", "<init>", "(Lorg/gnit/lucenekmp/codecs/lucene90/IndexedDISI;)V", "getDisi", "()Lorg/gnit/lucenekmp/codecs/lucene90/IndexedDISI;", "docID", "", "nextDoc", "advance", "target", "advanceExact", "", "cost", "", "core"})
    public static abstract class SparseNormsIterator
    extends NumericDocValues {
        @NotNull
        private final IndexedDISI disi;

        public SparseNormsIterator(@NotNull IndexedDISI disi) {
            Intrinsics.checkNotNullParameter((Object)disi, (String)"disi");
            this.disi = disi;
        }

        @NotNull
        public final IndexedDISI getDisi() {
            return this.disi;
        }

        @Override
        public int docID() {
            return this.disi.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            return this.disi.nextDoc();
        }

        @Override
        public int advance(int target) throws IOException {
            return this.disi.advance(target);
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            return this.disi.advanceExact(target);
        }

        @Override
        public long cost() {
            return this.disi.cost();
        }
    }
}

