/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs.lucene90;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.codecs.CodecUtil;
import org.gnit.lucenekmp.codecs.MutablePointTree;
import org.gnit.lucenekmp.codecs.PointsReader;
import org.gnit.lucenekmp.codecs.PointsWriter;
import org.gnit.lucenekmp.codecs.lucene90.Lucene90PointsReader;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.FieldInfos;
import org.gnit.lucenekmp.index.IndexFileNames;
import org.gnit.lucenekmp.index.MergeState;
import org.gnit.lucenekmp.index.PointValues;
import org.gnit.lucenekmp.index.SegmentWriteState;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.store.IndexOutput;
import org.gnit.lucenekmp.util.IORunnable;
import org.gnit.lucenekmp.util.IOUtils;
import org.gnit.lucenekmp.util.IntsRef;
import org.gnit.lucenekmp.util.bkd.BKDConfig;
import org.gnit.lucenekmp.util.bkd.BKDWriter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\nJ\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\u001fH\u0016J\b\u0010(\u001a\u00020\u001fH\u0016R\u001a\u0010\u000b\u001a\u00020\fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\u0014\u0010\u0014\u001a\u00020\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/Lucene90PointsWriter;", "Lorg/gnit/lucenekmp/codecs/PointsWriter;", "writeState", "Lorg/gnit/lucenekmp/index/SegmentWriteState;", "maxPointsInLeafNode", "", "maxMBSortInHeap", "", "<init>", "(Lorg/gnit/lucenekmp/index/SegmentWriteState;ID)V", "(Lorg/gnit/lucenekmp/index/SegmentWriteState;)V", "metaOut", "Lorg/gnit/lucenekmp/store/IndexOutput;", "getMetaOut", "()Lorg/gnit/lucenekmp/store/IndexOutput;", "setMetaOut", "(Lorg/gnit/lucenekmp/store/IndexOutput;)V", "indexOut", "getIndexOut", "setIndexOut", "dataOut", "getDataOut", "getWriteState", "()Lorg/gnit/lucenekmp/index/SegmentWriteState;", "getMaxPointsInLeafNode", "()I", "getMaxMBSortInHeap", "()D", "finished", "", "writeField", "", "fieldInfo", "Lorg/gnit/lucenekmp/index/FieldInfo;", "reader", "Lorg/gnit/lucenekmp/codecs/PointsReader;", "merge", "mergeState", "Lorg/gnit/lucenekmp/index/MergeState;", "finish", "close", "core"})
@SourceDebugExtension(value={"SMAP\nLucene90PointsWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Lucene90PointsWriter.kt\norg/gnit/lucenekmp/codecs/lucene90/Lucene90PointsWriter\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,277:1\n3#2,8:278\n10#3:286\n1#4:287\n*S KotlinDebug\n*F\n+ 1 Lucene90PointsWriter.kt\norg/gnit/lucenekmp/codecs/lucene90/Lucene90PointsWriter\n*L\n39#1:278,8\n39#1:286\n*E\n"})
public class Lucene90PointsWriter
extends PointsWriter {
    @NotNull
    private IndexOutput metaOut;
    @NotNull
    private IndexOutput indexOut;
    @NotNull
    private final IndexOutput dataOut;
    @NotNull
    private final SegmentWriteState writeState;
    private final int maxPointsInLeafNode;
    private final double maxMBSortInHeap;
    private boolean finished;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lucene90PointsWriter(@NotNull SegmentWriteState writeState, int maxPointsInLeafNode, double maxMBSortInHeap) {
        Intrinsics.checkNotNullParameter((Object)writeState, (String)"writeState");
        FieldInfos fieldInfos = writeState.getFieldInfos();
        Intrinsics.checkNotNull((Object)fieldInfos);
        boolean condition$iv = fieldInfos.hasPointValues();
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean $i$a$-assert-AssertKt$assert$22 = false;
            String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
        }
        this.writeState = writeState;
        this.maxPointsInLeafNode = maxPointsInLeafNode;
        this.maxMBSortInHeap = maxMBSortInHeap;
        String dataFileName = IndexFileNames.INSTANCE.segmentFileName(writeState.getSegmentInfo().getName(), writeState.getSegmentSuffix(), "kdd");
        this.dataOut = writeState.getDirectory().createOutput(dataFileName, writeState.getContext());
        boolean success = false;
        try {
            CodecUtil.INSTANCE.writeIndexHeader(this.dataOut, "Lucene90PointsFormatData", 0, writeState.getSegmentInfo().getId(), writeState.getSegmentSuffix());
            String metaFileName = IndexFileNames.INSTANCE.segmentFileName(writeState.getSegmentInfo().getName(), writeState.getSegmentSuffix(), "kdm");
            this.metaOut = writeState.getDirectory().createOutput(metaFileName, writeState.getContext());
            CodecUtil.INSTANCE.writeIndexHeader(this.metaOut, "Lucene90PointsFormatMeta", 0, writeState.getSegmentInfo().getId(), writeState.getSegmentSuffix());
            String indexFileName = IndexFileNames.INSTANCE.segmentFileName(writeState.getSegmentInfo().getName(), writeState.getSegmentSuffix(), "kdi");
            this.indexOut = writeState.getDirectory().createOutput(indexFileName, writeState.getContext());
            CodecUtil.INSTANCE.writeIndexHeader(this.indexOut, "Lucene90PointsFormatIndex", 0, writeState.getSegmentInfo().getId(), writeState.getSegmentSuffix());
            success = true;
        }
        catch (Throwable throwable) {
            AutoCloseable[] autoCloseableArray = new AutoCloseable[]{this};
            IOUtils.INSTANCE.closeWhileHandlingException(autoCloseableArray);
            throw throwable;
        }
    }

    @NotNull
    protected final IndexOutput getMetaOut() {
        return this.metaOut;
    }

    protected final void setMetaOut(@NotNull IndexOutput indexOutput) {
        Intrinsics.checkNotNullParameter((Object)indexOutput, (String)"<set-?>");
        this.metaOut = indexOutput;
    }

    @NotNull
    protected final IndexOutput getIndexOut() {
        return this.indexOut;
    }

    protected final void setIndexOut(@NotNull IndexOutput indexOutput) {
        Intrinsics.checkNotNullParameter((Object)indexOutput, (String)"<set-?>");
        this.indexOut = indexOutput;
    }

    @NotNull
    protected final IndexOutput getDataOut() {
        return this.dataOut;
    }

    @NotNull
    public final SegmentWriteState getWriteState() {
        return this.writeState;
    }

    public final int getMaxPointsInLeafNode() {
        return this.maxPointsInLeafNode;
    }

    public final double getMaxMBSortInHeap() {
        return this.maxMBSortInHeap;
    }

    public Lucene90PointsWriter(@NotNull SegmentWriteState writeState) {
        Intrinsics.checkNotNullParameter((Object)writeState, (String)"writeState");
        this(writeState, 512, 16.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeField(@NotNull FieldInfo fieldInfo, @NotNull PointsReader reader2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        PointValues pointValues = reader2.getValues(fieldInfo.getName());
        Intrinsics.checkNotNull((Object)pointValues);
        PointValues.PointTree values2 = pointValues.getPointTree();
        BKDConfig config = new BKDConfig(fieldInfo.getPointDimensionCount(), fieldInfo.getPointIndexDimensionCount(), fieldInfo.getPointNumBytes(), this.maxPointsInLeafNode);
        AutoCloseable autoCloseable = new BKDWriter(this.writeState.getSegmentInfo().maxDoc(), this.writeState.getDirectory(), this.writeState.getSegmentInfo().getName(), config, this.maxMBSortInHeap, values2.size());
        Throwable throwable = null;
        try {
            BKDWriter writer = (BKDWriter)autoCloseable;
            boolean bl = false;
            if (values2 instanceof MutablePointTree) {
                IORunnable finalizer2 = writer.writeField(this.metaOut, this.indexOut, this.dataOut, fieldInfo.getName(), (MutablePointTree)values2);
                if (finalizer2 != null) {
                    this.metaOut.writeInt(fieldInfo.getNumber());
                    finalizer2.run();
                }
                return;
            }
            values2.visitDocValues(new PointValues.IntersectVisitor(writer){
                final /* synthetic */ BKDWriter $writer;
                {
                    this.$writer = $writer;
                }

                public void visit(int docID) {
                    throw new IllegalStateException();
                }

                public void visit(int docID, byte[] packedValue) throws IOException {
                    Intrinsics.checkNotNullParameter((Object)packedValue, (String)"packedValue");
                    this.$writer.add(packedValue, docID);
                }

                public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                    Intrinsics.checkNotNullParameter((Object)minPackedValue, (String)"minPackedValue");
                    Intrinsics.checkNotNullParameter((Object)maxPackedValue, (String)"maxPackedValue");
                    return PointValues.Relation.CELL_CROSSES_QUERY;
                }

                public void visit(DocIdSetIterator iterator2) throws IOException {
                    PointValues.IntersectVisitor.super.visit(iterator2);
                }

                public void visit(IntsRef ref) throws IOException {
                    PointValues.IntersectVisitor.super.visit(ref);
                }

                public void visit(DocIdSetIterator iterator2, byte[] packedValue) throws IOException {
                    PointValues.IntersectVisitor.super.visit(iterator2, packedValue);
                }

                public void grow(int count) {
                    PointValues.IntersectVisitor.super.grow(count);
                }
            });
            IORunnable finalizer3 = writer.finish(this.metaOut, this.indexOut, this.dataOut);
            if (finalizer3 != null) {
                this.metaOut.writeInt(fieldInfo.getNumber());
                finalizer3.run();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void merge(@NotNull MergeState mergeState) throws IOException {
        Intrinsics.checkNotNullParameter((Object)mergeState, (String)"mergeState");
        for (PointsReader reader2 : mergeState.getPointsReaders()) {
            if (reader2 instanceof Lucene90PointsReader) continue;
            super.merge(mergeState);
            return;
        }
        PointsReader[] pointsReaderArray = mergeState.getPointsReaders();
        int n = pointsReaderArray.length;
        for (int i = 0; i < n; ++i) {
            PointsReader reader2;
            PointsReader pointsReader2 = reader2 = pointsReaderArray[i];
            if (pointsReader2 == null) continue;
            pointsReader2.checkIntegrity();
        }
        FieldInfos fieldInfos = mergeState.getMergeFieldInfos();
        Intrinsics.checkNotNull((Object)fieldInfos);
        for (FieldInfo fieldInfo : fieldInfos) {
            if (fieldInfo.getPointDimensionCount() == 0) continue;
            if (fieldInfo.getPointDimensionCount() == 1) {
                long totMaxSize = 0L;
                int n2 = mergeState.getPointsReaders().length;
                for (int i = 0; i < n2; ++i) {
                    PointValues values2;
                    FieldInfos readerFieldInfos;
                    PointsReader reader3 = mergeState.getPointsReaders()[i];
                    if (reader3 == null) continue;
                    Intrinsics.checkNotNull((Object)mergeState.getFieldInfos()[i]);
                    FieldInfo readerFieldInfo = readerFieldInfos.fieldInfo(fieldInfo.getName());
                    if (readerFieldInfo == null || readerFieldInfo.getPointDimensionCount() <= 0 || (values2 = reader3.getValues(fieldInfo.getName())) == null) continue;
                    totMaxSize += values2.size();
                }
                BKDConfig config = new BKDConfig(fieldInfo.getPointDimensionCount(), fieldInfo.getPointIndexDimensionCount(), fieldInfo.getPointNumBytes(), this.maxPointsInLeafNode);
                AutoCloseable autoCloseable = new BKDWriter(this.writeState.getSegmentInfo().maxDoc(), this.writeState.getDirectory(), this.writeState.getSegmentInfo().getName(), config, this.maxMBSortInHeap, totMaxSize);
                Throwable throwable = null;
                try {
                    BKDWriter writer = (BKDWriter)autoCloseable;
                    boolean bl = false;
                    List pointValues = new ArrayList();
                    List docMaps = new ArrayList();
                    int n3 = mergeState.getPointsReaders().length;
                    for (int i = 0; i < n3; ++i) {
                        PointValues aPointValues;
                        FieldInfos readerFieldInfos;
                        PointsReader reader4 = mergeState.getPointsReaders()[i];
                        if (reader4 == null) continue;
                        if (!(reader4 instanceof Lucene90PointsReader)) {
                            String string = "Failed requirement.";
                            throw new IllegalArgumentException(string.toString());
                        }
                        Lucene90PointsReader reader90 = (Lucene90PointsReader)reader4;
                        Intrinsics.checkNotNull((Object)mergeState.getFieldInfos()[i]);
                        FieldInfo readerFieldInfo = readerFieldInfos.fieldInfo(fieldInfo.getName());
                        if (readerFieldInfo == null || readerFieldInfo.getPointDimensionCount() <= 0 || (aPointValues = reader90.getValues(readerFieldInfo.getName())) == null) continue;
                        pointValues.add(aPointValues);
                        MergeState.DocMap[] docMapArray = mergeState.getDocMaps();
                        Intrinsics.checkNotNull((Object)docMapArray);
                        docMaps.add(docMapArray[i]);
                    }
                    IORunnable finalizer2 = writer.merge(this.metaOut, this.indexOut, this.dataOut, docMaps, pointValues);
                    if (finalizer2 != null) {
                        this.metaOut.writeInt(fieldInfo.getNumber());
                        finalizer2.run();
                    }
                    Unit unit = Unit.INSTANCE;
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                    continue;
                }
            }
            this.mergeOneField(mergeState, fieldInfo);
        }
        this.finish();
    }

    @Override
    public void finish() throws IOException {
        if (!(!this.finished)) {
            boolean bl = false;
            String string = "already finished";
            throw new IllegalStateException(string.toString());
        }
        this.finished = true;
        this.metaOut.writeInt(-1);
        CodecUtil.INSTANCE.writeFooter(this.indexOut);
        CodecUtil.INSTANCE.writeFooter(this.dataOut);
        this.metaOut.writeLong(this.indexOut.getFilePointer());
        this.metaOut.writeLong(this.dataOut.getFilePointer());
        CodecUtil.INSTANCE.writeFooter(this.metaOut);
    }

    @Override
    public void close() throws IOException {
        AutoCloseable[] autoCloseableArray = new AutoCloseable[]{this.metaOut, this.indexOut, this.dataOut};
        IOUtils.INSTANCE.close(autoCloseableArray);
    }
}

