/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs.lucene90.blocktree;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongCompanionObject;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.codecs.BlockTermState;
import org.gnit.lucenekmp.codecs.CodecUtil;
import org.gnit.lucenekmp.codecs.FieldsConsumer;
import org.gnit.lucenekmp.codecs.NormsProducer;
import org.gnit.lucenekmp.codecs.PostingsWriterBase;
import org.gnit.lucenekmp.codecs.lucene90.blocktree.CompressionAlgorithm;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.FieldInfos;
import org.gnit.lucenekmp.index.Fields;
import org.gnit.lucenekmp.index.IndexFileNames;
import org.gnit.lucenekmp.index.IndexOptions;
import org.gnit.lucenekmp.index.SegmentWriteState;
import org.gnit.lucenekmp.index.Terms;
import org.gnit.lucenekmp.index.TermsEnum;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.jdkport.LongExtKt;
import org.gnit.lucenekmp.jdkport.Math;
import org.gnit.lucenekmp.jdkport.Objects;
import org.gnit.lucenekmp.jdkport.System;
import org.gnit.lucenekmp.store.ByteArrayDataOutput;
import org.gnit.lucenekmp.store.ByteBuffersDataOutput;
import org.gnit.lucenekmp.store.DataOutput;
import org.gnit.lucenekmp.store.IndexOutput;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.BytesRefBuilder;
import org.gnit.lucenekmp.util.FixedBitSet;
import org.gnit.lucenekmp.util.IOUtils;
import org.gnit.lucenekmp.util.IntsRef;
import org.gnit.lucenekmp.util.IntsRefBuilder;
import org.gnit.lucenekmp.util.StringHelper;
import org.gnit.lucenekmp.util.ToStringUtils;
import org.gnit.lucenekmp.util.compress.LZ4;
import org.gnit.lucenekmp.util.compress.LowercaseAsciiCompression;
import org.gnit.lucenekmp.util.fst.ByteSequenceOutputs;
import org.gnit.lucenekmp.util.fst.BytesRefFSTEnum;
import org.gnit.lucenekmp.util.fst.FST;
import org.gnit.lucenekmp.util.fst.FSTCompiler;
import org.gnit.lucenekmp.util.fst.Util;
import org.gnit.lucenekmp.util.packed.PackedInts;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u0000 02\u00020\u0001:\u0006+,-./0B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bB)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\fJ\u0018\u0010 \u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010*\u001a\u00020!H\u0016R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/blocktree/Lucene90BlockTreeTermsWriter;", "Lorg/gnit/lucenekmp/codecs/FieldsConsumer;", "state", "Lorg/gnit/lucenekmp/index/SegmentWriteState;", "postingsWriter", "Lorg/gnit/lucenekmp/codecs/PostingsWriterBase;", "minItemsInBlock", "", "maxItemsInBlock", "version", "<init>", "(Lorg/gnit/lucenekmp/index/SegmentWriteState;Lorg/gnit/lucenekmp/codecs/PostingsWriterBase;III)V", "(Lorg/gnit/lucenekmp/index/SegmentWriteState;Lorg/gnit/lucenekmp/codecs/PostingsWriterBase;II)V", "metaOut", "Lorg/gnit/lucenekmp/store/IndexOutput;", "termsOut", "indexOut", "maxDoc", "getMaxDoc", "()I", "getMinItemsInBlock", "getMaxItemsInBlock", "getVersion", "getPostingsWriter", "()Lorg/gnit/lucenekmp/codecs/PostingsWriterBase;", "fieldInfos", "Lorg/gnit/lucenekmp/index/FieldInfos;", "getFieldInfos", "()Lorg/gnit/lucenekmp/index/FieldInfos;", "fields", "", "Lorg/gnit/lucenekmp/store/ByteBuffersDataOutput;", "write", "", "Lorg/gnit/lucenekmp/index/Fields;", "norms", "Lorg/gnit/lucenekmp/codecs/NormsProducer;", "scratchBytes", "scratchIntsRef", "Lorg/gnit/lucenekmp/util/IntsRefBuilder;", "closed", "", "close", "PendingEntry", "PendingTerm", "PendingBlock", "StatsWriter", "TermsWriter", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nLucene90BlockTreeTermsWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Lucene90BlockTreeTermsWriter.kt\norg/gnit/lucenekmp/codecs/lucene90/blocktree/Lucene90BlockTreeTermsWriter\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,1248:1\n3#2,8:1249\n10#3:1257\n*S KotlinDebug\n*F\n+ 1 Lucene90BlockTreeTermsWriter.kt\norg/gnit/lucenekmp/codecs/lucene90/blocktree/Lucene90BlockTreeTermsWriter\n*L\n264#1:1249,8\n264#1:1257\n*E\n"})
public final class Lucene90BlockTreeTermsWriter
extends FieldsConsumer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IndexOutput metaOut;
    @NotNull
    private final IndexOutput termsOut;
    @NotNull
    private final IndexOutput indexOut;
    private final int maxDoc;
    private final int minItemsInBlock;
    private final int maxItemsInBlock;
    private final int version;
    @NotNull
    private final PostingsWriterBase postingsWriter;
    @NotNull
    private final FieldInfos fieldInfos;
    @NotNull
    private final List<ByteBuffersDataOutput> fields;
    @NotNull
    private final ByteBuffersDataOutput scratchBytes;
    @NotNull
    private final IntsRefBuilder scratchIntsRef;
    private boolean closed;
    public static final int DEFAULT_MIN_BLOCK_SIZE = 25;
    public static final int DEFAULT_MAX_BLOCK_SIZE = 48;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lucene90BlockTreeTermsWriter(@NotNull SegmentWriteState state2, @NotNull PostingsWriterBase postingsWriter, int minItemsInBlock, int maxItemsInBlock, int version) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)postingsWriter, (String)"postingsWriter");
        this.fields = new ArrayList();
        this.scratchBytes = ByteBuffersDataOutput.Companion.newResettableInstance();
        this.scratchIntsRef = new IntsRefBuilder();
        Companion.validateSettings(minItemsInBlock, maxItemsInBlock);
        this.minItemsInBlock = minItemsInBlock;
        this.maxItemsInBlock = maxItemsInBlock;
        if (!(version >= 0 && version <= 2)) {
            boolean $i$a$-require-Lucene90BlockTreeTermsWriter$22 = false;
            String $i$a$-require-Lucene90BlockTreeTermsWriter$22 = "Expected version in range [0, 2], but got " + version;
            throw new IllegalArgumentException($i$a$-require-Lucene90BlockTreeTermsWriter$22.toString());
        }
        this.version = version;
        this.maxDoc = state2.getSegmentInfo().maxDoc();
        FieldInfos fieldInfos = state2.getFieldInfos();
        Intrinsics.checkNotNull((Object)fieldInfos);
        this.fieldInfos = fieldInfos;
        this.postingsWriter = postingsWriter;
        String termsName = IndexFileNames.INSTANCE.segmentFileName(state2.getSegmentInfo().getName(), state2.getSegmentSuffix(), "tim");
        this.termsOut = state2.getDirectory().createOutput(termsName, state2.getContext());
        boolean success = false;
        IndexOutput metaOut = null;
        IndexOutput indexOut = null;
        try {
            CodecUtil.INSTANCE.writeIndexHeader(this.termsOut, "BlockTreeTermsDict", version, state2.getSegmentInfo().getId(), state2.getSegmentSuffix());
            String indexName = IndexFileNames.INSTANCE.segmentFileName(state2.getSegmentInfo().getName(), state2.getSegmentSuffix(), "tip");
            indexOut = state2.getDirectory().createOutput(indexName, state2.getContext());
            CodecUtil.INSTANCE.writeIndexHeader(indexOut, "BlockTreeTermsIndex", version, state2.getSegmentInfo().getId(), state2.getSegmentSuffix());
            String metaName = IndexFileNames.INSTANCE.segmentFileName(state2.getSegmentInfo().getName(), state2.getSegmentSuffix(), "tmd");
            metaOut = state2.getDirectory().createOutput(metaName, state2.getContext());
            CodecUtil.INSTANCE.writeIndexHeader(metaOut, "BlockTreeTermsMeta", version, state2.getSegmentInfo().getId(), state2.getSegmentSuffix());
            postingsWriter.init(metaOut, state2);
            this.metaOut = metaOut;
            this.indexOut = indexOut;
            success = true;
        }
        catch (Throwable throwable) {
            AutoCloseable[] autoCloseableArray = new AutoCloseable[]{metaOut, this.termsOut, indexOut};
            IOUtils.INSTANCE.closeWhileHandlingExceptionNullable(autoCloseableArray);
            throw throwable;
        }
    }

    public final int getMaxDoc() {
        return this.maxDoc;
    }

    public final int getMinItemsInBlock() {
        return this.minItemsInBlock;
    }

    public final int getMaxItemsInBlock() {
        return this.maxItemsInBlock;
    }

    public final int getVersion() {
        return this.version;
    }

    @NotNull
    public final PostingsWriterBase getPostingsWriter() {
        return this.postingsWriter;
    }

    @NotNull
    public final FieldInfos getFieldInfos() {
        return this.fieldInfos;
    }

    public Lucene90BlockTreeTermsWriter(@NotNull SegmentWriteState state2, @NotNull PostingsWriterBase postingsWriter, int minItemsInBlock, int maxItemsInBlock) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)postingsWriter, (String)"postingsWriter");
        this(state2, postingsWriter, minItemsInBlock, maxItemsInBlock, 2);
    }

    @Override
    public void write(@NotNull Fields fields, @NotNull NormsProducer norms) throws IOException {
        Intrinsics.checkNotNullParameter((Object)fields, (String)"fields");
        Intrinsics.checkNotNullParameter((Object)norms, (String)"norms");
        String lastField = null;
        for (String field : fields) {
            BytesRef term;
            boolean condition$iv = lastField == null || lastField.compareTo(field) < 0;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean $i$a$-assert-AssertKt$assert$22 = false;
                String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
                throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
            }
            lastField = field;
            Terms terms = fields.terms(field);
            if (terms == null) continue;
            TermsEnum termsEnum = terms.iterator();
            FieldInfo fieldInfo = this.fieldInfos.fieldInfo(field);
            Intrinsics.checkNotNull((Object)fieldInfo);
            TermsWriter termsWriter = new TermsWriter(fieldInfo);
            while ((term = termsEnum.next()) != null) {
                termsWriter.write(term, termsEnum, norms);
            }
            termsWriter.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        boolean success = false;
        try {
            this.metaOut.writeVInt(this.fields.size());
            for (ByteBuffersDataOutput fieldMeta : this.fields) {
                fieldMeta.copyTo(this.metaOut);
            }
            CodecUtil.INSTANCE.writeFooter(this.indexOut);
            this.metaOut.writeLong(this.indexOut.getFilePointer());
            CodecUtil.INSTANCE.writeFooter(this.termsOut);
            this.metaOut.writeLong(this.termsOut.getFilePointer());
            CodecUtil.INSTANCE.writeFooter(this.metaOut);
            success = true;
        }
        catch (Throwable throwable) {
            AutoCloseable[] autoCloseableArray = new AutoCloseable[]{this.metaOut, this.termsOut, this.indexOut, this.postingsWriter};
            IOUtils.INSTANCE.closeWhileHandlingException(autoCloseableArray);
            throw throwable;
        }
        AutoCloseable[] autoCloseableArray = new AutoCloseable[]{this.metaOut, this.termsOut, this.indexOut, this.postingsWriter};
        IOUtils.INSTANCE.close(autoCloseableArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ\u0016\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/blocktree/Lucene90BlockTreeTermsWriter$Companion;", "", "<init>", "()V", "DEFAULT_MIN_BLOCK_SIZE", "", "DEFAULT_MAX_BLOCK_SIZE", "validateSettings", "", "minItemsInBlock", "maxItemsInBlock", "encodeOutput", "", "fp", "hasTerms", "", "isFloor", "writeMSBVLong", "l", "scratchBytes", "Lorg/gnit/lucenekmp/store/DataOutput;", "writeBytesRef", "out", "bytes", "Lorg/gnit/lucenekmp/util/BytesRef;", "core"})
    @SourceDebugExtension(value={"SMAP\nLucene90BlockTreeTermsWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Lucene90BlockTreeTermsWriter.kt\norg/gnit/lucenekmp/codecs/lucene90/blocktree/Lucene90BlockTreeTermsWriter$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 4 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,1248:1\n1#2:1249\n3#3,8:1250\n3#3,8:1259\n10#4:1258\n10#4:1267\n*S KotlinDebug\n*F\n+ 1 Lucene90BlockTreeTermsWriter.kt\norg/gnit/lucenekmp/codecs/lucene90/blocktree/Lucene90BlockTreeTermsWriter$Companion\n*L\n1213#1:1250,8\n1229#1:1259,8\n1213#1:1258\n1229#1:1267\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void validateSettings(int minItemsInBlock, int maxItemsInBlock) {
            if (!(minItemsInBlock > 1)) {
                boolean $i$a$-require-Lucene90BlockTreeTermsWriter$Companion$validateSettings$42 = false;
                String $i$a$-require-Lucene90BlockTreeTermsWriter$Companion$validateSettings$42 = "minItemsInBlock must be >= 2; got " + minItemsInBlock;
                throw new IllegalArgumentException($i$a$-require-Lucene90BlockTreeTermsWriter$Companion$validateSettings$42.toString());
            }
            if (!(minItemsInBlock <= maxItemsInBlock)) {
                boolean $i$a$-require-Lucene90BlockTreeTermsWriter$Companion$validateSettings$52 = false;
                String $i$a$-require-Lucene90BlockTreeTermsWriter$Companion$validateSettings$52 = "maxItemsInBlock must be >= minItemsInBlock; got maxItemsInBlock=" + maxItemsInBlock + " minItemsInBlock=" + minItemsInBlock;
                throw new IllegalArgumentException($i$a$-require-Lucene90BlockTreeTermsWriter$Companion$validateSettings$52.toString());
            }
            if (!(2 * (minItemsInBlock - 1) <= maxItemsInBlock)) {
                boolean bl = false;
                String string = "maxItemsInBlock must be at least 2*(minItemsInBlock-1); got maxItemsInBlock=" + maxItemsInBlock + " minItemsInBlock=" + minItemsInBlock;
                throw new IllegalArgumentException(string.toString());
            }
        }

        public final long encodeOutput(long fp, boolean hasTerms, boolean isFloor) {
            boolean condition$iv = fp < 0x4000000000000000L;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            return fp << 2 | (long)(hasTerms ? 2 : 0) | (long)(isFloor ? 1 : 0);
        }

        public final void writeMSBVLong(long l, @NotNull DataOutput scratchBytes) throws IOException {
            Intrinsics.checkNotNullParameter((Object)scratchBytes, (String)"scratchBytes");
            long l2 = l;
            boolean condition$iv = l2 >= 0L;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            int bytesNeeded = (64 - LongExtKt.numberOfLeadingZeros(LongCompanionObject.INSTANCE, l2) - 1) / 7 + 1;
            l2 <<= 64 - bytesNeeded * 7;
            for (int i = 1; i < bytesNeeded; ++i) {
                scratchBytes.writeByte((byte)(l2 >>> 57 & 0x7FL | 0x80L));
                l2 <<= 7;
            }
            scratchBytes.writeByte((byte)(l2 >>> 57 & 0x7FL));
        }

        private final void writeBytesRef(DataOutput out, BytesRef bytes) throws IOException {
            out.writeVInt(bytes.getLength());
            out.writeBytes(bytes.getBytes(), bytes.getOffset(), bytes.getLength());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0014\u0010\u000b\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\r\u0018\u00010\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010!\u001a\u00020\"H\u0016J(\u0010#\u001a\u00020$2\u0010\u0010%\u001a\f\u0012\b\u0012\u00060\u0000R\u00020&0\f2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*J*\u0010+\u001a\u00020$2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00030-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00030\r2\u0006\u0010)\u001a\u00020*R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0015R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R(\u0010\u000b\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\r\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\"\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006/"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/blocktree/Lucene90BlockTreeTermsWriter$PendingBlock;", "Lorg/gnit/lucenekmp/codecs/lucene90/blocktree/Lucene90BlockTreeTermsWriter$PendingEntry;", "prefix", "Lorg/gnit/lucenekmp/util/BytesRef;", "fp", "", "hasTerms", "", "isFloor", "floorLeadByte", "", "subIndices", "", "Lorg/gnit/lucenekmp/util/fst/FST;", "<init>", "(Lorg/gnit/lucenekmp/codecs/lucene90/blocktree/Lucene90BlockTreeTermsWriter;Lorg/gnit/lucenekmp/util/BytesRef;JZZILjava/util/List;)V", "getPrefix", "()Lorg/gnit/lucenekmp/util/BytesRef;", "getFp", "()J", "getHasTerms", "()Z", "getFloorLeadByte", "()I", "getSubIndices", "()Ljava/util/List;", "setSubIndices", "(Ljava/util/List;)V", "index", "getIndex", "()Lorg/gnit/lucenekmp/util/fst/FST;", "setIndex", "(Lorg/gnit/lucenekmp/util/fst/FST;)V", "toString", "", "compileIndex", "", "blocks", "Lorg/gnit/lucenekmp/codecs/lucene90/blocktree/Lucene90BlockTreeTermsWriter;", "scratchBytes", "Lorg/gnit/lucenekmp/store/ByteBuffersDataOutput;", "scratchIntsRef", "Lorg/gnit/lucenekmp/util/IntsRefBuilder;", "append", "fstCompiler", "Lorg/gnit/lucenekmp/util/fst/FSTCompiler;", "subIndex", "core"})
    @SourceDebugExtension(value={"SMAP\nLucene90BlockTreeTermsWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Lucene90BlockTreeTermsWriter.kt\norg/gnit/lucenekmp/codecs/lucene90/blocktree/Lucene90BlockTreeTermsWriter$PendingBlock\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1248:1\n8#2,2:1249\n3#2,8:1251\n3#2,8:1260\n3#2,8:1269\n3#2,8:1278\n3#2,8:1287\n3#2,8:1296\n10#3:1259\n10#3:1268\n10#3:1277\n10#3:1286\n10#3:1295\n10#3:1304\n1#4:1305\n*S KotlinDebug\n*F\n+ 1 Lucene90BlockTreeTermsWriter.kt\norg/gnit/lucenekmp/codecs/lucene90/blocktree/Lucene90BlockTreeTermsWriter$PendingBlock\n*L\n333#1:1249,2\n336#1:1251,8\n338#1:1260,8\n350#1:1269,8\n356#1:1278,8\n393#1:1287,8\n409#1:1296,8\n336#1:1259\n338#1:1268\n350#1:1277\n356#1:1286\n393#1:1295\n409#1:1304\n*E\n"})
    private final class PendingBlock
    extends PendingEntry {
        @NotNull
        private final BytesRef prefix;
        private final long fp;
        private final boolean hasTerms;
        private final boolean isFloor;
        private final int floorLeadByte;
        @Nullable
        private List<FST<BytesRef>> subIndices;
        @Nullable
        private FST<BytesRef> index;

        public PendingBlock(BytesRef prefix, long fp, boolean hasTerms, boolean isFloor, @Nullable int floorLeadByte, List<FST<BytesRef>> subIndices) {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            super(false);
            this.prefix = prefix;
            this.fp = fp;
            this.hasTerms = hasTerms;
            this.isFloor = isFloor;
            this.floorLeadByte = floorLeadByte;
            this.subIndices = subIndices;
        }

        @NotNull
        public final BytesRef getPrefix() {
            return this.prefix;
        }

        public final long getFp() {
            return this.fp;
        }

        public final boolean getHasTerms() {
            return this.hasTerms;
        }

        public final boolean isFloor() {
            return this.isFloor;
        }

        public final int getFloorLeadByte() {
            return this.floorLeadByte;
        }

        @Nullable
        public final List<FST<BytesRef>> getSubIndices() {
            return this.subIndices;
        }

        public final void setSubIndices(@Nullable List<FST<BytesRef>> list) {
            this.subIndices = list;
        }

        @Nullable
        public final FST<BytesRef> getIndex() {
            return this.index;
        }

        public final void setIndex(@Nullable FST<BytesRef> fST) {
            this.index = fST;
        }

        @NotNull
        public String toString() {
            return "BLOCK: prefix=" + ToStringUtils.INSTANCE.bytesRefToString(this.prefix);
        }

        /*
         * WARNING - void declaration
         */
        public final void compileIndex(@NotNull List<PendingBlock> blocks, @NotNull ByteBuffersDataOutput scratchBytes, @NotNull IntsRefBuilder scratchIntsRef) throws IOException {
            void condition$iv;
            boolean condition$iv2;
            Intrinsics.checkNotNullParameter(blocks, (String)"blocks");
            Intrinsics.checkNotNullParameter((Object)scratchBytes, (String)"scratchBytes");
            Intrinsics.checkNotNullParameter((Object)scratchIntsRef, (String)"scratchIntsRef");
            boolean bl = this.isFloor && blocks.size() > 1 || !this.isFloor && blocks.size() == 1;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv2) {
                boolean bl2 = false;
                String string = "isFloor=" + this.isFloor + " blocks=" + blocks;
                throw new AssertionError((Object)string);
            }
            condition$iv2 = Intrinsics.areEqual((Object)this, (Object)blocks.get(0));
            boolean $i$f$assert2 = false;
            if (_Assertions.ENABLED && !condition$iv2) {
                boolean $i$a$-assert-AssertKt$assert$22 = false;
                String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
                throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
            }
            condition$iv2 = scratchBytes.size() == 0L;
            $i$f$assert2 = false;
            if (_Assertions.ENABLED && !condition$iv2) {
                boolean $i$a$-assert-AssertKt$assert$32 = false;
                String $i$a$-assert-AssertKt$assert$32 = "assertion failed";
                throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$32);
            }
            if (Lucene90BlockTreeTermsWriter.this.getVersion() >= 1) {
                Companion.writeMSBVLong(Companion.encodeOutput(this.fp, this.hasTerms, this.isFloor), scratchBytes);
            } else {
                scratchBytes.writeVLong(Companion.encodeOutput(this.fp, this.hasTerms, this.isFloor));
            }
            if (this.isFloor) {
                scratchBytes.writeVInt(blocks.size() - 1);
                int n = blocks.size();
                for (int i = 1; i < n; ++i) {
                    PendingBlock sub = blocks.get(i);
                    boolean condition$iv3 = sub.floorLeadByte != -1;
                    boolean $i$f$assert3 = false;
                    if (_Assertions.ENABLED && !condition$iv3) {
                        boolean $i$a$-assert-AssertKt$assert$42 = false;
                        String $i$a$-assert-AssertKt$assert$42 = "assertion failed";
                        throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$42);
                    }
                    scratchBytes.writeByte((byte)sub.floorLeadByte);
                    condition$iv3 = sub.fp > this.fp;
                    $i$f$assert3 = false;
                    if (_Assertions.ENABLED && !condition$iv3) {
                        boolean $i$a$-assert-AssertKt$assert$52 = false;
                        String $i$a$-assert-AssertKt$assert$52 = "assertion failed";
                        throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$52);
                    }
                    scratchBytes.writeVLong(sub.fp - this.fp << 1 | (long)(sub.hasTerms ? 1 : 0));
                }
            }
            long estimateSize = this.prefix.getLength();
            for (PendingBlock block2 : blocks) {
                if (block2.subIndices == null) continue;
                for (FST<BytesRef> subIndex : block2.subIndices) {
                    estimateSize += subIndex.numBytes();
                }
            }
            int estimateBitsRequired = PackedInts.INSTANCE.bitsRequired(estimateSize);
            int pageBits = java.lang.Math.min(15, java.lang.Math.max(6, estimateBitsRequired));
            ByteSequenceOutputs outputs = ByteSequenceOutputs.Companion.getSingleton();
            int fstVersion = Lucene90BlockTreeTermsWriter.this.getVersion() >= 2 ? 9 : 8;
            FSTCompiler<BytesRef> fstCompiler = new FSTCompiler.Builder(FST.INPUT_TYPE.BYTE1, outputs).suffixRAMLimitMB(0.0).dataOutput(FSTCompiler.Companion.getOnHeapReaderWriter(pageBits)).setVersion(fstVersion).build();
            byte[] bytes = scratchBytes.toArrayCopy();
            boolean bl3 = !(bytes.length == 0);
            boolean $i$f$assert4 = false;
            if (_Assertions.ENABLED && condition$iv == false) {
                boolean $i$a$-assert-AssertKt$assert$62 = false;
                String $i$a$-assert-AssertKt$assert$62 = "assertion failed";
                throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$62);
            }
            fstCompiler.add(Util.INSTANCE.toIntsRef(this.prefix, scratchIntsRef), new BytesRef(bytes, 0, bytes.length));
            scratchBytes.reset();
            for (PendingBlock block3 : blocks) {
                if (block3.subIndices == null) continue;
                for (FST<BytesRef> subIndex : block3.subIndices) {
                    this.append(fstCompiler, subIndex, scratchIntsRef);
                }
                block3.subIndices = null;
            }
            this.index = FST.Companion.fromFSTReader(fstCompiler.compile(), fstCompiler.getFSTReader());
            boolean condition$iv4 = this.subIndices == null;
            $i$f$assert4 = false;
            if (_Assertions.ENABLED && !condition$iv4) {
                boolean bl4 = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
        }

        public final void append(@NotNull FSTCompiler<BytesRef> fstCompiler, @NotNull FST<BytesRef> subIndex, @NotNull IntsRefBuilder scratchIntsRef) throws IOException {
            Intrinsics.checkNotNullParameter(fstCompiler, (String)"fstCompiler");
            Intrinsics.checkNotNullParameter(subIndex, (String)"subIndex");
            Intrinsics.checkNotNullParameter((Object)scratchIntsRef, (String)"scratchIntsRef");
            BytesRefFSTEnum<BytesRef> subIndexEnum = new BytesRefFSTEnum<BytesRef>(subIndex);
            BytesRefFSTEnum.InputOutput<BytesRef> indexEnt = null;
            while (true) {
                BytesRefFSTEnum.InputOutput<BytesRef> inputOutput;
                BytesRefFSTEnum.InputOutput<BytesRef> it = inputOutput = subIndexEnum.next();
                boolean bl = false;
                indexEnt = it;
                if (inputOutput == null) break;
                BytesRefFSTEnum.InputOutput<BytesRef> inputOutput2 = indexEnt;
                Intrinsics.checkNotNull(inputOutput2);
                BytesRef bytesRef = inputOutput2.getInput();
                Intrinsics.checkNotNull((Object)bytesRef);
                IntsRef intsRef = Util.INSTANCE.toIntsRef(bytesRef, scratchIntsRef);
                BytesRef bytesRef2 = indexEnt.getOutput();
                Intrinsics.checkNotNull((Object)bytesRef2);
                fstCompiler.add(intsRef, bytesRef2);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0012\u0018\u00002\u00020\u0001B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/blocktree/Lucene90BlockTreeTermsWriter$PendingEntry;", "", "isTerm", "", "<init>", "(Z)V", "()Z", "core"})
    private static class PendingEntry {
        private final boolean isTerm;

        protected PendingEntry(boolean isTerm) {
            this.isTerm = isTerm;
        }

        public final boolean isTerm() {
            return this.isTerm;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/blocktree/Lucene90BlockTreeTermsWriter$PendingTerm;", "Lorg/gnit/lucenekmp/codecs/lucene90/blocktree/Lucene90BlockTreeTermsWriter$PendingEntry;", "term", "Lorg/gnit/lucenekmp/util/BytesRef;", "state", "Lorg/gnit/lucenekmp/codecs/BlockTermState;", "<init>", "(Lorg/gnit/lucenekmp/util/BytesRef;Lorg/gnit/lucenekmp/codecs/BlockTermState;)V", "termBytes", "", "getTermBytes", "()[B", "getState", "()Lorg/gnit/lucenekmp/codecs/BlockTermState;", "toString", "", "core"})
    private static final class PendingTerm
    extends PendingEntry {
        @NotNull
        private final byte[] termBytes;
        @NotNull
        private final BlockTermState state;

        public PendingTerm(@NotNull BytesRef term, @NotNull BlockTermState state2) {
            Intrinsics.checkNotNullParameter((Object)term, (String)"term");
            Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
            super(true);
            this.termBytes = new byte[term.getLength()];
            System.INSTANCE.arraycopy(term.getBytes(), term.getOffset(), this.termBytes, 0, term.getLength());
            this.state = state2;
        }

        @NotNull
        public final byte[] getTermBytes() {
            return this.termBytes;
        }

        @NotNull
        public final BlockTermState getState() {
            return this.state;
        }

        @NotNull
        public String toString() {
            return "TERM: " + ToStringUtils.INSTANCE.bytesRefToString(this.termBytes);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/blocktree/Lucene90BlockTreeTermsWriter$StatsWriter;", "", "out", "Lorg/gnit/lucenekmp/store/DataOutput;", "hasFreqs", "", "<init>", "(Lorg/gnit/lucenekmp/store/DataOutput;Z)V", "singletonCount", "", "add", "", "df", "ttf", "", "finish", "core"})
    private static final class StatsWriter {
        @NotNull
        private final DataOutput out;
        private final boolean hasFreqs;
        private int singletonCount;

        public StatsWriter(@NotNull DataOutput out, boolean hasFreqs) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            this.out = out;
            this.hasFreqs = hasFreqs;
        }

        public final void add(int df, long ttf) throws IOException {
            if (!(df != 1 || this.hasFreqs && ttf != 1L)) {
                int n = this.singletonCount;
                this.singletonCount = n + 1;
            } else {
                this.finish();
                this.out.writeVInt(df << 1);
                if (this.hasFreqs) {
                    this.out.writeVLong(ttf - (long)df);
                }
            }
        }

        public final void finish() throws IOException {
            if (this.singletonCount > 0) {
                this.out.writeVInt(this.singletonCount - 1 << 1 | 1);
                this.singletonCount = 0;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$J(\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020$2\u0006\u0010+\u001a\u00020$2\u0006\u0010,\u001a\u00020-H\u0002JD\u0010.\u001a\u00060\u001cR\u00020\u001d2\u0006\u0010#\u001a\u00020$2\u0006\u0010/\u001a\u00020'2\u0006\u00100\u001a\u00020$2\u0006\u00101\u001a\u00020$2\u0006\u00102\u001a\u00020$2\u0006\u00103\u001a\u00020'2\u0006\u00104\u001a\u00020'H\u0002J\u001e\u00105\u001a\u00020\"2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;J\u0010\u0010<\u001a\u00020\"2\u0006\u00106\u001a\u000207H\u0002J\u0006\u0010=\u001a\u00020\"R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001b\u001a\f\u0012\b\u0012\u00060\u001cR\u00020\u001d0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020?X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020?X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020?X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010C\u001a\u00020?X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010D\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010E\u001a\u0004\u0018\u00010FX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/blocktree/Lucene90BlockTreeTermsWriter$TermsWriter;", "", "fieldInfo", "Lorg/gnit/lucenekmp/index/FieldInfo;", "<init>", "(Lorg/gnit/lucenekmp/codecs/lucene90/blocktree/Lucene90BlockTreeTermsWriter;Lorg/gnit/lucenekmp/index/FieldInfo;)V", "numTerms", "", "docsSeen", "Lorg/gnit/lucenekmp/util/FixedBitSet;", "getDocsSeen", "()Lorg/gnit/lucenekmp/util/FixedBitSet;", "sumTotalTermFreq", "getSumTotalTermFreq", "()J", "setSumTotalTermFreq", "(J)V", "sumDocFreq", "getSumDocFreq", "setSumDocFreq", "lastTerm", "Lorg/gnit/lucenekmp/util/BytesRefBuilder;", "prefixStarts", "", "pending", "", "Lorg/gnit/lucenekmp/codecs/lucene90/blocktree/Lucene90BlockTreeTermsWriter$PendingEntry;", "newBlocks", "Lorg/gnit/lucenekmp/codecs/lucene90/blocktree/Lucene90BlockTreeTermsWriter$PendingBlock;", "Lorg/gnit/lucenekmp/codecs/lucene90/blocktree/Lucene90BlockTreeTermsWriter;", "firstPendingTerm", "Lorg/gnit/lucenekmp/codecs/lucene90/blocktree/Lucene90BlockTreeTermsWriter$PendingTerm;", "lastPendingTerm", "writeBlocks", "", "prefixLength", "", "count", "allEqual", "", "b", "", "startOffset", "endOffset", "value", "", "writeBlock", "isFloor", "floorLeadLabel", "start", "end", "hasTerms", "hasSubBlocks", "write", "text", "Lorg/gnit/lucenekmp/util/BytesRef;", "termsEnum", "Lorg/gnit/lucenekmp/index/TermsEnum;", "norms", "Lorg/gnit/lucenekmp/codecs/NormsProducer;", "pushTerm", "finish", "suffixLengthsWriter", "Lorg/gnit/lucenekmp/store/ByteBuffersDataOutput;", "suffixWriter", "statsWriter", "metaWriter", "spareWriter", "spareBytes", "compressionHashTable", "Lorg/gnit/lucenekmp/util/compress/LZ4$HighCompressionHashTable;", "core"})
    @SourceDebugExtension(value={"SMAP\nLucene90BlockTreeTermsWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Lucene90BlockTreeTermsWriter.kt\norg/gnit/lucenekmp/codecs/lucene90/blocktree/Lucene90BlockTreeTermsWriter$TermsWriter\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,1248:1\n3#2,8:1249\n3#2,8:1258\n8#2,2:1267\n3#2,8:1269\n3#2,8:1278\n3#2,8:1287\n3#2,8:1296\n8#2,2:1305\n8#2,2:1307\n3#2,8:1309\n8#2,2:1318\n3#2,8:1320\n3#2,8:1329\n3#2,8:1338\n8#2,2:1347\n3#2,8:1349\n3#2,8:1358\n3#2,8:1367\n8#2,2:1376\n3#2,8:1378\n8#2,2:1387\n3#2,8:1389\n3#2,8:1398\n3#2,8:1407\n3#2,8:1416\n3#2,8:1425\n10#3:1257\n10#3:1266\n10#3:1277\n10#3:1286\n10#3:1295\n10#3:1304\n10#3:1317\n10#3:1328\n10#3:1337\n10#3:1346\n10#3:1357\n10#3:1366\n10#3:1375\n10#3:1386\n10#3:1397\n10#3:1406\n10#3:1415\n10#3:1424\n10#3:1433\n*S KotlinDebug\n*F\n+ 1 Lucene90BlockTreeTermsWriter.kt\norg/gnit/lucenekmp/codecs/lucene90/blocktree/Lucene90BlockTreeTermsWriter$TermsWriter\n*L\n496#1:1249,8\n506#1:1258,8\n532#1:1267,2\n541#1:1269,8\n605#1:1278,8\n609#1:1287,8\n648#1:1296,8\n700#1:1305,2\n704#1:1307,2\n719#1:1309,8\n739#1:1318,2\n774#1:1320,8\n776#1:1329,8\n778#1:1338,8\n793#1:1347,2\n802#1:1349,8\n810#1:1358,8\n924#1:1367,8\n925#1:1376,2\n961#1:1378,8\n1011#1:1387,2\n1013#1:1389,8\n1022#1:1398,8\n1046#1:1407,8\n1050#1:1416,8\n1051#1:1425,8\n496#1:1257\n506#1:1266\n541#1:1277\n605#1:1286\n609#1:1295\n648#1:1304\n719#1:1317\n774#1:1328\n776#1:1337\n778#1:1346\n802#1:1357\n810#1:1366\n924#1:1375\n961#1:1386\n1013#1:1397\n1022#1:1406\n1046#1:1415\n1050#1:1424\n1051#1:1433\n*E\n"})
    public final class TermsWriter {
        @NotNull
        private final FieldInfo fieldInfo;
        private long numTerms;
        @NotNull
        private final FixedBitSet docsSeen;
        private long sumTotalTermFreq;
        private long sumDocFreq;
        @NotNull
        private final BytesRefBuilder lastTerm;
        @NotNull
        private int[] prefixStarts;
        @NotNull
        private final List<PendingEntry> pending;
        @NotNull
        private final List<PendingBlock> newBlocks;
        @Nullable
        private PendingTerm firstPendingTerm;
        @Nullable
        private PendingTerm lastPendingTerm;
        @NotNull
        private final ByteBuffersDataOutput suffixLengthsWriter;
        @NotNull
        private final BytesRefBuilder suffixWriter;
        @NotNull
        private final ByteBuffersDataOutput statsWriter;
        @NotNull
        private final ByteBuffersDataOutput metaWriter;
        @NotNull
        private final ByteBuffersDataOutput spareWriter;
        @NotNull
        private byte[] spareBytes;
        @Nullable
        private LZ4.HighCompressionHashTable compressionHashTable;

        public TermsWriter(FieldInfo fieldInfo) {
            Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
            this.fieldInfo = fieldInfo;
            this.lastTerm = new BytesRefBuilder();
            this.prefixStarts = new int[8];
            this.pending = new ArrayList();
            this.newBlocks = new ArrayList();
            this.suffixLengthsWriter = ByteBuffersDataOutput.Companion.newResettableInstance();
            this.suffixWriter = new BytesRefBuilder();
            this.statsWriter = ByteBuffersDataOutput.Companion.newResettableInstance();
            this.metaWriter = ByteBuffersDataOutput.Companion.newResettableInstance();
            this.spareWriter = ByteBuffersDataOutput.Companion.newResettableInstance();
            this.spareBytes = BytesRef.Companion.getEMPTY_BYTES();
            if (!(this.fieldInfo.getIndexOptions() != IndexOptions.NONE)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.docsSeen = new FixedBitSet(Lucene90BlockTreeTermsWriter.this.getMaxDoc());
            Lucene90BlockTreeTermsWriter.this.getPostingsWriter().setField(this.fieldInfo);
        }

        @NotNull
        public final FixedBitSet getDocsSeen() {
            return this.docsSeen;
        }

        public final long getSumTotalTermFreq() {
            return this.sumTotalTermFreq;
        }

        public final void setSumTotalTermFreq(long l) {
            this.sumTotalTermFreq = l;
        }

        public final long getSumDocFreq() {
            return this.sumDocFreq;
        }

        public final void setSumDocFreq(long l) {
            this.sumDocFreq = l;
        }

        public final void writeBlocks(int prefixLength, int count) throws IOException {
            boolean condition$iv = count > 0;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean $i$a$-assert-AssertKt$assert$22 = false;
                String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
                throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
            }
            condition$iv = prefixLength > 0 || count == this.pending.size();
            $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean $i$a$-assert-AssertKt$assert$32 = false;
                String $i$a$-assert-AssertKt$assert$32 = "assertion failed";
                throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$32);
            }
            int lastSuffixLeadLabel = 0;
            lastSuffixLeadLabel = -1;
            boolean hasTerms = false;
            boolean hasSubBlocks = false;
            int start = this.pending.size() - count;
            int end = this.pending.size();
            int nextBlockStart = start;
            int nextFloorLeadLabel = -1;
            for (int i = start; i < end; ++i) {
                PendingEntry ent = this.pending.get(i);
                int suffixLeadLabel = 0;
                if (ent.isTerm()) {
                    Intrinsics.checkNotNull((Object)ent, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.codecs.lucene90.blocktree.Lucene90BlockTreeTermsWriter.PendingTerm");
                    PendingTerm term = (PendingTerm)ent;
                    if (term.getTermBytes().length == prefixLength) {
                        boolean bl = lastSuffixLeadLabel == -1;
                        boolean $i$f$assert2 = false;
                        if (_Assertions.ENABLED && !condition$iv) {
                            boolean bl2 = false;
                            String string = "i=" + i + " lastSuffixLeadLabel=" + lastSuffixLeadLabel;
                            throw new AssertionError((Object)string);
                        }
                        suffixLeadLabel = -1;
                    } else {
                        suffixLeadLabel = term.getTermBytes()[prefixLength] & 0xFF;
                    }
                } else {
                    Intrinsics.checkNotNull((Object)ent, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.codecs.lucene90.blocktree.Lucene90BlockTreeTermsWriter.PendingBlock");
                    PendingBlock block2 = (PendingBlock)ent;
                    condition$iv = block2.getPrefix().getLength() > prefixLength;
                    boolean $i$f$assert3 = false;
                    if (_Assertions.ENABLED && !condition$iv) {
                        boolean bl = false;
                        String string = "assertion failed";
                        throw new AssertionError((Object)string);
                    }
                    suffixLeadLabel = (byte)(block2.getPrefix().getBytes()[block2.getPrefix().getOffset() + prefixLength] & 0xFFFFFFFF);
                }
                if (suffixLeadLabel != lastSuffixLeadLabel) {
                    int itemsInBlock = i - nextBlockStart;
                    if (itemsInBlock >= Lucene90BlockTreeTermsWriter.this.getMinItemsInBlock() && end - nextBlockStart > Lucene90BlockTreeTermsWriter.this.getMaxItemsInBlock()) {
                        boolean isFloor = itemsInBlock < count;
                        this.newBlocks.add(this.writeBlock(prefixLength, isFloor, nextFloorLeadLabel, nextBlockStart, i, hasTerms, hasSubBlocks));
                        hasTerms = false;
                        hasSubBlocks = false;
                        nextFloorLeadLabel = suffixLeadLabel;
                        nextBlockStart = i;
                    }
                    lastSuffixLeadLabel = suffixLeadLabel;
                }
                if (ent.isTerm()) {
                    hasTerms = true;
                    continue;
                }
                hasSubBlocks = true;
            }
            if (nextBlockStart < end) {
                int itemsInBlock = end - nextBlockStart;
                boolean isFloor = itemsInBlock < count;
                this.newBlocks.add(this.writeBlock(prefixLength, isFloor, nextFloorLeadLabel, nextBlockStart, end, hasTerms, hasSubBlocks));
            }
            boolean condition$iv2 = !this.newBlocks.isEmpty();
            boolean $i$f$assert4 = false;
            if (_Assertions.ENABLED && !condition$iv2) {
                boolean $i$a$-assert-AssertKt$assert$42 = false;
                String $i$a$-assert-AssertKt$assert$42 = "assertion failed";
                throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$42);
            }
            PendingBlock firstBlock = this.newBlocks.get(0);
            boolean condition$iv3 = firstBlock.isFloor() || this.newBlocks.size() == 1;
            boolean $i$f$assert5 = false;
            if (_Assertions.ENABLED && !condition$iv3) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            firstBlock.compileIndex(this.newBlocks, Lucene90BlockTreeTermsWriter.this.scratchBytes, Lucene90BlockTreeTermsWriter.this.scratchIntsRef);
            this.pending.subList(this.pending.size() - count, this.pending.size()).clear();
            this.pending.add(firstBlock);
            this.newBlocks.clear();
        }

        private final boolean allEqual(byte[] b, int startOffset, int endOffset, byte value) {
            Objects.INSTANCE.checkFromToIndex(startOffset, endOffset, b.length);
            for (int i = startOffset; i < endOffset; ++i) {
                if (b[i] == value) continue;
                return false;
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        private final PendingBlock writeBlock(int prefixLength, boolean isFloor, int floorLeadLabel, int start, int end, boolean hasTerms, boolean hasSubBlocks) throws IOException {
            boolean condition$iv = end > start;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean $i$a$-assert-AssertKt$assert$22 = false;
                String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
                throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
            }
            long startFP = Lucene90BlockTreeTermsWriter.this.termsOut.getFilePointer();
            boolean hasFloorLeadLabel = isFloor && floorLeadLabel != -1;
            BytesRef prefix = new BytesRef(prefixLength + (hasFloorLeadLabel ? 1 : 0));
            System.INSTANCE.arraycopy(this.lastTerm.get().getBytes(), 0, prefix.getBytes(), 0, prefixLength);
            prefix.setLength(prefixLength);
            int numEntries = end - start;
            int code = numEntries << 1;
            if (end == this.pending.size()) {
                code |= 1;
            }
            Lucene90BlockTreeTermsWriter.this.termsOut.writeVInt(code);
            boolean isLeafBlock = !hasSubBlocks;
            List subIndices = null;
            boolean absolute = true;
            if (isLeafBlock) {
                subIndices = null;
                statsWriter = new StatsWriter(this.statsWriter, this.fieldInfo.getIndexOptions() != IndexOptions.DOCS);
                for (i = start; i < end; ++i) {
                    PendingEntry ent = this.pending.get(i);
                    boolean condition$iv2 = ent.isTerm();
                    boolean $i$f$assert2 = false;
                    if (_Assertions.ENABLED && !condition$iv2) {
                        boolean bl = false;
                        String string = "i=" + i;
                        throw new AssertionError((Object)string);
                    }
                    Intrinsics.checkNotNull((Object)ent, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.codecs.lucene90.blocktree.Lucene90BlockTreeTermsWriter.PendingTerm");
                    PendingTerm term = (PendingTerm)ent;
                    boolean condition$iv3 = StringHelper.INSTANCE.startsWith(term.getTermBytes(), prefix);
                    $i$f$assert = false;
                    if (_Assertions.ENABLED && !condition$iv3) {
                        boolean bl = false;
                        String string = term + " prefix=" + prefix;
                        throw new AssertionError((Object)string);
                    }
                    BlockTermState state2 = term.getState();
                    suffix = term.getTermBytes().length - prefixLength;
                    this.suffixLengthsWriter.writeVInt(suffix);
                    this.suffixWriter.append(term.getTermBytes(), prefixLength, suffix);
                    boolean condition$iv4 = floorLeadLabel == -1 || (term.getTermBytes()[prefixLength] & 0xFF) >= floorLeadLabel;
                    boolean $i$f$assert3 = false;
                    if (_Assertions.ENABLED && !condition$iv4) {
                        boolean bl = false;
                        String string = "assertion failed";
                        throw new AssertionError((Object)string);
                    }
                    statsWriter.add(state2.getDocFreq(), state2.getTotalTermFreq());
                    Lucene90BlockTreeTermsWriter.this.getPostingsWriter().encodeTerm(this.metaWriter, this.fieldInfo, state2, absolute);
                    absolute = false;
                }
                statsWriter.finish();
            } else {
                void condition$iv5;
                subIndices = new ArrayList();
                statsWriter = new StatsWriter(this.statsWriter, this.fieldInfo.getIndexOptions() != IndexOptions.DOCS);
                for (i = start; i < end; ++i) {
                    PendingEntry ent = this.pending.get(i);
                    if (ent.isTerm()) {
                        Intrinsics.checkNotNull((Object)ent, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.codecs.lucene90.blocktree.Lucene90BlockTreeTermsWriter.PendingTerm");
                        PendingTerm term = (PendingTerm)ent;
                        boolean condition$iv6 = StringHelper.INSTANCE.startsWith(term.getTermBytes(), prefix);
                        $i$f$assert = false;
                        if (_Assertions.ENABLED && !condition$iv6) {
                            boolean bl = false;
                            String string = term + " prefix=" + prefix;
                            throw new AssertionError((Object)string);
                        }
                        BlockTermState state3 = term.getState();
                        suffix = term.getTermBytes().length - prefixLength;
                        this.suffixLengthsWriter.writeVInt(suffix << 1);
                        this.suffixWriter.append(term.getTermBytes(), prefixLength, suffix);
                        statsWriter.add(state3.getDocFreq(), state3.getTotalTermFreq());
                        Lucene90BlockTreeTermsWriter.this.getPostingsWriter().encodeTerm(this.metaWriter, this.fieldInfo, state3, absolute);
                        absolute = false;
                        continue;
                    }
                    Intrinsics.checkNotNull((Object)ent, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.codecs.lucene90.blocktree.Lucene90BlockTreeTermsWriter.PendingBlock");
                    PendingBlock block2 = (PendingBlock)ent;
                    boolean condition$iv7 = StringHelper.INSTANCE.startsWith(block2.getPrefix(), prefix);
                    boolean $i$f$assert4 = false;
                    if (_Assertions.ENABLED && !condition$iv7) {
                        boolean $i$a$-assert-AssertKt$assert$32 = false;
                        String $i$a$-assert-AssertKt$assert$32 = "assertion failed";
                        throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$32);
                    }
                    int suffix = block2.getPrefix().getLength() - prefixLength;
                    boolean condition$iv8 = StringHelper.INSTANCE.startsWith(block2.getPrefix(), prefix);
                    boolean $i$f$assert5 = false;
                    if (_Assertions.ENABLED && !condition$iv8) {
                        boolean $i$a$-assert-AssertKt$assert$42 = false;
                        String $i$a$-assert-AssertKt$assert$42 = "assertion failed";
                        throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$42);
                    }
                    condition$iv8 = suffix > 0;
                    $i$f$assert5 = false;
                    if (_Assertions.ENABLED && !condition$iv8) {
                        boolean $i$a$-assert-AssertKt$assert$52 = false;
                        String $i$a$-assert-AssertKt$assert$52 = "assertion failed";
                        throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$52);
                    }
                    this.suffixLengthsWriter.writeVInt(suffix << 1 | 1);
                    this.suffixWriter.append(block2.getPrefix().getBytes(), prefixLength, suffix);
                    condition$iv8 = floorLeadLabel == -1 || (byte)(block2.getPrefix().getBytes()[prefixLength] & 0xFFFFFFFF) >= floorLeadLabel;
                    $i$f$assert4 = false;
                    if (_Assertions.ENABLED && !condition$iv8) {
                        boolean bl = false;
                        String $i$a$-assert-AssertKt$assert$52 = "floorLeadLabel=" + floorLeadLabel + " suffixLead=" + (byte)(block2.getPrefix().getBytes()[prefixLength] & 0xFFFFFFFF);
                        throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$52);
                    }
                    condition$iv8 = block2.getFp() < startFP;
                    $i$f$assert5 = false;
                    if (_Assertions.ENABLED && !condition$iv8) {
                        boolean bl = false;
                        String string = "assertion failed";
                        throw new AssertionError((Object)string);
                    }
                    this.suffixLengthsWriter.writeVLong(startFP - block2.getFp());
                    ArrayList arrayList = (ArrayList)subIndices;
                    FST<BytesRef> fST = block2.getIndex();
                    Intrinsics.checkNotNull(fST);
                    arrayList.add(fST);
                }
                statsWriter.finish();
                i = !((Collection)subIndices).isEmpty() ? 1 : 0;
                boolean $i$f$assert6 = false;
                if (_Assertions.ENABLED && condition$iv5 == false) {
                    boolean $i$a$-assert-AssertKt$assert$62 = false;
                    String $i$a$-assert-AssertKt$assert$62 = "assertion failed";
                    throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$62);
                }
            }
            CompressionAlgorithm compressionAlg = CompressionAlgorithm.NO_COMPRESSION;
            if ((long)this.suffixWriter.length() > 2L * (long)numEntries && prefixLength > 2) {
                if ((long)this.suffixWriter.length() > 6L * (long)numEntries) {
                    if (this.compressionHashTable == null) {
                        this.compressionHashTable = new LZ4.HighCompressionHashTable();
                    }
                    byte[] byArray = this.suffixWriter.bytes();
                    int n = this.suffixWriter.length();
                    DataOutput dataOutput = this.spareWriter;
                    LZ4.HighCompressionHashTable highCompressionHashTable = this.compressionHashTable;
                    Intrinsics.checkNotNull((Object)highCompressionHashTable);
                    LZ4.INSTANCE.compress(byArray, 0, n, dataOutput, highCompressionHashTable);
                    if (this.spareWriter.size() < (long)(this.suffixWriter.length() - (this.suffixWriter.length() >>> 2))) {
                        compressionAlg = CompressionAlgorithm.LZ4;
                    }
                }
                if (compressionAlg == CompressionAlgorithm.NO_COMPRESSION) {
                    this.spareWriter.reset();
                    if (this.spareBytes.length < this.suffixWriter.length()) {
                        this.spareBytes = new byte[ArrayUtil.Companion.oversize(this.suffixWriter.length(), 1)];
                    }
                    if (LowercaseAsciiCompression.INSTANCE.compress(this.suffixWriter.bytes(), this.suffixWriter.length(), this.spareBytes, this.spareWriter)) {
                        compressionAlg = CompressionAlgorithm.LOWERCASE_ASCII;
                    }
                }
            }
            long token = (long)this.suffixWriter.length() << 3;
            if (isLeafBlock) {
                token |= 4L;
            }
            Lucene90BlockTreeTermsWriter.this.termsOut.writeVLong(token |= (long)compressionAlg.getCode());
            if (compressionAlg == CompressionAlgorithm.NO_COMPRESSION) {
                Lucene90BlockTreeTermsWriter.this.termsOut.writeBytes(this.suffixWriter.bytes(), this.suffixWriter.length());
            } else {
                this.spareWriter.copyTo(Lucene90BlockTreeTermsWriter.this.termsOut);
            }
            this.suffixWriter.setLength(0);
            this.spareWriter.reset();
            int numSuffixBytes = Math.INSTANCE.toIntExact(this.suffixLengthsWriter.size());
            this.spareBytes = ArrayUtil.Companion.growNoCopy(this.spareBytes, numSuffixBytes);
            this.suffixLengthsWriter.copyTo(new ByteArrayDataOutput(this.spareBytes));
            this.suffixLengthsWriter.reset();
            if (this.allEqual(this.spareBytes, 1, numSuffixBytes, this.spareBytes[0])) {
                Lucene90BlockTreeTermsWriter.this.termsOut.writeVInt(numSuffixBytes << 1 | 1);
                Lucene90BlockTreeTermsWriter.this.termsOut.writeByte(this.spareBytes[0]);
            } else {
                Lucene90BlockTreeTermsWriter.this.termsOut.writeVInt(numSuffixBytes << 1);
                Lucene90BlockTreeTermsWriter.this.termsOut.writeBytes(this.spareBytes, numSuffixBytes);
            }
            int numStatsBytes = Math.INSTANCE.toIntExact(this.statsWriter.size());
            Lucene90BlockTreeTermsWriter.this.termsOut.writeVInt(numStatsBytes);
            this.statsWriter.copyTo(Lucene90BlockTreeTermsWriter.this.termsOut);
            this.statsWriter.reset();
            Lucene90BlockTreeTermsWriter.this.termsOut.writeVInt((int)this.metaWriter.size());
            this.metaWriter.copyTo(Lucene90BlockTreeTermsWriter.this.termsOut);
            this.metaWriter.reset();
            if (hasFloorLeadLabel) {
                byte[] byArray = prefix.getBytes();
                int n = prefix.getLength();
                prefix.setLength(n + 1);
                byArray[n] = (byte)floorLeadLabel;
            }
            return new PendingBlock(prefix, startFP, hasTerms, isFloor, floorLeadLabel, subIndices);
        }

        public final void write(@NotNull BytesRef text, @NotNull TermsEnum termsEnum, @NotNull NormsProducer norms) throws IOException {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)termsEnum, (String)"termsEnum");
            Intrinsics.checkNotNullParameter((Object)norms, (String)"norms");
            BlockTermState state2 = Lucene90BlockTreeTermsWriter.this.getPostingsWriter().writeTerm(text, termsEnum, this.docsSeen, norms);
            if (state2 != null) {
                boolean condition$iv = state2.getDocFreq() != 0;
                boolean $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    boolean $i$a$-assert-AssertKt$assert$22 = false;
                    String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
                    throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
                }
                condition$iv = this.fieldInfo.getIndexOptions() == IndexOptions.DOCS || state2.getTotalTermFreq() >= (long)state2.getDocFreq();
                Lucene90BlockTreeTermsWriter lucene90BlockTreeTermsWriter = Lucene90BlockTreeTermsWriter.this;
                $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    boolean bl = false;
                    String string = "postingsWriter=" + lucene90BlockTreeTermsWriter.getPostingsWriter();
                    throw new AssertionError((Object)string);
                }
                this.pushTerm(text);
                PendingTerm term = new PendingTerm(text, state2);
                this.pending.add(term);
                this.sumDocFreq += (long)state2.getDocFreq();
                this.sumTotalTermFreq += state2.getTotalTermFreq();
                long l = this.numTerms;
                this.numTerms = l + 1L;
                if (this.firstPendingTerm == null) {
                    this.firstPendingTerm = term;
                }
                this.lastPendingTerm = term;
            }
        }

        private final void pushTerm(BytesRef text) throws IOException {
            int i;
            int n;
            int prefixLength = Arrays.INSTANCE.mismatch(this.lastTerm.bytes(), 0, this.lastTerm.length(), text.getBytes(), text.getOffset(), text.getOffset() + text.getLength());
            if (prefixLength == -1) {
                boolean condition$iv = this.lastTerm.length() == 0;
                boolean $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    boolean bl = false;
                    String string = "assertion failed";
                    throw new AssertionError((Object)string);
                }
                prefixLength = 0;
            }
            if ((n = prefixLength) <= (i = this.lastTerm.length() - 1)) {
                while (true) {
                    int prefixTopSize;
                    if ((prefixTopSize = this.pending.size() - this.prefixStarts[i]) >= Lucene90BlockTreeTermsWriter.this.getMinItemsInBlock()) {
                        this.writeBlocks(i + 1, prefixTopSize);
                        int[] nArray = this.prefixStarts;
                        int n2 = i;
                        nArray[n2] = nArray[n2] - (prefixTopSize - 1);
                    }
                    if (i == n) break;
                    --i;
                }
            }
            if (this.prefixStarts.length < text.getLength()) {
                this.prefixStarts = ArrayUtil.Companion.grow(this.prefixStarts, text.getLength());
            }
            n = text.getLength();
            for (i = prefixLength; i < n; ++i) {
                this.prefixStarts[i] = this.pending.size();
            }
            this.lastTerm.copyBytes(text);
        }

        public final void finish() throws IOException {
            if (this.numTerms > 0L) {
                this.pushTerm(new BytesRef());
                this.pushTerm(new BytesRef());
                this.writeBlocks(0, this.pending.size());
                boolean condition$iv = this.pending.size() == 1 && !this.pending.get(0).isTerm();
                boolean $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    boolean bl = false;
                    String string = "pending.size()=" + this.pending.size() + " pending=" + this.pending;
                    throw new AssertionError((Object)string);
                }
                PendingEntry pendingEntry = this.pending.get(0);
                Intrinsics.checkNotNull((Object)pendingEntry, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.codecs.lucene90.blocktree.Lucene90BlockTreeTermsWriter.PendingBlock");
                PendingBlock root = (PendingBlock)pendingEntry;
                boolean condition$iv2 = root.getPrefix().getLength() == 0;
                boolean $i$f$assert22 = false;
                if (_Assertions.ENABLED && !condition$iv2) {
                    boolean bl = false;
                    String string = "assertion failed";
                    throw new AssertionError((Object)string);
                }
                FST<BytesRef> fST = root.getIndex();
                Intrinsics.checkNotNull(fST);
                BytesRef bytesRef = fST.getEmptyOutput();
                if (bytesRef == null) {
                    String $i$f$assert22 = "Required value was null.";
                    throw new IllegalStateException($i$f$assert22.toString());
                }
                BytesRef rootCode = bytesRef;
                ByteBuffersDataOutput metaOut = new ByteBuffersDataOutput(0, 0, null, null, 15, null);
                Lucene90BlockTreeTermsWriter.this.fields.add(metaOut);
                metaOut.writeVInt(this.fieldInfo.getNumber());
                metaOut.writeVLong(this.numTerms);
                metaOut.writeVInt(rootCode.getLength());
                metaOut.writeBytes(rootCode.getBytes(), rootCode.getOffset(), rootCode.getLength());
                boolean condition$iv3 = this.fieldInfo.getIndexOptions() != IndexOptions.NONE;
                boolean $i$f$assert3 = false;
                if (_Assertions.ENABLED && !condition$iv3) {
                    boolean bl = false;
                    String string = "assertion failed";
                    throw new AssertionError((Object)string);
                }
                if (this.fieldInfo.getIndexOptions() != IndexOptions.DOCS) {
                    metaOut.writeVLong(this.sumTotalTermFreq);
                }
                metaOut.writeVLong(this.sumDocFreq);
                metaOut.writeVInt(this.docsSeen.cardinality());
                DataOutput dataOutput = metaOut;
                PendingTerm pendingTerm = this.firstPendingTerm;
                Intrinsics.checkNotNull((Object)pendingTerm);
                Companion.writeBytesRef(dataOutput, new BytesRef(pendingTerm.getTermBytes()));
                DataOutput dataOutput2 = metaOut;
                PendingTerm pendingTerm2 = this.lastPendingTerm;
                Intrinsics.checkNotNull((Object)pendingTerm2);
                Companion.writeBytesRef(dataOutput2, new BytesRef(pendingTerm2.getTermBytes()));
                metaOut.writeVLong(Lucene90BlockTreeTermsWriter.this.indexOut.getFilePointer());
                FST<BytesRef> fST2 = root.getIndex();
                Intrinsics.checkNotNull(fST2);
                fST2.save(metaOut, Lucene90BlockTreeTermsWriter.this.indexOut);
            } else {
                boolean condition$iv = this.sumTotalTermFreq == 0L || this.fieldInfo.getIndexOptions() == IndexOptions.DOCS && this.sumTotalTermFreq == -1L;
                boolean $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    boolean $i$a$-assert-AssertKt$assert$22 = false;
                    String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
                    throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
                }
                condition$iv = this.sumDocFreq == 0L;
                $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    boolean $i$a$-assert-AssertKt$assert$32 = false;
                    String $i$a$-assert-AssertKt$assert$32 = "assertion failed";
                    throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$32);
                }
                condition$iv = this.docsSeen.cardinality() == 0;
                $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    boolean bl = false;
                    String string = "assertion failed";
                    throw new AssertionError((Object)string);
                }
            }
        }
    }
}

