/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs.lucene90.compressing;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.codecs.CodecUtil;
import org.gnit.lucenekmp.codecs.lucene90.compressing.FieldsIndex;
import org.gnit.lucenekmp.index.IndexFileNames;
import org.gnit.lucenekmp.jdkport.Objects;
import org.gnit.lucenekmp.jdkport.UncheckedIOException;
import org.gnit.lucenekmp.store.Directory;
import org.gnit.lucenekmp.store.IOContext;
import org.gnit.lucenekmp.store.IndexInput;
import org.gnit.lucenekmp.store.RandomAccessInput;
import org.gnit.lucenekmp.store.ReadAdvice;
import org.gnit.lucenekmp.util.packed.DirectMonotonicReader;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001BI\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010B\u0011\b\u0012\u0012\u0006\u0010\u0011\u001a\u00020\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0012J\b\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020\u0014H\u0016J\u0010\u0010*\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020\u001cH\u0016J\u0010\u0010,\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020\u001cH\u0016J\b\u0010-\u001a\u00020\u0001H\u0016J\b\u0010.\u001a\u00020'H\u0016R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010#\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u0006/"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/compressing/FieldsIndexReader;", "Lorg/gnit/lucenekmp/codecs/lucene90/compressing/FieldsIndex;", "dir", "Lorg/gnit/lucenekmp/store/Directory;", "name", "", "suffix", "extension", "codecName", "id", "", "metaIn", "Lorg/gnit/lucenekmp/store/IndexInput;", "context", "Lorg/gnit/lucenekmp/store/IOContext;", "<init>", "(Lorg/gnit/lucenekmp/store/Directory;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;[BLorg/gnit/lucenekmp/store/IndexInput;Lorg/gnit/lucenekmp/store/IOContext;)V", "other", "(Lorg/gnit/lucenekmp/codecs/lucene90/compressing/FieldsIndexReader;)V", "maxDoc", "", "blockShift", "numChunks", "docsMeta", "Lorg/gnit/lucenekmp/util/packed/DirectMonotonicReader$Meta;", "startPointersMeta", "indexInput", "docsStartPointer", "", "docsEndPointer", "startPointersStartPointer", "startPointersEndPointer", "docs", "Lorg/gnit/lucenekmp/util/packed/DirectMonotonicReader;", "startPointers", "maxPointer", "getMaxPointer", "()J", "close", "", "getBlockID", "docID", "getBlockStartPointer", "blockIndex", "getBlockLength", "clone", "checkIntegrity", "core"})
public final class FieldsIndexReader
extends FieldsIndex {
    private final int maxDoc;
    private final int blockShift;
    private final int numChunks;
    @NotNull
    private final DirectMonotonicReader.Meta docsMeta;
    @NotNull
    private final DirectMonotonicReader.Meta startPointersMeta;
    @NotNull
    private final IndexInput indexInput;
    private final long docsStartPointer;
    private final long docsEndPointer;
    private final long startPointersStartPointer;
    private final long startPointersEndPointer;
    @NotNull
    private final DirectMonotonicReader docs;
    @NotNull
    private final DirectMonotonicReader startPointers;
    private final long maxPointer;

    public final long getMaxPointer() {
        return this.maxPointer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldsIndexReader(@NotNull Directory dir, @NotNull String name, @NotNull String suffix, @NotNull String extension, @NotNull String codecName, @NotNull byte[] id, @NotNull IndexInput metaIn, @NotNull IOContext context) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        Intrinsics.checkNotNullParameter((Object)codecName, (String)"codecName");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)metaIn, (String)"metaIn");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.maxDoc = metaIn.readInt();
        this.blockShift = metaIn.readInt();
        this.numChunks = metaIn.readInt();
        this.docsStartPointer = metaIn.readLong();
        this.docsMeta = DirectMonotonicReader.Companion.loadMeta(metaIn, this.numChunks, this.blockShift);
        this.docsEndPointer = this.startPointersStartPointer = metaIn.readLong();
        this.startPointersMeta = DirectMonotonicReader.Companion.loadMeta(metaIn, this.numChunks, this.blockShift);
        this.startPointersEndPointer = metaIn.readLong();
        this.maxPointer = metaIn.readLong();
        this.indexInput = dir.openInput(IndexFileNames.INSTANCE.segmentFileName(name, suffix, extension), context.withReadAdvice(ReadAdvice.RANDOM_PRELOAD));
        boolean success = false;
        try {
            CodecUtil.INSTANCE.checkIndexHeader(this.indexInput, codecName + "Idx", 0, 0, id, suffix);
            CodecUtil.INSTANCE.retrieveChecksum(this.indexInput);
            success = true;
        }
        catch (Throwable throwable) {
            this.indexInput.close();
            throw throwable;
        }
        RandomAccessInput docsSlice = this.indexInput.randomAccessSlice(this.docsStartPointer, this.docsEndPointer - this.docsStartPointer);
        RandomAccessInput startPointersSlice = this.indexInput.randomAccessSlice(this.startPointersStartPointer, this.startPointersEndPointer - this.startPointersStartPointer);
        this.docs = DirectMonotonicReader.Companion.getInstance(this.docsMeta, docsSlice);
        this.startPointers = DirectMonotonicReader.Companion.getInstance(this.startPointersMeta, startPointersSlice);
    }

    private FieldsIndexReader(FieldsIndexReader other) {
        this.maxDoc = other.maxDoc;
        this.numChunks = other.numChunks;
        this.blockShift = other.blockShift;
        this.docsMeta = other.docsMeta;
        this.startPointersMeta = other.startPointersMeta;
        this.indexInput = other.indexInput.clone();
        this.docsStartPointer = other.docsStartPointer;
        this.docsEndPointer = other.docsEndPointer;
        this.startPointersStartPointer = other.startPointersStartPointer;
        this.startPointersEndPointer = other.startPointersEndPointer;
        this.maxPointer = other.maxPointer;
        RandomAccessInput docsSlice = this.indexInput.randomAccessSlice(this.docsStartPointer, this.docsEndPointer - this.docsStartPointer);
        RandomAccessInput startPointersSlice = this.indexInput.randomAccessSlice(this.startPointersStartPointer, this.startPointersEndPointer - this.startPointersStartPointer);
        this.docs = DirectMonotonicReader.Companion.getInstance(this.docsMeta, docsSlice);
        this.startPointers = DirectMonotonicReader.Companion.getInstance(this.startPointersMeta, startPointersSlice);
    }

    @Override
    public void close() throws IOException {
        this.indexInput.close();
    }

    @Override
    public long getBlockID(int docID) {
        Objects.INSTANCE.checkIndex(docID, this.maxDoc);
        long blockIndex = this.docs.binarySearch(0L, this.numChunks, docID);
        if (blockIndex < 0L) {
            blockIndex = (long)-2 - blockIndex;
        }
        return blockIndex;
    }

    @Override
    public long getBlockStartPointer(long blockIndex) {
        return this.startPointers.get(blockIndex);
    }

    @Override
    public long getBlockLength(long blockIndex) {
        long endPointer = blockIndex == (long)(this.numChunks - 1) ? this.maxPointer : this.startPointers.get(blockIndex + 1L);
        return endPointer - this.getBlockStartPointer(blockIndex);
    }

    @Override
    @NotNull
    public FieldsIndex clone() {
        try {
            return new FieldsIndexReader(this);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void checkIntegrity() throws IOException {
        CodecUtil.INSTANCE.checksumEntireFile(this.indexInput);
    }
}

