/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs.lucene90.compressing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.codecs.CodecUtil;
import org.gnit.lucenekmp.codecs.StoredFieldsReader;
import org.gnit.lucenekmp.codecs.StoredFieldsWriter;
import org.gnit.lucenekmp.codecs.compressing.CompressionMode;
import org.gnit.lucenekmp.codecs.compressing.Compressor;
import org.gnit.lucenekmp.codecs.compressing.MatchingReaders;
import org.gnit.lucenekmp.codecs.lucene90.compressing.FieldsIndex;
import org.gnit.lucenekmp.codecs.lucene90.compressing.FieldsIndexWriter;
import org.gnit.lucenekmp.codecs.lucene90.compressing.Lucene90CompressingStoredFieldsReader;
import org.gnit.lucenekmp.codecs.lucene90.compressing.StoredFieldsInts;
import org.gnit.lucenekmp.index.CorruptIndexException;
import org.gnit.lucenekmp.index.DocIDMerger;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.IndexFileNames;
import org.gnit.lucenekmp.index.MergeState;
import org.gnit.lucenekmp.index.SegmentInfo;
import org.gnit.lucenekmp.index.StoredFieldDataInput;
import org.gnit.lucenekmp.jdkport.DoubleExtKt;
import org.gnit.lucenekmp.jdkport.FloatExtKt;
import org.gnit.lucenekmp.jdkport.Math;
import org.gnit.lucenekmp.jdkport.System;
import org.gnit.lucenekmp.store.ByteBuffersDataInput;
import org.gnit.lucenekmp.store.ByteBuffersDataOutput;
import org.gnit.lucenekmp.store.DataOutput;
import org.gnit.lucenekmp.store.Directory;
import org.gnit.lucenekmp.store.IOContext;
import org.gnit.lucenekmp.store.IndexInput;
import org.gnit.lucenekmp.store.IndexOutput;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.BitUtil;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.IOUtils;
import org.gnit.lucenekmp.util.packed.PackedInts;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 S2\u00020\u0001:\u0003QRSBQ\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0010\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0012J\b\u0010&\u001a\u00020'H\u0016J\b\u0010)\u001a\u00020'H\u0016J\b\u0010*\u001a\u00020'H\u0016J8\u0010+\u001a\u00020'2\u0006\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.H\u0002J\b\u00100\u001a\u00020.H\u0002J\u0010\u00101\u001a\u00020'2\u0006\u00102\u001a\u00020.H\u0002J\u001a\u00103\u001a\u00020'2\b\u00104\u001a\u0004\u0018\u0001052\u0006\u00106\u001a\u00020\u000eH\u0016J\u001a\u00103\u001a\u00020'2\b\u00104\u001a\u0004\u0018\u0001052\u0006\u00106\u001a\u00020#H\u0016J\u001a\u00103\u001a\u00020'2\b\u00104\u001a\u0004\u0018\u0001052\u0006\u00106\u001a\u000207H\u0016J\u001a\u00103\u001a\u00020'2\b\u00104\u001a\u0004\u0018\u0001052\u0006\u00106\u001a\u000208H\u0016J\u001a\u00103\u001a\u00020'2\b\u00104\u001a\u0004\u0018\u0001052\u0006\u00106\u001a\u000209H\u0016J\u001a\u00103\u001a\u00020'2\b\u00104\u001a\u0004\u0018\u0001052\u0006\u00106\u001a\u00020:H\u0016J\u001a\u00103\u001a\u00020'2\b\u00104\u001a\u0004\u0018\u0001052\u0006\u00106\u001a\u00020\u0007H\u0016J\u0010\u0010;\u001a\u00020'2\u0006\u0010<\u001a\u00020\u000eH\u0016J\u0018\u0010=\u001a\u00020'2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020\u000eH\u0002J(\u0010A\u001a\u00020'2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020\u000e2\u0006\u0010G\u001a\u00020\u000eH\u0002J\u0010\u0010H\u001a\u00020\u000e2\u0006\u0010B\u001a\u00020CH\u0016J\u000e\u0010I\u001a\u00020.2\u0006\u0010J\u001a\u00020?J \u0010K\u001a\u00020L2\u0006\u0010B\u001a\u00020C2\u0006\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020\u000eH\u0002J\b\u0010P\u001a\u00020#H\u0016R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006T"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/compressing/Lucene90CompressingStoredFieldsWriter;", "Lorg/gnit/lucenekmp/codecs/StoredFieldsWriter;", "directory", "Lorg/gnit/lucenekmp/store/Directory;", "si", "Lorg/gnit/lucenekmp/index/SegmentInfo;", "segmentSuffix", "", "context", "Lorg/gnit/lucenekmp/store/IOContext;", "formatName", "compressionMode", "Lorg/gnit/lucenekmp/codecs/compressing/CompressionMode;", "chunkSize", "", "maxDocsPerChunk", "blockShift", "<init>", "(Lorg/gnit/lucenekmp/store/Directory;Lorg/gnit/lucenekmp/index/SegmentInfo;Ljava/lang/String;Lorg/gnit/lucenekmp/store/IOContext;Ljava/lang/String;Lorg/gnit/lucenekmp/codecs/compressing/CompressionMode;III)V", "segment", "indexWriter", "Lorg/gnit/lucenekmp/codecs/lucene90/compressing/FieldsIndexWriter;", "metaStream", "Lorg/gnit/lucenekmp/store/IndexOutput;", "fieldsStream", "compressor", "Lorg/gnit/lucenekmp/codecs/compressing/Compressor;", "bufferedDocs", "Lorg/gnit/lucenekmp/store/ByteBuffersDataOutput;", "numStoredFields", "", "endOffsets", "docBase", "numBufferedDocs", "numChunks", "", "numDirtyChunks", "numDirtyDocs", "close", "", "numStoredFieldsInDoc", "startDocument", "finishDocument", "writeHeader", "lengths", "sliced", "", "dirtyChunk", "triggerFlush", "flush", "force", "writeField", "info", "Lorg/gnit/lucenekmp/index/FieldInfo;", "value", "", "", "Lorg/gnit/lucenekmp/util/BytesRef;", "Lorg/gnit/lucenekmp/index/StoredFieldDataInput;", "finish", "numDocs", "copyOneDoc", "reader", "Lorg/gnit/lucenekmp/codecs/lucene90/compressing/Lucene90CompressingStoredFieldsReader;", "docID", "copyChunks", "mergeState", "Lorg/gnit/lucenekmp/index/MergeState;", "sub", "Lorg/gnit/lucenekmp/codecs/lucene90/compressing/Lucene90CompressingStoredFieldsWriter$CompressingStoredFieldsMergeSub;", "fromDocID", "toDocID", "merge", "tooDirty", "candidate", "getMergeStrategy", "Lorg/gnit/lucenekmp/codecs/lucene90/compressing/Lucene90CompressingStoredFieldsWriter$MergeStrategy;", "matchingReaders", "Lorg/gnit/lucenekmp/codecs/compressing/MatchingReaders;", "readerIndex", "ramBytesUsed", "MergeStrategy", "CompressingStoredFieldsMergeSub", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nLucene90CompressingStoredFieldsWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Lucene90CompressingStoredFieldsWriter.kt\norg/gnit/lucenekmp/codecs/lucene90/compressing/Lucene90CompressingStoredFieldsWriter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,732:1\n1#2:733\n*E\n"})
public final class Lucene90CompressingStoredFieldsWriter
extends StoredFieldsWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String segment;
    @Nullable
    private FieldsIndexWriter indexWriter;
    @Nullable
    private IndexOutput metaStream;
    @Nullable
    private IndexOutput fieldsStream;
    @Nullable
    private Compressor compressor;
    @NotNull
    private final CompressionMode compressionMode;
    private final int chunkSize;
    private final int maxDocsPerChunk;
    @NotNull
    private final ByteBuffersDataOutput bufferedDocs;
    @NotNull
    private int[] numStoredFields;
    @NotNull
    private int[] endOffsets;
    private int docBase;
    private int numBufferedDocs;
    private long numChunks;
    private long numDirtyChunks;
    private long numDirtyDocs;
    private int numStoredFieldsInDoc;
    @NotNull
    public static final String FIELDS_EXTENSION = "fdt";
    @NotNull
    public static final String INDEX_EXTENSION = "fdx";
    @NotNull
    public static final String META_EXTENSION = "fdm";
    @NotNull
    public static final String INDEX_CODEC_NAME = "Lucene90FieldsIndex";
    public static final int STRING = 0;
    public static final int BYTE_ARR = 1;
    public static final int NUMERIC_INT = 2;
    public static final int NUMERIC_FLOAT = 3;
    public static final int NUMERIC_LONG = 4;
    public static final int NUMERIC_DOUBLE = 5;
    private static final int TYPE_BITS = PackedInts.INSTANCE.bitsRequired(5L);
    private static final int TYPE_MASK = (int)PackedInts.INSTANCE.maxValue(TYPE_BITS);
    public static final int VERSION_START = 1;
    public static final int VERSION_CURRENT = 1;
    public static final int META_VERSION_START = 0;
    private static final int NEGATIVE_ZERO_FLOAT = FloatExtKt.floatToIntBits(FloatCompanionObject.INSTANCE, -0.0f);
    private static final long NEGATIVE_ZERO_DOUBLE = DoubleExtKt.doubleToLongBits(DoubleCompanionObject.INSTANCE, -0.0);
    public static final long SECOND = 1000L;
    public static final long HOUR = 3600000L;
    public static final long DAY = 86400000L;
    public static final int SECOND_ENCODING = 64;
    public static final int HOUR_ENCODING = 128;
    public static final int DAY_ENCODING = 192;
    @NotNull
    private static final String BULK_MERGE_ENABLED_SYSPROP = Reflection.getOrCreateKotlinClass(Lucene90CompressingStoredFieldsWriter.class).getQualifiedName() + ".enableBulkMerge";
    private static final boolean BULK_MERGE_ENABLED;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lucene90CompressingStoredFieldsWriter(@NotNull Directory directory, @NotNull SegmentInfo si, @NotNull String segmentSuffix, @NotNull IOContext context, @NotNull String formatName, @NotNull CompressionMode compressionMode, int chunkSize, int maxDocsPerChunk, int blockShift) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)si, (String)"si");
        Intrinsics.checkNotNullParameter((Object)segmentSuffix, (String)"segmentSuffix");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)formatName, (String)"formatName");
        Intrinsics.checkNotNullParameter((Object)compressionMode, (String)"compressionMode");
        this.segment = si.getName();
        this.compressionMode = compressionMode;
        this.compressor = compressionMode.newCompressor();
        this.chunkSize = chunkSize;
        this.maxDocsPerChunk = maxDocsPerChunk;
        this.docBase = 0;
        this.bufferedDocs = ByteBuffersDataOutput.Companion.newResettableInstance();
        this.numStoredFields = new int[16];
        this.endOffsets = new int[16];
        this.numBufferedDocs = 0;
        boolean success = false;
        try {
            IndexOutput indexOutput = this.metaStream = directory.createOutput(IndexFileNames.INSTANCE.segmentFileName(this.segment, segmentSuffix, META_EXTENSION), context);
            Intrinsics.checkNotNull((Object)indexOutput);
            CodecUtil.INSTANCE.writeIndexHeader(indexOutput, "Lucene90FieldsIndexMeta", 1, si.getId(), segmentSuffix);
            long l = CodecUtil.INSTANCE.indexHeaderLength("Lucene90FieldsIndexMeta", segmentSuffix);
            IndexOutput indexOutput2 = this.metaStream;
            Intrinsics.checkNotNull((Object)indexOutput2);
            if (!(l == indexOutput2.getFilePointer())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            IndexOutput indexOutput3 = this.fieldsStream = directory.createOutput(IndexFileNames.INSTANCE.segmentFileName(this.segment, segmentSuffix, FIELDS_EXTENSION), context);
            Intrinsics.checkNotNull((Object)indexOutput3);
            CodecUtil.INSTANCE.writeIndexHeader(indexOutput3, formatName, 1, si.getId(), segmentSuffix);
            long l2 = CodecUtil.INSTANCE.indexHeaderLength(formatName, segmentSuffix);
            IndexOutput indexOutput4 = this.fieldsStream;
            Intrinsics.checkNotNull((Object)indexOutput4);
            if (!(l2 == indexOutput4.getFilePointer())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.indexWriter = new FieldsIndexWriter(directory, this.segment, segmentSuffix, INDEX_EXTENSION, INDEX_CODEC_NAME, si.getId(), blockShift, context);
            IndexOutput indexOutput5 = this.metaStream;
            Intrinsics.checkNotNull((Object)indexOutput5);
            indexOutput5.writeVInt(chunkSize);
            success = true;
        }
        catch (Throwable throwable) {
            AutoCloseable[] autoCloseableArray = new AutoCloseable[]{this.metaStream, this.fieldsStream, this.indexWriter};
            IOUtils.INSTANCE.closeWhileHandlingExceptionNullable(autoCloseableArray);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            AutoCloseable[] autoCloseableArray = new AutoCloseable[4];
            Intrinsics.checkNotNull((Object)this.metaStream);
            Intrinsics.checkNotNull((Object)this.fieldsStream);
            Intrinsics.checkNotNull((Object)this.indexWriter);
            Intrinsics.checkNotNull((Object)this.compressor);
            IOUtils.INSTANCE.close(autoCloseableArray);
        }
        finally {
            this.metaStream = null;
            this.fieldsStream = null;
            this.indexWriter = null;
            this.compressor = null;
        }
    }

    @Override
    public void startDocument() throws IOException {
    }

    @Override
    public void finishDocument() throws IOException {
        if (this.numBufferedDocs == this.numStoredFields.length) {
            int newLength = ArrayUtil.Companion.oversize(this.numBufferedDocs + 1, 4);
            this.numStoredFields = ArrayUtil.Companion.growExact(this.numStoredFields, newLength);
            this.endOffsets = ArrayUtil.Companion.growExact(this.endOffsets, newLength);
        }
        this.numStoredFields[this.numBufferedDocs] = this.numStoredFieldsInDoc;
        this.numStoredFieldsInDoc = 0;
        this.endOffsets[this.numBufferedDocs] = Math.INSTANCE.toIntExact(this.bufferedDocs.size());
        ++this.numBufferedDocs;
        if (this.triggerFlush()) {
            this.flush(false);
        }
    }

    private final void writeHeader(int docBase, int numBufferedDocs, int[] numStoredFields, int[] lengths, boolean sliced, boolean dirtyChunk) throws IOException {
        int slicedBit = sliced ? 1 : 0;
        int dirtyBit = dirtyChunk ? 2 : 0;
        IndexOutput indexOutput = this.fieldsStream;
        Intrinsics.checkNotNull((Object)indexOutput);
        indexOutput.writeVInt(docBase);
        IndexOutput indexOutput2 = this.fieldsStream;
        Intrinsics.checkNotNull((Object)indexOutput2);
        indexOutput2.writeVInt(numBufferedDocs << 2 | dirtyBit | slicedBit);
        IndexOutput indexOutput3 = this.fieldsStream;
        Intrinsics.checkNotNull((Object)indexOutput3);
        Lucene90CompressingStoredFieldsWriter.Companion.saveInts(numStoredFields, numBufferedDocs, indexOutput3);
        IndexOutput indexOutput4 = this.fieldsStream;
        Intrinsics.checkNotNull((Object)indexOutput4);
        Lucene90CompressingStoredFieldsWriter.Companion.saveInts(lengths, numBufferedDocs, indexOutput4);
    }

    private final boolean triggerFlush() {
        return this.bufferedDocs.size() >= (long)this.chunkSize || this.numBufferedDocs >= this.maxDocsPerChunk;
    }

    private final void flush(boolean force) throws IOException {
        if (!(this.triggerFlush() != force)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        long l = this.numChunks;
        this.numChunks = l + 1L;
        if (force) {
            l = this.numDirtyChunks;
            this.numDirtyChunks = l + 1L;
            this.numDirtyDocs += (long)this.numBufferedDocs;
        }
        FieldsIndexWriter fieldsIndexWriter = this.indexWriter;
        Intrinsics.checkNotNull((Object)fieldsIndexWriter);
        IndexOutput indexOutput = this.fieldsStream;
        Intrinsics.checkNotNull((Object)indexOutput);
        fieldsIndexWriter.writeIndex(this.numBufferedDocs, indexOutput.getFilePointer());
        int[] lengths = this.endOffsets;
        for (int i = this.numBufferedDocs - 1; 0 < i; --i) {
            lengths[i] = this.endOffsets[i] - this.endOffsets[i - 1];
            if (lengths[i] >= 0) continue;
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        boolean sliced = this.bufferedDocs.size() >= 2L * (long)this.chunkSize;
        boolean dirtyChunk = force;
        this.writeHeader(this.docBase, this.numBufferedDocs, this.numStoredFields, lengths, sliced, dirtyChunk);
        ByteBuffersDataInput bytebuffers = this.bufferedDocs.toDataInput();
        if (sliced) {
            int capacity = (int)bytebuffers.length();
            for (int compressed = 0; compressed < capacity; compressed += this.chunkSize) {
                int l2 = java.lang.Math.min(this.chunkSize, capacity - compressed);
                ByteBuffersDataInput bbdi = bytebuffers.slice(compressed, l2);
                Compressor compressor = this.compressor;
                Intrinsics.checkNotNull((Object)compressor);
                IndexOutput indexOutput2 = this.fieldsStream;
                Intrinsics.checkNotNull((Object)indexOutput2);
                compressor.compress(bbdi, indexOutput2);
            }
        } else {
            Compressor compressor = this.compressor;
            Intrinsics.checkNotNull((Object)compressor);
            IndexOutput indexOutput3 = this.fieldsStream;
            Intrinsics.checkNotNull((Object)indexOutput3);
            compressor.compress(bytebuffers, indexOutput3);
        }
        this.docBase += this.numBufferedDocs;
        this.numBufferedDocs = 0;
        this.bufferedDocs.reset();
    }

    @Override
    public void writeField(@Nullable FieldInfo info, int value) throws IOException {
        ++this.numStoredFieldsInDoc;
        FieldInfo fieldInfo = info;
        Intrinsics.checkNotNull((Object)fieldInfo);
        long infoAndBits = (long)fieldInfo.getNumber() << TYPE_BITS | 2L;
        this.bufferedDocs.writeVLong(infoAndBits);
        this.bufferedDocs.writeZInt(value);
    }

    @Override
    public void writeField(@Nullable FieldInfo info, long value) throws IOException {
        ++this.numStoredFieldsInDoc;
        FieldInfo fieldInfo = info;
        Intrinsics.checkNotNull((Object)fieldInfo);
        long infoAndBits = (long)fieldInfo.getNumber() << TYPE_BITS | 4L;
        this.bufferedDocs.writeVLong(infoAndBits);
        Companion.writeTLong(this.bufferedDocs, value);
    }

    @Override
    public void writeField(@Nullable FieldInfo info, float value) throws IOException {
        ++this.numStoredFieldsInDoc;
        FieldInfo fieldInfo = info;
        Intrinsics.checkNotNull((Object)fieldInfo);
        long infoAndBits = (long)fieldInfo.getNumber() << TYPE_BITS | 3L;
        this.bufferedDocs.writeVLong(infoAndBits);
        Companion.writeZFloat(this.bufferedDocs, value);
    }

    @Override
    public void writeField(@Nullable FieldInfo info, double value) throws IOException {
        ++this.numStoredFieldsInDoc;
        FieldInfo fieldInfo = info;
        Intrinsics.checkNotNull((Object)fieldInfo);
        long infoAndBits = (long)fieldInfo.getNumber() << TYPE_BITS | 5L;
        this.bufferedDocs.writeVLong(infoAndBits);
        Companion.writeZDouble(this.bufferedDocs, value);
    }

    @Override
    public void writeField(@Nullable FieldInfo info, @NotNull BytesRef value) throws IOException {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ++this.numStoredFieldsInDoc;
        FieldInfo fieldInfo = info;
        Intrinsics.checkNotNull((Object)fieldInfo);
        long infoAndBits = (long)fieldInfo.getNumber() << TYPE_BITS | 1L;
        this.bufferedDocs.writeVLong(infoAndBits);
        this.bufferedDocs.writeVInt(value.getLength());
        this.bufferedDocs.writeBytes(value.getBytes(), value.getOffset(), value.getLength());
    }

    @Override
    public void writeField(@Nullable FieldInfo info, @NotNull StoredFieldDataInput value) throws IOException {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        int length = value.getLength();
        ++this.numStoredFieldsInDoc;
        FieldInfo fieldInfo = info;
        Intrinsics.checkNotNull((Object)fieldInfo);
        long infoAndBits = (long)fieldInfo.getNumber() << TYPE_BITS | 1L;
        this.bufferedDocs.writeVLong(infoAndBits);
        this.bufferedDocs.writeVInt(length);
        this.bufferedDocs.copyBytes(value.getDataInput(), length);
    }

    @Override
    public void writeField(@Nullable FieldInfo info, @NotNull String value) throws IOException {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ++this.numStoredFieldsInDoc;
        FieldInfo fieldInfo = info;
        Intrinsics.checkNotNull((Object)fieldInfo);
        long infoAndBits = (long)fieldInfo.getNumber() << TYPE_BITS | 0L;
        this.bufferedDocs.writeVLong(infoAndBits);
        this.bufferedDocs.writeString(value);
    }

    @Override
    public void finish(int numDocs) throws IOException {
        if (this.numBufferedDocs > 0) {
            this.flush(true);
        } else if (!(this.bufferedDocs.size() == 0L)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.docBase != numDocs) {
            throw new RuntimeException("Wrote " + this.docBase + " docs, finish called with numDocs=" + numDocs);
        }
        FieldsIndexWriter fieldsIndexWriter = this.indexWriter;
        Intrinsics.checkNotNull((Object)fieldsIndexWriter);
        IndexOutput indexOutput = this.fieldsStream;
        Intrinsics.checkNotNull((Object)indexOutput);
        long l = indexOutput.getFilePointer();
        IndexOutput indexOutput2 = this.metaStream;
        Intrinsics.checkNotNull((Object)indexOutput2);
        fieldsIndexWriter.finish(numDocs, l, indexOutput2);
        IndexOutput indexOutput3 = this.metaStream;
        Intrinsics.checkNotNull((Object)indexOutput3);
        indexOutput3.writeVLong(this.numChunks);
        IndexOutput indexOutput4 = this.metaStream;
        Intrinsics.checkNotNull((Object)indexOutput4);
        indexOutput4.writeVLong(this.numDirtyChunks);
        IndexOutput indexOutput5 = this.metaStream;
        Intrinsics.checkNotNull((Object)indexOutput5);
        indexOutput5.writeVLong(this.numDirtyDocs);
        IndexOutput indexOutput6 = this.metaStream;
        Intrinsics.checkNotNull((Object)indexOutput6);
        CodecUtil.INSTANCE.writeFooter(indexOutput6);
        IndexOutput indexOutput7 = this.fieldsStream;
        Intrinsics.checkNotNull((Object)indexOutput7);
        CodecUtil.INSTANCE.writeFooter(indexOutput7);
        if (!(this.bufferedDocs.size() == 0L)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    private final void copyOneDoc(Lucene90CompressingStoredFieldsReader reader2, int docID) throws IOException {
        if (!(reader2.getVersion() == 1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Lucene90CompressingStoredFieldsReader.SerializedDocument doc = reader2.serializedDocument(docID);
        this.startDocument();
        this.bufferedDocs.copyBytes(doc.getIn(), doc.getLength());
        this.numStoredFieldsInDoc = doc.getNumStoredFields();
        this.finishDocument();
    }

    private final void copyChunks(MergeState mergeState, CompressingStoredFieldsMergeSub sub, int fromDocID, int toDocID) throws IOException {
        long toPointer;
        StoredFieldsReader storedFieldsReader = mergeState.getStoredFieldsReaders()[sub.getReaderIndex()];
        Intrinsics.checkNotNull((Object)storedFieldsReader, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.codecs.lucene90.compressing.Lucene90CompressingStoredFieldsReader");
        Lucene90CompressingStoredFieldsReader reader2 = (Lucene90CompressingStoredFieldsReader)storedFieldsReader;
        if (!(reader2.getVersion() == 1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(reader2.getChunkSize() == this.chunkSize)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(reader2.getCompressionMode() == this.compressionMode)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(!this.tooDirty(reader2))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(mergeState.getLiveDocs()[sub.getReaderIndex()] == null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int docID = fromDocID;
        FieldsIndex index = reader2.getIndexReader();
        while (docID < toDocID && reader2.isLoaded(docID)) {
            this.copyOneDoc(reader2, docID++);
        }
        if (docID >= toDocID) {
            return;
        }
        long fromPointer = index.getStartPointer(docID);
        long l = toPointer = toDocID == sub.getMaxDoc() ? reader2.getMaxPointer() : index.getStartPointer(toDocID);
        if (fromPointer < toPointer) {
            long endChunkPointer;
            if (this.numBufferedDocs > 0) {
                this.flush(true);
            }
            IndexInput rawDocs = reader2.getFieldsStream();
            rawDocs.seek(fromPointer);
            do {
                boolean dirtyChunk;
                int base = rawDocs.readVInt();
                int code = rawDocs.readVInt();
                int bufferedDocs = code >>> 2;
                if (base != docID) {
                    throw new CorruptIndexException("invalid state: base=" + base + ", docID=" + docID, rawDocs);
                }
                FieldsIndexWriter fieldsIndexWriter = this.indexWriter;
                Intrinsics.checkNotNull((Object)fieldsIndexWriter);
                IndexOutput indexOutput = this.fieldsStream;
                Intrinsics.checkNotNull((Object)indexOutput);
                fieldsIndexWriter.writeIndex(bufferedDocs, indexOutput.getFilePointer());
                IndexOutput indexOutput2 = this.fieldsStream;
                Intrinsics.checkNotNull((Object)indexOutput2);
                indexOutput2.writeVInt(this.docBase);
                IndexOutput indexOutput3 = this.fieldsStream;
                Intrinsics.checkNotNull((Object)indexOutput3);
                indexOutput3.writeVInt(code);
                this.docBase += bufferedDocs;
                if ((docID += bufferedDocs) > toDocID) {
                    throw new CorruptIndexException("invalid state: base=" + base + ", count=" + bufferedDocs + ", toDocID=" + toDocID, rawDocs);
                }
                endChunkPointer = docID == sub.getMaxDoc() ? reader2.getMaxPointer() : index.getStartPointer(docID);
                IndexOutput indexOutput4 = this.fieldsStream;
                Intrinsics.checkNotNull((Object)indexOutput4);
                indexOutput4.copyBytes(rawDocs, endChunkPointer - rawDocs.getFilePointer());
                ++this.numChunks;
                boolean bl = dirtyChunk = (code & 2) != 0;
                if (!dirtyChunk) continue;
                if (!(bufferedDocs < this.maxDocsPerChunk)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                ++this.numDirtyChunks;
                this.numDirtyDocs += (long)bufferedDocs;
            } while ((fromPointer = endChunkPointer) < toPointer);
        }
        if (!(!reader2.isLoaded(docID))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        while (docID < toDocID) {
            this.copyOneDoc(reader2, docID++);
        }
    }

    @Override
    public int merge(@NotNull MergeState mergeState) throws IOException {
        Intrinsics.checkNotNullParameter((Object)mergeState, (String)"mergeState");
        MatchingReaders matchingReaders = new MatchingReaders(mergeState);
        StoredFieldsWriter.MergeVisitor[] visitors = new StoredFieldsWriter.MergeVisitor[mergeState.getStoredFieldsReaders().length];
        List subs = new ArrayList(mergeState.getStoredFieldsReaders().length);
        int n = mergeState.getStoredFieldsReaders().length;
        for (int i = 0; i < n; ++i) {
            StoredFieldsReader reader2;
            Intrinsics.checkNotNull((Object)mergeState.getStoredFieldsReaders()[i]);
            reader2.checkIntegrity();
            MergeStrategy mergeStrategy = this.getMergeStrategy(mergeState, matchingReaders, i);
            if (mergeStrategy == MergeStrategy.VISITOR) {
                visitors[i] = new StoredFieldsWriter.MergeVisitor(mergeState, i);
            }
            subs.add(new CompressingStoredFieldsMergeSub(mergeState, mergeStrategy, i));
        }
        int docCount = 0;
        DocIDMerger docIDMerger = DocIDMerger.Companion.of(subs, mergeState.getNeedsIndexSort());
        CompressingStoredFieldsMergeSub sub = null;
        sub = (CompressingStoredFieldsMergeSub)docIDMerger.next();
        while (sub != null) {
            StoredFieldsReader reader3;
            if (!(((CompressingStoredFieldsMergeSub)sub).getMappedDocID() == docCount)) {
                boolean $i$a$-require-Lucene90CompressingStoredFieldsWriter$merge$22 = false;
                String $i$a$-require-Lucene90CompressingStoredFieldsWriter$merge$22 = ((CompressingStoredFieldsMergeSub)sub).getMappedDocID() + " != " + docCount;
                throw new IllegalArgumentException($i$a$-require-Lucene90CompressingStoredFieldsWriter$merge$22.toString());
            }
            Intrinsics.checkNotNull((Object)mergeState.getStoredFieldsReaders()[((CompressingStoredFieldsMergeSub)sub).getReaderIndex()]);
            if (((CompressingStoredFieldsMergeSub)sub).getMergeStrategy() == MergeStrategy.BULK) {
                CompressingStoredFieldsMergeSub current;
                int toDocID;
                int fromDocID;
                block9: {
                    CompressingStoredFieldsMergeSub compressingStoredFieldsMergeSub;
                    toDocID = fromDocID = ((CompressingStoredFieldsMergeSub)sub).getDocID();
                    current = sub;
                    do {
                        Object t = docIDMerger.next();
                        CompressingStoredFieldsMergeSub it = (CompressingStoredFieldsMergeSub)t;
                        boolean bl = false;
                        sub = it;
                        if (t != current) break block9;
                        compressingStoredFieldsMergeSub = sub;
                        Intrinsics.checkNotNull((Object)compressingStoredFieldsMergeSub);
                    } while (compressingStoredFieldsMergeSub.getDocID() == ++toDocID);
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                this.copyChunks(mergeState, current, fromDocID, ++toDocID);
                docCount += toDocID - fromDocID;
                continue;
            }
            if (((CompressingStoredFieldsMergeSub)sub).getMergeStrategy() == MergeStrategy.DOC) {
                this.copyOneDoc((Lucene90CompressingStoredFieldsReader)reader3, ((CompressingStoredFieldsMergeSub)sub).getDocID());
                ++docCount;
                sub = docIDMerger.next();
                continue;
            }
            if (((CompressingStoredFieldsMergeSub)sub).getMergeStrategy() == MergeStrategy.VISITOR) {
                if (visitors[((CompressingStoredFieldsMergeSub)sub).getReaderIndex()] == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                this.startDocument();
                int n2 = sub.getDocID();
                StoredFieldsWriter.MergeVisitor mergeVisitor = visitors[sub.getReaderIndex()];
                Intrinsics.checkNotNull((Object)mergeVisitor);
                reader3.document(n2, mergeVisitor);
                this.finishDocument();
                ++docCount;
                sub = docIDMerger.next();
                continue;
            }
            throw new AssertionError((Object)("Unknown merge strategy [" + ((CompressingStoredFieldsMergeSub)sub).getMergeStrategy() + "]"));
        }
        this.finish(docCount);
        return docCount;
    }

    public final boolean tooDirty(@NotNull Lucene90CompressingStoredFieldsReader candidate) {
        Intrinsics.checkNotNullParameter((Object)candidate, (String)"candidate");
        return candidate.getNumDirtyDocs() > (long)this.maxDocsPerChunk && candidate.getNumDirtyChunks() * (long)100 > candidate.getNumChunks();
    }

    private final MergeStrategy getMergeStrategy(MergeState mergeState, MatchingReaders matchingReaders, int readerIndex) {
        StoredFieldsReader storedFieldsReader = mergeState.getStoredFieldsReaders()[readerIndex];
        Intrinsics.checkNotNull((Object)storedFieldsReader);
        StoredFieldsReader candidate = storedFieldsReader;
        if (!matchingReaders.getMatchingReaders()[readerIndex] || !(candidate instanceof Lucene90CompressingStoredFieldsReader) || ((Lucene90CompressingStoredFieldsReader)candidate).getVersion() != 1) {
            return MergeStrategy.VISITOR;
        }
        Lucene90CompressingStoredFieldsReader reader2 = (Lucene90CompressingStoredFieldsReader)candidate;
        return BULK_MERGE_ENABLED && reader2.getCompressionMode() == this.compressionMode && reader2.getChunkSize() == this.chunkSize && mergeState.getLiveDocs()[readerIndex] == null && !this.tooDirty(reader2) ? MergeStrategy.BULK : MergeStrategy.DOC;
    }

    @Override
    public long ramBytesUsed() {
        return this.bufferedDocs.ramBytesUsed() + (long)this.numStoredFields.length * 4L + (long)this.endOffsets.length * 4L;
    }

    static {
        boolean v = true;
        try {
            v = Boolean.parseBoolean(System.INSTANCE.getProperty(BULK_MERGE_ENABLED_SYSPROP, "true"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        BULK_MERGE_ENABLED = v;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0016\u0010+\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020-J\u0016\u0010.\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010/\u001a\u000200J\u0016\u00101\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u00102\u001a\u00020\"R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u000e\u0010\u0015\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0012R\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020\"X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\"X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\"X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u00103\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0011\u00106\u001a\u000207\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109\u00a8\u0006:"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/compressing/Lucene90CompressingStoredFieldsWriter$Companion;", "", "<init>", "()V", "FIELDS_EXTENSION", "", "INDEX_EXTENSION", "META_EXTENSION", "INDEX_CODEC_NAME", "STRING", "", "BYTE_ARR", "NUMERIC_INT", "NUMERIC_FLOAT", "NUMERIC_LONG", "NUMERIC_DOUBLE", "TYPE_BITS", "getTYPE_BITS", "()I", "TYPE_MASK", "getTYPE_MASK", "VERSION_START", "VERSION_CURRENT", "META_VERSION_START", "saveInts", "", "values", "", "length", "out", "Lorg/gnit/lucenekmp/store/DataOutput;", "NEGATIVE_ZERO_FLOAT", "getNEGATIVE_ZERO_FLOAT", "NEGATIVE_ZERO_DOUBLE", "", "getNEGATIVE_ZERO_DOUBLE", "()J", "SECOND", "HOUR", "DAY", "SECOND_ENCODING", "HOUR_ENCODING", "DAY_ENCODING", "writeZFloat", "f", "", "writeZDouble", "d", "", "writeTLong", "l", "BULK_MERGE_ENABLED_SYSPROP", "getBULK_MERGE_ENABLED_SYSPROP", "()Ljava/lang/String;", "BULK_MERGE_ENABLED", "", "getBULK_MERGE_ENABLED", "()Z", "core"})
    public static final class Companion {
        private Companion() {
        }

        public final int getTYPE_BITS() {
            return TYPE_BITS;
        }

        public final int getTYPE_MASK() {
            return TYPE_MASK;
        }

        private final void saveInts(int[] values2, int length, DataOutput out) throws IOException {
            if (length == 1) {
                out.writeVInt(values2[0]);
            } else {
                StoredFieldsInts.INSTANCE.writeInts(values2, 0, length, out);
            }
        }

        public final int getNEGATIVE_ZERO_FLOAT() {
            return NEGATIVE_ZERO_FLOAT;
        }

        public final long getNEGATIVE_ZERO_DOUBLE() {
            return NEGATIVE_ZERO_DOUBLE;
        }

        public final void writeZFloat(@NotNull DataOutput out, float f) throws IOException {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            int intVal = (int)f;
            int floatBits = FloatExtKt.floatToIntBits(FloatCompanionObject.INSTANCE, f);
            if (f == (float)intVal && intVal >= -1 && intVal <= 125 && floatBits != this.getNEGATIVE_ZERO_FLOAT()) {
                out.writeByte((byte)(0x80 | 1 + intVal));
            } else if (floatBits >>> 31 == 0) {
                out.writeByte((byte)(floatBits >> 24));
                out.writeShort((short)(floatBits >>> 8));
                out.writeByte((byte)floatBits);
            } else {
                out.writeByte((byte)-1);
                out.writeInt(floatBits);
            }
        }

        public final void writeZDouble(@NotNull DataOutput out, double d) throws IOException {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            int intVal = (int)d;
            long doubleBits = DoubleExtKt.doubleToLongBits(DoubleCompanionObject.INSTANCE, d);
            if (d == (double)intVal && intVal >= -1 && intVal <= 124 && doubleBits != this.getNEGATIVE_ZERO_DOUBLE()) {
                out.writeByte((byte)(0x80 | intVal + 1));
                return;
            }
            if (d == (double)((float)d)) {
                out.writeByte((byte)-2);
                out.writeInt(FloatExtKt.floatToIntBits(FloatCompanionObject.INSTANCE, (float)d));
            } else if (doubleBits >>> 63 == 0L) {
                out.writeByte((byte)(doubleBits >> 56));
                out.writeInt((int)(doubleBits >>> 24));
                out.writeShort((short)(doubleBits >>> 8));
                out.writeByte((byte)doubleBits);
            } else {
                out.writeByte((byte)-1);
                out.writeLong(doubleBits);
            }
        }

        public final void writeTLong(@NotNull DataOutput out, long l) throws IOException {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            long l2 = l;
            int header = 0;
            if (l2 % 1000L != 0L) {
                header = 0;
            } else if (l2 % 86400000L == 0L) {
                header = 192;
                l2 /= 86400000L;
            } else if (l2 % 3600000L == 0L) {
                header = 128;
                l2 /= 3600000L;
            } else {
                header = 64;
                l2 /= 1000L;
            }
            long zigZagL = BitUtil.INSTANCE.zigZagEncode(l2);
            header |= (int)(zigZagL & 0x1FL);
            long upperBits = zigZagL >>> 5;
            if (upperBits != 0L) {
                header |= 0x20;
            }
            out.writeByte((byte)header);
            if (upperBits != 0L) {
                out.writeVLong(upperBits);
            }
        }

        @NotNull
        public final String getBULK_MERGE_ENABLED_SYSPROP() {
            return BULK_MERGE_ENABLED_SYSPROP;
        }

        public final boolean getBULK_MERGE_ENABLED() {
            return BULK_MERGE_ENABLED;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0014\u001a\u00020\u0007H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u001a\u0010\u0010\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/compressing/Lucene90CompressingStoredFieldsWriter$CompressingStoredFieldsMergeSub;", "Lorg/gnit/lucenekmp/index/DocIDMerger$Sub;", "mergeState", "Lorg/gnit/lucenekmp/index/MergeState;", "mergeStrategy", "Lorg/gnit/lucenekmp/codecs/lucene90/compressing/Lucene90CompressingStoredFieldsWriter$MergeStrategy;", "readerIndex", "", "<init>", "(Lorg/gnit/lucenekmp/index/MergeState;Lorg/gnit/lucenekmp/codecs/lucene90/compressing/Lucene90CompressingStoredFieldsWriter$MergeStrategy;I)V", "getMergeStrategy", "()Lorg/gnit/lucenekmp/codecs/lucene90/compressing/Lucene90CompressingStoredFieldsWriter$MergeStrategy;", "getReaderIndex", "()I", "maxDoc", "getMaxDoc", "docID", "getDocID", "setDocID", "(I)V", "nextDoc", "core"})
    private static final class CompressingStoredFieldsMergeSub
    extends DocIDMerger.Sub {
        @NotNull
        private final MergeStrategy mergeStrategy;
        private final int readerIndex;
        private final int maxDoc;
        private int docID;

        public CompressingStoredFieldsMergeSub(@NotNull MergeState mergeState, @NotNull MergeStrategy mergeStrategy, int readerIndex) {
            Intrinsics.checkNotNullParameter((Object)mergeState, (String)"mergeState");
            Intrinsics.checkNotNullParameter((Object)((Object)mergeStrategy), (String)"mergeStrategy");
            MergeState.DocMap[] docMapArray = mergeState.getDocMaps();
            Intrinsics.checkNotNull((Object)docMapArray);
            super(docMapArray[readerIndex]);
            this.mergeStrategy = mergeStrategy;
            this.readerIndex = readerIndex;
            this.maxDoc = mergeState.getMaxDocs()[this.readerIndex];
            this.docID = -1;
        }

        @NotNull
        public final MergeStrategy getMergeStrategy() {
            return this.mergeStrategy;
        }

        public final int getReaderIndex() {
            return this.readerIndex;
        }

        public final int getMaxDoc() {
            return this.maxDoc;
        }

        public final int getDocID() {
            return this.docID;
        }

        public final void setDocID(int n) {
            this.docID = n;
        }

        @Override
        public int nextDoc() {
            int n = this.docID;
            this.docID = n + 1;
            return this.docID == this.maxDoc ? Integer.MAX_VALUE : this.docID;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/compressing/Lucene90CompressingStoredFieldsWriter$MergeStrategy;", "", "<init>", "(Ljava/lang/String;I)V", "BULK", "DOC", "VISITOR", "core"})
    private static final class MergeStrategy
    extends Enum<MergeStrategy> {
        public static final /* enum */ MergeStrategy BULK = new MergeStrategy();
        public static final /* enum */ MergeStrategy DOC = new MergeStrategy();
        public static final /* enum */ MergeStrategy VISITOR = new MergeStrategy();
        private static final /* synthetic */ MergeStrategy[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static MergeStrategy[] values() {
            return (MergeStrategy[])$VALUES.clone();
        }

        public static MergeStrategy valueOf(String value) {
            return Enum.valueOf(MergeStrategy.class, value);
        }

        @NotNull
        public static EnumEntries<MergeStrategy> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = mergeStrategyArray = new MergeStrategy[]{MergeStrategy.BULK, MergeStrategy.DOC, MergeStrategy.VISITOR};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

