/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs.lucene90.compressing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.codecs.CodecUtil;
import org.gnit.lucenekmp.codecs.TermVectorsReader;
import org.gnit.lucenekmp.codecs.TermVectorsWriter;
import org.gnit.lucenekmp.codecs.compressing.CompressionMode;
import org.gnit.lucenekmp.codecs.compressing.Compressor;
import org.gnit.lucenekmp.codecs.compressing.MatchingReaders;
import org.gnit.lucenekmp.codecs.lucene90.compressing.FieldsIndex;
import org.gnit.lucenekmp.codecs.lucene90.compressing.FieldsIndexWriter;
import org.gnit.lucenekmp.codecs.lucene90.compressing.Lucene90CompressingTermVectorsReader;
import org.gnit.lucenekmp.index.CorruptIndexException;
import org.gnit.lucenekmp.index.DocIDMerger;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.Fields;
import org.gnit.lucenekmp.index.IndexFileNames;
import org.gnit.lucenekmp.index.MergeState;
import org.gnit.lucenekmp.index.SegmentInfo;
import org.gnit.lucenekmp.internal.hppc.IntHashSet;
import org.gnit.lucenekmp.jdkport.ArrayDequeExtKt;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.jdkport.FloatExtKt;
import org.gnit.lucenekmp.jdkport.Math;
import org.gnit.lucenekmp.jdkport.System;
import org.gnit.lucenekmp.store.ByteBuffersDataInput;
import org.gnit.lucenekmp.store.ByteBuffersDataOutput;
import org.gnit.lucenekmp.store.DataInput;
import org.gnit.lucenekmp.store.Directory;
import org.gnit.lucenekmp.store.IOContext;
import org.gnit.lucenekmp.store.IndexInput;
import org.gnit.lucenekmp.store.IndexOutput;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.IOUtils;
import org.gnit.lucenekmp.util.StringHelper;
import org.gnit.lucenekmp.util.packed.BlockPackedWriter;
import org.gnit.lucenekmp.util.packed.DirectWriter;
import org.gnit.lucenekmp.util.packed.PackedInts;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 v2\u00020\u0001:\u0004stuvBQ\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0010\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0014\u0010\u001f\u001a\u00060 R\u00020\u00002\u0006\u0010!\u001a\u00020\u000eH\u0002J\b\u00105\u001a\u000206H\u0016J\u0010\u00107\u001a\u0002062\u0006\u0010!\u001a\u00020\u000eH\u0016J\b\u00108\u001a\u000206H\u0016J2\u00109\u001a\u0002062\b\u0010:\u001a\u0004\u0018\u00010;2\u0006\u0010<\u001a\u00020\u000e2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020>2\u0006\u0010@\u001a\u00020>H\u0016J\b\u0010A\u001a\u000206H\u0016J\u001a\u0010B\u001a\u0002062\b\u0010C\u001a\u0004\u0018\u00010)2\u0006\u0010D\u001a\u00020\u000eH\u0016J*\u0010E\u001a\u0002062\u0006\u0010F\u001a\u00020\u000e2\u0006\u0010G\u001a\u00020\u000e2\u0006\u0010H\u001a\u00020\u000e2\b\u0010I\u001a\u0004\u0018\u00010)H\u0016J\b\u0010J\u001a\u00020>H\u0002J\u0010\u0010K\u001a\u0002062\u0006\u0010L\u001a\u00020>H\u0002J\u0010\u0010M\u001a\u00020\u000e2\u0006\u0010N\u001a\u00020\u000eH\u0002J\b\u0010O\u001a\u00020+H\u0002J\u0018\u0010P\u001a\u0002062\u0006\u0010Q\u001a\u00020\u000e2\u0006\u0010R\u001a\u00020+H\u0002J\u0018\u0010S\u001a\u0002062\u0006\u0010Q\u001a\u00020\u000e2\u0006\u0010R\u001a\u00020+H\u0002J\u0010\u0010T\u001a\u0002062\u0006\u0010Q\u001a\u00020\u000eH\u0002J\b\u0010U\u001a\u000206H\u0002J\b\u0010V\u001a\u000206H\u0002J\b\u0010W\u001a\u000206H\u0002J\u0010\u0010X\u001a\u0002062\u0006\u0010R\u001a\u00020+H\u0002J\b\u0010Y\u001a\u000206H\u0002J\u0010\u0010Z\u001a\u0002062\u0006\u0010\"\u001a\u00020\u000eH\u0016J$\u0010[\u001a\u0002062\u0006\u0010\\\u001a\u00020\u000e2\b\u0010=\u001a\u0004\u0018\u00010]2\b\u0010?\u001a\u0004\u0018\u00010]H\u0016J(\u0010^\u001a\u0002062\u0006\u0010_\u001a\u00020`2\u0006\u0010a\u001a\u00020b2\u0006\u0010c\u001a\u00020\u000e2\u0006\u0010d\u001a\u00020\u000eH\u0002J\u0010\u0010e\u001a\u00020\u000e2\u0006\u0010_\u001a\u00020`H\u0016J\u000e\u0010f\u001a\u00020>2\u0006\u0010g\u001a\u00020hJ \u0010i\u001a\u00020>2\u0006\u0010_\u001a\u00020`2\u0006\u0010j\u001a\u00020k2\u0006\u0010l\u001a\u00020\u000eH\u0002J\b\u0010m\u001a\u00020\u001cH\u0016R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010#\u001a\f\u0012\b\u0012\u00060 R\u00020\u00000$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\b\u0018\u00010 R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\b\u0018\u00010'R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u000203X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010n\u001a\b\u0012\u0004\u0012\u00020p0o8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bq\u0010r\u00a8\u0006w"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/compressing/Lucene90CompressingTermVectorsWriter;", "Lorg/gnit/lucenekmp/codecs/TermVectorsWriter;", "directory", "Lorg/gnit/lucenekmp/store/Directory;", "si", "Lorg/gnit/lucenekmp/index/SegmentInfo;", "segmentSuffix", "", "context", "Lorg/gnit/lucenekmp/store/IOContext;", "formatName", "compressionMode", "Lorg/gnit/lucenekmp/codecs/compressing/CompressionMode;", "chunkSize", "", "maxDocsPerChunk", "blockShift", "<init>", "(Lorg/gnit/lucenekmp/store/Directory;Lorg/gnit/lucenekmp/index/SegmentInfo;Ljava/lang/String;Lorg/gnit/lucenekmp/store/IOContext;Ljava/lang/String;Lorg/gnit/lucenekmp/codecs/compressing/CompressionMode;III)V", "segment", "indexWriter", "Lorg/gnit/lucenekmp/codecs/lucene90/compressing/FieldsIndexWriter;", "metaStream", "Lorg/gnit/lucenekmp/store/IndexOutput;", "vectorsStream", "compressor", "Lorg/gnit/lucenekmp/codecs/compressing/Compressor;", "numChunks", "", "numDirtyChunks", "numDirtyDocs", "addDocData", "Lorg/gnit/lucenekmp/codecs/lucene90/compressing/Lucene90CompressingTermVectorsWriter$DocData;", "numVectorFields", "numDocs", "pendingDocs", "Lkotlin/collections/ArrayDeque;", "curDoc", "curField", "Lorg/gnit/lucenekmp/codecs/lucene90/compressing/Lucene90CompressingTermVectorsWriter$FieldData;", "lastTerm", "Lorg/gnit/lucenekmp/util/BytesRef;", "positionsBuf", "", "startOffsetsBuf", "lengthsBuf", "payloadLengthsBuf", "termSuffixes", "Lorg/gnit/lucenekmp/store/ByteBuffersDataOutput;", "payloadBytes", "writer", "Lorg/gnit/lucenekmp/util/packed/BlockPackedWriter;", "scratchBuffer", "close", "", "startDocument", "finishDocument", "startField", "info", "Lorg/gnit/lucenekmp/index/FieldInfo;", "numTerms", "positions", "", "offsets", "payloads", "finishField", "startTerm", "term", "freq", "addPosition", "position", "startOffset", "endOffset", "payload", "triggerFlush", "flush", "force", "flushNumFields", "chunkDocs", "flushFieldNums", "flushFields", "totalFields", "fieldNums", "flushFlags", "flushNumTerms", "flushTermLengths", "flushTermFreqs", "flushPositions", "flushOffsets", "flushPayloadLengths", "finish", "addProx", "numProx", "Lorg/gnit/lucenekmp/store/DataInput;", "copyChunks", "mergeState", "Lorg/gnit/lucenekmp/index/MergeState;", "sub", "Lorg/gnit/lucenekmp/codecs/lucene90/compressing/Lucene90CompressingTermVectorsWriter$CompressingTermVectorsSub;", "fromDocID", "toDocID", "merge", "tooDirty", "candidate", "Lorg/gnit/lucenekmp/codecs/lucene90/compressing/Lucene90CompressingTermVectorsReader;", "canPerformBulkMerge", "matchingReaders", "Lorg/gnit/lucenekmp/codecs/compressing/MatchingReaders;", "readerIndex", "ramBytesUsed", "childResources", "", "Lorg/gnit/lucenekmp/util/Accountable;", "getChildResources", "()Ljava/util/Collection;", "DocData", "FieldData", "CompressingTermVectorsSub", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nLucene90CompressingTermVectorsWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Lucene90CompressingTermVectorsWriter.kt\norg/gnit/lucenekmp/codecs/lucene90/compressing/Lucene90CompressingTermVectorsWriter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,989:1\n1#2:990\n*E\n"})
public final class Lucene90CompressingTermVectorsWriter
extends TermVectorsWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String segment;
    @Nullable
    private FieldsIndexWriter indexWriter;
    @Nullable
    private IndexOutput metaStream;
    @Nullable
    private IndexOutput vectorsStream;
    @NotNull
    private final CompressionMode compressionMode;
    @NotNull
    private final Compressor compressor;
    private final int chunkSize;
    private long numChunks;
    private long numDirtyChunks;
    private long numDirtyDocs;
    private int numDocs;
    @NotNull
    private final ArrayDeque<DocData> pendingDocs;
    @Nullable
    private DocData curDoc;
    @Nullable
    private FieldData curField;
    @NotNull
    private final BytesRef lastTerm;
    @NotNull
    private int[] positionsBuf;
    @NotNull
    private int[] startOffsetsBuf;
    @NotNull
    private int[] lengthsBuf;
    @NotNull
    private int[] payloadLengthsBuf;
    @NotNull
    private final ByteBuffersDataOutput termSuffixes;
    @NotNull
    private final ByteBuffersDataOutput payloadBytes;
    @NotNull
    private final BlockPackedWriter writer;
    private final int maxDocsPerChunk;
    @NotNull
    private final ByteBuffersDataOutput scratchBuffer;
    @NotNull
    public static final String VECTORS_EXTENSION = "tvd";
    @NotNull
    public static final String VECTORS_INDEX_EXTENSION = "tvx";
    @NotNull
    public static final String VECTORS_META_EXTENSION = "tvm";
    @NotNull
    public static final String VECTORS_INDEX_CODEC_NAME = "Lucene90TermVectorsIndex";
    public static final int VERSION_START = 0;
    public static final int VERSION_CURRENT = 0;
    public static final int META_VERSION_START = 0;
    public static final int PACKED_BLOCK_SIZE = 64;
    public static final int POSITIONS = 1;
    public static final int OFFSETS = 2;
    public static final int PAYLOADS = 4;
    private static final int FLAGS_BITS = DirectWriter.Companion.bitsRequired(7L);
    @NotNull
    private static final String BULK_MERGE_ENABLED_SYSPROP = Reflection.getOrCreateKotlinClass(Lucene90CompressingTermVectorsWriter.class).getQualifiedName() + ".enableBulkMerge";
    private static final boolean BULK_MERGE_ENABLED;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lucene90CompressingTermVectorsWriter(@NotNull Directory directory, @NotNull SegmentInfo si, @NotNull String segmentSuffix, @NotNull IOContext context, @NotNull String formatName, @NotNull CompressionMode compressionMode, int chunkSize, int maxDocsPerChunk, int blockShift) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)si, (String)"si");
        Intrinsics.checkNotNullParameter((Object)segmentSuffix, (String)"segmentSuffix");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)formatName, (String)"formatName");
        Intrinsics.checkNotNullParameter((Object)compressionMode, (String)"compressionMode");
        this.scratchBuffer = ByteBuffersDataOutput.Companion.newResettableInstance();
        this.segment = si.getName();
        this.compressionMode = compressionMode;
        this.compressor = compressionMode.newCompressor();
        this.chunkSize = chunkSize;
        this.maxDocsPerChunk = maxDocsPerChunk;
        this.numDocs = 0;
        this.pendingDocs = new ArrayDeque();
        this.termSuffixes = ByteBuffersDataOutput.Companion.newResettableInstance();
        this.payloadBytes = ByteBuffersDataOutput.Companion.newResettableInstance();
        this.lastTerm = new BytesRef(ArrayUtil.Companion.oversize(30, 1));
        boolean success = false;
        try {
            IndexOutput indexOutput = this.metaStream = directory.createOutput(IndexFileNames.INSTANCE.segmentFileName(this.segment, segmentSuffix, VECTORS_META_EXTENSION), context);
            Intrinsics.checkNotNull((Object)indexOutput);
            CodecUtil.INSTANCE.writeIndexHeader(indexOutput, "Lucene90TermVectorsIndexMeta", 0, si.getId(), segmentSuffix);
            long l = CodecUtil.INSTANCE.indexHeaderLength("Lucene90TermVectorsIndexMeta", segmentSuffix);
            IndexOutput indexOutput2 = this.metaStream;
            Intrinsics.checkNotNull((Object)indexOutput2);
            if (!(l == indexOutput2.getFilePointer())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            IndexOutput indexOutput3 = this.vectorsStream = directory.createOutput(IndexFileNames.INSTANCE.segmentFileName(this.segment, segmentSuffix, VECTORS_EXTENSION), context);
            Intrinsics.checkNotNull((Object)indexOutput3);
            CodecUtil.INSTANCE.writeIndexHeader(indexOutput3, formatName, 0, si.getId(), segmentSuffix);
            long l2 = CodecUtil.INSTANCE.indexHeaderLength(formatName, segmentSuffix);
            IndexOutput indexOutput4 = this.vectorsStream;
            Intrinsics.checkNotNull((Object)indexOutput4);
            if (!(l2 == indexOutput4.getFilePointer())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.indexWriter = new FieldsIndexWriter(directory, this.segment, segmentSuffix, VECTORS_INDEX_EXTENSION, VECTORS_INDEX_CODEC_NAME, si.getId(), blockShift, context);
            IndexOutput indexOutput5 = this.metaStream;
            Intrinsics.checkNotNull((Object)indexOutput5);
            indexOutput5.writeVInt(PackedInts.INSTANCE.getVERSION_CURRENT());
            IndexOutput indexOutput6 = this.metaStream;
            Intrinsics.checkNotNull((Object)indexOutput6);
            indexOutput6.writeVInt(chunkSize);
            IndexOutput indexOutput7 = this.vectorsStream;
            Intrinsics.checkNotNull((Object)indexOutput7);
            this.writer = new BlockPackedWriter(indexOutput7, 64);
            this.positionsBuf = new int[1024];
            this.startOffsetsBuf = new int[1024];
            this.lengthsBuf = new int[1024];
            this.payloadLengthsBuf = new int[1024];
            success = true;
        }
        catch (Throwable throwable) {
            AutoCloseable[] autoCloseableArray = new AutoCloseable[4];
            Intrinsics.checkNotNull((Object)this.metaStream);
            Intrinsics.checkNotNull((Object)this.vectorsStream);
            Intrinsics.checkNotNull((Object)this.indexWriter);
            Intrinsics.checkNotNull((Object)this.indexWriter);
            IOUtils.INSTANCE.closeWhileHandlingException(autoCloseableArray);
            throw throwable;
        }
    }

    private final DocData addDocData(int numVectorFields) {
        DocData doc;
        FieldData last = null;
        Iterator<DocData> it = ArrayDequeExtKt.descendingIterator(this.pendingDocs);
        while (it.hasNext()) {
            doc = it.next();
            if (doc.getFields().isEmpty()) continue;
            last = ArrayDequeExtKt.getLast(doc.getFields());
            break;
        }
        doc = null;
        if (last == null) {
            doc = new DocData(numVectorFields, 0, 0, 0);
        } else {
            int posStart = last.getPosStart() + (last.getHasPositions() ? last.getTotalPositions() : 0);
            int offStart = last.getOffStart() + (last.getHasOffsets() ? last.getTotalPositions() : 0);
            int payStart = last.getPayStart() + (last.getHasPayloads() ? last.getTotalPositions() : 0);
            doc = new DocData(numVectorFields, posStart, offStart, payStart);
        }
        this.pendingDocs.add((Object)doc);
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            AutoCloseable[] autoCloseableArray = new AutoCloseable[3];
            Intrinsics.checkNotNull((Object)this.metaStream);
            Intrinsics.checkNotNull((Object)this.vectorsStream);
            Intrinsics.checkNotNull((Object)this.indexWriter);
            IOUtils.INSTANCE.close(autoCloseableArray);
        }
        finally {
            this.metaStream = null;
            this.vectorsStream = null;
            this.indexWriter = null;
        }
    }

    @Override
    public void startDocument(int numVectorFields) throws IOException {
        this.curDoc = this.addDocData(numVectorFields);
    }

    @Override
    public void finishDocument() throws IOException {
        this.payloadBytes.copyTo(this.termSuffixes);
        this.payloadBytes.reset();
        ++this.numDocs;
        if (this.triggerFlush()) {
            this.flush(false);
        }
        this.curDoc = null;
    }

    @Override
    public void startField(@Nullable FieldInfo info, int numTerms, boolean positions, boolean offsets, boolean payloads) throws IOException {
        DocData docData = this.curDoc;
        Intrinsics.checkNotNull((Object)docData);
        FieldInfo fieldInfo = info;
        Intrinsics.checkNotNull((Object)fieldInfo);
        this.curField = docData.addField(fieldInfo.getNumber(), numTerms, positions, offsets, payloads);
        this.lastTerm.setLength(0);
    }

    @Override
    public void finishField() throws IOException {
        this.curField = null;
    }

    @Override
    public void startTerm(@Nullable BytesRef term, int freq) throws IOException {
        if (!(freq >= 1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int prefix = this.lastTerm.getLength() == 0 ? 0 : StringHelper.INSTANCE.bytesDifference(this.lastTerm, term);
        FieldData fieldData = this.curField;
        Intrinsics.checkNotNull((Object)fieldData);
        BytesRef bytesRef = term;
        Intrinsics.checkNotNull((Object)bytesRef);
        fieldData.addTerm(freq, prefix, bytesRef.getLength() - prefix);
        this.termSuffixes.writeBytes(term.getBytes(), term.getOffset() + prefix, term.getLength() - prefix);
        if (this.lastTerm.getBytes().length < term.getLength()) {
            this.lastTerm.setBytes(new byte[ArrayUtil.Companion.oversize(term.getLength(), 1)]);
        }
        this.lastTerm.setOffset(0);
        this.lastTerm.setLength(term.getLength());
        System.INSTANCE.arraycopy(term.getBytes(), term.getOffset(), this.lastTerm.getBytes(), 0, term.getLength());
    }

    @Override
    public void addPosition(int position, int startOffset, int endOffset, @Nullable BytesRef payload) throws IOException {
        FieldData fieldData = this.curField;
        Intrinsics.checkNotNull((Object)fieldData);
        if (!(fieldData.getFlags() != 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        FieldData fieldData2 = this.curField;
        Intrinsics.checkNotNull((Object)fieldData2);
        BytesRef bytesRef = payload;
        fieldData2.addPosition(position, startOffset, endOffset - startOffset, bytesRef != null ? bytesRef.getLength() : 0);
        FieldData fieldData3 = this.curField;
        Intrinsics.checkNotNull((Object)fieldData3);
        if (fieldData3.getHasPayloads() && payload != null) {
            this.payloadBytes.writeBytes(payload.getBytes(), payload.getOffset(), payload.getLength());
        }
    }

    private final boolean triggerFlush() {
        return this.termSuffixes.size() >= (long)this.chunkSize || this.pendingDocs.size() >= this.maxDocsPerChunk;
    }

    private final void flush(boolean force) throws IOException {
        if (!(force != this.triggerFlush())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int chunkDocs = this.pendingDocs.size();
        if (!(chunkDocs > 0)) {
            boolean $i$a$-require-Lucene90CompressingTermVectorsWriter$flush$22 = false;
            Integer $i$a$-require-Lucene90CompressingTermVectorsWriter$flush$22 = chunkDocs;
            throw new IllegalArgumentException(((Object)$i$a$-require-Lucene90CompressingTermVectorsWriter$flush$22).toString());
        }
        long l = this.numChunks;
        this.numChunks = l + 1L;
        if (force) {
            l = this.numDirtyChunks;
            this.numDirtyChunks = l + 1L;
            this.numDirtyDocs += (long)this.pendingDocs.size();
        }
        FieldsIndexWriter fieldsIndexWriter = this.indexWriter;
        Intrinsics.checkNotNull((Object)fieldsIndexWriter);
        IndexOutput indexOutput = this.vectorsStream;
        Intrinsics.checkNotNull((Object)indexOutput);
        fieldsIndexWriter.writeIndex(chunkDocs, indexOutput.getFilePointer());
        int docBase = this.numDocs - chunkDocs;
        IndexOutput indexOutput2 = this.vectorsStream;
        Intrinsics.checkNotNull((Object)indexOutput2);
        indexOutput2.writeVInt(docBase);
        int dirtyBit = force ? 1 : 0;
        IndexOutput indexOutput3 = this.vectorsStream;
        Intrinsics.checkNotNull((Object)indexOutput3);
        indexOutput3.writeVInt(chunkDocs << 1 | dirtyBit);
        int totalFields = this.flushNumFields(chunkDocs);
        if (totalFields > 0) {
            int[] fieldNums = this.flushFieldNums();
            this.flushFields(totalFields, fieldNums);
            this.flushFlags(totalFields, fieldNums);
            this.flushNumTerms(totalFields);
            this.flushTermLengths();
            this.flushTermFreqs();
            this.flushPositions();
            this.flushOffsets(fieldNums);
            this.flushPayloadLengths();
            ByteBuffersDataInput content = this.termSuffixes.toDataInput();
            IndexOutput indexOutput4 = this.vectorsStream;
            Intrinsics.checkNotNull((Object)indexOutput4);
            this.compressor.compress(content, indexOutput4);
        }
        this.pendingDocs.clear();
        this.curDoc = null;
        this.curField = null;
        this.termSuffixes.reset();
    }

    private final int flushNumFields(int chunkDocs) throws IOException {
        if (chunkDocs == 1) {
            int numFields = ArrayDequeExtKt.getFirst(this.pendingDocs).getNumFields();
            IndexOutput indexOutput = this.vectorsStream;
            Intrinsics.checkNotNull((Object)indexOutput);
            indexOutput.writeVInt(numFields);
            return numFields;
        }
        IndexOutput indexOutput = this.vectorsStream;
        Intrinsics.checkNotNull((Object)indexOutput);
        this.writer.reset(indexOutput);
        int totalFields = 0;
        for (DocData dd : this.pendingDocs) {
            this.writer.add(dd.getNumFields());
            totalFields += dd.getNumFields();
        }
        this.writer.finish();
        return totalFields;
    }

    private final int[] flushFieldNums() throws IOException {
        IntHashSet fieldNumsSet = new IntHashSet();
        for (DocData dd : this.pendingDocs) {
            for (Object fd : dd.getFields()) {
                fieldNumsSet.add(((FieldData)fd).getFieldNum());
            }
        }
        int[] fieldNums = fieldNumsSet.toArray();
        Arrays.INSTANCE.sort(fieldNums);
        int numDistinctFields = fieldNums.length;
        if (!(numDistinctFields > 0)) {
            Object fd;
            fd = "Failed requirement.";
            throw new IllegalArgumentException(fd.toString());
        }
        int bitsRequired = PackedInts.INSTANCE.bitsRequired(fieldNums[numDistinctFields - 1]);
        int token = java.lang.Math.min(numDistinctFields - 1, 7) << 5 | bitsRequired;
        IndexOutput indexOutput = this.vectorsStream;
        Intrinsics.checkNotNull((Object)indexOutput);
        indexOutput.writeByte((byte)token);
        if (numDistinctFields - 1 >= 7) {
            IndexOutput indexOutput2 = this.vectorsStream;
            Intrinsics.checkNotNull((Object)indexOutput2);
            indexOutput2.writeVInt(numDistinctFields - 1 - 7);
        }
        IndexOutput indexOutput3 = this.vectorsStream;
        Intrinsics.checkNotNull((Object)indexOutput3);
        PackedInts.Writer writer = PackedInts.INSTANCE.getWriterNoHeader(indexOutput3, PackedInts.Format.PACKED, numDistinctFields, bitsRequired, 1);
        int n = fieldNums.length;
        for (int i = 0; i < n; ++i) {
            int fieldNum = fieldNums[i];
            writer.add(fieldNum);
        }
        writer.finish();
        return fieldNums;
    }

    private final void flushFields(int totalFields, int[] fieldNums) throws IOException {
        this.scratchBuffer.reset();
        DirectWriter writer = DirectWriter.Companion.getInstance(this.scratchBuffer, totalFields, DirectWriter.Companion.bitsRequired((long)fieldNums.length - 1L));
        for (DocData dd : this.pendingDocs) {
            for (FieldData fd : dd.getFields()) {
                int fieldNumIndex = Arrays.INSTANCE.binarySearch(fieldNums, fd.getFieldNum());
                if (!(fieldNumIndex >= 0)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                writer.add(fieldNumIndex);
            }
        }
        writer.finish();
        IndexOutput indexOutput = this.vectorsStream;
        Intrinsics.checkNotNull((Object)indexOutput);
        indexOutput.writeVLong(this.scratchBuffer.size());
        IndexOutput indexOutput2 = this.vectorsStream;
        Intrinsics.checkNotNull((Object)indexOutput2);
        this.scratchBuffer.copyTo(indexOutput2);
    }

    private final void flushFlags(int totalFields, int[] fieldNums) throws IOException {
        boolean nonChangingFlags = true;
        int[] fieldFlags = new int[fieldNums.length];
        Arrays.INSTANCE.fill(fieldFlags, -1);
        block0: for (DocData dd : this.pendingDocs) {
            for (FieldData fd : dd.getFields()) {
                int fieldNumOff = Arrays.INSTANCE.binarySearch(fieldNums, fd.getFieldNum());
                if (!(fieldNumOff >= 0)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                if (fieldFlags[fieldNumOff] == -1) {
                    fieldFlags[fieldNumOff] = fd.getFlags();
                    continue;
                }
                if (fieldFlags[fieldNumOff] == fd.getFlags()) continue;
                nonChangingFlags = false;
                break block0;
            }
        }
        if (nonChangingFlags) {
            IndexOutput indexOutput = this.vectorsStream;
            Intrinsics.checkNotNull((Object)indexOutput);
            indexOutput.writeVInt(0);
            this.scratchBuffer.reset();
            writer = DirectWriter.Companion.getInstance(this.scratchBuffer, fieldFlags.length, FLAGS_BITS);
            for (int flags : fieldFlags) {
                if (!(flags >= 0)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                writer.add(flags);
            }
            writer.finish();
            IndexOutput indexOutput2 = this.vectorsStream;
            Intrinsics.checkNotNull((Object)indexOutput2);
            indexOutput2.writeVInt(Math.INSTANCE.toIntExact(this.scratchBuffer.size()));
            IndexOutput indexOutput3 = this.vectorsStream;
            Intrinsics.checkNotNull((Object)indexOutput3);
            this.scratchBuffer.copyTo(indexOutput3);
        } else {
            IndexOutput indexOutput = this.vectorsStream;
            Intrinsics.checkNotNull((Object)indexOutput);
            indexOutput.writeVInt(1);
            this.scratchBuffer.reset();
            writer = DirectWriter.Companion.getInstance(this.scratchBuffer, totalFields, FLAGS_BITS);
            for (DocData dd : this.pendingDocs) {
                for (FieldData fd : dd.getFields()) {
                    writer.add(fd.getFlags());
                }
            }
            writer.finish();
            IndexOutput indexOutput4 = this.vectorsStream;
            Intrinsics.checkNotNull((Object)indexOutput4);
            indexOutput4.writeVInt(Math.INSTANCE.toIntExact(this.scratchBuffer.size()));
            IndexOutput indexOutput5 = this.vectorsStream;
            Intrinsics.checkNotNull((Object)indexOutput5);
            this.scratchBuffer.copyTo(indexOutput5);
        }
    }

    private final void flushNumTerms(int totalFields) throws IOException {
        int maxNumTerms = 0;
        for (DocData dd : this.pendingDocs) {
            for (FieldData fd : dd.getFields()) {
                maxNumTerms |= fd.getNumTerms();
            }
        }
        int bitsRequired = DirectWriter.Companion.bitsRequired(maxNumTerms);
        IndexOutput indexOutput = this.vectorsStream;
        Intrinsics.checkNotNull((Object)indexOutput);
        indexOutput.writeVInt(bitsRequired);
        this.scratchBuffer.reset();
        DirectWriter writer = DirectWriter.Companion.getInstance(this.scratchBuffer, totalFields, bitsRequired);
        for (DocData dd : this.pendingDocs) {
            for (FieldData fd : dd.getFields()) {
                writer.add(fd.getNumTerms());
            }
        }
        writer.finish();
        IndexOutput indexOutput2 = this.vectorsStream;
        Intrinsics.checkNotNull((Object)indexOutput2);
        indexOutput2.writeVInt(Math.INSTANCE.toIntExact(this.scratchBuffer.size()));
        IndexOutput indexOutput3 = this.vectorsStream;
        Intrinsics.checkNotNull((Object)indexOutput3);
        this.scratchBuffer.copyTo(indexOutput3);
    }

    private final void flushTermLengths() throws IOException {
        int i;
        int n;
        IndexOutput indexOutput = this.vectorsStream;
        Intrinsics.checkNotNull((Object)indexOutput);
        this.writer.reset(indexOutput);
        for (DocData dd : this.pendingDocs) {
            for (FieldData fd : dd.getFields()) {
                n = fd.getNumTerms();
                for (i = 0; i < n; ++i) {
                    this.writer.add(fd.getPrefixLengths()[i]);
                }
            }
        }
        this.writer.finish();
        IndexOutput indexOutput2 = this.vectorsStream;
        Intrinsics.checkNotNull((Object)indexOutput2);
        this.writer.reset(indexOutput2);
        for (DocData dd : this.pendingDocs) {
            for (FieldData fd : dd.getFields()) {
                n = fd.getNumTerms();
                for (i = 0; i < n; ++i) {
                    this.writer.add(fd.getSuffixLengths()[i]);
                }
            }
        }
        this.writer.finish();
    }

    private final void flushTermFreqs() throws IOException {
        IndexOutput indexOutput = this.vectorsStream;
        Intrinsics.checkNotNull((Object)indexOutput);
        this.writer.reset(indexOutput);
        for (DocData dd : this.pendingDocs) {
            for (FieldData fd : dd.getFields()) {
                int n = fd.getNumTerms();
                for (int i = 0; i < n; ++i) {
                    this.writer.add((long)fd.getFreqs()[i] - 1L);
                }
            }
        }
        this.writer.finish();
    }

    private final void flushPositions() throws IOException {
        IndexOutput indexOutput = this.vectorsStream;
        Intrinsics.checkNotNull((Object)indexOutput);
        this.writer.reset(indexOutput);
        for (DocData dd : this.pendingDocs) {
            for (FieldData fd : dd.getFields()) {
                if (!fd.getHasPositions()) continue;
                int pos = 0;
                int n = fd.getNumTerms();
                for (int i = 0; i < n; ++i) {
                    int previousPosition = 0;
                    int n2 = fd.getFreqs()[i];
                    for (int j = 0; j < n2; ++j) {
                        int position = this.positionsBuf[fd.getPosStart() + pos++];
                        this.writer.add(position - previousPosition);
                        previousPosition = position;
                    }
                }
                if (pos == fd.getTotalPositions()) continue;
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
        }
        this.writer.finish();
    }

    private final void flushOffsets(int[] fieldNums) throws IOException {
        int n;
        int i;
        int n2;
        int pos;
        boolean hasOffsets = false;
        long[] sumPos = new long[fieldNums.length];
        long[] sumOffsets = new long[fieldNums.length];
        for (DocData dd : this.pendingDocs) {
            for (FieldData fd : dd.getFields()) {
                hasOffsets |= fd.getHasOffsets();
                if (!fd.getHasOffsets() || !fd.getHasPositions()) continue;
                int fieldNumOff = Arrays.INSTANCE.binarySearch(fieldNums, fd.getFieldNum());
                pos = 0;
                n2 = fd.getNumTerms();
                for (int i2 = 0; i2 < n2; ++i2) {
                    sumPos[fieldNumOff] = sumPos[fieldNumOff] + (long)this.positionsBuf[fd.getPosStart() + fd.getFreqs()[i2] - 1 + pos];
                    sumOffsets[fieldNumOff] = sumOffsets[fieldNumOff] + (long)this.startOffsetsBuf[fd.getOffStart() + fd.getFreqs()[i2] - 1 + pos];
                    pos += fd.getFreqs()[i2];
                }
                if (pos == fd.getTotalPositions()) continue;
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
        }
        if (!hasOffsets) {
            return;
        }
        float[] charsPerTerm = new float[fieldNums.length];
        int n3 = fieldNums.length;
        for (i = 0; i < n3; ++i) {
            charsPerTerm[i] = sumPos[i] <= 0L || sumOffsets[i] <= 0L ? 0.0f : (float)((double)sumOffsets[i] / (double)sumPos[i]);
        }
        n3 = fieldNums.length;
        for (i = 0; i < n3; ++i) {
            IndexOutput indexOutput = this.vectorsStream;
            Intrinsics.checkNotNull((Object)indexOutput);
            indexOutput.writeInt(FloatExtKt.floatToRawIntBits(FloatCompanionObject.INSTANCE, charsPerTerm[i]));
        }
        IndexOutput indexOutput = this.vectorsStream;
        Intrinsics.checkNotNull((Object)indexOutput);
        this.writer.reset(indexOutput);
        for (DocData dd : this.pendingDocs) {
            for (FieldData fd : dd.getFields()) {
                if ((fd.getFlags() & 2) == 0) continue;
                int fieldNumOff = Arrays.INSTANCE.binarySearch(fieldNums, fd.getFieldNum());
                float cpt = charsPerTerm[fieldNumOff];
                int pos2 = 0;
                n = fd.getNumTerms();
                for (int i3 = 0; i3 < n; ++i3) {
                    int previousPos = 0;
                    int previousOff = 0;
                    int n4 = fd.getFreqs()[i3];
                    for (int j = 0; j < n4; ++j) {
                        int position = fd.getHasPositions() ? this.positionsBuf[fd.getPosStart() + pos2] : 0;
                        int startOffset = this.startOffsetsBuf[fd.getOffStart() + pos2];
                        this.writer.add(startOffset - previousOff - (int)(cpt * (float)(position - previousPos)));
                        previousPos = position;
                        previousOff = startOffset;
                        ++pos2;
                    }
                }
            }
        }
        this.writer.finish();
        IndexOutput indexOutput2 = this.vectorsStream;
        Intrinsics.checkNotNull((Object)indexOutput2);
        this.writer.reset(indexOutput2);
        for (DocData dd : this.pendingDocs) {
            for (FieldData fd : dd.getFields()) {
                if ((fd.getFlags() & 2) == 0) continue;
                pos = 0;
                n2 = fd.getNumTerms();
                for (int i4 = 0; i4 < n2; ++i4) {
                    n = fd.getFreqs()[i4];
                    for (int j = 0; j < n; ++j) {
                        this.writer.add(this.lengthsBuf[fd.getOffStart() + pos++] - fd.getPrefixLengths()[i4] - fd.getSuffixLengths()[i4]);
                    }
                }
                if (pos == fd.getTotalPositions()) continue;
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
        }
        this.writer.finish();
    }

    private final void flushPayloadLengths() throws IOException {
        IndexOutput indexOutput = this.vectorsStream;
        Intrinsics.checkNotNull((Object)indexOutput);
        this.writer.reset(indexOutput);
        for (DocData dd : this.pendingDocs) {
            for (FieldData fd : dd.getFields()) {
                if (!fd.getHasPayloads()) continue;
                int n = fd.getTotalPositions();
                for (int i = 0; i < n; ++i) {
                    this.writer.add(this.payloadLengthsBuf[fd.getPayStart() + i]);
                }
            }
        }
        this.writer.finish();
    }

    @Override
    public void finish(int numDocs) throws IOException {
        if (!this.pendingDocs.isEmpty()) {
            this.flush(true);
        }
        if (numDocs != this.numDocs) {
            throw new RuntimeException("Wrote " + this.numDocs + " docs, finish called with numDocs=" + numDocs);
        }
        FieldsIndexWriter fieldsIndexWriter = this.indexWriter;
        Intrinsics.checkNotNull((Object)fieldsIndexWriter);
        IndexOutput indexOutput = this.vectorsStream;
        Intrinsics.checkNotNull((Object)indexOutput);
        long l = indexOutput.getFilePointer();
        IndexOutput indexOutput2 = this.metaStream;
        Intrinsics.checkNotNull((Object)indexOutput2);
        fieldsIndexWriter.finish(numDocs, l, indexOutput2);
        IndexOutput indexOutput3 = this.metaStream;
        Intrinsics.checkNotNull((Object)indexOutput3);
        indexOutput3.writeVLong(this.numChunks);
        IndexOutput indexOutput4 = this.metaStream;
        Intrinsics.checkNotNull((Object)indexOutput4);
        indexOutput4.writeVLong(this.numDirtyChunks);
        IndexOutput indexOutput5 = this.metaStream;
        Intrinsics.checkNotNull((Object)indexOutput5);
        indexOutput5.writeVLong(this.numDirtyDocs);
        IndexOutput indexOutput6 = this.metaStream;
        Intrinsics.checkNotNull((Object)indexOutput6);
        CodecUtil.INSTANCE.writeFooter(indexOutput6);
        IndexOutput indexOutput7 = this.vectorsStream;
        Intrinsics.checkNotNull((Object)indexOutput7);
        CodecUtil.INSTANCE.writeFooter(indexOutput7);
    }

    @Override
    public void addProx(int numProx, @Nullable DataInput positions, @Nullable DataInput offsets) throws IOException {
        FieldData fieldData = this.curField;
        Intrinsics.checkNotNull((Object)fieldData);
        if (!(fieldData.getHasPositions() == (positions != null))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        FieldData fieldData2 = this.curField;
        Intrinsics.checkNotNull((Object)fieldData2);
        if (!(fieldData2.getHasOffsets() == (offsets != null))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        FieldData fieldData3 = this.curField;
        Intrinsics.checkNotNull((Object)fieldData3);
        if (fieldData3.getHasPositions()) {
            FieldData fieldData4 = this.curField;
            Intrinsics.checkNotNull((Object)fieldData4);
            int n = fieldData4.getPosStart();
            FieldData fieldData5 = this.curField;
            Intrinsics.checkNotNull((Object)fieldData5);
            int posStart = n + fieldData5.getTotalPositions();
            if (posStart + numProx > this.positionsBuf.length) {
                this.positionsBuf = ArrayUtil.Companion.grow(this.positionsBuf, posStart + numProx);
            }
            int position = 0;
            FieldData fieldData6 = this.curField;
            Intrinsics.checkNotNull((Object)fieldData6);
            if (fieldData6.getHasPayloads()) {
                FieldData fieldData7 = this.curField;
                Intrinsics.checkNotNull((Object)fieldData7);
                int n2 = fieldData7.getPayStart();
                FieldData fieldData8 = this.curField;
                Intrinsics.checkNotNull((Object)fieldData8);
                int payStart = n2 + fieldData8.getTotalPositions();
                if (payStart + numProx > this.payloadLengthsBuf.length) {
                    this.payloadLengthsBuf = ArrayUtil.Companion.grow(this.payloadLengthsBuf, payStart + numProx);
                }
                for (int i = 0; i < numProx; ++i) {
                    DataInput dataInput = positions;
                    Intrinsics.checkNotNull((Object)dataInput);
                    int code = dataInput.readVInt();
                    if ((code & 1) != 0) {
                        int payloadLength;
                        this.payloadLengthsBuf[payStart + i] = payloadLength = positions.readVInt();
                        this.payloadBytes.copyBytes(positions, payloadLength);
                    } else {
                        this.payloadLengthsBuf[payStart + i] = 0;
                    }
                    this.positionsBuf[posStart + i] = position += code >>> 1;
                }
            } else {
                for (int i = 0; i < numProx; ++i) {
                    DataInput dataInput = positions;
                    Intrinsics.checkNotNull((Object)dataInput);
                    this.positionsBuf[posStart + i] = position += dataInput.readVInt() >>> 1;
                }
            }
        }
        FieldData fieldData9 = this.curField;
        Intrinsics.checkNotNull((Object)fieldData9);
        if (fieldData9.getHasOffsets()) {
            FieldData fieldData10 = this.curField;
            Intrinsics.checkNotNull((Object)fieldData10);
            int n = fieldData10.getOffStart();
            FieldData fieldData11 = this.curField;
            Intrinsics.checkNotNull((Object)fieldData11);
            int offStart = n + fieldData11.getTotalPositions();
            if (offStart + numProx > this.startOffsetsBuf.length) {
                int newLength = ArrayUtil.Companion.oversize(offStart + numProx, 4);
                this.startOffsetsBuf = ArrayUtil.Companion.growExact(this.startOffsetsBuf, newLength);
                this.lengthsBuf = ArrayUtil.Companion.growExact(this.lengthsBuf, newLength);
            }
            int lastOffset = 0;
            int startOffset = 0;
            int endOffset = 0;
            for (int i = 0; i < numProx; ++i) {
                DataInput dataInput = offsets;
                Intrinsics.checkNotNull((Object)dataInput);
                startOffset = lastOffset + dataInput.readVInt();
                lastOffset = endOffset = startOffset + offsets.readVInt();
                this.startOffsetsBuf[offStart + i] = startOffset;
                this.lengthsBuf[offStart + i] = endOffset - startOffset;
            }
        }
        FieldData fieldData12 = this.curField;
        Intrinsics.checkNotNull((Object)fieldData12);
        FieldData fieldData13 = fieldData12;
        fieldData13.setTotalPositions(fieldData13.getTotalPositions() + numProx);
    }

    private final void copyChunks(MergeState mergeState, CompressingTermVectorsSub sub, int fromDocID, int toDocID) throws IOException {
        long toPointer;
        TermVectorsReader termVectorsReader = mergeState.getTermVectorsReaders()[sub.getReaderIndex()];
        Intrinsics.checkNotNull((Object)termVectorsReader, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.codecs.lucene90.compressing.Lucene90CompressingTermVectorsReader");
        Lucene90CompressingTermVectorsReader reader2 = (Lucene90CompressingTermVectorsReader)termVectorsReader;
        if (!(reader2.getVersion() == 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(reader2.getChunkSize() == this.chunkSize)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(reader2.getCompressionMode() == this.compressionMode)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(!this.tooDirty(reader2))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(mergeState.getLiveDocs()[sub.getReaderIndex()] == null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int docID = fromDocID;
        FieldsIndex index = reader2.getIndexReader();
        while (docID < toDocID && reader2.isLoaded(docID)) {
            this.addAllDocVectors(reader2.get(docID++), mergeState);
        }
        if (docID >= toDocID) {
            return;
        }
        long fromPointer = index.getStartPointer(docID);
        long l = toPointer = toDocID == sub.getMaxDoc() ? reader2.getMaxPointer() : index.getStartPointer(toDocID);
        if (fromPointer < toPointer) {
            long end;
            if (!this.pendingDocs.isEmpty()) {
                this.flush(true);
            }
            IndexInput rawDocs = reader2.getVectorsStream();
            rawDocs.seek(fromPointer);
            do {
                boolean dirtyChunk;
                int base;
                if ((base = rawDocs.readVInt()) != docID) {
                    throw new CorruptIndexException("invalid state: base=" + base + ", docID=" + docID, rawDocs);
                }
                int code = rawDocs.readVInt();
                int bufferedDocs = code >>> 1;
                FieldsIndexWriter fieldsIndexWriter = this.indexWriter;
                Intrinsics.checkNotNull((Object)fieldsIndexWriter);
                IndexOutput indexOutput = this.vectorsStream;
                Intrinsics.checkNotNull((Object)indexOutput);
                fieldsIndexWriter.writeIndex(bufferedDocs, indexOutput.getFilePointer());
                IndexOutput indexOutput2 = this.vectorsStream;
                Intrinsics.checkNotNull((Object)indexOutput2);
                indexOutput2.writeVInt(this.numDocs);
                IndexOutput indexOutput3 = this.vectorsStream;
                Intrinsics.checkNotNull((Object)indexOutput3);
                indexOutput3.writeVInt(code);
                this.numDocs += bufferedDocs;
                if ((docID += bufferedDocs) > toDocID) {
                    throw new CorruptIndexException("invalid state: base=" + base + ", count=" + bufferedDocs + ", toDocID=" + toDocID, rawDocs);
                }
                end = docID == sub.getMaxDoc() ? reader2.getMaxPointer() : index.getStartPointer(docID);
                IndexOutput indexOutput4 = this.vectorsStream;
                Intrinsics.checkNotNull((Object)indexOutput4);
                indexOutput4.copyBytes(rawDocs, end - rawDocs.getFilePointer());
                ++this.numChunks;
                boolean bl = dirtyChunk = (code & 1) != 0;
                if (!dirtyChunk) continue;
                long l2 = this.numDirtyChunks;
                this.numDirtyChunks = l2 + 1L;
                this.numDirtyDocs += (long)bufferedDocs;
            } while ((fromPointer = end) < toPointer);
        }
        if (!(!reader2.isLoaded(docID))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        while (docID < toDocID) {
            this.addAllDocVectors(reader2.get(docID++), mergeState);
        }
    }

    @Override
    public int merge(@NotNull MergeState mergeState) throws IOException {
        Intrinsics.checkNotNullParameter((Object)mergeState, (String)"mergeState");
        int numReaders = mergeState.getTermVectorsReaders().length;
        MatchingReaders matchingReaders = new MatchingReaders(mergeState);
        List subs = new ArrayList(numReaders);
        for (int i = 0; i < numReaders; ++i) {
            TermVectorsReader reader2;
            TermVectorsReader termVectorsReader = reader2 = mergeState.getTermVectorsReaders()[i];
            if (termVectorsReader != null) {
                termVectorsReader.checkIntegrity();
            }
            boolean bulkMerge = this.canPerformBulkMerge(mergeState, matchingReaders, i);
            subs.add(new CompressingTermVectorsSub(mergeState, bulkMerge, i));
        }
        int docCount = 0;
        DocIDMerger docIDMerger = DocIDMerger.Companion.of(subs, mergeState.getNeedsIndexSort());
        CompressingTermVectorsSub sub = null;
        sub = (CompressingTermVectorsSub)docIDMerger.next();
        while (sub != null) {
            TermVectorsReader reader3;
            if (!(((CompressingTermVectorsSub)sub).getMappedDocID() == docCount)) {
                boolean $i$a$-require-Lucene90CompressingTermVectorsWriter$merge$22 = false;
                String $i$a$-require-Lucene90CompressingTermVectorsWriter$merge$22 = ((CompressingTermVectorsSub)sub).getMappedDocID() + " != " + docCount;
                throw new IllegalArgumentException($i$a$-require-Lucene90CompressingTermVectorsWriter$merge$22.toString());
            }
            if (((CompressingTermVectorsSub)sub).getCanPerformBulkMerge()) {
                CompressingTermVectorsSub current;
                int toDocID;
                int fromDocID;
                block6: {
                    CompressingTermVectorsSub compressingTermVectorsSub;
                    toDocID = fromDocID = ((CompressingTermVectorsSub)sub).getDocID();
                    current = sub;
                    do {
                        Object t = docIDMerger.next();
                        CompressingTermVectorsSub it = (CompressingTermVectorsSub)t;
                        boolean bl = false;
                        sub = it;
                        if (t != current) break block6;
                        compressingTermVectorsSub = sub;
                        Intrinsics.checkNotNull((Object)compressingTermVectorsSub);
                    } while (compressingTermVectorsSub.getDocID() == ++toDocID);
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                this.copyChunks(mergeState, current, fromDocID, ++toDocID);
                docCount += toDocID - fromDocID;
                continue;
            }
            TermVectorsReader termVectorsReader = reader3 = mergeState.getTermVectorsReaders()[((CompressingTermVectorsSub)sub).getReaderIndex()];
            Fields vectors = termVectorsReader != null ? termVectorsReader.get(((CompressingTermVectorsSub)sub).getDocID()) : null;
            this.addAllDocVectors(vectors, mergeState);
            ++docCount;
            sub = docIDMerger.next();
        }
        this.finish(docCount);
        return docCount;
    }

    public final boolean tooDirty(@NotNull Lucene90CompressingTermVectorsReader candidate) {
        Intrinsics.checkNotNullParameter((Object)candidate, (String)"candidate");
        return candidate.getNumDirtyDocs() > (long)this.maxDocsPerChunk && candidate.getNumDirtyChunks() * (long)100 > candidate.getNumChunks();
    }

    private final boolean canPerformBulkMerge(MergeState mergeState, MatchingReaders matchingReaders, int readerIndex) {
        if (mergeState.getTermVectorsReaders()[readerIndex] instanceof Lucene90CompressingTermVectorsReader) {
            TermVectorsReader termVectorsReader = mergeState.getTermVectorsReaders()[readerIndex];
            Intrinsics.checkNotNull((Object)termVectorsReader, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.codecs.lucene90.compressing.Lucene90CompressingTermVectorsReader");
            Lucene90CompressingTermVectorsReader reader2 = (Lucene90CompressingTermVectorsReader)termVectorsReader;
            return BULK_MERGE_ENABLED && matchingReaders.getMatchingReaders()[readerIndex] && reader2.getCompressionMode() == this.compressionMode && reader2.getChunkSize() == this.chunkSize && reader2.getVersion() == 0 && reader2.getPackedIntsVersion() == PackedInts.INSTANCE.getVERSION_CURRENT() && mergeState.getLiveDocs()[readerIndex] == null && !this.tooDirty(reader2);
        }
        return false;
    }

    @Override
    public long ramBytesUsed() {
        return (long)(this.positionsBuf.length + this.startOffsetsBuf.length + this.lengthsBuf.length + this.payloadLengthsBuf.length) + this.termSuffixes.ramBytesUsed() + this.payloadBytes.ramBytesUsed() + (long)this.lastTerm.getBytes().length + this.scratchBuffer.ramBytesUsed();
    }

    @Override
    @NotNull
    public Collection<Accountable> getChildResources() {
        Object[] objectArray = new Accountable[]{this.termSuffixes, this.payloadBytes};
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }

    static {
        boolean v = true;
        try {
            v = Boolean.parseBoolean(System.INSTANCE.getProperty(BULK_MERGE_ENABLED_SYSPROP, "true"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        BULK_MERGE_ENABLED = v;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/compressing/Lucene90CompressingTermVectorsWriter$Companion;", "", "<init>", "()V", "VECTORS_EXTENSION", "", "VECTORS_INDEX_EXTENSION", "VECTORS_META_EXTENSION", "VECTORS_INDEX_CODEC_NAME", "VERSION_START", "", "VERSION_CURRENT", "META_VERSION_START", "PACKED_BLOCK_SIZE", "POSITIONS", "OFFSETS", "PAYLOADS", "FLAGS_BITS", "getFLAGS_BITS", "()I", "BULK_MERGE_ENABLED_SYSPROP", "getBULK_MERGE_ENABLED_SYSPROP", "()Ljava/lang/String;", "BULK_MERGE_ENABLED", "", "getBULK_MERGE_ENABLED", "()Z", "core"})
    public static final class Companion {
        private Companion() {
        }

        public final int getFLAGS_BITS() {
            return FLAGS_BITS;
        }

        @NotNull
        public final String getBULK_MERGE_ENABLED_SYSPROP() {
            return BULK_MERGE_ENABLED_SYSPROP;
        }

        public final boolean getBULK_MERGE_ENABLED() {
            return BULK_MERGE_ENABLED;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0014\u001a\u00020\u0007H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u001a\u0010\u0010\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/compressing/Lucene90CompressingTermVectorsWriter$CompressingTermVectorsSub;", "Lorg/gnit/lucenekmp/index/DocIDMerger$Sub;", "mergeState", "Lorg/gnit/lucenekmp/index/MergeState;", "canPerformBulkMerge", "", "readerIndex", "", "<init>", "(Lorg/gnit/lucenekmp/index/MergeState;ZI)V", "getCanPerformBulkMerge", "()Z", "getReaderIndex", "()I", "maxDoc", "getMaxDoc", "docID", "getDocID", "setDocID", "(I)V", "nextDoc", "core"})
    private static final class CompressingTermVectorsSub
    extends DocIDMerger.Sub {
        private final boolean canPerformBulkMerge;
        private final int readerIndex;
        private final int maxDoc;
        private int docID;

        public CompressingTermVectorsSub(@NotNull MergeState mergeState, boolean canPerformBulkMerge, int readerIndex) {
            Intrinsics.checkNotNullParameter((Object)mergeState, (String)"mergeState");
            MergeState.DocMap[] docMapArray = mergeState.getDocMaps();
            Intrinsics.checkNotNull((Object)docMapArray);
            super(docMapArray[readerIndex]);
            this.canPerformBulkMerge = canPerformBulkMerge;
            this.readerIndex = readerIndex;
            this.maxDoc = mergeState.getMaxDocs()[this.readerIndex];
            this.docID = -1;
        }

        public final boolean getCanPerformBulkMerge() {
            return this.canPerformBulkMerge;
        }

        public final int getReaderIndex() {
            return this.readerIndex;
        }

        public final int getMaxDoc() {
            return this.maxDoc;
        }

        public final int getDocID() {
            return this.docID;
        }

        public final void setDocID(int n) {
            this.docID = n;
        }

        @Override
        public int nextDoc() {
            int n = this.docID;
            this.docID = n + 1;
            return this.docID == this.maxDoc ? Integer.MAX_VALUE : this.docID;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ2\u0010\u0014\u001a\u00060\u0010R\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u001b\u0010\u000e\u001a\f\u0012\b\u0012\u00060\u0010R\u00020\u00110\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001b"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/compressing/Lucene90CompressingTermVectorsWriter$DocData;", "", "numFields", "", "posStart", "offStart", "payStart", "<init>", "(Lorg/gnit/lucenekmp/codecs/lucene90/compressing/Lucene90CompressingTermVectorsWriter;IIII)V", "getNumFields", "()I", "getPosStart", "getOffStart", "getPayStart", "fields", "Lkotlin/collections/ArrayDeque;", "Lorg/gnit/lucenekmp/codecs/lucene90/compressing/Lucene90CompressingTermVectorsWriter$FieldData;", "Lorg/gnit/lucenekmp/codecs/lucene90/compressing/Lucene90CompressingTermVectorsWriter;", "getFields", "()Lkotlin/collections/ArrayDeque;", "addField", "fieldNum", "numTerms", "positions", "", "offsets", "payloads", "core"})
    private final class DocData {
        private final int numFields;
        private final int posStart;
        private final int offStart;
        private final int payStart;
        @NotNull
        private final ArrayDeque<FieldData> fields;

        public DocData(int numFields, int posStart, int offStart, int payStart) {
            this.numFields = numFields;
            this.posStart = posStart;
            this.offStart = offStart;
            this.payStart = payStart;
            this.fields = new ArrayDeque(this.numFields);
        }

        public final int getNumFields() {
            return this.numFields;
        }

        public final int getPosStart() {
            return this.posStart;
        }

        public final int getOffStart() {
            return this.offStart;
        }

        public final int getPayStart() {
            return this.payStart;
        }

        @NotNull
        public final ArrayDeque<FieldData> getFields() {
            return this.fields;
        }

        @NotNull
        public final FieldData addField(int fieldNum, int numTerms, boolean positions, boolean offsets, boolean payloads) {
            FieldData field = null;
            if (this.fields.isEmpty()) {
                field = new FieldData(fieldNum, numTerms, positions, offsets, payloads, this.posStart, this.offStart, this.payStart);
            } else {
                FieldData last = ArrayDequeExtKt.getLast(this.fields);
                int posStart = last.getPosStart() + (last.getHasPositions() ? last.getTotalPositions() : 0);
                int offStart = last.getOffStart() + (last.getHasOffsets() ? last.getTotalPositions() : 0);
                int payStart = last.getPayStart() + (last.getHasPayloads() ? last.getTotalPositions() : 0);
                field = new FieldData(fieldNum, numTerms, positions, offsets, payloads, posStart, offStart, payStart);
            }
            this.fields.add((Object)field);
            return field;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0010\u0015\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\t\b\u0082\u0004\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u001e\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00032\u0006\u0010,\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\u0003J&\u0010.\u001a\u00020*2\u0006\u0010/\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u00032\u0006\u00102\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000fR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000fR\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000fR\u0011\u0010\u0018\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000fR\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001dR\u0011\u0010 \u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001dR\u001a\u0010\"\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u000f\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u000f\"\u0004\b(\u0010%\u00a8\u00063"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/compressing/Lucene90CompressingTermVectorsWriter$FieldData;", "", "fieldNum", "", "numTerms", "hasPositions", "", "hasOffsets", "hasPayloads", "posStart", "offStart", "payStart", "<init>", "(Lorg/gnit/lucenekmp/codecs/lucene90/compressing/Lucene90CompressingTermVectorsWriter;IIZZZIII)V", "getFieldNum", "()I", "getNumTerms", "getHasPositions", "()Z", "getHasOffsets", "getHasPayloads", "getPosStart", "getOffStart", "getPayStart", "flags", "getFlags", "freqs", "", "getFreqs", "()[I", "prefixLengths", "getPrefixLengths", "suffixLengths", "getSuffixLengths", "totalPositions", "getTotalPositions", "setTotalPositions", "(I)V", "ord", "getOrd", "setOrd", "addTerm", "", "freq", "prefixLength", "suffixLength", "addPosition", "position", "startOffset", "length", "payloadLength", "core"})
    private final class FieldData {
        private final int fieldNum;
        private final int numTerms;
        private final boolean hasPositions;
        private final boolean hasOffsets;
        private final boolean hasPayloads;
        private final int posStart;
        private final int offStart;
        private final int payStart;
        private final int flags;
        @NotNull
        private final int[] freqs;
        @NotNull
        private final int[] prefixLengths;
        @NotNull
        private final int[] suffixLengths;
        private int totalPositions;
        private int ord;

        public FieldData(int fieldNum, int numTerms, boolean hasPositions, boolean hasOffsets, boolean hasPayloads, int posStart, int offStart, int payStart) {
            this.fieldNum = fieldNum;
            this.numTerms = numTerms;
            this.hasPositions = hasPositions;
            this.hasOffsets = hasOffsets;
            this.hasPayloads = hasPayloads;
            this.posStart = posStart;
            this.offStart = offStart;
            this.payStart = payStart;
            this.flags = (this.hasPositions ? 1 : 0) | (this.hasOffsets ? 2 : 0) | (this.hasPayloads ? 4 : 0);
            this.freqs = new int[this.numTerms];
            this.prefixLengths = new int[this.numTerms];
            this.suffixLengths = new int[this.numTerms];
        }

        public final int getFieldNum() {
            return this.fieldNum;
        }

        public final int getNumTerms() {
            return this.numTerms;
        }

        public final boolean getHasPositions() {
            return this.hasPositions;
        }

        public final boolean getHasOffsets() {
            return this.hasOffsets;
        }

        public final boolean getHasPayloads() {
            return this.hasPayloads;
        }

        public final int getPosStart() {
            return this.posStart;
        }

        public final int getOffStart() {
            return this.offStart;
        }

        public final int getPayStart() {
            return this.payStart;
        }

        public final int getFlags() {
            return this.flags;
        }

        @NotNull
        public final int[] getFreqs() {
            return this.freqs;
        }

        @NotNull
        public final int[] getPrefixLengths() {
            return this.prefixLengths;
        }

        @NotNull
        public final int[] getSuffixLengths() {
            return this.suffixLengths;
        }

        public final int getTotalPositions() {
            return this.totalPositions;
        }

        public final void setTotalPositions(int n) {
            this.totalPositions = n;
        }

        public final int getOrd() {
            return this.ord;
        }

        public final void setOrd(int n) {
            this.ord = n;
        }

        public final void addTerm(int freq, int prefixLength, int suffixLength) {
            this.freqs[this.ord] = freq;
            this.prefixLengths[this.ord] = prefixLength;
            this.suffixLengths[this.ord] = suffixLength;
            ++this.ord;
        }

        public final void addPosition(int position, int startOffset, int length, int payloadLength) {
            if (this.hasPositions) {
                if (this.posStart + this.totalPositions == Lucene90CompressingTermVectorsWriter.this.positionsBuf.length) {
                    Lucene90CompressingTermVectorsWriter.this.positionsBuf = ArrayUtil.Companion.grow(Lucene90CompressingTermVectorsWriter.this.positionsBuf);
                }
                ((Lucene90CompressingTermVectorsWriter)Lucene90CompressingTermVectorsWriter.this).positionsBuf[this.posStart + this.totalPositions] = position;
            }
            if (this.hasOffsets) {
                if (this.offStart + this.totalPositions == Lucene90CompressingTermVectorsWriter.this.startOffsetsBuf.length) {
                    int newLength = ArrayUtil.Companion.oversize(this.offStart + this.totalPositions, 4);
                    Lucene90CompressingTermVectorsWriter.this.startOffsetsBuf = ArrayUtil.Companion.growExact(Lucene90CompressingTermVectorsWriter.this.startOffsetsBuf, newLength);
                    Lucene90CompressingTermVectorsWriter.this.lengthsBuf = ArrayUtil.Companion.growExact(Lucene90CompressingTermVectorsWriter.this.lengthsBuf, newLength);
                }
                ((Lucene90CompressingTermVectorsWriter)Lucene90CompressingTermVectorsWriter.this).startOffsetsBuf[this.offStart + this.totalPositions] = startOffset;
                ((Lucene90CompressingTermVectorsWriter)Lucene90CompressingTermVectorsWriter.this).lengthsBuf[this.offStart + this.totalPositions] = length;
            }
            if (this.hasPayloads) {
                if (this.payStart + this.totalPositions == Lucene90CompressingTermVectorsWriter.this.payloadLengthsBuf.length) {
                    Lucene90CompressingTermVectorsWriter.this.payloadLengthsBuf = ArrayUtil.Companion.grow(Lucene90CompressingTermVectorsWriter.this.payloadLengthsBuf);
                }
                ((Lucene90CompressingTermVectorsWriter)Lucene90CompressingTermVectorsWriter.this).payloadLengthsBuf[this.payStart + this.totalPositions] = payloadLength;
            }
            ++this.totalPositions;
        }
    }
}

