/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs.lucene95;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.codecs.lucene90.IndexedDISI;
import org.gnit.lucenekmp.index.DocsWithFieldSet;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.store.IndexInput;
import org.gnit.lucenekmp.store.IndexOutput;
import org.gnit.lucenekmp.store.RandomAccessInput;
import org.gnit.lucenekmp.util.packed.DirectMonotonicReader;
import org.gnit.lucenekmp.util.packed.DirectMonotonicWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 (2\u00020\u0001:\u0001(BK\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020#2\u0006\u0010 \u001a\u00020!R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010$\u001a\u00020%8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010&R\u0011\u0010'\u001a\u00020%8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010&\u00a8\u0006)"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene95/OrdToDocDISIReaderConfiguration;", "", "size", "", "jumpTableEntryCount", "", "addressesOffset", "", "addressesLength", "docsWithFieldOffset", "docsWithFieldLength", "denseRankPower", "", "meta", "Lorg/gnit/lucenekmp/util/packed/DirectMonotonicReader$Meta;", "<init>", "(ISJJJJBLorg/gnit/lucenekmp/util/packed/DirectMonotonicReader$Meta;)V", "getSize", "()I", "getJumpTableEntryCount", "()S", "getAddressesOffset", "()J", "getAddressesLength", "getDocsWithFieldOffset", "getDocsWithFieldLength", "getDenseRankPower", "()B", "getMeta", "()Lorg/gnit/lucenekmp/util/packed/DirectMonotonicReader$Meta;", "getIndexedDISI", "Lorg/gnit/lucenekmp/codecs/lucene90/IndexedDISI;", "dataIn", "Lorg/gnit/lucenekmp/store/IndexInput;", "getDirectMonotonicReader", "Lorg/gnit/lucenekmp/util/packed/DirectMonotonicReader;", "isEmpty", "", "()Z", "isDense", "Companion", "core"})
public final class OrdToDocDISIReaderConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int size;
    private final short jumpTableEntryCount;
    private final long addressesOffset;
    private final long addressesLength;
    private final long docsWithFieldOffset;
    private final long docsWithFieldLength;
    private final byte denseRankPower;
    @Nullable
    private final DirectMonotonicReader.Meta meta;

    public OrdToDocDISIReaderConfiguration(int size2, short jumpTableEntryCount, long addressesOffset, long addressesLength, long docsWithFieldOffset, long docsWithFieldLength, byte denseRankPower, @Nullable DirectMonotonicReader.Meta meta) {
        this.size = size2;
        this.jumpTableEntryCount = jumpTableEntryCount;
        this.addressesOffset = addressesOffset;
        this.addressesLength = addressesLength;
        this.docsWithFieldOffset = docsWithFieldOffset;
        this.docsWithFieldLength = docsWithFieldLength;
        this.denseRankPower = denseRankPower;
        this.meta = meta;
    }

    public final int getSize() {
        return this.size;
    }

    public final short getJumpTableEntryCount() {
        return this.jumpTableEntryCount;
    }

    public final long getAddressesOffset() {
        return this.addressesOffset;
    }

    public final long getAddressesLength() {
        return this.addressesLength;
    }

    public final long getDocsWithFieldOffset() {
        return this.docsWithFieldOffset;
    }

    public final long getDocsWithFieldLength() {
        return this.docsWithFieldLength;
    }

    public final byte getDenseRankPower() {
        return this.denseRankPower;
    }

    @Nullable
    public final DirectMonotonicReader.Meta getMeta() {
        return this.meta;
    }

    @NotNull
    public final IndexedDISI getIndexedDISI(@NotNull IndexInput dataIn) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dataIn, (String)"dataIn");
        if (!(this.docsWithFieldOffset > -1L)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return new IndexedDISI(dataIn, this.docsWithFieldOffset, this.docsWithFieldLength, this.jumpTableEntryCount, this.denseRankPower, this.size);
    }

    @NotNull
    public final DirectMonotonicReader getDirectMonotonicReader(@NotNull IndexInput dataIn) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dataIn, (String)"dataIn");
        if (!(this.docsWithFieldOffset > -1L)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        RandomAccessInput addressesData = dataIn.randomAccessSlice(this.addressesOffset, this.addressesLength);
        DirectMonotonicReader.Meta meta = this.meta;
        Intrinsics.checkNotNull((Object)meta);
        return DirectMonotonicReader.Companion.getInstance(meta, addressesData);
    }

    public final boolean isEmpty() {
        return this.docsWithFieldOffset == -2L;
    }

    public final boolean isDense() {
        return this.docsWithFieldOffset == -1L;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007\u00a8\u0006\u0014"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene95/OrdToDocDISIReaderConfiguration$Companion;", "", "<init>", "()V", "writeStoredMeta", "", "directMonotonicBlockShift", "", "outputMeta", "Lorg/gnit/lucenekmp/store/IndexOutput;", "vectorData", "count", "maxDoc", "docsWithField", "Lorg/gnit/lucenekmp/index/DocsWithFieldSet;", "fromStoredMeta", "Lorg/gnit/lucenekmp/codecs/lucene95/OrdToDocDISIReaderConfiguration;", "inputMeta", "Lorg/gnit/lucenekmp/store/IndexInput;", "size", "core"})
    public static final class Companion {
        private Companion() {
        }

        public final void writeStoredMeta(int directMonotonicBlockShift, @NotNull IndexOutput outputMeta, @NotNull IndexOutput vectorData, int count, int maxDoc, @NotNull DocsWithFieldSet docsWithField) throws IOException {
            Intrinsics.checkNotNullParameter((Object)outputMeta, (String)"outputMeta");
            Intrinsics.checkNotNullParameter((Object)vectorData, (String)"vectorData");
            Intrinsics.checkNotNullParameter((Object)docsWithField, (String)"docsWithField");
            if (count == 0) {
                outputMeta.writeLong(-2L);
                outputMeta.writeLong(0L);
                outputMeta.writeShort((short)-1);
                outputMeta.writeByte((byte)-1);
            } else if (count == maxDoc) {
                outputMeta.writeLong(-1L);
                outputMeta.writeLong(0L);
                outputMeta.writeShort((short)-1);
                outputMeta.writeByte((byte)-1);
            } else {
                long offset = vectorData.getFilePointer();
                outputMeta.writeLong(offset);
                short jumpTableEntryCount = IndexedDISI.Companion.writeBitSet(docsWithField.iterator(), vectorData, (byte)9);
                outputMeta.writeLong(vectorData.getFilePointer() - offset);
                outputMeta.writeShort(jumpTableEntryCount);
                outputMeta.writeByte((byte)9);
                long start = vectorData.getFilePointer();
                outputMeta.writeLong(start);
                outputMeta.writeVInt(directMonotonicBlockShift);
                DirectMonotonicWriter ordToDocWriter = DirectMonotonicWriter.Companion.getInstance(outputMeta, vectorData, count, directMonotonicBlockShift);
                DocIdSetIterator iterator2 = docsWithField.iterator();
                int doc = iterator2.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    ordToDocWriter.add(doc);
                    doc = iterator2.nextDoc();
                }
                ordToDocWriter.finish();
                outputMeta.writeLong(vectorData.getFilePointer() - start);
            }
        }

        @NotNull
        public final OrdToDocDISIReaderConfiguration fromStoredMeta(@NotNull IndexInput inputMeta, int size2) throws IOException {
            Intrinsics.checkNotNullParameter((Object)inputMeta, (String)"inputMeta");
            long docsWithFieldOffset = inputMeta.readLong();
            long docsWithFieldLength = inputMeta.readLong();
            short jumpTableEntryCount = inputMeta.readShort();
            byte denseRankPower = inputMeta.readByte();
            long addressesOffset = 0L;
            int blockShift = 0;
            DirectMonotonicReader.Meta meta = null;
            long addressesLength = 0L;
            if (docsWithFieldOffset > -1L) {
                addressesOffset = inputMeta.readLong();
                blockShift = inputMeta.readVInt();
                meta = DirectMonotonicReader.Companion.loadMeta(inputMeta, size2, blockShift);
                addressesLength = inputMeta.readLong();
            }
            return new OrdToDocDISIReaderConfiguration(size2, jumpTableEntryCount, addressesOffset, addressesLength, docsWithFieldOffset, docsWithFieldLength, denseRankPower, meta);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

