/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs.lucene99;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.gnit.lucenekmp.codecs.CodecUtil;
import org.gnit.lucenekmp.codecs.KnnFieldVectorsWriter;
import org.gnit.lucenekmp.codecs.KnnVectorsReader;
import org.gnit.lucenekmp.codecs.KnnVectorsWriter;
import org.gnit.lucenekmp.codecs.hnsw.FlatFieldVectorsWriter;
import org.gnit.lucenekmp.codecs.hnsw.FlatVectorsScorer;
import org.gnit.lucenekmp.codecs.hnsw.FlatVectorsWriter;
import org.gnit.lucenekmp.codecs.lucene99.Lucene99HnswVectorsReader;
import org.gnit.lucenekmp.index.ByteVectorValues;
import org.gnit.lucenekmp.index.DocsWithFieldSet;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.FieldInfos;
import org.gnit.lucenekmp.index.FloatVectorValues;
import org.gnit.lucenekmp.index.IndexFileNames;
import org.gnit.lucenekmp.index.KnnVectorValues;
import org.gnit.lucenekmp.index.MergeState;
import org.gnit.lucenekmp.index.SegmentWriteState;
import org.gnit.lucenekmp.index.Sorter;
import org.gnit.lucenekmp.index.VectorEncoding;
import org.gnit.lucenekmp.index.VectorSimilarityFunction;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.jdkport.Math;
import org.gnit.lucenekmp.search.TaskExecutor;
import org.gnit.lucenekmp.store.IndexOutput;
import org.gnit.lucenekmp.util.Bits;
import org.gnit.lucenekmp.util.IOUtils;
import org.gnit.lucenekmp.util.InfoStream;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.gnit.lucenekmp.util.hnsw.CloseableRandomVectorScorerSupplier;
import org.gnit.lucenekmp.util.hnsw.ConcurrentHnswMerger;
import org.gnit.lucenekmp.util.hnsw.HnswGraph;
import org.gnit.lucenekmp.util.hnsw.HnswGraphBuilder;
import org.gnit.lucenekmp.util.hnsw.HnswGraphMerger;
import org.gnit.lucenekmp.util.hnsw.IncrementalHnswGraphMerger;
import org.gnit.lucenekmp.util.hnsw.NeighborArray;
import org.gnit.lucenekmp.util.hnsw.OnHeapHnswGraph;
import org.gnit.lucenekmp.util.hnsw.RandomVectorScorerSupplier;
import org.gnit.lucenekmp.util.hnsw.UpdateableRandomVectorScorer;
import org.gnit.lucenekmp.util.packed.DirectMonotonicWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 I2\u00020\u0001:\u0002HIB9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0014\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001a\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00052\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\b\u0010 \u001a\u00020\u001cH\u0016J\b\u0010!\u001a\u00020\"H\u0016J\u0014\u0010#\u001a\u00020\u001c2\n\u0010$\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0002J\u001c\u0010%\u001a\u00020\u001c2\n\u0010$\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J9\u0010&\u001a\u0004\u0018\u00010'2\b\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+2\u000e\u0010-\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010+0.H\u0002\u00a2\u0006\u0002\u0010/J(\u00100\u001a\u00020\u001c2\u0006\u00101\u001a\u0002022\u0006\u0010,\u001a\u00020+2\u0006\u00103\u001a\u00020+2\u0006\u00104\u001a\u00020\u0005H\u0002J\u0018\u00105\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u00106\u001a\u000207H\u0016J\u001f\u00108\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010+0.2\b\u0010(\u001a\u0004\u0018\u00010)H\u0002\u00a2\u0006\u0002\u00109JG\u0010:\u001a\u00020\u001c2\u0006\u0010;\u001a\u00020\u001a2\u0006\u0010<\u001a\u00020\"2\u0006\u0010=\u001a\u00020\"2\u0006\u0010>\u001a\u00020\u00052\b\u0010(\u001a\u0004\u0018\u00010'2\u000e\u0010?\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010+0.H\u0002\u00a2\u0006\u0002\u0010@J*\u0010A\u001a\u00020B2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010C\u001a\u00020D2\b\u0010E\u001a\u0004\u0018\u00010\u000b2\u0006\u0010F\u001a\u00020\u0005H\u0002J\b\u0010G\u001a\u00020\u001cH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene99/Lucene99HnswVectorsWriter;", "Lorg/gnit/lucenekmp/codecs/KnnVectorsWriter;", "state", "Lorg/gnit/lucenekmp/index/SegmentWriteState;", "M", "", "beamWidth", "flatVectorWriter", "Lorg/gnit/lucenekmp/codecs/hnsw/FlatVectorsWriter;", "numMergeWorkers", "mergeExec", "Lorg/gnit/lucenekmp/search/TaskExecutor;", "<init>", "(Lorg/gnit/lucenekmp/index/SegmentWriteState;IILorg/gnit/lucenekmp/codecs/hnsw/FlatVectorsWriter;ILorg/gnit/lucenekmp/search/TaskExecutor;)V", "segmentWriteState", "meta", "Lorg/gnit/lucenekmp/store/IndexOutput;", "vectorIndex", "fields", "", "Lorg/gnit/lucenekmp/codecs/lucene99/Lucene99HnswVectorsWriter$FieldWriter;", "finished", "", "addField", "Lorg/gnit/lucenekmp/codecs/KnnFieldVectorsWriter;", "fieldInfo", "Lorg/gnit/lucenekmp/index/FieldInfo;", "flush", "", "maxDoc", "sortMap", "Lorg/gnit/lucenekmp/index/Sorter$DocMap;", "finish", "ramBytesUsed", "", "writeField", "fieldData", "writeSortingField", "reconstructAndWriteGraph", "Lorg/gnit/lucenekmp/util/hnsw/HnswGraph;", "graph", "Lorg/gnit/lucenekmp/util/hnsw/OnHeapHnswGraph;", "newToOldMap", "", "oldToNewMap", "levelNodeOffsets", "", "(Lorg/gnit/lucenekmp/util/hnsw/OnHeapHnswGraph;[I[I[[I)Lorg/gnit/lucenekmp/util/hnsw/HnswGraph;", "reconstructAndWriteNeighbours", "neighbors", "Lorg/gnit/lucenekmp/util/hnsw/NeighborArray;", "scratch", "maxOrd", "mergeOneField", "mergeState", "Lorg/gnit/lucenekmp/index/MergeState;", "writeGraph", "(Lorg/gnit/lucenekmp/util/hnsw/OnHeapHnswGraph;)[[I", "writeMeta", "field", "vectorIndexOffset", "vectorIndexLength", "count", "graphLevelNodeOffsets", "(Lorg/gnit/lucenekmp/index/FieldInfo;JJILorg/gnit/lucenekmp/util/hnsw/HnswGraph;[[I)V", "createGraphMerger", "Lorg/gnit/lucenekmp/util/hnsw/HnswGraphMerger;", "scorerSupplier", "Lorg/gnit/lucenekmp/util/hnsw/RandomVectorScorerSupplier;", "parallelMergeTaskExecutor", "numParallelMergeWorkers", "close", "FieldWriter", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nLucene99HnswVectorsWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Lucene99HnswVectorsWriter.kt\norg/gnit/lucenekmp/codecs/lucene99/Lucene99HnswVectorsWriter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,657:1\n1#2:658\n*E\n"})
public final class Lucene99HnswVectorsWriter
extends KnnVectorsWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int M;
    private final int beamWidth;
    @NotNull
    private final FlatVectorsWriter flatVectorWriter;
    private final int numMergeWorkers;
    @Nullable
    private final TaskExecutor mergeExec;
    @NotNull
    private final SegmentWriteState segmentWriteState;
    @Nullable
    private final IndexOutput meta;
    @Nullable
    private final IndexOutput vectorIndex;
    @NotNull
    private final List<FieldWriter<?>> fields;
    private boolean finished;
    private static final long SHALLOW_RAM_BYTES_USED = RamUsageEstimator.Companion.shallowSizeOfInstance(Reflection.getOrCreateKotlinClass(Lucene99HnswVectorsWriter.class));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lucene99HnswVectorsWriter(@NotNull SegmentWriteState state2, int M, int beamWidth, @NotNull FlatVectorsWriter flatVectorWriter, int numMergeWorkers, @Nullable TaskExecutor mergeExec) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)flatVectorWriter, (String)"flatVectorWriter");
        this.M = M;
        this.beamWidth = beamWidth;
        this.flatVectorWriter = flatVectorWriter;
        this.numMergeWorkers = numMergeWorkers;
        this.mergeExec = mergeExec;
        this.segmentWriteState = state2;
        this.fields = new ArrayList();
        String metaFileName = IndexFileNames.INSTANCE.segmentFileName(state2.getSegmentInfo().getName(), state2.getSegmentSuffix(), "vem");
        String indexDataFileName = IndexFileNames.INSTANCE.segmentFileName(state2.getSegmentInfo().getName(), state2.getSegmentSuffix(), "vex");
        boolean success = false;
        try {
            this.meta = state2.getDirectory().createOutput(metaFileName, state2.getContext());
            this.vectorIndex = state2.getDirectory().createOutput(indexDataFileName, state2.getContext());
            CodecUtil.INSTANCE.writeIndexHeader(this.meta, "Lucene99HnswVectorsFormatMeta", 0, state2.getSegmentInfo().getId(), state2.getSegmentSuffix());
            CodecUtil.INSTANCE.writeIndexHeader(this.vectorIndex, "Lucene99HnswVectorsFormatIndex", 0, state2.getSegmentInfo().getId(), state2.getSegmentSuffix());
            success = true;
        }
        catch (Throwable throwable) {
            AutoCloseable[] autoCloseableArray = new AutoCloseable[]{this};
            IOUtils.INSTANCE.closeWhileHandlingException(autoCloseableArray);
            throw throwable;
        }
    }

    @Override
    @NotNull
    public KnnFieldVectorsWriter<?> addField(@NotNull FieldInfo fieldInfo) throws IOException {
        Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
        FlatVectorsScorer flatVectorsScorer = this.flatVectorWriter.getFlatVectorScorer();
        FlatFieldVectorsWriter<?> flatFieldVectorsWriter = this.flatVectorWriter.addField(fieldInfo);
        InfoStream infoStream = this.segmentWriteState.getInfoStream();
        Intrinsics.checkNotNull((Object)infoStream);
        FieldWriter<?> newField = FieldWriter.Companion.create(flatVectorsScorer, flatFieldVectorsWriter, fieldInfo, this.M, this.beamWidth, infoStream);
        this.fields.add(newField);
        return newField;
    }

    @Override
    public void flush(int maxDoc, @Nullable Sorter.DocMap sortMap) throws IOException {
        this.flatVectorWriter.flush(maxDoc, sortMap);
        for (FieldWriter<?> field : this.fields) {
            if (sortMap == null) {
                this.writeField(field);
                continue;
            }
            this.writeSortingField(field, sortMap);
        }
    }

    @Override
    public void finish() throws IOException {
        if (!(!this.finished)) {
            boolean bl = false;
            String string = "already finished";
            throw new IllegalStateException(string.toString());
        }
        this.finished = true;
        this.flatVectorWriter.finish();
        if (this.meta != null) {
            this.meta.writeInt(-1);
            CodecUtil.INSTANCE.writeFooter(this.meta);
        }
        if (this.vectorIndex != null) {
            CodecUtil.INSTANCE.writeFooter(this.vectorIndex);
        }
    }

    @Override
    public long ramBytesUsed() {
        long total = SHALLOW_RAM_BYTES_USED;
        for (FieldWriter<?> field : this.fields) {
            total += field.ramBytesUsed();
        }
        return total;
    }

    private final void writeField(FieldWriter<?> fieldData) throws IOException {
        IndexOutput indexOutput = this.vectorIndex;
        Intrinsics.checkNotNull((Object)indexOutput);
        long vectorIndexOffset = indexOutput.getFilePointer();
        OnHeapHnswGraph onHeapHnswGraph = fieldData.getGraph();
        Intrinsics.checkNotNull((Object)onHeapHnswGraph);
        OnHeapHnswGraph graph = onHeapHnswGraph;
        int[][] graphLevelNodeOffsets = this.writeGraph(graph);
        long vectorIndexLength = this.vectorIndex.getFilePointer() - vectorIndexOffset;
        this.writeMeta(fieldData.getFieldInfo(), vectorIndexOffset, vectorIndexLength, fieldData.getDocsWithFieldSet().cardinality(), graph, graphLevelNodeOffsets);
    }

    private final void writeSortingField(FieldWriter<?> fieldData, Sorter.DocMap sortMap) throws IOException {
        OnHeapHnswGraph graph;
        int[] ordMap = new int[fieldData.getDocsWithFieldSet().cardinality()];
        int[] oldOrdMap = new int[fieldData.getDocsWithFieldSet().cardinality()];
        KnnVectorsWriter.Companion.mapOldOrdToNewOrd(fieldData.getDocsWithFieldSet(), sortMap, oldOrdMap, ordMap, null);
        IndexOutput indexOutput = this.vectorIndex;
        Intrinsics.checkNotNull((Object)indexOutput);
        long vectorIndexOffset = indexOutput.getFilePointer();
        OnHeapHnswGraph onHeapHnswGraph = graph = fieldData.getGraph();
        int[][] graphLevelNodeOffsets = onHeapHnswGraph == null ? new int[][]{} : new int[onHeapHnswGraph.numLevels()][];
        OnHeapHnswGraph onHeapHnswGraph2 = graph;
        Intrinsics.checkNotNull((Object)onHeapHnswGraph2);
        HnswGraph mockGraph = this.reconstructAndWriteGraph(onHeapHnswGraph2, ordMap, oldOrdMap, graphLevelNodeOffsets);
        long vectorIndexLength = this.vectorIndex.getFilePointer() - vectorIndexOffset;
        this.writeMeta(fieldData.getFieldInfo(), vectorIndexOffset, vectorIndexLength, fieldData.getDocsWithFieldSet().cardinality(), mockGraph, graphLevelNodeOffsets);
    }

    private final HnswGraph reconstructAndWriteGraph(OnHeapHnswGraph graph, int[] newToOldMap, int[] oldToNewMap, int[][] levelNodeOffsets) throws IOException {
        if (graph == null) {
            return null;
        }
        List nodesByLevel = new ArrayList(graph.numLevels());
        nodesByLevel.add(null);
        int maxOrd = graph.size();
        int[] scratch = new int[graph.maxConn() * 2];
        HnswGraph.NodesIterator nodesOnLevel0 = graph.getNodesOnLevel(0);
        levelNodeOffsets[0] = new int[nodesOnLevel0.size()];
        while (nodesOnLevel0.hasNext()) {
            int node = nodesOnLevel0.nextInt();
            NeighborArray neighbors = graph.getNeighbors(0, newToOldMap[node]);
            IndexOutput indexOutput = this.vectorIndex;
            Intrinsics.checkNotNull((Object)indexOutput);
            long offset = indexOutput.getFilePointer();
            this.reconstructAndWriteNeighbours(neighbors, oldToNewMap, scratch, maxOrd);
            int[] nArray = levelNodeOffsets[0];
            Intrinsics.checkNotNull((Object)nArray);
            nArray[node] = Math.INSTANCE.toIntExact(this.vectorIndex.getFilePointer() - offset);
        }
        int n = graph.numLevels();
        for (int level = 1; level < n; ++level) {
            HnswGraph.NodesIterator nodesOnLevel = graph.getNodesOnLevel(level);
            int[] newNodes = new int[nodesOnLevel.size()];
            int n2 = 0;
            while (nodesOnLevel.hasNext()) {
                newNodes[n2] = oldToNewMap[nodesOnLevel.nextInt()];
                ++n2;
            }
            Arrays.INSTANCE.sort(newNodes);
            nodesByLevel.add(newNodes);
            levelNodeOffsets[level] = new int[newNodes.length];
            int nodeOffsetIndex = 0;
            for (int node : newNodes) {
                NeighborArray neighbors = graph.getNeighbors(level, newToOldMap[node]);
                IndexOutput indexOutput = this.vectorIndex;
                Intrinsics.checkNotNull((Object)indexOutput);
                long offset = indexOutput.getFilePointer();
                this.reconstructAndWriteNeighbours(neighbors, oldToNewMap, scratch, maxOrd);
                int[] nArray = levelNodeOffsets[level];
                Intrinsics.checkNotNull((Object)nArray);
                nArray[nodeOffsetIndex++] = Math.INSTANCE.toIntExact(this.vectorIndex.getFilePointer() - offset);
            }
        }
        return new HnswGraph(graph, nodesByLevel){
            final /* synthetic */ OnHeapHnswGraph $graph;
            final /* synthetic */ List<int[]> $nodesByLevel;
            {
                this.$graph = $graph;
                this.$nodesByLevel = $nodesByLevel;
            }

            public int nextNeighbor() {
                throw new UnsupportedOperationException("Not supported on a mock graph");
            }

            public void seek(int level, int target) {
                throw new UnsupportedOperationException("Not supported on a mock graph");
            }

            public int size() {
                return this.$graph.size();
            }

            public int numLevels() {
                return this.$graph.numLevels();
            }

            public int maxConn() {
                return this.$graph.maxConn();
            }

            public int entryNode() {
                throw new UnsupportedOperationException("Not supported on a mock graph");
            }

            public int neighborCount() {
                throw new UnsupportedOperationException("Not supported on a mock graph");
            }

            public HnswGraph.NodesIterator getNodesOnLevel(int level) {
                HnswGraph.NodesIterator nodesIterator;
                if (level == 0) {
                    nodesIterator = this.$graph.getNodesOnLevel(0);
                } else {
                    int[] nArray = this.$nodesByLevel.get(level);
                    Intrinsics.checkNotNull((Object)nArray);
                    int[] nArray2 = this.$nodesByLevel.get(level);
                    Intrinsics.checkNotNull((Object)nArray2);
                    nodesIterator = new HnswGraph.ArrayNodesIterator(nArray, nArray2.length);
                }
                return nodesIterator;
            }
        };
    }

    private final void reconstructAndWriteNeighbours(NeighborArray neighbors, int[] oldToNewMap, int[] scratch, int maxOrd) throws IOException {
        int i;
        int size2 = neighbors.size();
        int[] nnodes = neighbors.nodes();
        for (int i2 = 0; i2 < size2; ++i2) {
            nnodes[i2] = oldToNewMap[nnodes[i2]];
        }
        Arrays.INSTANCE.sort(nnodes, 0, size2);
        int actualSize = 0;
        if (size2 > 0) {
            scratch[0] = nnodes[0];
            actualSize = 1;
        }
        for (i = 1; i < size2; ++i) {
            if (!(nnodes[i] < maxOrd)) {
                boolean bl = false;
                String string = "node too large: " + nnodes[i] + ">=" + maxOrd;
                throw new IllegalArgumentException(string.toString());
            }
            if (nnodes[i - 1] == nnodes[i]) continue;
            scratch[actualSize++] = nnodes[i] - nnodes[i - 1];
        }
        IndexOutput indexOutput = this.vectorIndex;
        Intrinsics.checkNotNull((Object)indexOutput);
        indexOutput.writeVInt(actualSize);
        int n = actualSize;
        for (i = 0; i < n; ++i) {
            this.vectorIndex.writeVInt(scratch[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mergeOneField(@NotNull FieldInfo fieldInfo, @NotNull MergeState mergeState) throws IOException {
        Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
        Intrinsics.checkNotNullParameter((Object)mergeState, (String)"mergeState");
        CloseableRandomVectorScorerSupplier scorerSupplier2 = this.flatVectorWriter.mergeOneFieldToIndex(fieldInfo, mergeState);
        boolean success = false;
        try {
            IndexOutput indexOutput = this.vectorIndex;
            Intrinsics.checkNotNull((Object)indexOutput);
            long vectorIndexOffset = indexOutput.getFilePointer();
            OnHeapHnswGraph graph = null;
            int[][] vectorIndexNodeOffsets = null;
            if (scorerSupplier2.totalVectorCount() > 0) {
                HnswGraphMerger merger = this.createGraphMerger(fieldInfo, scorerSupplier2, mergeState.getIntraMergeTaskExecutor() == null ? null : new TaskExecutor(mergeState.getIntraMergeTaskExecutor()), this.numMergeWorkers);
                int n = mergeState.getLiveDocs().length;
                for (int i = 0; i < n; ++i) {
                    FieldInfos fieldInfos = mergeState.getFieldInfos()[i];
                    Intrinsics.checkNotNull((Object)fieldInfos);
                    if (!KnnVectorsWriter.MergedVectorValues.INSTANCE.hasVectorValues(fieldInfos, fieldInfo.getName())) continue;
                    KnnVectorsReader knnVectorsReader = mergeState.getKnnVectorsReaders()[i];
                    Intrinsics.checkNotNull((Object)knnVectorsReader);
                    MergeState.DocMap[] docMapArray = mergeState.getDocMaps();
                    Intrinsics.checkNotNull((Object)docMapArray);
                    MergeState.DocMap docMap = docMapArray[i];
                    Bits bits = mergeState.getLiveDocs()[i];
                    Intrinsics.checkNotNull((Object)bits);
                    merger.addReader(knnVectorsReader, docMap, bits);
                }
                KnnVectorValues mergedVectorValues = switch (WhenMappings.$EnumSwitchMapping$0[fieldInfo.getVectorEncoding().ordinal()]) {
                    case 1 -> KnnVectorsWriter.MergedVectorValues.INSTANCE.mergeByteVectorValues(fieldInfo, mergeState);
                    case 2 -> KnnVectorsWriter.MergedVectorValues.INSTANCE.mergeFloatVectorValues(fieldInfo, mergeState);
                    default -> throw new NoWhenBranchMatchedException();
                };
                InfoStream infoStream = this.segmentWriteState.getInfoStream();
                Intrinsics.checkNotNull((Object)infoStream);
                graph = merger.merge(mergedVectorValues, infoStream, scorerSupplier2.totalVectorCount());
                vectorIndexNodeOffsets = this.writeGraph(graph);
            }
            long vectorIndexLength = this.vectorIndex.getFilePointer() - vectorIndexOffset;
            int n = scorerSupplier2.totalVectorCount();
            HnswGraph hnswGraph = graph;
            Intrinsics.checkNotNull(vectorIndexNodeOffsets);
            this.writeMeta(fieldInfo, vectorIndexOffset, vectorIndexLength, n, hnswGraph, vectorIndexNodeOffsets);
            success = true;
        }
        catch (Throwable throwable) {
            AutoCloseable[] autoCloseableArray = new AutoCloseable[]{scorerSupplier2};
            IOUtils.INSTANCE.closeWhileHandlingException(autoCloseableArray);
            throw throwable;
        }
        AutoCloseable[] autoCloseableArray = new AutoCloseable[]{scorerSupplier2};
        IOUtils.INSTANCE.close(autoCloseableArray);
    }

    private final int[][] writeGraph(OnHeapHnswGraph graph) throws IOException {
        if (graph == null) {
            int n = 0;
            int[][] nArrayArray = new int[][]{};
            while (n < 0) {
                int n2 = n++;
                nArrayArray[n2] = new int[0];
            }
            return nArrayArray;
        }
        int countOnLevel0 = graph.size();
        int[][] offsets = new int[graph.numLevels()][];
        int[] scratch = new int[graph.maxConn() * 2];
        int n = graph.numLevels();
        for (int level = 0; level < n; ++level) {
            int[] sortedNodes = HnswGraph.NodesIterator.Companion.getSortedNodes(graph.getNodesOnLevel(level));
            offsets[level] = new int[sortedNodes.length];
            int nodeOffsetId = 0;
            for (int node : sortedNodes) {
                int i;
                NeighborArray neighbors = graph.getNeighbors(level, node);
                int size2 = neighbors.size();
                IndexOutput indexOutput = this.vectorIndex;
                Intrinsics.checkNotNull((Object)indexOutput);
                long offsetStart = indexOutput.getFilePointer();
                int[] nnodes = neighbors.nodes();
                Arrays.INSTANCE.sort(nnodes, 0, size2);
                int actualSize = 0;
                if (size2 > 0) {
                    scratch[0] = nnodes[0];
                    actualSize = 1;
                }
                for (i = 1; i < size2; ++i) {
                    if (!(nnodes[i] < countOnLevel0)) {
                        boolean bl = false;
                        String string = "node too large: " + nnodes[i] + ">=" + countOnLevel0;
                        throw new IllegalArgumentException(string.toString());
                    }
                    if (nnodes[i - 1] == nnodes[i]) continue;
                    scratch[actualSize++] = nnodes[i] - nnodes[i - 1];
                }
                this.vectorIndex.writeVInt(actualSize);
                int n3 = actualSize;
                for (i = 0; i < n3; ++i) {
                    this.vectorIndex.writeVInt(scratch[i]);
                }
                int[] nArray = offsets[level];
                Intrinsics.checkNotNull((Object)nArray);
                nArray[nodeOffsetId++] = Math.INSTANCE.toIntExact(this.vectorIndex.getFilePointer() - offsetStart);
            }
        }
        return offsets;
    }

    private final void writeMeta(FieldInfo field, long vectorIndexOffset, long vectorIndexLength, int count, HnswGraph graph, int[][] graphLevelNodeOffsets) throws IOException {
        IndexOutput indexOutput = this.meta;
        Intrinsics.checkNotNull((Object)indexOutput);
        indexOutput.writeInt(field.getNumber());
        this.meta.writeInt(field.getVectorEncoding().ordinal());
        this.meta.writeInt(Companion.distFuncToOrd(field.getVectorSimilarityFunction()));
        this.meta.writeVLong(vectorIndexOffset);
        this.meta.writeVLong(vectorIndexLength);
        this.meta.writeVInt(field.getVectorDimension());
        this.meta.writeInt(count);
        if (graph == null) {
            this.meta.writeVInt(this.M);
            this.meta.writeVInt(0);
        } else {
            int n;
            this.meta.writeVInt(graph.maxConn());
            this.meta.writeVInt(graph.numLevels());
            long valueCount = 0L;
            int n2 = graph.numLevels();
            for (int level = 0; level < n2; ++level) {
                HnswGraph.NodesIterator nodesOnLevel = graph.getNodesOnLevel(level);
                valueCount += (long)nodesOnLevel.size();
                if (level > 0) {
                    int[] nol = new int[nodesOnLevel.size()];
                    int numberConsumed = nodesOnLevel.consume(nol);
                    Arrays.INSTANCE.sort(nol);
                    if (!(numberConsumed == nodesOnLevel.size())) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.meta.writeVInt(nol.length);
                    for (int i = nodesOnLevel.size() - 1; 0 < i; --i) {
                        n = i;
                        nol[n] = nol[n] - nol[i - 1];
                    }
                    for (int n3 : nol) {
                        if (!(n3 >= 0)) {
                            boolean bl = false;
                            String string = "delta encoding for nodes failed; expected nodes to be sorted";
                            throw new IllegalArgumentException(string.toString());
                        }
                        this.meta.writeVInt(n3);
                    }
                    continue;
                }
                if (nodesOnLevel.size() == count) continue;
                boolean bl = false;
                String string = "Level 0 expects to have all nodes";
                throw new IllegalArgumentException(string.toString());
            }
            IndexOutput indexOutput2 = this.vectorIndex;
            Intrinsics.checkNotNull((Object)indexOutput2);
            long start = indexOutput2.getFilePointer();
            this.meta.writeLong(start);
            this.meta.writeVInt(16);
            DirectMonotonicWriter memoryOffsetsWriter = DirectMonotonicWriter.Companion.getInstance(this.meta, this.vectorIndex, valueCount, 16);
            long cumulativeOffsetSum = 0L;
            n = ((Object[])graphLevelNodeOffsets).length;
            for (int i = 0; i < n; ++i) {
                int[] levelOffsets = graphLevelNodeOffsets[i];
                Intrinsics.checkNotNull((Object)levelOffsets);
                for (int v : levelOffsets) {
                    memoryOffsetsWriter.add(cumulativeOffsetSum);
                    cumulativeOffsetSum += (long)v;
                }
            }
            memoryOffsetsWriter.finish();
            this.meta.writeLong(this.vectorIndex.getFilePointer() - start);
        }
    }

    private final HnswGraphMerger createGraphMerger(FieldInfo fieldInfo, RandomVectorScorerSupplier scorerSupplier2, TaskExecutor parallelMergeTaskExecutor, int numParallelMergeWorkers) {
        if (this.mergeExec != null) {
            return new ConcurrentHnswMerger(fieldInfo, scorerSupplier2, this.M, this.beamWidth, this.mergeExec, this.numMergeWorkers);
        }
        if (parallelMergeTaskExecutor != null) {
            return new ConcurrentHnswMerger(fieldInfo, scorerSupplier2, this.M, this.beamWidth, parallelMergeTaskExecutor, numParallelMergeWorkers);
        }
        return new IncrementalHnswGraphMerger(fieldInfo, scorerSupplier2, this.M, this.beamWidth);
    }

    @Override
    public void close() throws IOException {
        AutoCloseable[] autoCloseableArray = new AutoCloseable[3];
        Intrinsics.checkNotNull((Object)this.meta);
        Intrinsics.checkNotNull((Object)this.vectorIndex);
        autoCloseableArray[2] = this.flatVectorWriter;
        IOUtils.INSTANCE.close(autoCloseableArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene99/Lucene99HnswVectorsWriter$Companion;", "", "<init>", "()V", "SHALLOW_RAM_BYTES_USED", "", "distFuncToOrd", "", "func", "Lorg/gnit/lucenekmp/index/VectorSimilarityFunction;", "core"})
    public static final class Companion {
        private Companion() {
        }

        public final int distFuncToOrd(@NotNull VectorSimilarityFunction func) {
            Intrinsics.checkNotNullParameter((Object)((Object)func), (String)"func");
            int n = Lucene99HnswVectorsReader.Companion.getSIMILARITY_FUNCTIONS().size();
            for (int i = 0; i < n; ++i) {
                if (Lucene99HnswVectorsReader.Companion.getSIMILARITY_FUNCTIONS().get(i) != func) continue;
                return (byte)i;
            }
            throw new IllegalArgumentException("invalid distance function: " + func);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u0002\u0018\u0000 (*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001(B=\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001d\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0015\u0010 \u001a\u00028\u00002\u0006\u0010\u001a\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010!J\b\u0010&\u001a\u00020'H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0013\u0010\"\u001a\u0004\u0018\u00010#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u0006)"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene99/Lucene99HnswVectorsWriter$FieldWriter;", "T", "Lorg/gnit/lucenekmp/codecs/KnnFieldVectorsWriter;", "scorer", "Lorg/gnit/lucenekmp/codecs/hnsw/FlatVectorsScorer;", "flatFieldVectorsWriter", "Lorg/gnit/lucenekmp/codecs/hnsw/FlatFieldVectorsWriter;", "fieldInfo", "Lorg/gnit/lucenekmp/index/FieldInfo;", "M", "", "beamWidth", "infoStream", "Lorg/gnit/lucenekmp/util/InfoStream;", "<init>", "(Lorg/gnit/lucenekmp/codecs/hnsw/FlatVectorsScorer;Lorg/gnit/lucenekmp/codecs/hnsw/FlatFieldVectorsWriter;Lorg/gnit/lucenekmp/index/FieldInfo;IILorg/gnit/lucenekmp/util/InfoStream;)V", "getFieldInfo", "()Lorg/gnit/lucenekmp/index/FieldInfo;", "hnswGraphBuilder", "Lorg/gnit/lucenekmp/util/hnsw/HnswGraphBuilder;", "lastDocID", "node", "Lorg/gnit/lucenekmp/util/hnsw/UpdateableRandomVectorScorer;", "addValue", "", "docID", "vectorValue", "(ILjava/lang/Object;)V", "docsWithFieldSet", "Lorg/gnit/lucenekmp/index/DocsWithFieldSet;", "getDocsWithFieldSet", "()Lorg/gnit/lucenekmp/index/DocsWithFieldSet;", "copyValue", "(Ljava/lang/Object;)Ljava/lang/Object;", "graph", "Lorg/gnit/lucenekmp/util/hnsw/OnHeapHnswGraph;", "getGraph", "()Lorg/gnit/lucenekmp/util/hnsw/OnHeapHnswGraph;", "ramBytesUsed", "", "Companion", "core"})
    private static final class FieldWriter<T>
    extends KnnFieldVectorsWriter<T> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final FieldInfo fieldInfo;
        @NotNull
        private final HnswGraphBuilder hnswGraphBuilder;
        private int lastDocID;
        private int node;
        @NotNull
        private final FlatFieldVectorsWriter<T> flatFieldVectorsWriter;
        @NotNull
        private final UpdateableRandomVectorScorer scorer;
        private static final long SHALLOW_SIZE = RamUsageEstimator.Companion.shallowSizeOfInstance(Reflection.getOrCreateKotlinClass(FieldWriter.class));

        public FieldWriter(@NotNull FlatVectorsScorer scorer2, @NotNull FlatFieldVectorsWriter<T> flatFieldVectorsWriter, @NotNull FieldInfo fieldInfo, int M, int beamWidth, @NotNull InfoStream infoStream) {
            Intrinsics.checkNotNullParameter((Object)scorer2, (String)"scorer");
            Intrinsics.checkNotNullParameter(flatFieldVectorsWriter, (String)"flatFieldVectorsWriter");
            Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
            Intrinsics.checkNotNullParameter((Object)infoStream, (String)"infoStream");
            this.fieldInfo = fieldInfo;
            this.lastDocID = -1;
            RandomVectorScorerSupplier scorerSupplier2 = switch (WhenMappings.$EnumSwitchMapping$0[this.fieldInfo.getVectorEncoding().ordinal()]) {
                case 1 -> {
                    VectorSimilarityFunction v0 = this.fieldInfo.getVectorSimilarityFunction();
                    List<T> v1 = flatFieldVectorsWriter.getVectors();
                    Intrinsics.checkNotNull(v1, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.ByteArray>");
                    yield scorer2.getRandomVectorScorerSupplier(v0, ByteVectorValues.Companion.fromBytes(TypeIntrinsics.asMutableList(v1), this.fieldInfo.getVectorDimension()));
                }
                case 2 -> {
                    VectorSimilarityFunction v3 = this.fieldInfo.getVectorSimilarityFunction();
                    List<T> v4 = flatFieldVectorsWriter.getVectors();
                    Intrinsics.checkNotNull(v4, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.FloatArray>");
                    yield scorer2.getRandomVectorScorerSupplier(v3, FloatVectorValues.Companion.fromFloats(TypeIntrinsics.asMutableList(v4), this.fieldInfo.getVectorDimension()));
                }
                default -> throw new NoWhenBranchMatchedException();
            };
            this.scorer = scorerSupplier2.scorer();
            this.hnswGraphBuilder = HnswGraphBuilder.Companion.create(scorerSupplier2, M, beamWidth, HnswGraphBuilder.Companion.getRandSeed());
            this.hnswGraphBuilder.setInfoStream(infoStream);
            this.flatFieldVectorsWriter = flatFieldVectorsWriter;
        }

        @NotNull
        public final FieldInfo getFieldInfo() {
            return this.fieldInfo;
        }

        @Override
        public void addValue(int docID, T vectorValue) throws IOException {
            if (!(docID != this.lastDocID)) {
                boolean bl = false;
                String string = "VectorValuesField \"" + this.fieldInfo.getName() + "\" appears more than once in this document (only one value is allowed per field)";
                throw new IllegalArgumentException(string.toString());
            }
            this.flatFieldVectorsWriter.addValue(docID, vectorValue);
            this.scorer.setScoringOrdinal(this.node);
            this.hnswGraphBuilder.addGraphNode(this.node, this.scorer);
            int n = this.node;
            this.node = n + 1;
            this.lastDocID = docID;
        }

        @NotNull
        public final DocsWithFieldSet getDocsWithFieldSet() {
            return this.flatFieldVectorsWriter.getDocsWithFieldSet();
        }

        @Override
        public T copyValue(T vectorValue) {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public final OnHeapHnswGraph getGraph() {
            if (!this.flatFieldVectorsWriter.isFinished()) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            return this.node > 0 ? this.hnswGraphBuilder.getCompletedGraph() : null;
        }

        @Override
        public long ramBytesUsed() {
            return SHALLOW_SIZE + this.flatFieldVectorsWriter.ramBytesUsed() + this.hnswGraphBuilder.getGraph().ramBytesUsed();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J>\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene99/Lucene99HnswVectorsWriter$FieldWriter$Companion;", "", "<init>", "()V", "SHALLOW_SIZE", "", "create", "Lorg/gnit/lucenekmp/codecs/lucene99/Lucene99HnswVectorsWriter$FieldWriter;", "scorer", "Lorg/gnit/lucenekmp/codecs/hnsw/FlatVectorsScorer;", "flatFieldVectorsWriter", "Lorg/gnit/lucenekmp/codecs/hnsw/FlatFieldVectorsWriter;", "fieldInfo", "Lorg/gnit/lucenekmp/index/FieldInfo;", "M", "", "beamWidth", "infoStream", "Lorg/gnit/lucenekmp/util/InfoStream;", "core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final FieldWriter<?> create(@NotNull FlatVectorsScorer scorer2, @NotNull FlatFieldVectorsWriter<?> flatFieldVectorsWriter, @NotNull FieldInfo fieldInfo, int M, int beamWidth, @NotNull InfoStream infoStream) throws IOException {
                Intrinsics.checkNotNullParameter((Object)scorer2, (String)"scorer");
                Intrinsics.checkNotNullParameter(flatFieldVectorsWriter, (String)"flatFieldVectorsWriter");
                Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
                Intrinsics.checkNotNullParameter((Object)infoStream, (String)"infoStream");
                return switch (WhenMappings.$EnumSwitchMapping$0[fieldInfo.getVectorEncoding().ordinal()]) {
                    case 1 -> new FieldWriter(scorer2, flatFieldVectorsWriter, fieldInfo, M, beamWidth, infoStream);
                    case 2 -> new FieldWriter(scorer2, flatFieldVectorsWriter, fieldInfo, M, beamWidth, infoStream);
                    default -> throw new NoWhenBranchMatchedException();
                };
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={2, 2, 0}, k=3, xi=48)
            public static final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[VectorEncoding.values().length];
                    try {
                        nArray[VectorEncoding.BYTE.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[VectorEncoding.FLOAT32.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[VectorEncoding.values().length];
                try {
                    nArray[VectorEncoding.BYTE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[VectorEncoding.FLOAT32.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VectorEncoding.values().length];
            try {
                nArray[VectorEncoding.BYTE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VectorEncoding.FLOAT32.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

