/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.document;

import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongCompanionObject;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gnit.lucenekmp.jdkport.LongExtKt;
import org.gnit.lucenekmp.jdkport.Math;
import org.gnit.lucenekmp.jdkport.Objects;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.gnit.lucenekmp.util.packed.PackedInts;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u0000 %2\u00020\u0001:\u0001%B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u0014H\u0002J\u000e\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u0014J\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00140\u001dJ\b\u0010\u001e\u001a\u00020\nH\u0016J\u0013\u0010\u001f\u001a\u00020\u000e2\b\u0010 \u001a\u0004\u0018\u00010!H\u0096\u0002J\b\u0010\"\u001a\u00020#H\u0016J\u0006\u0010\u0011\u001a\u00020\nJ\b\u0010$\u001a\u00020\u0014H\u0016R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016\u00a8\u0006&"}, d2={"Lorg/gnit/lucenekmp/document/DocValuesLongHashSet;", "Lorg/gnit/lucenekmp/util/Accountable;", "values", "", "<init>", "([J)V", "table", "getTable", "()[J", "mask", "", "getMask", "()I", "hasMissingValue", "", "getHasMissingValue", "()Z", "size", "getSize", "minValue", "", "getMinValue", "()J", "maxValue", "getMaxValue", "add", "l", "contains", "stream", "Lkotlin/sequences/Sequence;", "hashCode", "equals", "obj", "", "toString", "", "ramBytesUsed", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nDocValuesLongHashSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocValuesLongHashSet.kt\norg/gnit/lucenekmp/document/DocValuesLongHashSet\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,134:1\n1#2:135\n*E\n"})
public final class DocValuesLongHashSet
implements Accountable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final long[] table;
    private final int mask;
    private final boolean hasMissingValue;
    private final int size;
    private final long minValue;
    private final long maxValue;
    private static final long BASE_RAM_BYTES = RamUsageEstimator.Companion.shallowSizeOfInstance(Reflection.getOrCreateKotlinClass(DocValuesLongHashSet.class));
    private static final long MISSING = Long.MIN_VALUE;

    public DocValuesLongHashSet(@NotNull long[] values2) {
        Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
        int tableSize = Math.INSTANCE.toIntExact((long)values2.length * 3L / (long)2);
        tableSize = 1 << PackedInts.INSTANCE.bitsRequired(tableSize);
        if (!((long)tableSize >= (long)values2.length * 3L / (long)2)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.table = new long[tableSize];
        org.gnit.lucenekmp.jdkport.Arrays.INSTANCE.fill(this.table, Long.MIN_VALUE);
        this.mask = tableSize - 1;
        boolean hasMissingValue = false;
        int size2 = 0;
        long previousValue = Long.MIN_VALUE;
        int n = values2.length;
        for (int i = 0; i < n; ++i) {
            long value = values2[i];
            if (value == Long.MIN_VALUE) {
                size2 += hasMissingValue ? 0 : 1;
                hasMissingValue = true;
            } else if (this.add(value)) {
                ++size2;
            }
            if (!(value >= previousValue)) {
                boolean bl = false;
                String string = "values must be provided in sorted order";
                throw new IllegalArgumentException(string.toString());
            }
            previousValue = value;
        }
        this.hasMissingValue = hasMissingValue;
        this.size = size2;
        this.minValue = values2.length == 0 ? Long.MAX_VALUE : values2[0];
        this.maxValue = values2.length == 0 ? Long.MIN_VALUE : values2[values2.length - 1];
    }

    @NotNull
    public final long[] getTable() {
        return this.table;
    }

    public final int getMask() {
        return this.mask;
    }

    public final boolean getHasMissingValue() {
        return this.hasMissingValue;
    }

    public final int getSize() {
        return this.size;
    }

    public final long getMinValue() {
        return this.minValue;
    }

    public final long getMaxValue() {
        return this.maxValue;
    }

    private final boolean add(long l) {
        int slot;
        if (!(l != Long.MIN_VALUE)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int i = slot = LongExtKt.hashCode(LongCompanionObject.INSTANCE, l) & this.mask;
        while (true) {
            if (this.table[i] == Long.MIN_VALUE) {
                this.table[i] = l;
                return true;
            }
            if (this.table[i] == l) {
                return false;
            }
            i = i + 1 & this.mask;
        }
    }

    public final boolean contains(long l) {
        int slot;
        if (l == Long.MIN_VALUE) {
            return this.hasMissingValue;
        }
        int i = slot = LongExtKt.hashCode(LongCompanionObject.INSTANCE, l) & this.mask;
        while (this.table[i] != Long.MIN_VALUE) {
            if (this.table[i] == l) {
                return true;
            }
            i = i + 1 & this.mask;
        }
        return false;
    }

    @NotNull
    public final Sequence<Long> stream() {
        Sequence filteredSequence = SequencesKt.filter((Sequence)ArraysKt.asSequence((long[])this.table), DocValuesLongHashSet::stream$lambda$1);
        return this.hasMissingValue ? SequencesKt.plus((Sequence)SequencesKt.sequenceOf((Object)Long.MIN_VALUE), (Sequence)filteredSequence) : filteredSequence;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.size, this.minValue, this.maxValue, this.mask, this.hasMissingValue, Arrays.hashCode(this.table)};
        return Objects.INSTANCE.hash(objectArray);
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof DocValuesLongHashSet) {
            return this.size == ((DocValuesLongHashSet)obj).size && this.minValue == ((DocValuesLongHashSet)obj).minValue && this.maxValue == ((DocValuesLongHashSet)obj).maxValue && this.mask == ((DocValuesLongHashSet)obj).mask && this.hasMissingValue == ((DocValuesLongHashSet)obj).hasMissingValue && Arrays.equals(this.table, ((DocValuesLongHashSet)obj).table);
        }
        return false;
    }

    @NotNull
    public String toString() {
        return SequencesKt.joinToString$default((Sequence)SequencesKt.map(this.stream(), DocValuesLongHashSet::toString$lambda$2), (CharSequence)", ", (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)56, null);
    }

    public final int size() {
        return this.size;
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES + RamUsageEstimator.Companion.sizeOfObject(this.table);
    }

    @Override
    @NotNull
    public Collection<Accountable> getChildResources() {
        return Accountable.super.getChildResources();
    }

    private static final boolean stream$lambda$1(long it) {
        return it != Long.MIN_VALUE;
    }

    private static final String toString$lambda$2(long it) {
        return String.valueOf(it);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/gnit/lucenekmp/document/DocValuesLongHashSet$Companion;", "", "<init>", "()V", "BASE_RAM_BYTES", "", "MISSING", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

