/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.document;

import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.document.Document;
import org.gnit.lucenekmp.document.FieldType;
import org.gnit.lucenekmp.document.StoredField;
import org.gnit.lucenekmp.document.TextField;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.StoredFieldVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u001d\b\u0016\u0012\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\b\"\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\tB\t\b\u0016\u00a2\u0006\u0004\b\u0005\u0010\nJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004H\u0016J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/gnit/lucenekmp/document/DocumentStoredFieldVisitor;", "Lorg/gnit/lucenekmp/index/StoredFieldVisitor;", "fieldsToAdd", "", "", "<init>", "(Ljava/util/Set;)V", "fields", "", "([Ljava/lang/String;)V", "()V", "document", "Lorg/gnit/lucenekmp/document/Document;", "getDocument", "()Lorg/gnit/lucenekmp/document/Document;", "binaryField", "", "fieldInfo", "Lorg/gnit/lucenekmp/index/FieldInfo;", "value", "", "stringField", "intField", "", "longField", "", "floatField", "", "doubleField", "", "needsField", "Lorg/gnit/lucenekmp/index/StoredFieldVisitor$Status;", "core"})
public final class DocumentStoredFieldVisitor
extends StoredFieldVisitor {
    @NotNull
    private final Document document;
    @Nullable
    private final Set<String> fieldsToAdd;

    @NotNull
    public final Document getDocument() {
        return this.document;
    }

    public DocumentStoredFieldVisitor(@Nullable Set<String> fieldsToAdd) {
        this.document = new Document();
        this.fieldsToAdd = fieldsToAdd;
    }

    public DocumentStoredFieldVisitor(String ... fields) {
        Intrinsics.checkNotNullParameter((Object)fields, (String)"fields");
        this.document = new Document();
        this.fieldsToAdd = SetsKt.mutableSetOf((Object[])Arrays.copyOf(fields, fields.length));
    }

    public DocumentStoredFieldVisitor() {
        this.document = new Document();
        this.fieldsToAdd = null;
    }

    @Override
    public void binaryField(@NotNull FieldInfo fieldInfo, @NotNull byte[] value) throws IOException {
        Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.document.add(new StoredField(fieldInfo.getName(), value));
    }

    @Override
    public void stringField(@NotNull FieldInfo fieldInfo, @NotNull String value) throws IOException {
        Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        FieldType ft = new FieldType(TextField.Companion.getTYPE_STORED());
        ft.setStoreTermVectors(fieldInfo.hasTermVectors());
        ft.setOmitNorms(fieldInfo.omitsNorms());
        ft.setIndexOptions(fieldInfo.getIndexOptions());
        this.document.add(new StoredField(fieldInfo.getName(), value, ft));
    }

    @Override
    public void intField(@NotNull FieldInfo fieldInfo, int value) {
        Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
        this.document.add(new StoredField(fieldInfo.getName(), value));
    }

    @Override
    public void longField(@NotNull FieldInfo fieldInfo, long value) {
        Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
        this.document.add(new StoredField(fieldInfo.getName(), value));
    }

    @Override
    public void floatField(@NotNull FieldInfo fieldInfo, float value) {
        Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
        this.document.add(new StoredField(fieldInfo.getName(), value));
    }

    @Override
    public void doubleField(@NotNull FieldInfo fieldInfo, double value) {
        Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
        this.document.add(new StoredField(fieldInfo.getName(), value));
    }

    @Override
    @NotNull
    public StoredFieldVisitor.Status needsField(@NotNull FieldInfo fieldInfo) throws IOException {
        Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
        return this.fieldsToAdd == null || this.fieldsToAdd.contains(fieldInfo.getName()) ? StoredFieldVisitor.Status.YES : StoredFieldVisitor.Status.NO;
    }
}

