/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.document;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.analysis.Analyzer;
import org.gnit.lucenekmp.analysis.TokenStream;
import org.gnit.lucenekmp.analysis.tokenattributes.BytesTermAttribute;
import org.gnit.lucenekmp.analysis.tokenattributes.CharTermAttribute;
import org.gnit.lucenekmp.analysis.tokenattributes.OffsetAttribute;
import org.gnit.lucenekmp.document.InvertableType;
import org.gnit.lucenekmp.document.StoredValue;
import org.gnit.lucenekmp.index.DocValuesType;
import org.gnit.lucenekmp.index.IndexOptions;
import org.gnit.lucenekmp.index.IndexableField;
import org.gnit.lucenekmp.index.IndexableFieldType;
import org.gnit.lucenekmp.index.StoredFieldDataInput;
import org.gnit.lucenekmp.jdkport.Reader;
import org.gnit.lucenekmp.util.BytesRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001:\u0003HIJB\u0019\b\u0014\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\nB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\rB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0010B1\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0014B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0017B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u000e\u001a\u00020\u0018\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0019J\b\u0010$\u001a\u00020%H\u0004J\n\u0010&\u001a\u0004\u0018\u00010\u0003H\u0016J\n\u0010*\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010+\u001a\u0004\u0018\u00010\fJ\u0010\u0010,\u001a\u00020-2\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u000e\u0010.\u001a\u00020-2\u0006\u0010\u000e\u001a\u00020\tJ\u000e\u0010/\u001a\u00020-2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010/\u001a\u00020-2\u0006\u0010\u000e\u001a\u00020\u0016H\u0016J\u000e\u00100\u001a\u00020-2\u0006\u0010\u000e\u001a\u000201J\u000e\u00102\u001a\u00020-2\u0006\u0010\u000e\u001a\u000203J\u0010\u00104\u001a\u00020-2\u0006\u0010\u000e\u001a\u00020\u0012H\u0016J\u0010\u00105\u001a\u00020-2\u0006\u0010\u000e\u001a\u000206H\u0016J\u0010\u00107\u001a\u00020-2\u0006\u0010\u000e\u001a\u000208H\u0016J\u0010\u00109\u001a\u00020-2\u0006\u0010\u000e\u001a\u00020:H\u0016J\u000e\u0010;\u001a\u00020-2\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\u0002\u001a\u00020\u0003H\u0016J\n\u0010<\u001a\u0004\u0018\u00010=H\u0016J\n\u0010>\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u0010?\u001a\u00020\u0003H\u0016J\b\u0010@\u001a\u00020\u0005H\u0016J\b\u0010A\u001a\u00020BH\u0016J\u001c\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010C\u001a\u00020D2\b\u0010E\u001a\u0004\u0018\u00010\fH\u0016J\n\u0010F\u001a\u0004\u0018\u00010GH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u001fX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0016\u0010'\u001a\u0004\u0018\u00010\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u0006K"}, d2={"Lorg/gnit/lucenekmp/document/Field;", "Lorg/gnit/lucenekmp/index/IndexableField;", "name", "", "type", "Lorg/gnit/lucenekmp/index/IndexableFieldType;", "<init>", "(Ljava/lang/String;Lorg/gnit/lucenekmp/index/IndexableFieldType;)V", "reader", "Lorg/gnit/lucenekmp/jdkport/Reader;", "(Ljava/lang/String;Lorg/gnit/lucenekmp/jdkport/Reader;Lorg/gnit/lucenekmp/index/IndexableFieldType;)V", "tokenStream", "Lorg/gnit/lucenekmp/analysis/TokenStream;", "(Ljava/lang/String;Lorg/gnit/lucenekmp/analysis/TokenStream;Lorg/gnit/lucenekmp/index/IndexableFieldType;)V", "value", "", "(Ljava/lang/String;[BLorg/gnit/lucenekmp/index/IndexableFieldType;)V", "offset", "", "length", "(Ljava/lang/String;[BIILorg/gnit/lucenekmp/index/IndexableFieldType;)V", "bytes", "Lorg/gnit/lucenekmp/util/BytesRef;", "(Ljava/lang/String;Lorg/gnit/lucenekmp/util/BytesRef;Lorg/gnit/lucenekmp/index/IndexableFieldType;)V", "", "(Ljava/lang/String;Ljava/lang/CharSequence;Lorg/gnit/lucenekmp/index/IndexableFieldType;)V", "getType", "()Lorg/gnit/lucenekmp/index/IndexableFieldType;", "getName", "()Ljava/lang/String;", "fieldsData", "", "getFieldsData", "()Ljava/lang/Object;", "setFieldsData", "(Ljava/lang/Object;)V", "isFieldsDataInitialized", "", "stringValue", "charSequenceValue", "getCharSequenceValue", "()Ljava/lang/CharSequence;", "readerValue", "tokenStreamValue", "setStringValue", "", "setReaderValue", "setBytesValue", "setByteValue", "", "setShortValue", "", "setIntValue", "setLongValue", "", "setFloatValue", "", "setDoubleValue", "", "setTokenStream", "numericValue", "", "binaryValue", "toString", "fieldType", "invertableType", "Lorg/gnit/lucenekmp/document/InvertableType;", "analyzer", "Lorg/gnit/lucenekmp/analysis/Analyzer;", "reuse", "storedValue", "Lorg/gnit/lucenekmp/document/StoredValue;", "BinaryTokenStream", "StringTokenStream", "Store", "core"})
@SourceDebugExtension(value={"SMAP\nField.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Field.kt\norg/gnit/lucenekmp/document/Field\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,531:1\n1#2:532\n*E\n"})
public class Field
implements IndexableField {
    @NotNull
    private final IndexableFieldType type;
    @NotNull
    private final String name;
    protected Object fieldsData;

    @NotNull
    protected final IndexableFieldType getType() {
        return this.type;
    }

    @NotNull
    protected final String getName() {
        return this.name;
    }

    @NotNull
    protected final Object getFieldsData() {
        Object object = this.fieldsData;
        if (object != null) {
            return object;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"fieldsData");
        return Unit.INSTANCE;
    }

    protected final void setFieldsData(@NotNull Object object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"<set-?>");
        this.fieldsData = object;
    }

    protected final boolean isFieldsDataInitialized() {
        return this.fieldsData != null;
    }

    protected Field(@NotNull String name, @NotNull IndexableFieldType type) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.name = name;
        this.type = type;
    }

    public Field(@NotNull String name, @NotNull Reader reader2, @NotNull IndexableFieldType type) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (!(!type.stored())) {
            boolean $i$a$-require-Field$72 = false;
            String $i$a$-require-Field$72 = "fields with a Reader value cannot be stored";
            throw new IllegalArgumentException($i$a$-require-Field$72.toString());
        }
        if (!(type.indexOptions() == IndexOptions.NONE || type.tokenized())) {
            boolean bl = false;
            String string = "non-tokenized fields must use String values";
            throw new IllegalArgumentException(string.toString());
        }
        this.name = name;
        this.setFieldsData(reader2);
        this.type = type;
    }

    public Field(@NotNull String name, @NotNull TokenStream tokenStream, @NotNull IndexableFieldType type) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)tokenStream, (String)"tokenStream");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (!(type.indexOptions() != IndexOptions.NONE && type.tokenized())) {
            boolean $i$a$-require-Field$102 = false;
            String $i$a$-require-Field$102 = "TokenStream fields must be indexed and tokenized";
            throw new IllegalArgumentException($i$a$-require-Field$102.toString());
        }
        if (!(!type.stored())) {
            boolean bl = false;
            String string = "TokenStream fields cannot be stored";
            throw new IllegalArgumentException(string.toString());
        }
        this.name = name;
        this.setFieldsData(tokenStream);
        this.type = type;
    }

    public Field(@NotNull String name, @NotNull byte[] value, @NotNull IndexableFieldType type) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this(name, value, 0, value.length, type);
    }

    public Field(@NotNull String name, @NotNull byte[] value, int offset, int length, @NotNull IndexableFieldType type) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this(name, new BytesRef(value, offset, length), type);
    }

    public Field(@NotNull String name, @NotNull BytesRef bytes, @NotNull IndexableFieldType type) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (!(type.indexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) < 0 && !type.storeTermVectorOffsets())) {
            boolean $i$a$-require-Field$162 = false;
            String $i$a$-require-Field$162 = "It doesn't make sense to index offsets on binary fields";
            throw new IllegalArgumentException($i$a$-require-Field$162.toString());
        }
        if (!(type.indexOptions() == IndexOptions.NONE || !type.tokenized())) {
            boolean $i$a$-require-Field$172 = false;
            String $i$a$-require-Field$172 = "cannot set a BytesRef value on a tokenized field";
            throw new IllegalArgumentException($i$a$-require-Field$172.toString());
        }
        if (!(type.indexOptions() != IndexOptions.NONE || type.pointDimensionCount() != 0 || type.docValuesType() != DocValuesType.NONE || type.stored())) {
            boolean bl = false;
            String string = "it doesn't make sense to have a field that is neither indexed, nor doc-valued, nor stored";
            throw new IllegalArgumentException(string.toString());
        }
        this.name = name;
        this.setFieldsData(bytes);
        this.type = type;
    }

    public Field(@NotNull String name, @NotNull CharSequence value, @NotNull IndexableFieldType type) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (!(type.stored() || type.indexOptions() != IndexOptions.NONE)) {
            boolean bl = false;
            String string = "it doesn't make sense to have a field that is neither indexed nor stored";
            throw new IllegalArgumentException(string.toString());
        }
        this.name = name;
        this.setFieldsData(value);
        this.type = type;
    }

    @Override
    @Nullable
    public String stringValue() {
        if (this.getFieldsData() instanceof CharSequence || this.getFieldsData() instanceof Number) {
            return this.getFieldsData().toString();
        }
        return null;
    }

    @Override
    @Nullable
    public CharSequence getCharSequenceValue() {
        CharSequence charSequence;
        if (this.getFieldsData() instanceof CharSequence) {
            Object object = this.getFieldsData();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.CharSequence");
            charSequence = (CharSequence)object;
        } else {
            charSequence = this.stringValue();
        }
        return charSequence;
    }

    @Override
    @Nullable
    public Reader readerValue() {
        Reader reader2;
        if (this.getFieldsData() instanceof Reader) {
            Object object = this.getFieldsData();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.jdkport.Reader");
            reader2 = (Reader)object;
        } else {
            reader2 = null;
        }
        return reader2;
    }

    @Nullable
    public final TokenStream tokenStreamValue() {
        TokenStream tokenStream;
        if (this.getFieldsData() instanceof TokenStream) {
            Object object = this.getFieldsData();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.analysis.TokenStream");
            tokenStream = (TokenStream)object;
        } else {
            tokenStream = null;
        }
        return tokenStream;
    }

    public void setStringValue(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!(this.getFieldsData() instanceof String)) {
            boolean bl = false;
            Object object = this.getFieldsData();
            Intrinsics.checkNotNull((Object)object);
            String string = "cannot change value type from " + Reflection.getOrCreateKotlinClass(object.getClass()).getSimpleName() + " to String";
            throw new IllegalArgumentException(string.toString());
        }
        this.setFieldsData(value);
    }

    public final void setReaderValue(@NotNull Reader value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!(this.getFieldsData() instanceof Reader)) {
            boolean bl = false;
            Object object = this.getFieldsData();
            Intrinsics.checkNotNull((Object)object);
            String string = "cannot change value type from " + Reflection.getOrCreateKotlinClass(object.getClass()).getSimpleName() + " to Reader";
            throw new IllegalArgumentException(string.toString());
        }
        this.setFieldsData(value);
    }

    public final void setBytesValue(@NotNull byte[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.setBytesValue(new BytesRef(value));
    }

    public void setBytesValue(@NotNull BytesRef value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!(this.getFieldsData() instanceof BytesRef)) {
            boolean bl = false;
            Object object = this.getFieldsData();
            Intrinsics.checkNotNull((Object)object);
            String string = "cannot change value type from " + Reflection.getOrCreateKotlinClass(object.getClass()).getSimpleName() + " to BytesRef";
            throw new IllegalArgumentException(string.toString());
        }
        this.setFieldsData(value);
    }

    public final void setByteValue(byte value) {
        if (!(this.getFieldsData() instanceof Byte)) {
            boolean bl = false;
            Object object = this.getFieldsData();
            Intrinsics.checkNotNull((Object)object);
            String string = "cannot change value type from " + Reflection.getOrCreateKotlinClass(object.getClass()).getSimpleName() + " to Byte";
            throw new IllegalArgumentException(string.toString());
        }
        this.setFieldsData(value);
    }

    public final void setShortValue(short value) {
        if (!(this.getFieldsData() instanceof Short)) {
            boolean bl = false;
            Object object = this.getFieldsData();
            Intrinsics.checkNotNull((Object)object);
            String string = "cannot change value type from " + Reflection.getOrCreateKotlinClass(object.getClass()).getSimpleName() + " to Short";
            throw new IllegalArgumentException(string.toString());
        }
        this.setFieldsData(value);
    }

    public void setIntValue(int value) {
        if (!(this.getFieldsData() instanceof Integer)) {
            boolean bl = false;
            Object object = this.getFieldsData();
            Intrinsics.checkNotNull((Object)object);
            String string = "cannot change value type from " + Reflection.getOrCreateKotlinClass(object.getClass()).getSimpleName() + " to Integer";
            throw new IllegalArgumentException(string.toString());
        }
        this.setFieldsData(value);
    }

    public void setLongValue(long value) {
        if (!(this.getFieldsData() instanceof Long)) {
            boolean bl = false;
            Object object = this.getFieldsData();
            Intrinsics.checkNotNull((Object)object);
            String string = "cannot change value type from " + Reflection.getOrCreateKotlinClass(object.getClass()).getSimpleName() + " to Long";
            throw new IllegalArgumentException(string.toString());
        }
        this.setFieldsData(value);
    }

    public void setFloatValue(float value) {
        if (!(this.getFieldsData() instanceof Float)) {
            boolean bl = false;
            Object object = this.getFieldsData();
            Intrinsics.checkNotNull((Object)object);
            String string = "cannot change value type from " + Reflection.getOrCreateKotlinClass(object.getClass()).getSimpleName() + " to Float";
            throw new IllegalArgumentException(string.toString());
        }
        this.setFieldsData(Float.valueOf(value));
    }

    public void setDoubleValue(double value) {
        if (!(this.getFieldsData() instanceof Double)) {
            boolean bl = false;
            Object object = this.getFieldsData();
            Intrinsics.checkNotNull((Object)object);
            String string = "cannot change value type from " + Reflection.getOrCreateKotlinClass(object.getClass()).getSimpleName() + " to Double";
            throw new IllegalArgumentException(string.toString());
        }
        this.setFieldsData(value);
    }

    public final void setTokenStream(@NotNull TokenStream tokenStream) {
        Intrinsics.checkNotNullParameter((Object)tokenStream, (String)"tokenStream");
        if (!(this.getFieldsData() instanceof TokenStream)) {
            boolean bl = false;
            String string = "cannot change value type from " + Reflection.getOrCreateKotlinClass(this.getFieldsData().getClass()).getSimpleName() + " to TokenStream";
            throw new IllegalArgumentException(string.toString());
        }
        this.setFieldsData(tokenStream);
    }

    @Override
    @NotNull
    public String name() {
        return this.name;
    }

    @Override
    @Nullable
    public Number numericValue() {
        if (this.getFieldsData() instanceof Number) {
            Object object = this.getFieldsData();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Number");
            return (Number)object;
        }
        return null;
    }

    @Override
    @Nullable
    public BytesRef binaryValue() {
        if (this.getFieldsData() instanceof BytesRef) {
            Object object = this.getFieldsData();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.util.BytesRef");
            return (BytesRef)object;
        }
        return null;
    }

    @NotNull
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.type.toString());
        result.append('<');
        result.append(this.name);
        result.append(':');
        if (this.getFieldsData() != null) {
            result.append(this.getFieldsData());
        }
        result.append('>');
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    @NotNull
    public IndexableFieldType fieldType() {
        return this.type;
    }

    @Override
    @NotNull
    public InvertableType invertableType() {
        return InvertableType.TOKEN_STREAM;
    }

    @Override
    @Nullable
    public TokenStream tokenStream(@NotNull Analyzer analyzer, @Nullable TokenStream reuse) {
        Intrinsics.checkNotNullParameter((Object)analyzer, (String)"analyzer");
        TokenStream reuse2 = reuse;
        if (this.fieldType().indexOptions() == IndexOptions.NONE) {
            return null;
        }
        if (!this.fieldType().tokenized()) {
            if (this.stringValue() != null) {
                if (!(reuse2 instanceof StringTokenStream)) {
                    reuse2 = new StringTokenStream();
                }
                ((StringTokenStream)reuse2).setValue(this.stringValue());
                return reuse2;
            }
            if (this.binaryValue() != null) {
                if (!(reuse2 instanceof BinaryTokenStream)) {
                    reuse2 = new BinaryTokenStream();
                }
                ((BinaryTokenStream)reuse2).setValue(this.binaryValue());
                return reuse2;
            }
            throw new IllegalArgumentException("Non-Tokenized Fields must have a String value");
        }
        if (this.tokenStreamValue() != null) {
            return this.tokenStreamValue();
        }
        if (this.readerValue() != null) {
            String string = this.name();
            Reader reader2 = this.readerValue();
            Intrinsics.checkNotNull((Object)reader2);
            return analyzer.tokenStream(string, reader2);
        }
        if (this.stringValue() != null) {
            String string = this.name();
            String string2 = this.stringValue();
            Intrinsics.checkNotNull((Object)string2);
            return analyzer.tokenStream(string, string2);
        }
        throw new IllegalArgumentException("Field must have either TokenStream, String, Reader or Number value; got " + this);
    }

    @Override
    @Nullable
    public StoredValue storedValue() {
        if (!this.fieldType().stored()) {
            return null;
        }
        if (this.getFieldsData() != null) {
            // empty if block
        }
        if (this.getFieldsData() instanceof Integer) {
            Object object = this.getFieldsData();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
            return new StoredValue((Integer)object);
        }
        if (this.getFieldsData() instanceof Long) {
            Object object = this.getFieldsData();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Long");
            return new StoredValue((Long)object);
        }
        if (this.getFieldsData() instanceof Float) {
            Object object = this.getFieldsData();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Float");
            return new StoredValue(((Float)object).floatValue());
        }
        if (this.getFieldsData() instanceof Double) {
            Object object = this.getFieldsData();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Double");
            return new StoredValue((Double)object);
        }
        if (this.getFieldsData() instanceof BytesRef) {
            Object object = this.getFieldsData();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.util.BytesRef");
            return new StoredValue((BytesRef)object);
        }
        if (this.getFieldsData() instanceof StoredFieldDataInput) {
            Object object = this.getFieldsData();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.index.StoredFieldDataInput");
            return new StoredValue((StoredFieldDataInput)object);
        }
        if (this.getFieldsData() instanceof String) {
            Object object = this.getFieldsData();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            return new StoredValue((String)object);
        }
        throw new IllegalStateException("Cannot store value of type " + Reflection.getOrCreateKotlinClass(this.getFieldsData().getClass()));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000e\u001a\u00020\u0007H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\b\u001a\u0004\u0018\u00010\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lorg/gnit/lucenekmp/document/Field$BinaryTokenStream;", "Lorg/gnit/lucenekmp/analysis/TokenStream;", "<init>", "()V", "bytesAtt", "Lorg/gnit/lucenekmp/analysis/tokenattributes/BytesTermAttribute;", "used", "", "value", "Lorg/gnit/lucenekmp/util/BytesRef;", "getValue", "()Lorg/gnit/lucenekmp/util/BytesRef;", "setValue", "(Lorg/gnit/lucenekmp/util/BytesRef;)V", "incrementToken", "reset", "", "close", "core"})
    private static final class BinaryTokenStream
    extends TokenStream {
        @NotNull
        private final BytesTermAttribute bytesAtt = (BytesTermAttribute)this.addAttribute(Reflection.getOrCreateKotlinClass(BytesTermAttribute.class));
        private boolean used = true;

        @Nullable
        public final BytesRef getValue() {
            return this.getValue();
        }

        public final void setValue(@Nullable BytesRef value) {
            this.setValue(value);
        }

        @Override
        public boolean incrementToken() {
            if (this.used) {
                return false;
            }
            this.clearAttributes();
            this.bytesAtt.setBytesRef(this.getValue());
            this.used = true;
            return true;
        }

        @Override
        public void reset() {
            this.used = false;
        }

        @Override
        public void close() {
            this.setValue(null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/gnit/lucenekmp/document/Field$Store;", "", "<init>", "(Ljava/lang/String;I)V", "YES", "NO", "core"})
    public static final class Store
    extends Enum<Store> {
        public static final /* enum */ Store YES = new Store();
        public static final /* enum */ Store NO = new Store();
        private static final /* synthetic */ Store[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Store[] values() {
            return (Store[])$VALUES.clone();
        }

        public static Store valueOf(String value) {
            return Enum.valueOf(Store.class, value);
        }

        @NotNull
        public static EnumEntries<Store> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = storeArray = new Store[]{Store.YES, Store.NO};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\b\u0010\u000e\u001a\u00020\tH\u0016J\b\u0010\u000f\u001a\u00020\rH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0016J\b\u0010\u0011\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/gnit/lucenekmp/document/Field$StringTokenStream;", "Lorg/gnit/lucenekmp/analysis/TokenStream;", "<init>", "()V", "termAttribute", "Lorg/gnit/lucenekmp/analysis/tokenattributes/CharTermAttribute;", "offsetAttribute", "Lorg/gnit/lucenekmp/analysis/tokenattributes/OffsetAttribute;", "used", "", "value", "", "setValue", "", "incrementToken", "end", "reset", "close", "core"})
    private static final class StringTokenStream
    extends TokenStream {
        @NotNull
        private final CharTermAttribute termAttribute = (CharTermAttribute)this.addAttribute(Reflection.getOrCreateKotlinClass(CharTermAttribute.class));
        @NotNull
        private final OffsetAttribute offsetAttribute = (OffsetAttribute)this.addAttribute(Reflection.getOrCreateKotlinClass(OffsetAttribute.class));
        private boolean used = true;
        @Nullable
        private String value;

        public final void setValue(@Nullable String value) {
            this.value = value;
        }

        @Override
        public boolean incrementToken() {
            if (this.used) {
                return false;
            }
            this.clearAttributes();
            this.termAttribute.append((CharSequence)this.value);
            String string = this.value;
            Intrinsics.checkNotNull((Object)string);
            this.offsetAttribute.setOffset(0, string.length());
            this.used = true;
            return true;
        }

        @Override
        public void end() throws IOException {
            super.end();
            String string = this.value;
            Intrinsics.checkNotNull((Object)string);
            int finalOffset = string.length();
            this.offsetAttribute.setOffset(finalOffset, finalOffset);
        }

        @Override
        public void reset() {
            this.used = false;
        }

        @Override
        public void close() {
            this.value = null;
        }
    }
}

