/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.document;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.index.DocValuesSkipIndexType;
import org.gnit.lucenekmp.index.DocValuesType;
import org.gnit.lucenekmp.index.IndexOptions;
import org.gnit.lucenekmp.index.IndexableFieldType;
import org.gnit.lucenekmp.index.PointValues;
import org.gnit.lucenekmp.index.VectorEncoding;
import org.gnit.lucenekmp.index.VectorSimilarityFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u001b\n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004B\t\b\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0005J\b\u0010$\u001a\u00020%H\u0004J\u0006\u0010&\u001a\u00020%J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u000e\u0010'\u001a\u00020%2\u0006\u0010\u001e\u001a\u00020\u0007J\b\u0010\b\u001a\u00020\u0007H\u0016J\u000e\u0010(\u001a\u00020%2\u0006\u0010\u001e\u001a\u00020\u0007J\b\u0010\t\u001a\u00020\u0007H\u0016J\u000e\u0010)\u001a\u00020%2\u0006\u0010\u001e\u001a\u00020\u0007J\b\u0010\n\u001a\u00020\u0007H\u0016J\u000e\u0010*\u001a\u00020%2\u0006\u0010\u001e\u001a\u00020\u0007J\b\u0010\u000b\u001a\u00020\u0007H\u0016J\u000e\u0010+\u001a\u00020%2\u0006\u0010\u001e\u001a\u00020\u0007J\b\u0010\f\u001a\u00020\u0007H\u0016J\u000e\u0010,\u001a\u00020%2\u0006\u0010\u001e\u001a\u00020\u0007J\b\u0010\r\u001a\u00020\u0007H\u0016J\u000e\u0010-\u001a\u00020%2\u0006\u0010\u001e\u001a\u00020\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u000e\u0010.\u001a\u00020%2\u0006\u0010\u001e\u001a\u00020\u000fJ\u0016\u0010/\u001a\u00020%2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0016J\u001e\u0010/\u001a\u00020%2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0016J\b\u00100\u001a\u00020\u0016H\u0016J\b\u00101\u001a\u00020\u0016H\u0016J\b\u00102\u001a\u00020\u0016H\u0016J\"\u00103\u001a\u00020%2\u0006\u00104\u001a\u00020\u00162\b\u00105\u001a\u0004\u0018\u00010\u001b2\b\u00106\u001a\u0004\u0018\u00010\u001dJ\b\u0010\u0019\u001a\u00020\u0016H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u00107\u001a\u0004\u0018\u00010 2\u0006\u00108\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020 J\b\u00109\u001a\u00020 H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010:\u001a\u00020%2\u0006\u0010;\u001a\u00020\u0012J\b\u0010<\u001a\u00020\u0014H\u0016J\u000e\u0010=\u001a\u00020%2\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010>\u001a\u00020\u0016H\u0016J\u0013\u0010?\u001a\u00020\u00072\b\u0010@\u001a\u0004\u0018\u00010AH\u0096\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R:\u0010!\u001a\u0010\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020 \u0018\u00010\u001f2\u0014\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020 \u0018\u00010\u001f@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u0006B"}, d2={"Lorg/gnit/lucenekmp/document/FieldType;", "Lorg/gnit/lucenekmp/index/IndexableFieldType;", "ref", "<init>", "(Lorg/gnit/lucenekmp/index/IndexableFieldType;)V", "()V", "stored", "", "tokenized", "storeTermVectors", "storeTermVectorOffsets", "storeTermVectorPositions", "storeTermVectorPayloads", "omitNorms", "indexOptions", "Lorg/gnit/lucenekmp/index/IndexOptions;", "frozen", "docValuesType", "Lorg/gnit/lucenekmp/index/DocValuesType;", "docValuesSkipIndex", "Lorg/gnit/lucenekmp/index/DocValuesSkipIndexType;", "dimensionCount", "", "indexDimensionCount", "dimensionNumBytes", "vectorDimension", "vectorEncoding", "Lorg/gnit/lucenekmp/index/VectorEncoding;", "vectorSimilarityFunction", "Lorg/gnit/lucenekmp/index/VectorSimilarityFunction;", "value", "", "", "attributes", "getAttributes", "()Ljava/util/Map;", "checkIfFrozen", "", "freeze", "setStored", "setTokenized", "setStoreTermVectors", "setStoreTermVectorOffsets", "setStoreTermVectorPositions", "setStoreTermVectorPayloads", "setOmitNorms", "setIndexOptions", "setDimensions", "pointDimensionCount", "pointIndexDimensionCount", "pointNumBytes", "setVectorAttributes", "numDimensions", "encoding", "similarity", "putAttribute", "key", "toString", "setDocValuesType", "type", "docValuesSkipIndexType", "setDocValuesSkipIndexType", "hashCode", "equals", "obj", "", "core"})
@SourceDebugExtension(value={"SMAP\nFieldType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FieldType.kt\norg/gnit/lucenekmp/document/FieldType\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,510:1\n1#2:511\n*E\n"})
public final class FieldType
implements IndexableFieldType {
    private boolean stored;
    private boolean tokenized;
    private boolean storeTermVectors;
    private boolean storeTermVectorOffsets;
    private boolean storeTermVectorPositions;
    private boolean storeTermVectorPayloads;
    private boolean omitNorms;
    @NotNull
    private IndexOptions indexOptions;
    private boolean frozen;
    @NotNull
    private DocValuesType docValuesType;
    @NotNull
    private DocValuesSkipIndexType docValuesSkipIndex;
    private int dimensionCount;
    private int indexDimensionCount;
    private int dimensionNumBytes;
    private int vectorDimension;
    @NotNull
    private VectorEncoding vectorEncoding;
    @NotNull
    private VectorSimilarityFunction vectorSimilarityFunction;
    @Nullable
    private Map<String, String> attributes;

    @Override
    @Nullable
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public FieldType(@NotNull IndexableFieldType ref) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        this.tokenized = true;
        this.indexOptions = IndexOptions.NONE;
        this.docValuesType = DocValuesType.NONE;
        this.docValuesSkipIndex = DocValuesSkipIndexType.NONE;
        this.vectorEncoding = VectorEncoding.FLOAT32;
        this.vectorSimilarityFunction = VectorSimilarityFunction.EUCLIDEAN;
        this.stored = ref.stored();
        this.tokenized = ref.tokenized();
        this.storeTermVectors = ref.storeTermVectors();
        this.storeTermVectorOffsets = ref.storeTermVectorOffsets();
        this.storeTermVectorPositions = ref.storeTermVectorPositions();
        this.storeTermVectorPayloads = ref.storeTermVectorPayloads();
        this.omitNorms = ref.omitNorms();
        this.indexOptions = ref.indexOptions();
        this.docValuesType = ref.docValuesType();
        this.docValuesSkipIndex = ref.docValuesSkipIndexType();
        this.dimensionCount = ref.pointDimensionCount();
        this.indexDimensionCount = ref.pointIndexDimensionCount();
        this.dimensionNumBytes = ref.pointNumBytes();
        this.vectorDimension = ref.vectorDimension();
        this.vectorEncoding = ref.vectorEncoding();
        this.vectorSimilarityFunction = ref.vectorSimilarityFunction();
        if (ref.getAttributes() != null) {
            this.attributes = ref.getAttributes();
        }
    }

    public FieldType() {
        this.tokenized = true;
        this.indexOptions = IndexOptions.NONE;
        this.docValuesType = DocValuesType.NONE;
        this.docValuesSkipIndex = DocValuesSkipIndexType.NONE;
        this.vectorEncoding = VectorEncoding.FLOAT32;
        this.vectorSimilarityFunction = VectorSimilarityFunction.EUCLIDEAN;
    }

    protected final void checkIfFrozen() {
        if (!(!this.frozen)) {
            boolean bl = false;
            String string = "this FieldType is already frozen and cannot be changed";
            throw new IllegalStateException(string.toString());
        }
    }

    public final void freeze() {
        this.frozen = true;
    }

    @Override
    public boolean stored() {
        return this.stored;
    }

    public final void setStored(boolean value) {
        this.checkIfFrozen();
        this.stored = value;
    }

    @Override
    public boolean tokenized() {
        return this.tokenized;
    }

    public final void setTokenized(boolean value) {
        this.checkIfFrozen();
        this.tokenized = value;
    }

    @Override
    public boolean storeTermVectors() {
        return this.storeTermVectors;
    }

    public final void setStoreTermVectors(boolean value) {
        this.checkIfFrozen();
        this.storeTermVectors = value;
    }

    @Override
    public boolean storeTermVectorOffsets() {
        return this.storeTermVectorOffsets;
    }

    public final void setStoreTermVectorOffsets(boolean value) {
        this.checkIfFrozen();
        this.storeTermVectorOffsets = value;
    }

    @Override
    public boolean storeTermVectorPositions() {
        return this.storeTermVectorPositions;
    }

    public final void setStoreTermVectorPositions(boolean value) {
        this.checkIfFrozen();
        this.storeTermVectorPositions = value;
    }

    @Override
    public boolean storeTermVectorPayloads() {
        return this.storeTermVectorPayloads;
    }

    public final void setStoreTermVectorPayloads(boolean value) {
        this.checkIfFrozen();
        this.storeTermVectorPayloads = value;
    }

    @Override
    public boolean omitNorms() {
        return this.omitNorms;
    }

    public final void setOmitNorms(boolean value) {
        this.checkIfFrozen();
        this.omitNorms = value;
    }

    @Override
    @NotNull
    public IndexOptions indexOptions() {
        return this.indexOptions;
    }

    public final void setIndexOptions(@NotNull IndexOptions value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.checkIfFrozen();
        this.indexOptions = value;
    }

    public final void setDimensions(int dimensionCount, int dimensionNumBytes) {
        this.setDimensions(dimensionCount, dimensionCount, dimensionNumBytes);
    }

    public final void setDimensions(int dimensionCount, int indexDimensionCount, int dimensionNumBytes) {
        this.checkIfFrozen();
        if (!(dimensionCount >= 0)) {
            boolean $i$a$-require-FieldType$setDimensions$122 = false;
            String $i$a$-require-FieldType$setDimensions$122 = "dimensionCount must be >= 0; got " + dimensionCount;
            throw new IllegalArgumentException($i$a$-require-FieldType$setDimensions$122.toString());
        }
        if (!(dimensionCount <= PointValues.Companion.getMAX_DIMENSIONS())) {
            boolean $i$a$-require-FieldType$setDimensions$132 = false;
            String $i$a$-require-FieldType$setDimensions$132 = "dimensionCount must be <= " + PointValues.Companion.getMAX_DIMENSIONS() + "; got " + dimensionCount;
            throw new IllegalArgumentException($i$a$-require-FieldType$setDimensions$132.toString());
        }
        if (!(indexDimensionCount >= 0)) {
            boolean $i$a$-require-FieldType$setDimensions$142 = false;
            String $i$a$-require-FieldType$setDimensions$142 = "indexDimensionCount must be >= 0; got " + indexDimensionCount;
            throw new IllegalArgumentException($i$a$-require-FieldType$setDimensions$142.toString());
        }
        if (!(indexDimensionCount <= dimensionCount)) {
            boolean $i$a$-require-FieldType$setDimensions$152 = false;
            String $i$a$-require-FieldType$setDimensions$152 = "indexDimensionCount must be <= dimensionCount: " + dimensionCount + "; got " + indexDimensionCount;
            throw new IllegalArgumentException($i$a$-require-FieldType$setDimensions$152.toString());
        }
        if (!(indexDimensionCount <= PointValues.Companion.getMAX_INDEX_DIMENSIONS())) {
            boolean $i$a$-require-FieldType$setDimensions$162 = false;
            String $i$a$-require-FieldType$setDimensions$162 = "indexDimensionCount must be <= " + PointValues.Companion.getMAX_INDEX_DIMENSIONS() + "; got " + indexDimensionCount;
            throw new IllegalArgumentException($i$a$-require-FieldType$setDimensions$162.toString());
        }
        if (!(dimensionNumBytes >= 0)) {
            boolean $i$a$-require-FieldType$setDimensions$172 = false;
            String $i$a$-require-FieldType$setDimensions$172 = "dimensionNumBytes must be >= 0; got " + dimensionNumBytes;
            throw new IllegalArgumentException($i$a$-require-FieldType$setDimensions$172.toString());
        }
        if (!(dimensionNumBytes <= 16)) {
            boolean $i$a$-require-FieldType$setDimensions$182 = false;
            String $i$a$-require-FieldType$setDimensions$182 = "dimensionNumBytes must be <= 16; got " + dimensionNumBytes;
            throw new IllegalArgumentException($i$a$-require-FieldType$setDimensions$182.toString());
        }
        if (dimensionCount == 0) {
            if (!(indexDimensionCount == 0)) {
                boolean $i$a$-require-FieldType$setDimensions$192 = false;
                String $i$a$-require-FieldType$setDimensions$192 = "when dimensionCount is 0, indexDimensionCount must be 0; got " + indexDimensionCount;
                throw new IllegalArgumentException($i$a$-require-FieldType$setDimensions$192.toString());
            }
            if (!(dimensionNumBytes == 0)) {
                boolean $i$a$-require-FieldType$setDimensions$202 = false;
                String $i$a$-require-FieldType$setDimensions$202 = "when dimensionCount is 0, dimensionNumBytes must be 0; got " + dimensionNumBytes;
                throw new IllegalArgumentException($i$a$-require-FieldType$setDimensions$202.toString());
            }
        } else if (!(indexDimensionCount != 0)) {
            boolean $i$a$-require-FieldType$setDimensions$212 = false;
            String $i$a$-require-FieldType$setDimensions$212 = "when dimensionCount is > 0, indexDimensionCount must be > 0; got " + indexDimensionCount;
            throw new IllegalArgumentException($i$a$-require-FieldType$setDimensions$212.toString());
        }
        if (!(dimensionNumBytes != 0)) {
            boolean bl = false;
            String string = "when dimensionNumBytes is 0, dimensionCount must be 0; got " + dimensionCount;
            throw new IllegalArgumentException(string.toString());
        }
        this.dimensionCount = dimensionCount;
        this.indexDimensionCount = indexDimensionCount;
        this.dimensionNumBytes = dimensionNumBytes;
    }

    @Override
    public int pointDimensionCount() {
        return this.dimensionCount;
    }

    @Override
    public int pointIndexDimensionCount() {
        return this.indexDimensionCount;
    }

    @Override
    public int pointNumBytes() {
        return this.dimensionNumBytes;
    }

    public final void setVectorAttributes(int numDimensions, @Nullable VectorEncoding encoding, @Nullable VectorSimilarityFunction similarity) {
        this.checkIfFrozen();
        if (!(numDimensions > 0)) {
            boolean bl = false;
            String string = "vector numDimensions must be > 0; got " + numDimensions;
            throw new IllegalArgumentException(string.toString());
        }
        this.vectorDimension = numDimensions;
        VectorSimilarityFunction vectorSimilarityFunction = similarity;
        if (vectorSimilarityFunction == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        this.vectorSimilarityFunction = vectorSimilarityFunction;
        VectorEncoding vectorEncoding = encoding;
        if (vectorEncoding == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        this.vectorEncoding = vectorEncoding;
    }

    @Override
    public int vectorDimension() {
        return this.vectorDimension;
    }

    @Override
    @NotNull
    public VectorEncoding vectorEncoding() {
        return this.vectorEncoding;
    }

    @Override
    @NotNull
    public VectorSimilarityFunction vectorSimilarityFunction() {
        return this.vectorSimilarityFunction;
    }

    @Nullable
    public final String putAttribute(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.checkIfFrozen();
        if (this.getAttributes() == null) {
            this.attributes = new LinkedHashMap();
        }
        Map<String, String> map2 = this.getAttributes();
        Intrinsics.checkNotNull(map2);
        return map2.put(key, value);
    }

    @NotNull
    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.stored()) {
            result.append("stored");
        }
        if (this.indexOptions != IndexOptions.NONE) {
            if (((CharSequence)result).length() > 0) {
                result.append(",");
            }
            result.append("indexed");
            if (this.tokenized()) {
                result.append(",tokenized");
            }
            if (this.storeTermVectors()) {
                result.append(",termVector");
            }
            if (this.storeTermVectorOffsets()) {
                result.append(",termVectorOffsets");
            }
            if (this.storeTermVectorPositions()) {
                result.append(",termVectorPosition");
            }
            if (this.storeTermVectorPayloads()) {
                result.append(",termVectorPayloads");
            }
            if (this.omitNorms()) {
                result.append(",omitNorms");
            }
            if (this.indexOptions != IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) {
                result.append(",indexOptions=");
                result.append((Object)this.indexOptions);
            }
        }
        if (this.dimensionCount != 0) {
            if (((CharSequence)result).length() > 0) {
                result.append(",");
            }
            result.append("pointDimensionCount=");
            result.append(this.dimensionCount);
            result.append(",pointIndexDimensionCount=");
            result.append(this.indexDimensionCount);
            result.append(",pointNumBytes=");
            result.append(this.dimensionNumBytes);
        }
        if (this.docValuesType != DocValuesType.NONE) {
            if (((CharSequence)result).length() > 0) {
                result.append(",");
            }
            result.append("docValuesType=");
            result.append((Object)this.docValuesType);
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    @NotNull
    public DocValuesType docValuesType() {
        return this.docValuesType;
    }

    public final void setDocValuesType(@NotNull DocValuesType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.checkIfFrozen();
        this.docValuesType = type;
    }

    @Override
    @NotNull
    public DocValuesSkipIndexType docValuesSkipIndexType() {
        return this.docValuesSkipIndex;
    }

    public final void setDocValuesSkipIndexType(@NotNull DocValuesSkipIndexType docValuesSkipIndex) {
        Intrinsics.checkNotNullParameter((Object)((Object)docValuesSkipIndex), (String)"docValuesSkipIndex");
        this.checkIfFrozen();
        this.docValuesSkipIndex = docValuesSkipIndex;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + this.dimensionCount;
        result = prime * result + this.indexDimensionCount;
        result = prime * result + this.dimensionNumBytes;
        result = prime * result + this.docValuesType.hashCode();
        result = prime * result + this.docValuesSkipIndex.hashCode();
        result = prime * result + this.indexOptions.hashCode();
        result = prime * result + (this.omitNorms ? 1231 : 1237);
        result = prime * result + (this.storeTermVectorOffsets ? 1231 : 1237);
        result = prime * result + (this.storeTermVectorPayloads ? 1231 : 1237);
        result = prime * result + (this.storeTermVectorPositions ? 1231 : 1237);
        result = prime * result + (this.storeTermVectors ? 1231 : 1237);
        result = prime * result + (this.stored ? 1231 : 1237);
        result = prime * result + (this.tokenized ? 1231 : 1237);
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FieldType other = (FieldType)obj;
        if (this.dimensionCount != other.dimensionCount) {
            return false;
        }
        if (this.indexDimensionCount != other.indexDimensionCount) {
            return false;
        }
        if (this.dimensionNumBytes != other.dimensionNumBytes) {
            return false;
        }
        if (this.docValuesType != other.docValuesType) {
            return false;
        }
        if (this.docValuesSkipIndex != other.docValuesSkipIndex) {
            return false;
        }
        if (this.indexOptions != other.indexOptions) {
            return false;
        }
        if (this.omitNorms != other.omitNorms) {
            return false;
        }
        if (this.storeTermVectorOffsets != other.storeTermVectorOffsets) {
            return false;
        }
        if (this.storeTermVectorPayloads != other.storeTermVectorPayloads) {
            return false;
        }
        if (this.storeTermVectorPositions != other.storeTermVectorPositions) {
            return false;
        }
        if (this.storeTermVectors != other.storeTermVectors) {
            return false;
        }
        if (this.stored != other.stored) {
            return false;
        }
        return this.tokenized == other.tokenized;
    }
}

