/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.document;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.document.Field;
import org.gnit.lucenekmp.document.FieldType;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.jdkport.InetAddress;
import org.gnit.lucenekmp.jdkport.System;
import org.gnit.lucenekmp.jdkport.UnknownHostException;
import org.gnit.lucenekmp.search.PointInSetQuery;
import org.gnit.lucenekmp.search.PointRangeQuery;
import org.gnit.lucenekmp.search.Query;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.NumericUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0016\u00a8\u0006\u0010"}, d2={"Lorg/gnit/lucenekmp/document/InetAddressPoint;", "Lorg/gnit/lucenekmp/document/Field;", "name", "", "point", "Lorg/gnit/lucenekmp/jdkport/InetAddress;", "<init>", "(Ljava/lang/String;Lorg/gnit/lucenekmp/jdkport/InetAddress;)V", "setInetAddressValue", "", "value", "setBytesValue", "bytes", "Lorg/gnit/lucenekmp/util/BytesRef;", "toString", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nInetAddressPoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InetAddressPoint.kt\norg/gnit/lucenekmp/document/InetAddressPoint\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,298:1\n1#2:299\n*E\n"})
public final class InetAddressPoint
extends Field {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int BYTES = 16;
    @NotNull
    private static final byte[] IPV4_PREFIX;
    @NotNull
    private static final FieldType TYPE;
    @NotNull
    private static final InetAddress MIN_VALUE;
    @NotNull
    private static final InetAddress MAX_VALUE;

    public InetAddressPoint(@NotNull String name, @NotNull InetAddress point) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        super(name, TYPE);
        this.setInetAddressValue(point);
    }

    public final void setInetAddressValue(@NotNull InetAddress value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.setFieldsData(new BytesRef(Companion.encode(value)));
    }

    @Override
    public void setBytesValue(@NotNull BytesRef bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        throw new IllegalArgumentException("cannot change value type from InetAddress to BytesRef");
    }

    @Override
    @NotNull
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName());
        result.append(" <");
        result.append(this.getName());
        result.append(':');
        Object object = this.getFieldsData();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.util.BytesRef");
        BytesRef bytes = (BytesRef)object;
        InetAddress address = Companion.decode(BytesRef.Companion.deepCopyOf(bytes).getBytes());
        if (address.getAddress().length == 16) {
            result.append('[');
            result.append(address.getHostAddress());
            v1 = result.append(']');
        } else {
            v1 = result.append(address.getHostAddress());
        }
        result.append('>');
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    static {
        Object object = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1};
        IPV4_PREFIX = object;
        byte[] $this$TYPE_u24lambda_u241 = object = (Object)new FieldType();
        boolean bl = false;
        $this$TYPE_u24lambda_u241.setDimensions(1, 16);
        $this$TYPE_u24lambda_u241.freeze();
        TYPE = object;
        MIN_VALUE = Companion.decode(new byte[16]);
        int n = 0;
        byte[] byArray = new byte[16];
        Companion companion = Companion;
        while (n < 16) {
            int n2 = n++;
            byArray[n2] = -1;
        }
        MAX_VALUE = companion.decode(byArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\rJ\u000e\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\rJ\u000e\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\rJ\u000e\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0007J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\rJ\u001e\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u0005J\u001e\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\rJ'\u0010!\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0#\"\u00020\r\u00a2\u0006\u0002\u0010$R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006%"}, d2={"Lorg/gnit/lucenekmp/document/InetAddressPoint$Companion;", "", "<init>", "()V", "BYTES", "", "IPV4_PREFIX", "", "getIPV4_PREFIX", "()[B", "TYPE", "Lorg/gnit/lucenekmp/document/FieldType;", "MIN_VALUE", "Lorg/gnit/lucenekmp/jdkport/InetAddress;", "getMIN_VALUE", "()Lorg/gnit/lucenekmp/jdkport/InetAddress;", "MAX_VALUE", "getMAX_VALUE", "nextUp", "address", "nextDown", "encode", "value", "decode", "newExactQuery", "Lorg/gnit/lucenekmp/search/Query;", "field", "", "newPrefixQuery", "prefixLength", "newRangeQuery", "lowerValue", "upperValue", "newSetQuery", "values", "", "(Ljava/lang/String;[Lorg/gnit/lucenekmp/jdkport/InetAddress;)Lorg/gnit/lucenekmp/search/Query;", "core"})
    @SourceDebugExtension(value={"SMAP\nInetAddressPoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InetAddressPoint.kt\norg/gnit/lucenekmp/document/InetAddressPoint$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,298:1\n1#2:299\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final byte[] getIPV4_PREFIX() {
            return IPV4_PREFIX;
        }

        @NotNull
        public final InetAddress getMIN_VALUE() {
            return MIN_VALUE;
        }

        @NotNull
        public final InetAddress getMAX_VALUE() {
            return MAX_VALUE;
        }

        @NotNull
        public final InetAddress nextUp(@NotNull InetAddress address) {
            Intrinsics.checkNotNullParameter((Object)address, (String)"address");
            if (Intrinsics.areEqual((Object)address, (Object)this.getMAX_VALUE())) {
                throw new ArithmeticException("Overflow: there is no greater InetAddress than " + address.getHostAddress());
            }
            byte[] delta = new byte[16];
            delta[15] = 1;
            byte[] nextUpBytes = new byte[16];
            NumericUtils.INSTANCE.add(16, 0, this.encode(address), delta, nextUpBytes);
            return this.decode(nextUpBytes);
        }

        @NotNull
        public final InetAddress nextDown(@NotNull InetAddress address) {
            Intrinsics.checkNotNullParameter((Object)address, (String)"address");
            if (Intrinsics.areEqual((Object)address, (Object)this.getMIN_VALUE())) {
                throw new ArithmeticException("Underflow: there is no smaller InetAddress than " + address.getHostAddress());
            }
            byte[] delta = new byte[16];
            delta[15] = 1;
            byte[] nextDownBytes = new byte[16];
            NumericUtils.INSTANCE.subtract(16, 0, this.encode(address), delta, nextDownBytes);
            return this.decode(nextDownBytes);
        }

        @NotNull
        public final byte[] encode(@NotNull InetAddress value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            byte[] address = value.getAddress();
            if (address.length == 4) {
                byte[] mapped = new byte[16];
                System.INSTANCE.arraycopy(this.getIPV4_PREFIX(), 0, mapped, 0, this.getIPV4_PREFIX().length);
                System.INSTANCE.arraycopy(address, 0, mapped, this.getIPV4_PREFIX().length, address.length);
                address = mapped;
            } else if (address.length != 16) {
                throw new UnsupportedOperationException("Only IPv4 and IPv6 addresses are supported");
            }
            return address;
        }

        @NotNull
        public final InetAddress decode(@NotNull byte[] value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            try {
                return InetAddress.Companion.getByAddress(value);
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException("encoded bytes are of incorrect length", e);
            }
        }

        @NotNull
        public final Query newExactQuery(@NotNull String field, @NotNull InetAddress value) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return this.newRangeQuery(field, value, value);
        }

        @NotNull
        public final Query newPrefixQuery(@NotNull String field, @NotNull InetAddress value, int prefixLength) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (!(prefixLength >= 0 && prefixLength <= 8 * value.getAddress().length)) {
                boolean $i$a$-require-InetAddressPoint$Companion$newPrefixQuery$32 = false;
                String $i$a$-require-InetAddressPoint$Companion$newPrefixQuery$32 = "illegal prefixLength '" + prefixLength + "'. Must be 0-32 for IPv4 ranges, 0-128 for IPv6 ranges";
                throw new IllegalArgumentException($i$a$-require-InetAddressPoint$Companion$newPrefixQuery$32.toString());
            }
            byte[] lower = value.getAddress();
            byte[] upper = value.getAddress();
            int n = 8 * lower.length;
            for (int i = prefixLength; i < n; ++i) {
                byte m = (byte)(1 << 7 - (i & 7));
                byte by = lower[i >> 3];
                byte by2 = ~m;
                lower[i >> 3] = (byte)(by & by2);
                upper[i >> 3] = (byte)(upper[i >> 3] | m);
            }
            try {
                return this.newRangeQuery(field, InetAddress.Companion.getByAddress(lower), InetAddress.Companion.getByAddress(upper));
            }
            catch (UnknownHostException e) {
                throw new AssertionError((Object)e);
            }
        }

        @NotNull
        public final Query newRangeQuery(@NotNull String field, @NotNull InetAddress lowerValue, @NotNull InetAddress upperValue) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)lowerValue, (String)"lowerValue");
            Intrinsics.checkNotNullParameter((Object)upperValue, (String)"upperValue");
            PointRangeQuery.Companion.checkArgs(field, lowerValue, upperValue);
            byte[] byArray = Companion.encode(lowerValue);
            byte[] byArray2 = Companion.encode(upperValue);
            return new PointRangeQuery(field, byArray, byArray2){

                protected String toString(int dimension, byte[] value) {
                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                    return InetAddressPoint.Companion.decode(value).getHostAddress();
                }
            };
        }

        @NotNull
        public final Query newSetQuery(@NotNull String field, InetAddress ... values2) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
            int n = 0;
            int n2 = values2.length;
            byte[][] byArrayArray = new byte[n2][];
            while (n < n2) {
                int n3 = n++;
                byArrayArray[n3] = Companion.encode(values2[n3]);
            }
            byte[][] sortedValues = byArrayArray;
            Arrays.INSTANCE.sort((Object[])sortedValues, Companion::newSetQuery$lambda$2);
            BytesRef encoded = new BytesRef(new byte[16]);
            PointInSetQuery.Stream stream = new PointInSetQuery.Stream(sortedValues, encoded){
                private int upto;
                final /* synthetic */ byte[][] $sortedValues;
                final /* synthetic */ BytesRef $encoded;
                {
                    this.$sortedValues = $sortedValues;
                    this.$encoded = $encoded;
                }

                public final int getUpto() {
                    return this.upto;
                }

                public final void setUpto(int n) {
                    this.upto = n;
                }

                public BytesRef next() {
                    if (this.upto == ((Object[])this.$sortedValues).length) {
                        return null;
                    }
                    this.$encoded.setBytes(this.$sortedValues[this.upto]);
                    if (!(this.$encoded.getBytes().length == this.$encoded.getLength())) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    int n = this.upto;
                    this.upto = n + 1;
                    return this.$encoded;
                }
            };
            return new PointInSetQuery(field, stream){

                protected String toString(byte[] value) {
                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                    if (!(value.length == 16)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    return InetAddressPoint.Companion.decode(value).getHostAddress();
                }
            };
        }

        private static final int newSetQuery$lambda$2(byte[] a, byte[] b) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return Arrays.INSTANCE.compareUnsigned(a, 0, 16, b, 0, 16);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

