/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.document;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.document.Field;
import org.gnit.lucenekmp.document.FieldType;
import org.gnit.lucenekmp.index.VectorEncoding;
import org.gnit.lucenekmp.index.VectorSimilarityFunction;
import org.gnit.lucenekmp.search.KnnByteVectorQuery;
import org.gnit.lucenekmp.search.Query;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B#\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\b\u0010\fJ\u0006\u0010\r\u001a\u00020\u0005J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005\u00a8\u0006\u0012"}, d2={"Lorg/gnit/lucenekmp/document/KnnByteVectorField;", "Lorg/gnit/lucenekmp/document/Field;", "name", "", "vector", "", "similarityFunction", "Lorg/gnit/lucenekmp/index/VectorSimilarityFunction;", "<init>", "(Ljava/lang/String;[BLorg/gnit/lucenekmp/index/VectorSimilarityFunction;)V", "fieldType", "Lorg/gnit/lucenekmp/document/FieldType;", "(Ljava/lang/String;[BLorg/gnit/lucenekmp/document/FieldType;)V", "vectorValue", "setVectorValue", "", "value", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nKnnByteVectorField.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KnnByteVectorField.kt\norg/gnit/lucenekmp/document/KnnByteVectorField\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n1#2:137\n*E\n"})
public final class KnnByteVectorField
extends Field {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmOverloads
    public KnnByteVectorField(@NotNull String name, @NotNull byte[] vector, @NotNull VectorSimilarityFunction similarityFunction) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
        Intrinsics.checkNotNullParameter((Object)((Object)similarityFunction), (String)"similarityFunction");
        super(name, KnnByteVectorField.Companion.createType(vector, similarityFunction));
        this.setFieldsData(vector);
    }

    public /* synthetic */ KnnByteVectorField(String string, byte[] byArray, VectorSimilarityFunction vectorSimilarityFunction, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            vectorSimilarityFunction = VectorSimilarityFunction.EUCLIDEAN;
        }
        this(string, byArray, vectorSimilarityFunction);
    }

    public KnnByteVectorField(@NotNull String name, @NotNull byte[] vector, @NotNull FieldType fieldType) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
        Intrinsics.checkNotNullParameter((Object)fieldType, (String)"fieldType");
        super(name, fieldType);
        if (!(fieldType.vectorEncoding() == VectorEncoding.BYTE)) {
            boolean $i$a$-require-KnnByteVectorField$32 = false;
            String $i$a$-require-KnnByteVectorField$32 = "Attempt to create a vector for field " + name + " using byte[] but the field encoding is " + fieldType.vectorEncoding();
            throw new IllegalArgumentException($i$a$-require-KnnByteVectorField$32.toString());
        }
        if (!(vector.length == fieldType.vectorDimension())) {
            boolean bl = false;
            String string = "The number of vector dimensions does not match the field type";
            throw new IllegalArgumentException(string.toString());
        }
        this.setFieldsData(vector);
    }

    @NotNull
    public final byte[] vectorValue() {
        Object object = this.getFieldsData();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.ByteArray");
        return (byte[])object;
    }

    public final void setVectorValue(@NotNull byte[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!(value.length == this.getType().vectorDimension())) {
            boolean bl = false;
            String string = "value length " + value.length + " must match field dimension " + this.getType().vectorDimension();
            throw new IllegalArgumentException(string.toString());
        }
        this.setFieldsData(value);
    }

    @JvmOverloads
    public KnnByteVectorField(@NotNull String name, @NotNull byte[] vector) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
        this(name, vector, null, 4, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u0013"}, d2={"Lorg/gnit/lucenekmp/document/KnnByteVectorField$Companion;", "", "<init>", "()V", "createType", "Lorg/gnit/lucenekmp/document/FieldType;", "v", "", "similarityFunction", "Lorg/gnit/lucenekmp/index/VectorSimilarityFunction;", "newVectorQuery", "Lorg/gnit/lucenekmp/search/Query;", "field", "", "queryVector", "k", "", "createFieldType", "dimension", "core"})
    @SourceDebugExtension(value={"SMAP\nKnnByteVectorField.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KnnByteVectorField.kt\norg/gnit/lucenekmp/document/KnnByteVectorField$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n1#2:137\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final FieldType createType(byte[] v, VectorSimilarityFunction similarityFunction) {
            byte[] byArray = v;
            if (v == null) {
                boolean $i$a$-requireNotNull-KnnByteVectorField$Companion$createType$22 = false;
                String $i$a$-requireNotNull-KnnByteVectorField$Companion$createType$22 = "vector value must not be null";
                throw new IllegalArgumentException($i$a$-requireNotNull-KnnByteVectorField$Companion$createType$22.toString());
            }
            int dimension = v.length;
            if (!(dimension != 0)) {
                boolean bl = false;
                String string = "cannot index an empty vector";
                throw new IllegalArgumentException(string.toString());
            }
            if (similarityFunction == null) {
                boolean $i$a$-requireNotNull-KnnByteVectorField$Companion$createType$42 = false;
                String $i$a$-requireNotNull-KnnByteVectorField$Companion$createType$42 = "similarity function must not be null";
                throw new IllegalArgumentException($i$a$-requireNotNull-KnnByteVectorField$Companion$createType$42.toString());
            }
            FieldType type = new FieldType();
            type.setVectorAttributes(dimension, VectorEncoding.BYTE, similarityFunction);
            type.freeze();
            return type;
        }

        @NotNull
        public final Query newVectorQuery(@NotNull String field, @NotNull byte[] queryVector, int k) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)queryVector, (String)"queryVector");
            return new KnnByteVectorQuery(field, queryVector, k, null, null, 24, null);
        }

        @NotNull
        public final FieldType createFieldType(int dimension, @NotNull VectorSimilarityFunction similarityFunction) {
            Intrinsics.checkNotNullParameter((Object)((Object)similarityFunction), (String)"similarityFunction");
            FieldType type = new FieldType();
            type.setVectorAttributes(dimension, VectorEncoding.BYTE, similarityFunction);
            type.freeze();
            return type;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

