/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.document;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KClasses;
import org.gnit.lucenekmp.document.LatLonPoint;
import org.gnit.lucenekmp.document.LatLonPointDistanceQuery;
import org.gnit.lucenekmp.geo.GeoEncodingUtils;
import org.gnit.lucenekmp.geo.GeoUtils;
import org.gnit.lucenekmp.geo.Rectangle;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.LeafReader;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.gnit.lucenekmp.index.PointValues;
import org.gnit.lucenekmp.jdkport.DoubleExtKt;
import org.gnit.lucenekmp.search.ConstantScoreScorer;
import org.gnit.lucenekmp.search.ConstantScoreWeight;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.search.IndexSearcher;
import org.gnit.lucenekmp.search.Query;
import org.gnit.lucenekmp.search.QueryVisitor;
import org.gnit.lucenekmp.search.ScoreMode;
import org.gnit.lucenekmp.search.Scorer;
import org.gnit.lucenekmp.search.ScorerSupplier;
import org.gnit.lucenekmp.search.Weight;
import org.gnit.lucenekmp.util.BitSetIterator;
import org.gnit.lucenekmp.util.DocIdSetBuilder;
import org.gnit.lucenekmp.util.FixedBitSet;
import org.gnit.lucenekmp.util.IntsRef;
import org.gnit.lucenekmp.util.NumericUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0096\u0002J\u0010\u0010\"\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0000H\u0002J\u0012\u0010#\u001a\u00020\u00032\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006$"}, d2={"Lorg/gnit/lucenekmp/document/LatLonPointDistanceQuery;", "Lorg/gnit/lucenekmp/search/Query;", "field", "", "latitude", "", "longitude", "radiusMeters", "<init>", "(Ljava/lang/String;DDD)V", "getField", "()Ljava/lang/String;", "getLatitude", "()D", "getLongitude", "getRadiusMeters", "visit", "", "visitor", "Lorg/gnit/lucenekmp/search/QueryVisitor;", "createWeight", "Lorg/gnit/lucenekmp/search/Weight;", "searcher", "Lorg/gnit/lucenekmp/search/IndexSearcher;", "scoreMode", "Lorg/gnit/lucenekmp/search/ScoreMode;", "boost", "", "hashCode", "", "equals", "", "other", "", "equalsTo", "toString", "core"})
@SourceDebugExtension(value={"SMAP\nLatLonPointDistanceQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LatLonPointDistanceQuery.kt\norg/gnit/lucenekmp/document/LatLonPointDistanceQuery\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,358:1\n1#2:359\n*E\n"})
public final class LatLonPointDistanceQuery
extends Query {
    @NotNull
    private final String field;
    private final double latitude;
    private final double longitude;
    private final double radiusMeters;

    public LatLonPointDistanceQuery(@NotNull String field, double latitude, double longitude, double radiusMeters) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        if (!(DoubleExtKt.isFinite(DoubleCompanionObject.INSTANCE, radiusMeters) && !(radiusMeters < 0.0))) {
            boolean bl = false;
            String string = "radiusMeters: '" + radiusMeters + "' is invalid";
            throw new IllegalArgumentException(string.toString());
        }
        GeoUtils.INSTANCE.checkLatitude(latitude);
        GeoUtils.INSTANCE.checkLongitude(longitude);
        this.field = field;
        this.latitude = latitude;
        this.longitude = longitude;
        this.radiusMeters = radiusMeters;
    }

    @NotNull
    public final String getField() {
        return this.field;
    }

    public final double getLatitude() {
        return this.latitude;
    }

    public final double getLongitude() {
        return this.longitude;
    }

    public final double getRadiusMeters() {
        return this.radiusMeters;
    }

    @Override
    public void visit(@NotNull QueryVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        if (visitor2.acceptField(this.field)) {
            visitor2.visitLeaf(this);
        }
    }

    @Override
    @NotNull
    public Weight createWeight(@NotNull IndexSearcher searcher, @NotNull ScoreMode scoreMode, float boost) {
        Intrinsics.checkNotNullParameter((Object)searcher, (String)"searcher");
        Intrinsics.checkNotNullParameter((Object)((Object)scoreMode), (String)"scoreMode");
        Rectangle box = Rectangle.Companion.fromPointDistance(this.latitude, this.longitude, this.radiusMeters);
        int minLat = GeoEncodingUtils.INSTANCE.encodeLatitude(box.getMinLat());
        int maxLat = GeoEncodingUtils.INSTANCE.encodeLatitude(box.getMaxLat());
        int minLon = 0;
        int maxLon = 0;
        int minLon2 = 0;
        if (box.crossesDateline()) {
            minLon = Integer.MIN_VALUE;
            maxLon = GeoEncodingUtils.INSTANCE.encodeLongitude(box.getMaxLon());
            minLon2 = GeoEncodingUtils.INSTANCE.encodeLongitude(box.getMinLon());
        } else {
            minLon = GeoEncodingUtils.INSTANCE.encodeLongitude(box.getMinLon());
            maxLon = GeoEncodingUtils.INSTANCE.encodeLongitude(box.getMaxLon());
            minLon2 = Integer.MAX_VALUE;
        }
        double sortKey = GeoUtils.INSTANCE.distanceQuerySortKey(this.radiusMeters);
        double axisLat = Rectangle.Companion.axisLat(this.latitude, this.radiusMeters);
        return new ConstantScoreWeight(this, boost, scoreMode, maxLat, minLat, maxLon, minLon, minLon2, sortKey, axisLat){
            private final GeoEncodingUtils.DistancePredicate distancePredicate;
            final /* synthetic */ LatLonPointDistanceQuery this$0;
            final /* synthetic */ ScoreMode $scoreMode;
            final /* synthetic */ int $maxLat;
            final /* synthetic */ int $minLat;
            final /* synthetic */ int $maxLon;
            final /* synthetic */ int $minLon;
            final /* synthetic */ int $minLon2;
            final /* synthetic */ double $sortKey;
            final /* synthetic */ double $axisLat;
            {
                this.this$0 = $receiver;
                this.$scoreMode = $scoreMode;
                this.$maxLat = $maxLat;
                this.$minLat = $minLat;
                this.$maxLon = $maxLon;
                this.$minLon = $minLon;
                this.$minLon2 = $minLon2;
                this.$sortKey = $sortKey;
                this.$axisLat = $axisLat;
                super($receiver, $boost);
                this.distancePredicate = GeoEncodingUtils.INSTANCE.createDistancePredicate($receiver.getLatitude(), $receiver.getLongitude(), $receiver.getRadiusMeters());
            }

            public final GeoEncodingUtils.DistancePredicate getDistancePredicate() {
                return this.distancePredicate;
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                return true;
            }

            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                LeafReader reader2 = context.reader();
                PointValues values2 = reader2.getPointValues(this.this$0.getField());
                if (values2 == null) {
                    return null;
                }
                FieldInfo fieldInfo = reader2.getFieldInfos().fieldInfo(this.this$0.getField());
                if (fieldInfo == null) {
                    return null;
                }
                LatLonPoint.Companion.checkCompatible(fieldInfo);
                DocIdSetBuilder result = new DocIdSetBuilder(reader2.maxDoc(), values2);
                PointValues.IntersectVisitor visitor2 = this.getIntersectVisitor(result);
                return new ScorerSupplier(values2, reader2, this, this.$scoreMode, visitor2, result){
                    private long cost;
                    final /* synthetic */ PointValues $values;
                    final /* synthetic */ LeafReader $reader;
                    final /* synthetic */ createWeight.1 this$0;
                    final /* synthetic */ ScoreMode $scoreMode;
                    final /* synthetic */ PointValues.IntersectVisitor $visitor;
                    final /* synthetic */ DocIdSetBuilder $result;
                    {
                        this.$values = $values;
                        this.$reader = $reader;
                        this.this$0 = $receiver;
                        this.$scoreMode = $scoreMode;
                        this.$visitor = $visitor;
                        this.$result = $result;
                        this.cost = -1L;
                    }

                    public final long getCost() {
                        return this.cost;
                    }

                    public final void setCost(long l) {
                        this.cost = l;
                    }

                    public Scorer get(long leadCost) throws IOException {
                        if (this.$values.getDocCount() == this.$reader.maxDoc() && (long)this.$values.getDocCount() == this.$values.size() && this.cost() > (long)(this.$reader.maxDoc() / 2)) {
                            FixedBitSet result = new FixedBitSet(this.$reader.maxDoc());
                            result.set(0, this.$reader.maxDoc());
                            long[] lArray = new long[]{this.$reader.maxDoc()};
                            long[] cost = lArray;
                            this.$values.intersect(this.this$0.getInverseIntersectVisitor(result, cost));
                            DocIdSetIterator iterator2 = new BitSetIterator(result, cost[0]);
                            return new ConstantScoreScorer(createWeight.1.access$score(this.this$0), this.$scoreMode, iterator2);
                        }
                        this.$values.intersect(this.$visitor);
                        return new ConstantScoreScorer(createWeight.1.access$score(this.this$0), this.$scoreMode, this.$result.build().iterator());
                    }

                    public long cost() {
                        if (this.cost == -1L) {
                            this.cost = this.$values.estimateDocCount(this.$visitor);
                        }
                        if (!(this.cost >= 0L)) {
                            String string = "Failed requirement.";
                            throw new IllegalArgumentException(string.toString());
                        }
                        return this.cost;
                    }
                };
            }

            public final boolean matches(byte[] packedValue) {
                Intrinsics.checkNotNullParameter((Object)packedValue, (String)"packedValue");
                int lat = NumericUtils.INSTANCE.sortableBytesToInt(packedValue, 0);
                if (lat > this.$maxLat || lat < this.$minLat) {
                    return false;
                }
                int lon = NumericUtils.INSTANCE.sortableBytesToInt(packedValue, 4);
                if ((lon > this.$maxLon || lon < this.$minLon) && lon < this.$minLon2) {
                    return false;
                }
                return this.distancePredicate.test(lat, lon);
            }

            public final PointValues.Relation relate(byte[] minPackedValue, byte[] maxPackedValue) {
                Intrinsics.checkNotNullParameter((Object)minPackedValue, (String)"minPackedValue");
                Intrinsics.checkNotNullParameter((Object)maxPackedValue, (String)"maxPackedValue");
                int latLowerBound = NumericUtils.INSTANCE.sortableBytesToInt(minPackedValue, 0);
                int latUpperBound = NumericUtils.INSTANCE.sortableBytesToInt(maxPackedValue, 0);
                if (latLowerBound > this.$maxLat || latUpperBound < this.$minLat) {
                    return PointValues.Relation.CELL_OUTSIDE_QUERY;
                }
                int lonLowerBound = NumericUtils.INSTANCE.sortableBytesToInt(minPackedValue, 4);
                int lonUpperBound = NumericUtils.INSTANCE.sortableBytesToInt(maxPackedValue, 4);
                if ((lonLowerBound > this.$maxLon || lonUpperBound < this.$minLon) && lonUpperBound < this.$minLon2) {
                    return PointValues.Relation.CELL_OUTSIDE_QUERY;
                }
                double latMin = GeoEncodingUtils.INSTANCE.decodeLatitude(latLowerBound);
                double lonMin = GeoEncodingUtils.INSTANCE.decodeLongitude(lonLowerBound);
                double latMax = GeoEncodingUtils.INSTANCE.decodeLatitude(latUpperBound);
                double lonMax = GeoEncodingUtils.INSTANCE.decodeLongitude(lonUpperBound);
                return GeoUtils.INSTANCE.relate(latMin, latMax, lonMin, lonMax, this.this$0.getLatitude(), this.this$0.getLongitude(), this.$sortKey, this.$axisLat);
            }

            public final PointValues.IntersectVisitor getIntersectVisitor(DocIdSetBuilder result) {
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                return new PointValues.IntersectVisitor(result, this){
                    private DocIdSetBuilder.BulkAdder adder;
                    final /* synthetic */ DocIdSetBuilder $result;
                    final /* synthetic */ createWeight.1 this$0;
                    {
                        this.$result = $result;
                        this.this$0 = $receiver;
                    }

                    public final DocIdSetBuilder.BulkAdder getAdder() {
                        return this.adder;
                    }

                    public final void setAdder(DocIdSetBuilder.BulkAdder bulkAdder) {
                        this.adder = bulkAdder;
                    }

                    public void grow(int count) {
                        this.adder = this.$result.grow(count);
                    }

                    public void visit(int docID) {
                        DocIdSetBuilder.BulkAdder bulkAdder = this.adder;
                        Intrinsics.checkNotNull((Object)bulkAdder);
                        bulkAdder.add(docID);
                    }

                    public void visit(IntsRef ref) {
                        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
                        DocIdSetBuilder.BulkAdder bulkAdder = this.adder;
                        Intrinsics.checkNotNull((Object)bulkAdder);
                        bulkAdder.add(ref);
                    }

                    public void visit(DocIdSetIterator iterator2) throws IOException {
                        Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
                        DocIdSetBuilder.BulkAdder bulkAdder = this.adder;
                        Intrinsics.checkNotNull((Object)bulkAdder);
                        bulkAdder.add(iterator2);
                    }

                    public void visit(int docID, byte[] packedValue) {
                        Intrinsics.checkNotNullParameter((Object)packedValue, (String)"packedValue");
                        if (this.this$0.matches(packedValue)) {
                            this.visit(docID);
                        }
                    }

                    public void visit(DocIdSetIterator iterator2, byte[] packedValue) throws IOException {
                        Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
                        Intrinsics.checkNotNullParameter((Object)packedValue, (String)"packedValue");
                        if (this.this$0.matches(packedValue)) {
                            DocIdSetBuilder.BulkAdder bulkAdder = this.adder;
                            Intrinsics.checkNotNull((Object)bulkAdder);
                            bulkAdder.add(iterator2);
                        }
                    }

                    public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                        Intrinsics.checkNotNullParameter((Object)minPackedValue, (String)"minPackedValue");
                        Intrinsics.checkNotNullParameter((Object)maxPackedValue, (String)"maxPackedValue");
                        return this.this$0.relate(minPackedValue, maxPackedValue);
                    }
                };
            }

            public final PointValues.IntersectVisitor getInverseIntersectVisitor(FixedBitSet result, long[] cost) {
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                Intrinsics.checkNotNullParameter((Object)cost, (String)"cost");
                return new PointValues.IntersectVisitor(result, cost, this){
                    final /* synthetic */ FixedBitSet $result;
                    final /* synthetic */ long[] $cost;
                    final /* synthetic */ createWeight.1 this$0;
                    {
                        this.$result = $result;
                        this.$cost = $cost;
                        this.this$0 = $receiver;
                    }

                    public void visit(int docID) {
                        this.$result.clear(docID);
                        long[] lArray = this.$cost;
                        long l = lArray[0];
                        lArray[0] = l + -1L;
                    }

                    public void visit(IntsRef ref) {
                        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
                        int n = ref.getLength();
                        for (int i = 0; i < n; ++i) {
                            this.$result.clear(ref.getInts()[ref.getOffset() + i]);
                        }
                        this.$cost[0] = Math.max(0L, this.$cost[0] - (long)ref.getLength());
                    }

                    public void visit(DocIdSetIterator iterator2) throws IOException {
                        Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
                        this.$result.andNot(iterator2);
                        this.$cost[0] = Math.max(0L, this.$cost[0] - iterator2.cost());
                    }

                    public void visit(int docID, byte[] packedValue) {
                        Intrinsics.checkNotNullParameter((Object)packedValue, (String)"packedValue");
                        if (!this.this$0.matches(packedValue)) {
                            this.visit(docID);
                        }
                    }

                    public void visit(DocIdSetIterator iterator2, byte[] packedValue) throws IOException {
                        Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
                        Intrinsics.checkNotNullParameter((Object)packedValue, (String)"packedValue");
                        if (!this.this$0.matches(packedValue)) {
                            this.visit(iterator2);
                        }
                    }

                    public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                        Intrinsics.checkNotNullParameter((Object)minPackedValue, (String)"minPackedValue");
                        Intrinsics.checkNotNullParameter((Object)maxPackedValue, (String)"maxPackedValue");
                        PointValues.Relation relation = this.this$0.relate(minPackedValue, maxPackedValue);
                        return switch (createWeight.getInverseIntersectVisitor.WhenMappings.$EnumSwitchMapping$0[relation.ordinal()]) {
                            case 1 -> PointValues.Relation.CELL_OUTSIDE_QUERY;
                            case 2 -> PointValues.Relation.CELL_INSIDE_QUERY;
                            case 3 -> relation;
                            default -> throw new NoWhenBranchMatchedException();
                        };
                    }

                    public void grow(int count) {
                        PointValues.IntersectVisitor.super.grow(count);
                    }
                };
            }

            public static final /* synthetic */ float access$score(createWeight.1 $this) {
                return $this.score();
            }
        };
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = this.classHash();
        result = prime * result + this.field.hashCode();
        long temp = DoubleExtKt.doubleToLongBits(DoubleCompanionObject.INSTANCE, this.latitude);
        result = prime * result + (int)(temp ^ temp >>> 32);
        temp = DoubleExtKt.doubleToLongBits(DoubleCompanionObject.INSTANCE, this.longitude);
        result = prime * result + (int)(temp ^ temp >>> 32);
        temp = DoubleExtKt.doubleToLongBits(DoubleCompanionObject.INSTANCE, this.radiusMeters);
        result = prime * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return this.sameClassAs(other) && this.equalsTo((LatLonPointDistanceQuery)KClasses.cast((KClass)Reflection.getOrCreateKotlinClass(this.getClass()), (Object)other));
    }

    private final boolean equalsTo(LatLonPointDistanceQuery other) {
        return Intrinsics.areEqual((Object)this.field, (Object)other.field) && DoubleExtKt.doubleToLongBits(DoubleCompanionObject.INSTANCE, this.latitude) == DoubleExtKt.doubleToLongBits(DoubleCompanionObject.INSTANCE, other.latitude) && DoubleExtKt.doubleToLongBits(DoubleCompanionObject.INSTANCE, this.longitude) == DoubleExtKt.doubleToLongBits(DoubleCompanionObject.INSTANCE, other.longitude) && DoubleExtKt.doubleToLongBits(DoubleCompanionObject.INSTANCE, this.radiusMeters) == DoubleExtKt.doubleToLongBits(DoubleCompanionObject.INSTANCE, other.radiusMeters);
    }

    @Override
    @NotNull
    public String toString(@Nullable String field) {
        StringBuilder sb = new StringBuilder();
        if (!Intrinsics.areEqual((Object)this.field, (Object)field)) {
            sb.append(this.field);
            sb.append(':');
        }
        sb.append(this.latitude);
        sb.append(",");
        sb.append(this.longitude);
        sb.append(" +/- ");
        sb.append(this.radiusMeters);
        sb.append(" meters");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

