/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.document;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gnit.lucenekmp.index.DocValues;
import org.gnit.lucenekmp.index.DocValuesSkipper;
import org.gnit.lucenekmp.index.LeafReader;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.gnit.lucenekmp.index.NumericDocValues;
import org.gnit.lucenekmp.index.SortedNumericDocValues;
import org.gnit.lucenekmp.jdkport.Objects;
import org.gnit.lucenekmp.search.ConstantScoreScorerSupplier;
import org.gnit.lucenekmp.search.ConstantScoreWeight;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.search.DocValuesRangeIterator;
import org.gnit.lucenekmp.search.FieldExistsQuery;
import org.gnit.lucenekmp.search.IndexSearcher;
import org.gnit.lucenekmp.search.MatchAllScorerSupplier;
import org.gnit.lucenekmp.search.MatchNoDocsQuery;
import org.gnit.lucenekmp.search.Query;
import org.gnit.lucenekmp.search.QueryVisitor;
import org.gnit.lucenekmp.search.ScoreMode;
import org.gnit.lucenekmp.search.ScorerSupplier;
import org.gnit.lucenekmp.search.Sort;
import org.gnit.lucenekmp.search.TwoPhaseIterator;
import org.gnit.lucenekmp.search.Weight;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 &2\u00020\u0001:\u0001&B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0096\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u00020\u00032\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\"\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/gnit/lucenekmp/document/SortedNumericDocValuesRangeQuery;", "Lorg/gnit/lucenekmp/search/Query;", "field", "", "lowerValue", "", "upperValue", "<init>", "(Ljava/lang/String;JJ)V", "equals", "", "obj", "", "hashCode", "", "visit", "", "visitor", "Lorg/gnit/lucenekmp/search/QueryVisitor;", "toString", "rewrite", "indexSearcher", "Lorg/gnit/lucenekmp/search/IndexSearcher;", "createWeight", "Lorg/gnit/lucenekmp/search/Weight;", "searcher", "scoreMode", "Lorg/gnit/lucenekmp/search/ScoreMode;", "boost", "", "getDocIdSetIteratorOrNullForPrimarySort", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "reader", "Lorg/gnit/lucenekmp/index/LeafReader;", "numericDocValues", "Lorg/gnit/lucenekmp/index/NumericDocValues;", "skipper", "Lorg/gnit/lucenekmp/index/DocValuesSkipper;", "Companion", "core"})
public final class SortedNumericDocValuesRangeQuery
extends Query {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String field;
    private final long lowerValue;
    private final long upperValue;

    public SortedNumericDocValuesRangeQuery(@NotNull String field, long lowerValue, long upperValue) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        this.field = field;
        this.lowerValue = lowerValue;
        this.upperValue = upperValue;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)obj, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.document.SortedNumericDocValuesRangeQuery");
        SortedNumericDocValuesRangeQuery that = (SortedNumericDocValuesRangeQuery)obj;
        return Intrinsics.areEqual((Object)this.field, (Object)that.field) && this.lowerValue == that.lowerValue && this.upperValue == that.upperValue;
    }

    @Override
    public int hashCode() {
        Object[] objectArray = new Object[]{this.classHash(), this.field, this.lowerValue, this.upperValue};
        return Objects.INSTANCE.hash(objectArray);
    }

    @Override
    public void visit(@NotNull QueryVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        if (visitor2.acceptField(this.field)) {
            visitor2.visitLeaf(this);
        }
    }

    @Override
    @NotNull
    public String toString(@Nullable String field) {
        StringBuilder b = new StringBuilder();
        if (!Intrinsics.areEqual((Object)this.field, (Object)field)) {
            b.append(this.field).append(":");
        }
        String string = b.append("[").append(this.lowerValue).append(" TO ").append(this.upperValue).append("]").toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    @NotNull
    public Query rewrite(@NotNull IndexSearcher indexSearcher) {
        Intrinsics.checkNotNullParameter((Object)indexSearcher, (String)"indexSearcher");
        if (this.lowerValue == Long.MIN_VALUE && this.upperValue == Long.MAX_VALUE) {
            return new FieldExistsQuery(this.field);
        }
        if (this.lowerValue > this.upperValue) {
            return new MatchNoDocsQuery(null, 1, null);
        }
        return super.rewrite(indexSearcher);
    }

    @Override
    @NotNull
    public Weight createWeight(@NotNull IndexSearcher searcher, @NotNull ScoreMode scoreMode, float boost) {
        Intrinsics.checkNotNullParameter((Object)searcher, (String)"searcher");
        Intrinsics.checkNotNullParameter((Object)((Object)scoreMode), (String)"scoreMode");
        return new ConstantScoreWeight(this, boost, scoreMode){
            final /* synthetic */ SortedNumericDocValuesRangeQuery this$0;
            final /* synthetic */ ScoreMode $scoreMode;
            {
                this.this$0 = $receiver;
                this.$scoreMode = $scoreMode;
                super($receiver, $boost);
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                String[] stringArray = new String[]{SortedNumericDocValuesRangeQuery.access$getField$p(this.this$0)};
                return DocValues.INSTANCE.isCacheable(ctx, stringArray);
            }

            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                if (context.reader().getFieldInfos().fieldInfo(SortedNumericDocValuesRangeQuery.access$getField$p(this.this$0)) == null) {
                    return null;
                }
                int maxDoc = context.reader().maxDoc();
                DocValuesSkipper skipper = context.reader().getDocValuesSkipper(SortedNumericDocValuesRangeQuery.access$getField$p(this.this$0));
                if (skipper != null) {
                    if (skipper.minValue() > SortedNumericDocValuesRangeQuery.access$getUpperValue$p(this.this$0) || skipper.maxValue() < SortedNumericDocValuesRangeQuery.access$getLowerValue$p(this.this$0)) {
                        return null;
                    }
                    if (skipper.docCount() == maxDoc && skipper.minValue() >= SortedNumericDocValuesRangeQuery.access$getLowerValue$p(this.this$0) && skipper.maxValue() <= SortedNumericDocValuesRangeQuery.access$getUpperValue$p(this.this$0)) {
                        return new MatchAllScorerSupplier(this.score(), this.$scoreMode, maxDoc);
                    }
                }
                SortedNumericDocValues values2 = DocValues.INSTANCE.getSortedNumeric(context.reader(), SortedNumericDocValuesRangeQuery.access$getField$p(this.this$0));
                NumericDocValues singleton = DocValues.INSTANCE.unwrapSingleton(values2);
                TwoPhaseIterator iterator2 = null;
                if (singleton != null) {
                    DocIdSetIterator psIterator;
                    if (skipper != null && (psIterator = SortedNumericDocValuesRangeQuery.access$getDocIdSetIteratorOrNullForPrimarySort(this.this$0, context.reader(), singleton, skipper)) != null) {
                        return ConstantScoreScorerSupplier.Companion.fromIterator(psIterator, this.score(), this.$scoreMode, maxDoc);
                    }
                    iterator2 = new TwoPhaseIterator(singleton, this.this$0){
                        final /* synthetic */ NumericDocValues $singleton;
                        final /* synthetic */ SortedNumericDocValuesRangeQuery this$0;
                        {
                            this.$singleton = $singleton;
                            this.this$0 = $receiver;
                            super($singleton);
                        }

                        public boolean matches() throws IOException {
                            long value = this.$singleton.longValue();
                            return value >= SortedNumericDocValuesRangeQuery.access$getLowerValue$p(this.this$0) && value <= SortedNumericDocValuesRangeQuery.access$getUpperValue$p(this.this$0);
                        }

                        public float matchCost() {
                            return 2.0f;
                        }
                    };
                } else {
                    iterator2 = new TwoPhaseIterator(values2, this.this$0){
                        final /* synthetic */ SortedNumericDocValues $values;
                        final /* synthetic */ SortedNumericDocValuesRangeQuery this$0;
                        {
                            this.$values = $values;
                            this.this$0 = $receiver;
                            super($values);
                        }

                        public boolean matches() throws IOException {
                            int count = this.$values.docValueCount();
                            for (int i = 0; i < count; ++i) {
                                long value = this.$values.nextValue();
                                if (value < SortedNumericDocValuesRangeQuery.access$getLowerValue$p(this.this$0)) {
                                    continue;
                                }
                                return value <= SortedNumericDocValuesRangeQuery.access$getUpperValue$p(this.this$0);
                            }
                            return false;
                        }

                        public float matchCost() {
                            return 2.0f;
                        }
                    };
                }
                if (skipper != null) {
                    iterator2 = new DocValuesRangeIterator(iterator2, skipper, SortedNumericDocValuesRangeQuery.access$getLowerValue$p(this.this$0), SortedNumericDocValuesRangeQuery.access$getUpperValue$p(this.this$0), false);
                }
                return ConstantScoreScorerSupplier.Companion.fromIterator(TwoPhaseIterator.Companion.asDocIdSetIterator(iterator2), this.score(), this.$scoreMode, maxDoc);
            }
        };
    }

    private final DocIdSetIterator getDocIdSetIteratorOrNullForPrimarySort(LeafReader reader2, NumericDocValues numericDocValues, DocValuesSkipper skipper) throws IOException {
        if (skipper.docCount() != reader2.maxDoc()) {
            return null;
        }
        Sort indexSort = reader2.getMetaData().getSort();
        if (indexSort == null || indexSort.getSort().length == 0 || !StringsKt.equals$default((String)indexSort.getSort()[0].getField(), (String)this.field, (boolean)false, (int)2, null)) {
            return null;
        }
        int minDocID = 0;
        int maxDocID = 0;
        if (indexSort.getSort()[0].getReverse()) {
            if (skipper.maxValue() <= this.upperValue) {
                minDocID = 0;
            } else {
                skipper.advance(Long.MIN_VALUE, this.upperValue);
                minDocID = SortedNumericDocValuesRangeQuery.Companion.nextDoc(skipper.minDocID(0), numericDocValues, (Function1<? super Long, Boolean>)arg_0 -> SortedNumericDocValuesRangeQuery.getDocIdSetIteratorOrNullForPrimarySort$lambda$0(this, arg_0));
            }
            if (skipper.minValue() >= this.lowerValue) {
                maxDocID = skipper.docCount();
            } else {
                skipper.advance(Long.MIN_VALUE, this.lowerValue);
                maxDocID = SortedNumericDocValuesRangeQuery.Companion.nextDoc(skipper.minDocID(0), numericDocValues, (Function1<? super Long, Boolean>)arg_0 -> SortedNumericDocValuesRangeQuery.getDocIdSetIteratorOrNullForPrimarySort$lambda$1(this, arg_0));
            }
        } else {
            if (skipper.minValue() >= this.lowerValue) {
                minDocID = 0;
            } else {
                skipper.advance(this.lowerValue, Long.MAX_VALUE);
                minDocID = SortedNumericDocValuesRangeQuery.Companion.nextDoc(skipper.minDocID(0), numericDocValues, (Function1<? super Long, Boolean>)arg_0 -> SortedNumericDocValuesRangeQuery.getDocIdSetIteratorOrNullForPrimarySort$lambda$2(this, arg_0));
            }
            if (skipper.maxValue() <= this.upperValue) {
                maxDocID = skipper.docCount();
            } else {
                skipper.advance(this.upperValue, Long.MAX_VALUE);
                maxDocID = SortedNumericDocValuesRangeQuery.Companion.nextDoc(skipper.minDocID(0), numericDocValues, (Function1<? super Long, Boolean>)arg_0 -> SortedNumericDocValuesRangeQuery.getDocIdSetIteratorOrNullForPrimarySort$lambda$3(this, arg_0));
            }
        }
        return minDocID == maxDocID ? DocIdSetIterator.Companion.empty() : DocIdSetIterator.Companion.range(minDocID, maxDocID);
    }

    private static final boolean getDocIdSetIteratorOrNullForPrimarySort$lambda$0(SortedNumericDocValuesRangeQuery this$0, long l) {
        return l <= this$0.upperValue;
    }

    private static final boolean getDocIdSetIteratorOrNullForPrimarySort$lambda$1(SortedNumericDocValuesRangeQuery this$0, long l) {
        return l < this$0.lowerValue;
    }

    private static final boolean getDocIdSetIteratorOrNullForPrimarySort$lambda$2(SortedNumericDocValuesRangeQuery this$0, long l) {
        return l >= this$0.lowerValue;
    }

    private static final boolean getDocIdSetIteratorOrNullForPrimarySort$lambda$3(SortedNumericDocValuesRangeQuery this$0, long l) {
        return l > this$0.upperValue;
    }

    public static final /* synthetic */ String access$getField$p(SortedNumericDocValuesRangeQuery $this) {
        return $this.field;
    }

    public static final /* synthetic */ long access$getUpperValue$p(SortedNumericDocValuesRangeQuery $this) {
        return $this.upperValue;
    }

    public static final /* synthetic */ long access$getLowerValue$p(SortedNumericDocValuesRangeQuery $this) {
        return $this.lowerValue;
    }

    public static final /* synthetic */ DocIdSetIterator access$getDocIdSetIteratorOrNullForPrimarySort(SortedNumericDocValuesRangeQuery $this, LeafReader reader2, NumericDocValues numericDocValues, DocValuesSkipper skipper) {
        return $this.getDocIdSetIteratorOrNullForPrimarySort(reader2, numericDocValues, skipper);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nH\u0002\u00a8\u0006\r"}, d2={"Lorg/gnit/lucenekmp/document/SortedNumericDocValuesRangeQuery$Companion;", "", "<init>", "()V", "nextDoc", "", "startDoc", "docValues", "Lorg/gnit/lucenekmp/index/NumericDocValues;", "predicate", "Lkotlin/Function1;", "", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final int nextDoc(int startDoc, NumericDocValues docValues, Function1<? super Long, Boolean> predicate) throws IOException {
            int doc = docValues.docID();
            if (startDoc > doc) {
                doc = docValues.advance(startDoc);
            }
            while (doc < Integer.MAX_VALUE && !((Boolean)predicate.invoke((Object)docValues.longValue())).booleanValue()) {
                doc = docValues.nextDoc();
            }
            return doc;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

