/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.geo;

import kotlin.Metadata;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.geo.Circle2D;
import org.gnit.lucenekmp.geo.Component2D;
import org.gnit.lucenekmp.geo.GeoUtils;
import org.gnit.lucenekmp.geo.LatLonGeometry;
import org.gnit.lucenekmp.jdkport.DoubleExtKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\r\u001a\u00020\u000eH\u0014J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0017"}, d2={"Lorg/gnit/lucenekmp/geo/Circle;", "Lorg/gnit/lucenekmp/geo/LatLonGeometry;", "lat", "", "lon", "radiusMeters", "<init>", "(DDD)V", "getLat", "()D", "getLon", "radius", "getRadius", "toComponent2D", "Lorg/gnit/lucenekmp/geo/Component2D;", "equals", "", "o", "", "hashCode", "", "toString", "", "core"})
@SourceDebugExtension(value={"SMAP\nCircle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Circle.kt\norg/gnit/lucenekmp/geo/Circle\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n1#2:77\n*E\n"})
public final class Circle
extends LatLonGeometry {
    private final double lat;
    private final double lon;
    private final double radius;

    public Circle(double lat, double lon, double radiusMeters) {
        GeoUtils.INSTANCE.checkLatitude(lat);
        GeoUtils.INSTANCE.checkLongitude(lon);
        if (!(DoubleExtKt.isFinite(DoubleCompanionObject.INSTANCE, radiusMeters) && !(radiusMeters < 0.0))) {
            boolean bl = false;
            String string = "radiusMeters: '" + radiusMeters + "' is invalid";
            throw new IllegalArgumentException(string.toString());
        }
        this.lat = lat;
        this.lon = lon;
        this.radius = radiusMeters;
    }

    public final double getLat() {
        return this.lat;
    }

    public final double getLon() {
        return this.lon;
    }

    public final double getRadius() {
        return this.radius;
    }

    @Override
    @NotNull
    protected Component2D toComponent2D() {
        return Circle2D.Companion.create(this);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Circle)) {
            return false;
        }
        Object circle = o;
        return DoubleExtKt.compare(DoubleCompanionObject.INSTANCE, this.lat, ((Circle)circle).lat) == 0 && DoubleExtKt.compare(DoubleCompanionObject.INSTANCE, this.lon, ((Circle)circle).lon) == 0 && DoubleExtKt.compare(DoubleCompanionObject.INSTANCE, this.radius, ((Circle)circle).radius) == 0;
    }

    public int hashCode() {
        int result = Double.hashCode(this.lat);
        result = 31 * result + Double.hashCode(this.lon);
        result = 31 * result + Double.hashCode(this.radius);
        return result;
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Circle(");
        sb.append("[" + this.lat + "," + this.lon + "]");
        sb.append(" radius = " + this.radius + " meters");
        sb.append(')');
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

