/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.geo;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.IntCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.geo.Component2D;
import org.gnit.lucenekmp.geo.GeoUtils;
import org.gnit.lucenekmp.geo.Rectangle;
import org.gnit.lucenekmp.index.PointValues;
import org.gnit.lucenekmp.jdkport.IntExtKt;
import org.gnit.lucenekmp.util.NumericUtils;
import org.gnit.lucenekmp.util.SloppyMath;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003456B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0007J\u000e\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0007J\u000e\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0007J\u000e\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0007J\u000e\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\fJ\u0016\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\fJ\u000e\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\fJ\u0016\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\fJ\u001e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0007J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%J<\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u00072\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020/0-H\u0002J\u0018\u00100\u001a\u00020\f2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u000202H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u00067"}, d2={"Lorg/gnit/lucenekmp/geo/GeoEncodingUtils;", "", "<init>", "()V", "BITS", "", "LAT_SCALE", "", "LAT_DECODE", "LON_SCALE", "LON_DECODE", "MIN_LON_ENCODED", "", "getMIN_LON_ENCODED", "()I", "MAX_LON_ENCODED", "getMAX_LON_ENCODED", "encodeLatitude", "latitude", "encodeLatitudeCeil", "encodeLongitude", "longitude", "encodeLongitudeCeil", "decodeLatitude", "encoded", "src", "", "offset", "decodeLongitude", "createDistancePredicate", "Lorg/gnit/lucenekmp/geo/GeoEncodingUtils$DistancePredicate;", "lat", "lon", "radiusMeters", "createComponentPredicate", "Lorg/gnit/lucenekmp/geo/GeoEncodingUtils$Component2DPredicate;", "tree", "Lorg/gnit/lucenekmp/geo/Component2D;", "createSubBoxes", "Lorg/gnit/lucenekmp/geo/GeoEncodingUtils$Grid;", "shapeMinLat", "shapeMaxLat", "shapeMinLon", "shapeMaxLon", "boxToRelation", "Lkotlin/Function1;", "Lorg/gnit/lucenekmp/geo/Rectangle;", "Lorg/gnit/lucenekmp/index/PointValues$Relation;", "computeShift", "a", "", "b", "Grid", "DistancePredicate", "Component2DPredicate", "core"})
public final class GeoEncodingUtils {
    @NotNull
    public static final GeoEncodingUtils INSTANCE = new GeoEncodingUtils();
    public static final short BITS = 32;
    private static final double LAT_SCALE = 2.3860929422222223E7;
    private static final double LAT_DECODE = 4.190951585769653E-8;
    private static final double LON_SCALE = 1.1930464711111112E7;
    private static final double LON_DECODE = 8.381903171539307E-8;
    private static final int MIN_LON_ENCODED = INSTANCE.encodeLongitude(-180.0);
    private static final int MAX_LON_ENCODED = INSTANCE.encodeLongitude(180.0);

    private GeoEncodingUtils() {
    }

    public final int getMIN_LON_ENCODED() {
        return MIN_LON_ENCODED;
    }

    public final int getMAX_LON_ENCODED() {
        return MAX_LON_ENCODED;
    }

    public final int encodeLatitude(double latitude) {
        double latitude2 = latitude;
        GeoUtils.INSTANCE.checkLatitude(latitude2);
        if (latitude2 == 90.0) {
            latitude2 = Math.nextAfter(latitude2, Double.NEGATIVE_INFINITY);
        }
        return (int)Math.floor(latitude2 / 4.190951585769653E-8);
    }

    public final int encodeLatitudeCeil(double latitude) {
        double latitude2 = latitude;
        GeoUtils.INSTANCE.checkLatitude(latitude2);
        if (latitude2 == 90.0) {
            latitude2 = Math.nextAfter(latitude2, Double.NEGATIVE_INFINITY);
        }
        return (int)Math.ceil(latitude2 / 4.190951585769653E-8);
    }

    public final int encodeLongitude(double longitude) {
        double longitude2 = longitude;
        GeoUtils.INSTANCE.checkLongitude(longitude2);
        if (longitude2 == 180.0) {
            longitude2 = Math.nextAfter(longitude2, Double.NEGATIVE_INFINITY);
        }
        return (int)Math.floor(longitude2 / 8.381903171539307E-8);
    }

    public final int encodeLongitudeCeil(double longitude) {
        double longitude2 = longitude;
        GeoUtils.INSTANCE.checkLongitude(longitude2);
        if (longitude2 == 180.0) {
            longitude2 = Math.nextAfter(longitude2, Double.NEGATIVE_INFINITY);
        }
        return (int)Math.ceil(longitude2 / 8.381903171539307E-8);
    }

    public final double decodeLatitude(int encoded) {
        double result = (double)encoded * 4.190951585769653E-8;
        if (!(result >= -90.0 && result < 90.0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return result;
    }

    public final double decodeLatitude(@NotNull byte[] src, int offset) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        return this.decodeLatitude(NumericUtils.INSTANCE.sortableBytesToInt(src, offset));
    }

    public final double decodeLongitude(int encoded) {
        double result = (double)encoded * 8.381903171539307E-8;
        if (!(result >= -180.0 && result < 180.0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return result;
    }

    public final double decodeLongitude(@NotNull byte[] src, int offset) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        return this.decodeLongitude(NumericUtils.INSTANCE.sortableBytesToInt(src, offset));
    }

    @NotNull
    public final DistancePredicate createDistancePredicate(double lat, double lon, double radiusMeters) {
        Rectangle boundingBox = Rectangle.Companion.fromPointDistance(lat, lon, radiusMeters);
        double axisLat = Rectangle.Companion.axisLat(lat, radiusMeters);
        double distanceSortKey = GeoUtils.INSTANCE.distanceQuerySortKey(radiusMeters);
        Function1 boxToRelation = arg_0 -> GeoEncodingUtils.createDistancePredicate$lambda$0(lat, lon, distanceSortKey, axisLat, arg_0);
        Grid subBoxes = this.createSubBoxes(boundingBox.getMinLat(), boundingBox.getMaxLat(), boundingBox.getMinLon(), boundingBox.getMaxLon(), (Function1<? super Rectangle, ? extends PointValues.Relation>)boxToRelation);
        return new DistancePredicate(subBoxes.getLatShift(), subBoxes.getLonShift(), subBoxes.getLatBase(), subBoxes.getLonBase(), subBoxes.getMaxLatDelta(), subBoxes.getMaxLonDelta(), subBoxes.getRelations(), lat, lon, distanceSortKey);
    }

    @NotNull
    public final Component2DPredicate createComponentPredicate(@NotNull Component2D tree) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Function1 boxToRelation = arg_0 -> GeoEncodingUtils.createComponentPredicate$lambda$1(tree, arg_0);
        Grid subBoxes = this.createSubBoxes(tree.getMinY(), tree.getMaxY(), tree.getMinX(), tree.getMaxX(), (Function1<? super Rectangle, ? extends PointValues.Relation>)boxToRelation);
        return new Component2DPredicate(subBoxes.getLatShift(), subBoxes.getLonShift(), subBoxes.getLatBase(), subBoxes.getLonBase(), subBoxes.getMaxLatDelta(), subBoxes.getMaxLonDelta(), subBoxes.getRelations(), tree);
    }

    private final Grid createSubBoxes(double shapeMinLat, double shapeMaxLat, double shapeMinLon, double shapeMaxLon, Function1<? super Rectangle, ? extends PointValues.Relation> boxToRelation) {
        int minLat = this.encodeLatitudeCeil(shapeMinLat);
        int maxLat = this.encodeLatitude(shapeMaxLat);
        int minLon = this.encodeLongitudeCeil(shapeMinLon);
        int maxLon = this.encodeLongitude(shapeMaxLon);
        if (maxLat < minLat || shapeMaxLon >= shapeMinLon && maxLon < minLon) {
            return new Grid(1, 1, 0, 0, 0, 0, new byte[0]);
        }
        int latShift = 0;
        int lonShift = 0;
        int latBase = 0;
        int lonBase = 0;
        int maxLatDelta = 0;
        int maxLonDelta = 0;
        GeoEncodingUtils $this$createSubBoxes_u24lambda_u242 = this;
        boolean bl = false;
        long maxLat2 = (long)maxLat - (long)Integer.MIN_VALUE;
        long minLat2 = (long)minLat - (long)Integer.MIN_VALUE;
        latShift = INSTANCE.computeShift(minLat2, maxLat2);
        maxLatDelta = (int)(maxLat2 >>> latShift) - (latBase = (int)(minLat2 >>> latShift)) + 1;
        if (!(maxLatDelta > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        GeoEncodingUtils $this$createSubBoxes_u24lambda_u243 = this;
        boolean bl2 = false;
        long minLon2 = (long)minLon - (long)Integer.MIN_VALUE;
        long maxLon2 = (long)maxLon - (long)Integer.MIN_VALUE;
        if (shapeMaxLon < shapeMinLon) {
            maxLon2 += 0x100000000L;
        }
        if (!((maxLonDelta = (int)(maxLon2 >>> (lonShift = INSTANCE.computeShift(minLon2, maxLon2))) - (lonBase = (int)(minLon2 >>> lonShift)) + 1) > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        byte[] relations = new byte[maxLatDelta * maxLonDelta];
        for (int i = 0; i < maxLatDelta; ++i) {
            for (int j = 0; j < maxLonDelta; ++j) {
                int boxMinLat = (latBase + i << latShift) + Integer.MIN_VALUE;
                int boxMinLon = (lonBase + j << lonShift) + Integer.MIN_VALUE;
                int boxMaxLat = boxMinLat + (1 << latShift) - 1;
                int boxMaxLon = boxMinLon + (1 << lonShift) - 1;
                relations[i * maxLonDelta + j] = (byte)((PointValues.Relation)((Object)boxToRelation.invoke((Object)new Rectangle(this.decodeLatitude(boxMinLat), this.decodeLatitude(boxMaxLat), this.decodeLongitude(boxMinLon), this.decodeLongitude(boxMaxLon))))).ordinal();
            }
        }
        return new Grid(latShift, lonShift, latBase, lonBase, maxLatDelta, maxLonDelta, relations);
    }

    private final int computeShift(long a, long b) {
        if (!(a <= b)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int shift = 1;
        long delta;
        while ((delta = (b >>> shift) - (a >>> shift)) < 0L || delta >= 64L) {
            ++shift;
        }
        return shift;
    }

    private static final PointValues.Relation createDistancePredicate$lambda$0(double $lat, double $lon, double $distanceSortKey, double $axisLat, Rectangle box) {
        Intrinsics.checkNotNullParameter((Object)box, (String)"box");
        return GeoUtils.INSTANCE.relate(box.getMinLat(), box.getMaxLat(), box.getMinLon(), box.getMaxLon(), $lat, $lon, $distanceSortKey, $axisLat);
    }

    private static final PointValues.Relation createComponentPredicate$lambda$1(Component2D $tree, Rectangle box) {
        Intrinsics.checkNotNullParameter((Object)box, (String)"box");
        return $tree.relate(box.getMinLon(), box.getMaxLon(), box.getMinLat(), box.getMaxLat());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lorg/gnit/lucenekmp/geo/GeoEncodingUtils$Component2DPredicate;", "Lorg/gnit/lucenekmp/geo/GeoEncodingUtils$Grid;", "latShift", "", "lonShift", "latBase", "lonBase", "maxLatDelta", "maxLonDelta", "relations", "", "tree", "Lorg/gnit/lucenekmp/geo/Component2D;", "<init>", "(IIIIII[BLorg/gnit/lucenekmp/geo/Component2D;)V", "getTree", "()Lorg/gnit/lucenekmp/geo/Component2D;", "test", "", "lat", "lon", "core"})
    public static final class Component2DPredicate
    extends Grid {
        @NotNull
        private final Component2D tree;

        public Component2DPredicate(int latShift, int lonShift, int latBase, int lonBase, int maxLatDelta, int maxLonDelta, @NotNull byte[] relations, @NotNull Component2D tree) {
            Intrinsics.checkNotNullParameter((Object)relations, (String)"relations");
            Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
            super(latShift, lonShift, latBase, lonBase, maxLatDelta, maxLonDelta, relations);
            this.tree = tree;
        }

        @NotNull
        public final Component2D getTree() {
            return this.tree;
        }

        public final boolean test(int lat, int lon) {
            int lat2 = lat - Integer.MIN_VALUE >>> this.getLatShift();
            if (lat2 < this.getLatBase() || lat2 - this.getLatBase() >= this.getMaxLatDelta()) {
                return false;
            }
            int lon2 = lon - Integer.MIN_VALUE >>> this.getLonShift();
            if (lon2 < this.getLonBase()) {
                lon2 += 1 << 32 - this.getLonShift();
            }
            if (!(IntExtKt.toUnsignedLong(IntCompanionObject.INSTANCE, lon2) >= (long)this.getLonBase())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(lon2 - this.getLonBase() >= 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (lon2 - this.getLonBase() >= this.getMaxLonDelta()) {
                return false;
            }
            byte relation = this.getRelations()[(lat2 - this.getLatBase()) * this.getMaxLonDelta() + (lon2 - this.getLonBase())];
            return relation == PointValues.Relation.CELL_CROSSES_QUERY.ordinal() ? this.tree.contains(INSTANCE.decodeLongitude(lon), INSTANCE.decodeLatitude(lat)) : relation == PointValues.Relation.CELL_INSIDE_QUERY.ordinal();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001BW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/gnit/lucenekmp/geo/GeoEncodingUtils$DistancePredicate;", "Lorg/gnit/lucenekmp/geo/GeoEncodingUtils$Grid;", "latShift", "", "lonShift", "latBase", "lonBase", "maxLatDelta", "maxLonDelta", "relations", "", "lat", "", "lon", "distanceKey", "<init>", "(IIIIII[BDDD)V", "test", "", "core"})
    public static final class DistancePredicate
    extends Grid {
        private final double lat;
        private final double lon;
        private final double distanceKey;

        public DistancePredicate(int latShift, int lonShift, int latBase, int lonBase, int maxLatDelta, int maxLonDelta, @NotNull byte[] relations, double lat, double lon, double distanceKey) {
            Intrinsics.checkNotNullParameter((Object)relations, (String)"relations");
            super(latShift, lonShift, latBase, lonBase, maxLatDelta, maxLonDelta, relations);
            this.lat = lat;
            this.lon = lon;
            this.distanceKey = distanceKey;
        }

        public final boolean test(int lat, int lon) {
            int lat2 = lat - Integer.MIN_VALUE >>> this.getLatShift();
            if (lat2 < this.getLatBase() || lat2 - this.getLatBase() >= this.getMaxLatDelta()) {
                return false;
            }
            int lon2 = lon - Integer.MIN_VALUE >>> this.getLonShift();
            if (lon2 < this.getLonBase()) {
                lon2 += 1 << 32 - this.getLonShift();
            }
            if (!(IntExtKt.toUnsignedLong(IntCompanionObject.INSTANCE, lon2) >= (long)this.getLonBase())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(lon2 - this.getLonBase() >= 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (lon2 - this.getLonBase() >= this.getMaxLonDelta()) {
                return false;
            }
            byte relation = this.getRelations()[(lat2 - this.getLatBase()) * this.getMaxLonDelta() + (lon2 - this.getLonBase())];
            return relation == PointValues.Relation.CELL_CROSSES_QUERY.ordinal() ? SloppyMath.INSTANCE.haversinSortKey(INSTANCE.decodeLatitude(lat), INSTANCE.decodeLongitude(lon), this.lat, this.lon) <= this.distanceKey : relation == PointValues.Relation.CELL_INSIDE_QUERY.ordinal();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\r\b\u0016\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lorg/gnit/lucenekmp/geo/GeoEncodingUtils$Grid;", "", "latShift", "", "lonShift", "latBase", "lonBase", "maxLatDelta", "maxLonDelta", "relations", "", "<init>", "(IIIIII[B)V", "getLatShift", "()I", "getLonShift", "getLatBase", "getLonBase", "getMaxLatDelta", "getMaxLonDelta", "getRelations", "()[B", "Companion", "core"})
    public static class Grid {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int latShift;
        private final int lonShift;
        private final int latBase;
        private final int lonBase;
        private final int maxLatDelta;
        private final int maxLonDelta;
        @NotNull
        private final byte[] relations;
        public static final int ARITY = 64;

        public Grid(int latShift, int lonShift, int latBase, int lonBase, int maxLatDelta, int maxLonDelta, @NotNull byte[] relations) {
            Intrinsics.checkNotNullParameter((Object)relations, (String)"relations");
            if (!(latShift >= 1 && latShift <= 31)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(lonShift >= 1 && lonShift <= 31)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.latShift = latShift;
            this.lonShift = lonShift;
            this.latBase = latBase;
            this.lonBase = lonBase;
            this.maxLatDelta = maxLatDelta;
            this.maxLonDelta = maxLonDelta;
            this.relations = relations;
        }

        public final int getLatShift() {
            return this.latShift;
        }

        public final int getLonShift() {
            return this.lonShift;
        }

        public final int getLatBase() {
            return this.latBase;
        }

        public final int getLonBase() {
            return this.lonBase;
        }

        public final int getMaxLatDelta() {
            return this.maxLatDelta;
        }

        public final int getMaxLonDelta() {
            return this.maxLonDelta;
        }

        @NotNull
        public final byte[] getRelations() {
            return this.relations;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gnit/lucenekmp/geo/GeoEncodingUtils$Grid$Companion;", "", "<init>", "()V", "ARITY", "", "core"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

