/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.geo;

import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.geo.Rectangle;
import org.gnit.lucenekmp.index.PointValues;
import org.gnit.lucenekmp.jdkport.DoubleExtKt;
import org.gnit.lucenekmp.jdkport.Math;
import org.gnit.lucenekmp.util.SloppyMath;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0013\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001<B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0005J\u000e\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0005J\u000e\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005J\u000e\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0005JF\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u0005J\u001e\u0010'\u001a\u00020(2\u0006\u0010$\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u0005J6\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\u00052\u0006\u00100\u001a\u00020\u0005JF\u00101\u001a\u00020(2\u0006\u00102\u001a\u00020\u00052\u0006\u00103\u001a\u00020\u00052\u0006\u00104\u001a\u00020\u00052\u0006\u00105\u001a\u00020\u00052\u0006\u00106\u001a\u00020\u00052\u0006\u00107\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u00052\u0006\u00109\u001a\u00020\u0005JF\u0010:\u001a\u00020(2\u0006\u00102\u001a\u00020\u00052\u0006\u00103\u001a\u00020\u00052\u0006\u00104\u001a\u00020\u00052\u0006\u00105\u001a\u00020\u00052\u0006\u00106\u001a\u00020\u00052\u0006\u00107\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u00052\u0006\u00109\u001a\u00020\u0005JF\u0010;\u001a\u00020(2\u0006\u00102\u001a\u00020\u00052\u0006\u00103\u001a\u00020\u00052\u0006\u00104\u001a\u00020\u00052\u0006\u00105\u001a\u00020\u00052\u0006\u00106\u001a\u00020\u00052\u0006\u00107\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u00052\u0006\u00109\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u000e\u0010\u0012\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lorg/gnit/lucenekmp/geo/GeoUtils;", "", "<init>", "()V", "MIN_LON_INCL", "", "MAX_LON_INCL", "MIN_LAT_INCL", "MAX_LAT_INCL", "MIN_LON_RADIANS", "getMIN_LON_RADIANS", "()D", "MIN_LAT_RADIANS", "getMIN_LAT_RADIANS", "MAX_LON_RADIANS", "getMAX_LON_RADIANS", "MAX_LAT_RADIANS", "getMAX_LAT_RADIANS", "EARTH_MEAN_RADIUS_METERS", "checkLatitude", "", "latitude", "checkLongitude", "longitude", "PIO2", "sloppySin", "a", "distanceQuerySortKey", "radius", "relate", "Lorg/gnit/lucenekmp/index/PointValues$Relation;", "minLat", "maxLat", "minLon", "maxLon", "lat", "lon", "distanceSortKey", "axisLat", "within90LonDegrees", "", "orient", "", "ax", "ay", "bx", "by", "cx", "cy", "lineCrossesLine", "a1x", "a1y", "b1x", "b1y", "a2x", "a2y", "b2x", "b2y", "lineOverlapLine", "lineCrossesLineWithBoundary", "WindingOrder", "core"})
@SourceDebugExtension(value={"SMAP\nGeoUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeoUtils.kt\norg/gnit/lucenekmp/geo/GeoUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,323:1\n1#2:324\n*E\n"})
public final class GeoUtils {
    @NotNull
    public static final GeoUtils INSTANCE = new GeoUtils();
    public static final double MIN_LON_INCL = -180.0;
    public static final double MAX_LON_INCL = 180.0;
    public static final double MIN_LAT_INCL = -90.0;
    public static final double MAX_LAT_INCL = 90.0;
    private static final double MIN_LON_RADIANS = Math.INSTANCE.toRadians(-180.0);
    private static final double MIN_LAT_RADIANS = Math.INSTANCE.toRadians(-90.0);
    private static final double MAX_LON_RADIANS = Math.INSTANCE.toRadians(180.0);
    private static final double MAX_LAT_RADIANS = Math.INSTANCE.toRadians(90.0);
    public static final double EARTH_MEAN_RADIUS_METERS = 6371008.7714;
    private static final double PIO2 = 1.5707963267948966;

    private GeoUtils() {
    }

    public final double getMIN_LON_RADIANS() {
        return MIN_LON_RADIANS;
    }

    public final double getMIN_LAT_RADIANS() {
        return MIN_LAT_RADIANS;
    }

    public final double getMAX_LON_RADIANS() {
        return MAX_LON_RADIANS;
    }

    public final double getMAX_LAT_RADIANS() {
        return MAX_LAT_RADIANS;
    }

    public final void checkLatitude(double latitude) {
        if (!(!DoubleExtKt.isNaN(DoubleCompanionObject.INSTANCE, latitude) && !(latitude < -90.0) && !(latitude > 90.0))) {
            boolean bl = false;
            String string = "invalid latitude " + latitude + "; must be between -90.0 and 90.0";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final void checkLongitude(double longitude) {
        if (!(!DoubleExtKt.isNaN(DoubleCompanionObject.INSTANCE, longitude) && !(longitude < -180.0) && !(longitude > 180.0))) {
            boolean bl = false;
            String string = "invalid longitude " + longitude + "; must be between -180.0 and 180.0";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final double sloppySin(double a) {
        return SloppyMath.INSTANCE.cos(a - 1.5707963267948966);
    }

    public final double distanceQuerySortKey(double radius) {
        if (radius >= SloppyMath.INSTANCE.haversinMeters(Double.MAX_VALUE)) {
            return SloppyMath.INSTANCE.haversinMeters(Double.MAX_VALUE);
        }
        long lo = 0L;
        long hi = DoubleExtKt.doubleToRawLongBits(DoubleCompanionObject.INSTANCE, Double.MAX_VALUE);
        while (lo <= hi) {
            long mid = lo + hi >>> 1;
            double sortKey = DoubleExtKt.longBitsToDouble(DoubleCompanionObject.INSTANCE, mid);
            double midRadius = SloppyMath.INSTANCE.haversinMeters(sortKey);
            if (midRadius == radius) {
                return sortKey;
            }
            if (midRadius > radius) {
                hi = mid - 1L;
                continue;
            }
            lo = mid + 1L;
        }
        double ceil = DoubleExtKt.longBitsToDouble(DoubleCompanionObject.INSTANCE, lo);
        if (!(SloppyMath.INSTANCE.haversinMeters(ceil) > radius)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return ceil;
    }

    @NotNull
    public final PointValues.Relation relate(double minLat, double maxLat, double minLon, double maxLon, double lat, double lon, double distanceSortKey, double axisLat) {
        if (!(!(minLon > maxLon))) {
            boolean bl = false;
            String string = "Box crosses the dateline";
            throw new IllegalArgumentException(string.toString());
        }
        if ((lon < minLon || lon > maxLon) && (axisLat + Rectangle.Companion.getAXISLAT_ERROR() < minLat || axisLat - Rectangle.Companion.getAXISLAT_ERROR() > maxLat) && SloppyMath.INSTANCE.haversinSortKey(lat, lon, minLat, minLon) > distanceSortKey && SloppyMath.INSTANCE.haversinSortKey(lat, lon, minLat, maxLon) > distanceSortKey && SloppyMath.INSTANCE.haversinSortKey(lat, lon, maxLat, minLon) > distanceSortKey && SloppyMath.INSTANCE.haversinSortKey(lat, lon, maxLat, maxLon) > distanceSortKey) {
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
        if (this.within90LonDegrees(lon, minLon, maxLon) && SloppyMath.INSTANCE.haversinSortKey(lat, lon, minLat, minLon) <= distanceSortKey && SloppyMath.INSTANCE.haversinSortKey(lat, lon, minLat, maxLon) <= distanceSortKey && SloppyMath.INSTANCE.haversinSortKey(lat, lon, maxLat, minLon) <= distanceSortKey && SloppyMath.INSTANCE.haversinSortKey(lat, lon, maxLat, maxLon) <= distanceSortKey) {
            return PointValues.Relation.CELL_INSIDE_QUERY;
        }
        return PointValues.Relation.CELL_CROSSES_QUERY;
    }

    public final boolean within90LonDegrees(double lon, double minLon, double maxLon) {
        double lon2 = lon;
        if (maxLon <= lon2 - (double)180) {
            lon2 -= 360.0;
        } else if (minLon >= lon2 + (double)180) {
            lon2 += 360.0;
        }
        return maxLon - lon2 < 90.0 && lon2 - minLon < 90.0;
    }

    public final int orient(double ax, double ay, double bx, double by, double cx, double cy) {
        double v1 = (bx - ax) * (cy - ay);
        double v2 = (cx - ax) * (by - ay);
        if (v1 > v2) {
            return 1;
        }
        if (v1 < v2) {
            return -1;
        }
        return 0;
    }

    public final boolean lineCrossesLine(double a1x, double a1y, double b1x, double b1y, double a2x, double a2y, double b2x, double b2y) {
        return this.orient(a2x, a2y, b2x, b2y, a1x, a1y) * this.orient(a2x, a2y, b2x, b2y, b1x, b1y) < 0 && this.orient(a1x, a1y, b1x, b1y, a2x, a2y) * this.orient(a1x, a1y, b1x, b1y, b2x, b2y) < 0;
    }

    public final boolean lineOverlapLine(double a1x, double a1y, double b1x, double b1y, double a2x, double a2y, double b2x, double b2y) {
        return this.orient(a2x, a2y, b2x, b2y, a1x, a1y) == 0 && this.orient(a2x, a2y, b2x, b2y, b1x, b1y) == 0 && this.orient(a1x, a1y, b1x, b1y, a2x, a2y) == 0 && this.orient(a1x, a1y, b1x, b1y, b2x, b2y) == 0;
    }

    public final boolean lineCrossesLineWithBoundary(double a1x, double a1y, double b1x, double b1y, double a2x, double a2y, double b2x, double b2y) {
        return this.orient(a2x, a2y, b2x, b2y, a1x, a1y) * this.orient(a2x, a2y, b2x, b2y, b1x, b1y) <= 0 && this.orient(a1x, a1y, b1x, b1y, a2x, a2y) * this.orient(a1x, a1y, b1x, b1y, b2x, b2y) <= 0;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u0000 \t2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\tB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0002\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\n"}, d2={"Lorg/gnit/lucenekmp/geo/GeoUtils$WindingOrder;", "", "sign", "", "<init>", "(Ljava/lang/String;II)V", "CW", "COLINEAR", "CCW", "Companion", "core"})
    public static final class WindingOrder
    extends Enum<WindingOrder> {
        @NotNull
        public static final Companion Companion;
        private final int sign;
        public static final /* enum */ WindingOrder CW;
        public static final /* enum */ WindingOrder COLINEAR;
        public static final /* enum */ WindingOrder CCW;
        private static final /* synthetic */ WindingOrder[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private WindingOrder(int sign) {
            this.sign = sign;
        }

        public final int sign() {
            return this.sign;
        }

        public static WindingOrder[] values() {
            return (WindingOrder[])$VALUES.clone();
        }

        public static WindingOrder valueOf(String value) {
            return Enum.valueOf(WindingOrder.class, value);
        }

        @NotNull
        public static EnumEntries<WindingOrder> getEntries() {
            return $ENTRIES;
        }

        static {
            CW = new WindingOrder(-1);
            COLINEAR = new WindingOrder(0);
            CCW = new WindingOrder(1);
            $VALUES = windingOrderArray = new WindingOrder[]{WindingOrder.CW, WindingOrder.COLINEAR, WindingOrder.CCW};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/gnit/lucenekmp/geo/GeoUtils$WindingOrder$Companion;", "", "<init>", "()V", "fromSign", "Lorg/gnit/lucenekmp/geo/GeoUtils$WindingOrder;", "sign", "", "core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final WindingOrder fromSign(int sign) {
                if (sign == CW.sign) {
                    return CW;
                }
                if (sign == COLINEAR.sign) {
                    return COLINEAR;
                }
                if (sign == CCW.sign) {
                    return CCW;
                }
                throw new IllegalArgumentException("Invalid WindingOrder sign: " + sign);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

