/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.geo;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.geo.Component2D;
import org.gnit.lucenekmp.geo.GeoEncodingUtils;
import org.gnit.lucenekmp.geo.GeoUtils;
import org.gnit.lucenekmp.geo.Point;
import org.gnit.lucenekmp.geo.XYPoint;
import org.gnit.lucenekmp.index.PointValues;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 '2\u00020\u0001:\u0001'B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016J(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0016JH\u0010\u0016\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0003H\u0016JX\u0010\u001b\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0003H\u0016JH\u0010\u001e\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0003H\u0016JX\u0010\u001f\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\u0018\u0010 \u001a\u00020!2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016JP\u0010\"\u001a\u00020!2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0003H\u0016Jp\u0010$\u001a\u00020!2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0014\u0010\n\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\bR\u0014\u0010\f\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\bR\u0014\u0010\u000e\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\bR\u0014\u0010\u0010\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\b\u00a8\u0006("}, d2={"Lorg/gnit/lucenekmp/geo/Point2D;", "Lorg/gnit/lucenekmp/geo/Component2D;", "x", "", "y", "<init>", "(DD)V", "getX", "()D", "getY", "minX", "getMinX", "maxX", "getMaxX", "minY", "getMinY", "maxY", "getMaxY", "contains", "", "relate", "Lorg/gnit/lucenekmp/index/PointValues$Relation;", "intersectsLine", "aX", "aY", "bX", "bY", "intersectsTriangle", "cX", "cY", "containsLine", "containsTriangle", "withinPoint", "Lorg/gnit/lucenekmp/geo/Component2D$WithinRelation;", "withinLine", "ab", "withinTriangle", "bc", "ca", "Companion", "core"})
public final class Point2D
implements Component2D {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double x;
    private final double y;

    private Point2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    @Override
    public double getMinX() {
        return this.x;
    }

    @Override
    public double getMaxX() {
        return this.x;
    }

    @Override
    public double getMinY() {
        return this.y;
    }

    @Override
    public double getMaxY() {
        return this.y;
    }

    @Override
    public boolean contains(double x, double y) {
        return x == this.x && y == this.y;
    }

    @Override
    @NotNull
    public PointValues.Relation relate(double minX, double maxX, double minY, double maxY) {
        if (Component2D.Companion.containsPoint(this.x, this.y, minX, maxX, minY, maxY)) {
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }
        return PointValues.Relation.CELL_OUTSIDE_QUERY;
    }

    @Override
    public boolean intersectsLine(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY) {
        return Component2D.Companion.containsPoint(this.x, this.y, minX, maxX, minY, maxY) && GeoUtils.INSTANCE.orient(aX, aY, bX, bY, this.x, this.y) == 0;
    }

    @Override
    public boolean intersectsTriangle(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY, double cX, double cY) {
        return Component2D.Companion.pointInTriangle(minX, maxX, minY, maxY, this.x, this.y, aX, aY, bX, bY, cX, cY);
    }

    @Override
    public boolean containsLine(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY) {
        return false;
    }

    @Override
    public boolean containsTriangle(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY, double cX, double cY) {
        return false;
    }

    @Override
    @NotNull
    public Component2D.WithinRelation withinPoint(double x, double y) {
        return this.contains(x, y) ? Component2D.WithinRelation.CANDIDATE : Component2D.WithinRelation.DISJOINT;
    }

    @Override
    @NotNull
    public Component2D.WithinRelation withinLine(double minX, double maxX, double minY, double maxY, double aX, double aY, boolean ab, double bX, double bY) {
        return this.intersectsLine(minX, maxX, minY, maxY, aX, aY, bX, bY) ? Component2D.WithinRelation.CANDIDATE : Component2D.WithinRelation.DISJOINT;
    }

    @Override
    @NotNull
    public Component2D.WithinRelation withinTriangle(double minX, double maxX, double minY, double maxY, double aX, double aY, boolean ab, double bX, double bY, boolean bc, double cX, double cY, boolean ca) {
        if (Component2D.Companion.pointInTriangle(minX, maxX, minY, maxY, this.x, this.y, aX, aY, bX, bY, cX, cY)) {
            return Component2D.WithinRelation.CANDIDATE;
        }
        return Component2D.WithinRelation.DISJOINT;
    }

    @Override
    public boolean intersectsLine(double aX, double aY, double bX, double bY) {
        return Component2D.super.intersectsLine(aX, aY, bX, bY);
    }

    @Override
    public boolean intersectsTriangle(double aX, double aY, double bX, double bY, double cX, double cY) {
        return Component2D.super.intersectsTriangle(aX, aY, bX, bY, cX, cY);
    }

    @Override
    public boolean containsLine(double aX, double aY, double bX, double bY) {
        return Component2D.super.containsLine(aX, aY, bX, bY);
    }

    @Override
    public boolean containsTriangle(double aX, double aY, double bX, double bY, double cX, double cY) {
        return Component2D.super.containsTriangle(aX, aY, bX, bY, cX, cY);
    }

    @Override
    @NotNull
    public Component2D.WithinRelation withinLine(double aX, double aY, boolean ab, double bX, double bY) {
        return Component2D.super.withinLine(aX, aY, ab, bX, bY);
    }

    @Override
    @NotNull
    public Component2D.WithinRelation withinTriangle(double aX, double aY, boolean ab, double bX, double bY, boolean bc, double cX, double cY, boolean ca) {
        return Component2D.super.withinTriangle(aX, aY, ab, bX, bY, bc, cX, cY, ca);
    }

    public /* synthetic */ Point2D(double x, double y, DefaultConstructorMarker $constructor_marker) {
        this(x, y);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/gnit/lucenekmp/geo/Point2D$Companion;", "", "<init>", "()V", "create", "Lorg/gnit/lucenekmp/geo/Component2D;", "point", "Lorg/gnit/lucenekmp/geo/Point;", "xyPoint", "Lorg/gnit/lucenekmp/geo/XYPoint;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Component2D create(@NotNull Point point) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            double qLat = point.getLat() == 90.0 ? point.getLat() : GeoEncodingUtils.INSTANCE.decodeLatitude(GeoEncodingUtils.INSTANCE.encodeLatitudeCeil(point.getLat()));
            double qLon = point.getLon() == 180.0 ? point.getLon() : GeoEncodingUtils.INSTANCE.decodeLongitude(GeoEncodingUtils.INSTANCE.encodeLongitudeCeil(point.getLon()));
            return new Point2D(qLon, qLat, null);
        }

        @NotNull
        public final Component2D create(@NotNull XYPoint xyPoint) {
            Intrinsics.checkNotNullParameter((Object)xyPoint, (String)"xyPoint");
            return new Point2D(xyPoint.getX(), xyPoint.getY(), null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

