/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.geo;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.geo.Component2D;
import org.gnit.lucenekmp.geo.ComponentTree;
import org.gnit.lucenekmp.geo.GeoEncodingUtils;
import org.gnit.lucenekmp.geo.GeoUtils;
import org.gnit.lucenekmp.geo.Rectangle;
import org.gnit.lucenekmp.geo.XYRectangle;
import org.gnit.lucenekmp.index.PointValues;
import org.gnit.lucenekmp.jdkport.DoubleExtKt;
import org.gnit.lucenekmp.jdkport.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 -2\u00020\u0001:\u0001-B)\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003H\u0016JH\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003H\u0016JX\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0003H\u0016JH\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003H\u0016JX\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0003H\u0016J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0016JP\u0010 \u001a\u00020\u001f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003H\u0016Jp\u0010\"\u001a\u00020\u001f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u000fH\u0016J(\u0010%\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\u0013\u0010&\u001a\u00020\u000f2\b\u0010'\u001a\u0004\u0018\u00010(H\u0096\u0002J\b\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020,H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006."}, d2={"Lorg/gnit/lucenekmp/geo/Rectangle2D;", "Lorg/gnit/lucenekmp/geo/Component2D;", "minX", "", "maxX", "minY", "maxY", "<init>", "(DDDD)V", "getMinX", "()D", "getMaxX", "getMinY", "getMaxY", "contains", "", "x", "y", "relate", "Lorg/gnit/lucenekmp/index/PointValues$Relation;", "intersectsLine", "aX", "aY", "bX", "bY", "intersectsTriangle", "cX", "cY", "containsLine", "containsTriangle", "withinPoint", "Lorg/gnit/lucenekmp/geo/Component2D$WithinRelation;", "withinLine", "ab", "withinTriangle", "bc", "ca", "edgesIntersect", "equals", "o", "", "hashCode", "", "toString", "", "Companion", "core"})
public final class Rectangle2D
implements Component2D {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double minX;
    private final double maxX;
    private final double minY;
    private final double maxY;
    private static final double MIN_LON_INCL_QUANTIZE = GeoEncodingUtils.INSTANCE.decodeLongitude(GeoEncodingUtils.INSTANCE.getMIN_LON_ENCODED());
    private static final double MAX_LON_INCL_QUANTIZE = GeoEncodingUtils.INSTANCE.decodeLongitude(GeoEncodingUtils.INSTANCE.getMAX_LON_ENCODED());

    private Rectangle2D(double minX, double maxX, double minY, double maxY) {
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
    }

    @Override
    public double getMinX() {
        return this.minX;
    }

    @Override
    public double getMaxX() {
        return this.maxX;
    }

    @Override
    public double getMinY() {
        return this.minY;
    }

    @Override
    public double getMaxY() {
        return this.maxY;
    }

    @Override
    public boolean contains(double x, double y) {
        return Component2D.Companion.containsPoint(x, y, this.getMinX(), this.getMaxX(), this.getMinY(), this.getMaxY());
    }

    @Override
    @NotNull
    public PointValues.Relation relate(double minX, double maxX, double minY, double maxY) {
        if (Component2D.Companion.disjoint(this.getMinX(), this.getMaxX(), this.getMinY(), this.getMaxY(), minX, maxX, minY, maxY)) {
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
        if (Component2D.Companion.within(minX, maxX, minY, maxY, this.getMinX(), this.getMaxX(), this.getMinY(), this.getMaxY())) {
            return PointValues.Relation.CELL_INSIDE_QUERY;
        }
        return PointValues.Relation.CELL_CROSSES_QUERY;
    }

    @Override
    public boolean intersectsLine(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY) {
        if (Component2D.Companion.disjoint(this.getMinX(), this.getMaxX(), this.getMinY(), this.getMaxY(), minX, maxX, minY, maxY)) {
            return false;
        }
        return this.contains(aX, aY) || this.contains(bX, bY) || this.edgesIntersect(aX, aY, bX, bY);
    }

    @Override
    public boolean intersectsTriangle(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY, double cX, double cY) {
        if (Component2D.Companion.disjoint(this.getMinX(), this.getMaxX(), this.getMinY(), this.getMaxY(), minX, maxX, minY, maxY)) {
            return false;
        }
        return this.contains(aX, aY) || this.contains(bX, bY) || this.contains(cX, cY) || Component2D.Companion.pointInTriangle(minX, maxX, minY, maxY, this.getMinX(), this.getMinY(), aX, aY, bX, bY, cX, cY) || this.edgesIntersect(aX, aY, bX, bY) || this.edgesIntersect(bX, bY, cX, cY) || this.edgesIntersect(cX, cY, aX, aY);
    }

    @Override
    public boolean containsLine(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY) {
        return Component2D.Companion.within(minX, maxX, minY, maxY, this.getMinX(), this.getMaxX(), this.getMinY(), this.getMaxY());
    }

    @Override
    public boolean containsTriangle(double minX, double maxX, double minY, double maxY, double aX, double aY, double bX, double bY, double cX, double cY) {
        return Component2D.Companion.within(minX, maxX, minY, maxY, this.getMinX(), this.getMaxX(), this.getMinY(), this.getMaxY());
    }

    @Override
    @NotNull
    public Component2D.WithinRelation withinPoint(double x, double y) {
        return this.contains(x, y) ? Component2D.WithinRelation.NOTWITHIN : Component2D.WithinRelation.DISJOINT;
    }

    @Override
    @NotNull
    public Component2D.WithinRelation withinLine(double minX, double maxX, double minY, double maxY, double aX, double aY, boolean ab, double bX, double bY) {
        if (Component2D.Companion.disjoint(this.getMinX(), this.getMaxX(), this.getMinY(), this.getMaxY(), minX, maxX, minY, maxY)) {
            return Component2D.WithinRelation.DISJOINT;
        }
        if (this.contains(aX, aY) || this.contains(bX, bY)) {
            return Component2D.WithinRelation.NOTWITHIN;
        }
        if (ab && this.edgesIntersect(aX, aY, bX, bY)) {
            return Component2D.WithinRelation.NOTWITHIN;
        }
        return Component2D.WithinRelation.DISJOINT;
    }

    @Override
    @NotNull
    public Component2D.WithinRelation withinTriangle(double minX, double maxX, double minY, double maxY, double aX, double aY, boolean ab, double bX, double bY, boolean bc, double cX, double cY, boolean ca) {
        if (Component2D.Companion.disjoint(this.getMinX(), this.getMaxX(), this.getMinY(), this.getMaxY(), minX, maxX, minY, maxY)) {
            return Component2D.WithinRelation.DISJOINT;
        }
        if (this.contains(aX, aY) || this.contains(bX, bY) || this.contains(cX, cY)) {
            return Component2D.WithinRelation.NOTWITHIN;
        }
        Component2D.WithinRelation relation = Component2D.WithinRelation.DISJOINT;
        if (this.edgesIntersect(aX, aY, bX, bY)) {
            if (ab) {
                return Component2D.WithinRelation.NOTWITHIN;
            }
            relation = Component2D.WithinRelation.CANDIDATE;
        }
        if (this.edgesIntersect(bX, bY, cX, cY)) {
            if (bc) {
                return Component2D.WithinRelation.NOTWITHIN;
            }
            relation = Component2D.WithinRelation.CANDIDATE;
        }
        if (this.edgesIntersect(cX, cY, aX, aY)) {
            if (ca) {
                return Component2D.WithinRelation.NOTWITHIN;
            }
            relation = Component2D.WithinRelation.CANDIDATE;
        }
        if (relation == Component2D.WithinRelation.CANDIDATE) {
            return Component2D.WithinRelation.CANDIDATE;
        }
        if (Component2D.Companion.pointInTriangle(minX, maxX, minY, maxY, this.getMinX(), this.getMinY(), aX, aY, bX, bY, cX, cY)) {
            return Component2D.WithinRelation.CANDIDATE;
        }
        return relation;
    }

    private final boolean edgesIntersect(double aX, double aY, double bX, double bY) {
        if (Math.max(aX, bX) < this.getMinX() || Math.min(aX, bX) > this.getMaxX() || Math.min(aY, bY) > this.getMaxY() || Math.max(aY, bY) < this.getMinY()) {
            return false;
        }
        return GeoUtils.INSTANCE.lineCrossesLineWithBoundary(aX, aY, bX, bY, this.getMinX(), this.getMaxY(), this.getMaxX(), this.getMaxY()) || GeoUtils.INSTANCE.lineCrossesLineWithBoundary(aX, aY, bX, bY, this.getMaxX(), this.getMaxY(), this.getMaxX(), this.getMinY()) || GeoUtils.INSTANCE.lineCrossesLineWithBoundary(aX, aY, bX, bY, this.getMaxX(), this.getMinY(), this.getMinX(), this.getMinY()) || GeoUtils.INSTANCE.lineCrossesLineWithBoundary(aX, aY, bX, bY, this.getMinX(), this.getMinY(), this.getMinX(), this.getMaxY());
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Rectangle2D)) {
            return false;
        }
        Object that = o;
        return DoubleExtKt.compare(DoubleCompanionObject.INSTANCE, this.getMinX(), ((Rectangle2D)that).getMinX()) == 0 && DoubleExtKt.compare(DoubleCompanionObject.INSTANCE, this.getMaxX(), ((Rectangle2D)that).getMaxX()) == 0 && DoubleExtKt.compare(DoubleCompanionObject.INSTANCE, this.getMinY(), ((Rectangle2D)that).getMinY()) == 0 && DoubleExtKt.compare(DoubleCompanionObject.INSTANCE, this.getMaxY(), ((Rectangle2D)that).getMaxY()) == 0;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.getMinX(), this.getMaxX(), this.getMinY(), this.getMaxY()};
        int result = Objects.INSTANCE.hash(objectArray);
        return result;
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Rectangle2D(x=");
        sb.append(this.getMinX());
        sb.append(" TO ");
        sb.append(this.getMaxX());
        sb.append(" y=");
        sb.append(this.getMinY());
        sb.append(" TO ");
        sb.append(this.getMaxY());
        sb.append(")");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    public boolean intersectsLine(double aX, double aY, double bX, double bY) {
        return Component2D.super.intersectsLine(aX, aY, bX, bY);
    }

    @Override
    public boolean intersectsTriangle(double aX, double aY, double bX, double bY, double cX, double cY) {
        return Component2D.super.intersectsTriangle(aX, aY, bX, bY, cX, cY);
    }

    @Override
    public boolean containsLine(double aX, double aY, double bX, double bY) {
        return Component2D.super.containsLine(aX, aY, bX, bY);
    }

    @Override
    public boolean containsTriangle(double aX, double aY, double bX, double bY, double cX, double cY) {
        return Component2D.super.containsTriangle(aX, aY, bX, bY, cX, cY);
    }

    @Override
    @NotNull
    public Component2D.WithinRelation withinLine(double aX, double aY, boolean ab, double bX, double bY) {
        return Component2D.super.withinLine(aX, aY, ab, bX, bY);
    }

    @Override
    @NotNull
    public Component2D.WithinRelation withinTriangle(double aX, double aY, boolean ab, double bX, double bY, boolean bc, double cX, double cY, boolean ca) {
        return Component2D.super.withinTriangle(aX, aY, ab, bX, bY, bc, cX, cY, ca);
    }

    public /* synthetic */ Rectangle2D(double minX, double maxX, double minY, double maxY, DefaultConstructorMarker $constructor_marker) {
        this(minX, maxX, minY, maxY);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000bR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/geo/Rectangle2D$Companion;", "", "<init>", "()V", "create", "Lorg/gnit/lucenekmp/geo/Component2D;", "rectangle", "Lorg/gnit/lucenekmp/geo/XYRectangle;", "MIN_LON_INCL_QUANTIZE", "", "MAX_LON_INCL_QUANTIZE", "Lorg/gnit/lucenekmp/geo/Rectangle;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Component2D create(@NotNull XYRectangle rectangle) {
            Intrinsics.checkNotNullParameter((Object)rectangle, (String)"rectangle");
            return new Rectangle2D(rectangle.getMinX(), rectangle.getMaxX(), rectangle.getMinY(), rectangle.getMaxY(), null);
        }

        @NotNull
        public final Component2D create(@NotNull Rectangle rectangle) {
            Intrinsics.checkNotNullParameter((Object)rectangle, (String)"rectangle");
            double minLongitude = rectangle.getMinLon();
            boolean crossesDateline = rectangle.getMinLon() > rectangle.getMaxLon();
            if (minLongitude == 180.0 && crossesDateline) {
                minLongitude = -180.0;
                crossesDateline = false;
            }
            double qMinLat = GeoEncodingUtils.INSTANCE.decodeLatitude(GeoEncodingUtils.INSTANCE.encodeLatitudeCeil(rectangle.getMinLat()));
            double qMaxLat = GeoEncodingUtils.INSTANCE.decodeLatitude(GeoEncodingUtils.INSTANCE.encodeLatitude(rectangle.getMaxLat()));
            double qMinLon = GeoEncodingUtils.INSTANCE.decodeLongitude(GeoEncodingUtils.INSTANCE.encodeLongitudeCeil(minLongitude));
            double qMaxLon = GeoEncodingUtils.INSTANCE.decodeLongitude(GeoEncodingUtils.INSTANCE.encodeLongitude(rectangle.getMaxLon()));
            if (crossesDateline) {
                Component2D[] component2DArray = new Component2D[]{new Rectangle2D(MIN_LON_INCL_QUANTIZE, qMaxLon, qMinLat, qMaxLat, null), new Rectangle2D(qMinLon, MAX_LON_INCL_QUANTIZE, qMinLat, qMaxLat, null)};
                Component2D[] components = component2DArray;
                return ComponentTree.Companion.create(components);
            }
            return new Rectangle2D(qMinLon, qMaxLon, qMinLat, qMaxLat, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

