/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.geo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.gnit.lucenekmp.geo.Polygon;
import org.gnit.lucenekmp.jdkport.ParseException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\u0004\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 '2\u00020\u0001:\u0001'B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u0003H\u0002J\u0016\u0010\u0016\u001a\u00020\u000f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\fH\u0002J!\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u000e2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00010\fH\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0018\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\f2\u0006\u0010\u0013\u001a\u00020\u0003H\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u0003H\u0002J\b\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020 H\u0002J\b\u0010#\u001a\u00020\u0012H\u0002J\u0010\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u0003H\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/gnit/lucenekmp/geo/SimpleGeoJSONPolygonParser;", "", "input", "", "<init>", "(Ljava/lang/String;)V", "getInput", "()Ljava/lang/String;", "upto", "", "polyType", "coordinates", "", "parse", "", "Lorg/gnit/lucenekmp/geo/Polygon;", "()[Lorg/gnit/lucenekmp/geo/Polygon;", "parseObject", "", "path", "isValidGeometryPath", "", "parsePolygon", "parsePoints", "", "o", "(Ljava/util/List;)[[D", "parseArray", "parseNumber", "", "parseString", "peek", "", "scan", "expected", "readEnd", "newParseException", "Lorg/gnit/lucenekmp/jdkport/ParseException;", "details", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nSimpleGeoJSONPolygonParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleGeoJSONPolygonParser.kt\norg/gnit/lucenekmp/geo/SimpleGeoJSONPolygonParser\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,471:1\n37#2:472\n36#2,3:473\n37#2:476\n36#2,3:477\n*S KotlinDebug\n*F\n+ 1 SimpleGeoJSONPolygonParser.kt\norg/gnit/lucenekmp/geo/SimpleGeoJSONPolygonParser\n*L\n74#1:472\n74#1:473,3\n231#1:476\n231#1:477,3\n*E\n"})
public final class SimpleGeoJSONPolygonParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String input;
    private int upto;
    @Nullable
    private String polyType;
    @Nullable
    private List<Object> coordinates;

    public SimpleGeoJSONPolygonParser(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.input = input;
    }

    @NotNull
    public final String getInput() {
        return this.input;
    }

    @NotNull
    public final Polygon[] parse() throws ParseException {
        this.parseObject("");
        this.readEnd();
        if (this.coordinates == null) {
            throw this.newParseException("did not see any polygon coordinates");
        }
        if (this.polyType == null) {
            throw this.newParseException("did not see type: Polygon or MultiPolygon");
        }
        if (Intrinsics.areEqual((Object)this.polyType, (Object)"Polygon")) {
            Polygon[] polygonArray = new Polygon[1];
            List<Object> list = this.coordinates;
            Intrinsics.checkNotNull(list);
            polygonArray[0] = this.parsePolygon(list);
            return polygonArray;
        }
        List polygons = new ArrayList();
        List<Object> list = this.coordinates;
        Intrinsics.checkNotNull(list);
        int n = ((Collection)list).size();
        for (int i = 0; i < n; ++i) {
            List<Object> list2 = this.coordinates;
            Intrinsics.checkNotNull(list2);
            Object o = list2.get(i);
            if (!TypeIntrinsics.isMutableList((Object)o)) {
                throw this.newParseException("elements of coordinates array should be an array, but got: " + Reflection.getOrCreateKotlinClass(o.getClass()).getQualifiedName());
            }
            Object object = o;
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.Any>");
            polygons.add(this.parsePolygon(TypeIntrinsics.asMutableList((Object)object)));
        }
        Collection $this$toTypedArray$iv = polygons;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Polygon[0]);
    }

    private final void parseObject(String path) throws ParseException {
        char ch;
        this.scan('{');
        boolean first = true;
        while ((ch = this.peek()) != '}') {
            if (!first) {
                if (ch == ',') {
                    int n = this.upto;
                    this.upto = n + 1;
                    ch = this.peek();
                    if (ch == '}') {
                        break;
                    }
                } else {
                    throw this.newParseException("expected , but got " + ch);
                }
            }
            first = false;
            int uptoStart = this.upto;
            String key = this.parseString();
            if (Intrinsics.areEqual((Object)path, (Object)"crs.properties") && Intrinsics.areEqual((Object)key, (Object)"href")) {
                this.upto = uptoStart;
                throw this.newParseException("cannot handle linked crs");
            }
            this.scan(':');
            Object o = null;
            ch = this.peek();
            uptoStart = this.upto;
            if (ch == '[') {
                newPath = ((CharSequence)path).length() == 0 ? key : path + "." + key;
                o = this.parseArray(newPath);
            } else if (ch == '{') {
                newPath = ((CharSequence)path).length() == 0 ? key : path + "." + key;
                this.parseObject(newPath);
                o = null;
            } else if (ch == '\"') {
                o = this.parseString();
            } else if (ch == 't') {
                this.scan("true");
                o = true;
            } else if (ch == 'f') {
                o = false;
                this.scan("false");
            } else if (ch == 'n') {
                this.scan("null");
                o = null;
            } else if (ch == '-' || ch == '.' || Intrinsics.compare((int)ch, (int)48) >= 0 && Intrinsics.compare((int)ch, (int)57) <= 0) {
                o = this.parseNumber();
            } else {
                if (ch == '}') break;
                throw this.newParseException("expected array, object, string or literal value, but got: " + ch);
            }
            if (Intrinsics.areEqual((Object)path, (Object)"crs.properties") && Intrinsics.areEqual((Object)key, (Object)"name")) {
                if (!(o instanceof String)) {
                    this.upto = uptoStart;
                    throw this.newParseException("crs.properties.name should be a string, but saw: " + o);
                }
                Object crs = o;
                if (!StringsKt.startsWith$default((String)((String)crs), (String)"urn:ogc:def:crs:OGC", (boolean)false, (int)2, null) || !StringsKt.endsWith$default((String)((String)crs), (String)":CRS84", (boolean)false, (int)2, null)) {
                    this.upto = uptoStart;
                    throw this.newParseException("crs must be CRS84 from OGC, but saw: " + o);
                }
            }
            if (Intrinsics.areEqual((Object)key, (Object)"type") && !StringsKt.startsWith$default((String)path, (String)"crs", (boolean)false, (int)2, null)) {
                if (!(o instanceof String)) {
                    this.upto = uptoStart;
                    throw this.newParseException("type should be a string, but got: " + o);
                }
                Object type = o;
                if (Intrinsics.areEqual((Object)type, (Object)"Polygon") && this.isValidGeometryPath(path)) {
                    this.polyType = "Polygon";
                    continue;
                }
                if (Intrinsics.areEqual((Object)type, (Object)"MultiPolygon") && this.isValidGeometryPath(path)) {
                    this.polyType = "MultiPolygon";
                    continue;
                }
                if (!(!Intrinsics.areEqual((Object)type, (Object)"FeatureCollection") && !Intrinsics.areEqual((Object)type, (Object)"Feature") || !Intrinsics.areEqual((Object)path, (Object)"features.[]") && !(((CharSequence)path).length() == 0))) continue;
                this.upto = uptoStart;
                throw this.newParseException("can only handle type FeatureCollection (if it has a single polygon geometry), Feature, Polygon or MultiPolygon, but got " + type);
            }
            if (!Intrinsics.areEqual((Object)key, (Object)"coordinates") || !this.isValidGeometryPath(path)) continue;
            if (!TypeIntrinsics.isMutableList((Object)o)) {
                this.upto = uptoStart;
                Object object = o;
                Intrinsics.checkNotNull((Object)object);
                throw this.newParseException("coordinates should be an array, but got: " + Reflection.getOrCreateKotlinClass(object.getClass()).getQualifiedName());
            }
            if (this.coordinates != null) {
                this.upto = uptoStart;
                throw this.newParseException("only one Polygon or MultiPolygon is supported");
            }
            Object object = o;
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.Any>");
            this.coordinates = TypeIntrinsics.asMutableList((Object)object);
        }
        this.scan('}');
    }

    private final boolean isValidGeometryPath(String path) {
        return ((CharSequence)path).length() == 0 || Intrinsics.areEqual((Object)path, (Object)"geometry") || Intrinsics.areEqual((Object)path, (Object)"features.[].geometry");
    }

    private final Polygon parsePolygon(List<Object> coordinates) throws ParseException {
        List holes = new ArrayList();
        Object o = coordinates.get(0);
        if (!TypeIntrinsics.isMutableList((Object)o)) {
            throw this.newParseException("first element of polygon array must be an array [[lat, lon], [lat, lon] ...] but got: " + o);
        }
        Object object = o;
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.Any>");
        double[][] polyPoints = this.parsePoints(TypeIntrinsics.asMutableList((Object)object));
        int n = coordinates.size();
        for (int i = 1; i < n; ++i) {
            o = coordinates.get(i);
            if (!TypeIntrinsics.isMutableList((Object)o)) {
                throw this.newParseException("elements of coordinates array must be an array [[lat, lon], [lat, lon] ...] but got: " + o);
            }
            Object object2 = o;
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.Any>");
            double[][] holePoints = this.parsePoints(TypeIntrinsics.asMutableList((Object)object2));
            holes.add(new Polygon(holePoints[0], holePoints[1], new Polygon[0]));
        }
        Collection $this$toTypedArray$iv = holes;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Polygon[] polygonArray = thisCollection$iv.toArray(new Polygon[0]);
        return new Polygon(polyPoints[0], polyPoints[1], Arrays.copyOf(polygonArray, polygonArray.length));
    }

    private final double[][] parsePoints(List<Object> o) throws ParseException {
        double[] lats = new double[o.size()];
        double[] lons = new double[o.size()];
        int n = ((Collection)o).size();
        for (int i = 0; i < n; ++i) {
            Object point = o.get(i);
            if (!TypeIntrinsics.isMutableList((Object)point)) {
                throw this.newParseException("elements of coordinates array must [lat, lon] array, but got: " + point);
            }
            Object object = point;
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.MutableList<kotlin.Any>");
            List pointList = TypeIntrinsics.asMutableList((Object)object);
            if (pointList.size() != 2) {
                throw this.newParseException("elements of coordinates array must [lat, lon] array, but got wrong element count: " + pointList);
            }
            if (!(pointList.get(0) instanceof Double)) {
                throw this.newParseException("elements of coordinates array must [lat, lon] array, but first element is not a Double: " + pointList.get(0));
            }
            if (!(pointList.get(1) instanceof Double)) {
                throw this.newParseException("elements of coordinates array must [lat, lon] array, but second element is not a Double: " + pointList.get(1));
            }
            Object e = pointList.get(0);
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.Double");
            lons[i] = (Double)e;
            Object e2 = pointList.get(1);
            Intrinsics.checkNotNull(e2, (String)"null cannot be cast to non-null type kotlin.Double");
            lats[i] = (Double)e2;
        }
        double[][] dArrayArray = new double[][]{lats, lons};
        return dArrayArray;
    }

    private final List<Object> parseArray(String path) throws ParseException {
        List result = new ArrayList();
        this.scan('[');
        while (this.upto < this.input.length()) {
            char ch = this.peek();
            if (ch == ']') {
                this.scan(']');
                return result;
            }
            if (!((Collection)result).isEmpty()) {
                if (ch != ',') {
                    throw this.newParseException("expected ',' separating list items, but got '" + ch + "'");
                }
                int n = this.upto;
                this.upto = n + 1;
                if (this.upto == this.input.length()) {
                    throw this.newParseException("hit EOF while parsing array");
                }
                ch = this.peek();
            }
            Object o = null;
            if (ch == '[') {
                o = this.parseArray(path + ".[]");
            } else if (ch == '{') {
                this.parseObject(path + ".[]");
                o = null;
            } else if (ch == '-' || ch == '.' || Intrinsics.compare((int)ch, (int)48) >= 0 && Intrinsics.compare((int)ch, (int)57) <= 0) {
                o = this.parseNumber();
            } else if (ch == '\"') {
                o = this.parseString();
            } else {
                throw this.newParseException("expected another array or number while parsing array, not '" + ch + "'");
            }
            result.add(o);
        }
        throw this.newParseException("hit EOF while reading array");
    }

    private final Number parseNumber() throws ParseException {
        char ch;
        StringBuilder b = new StringBuilder();
        int uptoStart = this.upto;
        while (this.upto < this.input.length() && ((ch = this.input.charAt(this.upto)) == '-' || ch == '.' || Intrinsics.compare((int)ch, (int)48) >= 0 && Intrinsics.compare((int)ch, (int)57) <= 0 || ch == 'e' || ch == 'E')) {
            int n = this.upto;
            this.upto = n + 1;
            b.append(ch);
        }
        try {
            String string = b.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return Double.parseDouble(string);
        }
        catch (NumberFormatException nfe) {
            this.upto = uptoStart;
            throw this.newParseException("could not parse number as double");
        }
    }

    private final String parseString() throws ParseException {
        this.scan('\"');
        StringBuilder b = new StringBuilder();
        block4: while (this.upto < this.input.length()) {
            Comparable<Integer> comparable;
            int n;
            char ch = this.input.charAt(this.upto);
            if (ch == '\"') {
                n = this.upto;
                this.upto = n + 1;
                String string = b.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                return string;
            }
            if (ch == '\\') {
                n = this.upto;
                this.upto = n + 1;
                if (this.upto == this.input.length()) {
                    throw this.newParseException("hit EOF inside string literal");
                }
                ch = this.input.charAt(this.upto);
                switch (ch) {
                    case 'u': {
                        int n2 = this.upto;
                        this.upto = n2 + 1;
                        if (this.upto + 4 > this.input.length()) {
                            throw this.newParseException("hit EOF inside string literal");
                        }
                        String string = this.input.substring(this.upto, this.upto + 4);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        comparable = b.append(Integer.parseInt(string, CharsKt.checkRadix((int)16)));
                        continue block4;
                    }
                    case '\\': {
                        b.append('\\');
                        int n2 = this.upto;
                        this.upto = n2 + 1;
                        comparable = n2;
                        continue block4;
                    }
                    default: {
                        throw this.newParseException("unsupported string escape character \\" + ch);
                    }
                }
            }
            b.append(ch);
            n = this.upto;
            this.upto = n + 1;
            comparable = n;
        }
        throw this.newParseException("hit EOF inside string literal");
    }

    private final char peek() throws ParseException {
        while (this.upto < this.input.length()) {
            char ch = this.input.charAt(this.upto);
            if (SimpleGeoJSONPolygonParser.Companion.isJSONWhitespace(ch)) {
                int n = this.upto;
                this.upto = n + 1;
                continue;
            }
            return ch;
        }
        throw this.newParseException("unexpected EOF");
    }

    private final void scan(char expected) throws ParseException {
        while (this.upto < this.input.length()) {
            int n;
            char ch = this.input.charAt(this.upto);
            if (SimpleGeoJSONPolygonParser.Companion.isJSONWhitespace(ch)) {
                n = this.upto;
                this.upto = n + 1;
                continue;
            }
            if (ch != expected) {
                throw this.newParseException("expected '" + expected + "' but got '" + ch + "'");
            }
            n = this.upto;
            this.upto = n + 1;
            return;
        }
        throw this.newParseException("expected '" + expected + "' but got EOF");
    }

    private final void readEnd() throws ParseException {
        while (this.upto < this.input.length()) {
            char ch = this.input.charAt(this.upto);
            if (!SimpleGeoJSONPolygonParser.Companion.isJSONWhitespace(ch)) {
                throw this.newParseException("unexpected character '" + ch + "' after end of GeoJSON object");
            }
            int n = this.upto;
            this.upto = n + 1;
        }
    }

    private final void scan(String expected) throws ParseException {
        if (this.upto + expected.length() > this.input.length()) {
            throw this.newParseException("expected \"" + expected + "\" but hit EOF");
        }
        String string = this.input.substring(this.upto, this.upto + expected.length());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String subString = string;
        if (!Intrinsics.areEqual((Object)subString, (Object)expected)) {
            throw this.newParseException("expected \"" + expected + "\" but got \"" + subString + "\"");
        }
        this.upto += expected.length();
    }

    private final ParseException newParseException(String details) throws ParseException {
        Object object;
        int end = Math.min(this.input.length(), this.upto + 1);
        if (this.upto < 50) {
            String string = this.input.substring(0, end);
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        } else {
            String string = this.input.substring(this.upto - 50, end);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            object = "..." + string;
        }
        String fragment = object;
        return new ParseException(details + " at character offset " + this.upto + "; fragment leading to this:\n" + fragment, this.upto);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\b"}, d2={"Lorg/gnit/lucenekmp/geo/SimpleGeoJSONPolygonParser$Companion;", "", "<init>", "()V", "isJSONWhitespace", "", "ch", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isJSONWhitespace(char ch) {
            return ch == ' ' || ch == '\t' || ch == '\n' || ch == '\r';
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

