/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.geo;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gnit.lucenekmp.geo.Line;
import org.gnit.lucenekmp.geo.Polygon;
import org.gnit.lucenekmp.geo.Rectangle;
import org.gnit.lucenekmp.jdkport.ParseException;
import org.gnit.lucenekmp.jdkport.StreamTokenizer;
import org.gnit.lucenekmp.jdkport.StringReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001;B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0005J\u0018\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u001a\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J@\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00152\u0016\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u001c0\u001bj\b\u0012\u0004\u0012\u00020\u001c`\u001d2\u0016\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020\u001c0\u001bj\b\u0012\u0004\u0012\u00020\u001c`\u001dH\u0002J@\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00152\u0016\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u001c0\u001bj\b\u0012\u0004\u0012\u00020\u001c`\u001d2\u0016\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020\u001c0\u001bj\b\u0012\u0004\u0012\u00020\u001c`\u001dH\u0002J\u001d\u0010 \u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010!2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010\"J\u0012\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001d\u0010%\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010!2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010&J\u0010\u0010'\u001a\u00020(2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010)\u001a\u0004\u0018\u00010(2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001d\u0010*\u001a\n\u0012\u0004\u0012\u00020(\u0018\u00010!2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010+J\u0012\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001d\u0010.\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010!2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010/J\u0010\u00100\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u00101\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u00102\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u00103\u001a\u0002042\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u00105\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u00106\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u00107\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u00108\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u00109\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010:\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lorg/gnit/lucenekmp/geo/SimpleWKTShapeParser;", "", "<init>", "()V", "EMPTY", "", "SPACE", "LPAREN", "RPAREN", "COMMA", "NAN", "NUMBER", "EOF", "EOL", "parse", "wkt", "parseExpectedType", "shapeType", "Lorg/gnit/lucenekmp/geo/SimpleWKTShapeParser$ShapeType;", "parseGeometry", "stream", "Lorg/gnit/lucenekmp/jdkport/StreamTokenizer;", "parsePoint", "", "parseCoordinates", "", "lats", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "lons", "parseCoordinate", "parseMultiPoint", "", "(Lorg/gnit/lucenekmp/jdkport/StreamTokenizer;)[[D", "parseLine", "Lorg/gnit/lucenekmp/geo/Line;", "parseMultiLine", "(Lorg/gnit/lucenekmp/jdkport/StreamTokenizer;)[Lorg/gnit/lucenekmp/geo/Line;", "parsePolygonHole", "Lorg/gnit/lucenekmp/geo/Polygon;", "parsePolygon", "parseMultiPolygon", "(Lorg/gnit/lucenekmp/jdkport/StreamTokenizer;)[Lorg/gnit/lucenekmp/geo/Polygon;", "parseBBox", "Lorg/gnit/lucenekmp/geo/Rectangle;", "parseGeometryCollection", "(Lorg/gnit/lucenekmp/jdkport/StreamTokenizer;)[Ljava/lang/Object;", "nextWord", "nextNumber", "tokenString", "isNumberNext", "", "nextEmptyOrOpen", "nextCloser", "nextComma", "nextOpener", "nextCloserOrComma", "checkEOF", "ShapeType", "core"})
@SourceDebugExtension(value={"SMAP\nSimpleWKTShapeParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleWKTShapeParser.kt\norg/gnit/lucenekmp/geo/SimpleWKTShapeParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,433:1\n1#2:434\n37#3:435\n36#3,3:436\n37#3:439\n36#3,3:440\n37#3:443\n36#3,3:444\n37#3:447\n36#3,3:448\n*S KotlinDebug\n*F\n+ 1 SimpleWKTShapeParser.kt\norg/gnit/lucenekmp/geo/SimpleWKTShapeParser\n*L\n178#1:435\n178#1:436,3\n212#1:439\n212#1:440,3\n233#1:443\n233#1:444,3\n264#1:447\n264#1:448,3\n*E\n"})
public final class SimpleWKTShapeParser {
    @NotNull
    public static final SimpleWKTShapeParser INSTANCE = new SimpleWKTShapeParser();
    @NotNull
    public static final String EMPTY = "EMPTY";
    @NotNull
    public static final String SPACE = " ";
    @NotNull
    public static final String LPAREN = "(";
    @NotNull
    public static final String RPAREN = ")";
    @NotNull
    public static final String COMMA = ",";
    @NotNull
    public static final String NAN = "NaN";
    @NotNull
    private static final String NUMBER = "<NUMBER>";
    @NotNull
    private static final String EOF = "END-OF-STREAM";
    @NotNull
    private static final String EOL = "END-OF-LINE";

    private SimpleWKTShapeParser() {
    }

    @NotNull
    public final Object parse(@NotNull String wkt) throws IOException, ParseException {
        Intrinsics.checkNotNullParameter((Object)wkt, (String)"wkt");
        return this.parseExpectedType(wkt, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Object parseExpectedType(@NotNull String wkt, @Nullable ShapeType shapeType) throws IOException, ParseException {
        Intrinsics.checkNotNullParameter((Object)wkt, (String)"wkt");
        AutoCloseable autoCloseable = new StringReader(wkt);
        Throwable throwable = null;
        try {
            StringReader reader2 = (StringReader)autoCloseable;
            boolean bl = false;
            StreamTokenizer tokenizer = new StreamTokenizer(reader2);
            tokenizer.resetSyntax();
            tokenizer.wordChars(97, 122);
            tokenizer.wordChars(65, 90);
            tokenizer.wordChars(160, 255);
            tokenizer.wordChars(48, 57);
            tokenizer.wordChars(45, 45);
            tokenizer.wordChars(43, 43);
            tokenizer.wordChars(46, 46);
            tokenizer.whitespaceChars(0, 32);
            tokenizer.commentChar(35);
            Object geometry = INSTANCE.parseGeometry(tokenizer, shapeType);
            INSTANCE.checkEOF(tokenizer);
            Object object = geometry;
            return object;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private final Object parseGeometry(StreamTokenizer stream, ShapeType shapeType) throws IOException, ParseException {
        Object object;
        ShapeType type = ShapeType.Companion.forName(this.nextWord(stream));
        if (shapeType != null && shapeType != ShapeType.GEOMETRYCOLLECTION && !Intrinsics.areEqual((Object)type.wktName(), (Object)shapeType.wktName())) {
            throw new ParseException("Expected geometry type: [" + shapeType + "], but found: [" + type + "]", stream.lineno());
        }
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                double[] dArray = this.parsePoint(stream);
                object = dArray;
                Intrinsics.checkNotNull((Object)dArray);
                break;
            }
            case 2: {
                double[][] dArray = this.parseMultiPoint(stream);
                object = dArray;
                Intrinsics.checkNotNull((Object)dArray);
                break;
            }
            case 3: {
                Line line = this.parseLine(stream);
                object = line;
                Intrinsics.checkNotNull((Object)line);
                break;
            }
            case 4: {
                Line[] lineArray = this.parseMultiLine(stream);
                object = lineArray;
                Intrinsics.checkNotNull((Object)lineArray);
                break;
            }
            case 5: {
                Polygon polygon = this.parsePolygon(stream);
                object = polygon;
                Intrinsics.checkNotNull((Object)polygon);
                break;
            }
            case 6: {
                Polygon[] polygonArray = this.parseMultiPolygon(stream);
                object = polygonArray;
                Intrinsics.checkNotNull((Object)polygonArray);
                break;
            }
            case 7: {
                Rectangle rectangle = this.parseBBox(stream);
                object = rectangle;
                Intrinsics.checkNotNull((Object)rectangle);
                break;
            }
            case 8: {
                Object[] objectArray = this.parseGeometryCollection(stream);
                object = objectArray;
                Intrinsics.checkNotNull((Object)objectArray);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return object;
    }

    private final double[] parsePoint(StreamTokenizer stream) throws IOException, ParseException {
        if (Intrinsics.areEqual((Object)this.nextEmptyOrOpen(stream), (Object)EMPTY)) {
            return null;
        }
        double[] dArray = new double[]{this.nextNumber(stream), this.nextNumber(stream)};
        double[] pt = dArray;
        if (this.isNumberNext(stream)) {
            this.nextNumber(stream);
        }
        this.nextCloser(stream);
        return pt;
    }

    private final void parseCoordinates(StreamTokenizer stream, ArrayList<Double> lats, ArrayList<Double> lons) throws IOException, ParseException {
        boolean it;
        boolean bl;
        boolean isOpenParen;
        block9: {
            block8: {
                isOpenParen = false;
                if (this.isNumberNext(stream)) break block8;
                it = bl = Intrinsics.areEqual((Object)this.nextWord(stream), (Object)LPAREN);
                boolean bl2 = false;
                isOpenParen = it;
                if (!bl) break block9;
            }
            this.parseCoordinate(stream, lats, lons);
        }
        while (Intrinsics.areEqual((Object)this.nextCloserOrComma(stream), (Object)COMMA)) {
            block11: {
                block10: {
                    isOpenParen = false;
                    if (this.isNumberNext(stream)) break block10;
                    it = bl = Intrinsics.areEqual((Object)this.nextWord(stream), (Object)LPAREN);
                    boolean bl3 = false;
                    isOpenParen = it;
                    if (!bl) break block11;
                }
                this.parseCoordinate(stream, lats, lons);
            }
            if (!isOpenParen || Intrinsics.areEqual((Object)this.nextCloser(stream), (Object)RPAREN)) continue;
            throw new ParseException("expected: [)] but found: [" + this.tokenString(stream) + "]", stream.lineno());
        }
        if (isOpenParen && !Intrinsics.areEqual((Object)this.nextCloser(stream), (Object)RPAREN)) {
            throw new ParseException("expected: [)] but found: [" + this.tokenString(stream) + "]", stream.lineno());
        }
    }

    private final void parseCoordinate(StreamTokenizer stream, ArrayList<Double> lats, ArrayList<Double> lons) throws IOException, ParseException {
        lons.add(this.nextNumber(stream));
        lats.add(this.nextNumber(stream));
        if (this.isNumberNext(stream)) {
            this.nextNumber(stream);
        }
    }

    private final double[][] parseMultiPoint(StreamTokenizer stream) throws IOException, ParseException {
        String token = this.nextEmptyOrOpen(stream);
        if (Intrinsics.areEqual((Object)token, (Object)EMPTY)) {
            return null;
        }
        ArrayList<Double> lats = new ArrayList<Double>();
        ArrayList<Double> lons = new ArrayList<Double>();
        this.parseCoordinates(stream, lats, lons);
        int n = 0;
        int n2 = lats.size();
        Object object = new double[n2][];
        while (n < n2) {
            int n3 = n++;
            object[n3] = new double[2];
        }
        double[][] result = object;
        n2 = ((Collection)lats).size();
        for (int i = 0; i < n2; ++i) {
            object = new double[2];
            Double d = lons.get(i);
            Intrinsics.checkNotNullExpressionValue((Object)d, (String)"get(...)");
            object[0] = (double[])((Number)d).doubleValue();
            Double d2 = lats.get(i);
            Intrinsics.checkNotNullExpressionValue((Object)d2, (String)"get(...)");
            object[1] = (double[])((Number)d2).doubleValue();
            result[i] = (double[])object;
        }
        return result;
    }

    private final Line parseLine(StreamTokenizer stream) throws IOException, ParseException {
        String token = this.nextEmptyOrOpen(stream);
        if (Intrinsics.areEqual((Object)token, (Object)EMPTY)) {
            return null;
        }
        ArrayList<Double> lats = new ArrayList<Double>();
        ArrayList<Double> lons = new ArrayList<Double>();
        this.parseCoordinates(stream, lats, lons);
        return new Line(CollectionsKt.toDoubleArray((Collection)lats), CollectionsKt.toDoubleArray((Collection)lons));
    }

    private final Line[] parseMultiLine(StreamTokenizer stream) throws IOException, ParseException {
        String token = this.nextEmptyOrOpen(stream);
        if (Intrinsics.areEqual((Object)token, (Object)EMPTY)) {
            return null;
        }
        ArrayList<Line> lines = new ArrayList<Line>();
        Line line = this.parseLine(stream);
        Intrinsics.checkNotNull((Object)line);
        lines.add(line);
        while (Intrinsics.areEqual((Object)this.nextCloserOrComma(stream), (Object)COMMA)) {
            Line line2 = this.parseLine(stream);
            Intrinsics.checkNotNull((Object)line2);
            lines.add(line2);
        }
        Collection $this$toTypedArray$iv = lines;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Line[0]);
    }

    private final Polygon parsePolygonHole(StreamTokenizer stream) throws IOException, ParseException {
        ArrayList<Double> lats = new ArrayList<Double>();
        ArrayList<Double> lons = new ArrayList<Double>();
        this.parseCoordinates(stream, lats, lons);
        return new Polygon(CollectionsKt.toDoubleArray((Collection)lats), CollectionsKt.toDoubleArray((Collection)lons), new Polygon[0]);
    }

    private final Polygon parsePolygon(StreamTokenizer stream) throws IOException, ParseException {
        if (Intrinsics.areEqual((Object)this.nextEmptyOrOpen(stream), (Object)EMPTY)) {
            return null;
        }
        this.nextOpener(stream);
        ArrayList<Double> lats = new ArrayList<Double>();
        ArrayList<Double> lons = new ArrayList<Double>();
        this.parseCoordinates(stream, lats, lons);
        ArrayList<Polygon> holes = new ArrayList<Polygon>();
        while (Intrinsics.areEqual((Object)this.nextCloserOrComma(stream), (Object)COMMA)) {
            holes.add(this.parsePolygonHole(stream));
        }
        if (!holes.isEmpty()) {
            Collection $this$toTypedArray$iv = holes;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Polygon[] polygonArray = thisCollection$iv.toArray(new Polygon[0]);
            return new Polygon(CollectionsKt.toDoubleArray((Collection)lats), CollectionsKt.toDoubleArray((Collection)lons), Arrays.copyOf(polygonArray, polygonArray.length));
        }
        return new Polygon(CollectionsKt.toDoubleArray((Collection)lats), CollectionsKt.toDoubleArray((Collection)lons), new Polygon[0]);
    }

    private final Polygon[] parseMultiPolygon(StreamTokenizer stream) throws IOException, ParseException {
        String token = this.nextEmptyOrOpen(stream);
        if (Intrinsics.areEqual((Object)token, (Object)EMPTY)) {
            return null;
        }
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        Polygon polygon = this.parsePolygon(stream);
        Intrinsics.checkNotNull((Object)polygon);
        polygons.add(polygon);
        while (Intrinsics.areEqual((Object)this.nextCloserOrComma(stream), (Object)COMMA)) {
            Polygon polygon2 = this.parsePolygon(stream);
            Intrinsics.checkNotNull((Object)polygon2);
            polygons.add(polygon2);
        }
        Collection $this$toTypedArray$iv = polygons;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Polygon[0]);
    }

    private final Rectangle parseBBox(StreamTokenizer stream) throws IOException, ParseException {
        if (Intrinsics.areEqual((Object)this.nextEmptyOrOpen(stream), (Object)EMPTY)) {
            return null;
        }
        double minLon = this.nextNumber(stream);
        this.nextComma(stream);
        double maxLon = this.nextNumber(stream);
        this.nextComma(stream);
        double maxLat = this.nextNumber(stream);
        this.nextComma(stream);
        double minLat = this.nextNumber(stream);
        this.nextCloser(stream);
        return new Rectangle(minLat, maxLat, minLon, maxLon);
    }

    private final Object[] parseGeometryCollection(StreamTokenizer stream) throws IOException, ParseException {
        if (Intrinsics.areEqual((Object)this.nextEmptyOrOpen(stream), (Object)EMPTY)) {
            return null;
        }
        ArrayList<Object> geometries = new ArrayList<Object>();
        geometries.add(this.parseGeometry(stream, ShapeType.GEOMETRYCOLLECTION));
        while (Intrinsics.areEqual((Object)this.nextCloserOrComma(stream), (Object)COMMA)) {
            geometries.add(this.parseGeometry(stream, null));
        }
        Collection $this$toTypedArray$iv = geometries;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Object[0]);
    }

    private final String nextWord(StreamTokenizer stream) throws ParseException, IOException {
        switch ((char)stream.nextToken()) {
            case '\ufffd': {
                String string = stream.getSval();
                Intrinsics.checkNotNull((Object)string);
                String word = string;
                return StringsKt.equals((String)word, (String)EMPTY, (boolean)true) ? EMPTY : word;
            }
            case '(': {
                return LPAREN;
            }
            case ')': {
                return RPAREN;
            }
            case ',': {
                return COMMA;
            }
        }
        throw new ParseException("expected word but found: " + this.tokenString(stream), stream.lineno());
    }

    private final double nextNumber(StreamTokenizer stream) throws IOException, ParseException {
        if (stream.nextToken() == -3) {
            double d;
            if (StringsKt.equals((String)stream.getSval(), (String)NAN, (boolean)true)) {
                d = Double.NaN;
            } else {
                double d2;
                try {
                    String string = stream.getSval();
                    Intrinsics.checkNotNull((Object)string);
                    d2 = Double.parseDouble(string);
                }
                catch (NumberFormatException e) {
                    throw new ParseException("invalid number found: " + stream.getSval(), stream.lineno());
                }
                d = d2;
            }
            return d;
        }
        throw new ParseException("expected number but found: " + this.tokenString(stream), stream.lineno());
    }

    private final String tokenString(StreamTokenizer stream) {
        int n = stream.getTtype();
        if (n == -3) {
            String string = stream.getSval();
            Intrinsics.checkNotNull((Object)string);
            return string;
        }
        if (n == -1) {
            return EOF;
        }
        if (n == StreamTokenizer.Companion.getTT_EOL()) {
            return EOL;
        }
        if (n == -2) {
            return NUMBER;
        }
        return "'" + (char)stream.getTtype() + "'";
    }

    private final boolean isNumberNext(StreamTokenizer stream) throws IOException {
        int type = stream.nextToken();
        stream.pushBack();
        return type == -3;
    }

    private final String nextEmptyOrOpen(StreamTokenizer stream) throws IOException, ParseException {
        String next = this.nextWord(stream);
        if (Intrinsics.areEqual((Object)next, (Object)EMPTY) || Intrinsics.areEqual((Object)next, (Object)LPAREN)) {
            return next;
        }
        throw new ParseException("expected EMPTY or ( but found: " + this.tokenString(stream), stream.lineno());
    }

    private final String nextCloser(StreamTokenizer stream) throws IOException, ParseException {
        if (Intrinsics.areEqual((Object)this.nextWord(stream), (Object)RPAREN)) {
            return RPAREN;
        }
        throw new ParseException("expected ) but found: " + this.tokenString(stream), stream.lineno());
    }

    private final String nextComma(StreamTokenizer stream) throws IOException, ParseException {
        if (Intrinsics.areEqual((Object)this.nextWord(stream), (Object)COMMA)) {
            return COMMA;
        }
        throw new ParseException("expected , but found: " + this.tokenString(stream), stream.lineno());
    }

    private final String nextOpener(StreamTokenizer stream) throws IOException, ParseException {
        if (Intrinsics.areEqual((Object)this.nextWord(stream), (Object)LPAREN)) {
            return LPAREN;
        }
        throw new ParseException("expected ( but found: " + this.tokenString(stream), stream.lineno());
    }

    private final String nextCloserOrComma(StreamTokenizer stream) throws IOException, ParseException {
        String token = this.nextWord(stream);
        if (Intrinsics.areEqual((Object)token, (Object)COMMA) || Intrinsics.areEqual((Object)token, (Object)RPAREN)) {
            return token;
        }
        throw new ParseException("expected , or ) but found: " + this.tokenString(stream), stream.lineno());
    }

    private final void checkEOF(StreamTokenizer stream) throws ParseException, IOException {
        if (stream.nextToken() != -1) {
            throw new ParseException("expected end of WKT string but found additional text: " + this.tokenString(stream), stream.lineno());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\b\u0086\u0081\u0002\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0010B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u000e\u001a\u00020\u0003J\u0006\u0010\u000f\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u0011"}, d2={"Lorg/gnit/lucenekmp/geo/SimpleWKTShapeParser$ShapeType;", "", "shapeName", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "POINT", "MULTIPOINT", "LINESTRING", "MULTILINESTRING", "POLYGON", "MULTIPOLYGON", "GEOMETRYCOLLECTION", "ENVELOPE", "typename", "wktName", "Companion", "core"})
    public static final class ShapeType
    extends Enum<ShapeType> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String shapeName;
        @NotNull
        private static final Map<String, ShapeType> shapeTypeMap;
        @NotNull
        private static final String BBOX = "BBOX";
        public static final /* enum */ ShapeType POINT;
        public static final /* enum */ ShapeType MULTIPOINT;
        public static final /* enum */ ShapeType LINESTRING;
        public static final /* enum */ ShapeType MULTILINESTRING;
        public static final /* enum */ ShapeType POLYGON;
        public static final /* enum */ ShapeType MULTIPOLYGON;
        public static final /* enum */ ShapeType GEOMETRYCOLLECTION;
        public static final /* enum */ ShapeType ENVELOPE;
        private static final /* synthetic */ ShapeType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private ShapeType(String shapeName) {
            this.shapeName = shapeName;
        }

        @NotNull
        public final String typename() {
            return this.shapeName;
        }

        @NotNull
        public final String wktName() {
            return this == ENVELOPE ? BBOX : this.shapeName;
        }

        public static ShapeType[] values() {
            return (ShapeType[])$VALUES.clone();
        }

        public static ShapeType valueOf(String value) {
            return Enum.valueOf(ShapeType.class, value);
        }

        @NotNull
        public static EnumEntries<ShapeType> getEntries() {
            return $ENTRIES;
        }

        static {
            POINT = new ShapeType("point");
            MULTIPOINT = new ShapeType("multipoint");
            LINESTRING = new ShapeType("linestring");
            MULTILINESTRING = new ShapeType("multilinestring");
            POLYGON = new ShapeType("polygon");
            MULTIPOLYGON = new ShapeType("multipolygon");
            GEOMETRYCOLLECTION = new ShapeType("geometrycollection");
            ENVELOPE = new ShapeType("envelope");
            $VALUES = shapeTypeArray = new ShapeType[]{ShapeType.POINT, ShapeType.MULTIPOINT, ShapeType.LINESTRING, ShapeType.MULTILINESTRING, ShapeType.POLYGON, ShapeType.MULTIPOLYGON, ShapeType.GEOMETRYCOLLECTION, ShapeType.ENVELOPE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            Map shapeTypes = new LinkedHashMap();
            for (ShapeType type : ShapeType.getEntries()) {
                shapeTypes.put(type.shapeName, type);
            }
            String string = ENVELOPE.wktName().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            shapeTypes.put(string, ENVELOPE);
            shapeTypeMap = MapsKt.toMutableMap((Map)shapeTypes);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0006R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/gnit/lucenekmp/geo/SimpleWKTShapeParser$ShapeType$Companion;", "", "<init>", "()V", "shapeTypeMap", "", "", "Lorg/gnit/lucenekmp/geo/SimpleWKTShapeParser$ShapeType;", "BBOX", "forName", "shapename", "core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ShapeType forName(@NotNull String shapename) {
                Intrinsics.checkNotNullParameter((Object)shapename, (String)"shapename");
                String string = shapename.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                String typename = string;
                ShapeType type = (ShapeType)((Object)shapeTypeMap.get(typename));
                if (type != null) {
                    return type;
                }
                throw new IllegalArgumentException("unknown geo_shape [" + shapename + "]");
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ShapeType.values().length];
            try {
                nArray[ShapeType.POINT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.MULTIPOINT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.LINESTRING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.MULTILINESTRING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.POLYGON.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.MULTIPOLYGON.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.ENVELOPE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ShapeType.GEOMETRYCOLLECTION.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

