/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.geo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongCompanionObject;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.geo.GeoEncodingUtils;
import org.gnit.lucenekmp.geo.GeoUtils;
import org.gnit.lucenekmp.geo.Point;
import org.gnit.lucenekmp.geo.Polygon;
import org.gnit.lucenekmp.geo.Rectangle;
import org.gnit.lucenekmp.geo.XYEncodingUtils;
import org.gnit.lucenekmp.geo.XYPolygon;
import org.gnit.lucenekmp.jdkport.LongExtKt;
import org.gnit.lucenekmp.jdkport.StrictMath;
import org.gnit.lucenekmp.util.BitUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\bC\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\b\u0085\u0001\u0086\u0001\u0087\u0001\u0088\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J*\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J:\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0016H\u0002J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u00112\u0006\u0010\t\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u0011H\u0002J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u0011H\u0002J4\u0010\u001a\u001a\u0004\u0018\u00010\u00112\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00110\u00072\u0010\u0010\u001d\u001a\f\u0012\u0004\u0012\u00020\u0011\u0012\u0002\b\u00030\u001e2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0011H\u0002J:\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00112\b\u0010\u001b\u001a\u0004\u0018\u00010\u00112\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020#H\u0002J8\u0010'\u001a\u00020\f2\u0006\u0010!\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020#H\u0002J\u001a\u0010(\u001a\u0004\u0018\u00010\u00112\u0006\u0010\t\u001a\u00020\u00112\u0006\u0010)\u001a\u00020\u0011H\u0002J\u001e\u0010*\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\u00112\u0006\u0010-\u001a\u00020\u0011J \u0010.\u001a\u00020#2\u0006\u0010/\u001a\u00020\u00112\u0006\u00100\u001a\u00020\u00112\u0006\u00101\u001a\u00020\u0011H\u0002J\u001a\u00102\u001a\u0004\u0018\u00010\u00112\u0006\u0010!\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0011H\u0002J\u0012\u00103\u001a\u00020\u00112\b\u00104\u001a\u0004\u0018\u00010\u0011H\u0002JP\u00105\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\u00012\b\u00106\u001a\u0004\u0018\u00010\u00112\f\u00107\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010;\u001a\u00020\u0005H\u0002J\u0018\u0010<\u001a\u00020\f2\u0006\u0010=\u001a\u00020\u00112\u0006\u0010:\u001a\u00020\fH\u0002J\u0010\u0010>\u001a\u00020\f2\u0006\u0010=\u001a\u00020\u0011H\u0002J&\u0010?\u001a\u00020\u00112\u0006\u0010@\u001a\u00020\u00112\f\u00107\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010:\u001a\u00020\fH\u0002J@\u0010A\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u00012\u0006\u00104\u001a\u00020\u00112\f\u00107\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010:\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010;\u001a\u00020\u0005H\u0002J\u001a\u0010B\u001a\u00020 2\b\u0010/\u001a\u0004\u0018\u00010\u00112\u0006\u0010C\u001a\u00020\fH\u0002J\u0018\u0010D\u001a\u00020 2\u0006\u0010/\u001a\u00020\u00112\u0006\u00100\u001a\u00020\u0011H\u0002J\u0018\u0010E\u001a\u00020 2\u0006\u0010/\u001a\u00020\u00112\u0006\u00100\u001a\u00020\u0011H\u0002J \u0010F\u001a\u00020\f2\u0006\u0010/\u001a\u00020\u00112\u0006\u00100\u001a\u00020\u00112\u0006\u0010C\u001a\u00020\fH\u0002J\u0018\u0010G\u001a\u00020\f2\u0006\u0010/\u001a\u00020\u00112\u0006\u00100\u001a\u00020\u0011H\u0002J \u0010H\u001a\u00020\f2\u0006\u0010/\u001a\u00020\u00112\u0006\u00100\u001a\u00020\u00112\u0006\u0010I\u001a\u00020\u0011H\u0002J(\u0010H\u001a\u00020\f2\u0006\u0010/\u001a\u00020\u00112\u0006\u00100\u001a\u00020\u00112\u0006\u0010J\u001a\u00020#2\u0006\u0010K\u001a\u00020#H\u0002J \u0010L\u001a\u00020\u00112\u0006\u0010/\u001a\u00020\u00112\u0006\u00100\u001a\u00020\u00112\u0006\u0010M\u001a\u00020\fH\u0002J\u0018\u0010N\u001a\u00020\f2\u0006\u0010/\u001a\u00020\u00112\u0006\u00100\u001a\u00020\u0011H\u0002J\u0018\u0010O\u001a\u00020\f2\u0006\u00104\u001a\u00020\u00112\u0006\u0010P\u001a\u00020\u0011H\u0002J\u0018\u0010Q\u001a\u00020#2\u0006\u00104\u001a\u00020\u00112\u0006\u0010P\u001a\u00020\u0011H\u0002J\u0018\u0010R\u001a\u00020\f2\u0006\u0010/\u001a\u00020\u00112\u0006\u00100\u001a\u00020\u0011H\u0002J0\u0010S\u001a\u00020\f2\u0006\u00104\u001a\u00020\u00112\u0006\u0010T\u001a\u00020#2\u0006\u0010U\u001a\u00020#2\u0006\u0010V\u001a\u00020#2\u0006\u0010W\u001a\u00020#H\u0002J0\u0010X\u001a\u00020\f2\u0006\u00104\u001a\u00020\u00112\u0006\u0010T\u001a\u00020#2\u0006\u0010U\u001a\u00020#2\u0006\u0010V\u001a\u00020#2\u0006\u0010W\u001a\u00020#H\u0002JF\u0010Y\u001a\u00020\f2\u0006\u0010Z\u001a\u00020#2\u0006\u0010[\u001a\u00020#2\u0006\u0010\\\u001a\u00020#2\u0006\u0010]\u001a\u00020#2\u0006\u0010^\u001a\u00020#2\u0006\u0010_\u001a\u00020#2\u0006\u0010`\u001a\u00020#2\u0006\u0010a\u001a\u00020#J\u0012\u0010b\u001a\u00020 2\b\u00104\u001a\u0004\u0018\u00010\u0011H\u0002J\u0012\u0010c\u001a\u00020 2\b\u00104\u001a\u0004\u0018\u00010\u0011H\u0002J\u0012\u0010d\u001a\u00020 2\b\u0010e\u001a\u0004\u0018\u00010\u0011H\u0002J\u001e\u0010f\u001a\u0004\u0018\u00010\u00112\b\u00104\u001a\u0004\u0018\u00010\u00112\b\u0010P\u001a\u0004\u0018\u00010\u0011H\u0002J:\u0010g\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010h\u001a\u00020\u00052\u0006\u0010i\u001a\u00020\u00052\b\u0010j\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0017\u001a\u00020\fH\u0002J\u0018\u0010k\u001a\u00020 2\u0006\u0010l\u001a\u00020\u00112\u0006\u0010M\u001a\u00020\fH\u0002J\u0018\u0010m\u001a\u00020\f2\u0006\u0010/\u001a\u00020\u00112\u0006\u00100\u001a\u00020\u0011H\u0002J \u0010m\u001a\u00020\f2\u0006\u0010/\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020#2\u0006\u0010\u0014\u001a\u00020#H\u0002J8\u0010n\u001a\u00020#2\u0006\u0010o\u001a\u00020#2\u0006\u0010p\u001a\u00020#2\u0006\u0010q\u001a\u00020#2\u0006\u0010r\u001a\u00020#2\u0006\u0010s\u001a\u00020#2\u0006\u0010t\u001a\u00020#H\u0002JH\u0010u\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020#2\u0006\u0010\u0014\u001a\u00020#2\u0006\u0010v\u001a\u00020#2\u0006\u0010w\u001a\u00020#2\u0006\u0010x\u001a\u00020#2\u0006\u0010y\u001a\u00020#2\u0006\u0010z\u001a\u00020#2\u0006\u0010{\u001a\u00020#H\u0002J\u0016\u0010|\u001a\b\u0012\u0004\u0012\u00020}0\u00072\u0006\u00104\u001a\u00020\u0011H\u0002J/\u0010~\u001a\u00020 2\u0006\u0010;\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u007f\u001a\u0004\u0018\u00010\u00112\t\u0010\u0080\u0001\u001a\u0004\u0018\u00010\u0011H\u0002J\u001b\u0010\u0081\u0001\u001a\u00020 2\u0006\u0010;\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J;\u0010\u0082\u0001\u001a\u00020 2\u0006\u00108\u001a\u0002092\u0006\u0010;\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u00104\u001a\u0004\u0018\u00010\u00112\f\u00107\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J5\u0010\u0082\u0001\u001a\u00020 2\b\u0010\u0083\u0001\u001a\u00030\u0084\u00012\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u00104\u001a\u0004\u0018\u00010\u00112\f\u00107\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0089\u0001"}, d2={"Lorg/gnit/lucenekmp/geo/Tessellator;", "", "<init>", "()V", "VERTEX_THRESHOLD", "", "tessellate", "", "Lorg/gnit/lucenekmp/geo/Tessellator$Triangle;", "polygon", "Lorg/gnit/lucenekmp/geo/Polygon;", "checkSelfIntersections", "", "monitor", "Lorg/gnit/lucenekmp/geo/Tessellator$Monitor;", "Lorg/gnit/lucenekmp/geo/XYPolygon;", "createDoublyLinkedList", "Lorg/gnit/lucenekmp/geo/Tessellator$Node;", "x", "", "y", "polyWindingOrder", "Lorg/gnit/lucenekmp/geo/GeoUtils$WindingOrder;", "isGeo", "startIndex", "windingOrder", "eliminateHoles", "outerNode", "holeList", "holeListPolygons", "", "eliminateHole", "", "holeNode", "holeMinX", "", "holeMaxX", "holeMinY", "holeMaxY", "maybeMergeHoleWithSharedVertices", "getSharedVertex", "vertex", "getSharedInsideVertex", "holeVertex", "candidateA", "candidateB", "angle", "a", "b", "c", "fetchHoleBridge", "fetchLeftmost", "start", "earcutLinkedList", "currEar", "tessellation", "state", "Lorg/gnit/lucenekmp/geo/Tessellator$State;", "mortonOptimized", "depth", "isEar", "ear", "mortonIsEar", "cureLocalIntersections", "startNode", "splitEarcut", "checkIntersection", "isMorton", "mortonCheckIntersection", "checkIntersectionPoint", "isEdgeFromPolygon", "isMortonEdgeFromPolygon", "isPointInLine", "point", "lon", "lat", "splitPolygon", "edgeFromPolygon", "isValidDiagonal", "isCWPolygon", "end", "signedArea", "isLocallyInside", "middleInsert", "x0", "y0", "x1", "y1", "isIntersectingPolygon", "linesIntersect", "aX0", "aY0", "aX1", "aY1", "bX0", "bY0", "bX1", "bY1", "sortByMortonWithReset", "sortByMorton", "tathamSort", "list", "filterPoints", "insertNode", "index", "vertexIndex", "lastNode", "removeNode", "node", "isVertexEquals", "area", "aX", "aY", "bX", "bY", "cX", "cY", "pointInEar", "ax", "ay", "bx", "by", "cx", "cy", "getPoints", "Lorg/gnit/lucenekmp/geo/Point;", "notifyMonitorSplit", "searchNode", "diagonalNode", "notifyMonitorSplitEnd", "notifyMonitor", "status", "", "State", "Monitor", "Node", "Triangle", "core"})
@SourceDebugExtension(value={"SMAP\nTessellator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Tessellator.kt\norg/gnit/lucenekmp/geo/Tessellator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 MutableListExt.kt\norg/gnit/lucenekmp/jdkport/MutableListExtKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,1844:1\n1#2:1845\n4#3,4:1846\n8#3,5:1854\n37#4:1850\n36#4,3:1851\n*S KotlinDebug\n*F\n+ 1 Tessellator.kt\norg/gnit/lucenekmp/geo/Tessellator\n*L\n290#1:1846,4\n290#1:1854,5\n290#1:1850\n290#1:1851,3\n*E\n"})
public final class Tessellator {
    @NotNull
    public static final Tessellator INSTANCE = new Tessellator();
    private static final int VERTEX_THRESHOLD = 80;

    private Tessellator() {
    }

    /*
     * Unable to fully structure code
     */
    @JvmOverloads
    @NotNull
    public final List<Triangle> tessellate(@NotNull Polygon polygon, boolean checkSelfIntersections, @Nullable Monitor monitor) {
        Intrinsics.checkNotNullParameter((Object)polygon, (String)"polygon");
        outerNode = null;
        outerNode = this.createDoublyLinkedList(polygon.getPolyLons(), polygon.getPolyLats(), polygon.getWindingOrder(), true, 0, GeoUtils.WindingOrder.CW);
        if (outerNode == null) {
            $i$a$-requireNotNull-Tessellator$tessellate$1 = false;
            $i$a$-requireNotNull-Tessellator$tessellate$1 = "Malformed shape detected in Tessellator!";
            throw new IllegalArgumentException($i$a$-requireNotNull-Tessellator$tessellate$1.toString());
        }
        if (outerNode == outerNode.getNext()) ** GOTO lbl-1000
        v0 = outerNode.getNext();
        Intrinsics.checkNotNull((Object)v0);
        if (outerNode != v0.getNext()) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        if (!v1) {
            $i$a$-require-Tessellator$tessellate$2 = false;
            $i$a$-require-Tessellator$tessellate$2 = "at least three non-collinear points required";
            throw new IllegalArgumentException($i$a$-require-Tessellator$tessellate$2.toString());
        }
        if (polygon.numHoles() > 0) {
            outerNode = this.eliminateHoles(polygon, outerNode);
        }
        mortonOptimized = false;
        $this$tessellate_u24lambda_u242 = this;
        $i$a$-run-Tessellator$tessellate$3 = false;
        threshold = 80 - polygon.numPoints();
        for (i = 0; threshold >= 0 && i < polygon.numHoles(); threshold -= polygon.getHole(i).numPoints(), ++i) {
        }
        v2 = mortonOptimized = threshold < 0;
        if (mortonOptimized) {
            Tessellator.INSTANCE.sortByMorton(outerNode);
        }
        if (checkSelfIntersections) {
            this.checkIntersection(outerNode, mortonOptimized);
        }
        if ((result = this.earcutLinkedList(polygon, outerNode, (List<Triangle>)new ArrayList<E>(), State.INIT, mortonOptimized, monitor, 0)).isEmpty()) {
            this.notifyMonitor("FAILED", monitor, null, result);
            throw new IllegalArgumentException("Unable to Tessellate shape. Possible malformed shape detected.");
        }
        this.notifyMonitor("COMPLETED", monitor, null, result);
        return result;
    }

    public static /* synthetic */ List tessellate$default(Tessellator tessellator, Polygon polygon, boolean bl, Monitor monitor, int n, Object object) {
        if ((n & 4) != 0) {
            monitor = null;
        }
        return tessellator.tessellate(polygon, bl, monitor);
    }

    /*
     * Unable to fully structure code
     */
    @JvmOverloads
    @NotNull
    public final List<Triangle> tessellate(@NotNull XYPolygon polygon, boolean checkSelfIntersections, @Nullable Monitor monitor) {
        Intrinsics.checkNotNullParameter((Object)polygon, (String)"polygon");
        outerNode = null;
        outerNode = this.createDoublyLinkedList(XYEncodingUtils.INSTANCE.floatArrayToDoubleArray(polygon.getPolyX()), XYEncodingUtils.INSTANCE.floatArrayToDoubleArray(polygon.getPolyY()), polygon.getWindingOrder(), false, 0, GeoUtils.WindingOrder.CW);
        if (outerNode == null) {
            $i$a$-requireNotNull-Tessellator$tessellate$4 = false;
            $i$a$-requireNotNull-Tessellator$tessellate$4 = "Malformed shape detected in Tessellator!";
            throw new IllegalArgumentException($i$a$-requireNotNull-Tessellator$tessellate$4.toString());
        }
        if (outerNode == outerNode.getNext()) ** GOTO lbl-1000
        v0 = outerNode.getNext();
        Intrinsics.checkNotNull((Object)v0);
        if (outerNode != v0.getNext()) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        if (!v1) {
            $i$a$-require-Tessellator$tessellate$5 = false;
            $i$a$-require-Tessellator$tessellate$5 = "at least three non-collinear points required";
            throw new IllegalArgumentException($i$a$-require-Tessellator$tessellate$5.toString());
        }
        if (polygon.numHoles() > 0) {
            outerNode = this.eliminateHoles(polygon, outerNode);
        }
        mortonOptimized = false;
        $this$tessellate_u24lambda_u245 = this;
        $i$a$-run-Tessellator$tessellate$6 = false;
        threshold = 80 - polygon.numPoints();
        for (i = 0; threshold >= 0 && i < polygon.numHoles(); threshold -= polygon.getHole(i).numPoints(), ++i) {
        }
        v2 = mortonOptimized = threshold < 0;
        if (mortonOptimized) {
            Tessellator.INSTANCE.sortByMorton(outerNode);
        }
        if (checkSelfIntersections) {
            this.checkIntersection(outerNode, mortonOptimized);
        }
        if ((result = this.earcutLinkedList(polygon, outerNode, (List<Triangle>)new ArrayList<E>(), State.INIT, mortonOptimized, monitor, 0)).isEmpty()) {
            this.notifyMonitor("FAILED", monitor, null, result);
            throw new IllegalArgumentException("Unable to Tessellate shape. Possible malformed shape detected.");
        }
        this.notifyMonitor("COMPLETED", monitor, null, result);
        return result;
    }

    public static /* synthetic */ List tessellate$default(Tessellator tessellator, XYPolygon xYPolygon, boolean bl, Monitor monitor, int n, Object object) {
        if ((n & 4) != 0) {
            monitor = null;
        }
        return tessellator.tessellate(xYPolygon, bl, monitor);
    }

    private final Node createDoublyLinkedList(double[] x, double[] y, GeoUtils.WindingOrder polyWindingOrder, boolean isGeo, int startIndex, GeoUtils.WindingOrder windingOrder) {
        int startIndex2 = startIndex;
        Node lastNode = null;
        if (windingOrder == polyWindingOrder) {
            int n = x.length;
            for (int i = 0; i < n; ++i) {
                lastNode = this.insertNode(x, y, startIndex2++, i, lastNode, isGeo);
            }
        } else {
            int n = x.length + -1;
            if (0 <= n) {
                do {
                    int i = n--;
                    lastNode = this.insertNode(x, y, startIndex2++, i, lastNode, isGeo);
                } while (0 <= n);
            }
        }
        if (lastNode != null) {
            Node node = lastNode.getNext();
            Intrinsics.checkNotNull((Object)node);
            if (this.isVertexEquals(lastNode, node)) {
                this.removeNode(lastNode, true);
                lastNode = lastNode.getNext();
            }
        }
        return this.filterPoints(lastNode, null);
    }

    private final Node eliminateHoles(XYPolygon polygon, Node outerNode) {
        List holeList = new ArrayList();
        Map holeListPolygons = new HashMap();
        XYPolygon[] holes = polygon.getHoles();
        int nodeIndex = polygon.numPoints();
        int n = polygon.numHoles();
        for (int i = 0; i < n; ++i) {
            Node list = this.createDoublyLinkedList(XYEncodingUtils.INSTANCE.floatArrayToDoubleArray(holes[i].getPolyX()), XYEncodingUtils.INSTANCE.floatArrayToDoubleArray(holes[i].getPolyY()), holes[i].getWindingOrder(), false, nodeIndex, GeoUtils.WindingOrder.CCW);
            if (list != null) {
                Node leftMost = this.fetchLeftmost(list);
                holeList.add(leftMost);
                holeListPolygons.put(leftMost, holes[i]);
            }
            nodeIndex += holes[i].numPoints();
        }
        return this.eliminateHoles(holeList, holeListPolygons, outerNode);
    }

    private final Node eliminateHoles(Polygon polygon, Node outerNode) {
        List holeList = new ArrayList();
        Map holeListPolygons = new HashMap();
        Polygon[] holes = polygon.getHoles();
        int nodeIndex = polygon.numPoints();
        int n = polygon.numHoles();
        for (int i = 0; i < n; ++i) {
            Node list;
            Node node = list = this.createDoublyLinkedList(holes[i].getPolyLons(), holes[i].getPolyLats(), holes[i].getWindingOrder(), true, nodeIndex, GeoUtils.WindingOrder.CCW);
            if (!(list != (node != null ? node.getNext() : null))) {
                boolean bl = false;
                String string = "Points are all coplanar in hole: " + holes[i];
                throw new IllegalArgumentException(string.toString());
            }
            Node leftMost = this.fetchLeftmost(list);
            holeList.add(leftMost);
            holeListPolygons.put(leftMost, holes[i]);
            nodeIndex += holes[i].numPoints();
        }
        return this.eliminateHoles(holeList, holeListPolygons, outerNode);
    }

    /*
     * WARNING - void declaration
     */
    private final Node eliminateHoles(List<Node> holeList, Map<Node, ?> holeListPolygons, Node outerNode) {
        void $this$sort$iv;
        Node outerNode2 = outerNode;
        List<Node> list = holeList;
        Comparator Comparator$iv = Tessellator::eliminateHoles$lambda$7;
        boolean $i$f$sort = false;
        int size$iv = $this$sort$iv.size();
        if (size$iv >= 2) {
            Collection $this$toTypedArray$iv$iv = (Collection)$this$sort$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            Object[] array$iv = thisCollection$iv$iv.toArray(new Node[0]);
            ArraysKt.sortWith((Object[])array$iv, (Comparator)Comparator$iv);
            for (int i$iv = 0; i$iv < size$iv; ++i$iv) {
                $this$sort$iv.set(i$iv, array$iv[i$iv]);
            }
        }
        int n = ((Collection)holeList).size();
        for (int i = 0; i < n; ++i) {
            Object h;
            Node holeNode = holeList.get(i);
            double holeMinX = 0.0;
            double holeMaxX = 0.0;
            double holeMinY = 0.0;
            double holeMaxY = 0.0;
            Intrinsics.checkNotNull(holeListPolygons.get(holeNode), (String)"null cannot be cast to non-null type kotlin.Any");
            if (h instanceof Polygon) {
                holeMinX = ((Polygon)h).getMinLon();
                holeMaxX = ((Polygon)h).getMaxLon();
                holeMinY = ((Polygon)h).getMinLat();
                holeMaxY = ((Polygon)h).getMaxLat();
            } else {
                XYPolygon holePoly = (XYPolygon)h;
                holeMinX = holePoly.getMinX();
                holeMaxX = holePoly.getMaxX();
                holeMinY = holePoly.getMinY();
                holeMaxY = holePoly.getMaxY();
            }
            this.eliminateHole(holeNode, outerNode2, holeMinX, holeMaxX, holeMinY, holeMaxY);
            Node node = outerNode2;
            Intrinsics.checkNotNull((Object)node);
            outerNode2 = this.filterPoints(outerNode2, node.getNext());
        }
        return outerNode2;
    }

    /*
     * Unable to fully structure code
     */
    private final void eliminateHole(Node holeNode, Node outerNode, double holeMinX, double holeMaxX, double holeMinY, double holeMaxY) {
        block3: {
            v0 = outerNode = outerNode;
            Intrinsics.checkNotNull((Object)v0);
            if (this.maybeMergeHoleWithSharedVertices(holeNode, v0, holeMinX, holeMaxX, holeMinY, holeMaxY)) {
                return;
            }
            if ((outerNode = this.fetchHoleBridge(holeNode, outerNode)) == null) break block3;
            v1 = outerNode.getNext();
            Intrinsics.checkNotNull((Object)v1);
            if (this.isPointInLine(outerNode, v1, holeNode)) ** GOTO lbl-1000
            v2 = holeNode.getNext();
            Intrinsics.checkNotNull((Object)v2);
            if (this.isPointInLine(holeNode, v2, outerNode)) lbl-1000:
            // 2 sources

            {
                v3 = true;
            } else {
                v3 = false;
            }
            fromPolygon = v3;
            node = this.splitPolygon(outerNode, holeNode, fromPolygon);
            this.filterPoints(node, node.getNext());
        }
    }

    private final boolean maybeMergeHoleWithSharedVertices(Node holeNode, Node outerNode, double holeMinX, double holeMaxX, double holeMinY, double holeMaxY) {
        Node sharedVertex = null;
        Node sharedVertexConnection = null;
        Node next = outerNode;
        do {
            Node newSharedVertex;
            Node node = next;
            Intrinsics.checkNotNull((Object)node);
            if (!Rectangle.Companion.containsPoint(node.getY(), next.getX(), holeMinY, holeMaxY, holeMinX, holeMaxX) || (newSharedVertex = this.getSharedVertex(holeNode, next)) == null) continue;
            if (sharedVertex == null) {
                sharedVertex = newSharedVertex;
                sharedVertexConnection = next;
                continue;
            }
            if (!Intrinsics.areEqual((Object)newSharedVertex, (Object)sharedVertex)) continue;
            Node node2 = sharedVertexConnection;
            Intrinsics.checkNotNull((Object)node2);
            sharedVertexConnection = this.getSharedInsideVertex(sharedVertex, node2, next);
        } while ((next = next.getNext()) != outerNode);
        if (sharedVertex != null) {
            Node node = sharedVertexConnection;
            Intrinsics.checkNotNull(node);
            Node node3 = this.splitPolygon(node, sharedVertex, true);
            this.filterPoints(node3, node3.getNext());
            return true;
        }
        return false;
    }

    private final Node getSharedVertex(Node polygon, Node vertex) {
        Node next = polygon;
        do {
            Node node = next;
            Intrinsics.checkNotNull((Object)node);
            if (!this.isVertexEquals(node, vertex)) continue;
            return next;
        } while ((next = next.getNext()) != polygon);
        return null;
    }

    @NotNull
    public final Node getSharedInsideVertex(@NotNull Node holeVertex, @NotNull Node candidateA, @NotNull Node candidateB) {
        Intrinsics.checkNotNullParameter((Object)holeVertex, (String)"holeVertex");
        Intrinsics.checkNotNullParameter((Object)candidateA, (String)"candidateA");
        Intrinsics.checkNotNullParameter((Object)candidateB, (String)"candidateB");
        if (!(this.isVertexEquals(holeVertex, candidateA) && this.isVertexEquals(holeVertex, candidateB))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Node node = candidateA.getPrevious();
        Intrinsics.checkNotNull((Object)node);
        double d = node.getX();
        Node node2 = candidateA.getPrevious();
        Intrinsics.checkNotNull((Object)node2);
        double d2 = node2.getY();
        double d3 = holeVertex.getX();
        double d4 = holeVertex.getY();
        Node node3 = holeVertex.getNext();
        Intrinsics.checkNotNull((Object)node3);
        double d5 = node3.getX();
        Node node4 = holeVertex.getNext();
        Intrinsics.checkNotNull((Object)node4);
        double a1 = this.area(d, d2, d3, d4, d5, node4.getY());
        Node node5 = candidateB.getPrevious();
        Intrinsics.checkNotNull((Object)node5);
        double d6 = node5.getX();
        Node node6 = candidateB.getPrevious();
        Intrinsics.checkNotNull((Object)node6);
        double d7 = node6.getY();
        double d8 = holeVertex.getX();
        double d9 = holeVertex.getY();
        Node node7 = holeVertex.getNext();
        Intrinsics.checkNotNull((Object)node7);
        double d10 = node7.getX();
        Node node8 = holeVertex.getNext();
        Intrinsics.checkNotNull((Object)node8);
        double a2 = this.area(d6, d7, d8, d9, d10, node8.getY());
        if (a1 < 0.0 != a2 < 0.0) {
            return a1 < a2 ? candidateA : candidateB;
        }
        Node node9 = candidateA.getPrevious();
        Intrinsics.checkNotNull((Object)node9);
        Node node10 = holeVertex.getNext();
        Intrinsics.checkNotNull((Object)node10);
        double angle1 = this.angle(node9, candidateA, node10);
        Node node11 = candidateB.getPrevious();
        Intrinsics.checkNotNull((Object)node11);
        Node node12 = holeVertex.getNext();
        Intrinsics.checkNotNull((Object)node12);
        double angle2 = this.angle(node11, candidateB, node12);
        return angle1 < angle2 ? candidateA : candidateB;
    }

    private final double angle(Node a, Node b, Node c) {
        double ax = a.getX() - b.getX();
        double ay = a.getY() - b.getY();
        double cx = c.getX() - b.getX();
        double cy = c.getY() - b.getY();
        double dotProduct = ax * cx + ay * cy;
        double aLength = Math.sqrt(ax * ax + ay * ay);
        double bLength = Math.sqrt(cx * cx + cy * cy);
        return Math.acos(dotProduct / (aLength * bLength));
    }

    private final Node fetchHoleBridge(Node holeNode, Node outerNode) {
        Node p = null;
        p = outerNode;
        double qx = 0.0;
        qx = Double.NEGATIVE_INFINITY;
        double hx = holeNode.getX();
        double hy = holeNode.getY();
        Node connection = null;
        Tessellator $this$fetchHoleBridge_u24lambda_u248 = this;
        boolean bl = false;
        do {
            Node node = p;
            Intrinsics.checkNotNull((Object)node);
            if (!(hy <= node.getY())) continue;
            Node node2 = p.getNext();
            Intrinsics.checkNotNull((Object)node2);
            if (!(hy >= node2.getY())) continue;
            Node node3 = p.getNext();
            Intrinsics.checkNotNull((Object)node3);
            if (node3.getY() == p.getY()) continue;
            double d = p.getX();
            double d2 = hy - p.getY();
            Node node4 = p.getNext();
            Intrinsics.checkNotNull((Object)node4);
            double d3 = d2 * (node4.getX() - p.getX());
            Node node5 = p.getNext();
            Intrinsics.checkNotNull((Object)node5);
            double x = d + d3 / (node5.getY() - p.getY());
            if (!(x <= hx) || !(x > qx)) continue;
            qx = x;
            if (x == hx) {
                if (hy == p.getY()) {
                    return p;
                }
                Node node6 = p.getNext();
                Intrinsics.checkNotNull((Object)node6);
                if (hy == node6.getY()) {
                    return p.getNext();
                }
            }
            double d4 = p.getX();
            Node node7 = p.getNext();
            Intrinsics.checkNotNull((Object)node7);
            Node node8 = connection = d4 < node7.getX() ? p : p.getNext();
        } while ((p = p.getNext()) != outerNode);
        if (connection == null) {
            return null;
        }
        if (hx == qx) {
            return connection.getPrevious();
        }
        Node stop = connection;
        double mx = connection.getX();
        double my = connection.getY();
        double tanMin = Double.POSITIVE_INFINITY;
        double tan = 0.0;
        p = connection;
        do {
            Node node = p;
            Intrinsics.checkNotNull((Object)node);
            if (!(hx >= node.getX()) || !(p.getX() >= mx) || hx == p.getX() || !this.pointInEar(p.getX(), p.getY(), hy < my ? hx : qx, hy, mx, my, hy < my ? qx : hx, hy) || !((tan = Math.abs(hy - p.getY()) / (hx - p.getX())) < tanMin) && (!(tan == tanMin) || !(p.getX() > connection.getX())) || !this.isLocallyInside(p, holeNode)) continue;
            connection = p;
            tanMin = tan;
        } while ((p = p.getNext()) != stop);
        return connection;
    }

    private final Node fetchLeftmost(Node start) {
        Node node = start;
        Node leftMost = start;
        do {
            Node node2 = node;
            Intrinsics.checkNotNull((Object)node2);
            double d = node2.getX();
            Node node3 = leftMost;
            Intrinsics.checkNotNull((Object)node3);
            if (!(d < node3.getX()) && (!(node.getX() == leftMost.getX()) || !(node.getY() < leftMost.getY()))) continue;
            leftMost = node;
        } while ((node = node.getNext()) != start);
        return leftMost;
    }

    private final List<Triangle> earcutLinkedList(Object polygon, Node currEar, List<Triangle> tessellation, State state2, boolean mortonOptimized, Monitor monitor, int depth) {
        block12: {
            Node currEar2 = currEar;
            State state3 = state2;
            block5: while (true) {
                Node node;
                if (currEar2 == null || currEar2.getPrevious() == currEar2.getNext()) {
                    return tessellation;
                }
                Node stop = currEar2;
                Node prevNode = null;
                Node nextNode = null;
                do {
                    boolean isReflex;
                    this.notifyMonitor(state3, depth, monitor, currEar2, tessellation);
                    prevNode = currEar2.getPrevious();
                    nextNode = currEar2.getNext();
                    Node node2 = prevNode;
                    Intrinsics.checkNotNull((Object)node2);
                    double d = node2.getX();
                    double d2 = prevNode.getY();
                    double d3 = currEar2.getX();
                    double d4 = currEar2.getY();
                    Node node3 = nextNode;
                    Intrinsics.checkNotNull((Object)node3);
                    boolean bl = isReflex = this.area(d, d2, d3, d4, node3.getX(), nextNode.getY()) >= 0.0;
                    if (!isReflex && this.isEar(currEar2, mortonOptimized)) {
                        boolean abFromPolygon = prevNode.isNextEdgeFromPolygon();
                        boolean bcFromPolygon = currEar2.isNextEdgeFromPolygon();
                        boolean caFromPolygon = this.isEdgeFromPolygon(prevNode, nextNode, mortonOptimized);
                        tessellation.add(new Triangle(prevNode, abFromPolygon, currEar2, bcFromPolygon, nextNode, caFromPolygon));
                        this.removeNode(currEar2, caFromPolygon);
                        currEar2 = nextNode.getNext();
                        stop = nextNode.getNext();
                    } else {
                        currEar2 = nextNode;
                        if (currEar2 == stop) {
                            switch (WhenMappings.$EnumSwitchMapping$0[state3.ordinal()]) {
                                case 1: {
                                    currEar2 = this.filterPoints(currEar2, null);
                                    state3 = State.CURE;
                                    continue block5;
                                }
                                case 2: {
                                    currEar2 = this.cureLocalIntersections(currEar2, tessellation, mortonOptimized);
                                    state3 = State.SPLIT;
                                    continue block5;
                                }
                                case 3: {
                                    if (!this.splitEarcut(polygon, currEar2, tessellation, mortonOptimized, monitor, depth + 1)) {
                                        this.notifyMonitor(state3.name() + "[FAILED]", monitor, currEar2, tessellation);
                                        throw new IllegalArgumentException("Unable to Tessellate shape. Possible malformed shape detected.");
                                    }
                                    break block12;
                                }
                                default: {
                                    throw new NoWhenBranchMatchedException();
                                }
                            }
                        }
                    }
                    node = currEar2;
                    Intrinsics.checkNotNull((Object)node);
                } while (node.getPrevious() != currEar2.getNext());
                break;
            }
        }
        return tessellation;
    }

    private final boolean isEar(Node ear, boolean mortonOptimized) {
        if (mortonOptimized) {
            return this.mortonIsEar(ear);
        }
        Intrinsics.checkNotNull((Object)ear.getNext());
        for (Node node = (v106007).getNext(); node != ear.getPrevious(); node = node.getNext()) {
            Node node2 = node;
            Intrinsics.checkNotNull((Object)node2);
            double d = node2.getX();
            double d2 = node.getY();
            Node node3 = ear.getPrevious();
            Intrinsics.checkNotNull((Object)node3);
            double d3 = node3.getX();
            Node node4 = ear.getPrevious();
            Intrinsics.checkNotNull((Object)node4);
            double d4 = node4.getY();
            double d5 = ear.getX();
            double d6 = ear.getY();
            Node node5 = ear.getNext();
            Intrinsics.checkNotNull((Object)node5);
            double d7 = node5.getX();
            Node node6 = ear.getNext();
            Intrinsics.checkNotNull((Object)node6);
            if (!this.pointInEar(d, d2, d3, d4, d5, d6, d7, node6.getY())) continue;
            Node node7 = node.getPrevious();
            Intrinsics.checkNotNull((Object)node7);
            double d8 = node7.getX();
            Node node8 = node.getPrevious();
            Intrinsics.checkNotNull((Object)node8);
            double d9 = node8.getY();
            double d10 = node.getX();
            double d11 = node.getY();
            Node node9 = node.getNext();
            Intrinsics.checkNotNull((Object)node9);
            double d12 = node9.getX();
            Node node10 = node.getNext();
            Intrinsics.checkNotNull((Object)node10);
            if (!(this.area(d8, d9, d10, d11, d12, node10.getY()) >= 0.0)) continue;
            return false;
        }
        return true;
    }

    private final boolean mortonIsEar(Node ear) {
        Node node = ear.getPrevious();
        Intrinsics.checkNotNull((Object)node);
        int n = StrictMath.INSTANCE.min(node.getX(), ear.getX());
        Node node2 = ear.getNext();
        Intrinsics.checkNotNull((Object)node2);
        int minTX = StrictMath.INSTANCE.min(n, node2.getX()) ^ Integer.MIN_VALUE;
        Node node3 = ear.getPrevious();
        Intrinsics.checkNotNull((Object)node3);
        int n2 = StrictMath.INSTANCE.min(node3.getY(), ear.getY());
        Node node4 = ear.getNext();
        Intrinsics.checkNotNull((Object)node4);
        int minTY = StrictMath.INSTANCE.min(n2, node4.getY()) ^ Integer.MIN_VALUE;
        Node node5 = ear.getPrevious();
        Intrinsics.checkNotNull((Object)node5);
        int n3 = StrictMath.INSTANCE.max(node5.getX(), ear.getX());
        Node node6 = ear.getNext();
        Intrinsics.checkNotNull((Object)node6);
        int maxTX = StrictMath.INSTANCE.max(n3, node6.getX()) ^ Integer.MIN_VALUE;
        Node node7 = ear.getPrevious();
        Intrinsics.checkNotNull((Object)node7);
        int n4 = StrictMath.INSTANCE.max(node7.getY(), ear.getY());
        Node node8 = ear.getNext();
        Intrinsics.checkNotNull((Object)node8);
        int maxTY = StrictMath.INSTANCE.max(n4, node8.getY()) ^ Integer.MIN_VALUE;
        long minZ = BitUtil.INSTANCE.interleave(minTX, minTY);
        long maxZ = BitUtil.INSTANCE.interleave(maxTX, maxTY);
        Node p = ear.getPreviousZ();
        Node n5 = ear.getNextZ();
        while (p != null) {
            if (LongExtKt.compareUnsigned(LongCompanionObject.INSTANCE, p.getMorton(), minZ) < 0 || n5 == null || LongExtKt.compareUnsigned(LongCompanionObject.INSTANCE, n5.getMorton(), maxZ) > 0) break;
            int n6 = p.getIdx();
            Node node9 = ear.getPrevious();
            Intrinsics.checkNotNull((Object)node9);
            if (n6 != node9.getIdx()) {
                int n7 = p.getIdx();
                Node node10 = ear.getNext();
                Intrinsics.checkNotNull((Object)node10);
                if (n7 != node10.getIdx()) {
                    double d = p.getX();
                    double d2 = p.getY();
                    Node node11 = ear.getPrevious();
                    Intrinsics.checkNotNull((Object)node11);
                    double d3 = node11.getX();
                    Node node12 = ear.getPrevious();
                    Intrinsics.checkNotNull((Object)node12);
                    double d4 = node12.getY();
                    double d5 = ear.getX();
                    double d6 = ear.getY();
                    Node node13 = ear.getNext();
                    Intrinsics.checkNotNull((Object)node13);
                    double d7 = node13.getX();
                    Node node14 = ear.getNext();
                    Intrinsics.checkNotNull((Object)node14);
                    if (this.pointInEar(d, d2, d3, d4, d5, d6, d7, node14.getY())) {
                        Node node15 = p.getPrevious();
                        Intrinsics.checkNotNull((Object)node15);
                        double d8 = node15.getX();
                        Node node16 = p.getPrevious();
                        Intrinsics.checkNotNull((Object)node16);
                        double d9 = node16.getY();
                        double d10 = p.getX();
                        double d11 = p.getY();
                        Node node17 = p.getNext();
                        Intrinsics.checkNotNull((Object)node17);
                        double d12 = node17.getX();
                        Node node18 = p.getNext();
                        Intrinsics.checkNotNull((Object)node18);
                        if (this.area(d8, d9, d10, d11, d12, node18.getY()) >= 0.0) {
                            return false;
                        }
                    }
                }
            }
            p = p.getPreviousZ();
            int n8 = n5.getIdx();
            Node node19 = ear.getPrevious();
            Intrinsics.checkNotNull((Object)node19);
            if (n8 != node19.getIdx()) {
                int n9 = n5.getIdx();
                Node node20 = ear.getNext();
                Intrinsics.checkNotNull((Object)node20);
                if (n9 != node20.getIdx()) {
                    double d = n5.getX();
                    double d13 = n5.getY();
                    Node node21 = ear.getPrevious();
                    Intrinsics.checkNotNull((Object)node21);
                    double d14 = node21.getX();
                    Node node22 = ear.getPrevious();
                    Intrinsics.checkNotNull((Object)node22);
                    double d15 = node22.getY();
                    double d16 = ear.getX();
                    double d17 = ear.getY();
                    Node node23 = ear.getNext();
                    Intrinsics.checkNotNull((Object)node23);
                    double d18 = node23.getX();
                    Node node24 = ear.getNext();
                    Intrinsics.checkNotNull((Object)node24);
                    if (this.pointInEar(d, d13, d14, d15, d16, d17, d18, node24.getY())) {
                        Node node25 = n5.getPrevious();
                        Intrinsics.checkNotNull((Object)node25);
                        double d19 = node25.getX();
                        Node node26 = n5.getPrevious();
                        Intrinsics.checkNotNull((Object)node26);
                        double d20 = node26.getY();
                        double d21 = n5.getX();
                        double d22 = n5.getY();
                        Node node27 = n5.getNext();
                        Intrinsics.checkNotNull((Object)node27);
                        double d23 = node27.getX();
                        Node node28 = n5.getNext();
                        Intrinsics.checkNotNull((Object)node28);
                        if (this.area(d19, d20, d21, d22, d23, node28.getY()) >= 0.0) {
                            return false;
                        }
                    }
                }
            }
            n5 = n5.getNextZ();
        }
        while (p != null && LongExtKt.compareUnsigned(LongCompanionObject.INSTANCE, p.getMorton(), minZ) >= 0) {
            int n10 = p.getIdx();
            Node node29 = ear.getPrevious();
            Intrinsics.checkNotNull((Object)node29);
            if (n10 != node29.getIdx()) {
                int n11 = p.getIdx();
                Node node30 = ear.getNext();
                Intrinsics.checkNotNull((Object)node30);
                if (n11 != node30.getIdx()) {
                    double d = p.getX();
                    double d24 = p.getY();
                    Node node31 = ear.getPrevious();
                    Intrinsics.checkNotNull((Object)node31);
                    double d25 = node31.getX();
                    Node node32 = ear.getPrevious();
                    Intrinsics.checkNotNull((Object)node32);
                    double d26 = node32.getY();
                    double d27 = ear.getX();
                    double d28 = ear.getY();
                    Node node33 = ear.getNext();
                    Intrinsics.checkNotNull((Object)node33);
                    double d29 = node33.getX();
                    Node node34 = ear.getNext();
                    Intrinsics.checkNotNull((Object)node34);
                    if (this.pointInEar(d, d24, d25, d26, d27, d28, d29, node34.getY())) {
                        Node node35 = p.getPrevious();
                        Intrinsics.checkNotNull((Object)node35);
                        double d30 = node35.getX();
                        Node node36 = p.getPrevious();
                        Intrinsics.checkNotNull((Object)node36);
                        double d31 = node36.getY();
                        double d32 = p.getX();
                        double d33 = p.getY();
                        Node node37 = p.getNext();
                        Intrinsics.checkNotNull((Object)node37);
                        double d34 = node37.getX();
                        Node node38 = p.getNext();
                        Intrinsics.checkNotNull((Object)node38);
                        if (this.area(d30, d31, d32, d33, d34, node38.getY()) >= 0.0) {
                            return false;
                        }
                    }
                }
            }
            p = p.getPreviousZ();
        }
        while (n5 != null && LongExtKt.compareUnsigned(LongCompanionObject.INSTANCE, n5.getMorton(), maxZ) <= 0) {
            int n12 = n5.getIdx();
            Node node39 = ear.getPrevious();
            Intrinsics.checkNotNull((Object)node39);
            if (n12 != node39.getIdx()) {
                int n13 = n5.getIdx();
                Node node40 = ear.getNext();
                Intrinsics.checkNotNull((Object)node40);
                if (n13 != node40.getIdx()) {
                    double d = n5.getX();
                    double d35 = n5.getY();
                    Node node41 = ear.getPrevious();
                    Intrinsics.checkNotNull((Object)node41);
                    double d36 = node41.getX();
                    Node node42 = ear.getPrevious();
                    Intrinsics.checkNotNull((Object)node42);
                    double d37 = node42.getY();
                    double d38 = ear.getX();
                    double d39 = ear.getY();
                    Node node43 = ear.getNext();
                    Intrinsics.checkNotNull((Object)node43);
                    double d40 = node43.getX();
                    Node node44 = ear.getNext();
                    Intrinsics.checkNotNull((Object)node44);
                    if (this.pointInEar(d, d35, d36, d37, d38, d39, d40, node44.getY())) {
                        Node node45 = n5.getPrevious();
                        Intrinsics.checkNotNull((Object)node45);
                        double d41 = node45.getX();
                        Node node46 = n5.getPrevious();
                        Intrinsics.checkNotNull((Object)node46);
                        double d42 = node46.getY();
                        double d43 = n5.getX();
                        double d44 = n5.getY();
                        Node node47 = n5.getNext();
                        Intrinsics.checkNotNull((Object)node47);
                        double d45 = node47.getX();
                        Node node48 = n5.getNext();
                        Intrinsics.checkNotNull((Object)node48);
                        if (this.area(d41, d42, d43, d44, d45, node48.getY()) >= 0.0) {
                            return false;
                        }
                    }
                }
            }
            n5 = n5.getNextZ();
        }
        return true;
    }

    private final Node cureLocalIntersections(Node startNode, List<Triangle> tessellation, boolean mortonOptimized) {
        Node startNode2;
        Node node = startNode2 = startNode;
        Node nextNode = null;
        do {
            Node node2 = node;
            Intrinsics.checkNotNull((Object)node2);
            nextNode = node2.getNext();
            Node a = node.getPrevious();
            Node node3 = nextNode;
            Intrinsics.checkNotNull((Object)node3);
            Node b = node3.getNext();
            Node node4 = a;
            Intrinsics.checkNotNull((Object)node4);
            Node node5 = b;
            Intrinsics.checkNotNull((Object)node5);
            if (this.isVertexEquals(node4, node5) || !this.linesIntersect(a.getX(), a.getY(), node.getX(), node.getY(), nextNode.getX(), nextNode.getY(), b.getX(), b.getY()) || !this.isLocallyInside(a, b) || !this.isLocallyInside(b, a) || this.isIntersectingPolygon(a, a.getX(), a.getY(), b.getX(), b.getY())) continue;
            boolean abFromPolygon = a.getNext() == node ? a.isNextEdgeFromPolygon() : this.isEdgeFromPolygon(a, node, mortonOptimized);
            boolean bcFromPolygon = node.getNext() == b ? node.isNextEdgeFromPolygon() : this.isEdgeFromPolygon(node, b, mortonOptimized);
            boolean caFromPolygon = b.getNext() == a ? b.isNextEdgeFromPolygon() : this.isEdgeFromPolygon(a, b, mortonOptimized);
            tessellation.add(new Triangle(a, abFromPolygon, node, bcFromPolygon, b, caFromPolygon));
            tessellation.add(new Triangle(a, abFromPolygon, node, bcFromPolygon, b, caFromPolygon));
            this.removeNode(node, caFromPolygon);
            Node node6 = node.getNext();
            Intrinsics.checkNotNull((Object)node6);
            this.removeNode(node6, caFromPolygon);
            node = startNode2 = b;
        } while ((node = node.getNext()) != startNode2);
        return node;
    }

    private final boolean splitEarcut(Object polygon, Node start, List<Triangle> tessellation, boolean mortonOptimized, Monitor monitor, int depth) {
        Node searchNode = start;
        do {
            Node node = searchNode;
            Intrinsics.checkNotNull((Object)node);
            Node nextNode = node.getNext();
            Intrinsics.checkNotNull((Object)nextNode);
            for (Node diagonal = (v106646).getNext(); diagonal != searchNode.getPrevious(); diagonal = diagonal.getNext()) {
                int n = searchNode.getIdx();
                Node node2 = diagonal;
                Intrinsics.checkNotNull((Object)node2);
                if (n == node2.getIdx() || !this.isValidDiagonal(searchNode, diagonal)) continue;
                Node splitNode = this.splitPolygon(searchNode, diagonal, this.isEdgeFromPolygon(searchNode, diagonal, mortonOptimized));
                searchNode = this.filterPoints(searchNode, searchNode.getNext());
                Node node3 = splitNode;
                Intrinsics.checkNotNull((Object)node3);
                splitNode = this.filterPoints(splitNode, node3.getNext());
                if (mortonOptimized) {
                    this.sortByMortonWithReset(searchNode);
                    this.sortByMortonWithReset(splitNode);
                }
                this.notifyMonitorSplit(depth, monitor, searchNode, splitNode);
                this.earcutLinkedList(polygon, searchNode, tessellation, State.INIT, mortonOptimized, monitor, depth);
                this.earcutLinkedList(polygon, splitNode, tessellation, State.INIT, mortonOptimized, monitor, depth);
                this.notifyMonitorSplitEnd(depth, monitor);
                return true;
            }
        } while ((searchNode = searchNode.getNext()) != start);
        return this.signedArea(start, start) == 0.0;
    }

    private final void checkIntersection(Node a, boolean isMorton) {
        Node node = a;
        Intrinsics.checkNotNull((Object)node);
        Node next = node.getNext();
        do {
            Node node2 = next;
            Intrinsics.checkNotNull((Object)node2);
            Node innerNext = node2.getNext();
            if (isMorton) {
                Node node3 = innerNext;
                Intrinsics.checkNotNull((Object)node3);
                this.mortonCheckIntersection(next, node3);
                continue;
            }
            do {
                Node node4 = innerNext;
                Intrinsics.checkNotNull((Object)node4);
                this.checkIntersectionPoint(next, node4);
            } while ((innerNext = innerNext.getNext()) != next.getPrevious());
        } while ((next = next.getNext()) != a.getPrevious());
    }

    private final void mortonCheckIntersection(Node a, Node b) {
        int n = a.getX();
        Node node = a.getNext();
        Intrinsics.checkNotNull((Object)node);
        int minTX = StrictMath.INSTANCE.min(n, node.getX()) ^ Integer.MIN_VALUE;
        int n2 = a.getY();
        Node node2 = a.getNext();
        Intrinsics.checkNotNull((Object)node2);
        int minTY = StrictMath.INSTANCE.min(n2, node2.getY()) ^ Integer.MIN_VALUE;
        int n3 = a.getX();
        Node node3 = a.getNext();
        Intrinsics.checkNotNull((Object)node3);
        int maxTX = StrictMath.INSTANCE.max(n3, node3.getX()) ^ Integer.MIN_VALUE;
        int n4 = a.getY();
        Node node4 = a.getNext();
        Intrinsics.checkNotNull((Object)node4);
        int maxTY = StrictMath.INSTANCE.max(n4, node4.getY()) ^ Integer.MIN_VALUE;
        long minZ = BitUtil.INSTANCE.interleave(minTX, minTY);
        long maxZ = BitUtil.INSTANCE.interleave(maxTX, maxTY);
        Node p = b.getPreviousZ();
        Node n5 = b.getNextZ();
        while (p != null) {
            if (LongExtKt.compareUnsigned(LongCompanionObject.INSTANCE, p.getMorton(), minZ) < 0 || n5 == null || LongExtKt.compareUnsigned(LongCompanionObject.INSTANCE, n5.getMorton(), maxZ) > 0) break;
            this.checkIntersectionPoint(p, a);
            p = p.getPreviousZ();
            this.checkIntersectionPoint(n5, a);
            n5 = n5.getNextZ();
        }
        while (p != null && LongExtKt.compareUnsigned(LongCompanionObject.INSTANCE, p.getMorton(), minZ) >= 0) {
            this.checkIntersectionPoint(p, a);
            p = p.getPreviousZ();
        }
        while (n5 != null && LongExtKt.compareUnsigned(LongCompanionObject.INSTANCE, n5.getMorton(), maxZ) <= 0) {
            this.checkIntersectionPoint(n5, a);
            n5 = n5.getNextZ();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void checkIntersectionPoint(Node a, Node b) {
        if (a == b) {
            return;
        }
        double d = a.getY();
        Node node = a.getNext();
        Intrinsics.checkNotNull((Object)node);
        double d2 = Math.max(d, node.getY());
        double d3 = b.getY();
        Node node2 = b.getNext();
        Intrinsics.checkNotNull((Object)node2);
        if (d2 <= Math.min(d3, node2.getY())) return;
        double d4 = a.getY();
        Node node3 = a.getNext();
        Intrinsics.checkNotNull((Object)node3);
        double d5 = Math.min(d4, node3.getY());
        double d6 = b.getY();
        Node node4 = b.getNext();
        Intrinsics.checkNotNull((Object)node4);
        if (d5 >= Math.max(d6, node4.getY())) return;
        double d7 = a.getX();
        Node node5 = a.getNext();
        Intrinsics.checkNotNull((Object)node5);
        double d8 = Math.max(d7, node5.getX());
        double d9 = b.getX();
        Node node6 = b.getNext();
        Intrinsics.checkNotNull((Object)node6);
        if (d8 <= Math.min(d9, node6.getX())) return;
        double d10 = a.getX();
        Node node7 = a.getNext();
        Intrinsics.checkNotNull((Object)node7);
        double d11 = Math.min(d10, node7.getX());
        double d12 = b.getX();
        Node node8 = b.getNext();
        Intrinsics.checkNotNull((Object)node8);
        if (d11 >= Math.max(d12, node8.getX())) {
            return;
        }
        double d13 = a.getX();
        double d14 = a.getY();
        Node node9 = a.getNext();
        Intrinsics.checkNotNull((Object)node9);
        double d15 = node9.getX();
        Node node10 = a.getNext();
        Intrinsics.checkNotNull((Object)node10);
        double d16 = node10.getY();
        double d17 = b.getX();
        double d18 = b.getY();
        Node node11 = b.getNext();
        Intrinsics.checkNotNull((Object)node11);
        double d19 = node11.getX();
        Node node12 = b.getNext();
        Intrinsics.checkNotNull((Object)node12);
        if (GeoUtils.INSTANCE.lineCrossesLine(d13, d14, d15, d16, d17, d18, d19, node12.getY())) {
            Node node13 = a.getNext();
            Intrinsics.checkNotNull((Object)node13);
            double a1 = node13.getY() - a.getY();
            double d20 = a.getX();
            Node node14 = a.getNext();
            Intrinsics.checkNotNull((Object)node14);
            double b1 = d20 - node14.getX();
            double c1 = a1 * a.getX() + b1 * a.getY();
            Node node15 = b.getNext();
            Intrinsics.checkNotNull((Object)node15);
            double a2 = node15.getY() - b.getY();
            double d21 = b.getX();
            Node node16 = b.getNext();
            Intrinsics.checkNotNull((Object)node16);
            double b2 = d21 - node16.getX();
            double c2 = a2 * b.getX() + b2 * b.getY();
            double determinant = a1 * b2 - a2 * b1;
            if (!(!(determinant == 0.0))) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            double x = (b2 * c1 - b1 * c2) / determinant;
            double y = (a1 * c2 - a2 * c1) / determinant;
            throw new IllegalArgumentException("Polygon self-intersection at lat=" + y + " lon=" + x);
        }
        if (!a.isNextEdgeFromPolygon()) return;
        if (!b.isNextEdgeFromPolygon()) return;
        double d22 = a.getX();
        double d23 = a.getY();
        Node node17 = a.getNext();
        Intrinsics.checkNotNull((Object)node17);
        double d24 = node17.getX();
        Node node18 = a.getNext();
        Intrinsics.checkNotNull((Object)node18);
        double d25 = node18.getY();
        double d26 = b.getX();
        double d27 = b.getY();
        Node node19 = b.getNext();
        Intrinsics.checkNotNull((Object)node19);
        double d28 = node19.getX();
        Node node20 = b.getNext();
        Intrinsics.checkNotNull((Object)node20);
        if (!GeoUtils.INSTANCE.lineOverlapLine(d22, d23, d24, d25, d26, d27, d28, node20.getY())) {
            return;
        }
        boolean bl = false;
        if (bl) return;
        boolean bl2 = false;
        String string = "Polygon ring self-intersection at lat=" + a.getY() + " lon=" + a.getX();
        throw new IllegalArgumentException(string.toString());
    }

    private final boolean isEdgeFromPolygon(Node a, Node b, boolean isMorton) {
        if (isMorton) {
            return this.isMortonEdgeFromPolygon(a, b);
        }
        Node next = a;
        do {
            Node node = next;
            Intrinsics.checkNotNull((Object)node);
            Node node2 = next.getNext();
            Intrinsics.checkNotNull((Object)node2);
            if (this.isPointInLine(node, node2, a)) {
                Node node3 = next.getNext();
                Intrinsics.checkNotNull((Object)node3);
                if (this.isPointInLine(next, node3, b)) {
                    return next.isNextEdgeFromPolygon();
                }
            }
            Node node4 = next.getPrevious();
            Intrinsics.checkNotNull((Object)node4);
            if (!this.isPointInLine(next, node4, a)) continue;
            Node node5 = next.getPrevious();
            Intrinsics.checkNotNull((Object)node5);
            if (!this.isPointInLine(next, node5, b)) continue;
            Node node6 = next.getPrevious();
            Intrinsics.checkNotNull((Object)node6);
            return node6.isNextEdgeFromPolygon();
        } while ((next = next.getNext()) != a);
        return false;
    }

    private final boolean isMortonEdgeFromPolygon(Node a, Node b) {
        int minTX = StrictMath.INSTANCE.min(a.getX(), b.getX()) ^ Integer.MIN_VALUE;
        int minTY = StrictMath.INSTANCE.min(a.getY(), b.getY()) ^ Integer.MIN_VALUE;
        int maxTX = StrictMath.INSTANCE.max(a.getX(), b.getX()) ^ Integer.MIN_VALUE;
        int maxTY = StrictMath.INSTANCE.max(a.getY(), b.getY()) ^ Integer.MIN_VALUE;
        long minZ = BitUtil.INSTANCE.interleave(minTX, minTY);
        long maxZ = BitUtil.INSTANCE.interleave(maxTX, maxTY);
        Node p = a.getPreviousZ();
        Node n = a.getNextZ();
        while (p != null) {
            if (LongExtKt.compareUnsigned(LongCompanionObject.INSTANCE, p.getMorton(), minZ) < 0 || n == null || LongExtKt.compareUnsigned(LongCompanionObject.INSTANCE, n.getMorton(), maxZ) > 0) break;
            Node node = p.getNext();
            Intrinsics.checkNotNull((Object)node);
            if (this.isPointInLine(p, node, a)) {
                Node node2 = p.getNext();
                Intrinsics.checkNotNull((Object)node2);
                if (this.isPointInLine(p, node2, b)) {
                    return p.isNextEdgeFromPolygon();
                }
            }
            Node node3 = p.getPrevious();
            Intrinsics.checkNotNull((Object)node3);
            if (this.isPointInLine(p, node3, a)) {
                Node node4 = p.getPrevious();
                Intrinsics.checkNotNull((Object)node4);
                if (this.isPointInLine(p, node4, b)) {
                    Node node5 = p.getPrevious();
                    Intrinsics.checkNotNull((Object)node5);
                    return node5.isNextEdgeFromPolygon();
                }
            }
            p = p.getPreviousZ();
            Node node6 = n.getNext();
            Intrinsics.checkNotNull((Object)node6);
            if (this.isPointInLine(n, node6, a)) {
                Node node7 = n.getNext();
                Intrinsics.checkNotNull((Object)node7);
                if (this.isPointInLine(n, node7, b)) {
                    return n.isNextEdgeFromPolygon();
                }
            }
            Node node8 = n.getPrevious();
            Intrinsics.checkNotNull((Object)node8);
            if (this.isPointInLine(n, node8, a)) {
                Node node9 = n.getPrevious();
                Intrinsics.checkNotNull((Object)node9);
                if (this.isPointInLine(n, node9, b)) {
                    Node node10 = n.getPrevious();
                    Intrinsics.checkNotNull((Object)node10);
                    return node10.isNextEdgeFromPolygon();
                }
            }
            n = n.getNextZ();
        }
        while (p != null && LongExtKt.compareUnsigned(LongCompanionObject.INSTANCE, p.getMorton(), minZ) >= 0) {
            Node node = p.getNext();
            Intrinsics.checkNotNull((Object)node);
            if (this.isPointInLine(p, node, a)) {
                Node node11 = p.getNext();
                Intrinsics.checkNotNull((Object)node11);
                if (this.isPointInLine(p, node11, b)) {
                    return p.isNextEdgeFromPolygon();
                }
            }
            Node node12 = p.getPrevious();
            Intrinsics.checkNotNull((Object)node12);
            if (this.isPointInLine(p, node12, a)) {
                Node node13 = p.getPrevious();
                Intrinsics.checkNotNull((Object)node13);
                if (this.isPointInLine(p, node13, b)) {
                    Node node14 = p.getPrevious();
                    Intrinsics.checkNotNull((Object)node14);
                    return node14.isNextEdgeFromPolygon();
                }
            }
            p = p.getPreviousZ();
        }
        while (n != null && LongExtKt.compareUnsigned(LongCompanionObject.INSTANCE, n.getMorton(), maxZ) <= 0) {
            Node node = n.getNext();
            Intrinsics.checkNotNull((Object)node);
            if (this.isPointInLine(n, node, a)) {
                Node node15 = n.getNext();
                Intrinsics.checkNotNull((Object)node15);
                if (this.isPointInLine(n, node15, b)) {
                    return n.isNextEdgeFromPolygon();
                }
            }
            Node node16 = n.getPrevious();
            Intrinsics.checkNotNull((Object)node16);
            if (this.isPointInLine(n, node16, a)) {
                Node node17 = n.getPrevious();
                Intrinsics.checkNotNull((Object)node17);
                if (this.isPointInLine(n, node17, b)) {
                    Node node18 = n.getPrevious();
                    Intrinsics.checkNotNull((Object)node18);
                    return node18.isNextEdgeFromPolygon();
                }
            }
            n = n.getNextZ();
        }
        return false;
    }

    private final boolean isPointInLine(Node a, Node b, Node point) {
        return this.isPointInLine(a, b, point.getX(), point.getY());
    }

    private final boolean isPointInLine(Node a, Node b, double lon, double lat) {
        double dxc = lon - a.getX();
        double dyc = lat - a.getY();
        double dxl = b.getX() - a.getX();
        double dyl = b.getY() - a.getY();
        if (dxc * dyl - dyc * dxl == 0.0) {
            return Math.abs(dxl) >= Math.abs(dyl) ? (dxl > 0.0 ? a.getX() <= lon && lon <= b.getX() : b.getX() <= lon && lon <= a.getX()) : (dyl > 0.0 ? a.getY() <= lat && lat <= b.getY() : b.getY() <= lat && lat <= a.getY());
        }
        return false;
    }

    private final Node splitPolygon(Node a, Node b, boolean edgeFromPolygon) {
        Node a2 = new Node(a);
        Node b2 = new Node(b);
        Node an = a.getNext();
        Node bp = b.getPrevious();
        a.setNext(b);
        a.setNextEdgeFromPolygon(edgeFromPolygon);
        a.setNextZ(b);
        b.setPrevious(a);
        b.setPreviousZ(a);
        a2.setNext(an);
        a2.setNextZ(an);
        Node node = an;
        Intrinsics.checkNotNull((Object)node);
        node.setPrevious(a2);
        an.setPreviousZ(a2);
        b2.setNext(a2);
        b2.setNextEdgeFromPolygon(edgeFromPolygon);
        b2.setNextZ(a2);
        a2.setPrevious(b2);
        a2.setPreviousZ(b2);
        Node node2 = bp;
        Intrinsics.checkNotNull((Object)node2);
        node2.setNext(b2);
        bp.setNextZ(b2);
        return b2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isValidDiagonal(Node a, Node b) {
        Node node = a.getNext();
        Intrinsics.checkNotNull((Object)node);
        if (node.getIdx() == b.getIdx()) return false;
        Node node2 = a.getPrevious();
        Intrinsics.checkNotNull((Object)node2);
        if (node2.getIdx() == b.getIdx()) return false;
        Node node3 = a.getPrevious();
        Intrinsics.checkNotNull((Object)node3);
        if (!this.isLocallyInside(node3, b)) return false;
        Node node4 = b.getNext();
        Intrinsics.checkNotNull((Object)node4);
        if (!this.isLocallyInside(node4, a)) return false;
        if (!this.isCWPolygon(a, b)) return false;
        if (!this.isCWPolygon(b, a)) {
            return false;
        }
        if (this.isVertexEquals(a, b)) {
            return true;
        }
        if (!this.isLocallyInside(a, b)) return false;
        if (!this.isLocallyInside(b, a)) return false;
        if (!this.middleInsert(a, a.getX(), a.getY(), b.getX(), b.getY())) return false;
        Node node5 = a.getPrevious();
        Intrinsics.checkNotNull((Object)node5);
        double d = node5.getX();
        Node node6 = a.getPrevious();
        Intrinsics.checkNotNull((Object)node6);
        if (this.area(d, node6.getY(), a.getX(), a.getY(), b.getX(), b.getY()) == 0.0) {
            return false;
        }
        boolean bl = false;
        if (bl) return false;
        double d2 = a.getX();
        double d3 = a.getY();
        double d4 = b.getX();
        double d5 = b.getY();
        Node node7 = b.getNext();
        Intrinsics.checkNotNull((Object)node7);
        double d6 = node7.getX();
        Node node8 = b.getNext();
        Intrinsics.checkNotNull((Object)node8);
        if (this.area(d2, d3, d4, d5, d6, node8.getY()) == 0.0) {
            return false;
        }
        boolean bl2 = false;
        if (bl2) return false;
        Node node9 = a.getNext();
        Intrinsics.checkNotNull((Object)node9);
        double d7 = node9.getX();
        Node node10 = a.getNext();
        Intrinsics.checkNotNull((Object)node10);
        if (this.area(d7, node10.getY(), a.getX(), a.getY(), b.getX(), b.getY()) == 0.0) {
            return false;
        }
        boolean bl3 = false;
        if (bl3) return false;
        double d8 = a.getX();
        double d9 = a.getY();
        double d10 = b.getX();
        double d11 = b.getY();
        Node node11 = b.getPrevious();
        Intrinsics.checkNotNull((Object)node11);
        double d12 = node11.getX();
        Node node12 = b.getPrevious();
        Intrinsics.checkNotNull((Object)node12);
        if (this.area(d8, d9, d10, d11, d12, node12.getY()) == 0.0) {
            return false;
        }
        boolean bl4 = false;
        if (bl4) return false;
        if (this.isIntersectingPolygon(a, a.getX(), a.getY(), b.getX(), b.getY())) return false;
        return true;
    }

    private final boolean isCWPolygon(Node start, Node end) {
        return this.signedArea(start, end) < 0.0;
    }

    private final double signedArea(Node start, Node end) {
        Node node;
        Node next = start;
        double windingSum = 0.0;
        do {
            Node node2 = next;
            Intrinsics.checkNotNull((Object)node2);
            double d = node2.getX();
            double d2 = next.getY();
            Node node3 = next.getNext();
            Intrinsics.checkNotNull((Object)node3);
            double d3 = node3.getX();
            Node node4 = next.getNext();
            Intrinsics.checkNotNull((Object)node4);
            windingSum += this.area(d, d2, d3, node4.getY(), end.getX(), end.getY());
            node = next = next.getNext();
            Intrinsics.checkNotNull((Object)node);
        } while (node.getNext() != end);
        return windingSum;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isLocallyInside(Node a, Node b) {
        Node node = a.getPrevious();
        Intrinsics.checkNotNull((Object)node);
        double d = node.getX();
        Node node2 = a.getPrevious();
        Intrinsics.checkNotNull((Object)node2);
        double d2 = node2.getY();
        double d3 = a.getX();
        double d4 = a.getY();
        Node node3 = a.getNext();
        Intrinsics.checkNotNull((Object)node3);
        double d5 = node3.getX();
        Node node4 = a.getNext();
        Intrinsics.checkNotNull((Object)node4);
        double area = this.area(d, d2, d3, d4, d5, node4.getY());
        if (area == 0.0) {
            return false;
        }
        boolean bl = false;
        if (bl) {
            return false;
        }
        if (area < 0.0) {
            double d6 = a.getX();
            double d7 = a.getY();
            double d8 = b.getX();
            double d9 = b.getY();
            Node node5 = a.getNext();
            Intrinsics.checkNotNull((Object)node5);
            double d10 = node5.getX();
            Node node6 = a.getNext();
            Intrinsics.checkNotNull((Object)node6);
            if (!(this.area(d6, d7, d8, d9, d10, node6.getY()) >= 0.0)) return false;
            double d11 = a.getX();
            double d12 = a.getY();
            Node node7 = a.getPrevious();
            Intrinsics.checkNotNull((Object)node7);
            double d13 = node7.getX();
            Node node8 = a.getPrevious();
            Intrinsics.checkNotNull((Object)node8);
            if (!(this.area(d11, d12, d13, node8.getY(), b.getX(), b.getY()) >= 0.0)) return false;
            return true;
        }
        double d14 = a.getX();
        double d15 = a.getY();
        double d16 = b.getX();
        double d17 = b.getY();
        Node node9 = a.getPrevious();
        Intrinsics.checkNotNull((Object)node9);
        double d18 = node9.getX();
        Node node10 = a.getPrevious();
        Intrinsics.checkNotNull((Object)node10);
        if (this.area(d14, d15, d16, d17, d18, node10.getY()) < 0.0) return true;
        double d19 = a.getX();
        double d20 = a.getY();
        Node node11 = a.getNext();
        Intrinsics.checkNotNull((Object)node11);
        double d21 = node11.getX();
        Node node12 = a.getNext();
        Intrinsics.checkNotNull((Object)node12);
        if (!(this.area(d19, d20, d21, node12.getY(), b.getX(), b.getY()) < 0.0)) return false;
        return true;
    }

    private final boolean middleInsert(Node start, double x0, double y0, double x1, double y1) {
        Node node = start;
        Node nextNode = null;
        boolean lIsInside = false;
        double lDx = (x0 + x1) / (double)2.0f;
        double lDy = (y0 + y1) / (double)2.0f;
        do {
            Node node2 = node;
            Intrinsics.checkNotNull((Object)node2);
            nextNode = node2.getNext();
            boolean bl = node.getY() > lDy;
            Node node3 = nextNode;
            Intrinsics.checkNotNull((Object)node3);
            if (bl == node3.getY() > lDy || !(lDx < (nextNode.getX() - node.getX()) * (lDy - node.getY()) / (nextNode.getY() - node.getY()) + node.getX())) continue;
            boolean bl2 = lIsInside = !lIsInside;
        } while ((node = node.getNext()) != start);
        return lIsInside;
    }

    private final boolean isIntersectingPolygon(Node start, double x0, double y0, double x1, double y1) {
        Node node = start;
        Node nextNode = null;
        do {
            Node node2 = node;
            Intrinsics.checkNotNull((Object)node2);
            nextNode = node2.getNext();
            if (this.isVertexEquals(node, x0, y0)) continue;
            if (this.isVertexEquals(node, x1, y1)) continue;
            double d = node.getX();
            double d2 = node.getY();
            Node node3 = nextNode;
            Intrinsics.checkNotNull((Object)node3);
            if (!this.linesIntersect(d, d2, node3.getX(), nextNode.getY(), x0, y0, x1, y1)) continue;
            return true;
        } while ((node = nextNode) != start);
        return false;
    }

    public final boolean linesIntersect(double aX0, double aY0, double aX1, double aY1, double bX0, double bY0, double bX1, double bY1) {
        return this.area(aX0, aY0, aX1, aY1, bX0, bY0) > 0.0 != this.area(aX0, aY0, aX1, aY1, bX1, bY1) > 0.0 && this.area(bX0, bY0, bX1, bY1, aX0, aY0) > 0.0 != this.area(bX0, bY0, bX1, bY1, aX1, aY1) > 0.0;
    }

    private final void sortByMortonWithReset(Node start) {
        Node next = start;
        do {
            Node node = next;
            Intrinsics.checkNotNull((Object)node);
            node.setPreviousZ(next.getPrevious());
            next.setNextZ(next.getNext());
        } while ((next = next.getNext()) != start);
        this.sortByMorton(start);
    }

    private final void sortByMorton(Node start) {
        Node node = start;
        Intrinsics.checkNotNull((Object)node);
        Node node2 = node.getPreviousZ();
        Intrinsics.checkNotNull((Object)node2);
        node2.setNextZ(null);
        start.setPreviousZ(null);
        this.tathamSort(start);
    }

    /*
     * Unable to fully structure code
     */
    private final void tathamSort(Node list) {
        list = list;
        p = null;
        q = null;
        e = null;
        tail = null;
        i = 0;
        numMerges = 0;
        pSize = 0;
        qSize = 0;
        inSize = 1;
        if (list == null) {
            return;
        }
        do {
            p = list;
            list = null;
            tail = null;
            numMerges = 0;
            while (p != null) {
                ++numMerges;
                q = p;
                i = 0;
                pSize = 0;
                while (i < inSize && q != null) {
                    ++i;
                    ++pSize;
                    q = q.getNextZ();
                }
                qSize = inSize;
                while (pSize > 0 || qSize > 0 && q != null) {
                    if (pSize == 0) ** GOTO lbl-1000
                    if (qSize == 0 || q == null) ** GOTO lbl-1000
                    v0 = p;
                    Intrinsics.checkNotNull((Object)v0);
                    if (LongExtKt.compareUnsigned(LongCompanionObject.INSTANCE, v0.getMorton(), q.getMorton()) <= 0) lbl-1000:
                    // 2 sources

                    {
                        e = p;
                        v1 = p;
                        Intrinsics.checkNotNull((Object)v1);
                        p = v1.getNextZ();
                        --pSize;
                    } else lbl-1000:
                    // 2 sources

                    {
                        e = q;
                        v2 = q;
                        Intrinsics.checkNotNull((Object)v2);
                        q = v2.getNextZ();
                        --qSize;
                    }
                    if (tail != null) {
                        tail.setNextZ(e);
                    } else {
                        list = e;
                    }
                    e.setPreviousZ(tail);
                    tail = e;
                }
                p = q;
            }
            v3 = tail;
            Intrinsics.checkNotNull(v3);
            v3.setNextZ(null);
            inSize *= 2;
        } while (numMerges > 1);
    }

    private final Node filterPoints(Node start, Node end) {
        Node end2 = end;
        if (start == null) {
            return start;
        }
        if (end2 == null) {
            end2 = start;
        }
        Node node = start;
        Node nextNode = null;
        Node prevNode = null;
        boolean continueIteration = false;
        do {
            block7: {
                block6: {
                    continueIteration = false;
                    nextNode = node.getNext();
                    prevNode = node.getPrevious();
                    Node node2 = nextNode;
                    Intrinsics.checkNotNull((Object)node2);
                    if (this.isVertexEquals(node, node2)) break block6;
                    Node node3 = prevNode;
                    Intrinsics.checkNotNull((Object)node3);
                    if (!this.isVertexEquals(node3, nextNode) && (prevNode.isNextEdgeFromPolygon() != node.isNextEdgeFromPolygon() && !this.isPointInLine(prevNode, node, nextNode.getX(), nextNode.getY()) || !(this.area(prevNode.getX(), prevNode.getY(), node.getX(), node.getY(), nextNode.getX(), nextNode.getY()) == 0.0))) break block7;
                }
                Node node4 = prevNode;
                Intrinsics.checkNotNull((Object)node4);
                this.removeNode(node, node4.isNextEdgeFromPolygon());
                node = end2 = prevNode;
                if (node == nextNode) break;
                continueIteration = true;
                continue;
            }
            node = nextNode;
        } while (continueIteration || node != end2);
        return end2;
    }

    private final Node insertNode(double[] x, double[] y, int index, int vertexIndex, Node lastNode, boolean isGeo) {
        Node node = new Node(x, y, index, vertexIndex, isGeo);
        if (lastNode == null) {
            node.setPrevious(node);
            node.setPreviousZ(node);
            node.setNext(node);
            node.setNextZ(node);
        } else {
            node.setNext(lastNode.getNext());
            node.setNextZ(lastNode.getNext());
            node.setPrevious(lastNode);
            node.setPreviousZ(lastNode);
            Node node2 = lastNode.getNext();
            Intrinsics.checkNotNull((Object)node2);
            node2.setPrevious(node);
            Node node3 = lastNode.getNextZ();
            Intrinsics.checkNotNull((Object)node3);
            node3.setPreviousZ(node);
            lastNode.setNext(node);
            lastNode.setNextZ(node);
        }
        return node;
    }

    private final void removeNode(Node node, boolean edgeFromPolygon) {
        Node node2 = node.getNext();
        Intrinsics.checkNotNull((Object)node2);
        node2.setPrevious(node.getPrevious());
        Node node3 = node.getPrevious();
        Intrinsics.checkNotNull((Object)node3);
        node3.setNext(node.getNext());
        Node node4 = node.getPrevious();
        Intrinsics.checkNotNull((Object)node4);
        node4.setNextEdgeFromPolygon(edgeFromPolygon);
        if (node.getPreviousZ() != null) {
            Node node5 = node.getPreviousZ();
            Intrinsics.checkNotNull((Object)node5);
            node5.setNextZ(node.getNextZ());
        }
        if (node.getNextZ() != null) {
            Node node6 = node.getNextZ();
            Intrinsics.checkNotNull((Object)node6);
            node6.setPreviousZ(node.getPreviousZ());
        }
    }

    private final boolean isVertexEquals(Node a, Node b) {
        return this.isVertexEquals(a, b.getX(), b.getY());
    }

    private final boolean isVertexEquals(Node a, double x, double y) {
        return a.getX() == x && a.getY() == y;
    }

    private final double area(double aX, double aY, double bX, double bY, double cX, double cY) {
        return (bY - aY) * (cX - bX) - (bX - aX) * (cY - bY);
    }

    private final boolean pointInEar(double x, double y, double ax, double ay, double bx, double by, double cx, double cy) {
        return (cx - x) * (ay - y) - (ax - x) * (cy - y) >= 0.0 && (ax - x) * (by - y) - (bx - x) * (ay - y) >= 0.0 && (bx - x) * (cy - y) - (cx - x) * (by - y) >= 0.0;
    }

    private final List<Point> getPoints(Node start) {
        Node node = start;
        ArrayList<Point> points2 = new ArrayList<Point>();
        do {
            Node node2 = node;
            Intrinsics.checkNotNull((Object)node2);
            points2.add(new Point(node2.getY(), node.getX()));
        } while ((node = node.getNext()) != start);
        return points2;
    }

    private final void notifyMonitorSplit(int depth, Monitor monitor, Node searchNode, Node diagonalNode) {
        if (monitor != null) {
            if (!(searchNode != null && diagonalNode != null)) {
                boolean bl = false;
                String string = "Invalid split provided to monitor";
                throw new IllegalStateException(string.toString());
            }
            monitor.startSplit("SPLIT[" + depth + "]", this.getPoints(searchNode), this.getPoints(diagonalNode));
        }
    }

    private final void notifyMonitorSplitEnd(int depth, Monitor monitor) {
        if (monitor != null) {
            monitor.endSplit("SPLIT[" + depth + "]");
        }
    }

    private final void notifyMonitor(State state2, int depth, Monitor monitor, Node start, List<Triangle> tessellation) {
        if (monitor != null) {
            this.notifyMonitor(state2.name() + (String)(depth == 0 ? "" : "[" + depth + "]"), monitor, start, tessellation);
        }
    }

    private final void notifyMonitor(String status, Monitor monitor, Node start, List<Triangle> tessellation) {
        if (monitor != null) {
            if (start == null) {
                monitor.currentState(status, null, tessellation);
            } else {
                monitor.currentState(status, this.getPoints(start), tessellation);
            }
        }
    }

    @JvmOverloads
    @NotNull
    public final List<Triangle> tessellate(@NotNull Polygon polygon, boolean checkSelfIntersections) {
        Intrinsics.checkNotNullParameter((Object)polygon, (String)"polygon");
        return Tessellator.tessellate$default(this, polygon, checkSelfIntersections, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final List<Triangle> tessellate(@NotNull XYPolygon polygon, boolean checkSelfIntersections) {
        Intrinsics.checkNotNullParameter((Object)polygon, (String)"polygon");
        return Tessellator.tessellate$default(this, polygon, checkSelfIntersections, null, 4, null);
    }

    private static final int eliminateHoles$lambda$7(Node pNodeA, Node pNodeB) {
        Intrinsics.checkNotNullParameter((Object)pNodeA, (String)"pNodeA");
        Intrinsics.checkNotNullParameter((Object)pNodeB, (String)"pNodeB");
        double diff = pNodeA.getX() - pNodeB.getX();
        if (diff == 0.0 && (diff = pNodeA.getY() - pNodeB.getY()) == 0.0) {
            Node node = pNodeA.getPrevious();
            Intrinsics.checkNotNull((Object)node);
            double d = node.getY();
            Node node2 = pNodeA.getNext();
            Intrinsics.checkNotNull((Object)node2);
            double a = Math.min(d, node2.getY());
            Node node3 = pNodeB.getPrevious();
            Intrinsics.checkNotNull((Object)node3);
            double d2 = node3.getY();
            Node node4 = pNodeB.getNext();
            Intrinsics.checkNotNull((Object)node4);
            double b = Math.min(d2, node4.getY());
            diff = a - b;
        }
        return diff < 0.0 ? -1 : (diff > 0.0 ? 1 : 0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\bf\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fJ.\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007H&J,\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H&J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0010\u00c0\u0006\u0003"}, d2={"Lorg/gnit/lucenekmp/geo/Tessellator$Monitor;", "", "currentState", "", "status", "", "points", "", "Lorg/gnit/lucenekmp/geo/Point;", "tessellation", "Lorg/gnit/lucenekmp/geo/Tessellator$Triangle;", "startSplit", "leftPolygon", "rightPolygon", "endSplit", "Companion", "core"})
    public static interface Monitor {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;
        @NotNull
        public static final String FAILED = "FAILED";
        @NotNull
        public static final String COMPLETED = "COMPLETED";

        public void currentState(@NotNull String var1, @Nullable List<Point> var2, @NotNull List<Triangle> var3);

        public void startSplit(@NotNull String var1, @NotNull List<Point> var2, @NotNull List<Point> var3);

        public void endSplit(@NotNull String var1);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/gnit/lucenekmp/geo/Tessellator$Monitor$Companion;", "", "<init>", "()V", "FAILED", "", "COMPLETED", "core"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            public static final String FAILED = "FAILED";
            @NotNull
            public static final String COMPLETED = "COMPLETED";

            private Companion() {
            }

            static {
                $$INSTANCE = new Companion();
            }
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\t\n\u0002\b\u0013\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B1\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bB\u0011\b\u0016\u0012\u0006\u0010\f\u001a\u00020\u0000\u00a2\u0006\u0004\b\n\u0010\rJ\u0006\u0010\u0014\u001a\u00020+J\u0006\u0010\u0015\u001a\u00020+J\b\u0010,\u001a\u00020-H\u0016R\u0011\u0010\u000e\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\rR\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001c\"\u0004\b \u0010\rR\u001c\u0010!\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001c\"\u0004\b#\u0010\rR\u001c\u0010$\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u001c\"\u0004\b&\u0010\rR\u001a\u0010'\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*\u00a8\u0006."}, d2={"Lorg/gnit/lucenekmp/geo/Tessellator$Node;", "", "x", "", "y", "index", "", "vertexIndex", "isGeo", "", "<init>", "([D[DIIZ)V", "other", "(Lorg/gnit/lucenekmp/geo/Tessellator$Node;)V", "idx", "getIdx", "()I", "vrtxIdx", "polyX", "polyY", "getX", "getY", "morton", "", "getMorton", "()J", "previous", "getPrevious", "()Lorg/gnit/lucenekmp/geo/Tessellator$Node;", "setPrevious", "next", "getNext", "setNext", "previousZ", "getPreviousZ", "setPreviousZ", "nextZ", "getNextZ", "setNextZ", "isNextEdgeFromPolygon", "()Z", "setNextEdgeFromPolygon", "(Z)V", "", "toString", "", "core"})
    public static final class Node {
        private final int idx;
        private final int vrtxIdx;
        @NotNull
        private final double[] polyX;
        @NotNull
        private final double[] polyY;
        private final int x;
        private final int y;
        private final long morton;
        @Nullable
        private Node previous;
        @Nullable
        private Node next;
        @Nullable
        private Node previousZ;
        @Nullable
        private Node nextZ;
        private boolean isNextEdgeFromPolygon;

        public final int getIdx() {
            return this.idx;
        }

        public final int getX() {
            return this.x;
        }

        public final int getY() {
            return this.y;
        }

        public final long getMorton() {
            return this.morton;
        }

        @Nullable
        public final Node getPrevious() {
            return this.previous;
        }

        public final void setPrevious(@Nullable Node node) {
            this.previous = node;
        }

        @Nullable
        public final Node getNext() {
            return this.next;
        }

        public final void setNext(@Nullable Node node) {
            this.next = node;
        }

        @Nullable
        public final Node getPreviousZ() {
            return this.previousZ;
        }

        public final void setPreviousZ(@Nullable Node node) {
            this.previousZ = node;
        }

        @Nullable
        public final Node getNextZ() {
            return this.nextZ;
        }

        public final void setNextZ(@Nullable Node node) {
            this.nextZ = node;
        }

        public final boolean isNextEdgeFromPolygon() {
            return this.isNextEdgeFromPolygon;
        }

        public final void setNextEdgeFromPolygon(boolean bl) {
            this.isNextEdgeFromPolygon = bl;
        }

        public Node(@NotNull double[] x, @NotNull double[] y, int index, int vertexIndex, boolean isGeo) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            Intrinsics.checkNotNullParameter((Object)y, (String)"y");
            this.idx = index;
            this.vrtxIdx = vertexIndex;
            this.polyX = x;
            this.polyY = y;
            this.y = isGeo ? GeoEncodingUtils.INSTANCE.encodeLatitude(this.polyY[this.vrtxIdx]) : XYEncodingUtils.INSTANCE.encode((float)this.polyY[this.vrtxIdx]);
            this.x = isGeo ? GeoEncodingUtils.INSTANCE.encodeLongitude(this.polyX[this.vrtxIdx]) : XYEncodingUtils.INSTANCE.encode((float)this.polyX[this.vrtxIdx]);
            this.morton = BitUtil.INSTANCE.interleave(this.x ^ Integer.MIN_VALUE, this.y ^ Integer.MIN_VALUE);
            this.previous = null;
            this.next = null;
            this.previousZ = null;
            this.nextZ = null;
            this.isNextEdgeFromPolygon = true;
        }

        public Node(@NotNull Node other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            this.idx = other.idx;
            this.vrtxIdx = other.vrtxIdx;
            this.polyX = other.polyX;
            this.polyY = other.polyY;
            this.morton = other.morton;
            this.x = other.x;
            this.y = other.y;
            this.previous = other.previous;
            this.next = other.next;
            this.previousZ = other.previousZ;
            this.nextZ = other.nextZ;
            this.isNextEdgeFromPolygon = other.isNextEdgeFromPolygon;
        }

        public final double getX() {
            return this.polyX[this.vrtxIdx];
        }

        public final double getY() {
            return this.polyY[this.vrtxIdx];
        }

        @NotNull
        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (this.previous == null) {
                v0 = builder.append("||-");
            } else {
                Node node = this.previous;
                Intrinsics.checkNotNull((Object)node);
                v0 = builder.append(node.idx).append(" <- ");
            }
            builder.append(this.idx);
            if (this.next == null) {
                v2 = builder.append(" -||");
            } else {
                StringBuilder stringBuilder = builder.append(" -> ");
                Node node = this.next;
                Intrinsics.checkNotNull((Object)node);
                v2 = stringBuilder.append(node.idx);
            }
            String string = builder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/gnit/lucenekmp/geo/Tessellator$State;", "", "<init>", "(Ljava/lang/String;I)V", "INIT", "CURE", "SPLIT", "core"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State INIT = new State();
        public static final /* enum */ State CURE = new State();
        public static final /* enum */ State SPLIT = new State();
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.INIT, State.CURE, State.SPLIT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u0018\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\u001aJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\f\u001a\u00020\u001aJ\u000e\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\f\u001a\u00020\u001aJ\u000e\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u001aJ\b\u0010!\u001a\u00020\"H\u0016R\"\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\rX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0012\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006#"}, d2={"Lorg/gnit/lucenekmp/geo/Tessellator$Triangle;", "", "a", "Lorg/gnit/lucenekmp/geo/Tessellator$Node;", "isABfromPolygon", "", "b", "isBCfromPolygon", "c", "isCAfromPolygon", "<init>", "(Lorg/gnit/lucenekmp/geo/Tessellator$Node;ZLorg/gnit/lucenekmp/geo/Tessellator$Node;ZLorg/gnit/lucenekmp/geo/Tessellator$Node;Z)V", "vertex", "", "getVertex", "()[Lorg/gnit/lucenekmp/geo/Tessellator$Node;", "setVertex", "([Lorg/gnit/lucenekmp/geo/Tessellator$Node;)V", "[Lorg/gnit/lucenekmp/geo/Tessellator$Node;", "edgeFromPolygon", "", "getEdgeFromPolygon", "()[Z", "setEdgeFromPolygon", "([Z)V", "getEncodedX", "", "getEncodedY", "getY", "", "getX", "isEdgefromPolygon", "startVertex", "toString", "", "core"})
    public static final class Triangle {
        @NotNull
        private Node[] vertex;
        @NotNull
        private boolean[] edgeFromPolygon;

        public Triangle(@NotNull Node a, boolean isABfromPolygon, @NotNull Node b, boolean isBCfromPolygon, @NotNull Node c, boolean isCAfromPolygon) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            Object[] objectArray = new Node[]{a, b, c};
            this.vertex = objectArray;
            objectArray = new boolean[3];
            objectArray[0] = (Node)isABfromPolygon;
            objectArray[1] = (Node)isBCfromPolygon;
            objectArray[2] = (Node)isCAfromPolygon;
            this.edgeFromPolygon = (boolean[])objectArray;
        }

        @NotNull
        public final Node[] getVertex() {
            return this.vertex;
        }

        public final void setVertex(@NotNull Node[] nodeArray) {
            Intrinsics.checkNotNullParameter((Object)nodeArray, (String)"<set-?>");
            this.vertex = nodeArray;
        }

        @NotNull
        public final boolean[] getEdgeFromPolygon() {
            return this.edgeFromPolygon;
        }

        public final void setEdgeFromPolygon(@NotNull boolean[] blArray) {
            Intrinsics.checkNotNullParameter((Object)blArray, (String)"<set-?>");
            this.edgeFromPolygon = blArray;
        }

        public final int getEncodedX(int vertex) {
            return this.vertex[vertex].getX();
        }

        public final int getEncodedY(int vertex) {
            return this.vertex[vertex].getY();
        }

        public final double getY(int vertex) {
            return this.vertex[vertex].getY();
        }

        public final double getX(int vertex) {
            return this.vertex[vertex].getX();
        }

        public final boolean isEdgefromPolygon(int startVertex) {
            return this.edgeFromPolygon[startVertex];
        }

        @NotNull
        public String toString() {
            String result = this.vertex[0].getX() + ", " + this.vertex[0].getY() + " [" + this.edgeFromPolygon[0] + "] " + this.vertex[1].getX() + ", " + this.vertex[1].getY() + " [" + this.edgeFromPolygon[1] + "] " + this.vertex[2].getX() + ", " + this.vertex[2].getY() + " [" + this.edgeFromPolygon[2] + "]";
            return result;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[State.values().length];
            try {
                nArray[State.INIT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.CURE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.SPLIT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

