/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.geo;

import kotlin.Metadata;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.FloatExtKt;
import org.gnit.lucenekmp.util.NumericUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0014\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\bJ\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/gnit/lucenekmp/geo/XYEncodingUtils;", "", "<init>", "()V", "MIN_VAL_INCL", "", "MAX_VAL_INCL", "checkVal", "", "x", "encode", "", "decode", "encoded", "src", "", "offset", "floatArrayToDoubleArray", "", "f", "", "core"})
@SourceDebugExtension(value={"SMAP\nXYEncodingUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XYEncodingUtils.kt\norg/gnit/lucenekmp/geo/XYEncodingUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n1#2:70\n*E\n"})
public final class XYEncodingUtils {
    @NotNull
    public static final XYEncodingUtils INSTANCE = new XYEncodingUtils();
    public static final double MIN_VAL_INCL = -3.4028234663852886E38;
    public static final double MAX_VAL_INCL = 3.4028234663852886E38;

    private XYEncodingUtils() {
    }

    public final float checkVal(float x) {
        if (!FloatExtKt.isFinite(FloatCompanionObject.INSTANCE, x)) {
            boolean bl = false;
            String string = "invalid value " + x + "; must be between -3.4028234663852886E38 and 3.4028234663852886E38";
            throw new IllegalArgumentException(string.toString());
        }
        return x;
    }

    public final int encode(float x) {
        return NumericUtils.INSTANCE.floatToSortableInt(this.checkVal(x));
    }

    public final float decode(int encoded) {
        float result = NumericUtils.INSTANCE.sortableIntToFloat(encoded);
        if (!((double)result >= -3.4028234663852886E38 && (double)result <= 3.4028234663852886E38)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return result;
    }

    public final float decode(@NotNull byte[] src, int offset) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        return this.decode(NumericUtils.INSTANCE.sortableBytesToInt(src, offset));
    }

    @NotNull
    public final double[] floatArrayToDoubleArray(@NotNull float[] f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        double[] d = new double[f.length];
        int n = f.length;
        for (int i = 0; i < n; ++i) {
            d[i] = f[i];
        }
        return d;
    }
}

