/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.geo;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.geo.Component2D;
import org.gnit.lucenekmp.geo.Line2D;
import org.gnit.lucenekmp.geo.XYEncodingUtils;
import org.gnit.lucenekmp.geo.XYGeometry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0012J\u000e\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0003J\u0006\u0010\u0015\u001a\u00020\u0003J\b\u0010\u0016\u001a\u00020\u0017H\u0014J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J\b\u0010\u001c\u001a\u00020\u0012H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0011\u0010\u000f\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\n\u00a8\u0006\u001f"}, d2={"Lorg/gnit/lucenekmp/geo/XYLine;", "Lorg/gnit/lucenekmp/geo/XYGeometry;", "x", "", "y", "<init>", "([F[F)V", "minX", "", "getMinX", "()F", "maxX", "getMaxX", "minY", "getMinY", "maxY", "getMaxY", "numPoints", "", "getX", "vertex", "getY", "toComponent2D", "Lorg/gnit/lucenekmp/geo/Component2D;", "equals", "", "o", "", "hashCode", "toString", "", "core"})
@SourceDebugExtension(value={"SMAP\nXYLine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XYLine.kt\norg/gnit/lucenekmp/geo/XYLine\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n1#2:109\n*E\n"})
public final class XYLine
extends XYGeometry {
    @NotNull
    private final float[] x;
    @NotNull
    private final float[] y;
    private final float minX;
    private final float maxX;
    private final float minY;
    private final float maxY;

    public XYLine(@NotNull float[] x, @NotNull float[] y) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        if (!(x.length == y.length)) {
            boolean $i$a$-require-XYLine$52 = false;
            String $i$a$-require-XYLine$52 = "x and y must be equal length";
            throw new IllegalArgumentException($i$a$-require-XYLine$52.toString());
        }
        if (!(x.length >= 2)) {
            boolean $i$a$-require-XYLine$62 = false;
            String $i$a$-require-XYLine$62 = "at least 2 line points required";
            throw new IllegalArgumentException($i$a$-require-XYLine$62.toString());
        }
        float minX = Float.MAX_VALUE;
        float minY = Float.MAX_VALUE;
        float maxX = -3.4028235E38f;
        float maxY = -3.4028235E38f;
        int n = x.length;
        for (int i = 0; i < n; ++i) {
            minX = Math.min(XYEncodingUtils.INSTANCE.checkVal(x[i]), minX);
            minY = Math.min(XYEncodingUtils.INSTANCE.checkVal(y[i]), minY);
            maxX = Math.max(x[i], maxX);
            maxY = Math.max(y[i], maxY);
        }
        float[] fArray = x;
        float[] fArray2 = Arrays.copyOf(fArray, fArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)fArray2, (String)"copyOf(...)");
        this.x = fArray2;
        fArray = y;
        float[] fArray3 = Arrays.copyOf(fArray, fArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)fArray3, (String)"copyOf(...)");
        this.y = fArray3;
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
    }

    public final float getMinX() {
        return this.minX;
    }

    public final float getMaxX() {
        return this.maxX;
    }

    public final float getMinY() {
        return this.minY;
    }

    public final float getMaxY() {
        return this.maxY;
    }

    public final int numPoints() {
        return this.x.length;
    }

    public final float getX(int vertex) {
        return this.x[vertex];
    }

    public final float getY(int vertex) {
        return this.y[vertex];
    }

    @NotNull
    public final float[] getX() {
        float[] fArray = Arrays.copyOf(this.x, this.x.length);
        Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"copyOf(...)");
        return fArray;
    }

    @NotNull
    public final float[] getY() {
        float[] fArray = Arrays.copyOf(this.y, this.y.length);
        Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"copyOf(...)");
        return fArray;
    }

    @Override
    @NotNull
    protected Component2D toComponent2D() {
        return Line2D.Companion.create(this);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof XYLine)) {
            return false;
        }
        Object line = o;
        return Arrays.equals(this.x, ((XYLine)line).x) && Arrays.equals(this.y, ((XYLine)line).y);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.x);
        result = 31 * result + Arrays.hashCode(this.y);
        return result;
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("XYLine(");
        int n = this.x.length;
        for (int i = 0; i < n; ++i) {
            sb.append("[").append(this.x[i]).append(", ").append(this.y[i]).append("]");
        }
        sb.append(')');
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

