/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.geo;

import kotlin.Metadata;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.geo.Component2D;
import org.gnit.lucenekmp.geo.Point2D;
import org.gnit.lucenekmp.geo.XYEncodingUtils;
import org.gnit.lucenekmp.geo.XYGeometry;
import org.gnit.lucenekmp.jdkport.FloatExtKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\n\u001a\u00020\u000bH\u0014J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lorg/gnit/lucenekmp/geo/XYPoint;", "Lorg/gnit/lucenekmp/geo/XYGeometry;", "x", "", "y", "<init>", "(FF)V", "getX", "()F", "getY", "toComponent2D", "Lorg/gnit/lucenekmp/geo/Component2D;", "equals", "", "o", "", "hashCode", "", "toString", "", "core"})
public final class XYPoint
extends XYGeometry {
    private final float x;
    private final float y;

    public XYPoint(float x, float y) {
        this.x = XYEncodingUtils.INSTANCE.checkVal(x);
        this.y = XYEncodingUtils.INSTANCE.checkVal(y);
    }

    public final float getX() {
        return this.x;
    }

    public final float getY() {
        return this.y;
    }

    @Override
    @NotNull
    protected Component2D toComponent2D() {
        return Point2D.Companion.create(this);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof XYPoint)) {
            return false;
        }
        Object point = o;
        return FloatExtKt.compare(FloatCompanionObject.INSTANCE, ((XYPoint)point).x, this.x) == 0 && FloatExtKt.compare(FloatCompanionObject.INSTANCE, ((XYPoint)point).y, this.y) == 0;
    }

    public int hashCode() {
        int result = Float.hashCode(this.x);
        result = 31 * result + Float.hashCode(this.y);
        return result;
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("XYPoint(");
        sb.append(this.x);
        sb.append(",");
        sb.append(this.y);
        sb.append(')');
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

