/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.geo;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.geo.Component2D;
import org.gnit.lucenekmp.geo.GeoUtils;
import org.gnit.lucenekmp.geo.Polygon2D;
import org.gnit.lucenekmp.geo.XYEncodingUtils;
import org.gnit.lucenekmp.geo.XYGeometry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0006\"\u00020\u0000\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u0017J\u000e\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u0017J\u0011\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00000\u0006\u00a2\u0006\u0002\u0010\u001fJ\u000e\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0017J\u0006\u0010\"\u001a\u00020\u0015J\u0006\u0010#\u001a\u00020\u0017J\b\u0010$\u001a\u00020%H\u0014J\b\u0010&\u001a\u00020\u0017H\u0016J\u0013\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*H\u0096\u0002J\b\u0010+\u001a\u00020,H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00000\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\u0012\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001c\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001a\u00a8\u0006-"}, d2={"Lorg/gnit/lucenekmp/geo/XYPolygon;", "Lorg/gnit/lucenekmp/geo/XYGeometry;", "x", "", "y", "holes", "", "<init>", "([F[F[Lorg/gnit/lucenekmp/geo/XYPolygon;)V", "[Lorg/gnit/lucenekmp/geo/XYPolygon;", "minX", "", "getMinX", "()F", "maxX", "getMaxX", "minY", "getMinY", "maxY", "getMaxY", "windingOrder", "Lorg/gnit/lucenekmp/geo/GeoUtils$WindingOrder;", "numPoints", "", "polyX", "getPolyX", "()[F", "vertex", "polyY", "getPolyY", "getHoles", "()[Lorg/gnit/lucenekmp/geo/XYPolygon;", "getHole", "i", "getWindingOrder", "numHoles", "toComponent2D", "Lorg/gnit/lucenekmp/geo/Component2D;", "hashCode", "equals", "", "obj", "", "toString", "", "core"})
@SourceDebugExtension(value={"SMAP\nXYPolygon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XYPolygon.kt\norg/gnit/lucenekmp/geo/XYPolygon\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,168:1\n1#2:169\n*E\n"})
public final class XYPolygon
extends XYGeometry {
    @NotNull
    private final float[] x;
    @NotNull
    private final float[] y;
    @NotNull
    private final XYPolygon[] holes;
    private final float minX;
    private final float maxX;
    private final float minY;
    private final float maxY;
    @NotNull
    private final GeoUtils.WindingOrder windingOrder;

    public XYPolygon(@NotNull float[] x, @NotNull float[] y, XYPolygon ... holes) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter((Object)holes, (String)"holes");
        if (!(x.length == y.length)) {
            boolean $i$a$-require-XYPolygon$92 = false;
            String $i$a$-require-XYPolygon$92 = "x and y must be equal length";
            throw new IllegalArgumentException($i$a$-require-XYPolygon$92.toString());
        }
        if (!(x.length >= 4)) {
            boolean $i$a$-require-XYPolygon$102 = false;
            String $i$a$-require-XYPolygon$102 = "at least 4 polygon points required";
            throw new IllegalArgumentException($i$a$-require-XYPolygon$102.toString());
        }
        if (!(x[0] == x[x.length - 1])) {
            boolean $i$a$-require-XYPolygon$112 = false;
            String $i$a$-require-XYPolygon$112 = "first and last points of the polygon must be the same (it must close itself): x[0]=" + x[0] + " x[" + (x.length - 1) + "]=" + x[x.length - 1];
            throw new IllegalArgumentException($i$a$-require-XYPolygon$112.toString());
        }
        if (!(y[0] == y[y.length - 1])) {
            boolean $i$a$-require-XYPolygon$122 = false;
            String $i$a$-require-XYPolygon$122 = "first and last points of the polygon must be the same (it must close itself): y[0]=" + y[0] + " y[" + (y.length - 1) + "]=" + y[y.length - 1];
            throw new IllegalArgumentException($i$a$-require-XYPolygon$122.toString());
        }
        int $i$a$-require-XYPolygon$122 = holes.length;
        for (int i = 0; i < $i$a$-require-XYPolygon$122; ++i) {
            XYPolygon inner = holes[i];
            if (inner.holes.length == 0) continue;
            boolean $i$a$-require-XYPolygon$132 = false;
            String $i$a$-require-XYPolygon$132 = "holes may not contain holes: polygons may not nest.";
            throw new IllegalArgumentException($i$a$-require-XYPolygon$132.toString());
        }
        Object[] i = x;
        float[] fArray = Arrays.copyOf(i, i.length);
        Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"copyOf(...)");
        this.x = fArray;
        i = y;
        float[] fArray2 = Arrays.copyOf(i, i.length);
        Intrinsics.checkNotNullExpressionValue((Object)fArray2, (String)"copyOf(...)");
        this.y = fArray2;
        i = holes;
        float[] fArray3 = Arrays.copyOf(i, i.length);
        Intrinsics.checkNotNullExpressionValue((Object)fArray3, (String)"copyOf(...)");
        this.holes = (XYPolygon[])fArray3;
        float minX = XYEncodingUtils.INSTANCE.checkVal(x[0]);
        float maxX = x[0];
        float minY = XYEncodingUtils.INSTANCE.checkVal(y[0]);
        float maxY = y[0];
        double windingSum = 0.0;
        int numPts = x.length - 1;
        int i2 = 1;
        int j = 0;
        while (i2 < numPts) {
            minX = Math.min(XYEncodingUtils.INSTANCE.checkVal(x[i2]), minX);
            maxX = Math.max(x[i2], maxX);
            minY = Math.min(XYEncodingUtils.INSTANCE.checkVal(y[i2]), minY);
            maxY = Math.max(y[i2], maxY);
            windingSum += (double)((x[j] - x[numPts]) * (y[i2] - y[numPts]) - (y[j] - y[numPts]) * (x[i2] - x[numPts]));
            j = i2++;
        }
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
        this.windingOrder = windingSum < 0.0 ? GeoUtils.WindingOrder.CCW : GeoUtils.WindingOrder.CW;
    }

    public final float getMinX() {
        return this.minX;
    }

    public final float getMaxX() {
        return this.maxX;
    }

    public final float getMinY() {
        return this.minY;
    }

    public final float getMaxY() {
        return this.maxY;
    }

    public final int numPoints() {
        return this.x.length;
    }

    @NotNull
    public final float[] getPolyX() {
        float[] fArray = Arrays.copyOf(this.x, this.x.length);
        Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"copyOf(...)");
        return fArray;
    }

    public final float getPolyX(int vertex) {
        return this.x[vertex];
    }

    @NotNull
    public final float[] getPolyY() {
        float[] fArray = Arrays.copyOf(this.y, this.y.length);
        Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"copyOf(...)");
        return fArray;
    }

    public final float getPolyY(int vertex) {
        return this.y[vertex];
    }

    @NotNull
    public final XYPolygon[] getHoles() {
        XYPolygon[] xYPolygonArray = Arrays.copyOf(this.holes, this.holes.length);
        Intrinsics.checkNotNullExpressionValue((Object)xYPolygonArray, (String)"copyOf(...)");
        return xYPolygonArray;
    }

    @NotNull
    public final XYPolygon getHole(int i) {
        return this.holes[i];
    }

    @NotNull
    public final GeoUtils.WindingOrder getWindingOrder() {
        return this.windingOrder;
    }

    public final int numHoles() {
        return this.holes.length;
    }

    @Override
    @NotNull
    protected Component2D toComponent2D() {
        return Polygon2D.Companion.create(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + Arrays.hashCode(this.holes);
        result = prime * result + Arrays.hashCode(this.x);
        result = prime * result + Arrays.hashCode(this.y);
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XYPolygon other = (XYPolygon)obj;
        if (!Arrays.equals(this.holes, other.holes)) {
            return false;
        }
        if (!Arrays.equals(this.x, other.x)) {
            return false;
        }
        return Arrays.equals(this.y, other.y);
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("XYPolygon");
        int n = this.x.length;
        for (int i = 0; i < n; ++i) {
            sb.append("[").append(this.x[i]).append(", ").append(this.y[i]).append("] ");
        }
        if (!(this.holes.length == 0)) {
            sb.append(", holes=");
            String string = Arrays.toString(this.holes);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            sb.append(string);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

