/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.geo;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.geo.Component2D;
import org.gnit.lucenekmp.geo.Rectangle2D;
import org.gnit.lucenekmp.geo.XYEncodingUtils;
import org.gnit.lucenekmp.geo.XYGeometry;
import org.gnit.lucenekmp.jdkport.FloatExtKt;
import org.gnit.lucenekmp.jdkport.Math;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000e\u001a\u00020\u000fH\u0014J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0019"}, d2={"Lorg/gnit/lucenekmp/geo/XYRectangle;", "Lorg/gnit/lucenekmp/geo/XYGeometry;", "minX", "", "maxX", "minY", "maxY", "<init>", "(FFFF)V", "getMinX", "()F", "getMaxX", "getMinY", "getMaxY", "toComponent2D", "Lorg/gnit/lucenekmp/geo/Component2D;", "equals", "", "o", "", "hashCode", "", "toString", "", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nXYRectangle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XYRectangle.kt\norg/gnit/lucenekmp/geo/XYRectangle\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n1#2:98\n*E\n"})
public final class XYRectangle
extends XYGeometry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float minX;
    private final float maxX;
    private final float minY;
    private final float maxY;

    public XYRectangle(float minX, float maxX, float minY, float maxY) {
        if (!(!(minX > maxX))) {
            boolean $i$a$-require-XYRectangle$32 = false;
            String $i$a$-require-XYRectangle$32 = "minX must be lower than maxX, got " + minX + " > " + maxX;
            throw new IllegalArgumentException($i$a$-require-XYRectangle$32.toString());
        }
        if (!(!(minY > maxY))) {
            boolean bl = false;
            String string = "minY must be lower than maxY, got " + minY + " > " + maxY;
            throw new IllegalArgumentException(string.toString());
        }
        this.minX = XYEncodingUtils.INSTANCE.checkVal(minX);
        this.maxX = XYEncodingUtils.INSTANCE.checkVal(maxX);
        this.minY = XYEncodingUtils.INSTANCE.checkVal(minY);
        this.maxY = XYEncodingUtils.INSTANCE.checkVal(maxY);
    }

    public final float getMinX() {
        return this.minX;
    }

    public final float getMaxX() {
        return this.maxX;
    }

    public final float getMinY() {
        return this.minY;
    }

    public final float getMaxY() {
        return this.maxY;
    }

    @Override
    @NotNull
    protected Component2D toComponent2D() {
        return Rectangle2D.Companion.create(this);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XYRectangle rectangle = (XYRectangle)o;
        if (FloatExtKt.compare(FloatCompanionObject.INSTANCE, rectangle.minX, this.minX) != 0) {
            return false;
        }
        if (FloatExtKt.compare(FloatCompanionObject.INSTANCE, rectangle.minY, this.minY) != 0) {
            return false;
        }
        if (FloatExtKt.compare(FloatCompanionObject.INSTANCE, rectangle.maxX, this.maxX) != 0) {
            return false;
        }
        return FloatExtKt.compare(FloatCompanionObject.INSTANCE, rectangle.maxY, this.maxY) == 0;
    }

    public int hashCode() {
        int result = 0;
        long temp = 0L;
        temp = FloatExtKt.floatToIntBits(FloatCompanionObject.INSTANCE, this.minX);
        result = (int)(temp ^ temp >>> 32);
        temp = FloatExtKt.floatToIntBits(FloatCompanionObject.INSTANCE, this.minY);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = FloatExtKt.floatToIntBits(FloatCompanionObject.INSTANCE, this.maxX);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = FloatExtKt.floatToIntBits(FloatCompanionObject.INSTANCE, this.maxY);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @NotNull
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("XYRectangle(x=");
        b.append(this.minX);
        b.append(" TO ");
        b.append(this.maxX);
        b.append(" y=");
        b.append(this.minY);
        b.append(" TO ");
        b.append(this.maxY);
        b.append(")");
        String string = b.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007\u00a8\u0006\n"}, d2={"Lorg/gnit/lucenekmp/geo/XYRectangle$Companion;", "", "<init>", "()V", "fromPointDistance", "Lorg/gnit/lucenekmp/geo/XYRectangle;", "x", "", "y", "radius", "core"})
    @SourceDebugExtension(value={"SMAP\nXYRectangle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XYRectangle.kt\norg/gnit/lucenekmp/geo/XYRectangle$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n1#2:98\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final XYRectangle fromPointDistance(float x, float y, float radius) {
            XYEncodingUtils.INSTANCE.checkVal(x);
            XYEncodingUtils.INSTANCE.checkVal(y);
            if (!(!(radius < 0.0f))) {
                boolean $i$a$-require-XYRectangle$Companion$fromPointDistance$32 = false;
                String $i$a$-require-XYRectangle$Companion$fromPointDistance$32 = "radius must be bigger than 0, got " + radius;
                throw new IllegalArgumentException($i$a$-require-XYRectangle$Companion$fromPointDistance$32.toString());
            }
            if (!FloatExtKt.isFinite(FloatCompanionObject.INSTANCE, radius)) {
                boolean $i$a$-require-XYRectangle$Companion$fromPointDistance$42 = false;
                String $i$a$-require-XYRectangle$Companion$fromPointDistance$42 = "radius must be finite, got " + radius;
                throw new IllegalArgumentException($i$a$-require-XYRectangle$Companion$fromPointDistance$42.toString());
            }
            float distanceBox = Math.INSTANCE.nextUp(radius);
            float minX = java.lang.Math.max(-3.4028235E38f, x - distanceBox);
            float maxX = java.lang.Math.min(Float.MAX_VALUE, x + distanceBox);
            float minY = java.lang.Math.max(-3.4028235E38f, y - distanceBox);
            float maxY = java.lang.Math.min(Float.MAX_VALUE, y + distanceBox);
            return new XYRectangle(minX, maxX, minY, maxY);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

