/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.util.BitUtil;
import org.gnit.lucenekmp.util.ByteBlockPool;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u0016\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tJ\u0016\u0010\u000f\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/gnit/lucenekmp/index/ByteSlicePool;", "", "pool", "Lorg/gnit/lucenekmp/util/ByteBlockPool;", "<init>", "(Lorg/gnit/lucenekmp/util/ByteBlockPool;)V", "getPool", "()Lorg/gnit/lucenekmp/util/ByteBlockPool;", "newSlice", "", "size", "allocSlice", "slice", "", "upto", "allocKnownSizeSlice", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nByteSlicePool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ByteSlicePool.kt\norg/gnit/lucenekmp/index/ByteSlicePool\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,126:1\n3#2,8:127\n10#3:135\n*S KotlinDebug\n*F\n+ 1 ByteSlicePool.kt\norg/gnit/lucenekmp/index/ByteSlicePool\n*L\n93#1:127,8\n93#1:135\n*E\n"})
public final class ByteSlicePool {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ByteBlockPool pool;
    @NotNull
    private static final int[] LEVEL_SIZE_ARRAY;
    @NotNull
    private static final int[] NEXT_LEVEL_ARRAY;
    private static final int FIRST_LEVEL_SIZE;

    public ByteSlicePool(@NotNull ByteBlockPool pool) {
        Intrinsics.checkNotNullParameter((Object)pool, (String)"pool");
        this.pool = pool;
    }

    @NotNull
    public final ByteBlockPool getPool() {
        return this.pool;
    }

    public final int newSlice(int size2) {
        if (!(size2 <= 32768)) {
            boolean bl = false;
            String string = "Slice size " + size2 + " should be less than the block size 32768";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.pool.getByteUpto() > 32768 - size2) {
            this.pool.nextBuffer();
        }
        int upto = this.pool.getByteUpto();
        ByteBlockPool byteBlockPool = this.pool;
        byteBlockPool.setByteUpto(byteBlockPool.getByteUpto() + size2);
        byte[] byArray = this.pool.getBuffer();
        Intrinsics.checkNotNull((Object)byArray);
        byArray[this.pool.getByteUpto() - 1] = 16;
        return upto;
    }

    public final int allocSlice(@NotNull byte[] slice, int upto) {
        Intrinsics.checkNotNullParameter((Object)slice, (String)"slice");
        return this.allocKnownSizeSlice(slice, upto) >> 8;
    }

    public final int allocKnownSizeSlice(@NotNull byte[] slice, int upto) {
        Intrinsics.checkNotNullParameter((Object)slice, (String)"slice");
        int level = slice[upto] & 0xF;
        int newLevel = NEXT_LEVEL_ARRAY[level];
        int newSize = LEVEL_SIZE_ARRAY[newLevel];
        if (this.pool.getByteUpto() > 32768 - newSize) {
            this.pool.nextBuffer();
        }
        int newUpto = this.pool.getByteUpto();
        int offset = newUpto + this.pool.getByteOffset();
        ByteBlockPool byteBlockPool = this.pool;
        byteBlockPool.setByteUpto(byteBlockPool.getByteUpto() + newSize);
        int past3Bytes = BitUtil.VH_LE_INT.INSTANCE.get(slice, upto - 3) & 0xFFFFFF;
        byte[] byArray = this.pool.getBuffer();
        Intrinsics.checkNotNull((Object)byArray);
        boolean condition$iv = byArray[newUpto + 3] == 0;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        byte[] byArray2 = this.pool.getBuffer();
        Intrinsics.checkNotNull((Object)byArray2);
        BitUtil.VH_LE_INT.INSTANCE.set(byArray2, newUpto, past3Bytes);
        BitUtil.VH_LE_INT.INSTANCE.set(slice, upto - 3, offset);
        byte[] byArray3 = this.pool.getBuffer();
        Intrinsics.checkNotNull((Object)byArray3);
        byArray3[this.pool.getByteUpto() - 1] = (byte)(0x10 | newLevel);
        return newUpto + 3 << 8 | newSize - 3;
    }

    static {
        int[] nArray = new int[]{5, 14, 20, 30, 40, 40, 80, 80, 120, 200};
        LEVEL_SIZE_ARRAY = nArray;
        nArray = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 9};
        NEXT_LEVEL_ARRAY = nArray;
        FIRST_LEVEL_SIZE = LEVEL_SIZE_ARRAY[0];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/index/ByteSlicePool$Companion;", "", "<init>", "()V", "LEVEL_SIZE_ARRAY", "", "getLEVEL_SIZE_ARRAY", "()[I", "NEXT_LEVEL_ARRAY", "getNEXT_LEVEL_ARRAY", "FIRST_LEVEL_SIZE", "", "getFIRST_LEVEL_SIZE", "()I", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final int[] getLEVEL_SIZE_ARRAY() {
            return LEVEL_SIZE_ARRAY;
        }

        @NotNull
        public final int[] getNEXT_LEVEL_ARRAY() {
            return NEXT_LEVEL_ARRAY;
        }

        public final int getFIRST_LEVEL_SIZE() {
            return FIRST_LEVEL_SIZE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

