/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.ExceptionsKt;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArrayDeque;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongCompanionObject;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import okio.Path;
import org.gnit.lucenekmp.codecs.Codec;
import org.gnit.lucenekmp.codecs.DocValuesProducer;
import org.gnit.lucenekmp.codecs.FieldsProducer;
import org.gnit.lucenekmp.codecs.KnnVectorsReader;
import org.gnit.lucenekmp.codecs.NormsProducer;
import org.gnit.lucenekmp.codecs.PointsReader;
import org.gnit.lucenekmp.codecs.StoredFieldsReader;
import org.gnit.lucenekmp.codecs.hnsw.FlatVectorsReader;
import org.gnit.lucenekmp.codecs.hnsw.HnswGraphProvider;
import org.gnit.lucenekmp.codecs.perfield.PerFieldKnnVectorsFormat;
import org.gnit.lucenekmp.document.Document;
import org.gnit.lucenekmp.document.DocumentStoredFieldVisitor;
import org.gnit.lucenekmp.index.BinaryDocValues;
import org.gnit.lucenekmp.index.ByteVectorValues;
import org.gnit.lucenekmp.index.CodecReader;
import org.gnit.lucenekmp.index.DocValuesIterator;
import org.gnit.lucenekmp.index.DocValuesSkipIndexType;
import org.gnit.lucenekmp.index.DocValuesSkipper;
import org.gnit.lucenekmp.index.DocValuesType;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.FieldInfos;
import org.gnit.lucenekmp.index.Fields;
import org.gnit.lucenekmp.index.FloatVectorValues;
import org.gnit.lucenekmp.index.Impact;
import org.gnit.lucenekmp.index.Impacts;
import org.gnit.lucenekmp.index.ImpactsEnum;
import org.gnit.lucenekmp.index.IndexNotFoundException;
import org.gnit.lucenekmp.index.IndexOptions;
import org.gnit.lucenekmp.index.IndexReader;
import org.gnit.lucenekmp.index.LeafMetaData;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.gnit.lucenekmp.index.NumericDocValues;
import org.gnit.lucenekmp.index.PendingSoftDeletes;
import org.gnit.lucenekmp.index.PointValues;
import org.gnit.lucenekmp.index.PostingsEnum;
import org.gnit.lucenekmp.index.SegmentCommitInfo;
import org.gnit.lucenekmp.index.SegmentInfos;
import org.gnit.lucenekmp.index.SegmentReader;
import org.gnit.lucenekmp.index.SortedDocValues;
import org.gnit.lucenekmp.index.SortedNumericDocValues;
import org.gnit.lucenekmp.index.SortedSetDocValues;
import org.gnit.lucenekmp.index.Terms;
import org.gnit.lucenekmp.index.TermsEnum;
import org.gnit.lucenekmp.index.VectorEncoding;
import org.gnit.lucenekmp.internal.hppc.IntIntHashMap;
import org.gnit.lucenekmp.jdkport.ArrayDequeExtKt;
import org.gnit.lucenekmp.jdkport.ByteArrayOutputStream;
import org.gnit.lucenekmp.jdkport.Callable;
import org.gnit.lucenekmp.jdkport.ExecutionException;
import org.gnit.lucenekmp.jdkport.ExecutorService;
import org.gnit.lucenekmp.jdkport.ExitProcessKt;
import org.gnit.lucenekmp.jdkport.InterruptedException;
import org.gnit.lucenekmp.jdkport.LongExtKt;
import org.gnit.lucenekmp.jdkport.PrintStream;
import org.gnit.lucenekmp.jdkport.StandardCharsets;
import org.gnit.lucenekmp.jdkport.ThrowableExtKt;
import org.gnit.lucenekmp.jdkport.TimeUnit;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.search.FieldExistsQuery;
import org.gnit.lucenekmp.search.KnnCollector;
import org.gnit.lucenekmp.search.LeafFieldComparator;
import org.gnit.lucenekmp.search.Pruning;
import org.gnit.lucenekmp.search.ScoreDoc;
import org.gnit.lucenekmp.search.Sort;
import org.gnit.lucenekmp.search.SortField;
import org.gnit.lucenekmp.search.TopDocs;
import org.gnit.lucenekmp.search.TopKnnCollector;
import org.gnit.lucenekmp.store.AlreadyClosedException;
import org.gnit.lucenekmp.store.Directory;
import org.gnit.lucenekmp.store.FSDirectory;
import org.gnit.lucenekmp.store.IOContext;
import org.gnit.lucenekmp.store.Lock;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.BitSet;
import org.gnit.lucenekmp.util.Bits;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.BytesRefBuilder;
import org.gnit.lucenekmp.util.CommandLineUtil;
import org.gnit.lucenekmp.util.FixedBitSet;
import org.gnit.lucenekmp.util.IOUtils;
import org.gnit.lucenekmp.util.IntsRef;
import org.gnit.lucenekmp.util.LongBitSet;
import org.gnit.lucenekmp.util.StringHelper;
import org.gnit.lucenekmp.util.Version;
import org.gnit.lucenekmp.util.automaton.Automata;
import org.gnit.lucenekmp.util.automaton.Automaton;
import org.gnit.lucenekmp.util.automaton.ByteRunAutomaton;
import org.gnit.lucenekmp.util.automaton.CompiledAutomaton;
import org.gnit.lucenekmp.util.automaton.Operations;
import org.gnit.lucenekmp.util.hnsw.HnswGraph;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 E2\u00060\u0001j\u0002`\u0002:\b>?@ABCDEB\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u000e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0011J\u0006\u0010\u0014\u001a\u00020\u0011J\u000e\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u0011J\u0016\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\fJ\u000e\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\nJ\u0018\u0010 \u001a\u00020!2\u0010\b\u0002\u0010\"\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010#J\u001c\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010%\u001a\u00020&J\u0018\u0010'\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020*H\u0002J \u0010+\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020*2\u0006\u0010,\u001a\u00020-H\u0002J*\u0010.\u001a\b\u0012\u0004\u0012\u0002H00/\"\u0004\b\u0000\u001002\f\u00101\u001a\b\u0012\u0004\u0012\u0002H0022\u0006\u0010%\u001a\u00020&H\u0002J\"\u00103\u001a\b\u0012\u0004\u0012\u0002H504\"\u0004\b\u0000\u001052\f\u00106\u001a\b\u0012\u0004\u0012\u0002H502H\u0002J \u00107\u001a\u00020-2\u0006\u00108\u001a\u0002092\u0006\u0010)\u001a\u00020*2\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010:\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020!J\u000e\u0010;\u001a\u00020\u00112\u0006\u0010<\u001a\u00020=R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lorg/gnit/lucenekmp/index/CheckIndex;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "dir", "Lorg/gnit/lucenekmp/store/Directory;", "writeLock", "Lorg/gnit/lucenekmp/store/Lock;", "<init>", "(Lorg/gnit/lucenekmp/store/Directory;Lorg/gnit/lucenekmp/store/Lock;)V", "infoStream", "Lorg/gnit/lucenekmp/jdkport/PrintStream;", "closed", "", "ensureOpen", "", "close", "level", "", "setLevel", "v", "getLevel", "failFast", "getFailFast", "()Z", "setFailFast", "(Z)V", "verbose", "setThreadCount", "tc", "threadCount", "setInfoStream", "out", "checkIndex", "Lorg/gnit/lucenekmp/index/CheckIndex$Status;", "onlySegments", "", "", "executorService", "Lorg/gnit/lucenekmp/jdkport/ExecutorService;", "updateMaxSegmentName", "result", "info", "Lorg/gnit/lucenekmp/index/SegmentCommitInfo;", "processSegmentInfoStatusResult", "segmentInfoStatus", "Lorg/gnit/lucenekmp/index/CheckIndex$Status$SegmentInfoStatus;", "runAsyncSegmentCheck", "Lkotlinx/coroutines/CompletableDeferred;", "R", "asyncCallable", "Lorg/gnit/lucenekmp/jdkport/Callable;", "callableToSupplier", "Lkotlin/Function0;", "T", "callable", "testSegment", "sis", "Lorg/gnit/lucenekmp/index/SegmentInfos;", "exorciseIndex", "doCheck", "opts", "Lorg/gnit/lucenekmp/index/CheckIndex$Options;", "Status", "VerifyPointsVisitor", "ConstantRelationIntersectVisitor", "DocValuesIteratorSupplier", "Options", "Level", "CheckIndexException", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nCheckIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CheckIndex.kt\norg/gnit/lucenekmp/index/CheckIndex\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 MutableListExt.kt\norg/gnit/lucenekmp/jdkport/MutableListExtKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 6 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,4933:1\n1#2:4934\n4#3,4:4935\n8#3,5:4943\n4#3,4:4948\n8#3,5:4956\n37#4:4939\n36#4,3:4940\n37#4:4952\n36#4,3:4953\n3#5,8:4961\n10#6:4969\n*S KotlinDebug\n*F\n+ 1 CheckIndex.kt\norg/gnit/lucenekmp/index/CheckIndex\n*L\n575#1:4935,4\n575#1:4943,5\n751#1:4948,4\n751#1:4956,5\n575#1:4939\n575#1:4940,3\n751#1:4952\n751#1:4953,3\n823#1:4961,8\n823#1:4969\n*E\n"})
public final class CheckIndex
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Directory dir;
    @NotNull
    private final Lock writeLock;
    @Nullable
    private PrintStream infoStream;
    private volatile boolean closed;
    private int level;
    private boolean failFast;
    private boolean verbose;
    private int threadCount;
    private static boolean assertsOn;

    public CheckIndex(@NotNull Directory dir, @NotNull Lock writeLock) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)writeLock, (String)"writeLock");
        this.threadCount = 1;
        this.dir = dir;
        this.writeLock = writeLock;
        this.infoStream = null;
    }

    public /* synthetic */ CheckIndex(Directory directory, Lock lock2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            lock2 = directory.obtainLock("write.lock");
        }
        this(directory, lock2);
    }

    private final void ensureOpen() {
        if (this.closed) {
            throw new AlreadyClosedException("this instance is closed");
        }
    }

    @Override
    public void close() {
        this.closed = true;
        AutoCloseable[] autoCloseableArray = new AutoCloseable[]{this.writeLock};
        IOUtils.INSTANCE.close(autoCloseableArray);
    }

    public final void setLevel(int v) {
        Level.INSTANCE.checkIfLevelInBounds(v);
        this.level = v;
    }

    public final int getLevel() {
        return this.level;
    }

    public final boolean getFailFast() {
        return this.failFast;
    }

    public final void setFailFast(boolean bl) {
        this.failFast = bl;
    }

    public final void setThreadCount(int tc) {
        if (!(tc > 0)) {
            boolean bl = false;
            String string = "setThreadCount requires a number larger than 0, but got: " + tc;
            throw new IllegalArgumentException(string.toString());
        }
        this.threadCount = tc;
    }

    public final void setInfoStream(@NotNull PrintStream out, boolean verbose) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        this.infoStream = out;
        this.verbose = verbose;
    }

    public final void setInfoStream(@NotNull PrintStream out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        this.setInfoStream(out, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Status checkIndex(@Nullable List<String> onlySegments) throws IOException {
        Status status;
        block3: {
            Ref.ObjectRef executorService = new Ref.ObjectRef();
            PrintStream printStream = this.infoStream;
            Intrinsics.checkNotNull((Object)printStream);
            CheckIndex.Companion.msg(printStream, "Checking index with threadCount: " + this.threadCount);
            try {
                List<String> list = onlySegments;
                Intrinsics.checkNotNull(list);
                Object object = executorService.element;
                Intrinsics.checkNotNull((Object)object);
                status = this.checkIndex(list, (ExecutorService)object);
                if (executorService.element == null) break block3;
                ((ExecutorService)executorService.element).shutdown();
            }
            catch (Throwable throwable) {
                if (executorService.element != null) {
                    ((ExecutorService)executorService.element).shutdown();
                    BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Object>, Object>((Ref.ObjectRef<ExecutorService>)executorService, this, null){
                        Object L$0;
                        int label;
                        final /* synthetic */ Ref.ObjectRef<ExecutorService> $executorService;
                        final /* synthetic */ CheckIndex this$0;
                        {
                            this.$executorService = $executorService;
                            this.this$0 = $receiver;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Unable to fully structure code
                         */
                        public final Object invokeSuspend(Object $result) {
                            block17: {
                                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        v0 = ((ExecutorService)this.$executorService.element).awaitTermination(5L, TimeUnit.SECONDS, (Continuation<? super Boolean>)((Continuation)this));
                                        ** if (v0 != var4_2) goto lbl11
lbl10:
                                        // 1 sources

                                        return var4_2;
lbl11:
                                        // 1 sources

                                        ** GOTO lbl17
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl17:
                                        // 2 sources

                                        this.L$0 = var2_3 = v0;
                                        this.label = 2;
                                        v1 = ((ExecutorService)this.$executorService.element).shutdownNow((Continuation<? super List<Runnable>>)((Continuation)this));
                                        ** if (v1 != var4_2) goto lbl22
lbl21:
                                        // 1 sources

                                        return var4_2;
lbl22:
                                        // 1 sources

                                        break;
                                    }
                                    case 2: {
                                        var2_3 = this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v1 = $result;
                                        break;
                                    }
                                }
                                catch (InterruptedException e) {
                                    v2 = CheckIndex.access$getInfoStream$p(this.this$0);
                                    Intrinsics.checkNotNull((Object)v2);
                                    org.gnit.lucenekmp.index.CheckIndex$Companion.access$msg(CheckIndex.Companion, v2, "ERROR: Interrupted exception occurred when shutting down executor service");
                                    if (CheckIndex.access$getInfoStream$p(this.this$0) != null) {
                                        v3 = e;
                                        v4 = CheckIndex.access$getInfoStream$p(this.this$0);
                                        Intrinsics.checkNotNull((Object)v4);
                                        ThrowableExtKt.printStackTrace(v3, v4);
                                    }
                                    this.L$0 = var2_3 = Unit.INSTANCE;
                                    this.label = 3;
                                    v5 = ((ExecutorService)this.$executorService.element).shutdownNow((Continuation<? super List<Runnable>>)((Continuation)this));
                                    ** if (v5 != var4_2) goto lbl43
lbl42:
                                    // 1 sources

                                    return var4_2;
lbl43:
                                    // 1 sources

                                    break block17;
                                }
                                {
                                    case 3: {
                                        var2_3 = (Unit)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v5 = $result;
                                        break;
                                    }
                                }
                                {
                                    catch (Throwable var3_5) {
                                        this.L$0 = var3_5;
                                        this.label = 4;
                                        v6 = ((ExecutorService)this.$executorService.element).shutdownNow((Continuation<? super List<Runnable>>)((Continuation)this));
                                        if (v6 == var4_2) {
                                            return var4_2;
                                        }
                                        ** GOTO lbl60
                                    }
                                }
                                {
                                    case 4: {
                                        var3_6 = (Throwable)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v6 = $result;
lbl60:
                                        // 2 sources

                                        throw var3_6;
                                    }
                                }
                            }
                            return var2_3;
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<Object> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)1, null);
                }
                throw throwable;
            }
            BuildersKt.runBlocking$default(null, (Function2)((Function2)new /* invalid duplicate definition of identical inner class */), (int)1, null);
        }
        return status;
    }

    public static /* synthetic */ Status checkIndex$default(CheckIndex checkIndex2, List list, int n, Object object) throws IOException {
        if ((n & 1) != 0) {
            list = null;
        }
        return checkIndex2.checkIndex(list);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Status checkIndex(@NotNull List<String> onlySegments, @NotNull ExecutorService executorService) throws IOException {
        SegmentCommitInfo info;
        int i;
        void $this$sort$iv;
        String $this$sort$iv2;
        Intrinsics.checkNotNullParameter(onlySegments, (String)"onlySegments");
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        this.ensureOpen();
        long startNS = org.gnit.lucenekmp.jdkport.System.INSTANCE.nanoTime();
        Status result = new Status();
        result.setDir(this.dir);
        Object[] files = this.dir.listAll();
        String lastSegmentsFile = SegmentInfos.Companion.getLastCommitSegmentsFileName((String[])files);
        if (lastSegmentsFile == null) {
            String string = Arrays.toString(files);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            throw new IndexNotFoundException("no segments* file found in " + this.dir + ": files: " + string);
        }
        SegmentInfos lastCommit = null;
        List allSegmentsFiles = new ArrayList();
        for (Object fileName : files) {
            if (!StringsKt.startsWith$default((String)fileName, (String)"segments", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)fileName, (Object)"segments.gen")) continue;
            allSegmentsFiles.add(fileName);
        }
        List list = allSegmentsFiles;
        Comparator Comparator$iv = CheckIndex::checkIndex$lambda$1;
        boolean $i$f$sort = false;
        int size$iv = $this$sort$iv2.size();
        if (size$iv >= 2) {
            Collection $this$toTypedArray$iv$iv = (Collection)((Object)$this$sort$iv2);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            String[] array$iv = thisCollection$iv$iv.toArray(new String[0]);
            ArraysKt.sortWith((Object[])array$iv, (Comparator)Comparator$iv);
            for (int i$iv = 0; i$iv < size$iv; ++i$iv) {
                $this$sort$iv2.set(i$iv, array$iv[i$iv]);
            }
        }
        for (String fileName : allSegmentsFiles) {
            boolean isLastCommit = Intrinsics.areEqual((Object)fileName, (Object)lastSegmentsFile);
            SegmentInfos infos = null;
            try {
                infos = SegmentInfos.Companion.readCommit(this.dir, fileName, 0);
            }
            catch (Throwable t) {
                if (this.failFast) {
                    IOUtils.INSTANCE.rethrowAlways(t);
                    throw new KotlinNothingValueException();
                }
                String message = isLastCommit ? "ERROR: could not read latest commit point from segments file \"" + fileName + "\" in directory" : "ERROR: could not read old (not latest) commit point segments file \"" + fileName + "\" in directory";
                PrintStream printStream = this.infoStream;
                Intrinsics.checkNotNull((Object)printStream);
                CheckIndex.Companion.msg(printStream, message);
                result.setMissingSegments(true);
                if (this.infoStream != null) {
                    PrintStream printStream2 = this.infoStream;
                    Intrinsics.checkNotNull((Object)printStream2);
                    ThrowableExtKt.printStackTrace(t, printStream2);
                }
                return result;
            }
            if (!isLastCommit) continue;
            lastCommit = infos;
        }
        if (lastCommit == null) {
            $this$sort$iv2 = "Required value was null.";
            throw new IllegalStateException($this$sort$iv2.toString());
        }
        if (this.infoStream != null) {
            int maxDoc = 0;
            int delCount = 0;
            for (SegmentCommitInfo info2 : lastCommit) {
                maxDoc += info2.getInfo().maxDoc();
                delCount += info2.getDelCount();
            }
            PrintStream printStream = this.infoStream;
            Intrinsics.checkNotNull((Object)printStream);
            printStream.print(100.0 * (double)delCount / (double)maxDoc + "% total deletions; " + maxDoc + " documents; " + delCount + " deletions%n");
        }
        Version oldest = null;
        Version newest = null;
        String oldSegs = null;
        for (SegmentCommitInfo si : lastCommit) {
            Version version = si.getInfo().getVersion();
            if (version == null) {
                oldSegs = "pre-3.1";
                continue;
            }
            if (oldest == null || !version.onOrAfter(oldest)) {
                oldest = version;
            }
            if (newest != null && !version.onOrAfter(newest)) continue;
            newest = version;
        }
        int numSegments = lastCommit.size();
        String segmentsFileName = lastCommit.getSegmentsFileName();
        result.setSegmentsFileName(segmentsFileName);
        result.setNumSegments(numSegments);
        result.setUserData(lastCommit.getUserData());
        String userDataString = !lastCommit.getUserData().isEmpty() ? " userData=" + lastCommit.getUserData() : "";
        Object versionString = "";
        if (oldSegs != null) {
            versionString = newest != null ? "versions=[" + oldSegs + " .. " + newest + "]" : "version=" + oldSegs;
        } else if (newest != null) {
            versionString = Intrinsics.areEqual((Object)oldest, (Object)newest) ? "version=" + oldest : "versions=[" + oldest + " .. " + newest + "]";
        }
        PrintStream printStream = this.infoStream;
        Intrinsics.checkNotNull((Object)printStream);
        CheckIndex.Companion.msg(printStream, "Segments file=" + segmentsFileName + " numSegments=" + numSegments + " " + (String)versionString + " id=" + StringHelper.INSTANCE.idToString(lastCommit.getId()) + userDataString);
        result.setPartial(true);
        if (this.infoStream != null) {
            PrintStream printStream3 = this.infoStream;
            Intrinsics.checkNotNull((Object)printStream3);
            printStream3.print("\nChecking only these segments:");
            for (String s : onlySegments) {
                PrintStream printStream4 = this.infoStream;
                Intrinsics.checkNotNull((Object)printStream4);
                printStream4.print(" " + s);
            }
        }
        result.getSegmentsChecked().addAll((Collection<String>)onlySegments);
        PrintStream printStream5 = this.infoStream;
        Intrinsics.checkNotNull((Object)printStream5);
        CheckIndex.Companion.msg(printStream5, ":");
        result.setNewSegments(lastCommit.clone());
        SegmentInfos segmentInfos = result.getNewSegments();
        Intrinsics.checkNotNull((Object)segmentInfos);
        segmentInfos.clear();
        result.setMaxSegmentName(-1L);
        ByteArrayOutputStream[] outputs = new ByteArrayOutputStream[numSegments];
        CompletableDeferred[] futures = new CompletableDeferred[numSegments];
        List segmentCommitInfos = new ArrayList();
        for (SegmentCommitInfo sci : lastCommit) {
            segmentCommitInfos.add(sci);
        }
        List list2 = segmentCommitInfos;
        Comparator Comparator$iv2 = (arg_0, arg_1) -> CheckIndex.checkIndex$lambda$2(this, arg_0, arg_1);
        boolean $i$f$sort2 = false;
        int size$iv2 = $this$sort$iv.size();
        if (size$iv2 >= 2) {
            Collection $this$toTypedArray$iv$iv = (Collection)$this$sort$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            Object[] array$iv = thisCollection$iv$iv.toArray(new SegmentCommitInfo[0]);
            ArraysKt.sortWith((Object[])array$iv, (Comparator)Comparator$iv2);
            for (int i$iv = 0; i$iv < size$iv2; ++i$iv) {
                $this$sort$iv.set(i$iv, array$iv[i$iv]);
            }
        }
        for (i = numSegments - 1; -1 < i; --i) {
            info = (SegmentCommitInfo)segmentCommitInfos.get(i);
            this.updateMaxSegmentName(result, info);
            if (onlySegments != null && !onlySegments.contains(info.getInfo().getName())) continue;
            SegmentInfos finalSis = lastCommit;
            ByteArrayOutputStream output = new ByteArrayOutputStream(0, 1, null);
            PrintStream stream = new PrintStream(output, true, StandardCharsets.Companion.getUTF_8());
            CheckIndex.Companion.msg(stream, 1 + i + " of " + numSegments + ": name=" + info.getInfo().getName() + " maxDoc=" + info.getInfo().maxDoc());
            outputs[i] = output;
            futures[i] = this.runAsyncSegmentCheck(() -> CheckIndex.checkIndex$lambda$3(this, finalSis, info, stream), executorService);
        }
        for (i = 0; i < numSegments; ++i) {
            info = (SegmentCommitInfo)segmentCommitInfos.get(i);
            if (onlySegments != null && !onlySegments.contains(info.getInfo().getName())) continue;
            ByteArrayOutputStream output = outputs[i];
            Status.SegmentInfoStatus segmentInfoStatus = null;
            try {
                segmentInfoStatus = (Status.SegmentInfoStatus)futures[i].getCompleted();
            }
            catch (InterruptedException e) {
                PrintStream printStream6 = this.infoStream;
                Intrinsics.checkNotNull((Object)printStream6);
                CheckIndex.Companion.msg(printStream6, output);
                PrintStream printStream7 = this.infoStream;
                Intrinsics.checkNotNull((Object)printStream7);
                CheckIndex.Companion.msg(printStream7, "ERROR: Interrupted exception occurred when getting segment check result for segment " + info.getInfo().getName());
                if (this.infoStream != null) {
                    Throwable throwable = e;
                    PrintStream printStream8 = this.infoStream;
                    Intrinsics.checkNotNull((Object)printStream8);
                    ThrowableExtKt.printStackTrace(throwable, printStream8);
                }
            }
            catch (ExecutionException e) {
                PrintStream printStream9 = this.infoStream;
                Intrinsics.checkNotNull((Object)printStream9);
                CheckIndex.Companion.msg(printStream9, output.toString(StandardCharsets.Companion.getUTF_8()));
                boolean condition$iv = this.failFast;
                boolean $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    boolean bl = false;
                    String string = "assertion failed";
                    throw new AssertionError((Object)string);
                }
                String string = "Segment " + info.getInfo().getName() + " check failed.";
                Throwable throwable = e.getCause();
                Intrinsics.checkNotNull((Object)throwable);
                throw new CheckIndexException(string, throwable);
            }
            PrintStream printStream10 = this.infoStream;
            Intrinsics.checkNotNull((Object)printStream10);
            CheckIndex.Companion.msg(printStream10, output);
            Status.SegmentInfoStatus segmentInfoStatus2 = segmentInfoStatus;
            Intrinsics.checkNotNull((Object)segmentInfoStatus2);
            this.processSegmentInfoStatusResult(result, info, segmentInfoStatus2);
        }
        if (result.getNumBadSegments() == 0) {
            result.setClean(true);
        } else {
            PrintStream printStream11 = this.infoStream;
            Intrinsics.checkNotNull((Object)printStream11);
            CheckIndex.Companion.msg(printStream11, "WARNING: " + result.getNumBadSegments() + " broken segments (containing " + result.getTotLoseDocCount() + " documents) detected");
        }
        result.setValidCounter(result.getMaxSegmentName() < lastCommit.getCounter());
        if (!result.getValidCounter()) {
            result.setClean(false);
            SegmentInfos segmentInfos2 = result.getNewSegments();
            Intrinsics.checkNotNull((Object)segmentInfos2);
            segmentInfos2.setCounter(result.getMaxSegmentName() + 1L);
            PrintStream printStream12 = this.infoStream;
            Intrinsics.checkNotNull((Object)printStream12);
            CheckIndex.Companion.msg(printStream12, "ERROR: Next segment name counter " + lastCommit.getCounter() + " is not greater than max segment name " + result.getMaxSegmentName());
        }
        if (result.getClean()) {
            PrintStream printStream13 = this.infoStream;
            Intrinsics.checkNotNull((Object)printStream13);
            CheckIndex.Companion.msg(printStream13, "No problems were detected with this index.\n");
        }
        PrintStream printStream14 = this.infoStream;
        Intrinsics.checkNotNull((Object)printStream14);
        CheckIndex.Companion.msg(printStream14, "Took " + CheckIndex.Companion.nsToSec(org.gnit.lucenekmp.jdkport.System.INSTANCE.nanoTime() - startNS) + " sec total.");
        return result;
    }

    private final void updateMaxSegmentName(Status result, SegmentCommitInfo info) {
        String string = info.getInfo().getName().substring(1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        long segmentName = Long.parseLong(string, CharsKt.checkRadix((int)36));
        if (segmentName > result.getMaxSegmentName()) {
            result.setMaxSegmentName(segmentName);
        }
    }

    private final void processSegmentInfoStatusResult(Status result, SegmentCommitInfo info, Status.SegmentInfoStatus segmentInfoStatus) {
        result.getSegmentInfos().add(segmentInfoStatus);
        if (segmentInfoStatus.getError() != null) {
            result.setTotLoseDocCount(result.getTotLoseDocCount() + segmentInfoStatus.getToLoseDocCount());
            int n = result.getNumBadSegments();
            result.setNumBadSegments(n + 1);
        } else {
            SegmentInfos segmentInfos = result.getNewSegments();
            Intrinsics.checkNotNull((Object)segmentInfos);
            segmentInfos.add(info.clone());
        }
    }

    private final <R> CompletableDeferred<R> runAsyncSegmentCheck(Callable<R> asyncCallable, ExecutorService executorService) {
        CompletableDeferred deferred = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        executorService.execute(() -> CheckIndex.runAsyncSegmentCheck$lambda$4(deferred, asyncCallable));
        return deferred;
    }

    private final <T> Function0<T> callableToSupplier(Callable<T> callable) {
        return () -> CheckIndex.callableToSupplier$lambda$5(callable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Status.SegmentInfoStatus testSegment(SegmentInfos sis, SegmentCommitInfo info, PrintStream infoStream) throws IOException {
        Status.SegmentInfoStatus segInfoStat = new Status.SegmentInfoStatus();
        segInfoStat.setName(info.getInfo().getName());
        segInfoStat.setMaxDoc(info.getInfo().maxDoc());
        Version version = info.getInfo().getVersion();
        if (info.getInfo().maxDoc() <= 0) {
            throw new CheckIndexException(" illegal number of documents: maxDoc=" + info.getInfo().maxDoc());
        }
        int toLoseDocCount = info.getInfo().maxDoc();
        IndexReader reader2 = null;
        try {
            int numDocs;
            Object object = version;
            if (object == null) {
                object = "3.0";
            }
            CheckIndex.Companion.msg(infoStream, "    version=" + object);
            CheckIndex.Companion.msg(infoStream, "    id=" + StringHelper.INSTANCE.idToString(info.getInfo().getId()));
            Codec codec = info.getInfo().getCodec();
            CheckIndex.Companion.msg(infoStream, "    codec=" + codec);
            segInfoStat.setCodec(codec);
            CheckIndex.Companion.msg(infoStream, "    compound=" + info.getInfo().getUseCompoundFile());
            segInfoStat.setCompound(info.getInfo().getUseCompoundFile());
            CheckIndex.Companion.msg(infoStream, "    numFiles=" + info.files().size());
            Sort indexSort = info.getInfo().getIndexSort();
            if (indexSort != null) {
                CheckIndex.Companion.msg(infoStream, "    sort=" + indexSort);
            }
            segInfoStat.setNumFiles(info.files().size());
            segInfoStat.setSizeMB((double)info.sizeInBytes() / 1048576.0);
            CheckIndex.Companion.msg(infoStream, "    size (MB)= " + segInfoStat.getSizeMB());
            Map<String, String> diagnostics = info.getInfo().getDiagnostics();
            segInfoStat.setDiagnostics(diagnostics);
            if (!diagnostics.isEmpty()) {
                CheckIndex.Companion.msg(infoStream, "    diagnostics = " + diagnostics);
            }
            if (!info.hasDeletions()) {
                CheckIndex.Companion.msg(infoStream, "    no deletions");
                segInfoStat.setHasDeletions(false);
            } else {
                CheckIndex.Companion.msg(infoStream, "    has deletions [delGen=" + info.getDelGen() + "]");
                segInfoStat.setHasDeletions(true);
                segInfoStat.setDeletionsGen(info.getDelGen());
            }
            long startOpenReaderNS = org.gnit.lucenekmp.jdkport.System.INSTANCE.nanoTime();
            if (infoStream != null) {
                infoStream.print("    test: open reader.........");
            }
            reader2 = new SegmentReader(info, sis.getIndexCreatedVersionMajor(), IOContext.Companion.getDEFAULT());
            CheckIndex.Companion.msg(infoStream, "OK [took " + CheckIndex.Companion.nsToSec(org.gnit.lucenekmp.jdkport.System.INSTANCE.nanoTime() - startOpenReaderNS) + " sec]");
            segInfoStat.setOpenReaderPassed(true);
            long startIntegrityNS = org.gnit.lucenekmp.jdkport.System.INSTANCE.nanoTime();
            if (infoStream != null) {
                infoStream.print("    test: check integrity.....");
            }
            ((SegmentReader)reader2).checkIntegrity();
            CheckIndex.Companion.msg(infoStream, "OK [took " + CheckIndex.Companion.nsToSec(org.gnit.lucenekmp.jdkport.System.INSTANCE.nanoTime() - startIntegrityNS) + " sec]");
            if (((SegmentReader)reader2).maxDoc() != info.getInfo().maxDoc()) {
                throw new CheckIndexException("SegmentReader.maxDoc() " + ((SegmentReader)reader2).maxDoc() + " != SegmentInfo.maxDoc " + info.getInfo().maxDoc());
            }
            toLoseDocCount = numDocs = ((SegmentReader)reader2).numDocs();
            if (reader2.hasDeletions()) {
                if (numDocs != info.getInfo().maxDoc() - info.getDelCount()) {
                    throw new CheckIndexException("delete count mismatch: info=" + (info.getInfo().maxDoc() - info.getDelCount()) + " vs reader=" + numDocs);
                }
                if (info.getInfo().maxDoc() - numDocs > ((SegmentReader)reader2).maxDoc()) {
                    throw new CheckIndexException("too many deleted docs: maxDoc()=" + ((SegmentReader)reader2).maxDoc() + " vs del count=" + (info.getInfo().maxDoc() - numDocs));
                }
                if (info.getInfo().maxDoc() - numDocs != info.getDelCount()) {
                    throw new CheckIndexException("delete count mismatch: info=" + info.getDelCount() + " vs reader=" + (info.getInfo().maxDoc() - numDocs));
                }
            } else if (info.getDelCount() != 0) {
                throw new CheckIndexException("delete count mismatch: info=" + info.getDelCount() + " vs reader=" + (info.getInfo().maxDoc() - numDocs));
            }
            if (this.level >= 2) {
                String softDeletesField;
                segInfoStat.setLiveDocStatus(Companion.testLiveDocs((CodecReader)reader2, infoStream, this.failFast));
                segInfoStat.setFieldInfoStatus(Companion.testFieldInfos((CodecReader)reader2, infoStream, this.failFast));
                segInfoStat.setFieldNormStatus(Companion.testFieldNorms((CodecReader)reader2, infoStream, this.failFast));
                segInfoStat.setTermIndexStatus(Companion.testPostings((CodecReader)reader2, infoStream, this.verbose, this.level, this.failFast));
                segInfoStat.setStoredFieldStatus(Companion.testStoredFields((CodecReader)reader2, infoStream, this.failFast));
                segInfoStat.setTermVectorStatus(Companion.testTermVectors((CodecReader)reader2, infoStream, this.verbose, this.level, this.failFast));
                segInfoStat.setDocValuesStatus(Companion.testDocValues((CodecReader)reader2, infoStream, this.failFast));
                segInfoStat.setPointsStatus(Companion.testPoints((CodecReader)reader2, infoStream, this.failFast));
                segInfoStat.setVectorValuesStatus(Companion.testVectors((CodecReader)reader2, infoStream, this.failFast));
                segInfoStat.setHnswGraphsStatus(Companion.testHnswGraphs((CodecReader)reader2, infoStream, this.failFast));
                if (indexSort != null) {
                    segInfoStat.setIndexSortStatus(Companion.testSort((CodecReader)reader2, indexSort, infoStream, this.failFast));
                }
                if ((softDeletesField = ((SegmentReader)reader2).getFieldInfos().getSoftDeletesField()) != null) {
                    segInfoStat.setSoftDeletesStatus(CheckIndex.Companion.checkSoftDeletes(softDeletesField, info, (SegmentReader)reader2, infoStream, this.failFast));
                }
                Status.LiveDocStatus liveDocStatus = segInfoStat.getLiveDocStatus();
                Intrinsics.checkNotNull((Object)liveDocStatus);
                if (liveDocStatus.getError() != null) {
                    Status.LiveDocStatus liveDocStatus2 = segInfoStat.getLiveDocStatus();
                    Intrinsics.checkNotNull((Object)liveDocStatus2);
                    Throwable throwable = liveDocStatus2.getError();
                    Intrinsics.checkNotNull((Object)throwable);
                    throw new CheckIndexException("Live docs test failed", throwable);
                }
                Status.FieldInfoStatus fieldInfoStatus = segInfoStat.getFieldInfoStatus();
                Intrinsics.checkNotNull((Object)fieldInfoStatus);
                Throwable throwable = fieldInfoStatus.getError();
                Intrinsics.checkNotNull((Object)throwable);
                if (throwable != null) {
                    Status.FieldInfoStatus fieldInfoStatus2 = segInfoStat.getFieldInfoStatus();
                    Intrinsics.checkNotNull((Object)fieldInfoStatus2);
                    Throwable throwable2 = fieldInfoStatus2.getError();
                    Intrinsics.checkNotNull((Object)throwable2);
                    throw new CheckIndexException("Field Info test failed", throwable2);
                }
                Status.FieldNormStatus fieldNormStatus = segInfoStat.getFieldNormStatus();
                Intrinsics.checkNotNull((Object)fieldNormStatus);
                if (fieldNormStatus.getError() != null) {
                    Status.FieldNormStatus fieldNormStatus2 = segInfoStat.getFieldNormStatus();
                    Intrinsics.checkNotNull((Object)fieldNormStatus2);
                    Throwable throwable3 = fieldNormStatus2.getError();
                    Intrinsics.checkNotNull((Object)throwable3);
                    throw new CheckIndexException("Field Norm test failed", throwable3);
                }
                Status.TermIndexStatus termIndexStatus = segInfoStat.getTermIndexStatus();
                Intrinsics.checkNotNull((Object)termIndexStatus);
                if (termIndexStatus.getError() != null) {
                    Status.TermIndexStatus termIndexStatus2 = segInfoStat.getTermIndexStatus();
                    Intrinsics.checkNotNull((Object)termIndexStatus2);
                    Throwable throwable4 = termIndexStatus2.getError();
                    Intrinsics.checkNotNull((Object)throwable4);
                    throw new CheckIndexException("Term Index test failed", throwable4);
                }
                Status.StoredFieldStatus storedFieldStatus = segInfoStat.getStoredFieldStatus();
                Intrinsics.checkNotNull((Object)storedFieldStatus);
                if (storedFieldStatus.getError() != null) {
                    Status.StoredFieldStatus storedFieldStatus2 = segInfoStat.getStoredFieldStatus();
                    Intrinsics.checkNotNull((Object)storedFieldStatus2);
                    Throwable throwable5 = storedFieldStatus2.getError();
                    Intrinsics.checkNotNull((Object)throwable5);
                    throw new CheckIndexException("Stored Field test failed", throwable5);
                }
                Status.TermVectorStatus termVectorStatus = segInfoStat.getTermVectorStatus();
                Intrinsics.checkNotNull((Object)termVectorStatus);
                Throwable throwable6 = termVectorStatus.getError();
                Intrinsics.checkNotNull((Object)throwable6);
                if (throwable6 != null) {
                    Status.TermVectorStatus termVectorStatus2 = segInfoStat.getTermVectorStatus();
                    Intrinsics.checkNotNull((Object)termVectorStatus2);
                    Throwable throwable7 = termVectorStatus2.getError();
                    Intrinsics.checkNotNull((Object)throwable7);
                    throw new CheckIndexException("Term Vector test failed", throwable7);
                }
                Status.DocValuesStatus docValuesStatus = segInfoStat.getDocValuesStatus();
                Intrinsics.checkNotNull((Object)docValuesStatus);
                Throwable throwable8 = docValuesStatus.getError();
                Intrinsics.checkNotNull((Object)throwable8);
                if (throwable8 != null) {
                    Status.DocValuesStatus docValuesStatus2 = segInfoStat.getDocValuesStatus();
                    Intrinsics.checkNotNull((Object)docValuesStatus2);
                    Throwable throwable9 = docValuesStatus2.getError();
                    Intrinsics.checkNotNull((Object)throwable9);
                    throw new CheckIndexException("DocValues test failed", throwable9);
                }
                Status.PointsStatus pointsStatus = segInfoStat.getPointsStatus();
                Intrinsics.checkNotNull((Object)pointsStatus);
                Throwable throwable10 = pointsStatus.getError();
                Intrinsics.checkNotNull((Object)throwable10);
                if (throwable10 != null) {
                    Status.PointsStatus pointsStatus2 = segInfoStat.getPointsStatus();
                    Intrinsics.checkNotNull((Object)pointsStatus2);
                    Throwable throwable11 = pointsStatus2.getError();
                    Intrinsics.checkNotNull((Object)throwable11);
                    throw new CheckIndexException("Points test failed", throwable11);
                }
                Status.VectorValuesStatus vectorValuesStatus = segInfoStat.getVectorValuesStatus();
                Intrinsics.checkNotNull((Object)vectorValuesStatus);
                Throwable throwable12 = vectorValuesStatus.getError();
                Intrinsics.checkNotNull((Object)throwable12);
                if (throwable12 != null) {
                    Status.VectorValuesStatus vectorValuesStatus2 = segInfoStat.getVectorValuesStatus();
                    Intrinsics.checkNotNull((Object)vectorValuesStatus2);
                    Throwable throwable13 = vectorValuesStatus2.getError();
                    Intrinsics.checkNotNull((Object)throwable13);
                    throw new CheckIndexException("Vectors test failed", throwable13);
                }
                if (segInfoStat.getIndexSortStatus() != null) {
                    Status.IndexSortStatus indexSortStatus = segInfoStat.getIndexSortStatus();
                    Intrinsics.checkNotNull((Object)indexSortStatus);
                    Throwable throwable14 = indexSortStatus.getError();
                    Intrinsics.checkNotNull((Object)throwable14);
                    if (throwable14 != null) {
                        Status.IndexSortStatus indexSortStatus2 = segInfoStat.getIndexSortStatus();
                        Intrinsics.checkNotNull((Object)indexSortStatus2);
                        Throwable throwable15 = indexSortStatus2.getError();
                        Intrinsics.checkNotNull((Object)throwable15);
                        throw new CheckIndexException("Index Sort test failed", throwable15);
                    }
                }
                if (segInfoStat.getSoftDeletesStatus() != null) {
                    Status.SoftDeletesStatus softDeletesStatus = segInfoStat.getSoftDeletesStatus();
                    Intrinsics.checkNotNull((Object)softDeletesStatus);
                    if (softDeletesStatus.getError() != null) {
                        Status.SoftDeletesStatus softDeletesStatus2 = segInfoStat.getSoftDeletesStatus();
                        Intrinsics.checkNotNull((Object)softDeletesStatus2);
                        Throwable throwable16 = softDeletesStatus2.getError();
                        Intrinsics.checkNotNull((Object)throwable16);
                        throw new CheckIndexException("Soft Deletes test failed", throwable16);
                    }
                }
            }
            CheckIndex.Companion.msg(infoStream, "");
        }
        catch (Throwable t) {
            try {
                if (this.failFast) {
                    IOUtils.INSTANCE.rethrowAlways(t);
                    throw new KotlinNothingValueException();
                }
                segInfoStat.setError(t);
                segInfoStat.setToLoseDocCount(toLoseDocCount);
                CheckIndex.Companion.msg(infoStream, "FAILED");
                String comment = "exorciseIndex() would remove reference to this segment";
                CheckIndex.Companion.msg(infoStream, "    WARNING: " + comment + "; full exception:");
                if (infoStream != null) {
                    ThrowableExtKt.printStackTrace(t, infoStream);
                }
                CheckIndex.Companion.msg(infoStream, "");
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (reader2 != null) {
                    reader2.close();
                }
            }
        }
        reader2.close();
        return segInfoStat;
    }

    public final void exorciseIndex(@NotNull Status result) throws IOException {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        this.ensureOpen();
        if (!(!result.getPartial())) {
            boolean bl = false;
            String string = "can only exorcise an index that was fully checked (this status checked a subset of segments)";
            throw new IllegalArgumentException(string.toString());
        }
        SegmentInfos segmentInfos = result.getNewSegments();
        Intrinsics.checkNotNull((Object)segmentInfos);
        segmentInfos.changed();
        SegmentInfos segmentInfos2 = result.getNewSegments();
        Intrinsics.checkNotNull((Object)segmentInfos2);
        Directory directory = result.getDir();
        Intrinsics.checkNotNull((Object)directory);
        segmentInfos2.commit(directory);
    }

    public final int doCheck(@NotNull Options opts) throws IOException, InterruptedException {
        Status result;
        Intrinsics.checkNotNullParameter((Object)opts, (String)"opts");
        this.setLevel(opts.getLevel());
        PrintStream printStream = opts.getOut();
        Intrinsics.checkNotNull((Object)printStream);
        this.setInfoStream(printStream, opts.getVerbose());
        if (opts.getThreadCount() > 0) {
            this.setThreadCount(opts.getThreadCount());
        }
        if ((result = this.checkIndex(opts.getOnlySegments())).getMissingSegments()) {
            return 1;
        }
        if (!result.getClean()) {
            if (!opts.getDoExorcise()) {
                PrintStream printStream2 = opts.getOut();
                Intrinsics.checkNotNull((Object)printStream2);
                printStream2.println("WARNING: would write new segments file, and " + result.getTotLoseDocCount() + " documents would be lost, if -exorcise were specified\n");
            } else {
                PrintStream printStream3 = opts.getOut();
                Intrinsics.checkNotNull((Object)printStream3);
                printStream3.println("WARNING: " + result.getTotLoseDocCount() + " documents will be lost\n");
                PrintStream printStream4 = opts.getOut();
                Intrinsics.checkNotNull((Object)printStream4);
                printStream4.println("NOTE: will write new segments file in 5 seconds; this will remove " + result.getTotLoseDocCount() + " docs from the index. YOU WILL LOSE DATA. THIS IS YOUR LAST CHANCE TO CTRL+C!");
                BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(opts, null){
                    int I$0;
                    int I$1;
                    int I$2;
                    int I$3;
                    Object L$0;
                    int label;
                    final /* synthetic */ Options $opts;
                    {
                        this.$opts = $opts;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object $result) {
                        var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                var2_3 = 5;
                                var3_4 = this.$opts;
                                var4_5 = 0;
lbl8:
                                // 2 sources

                                while (var4_5 < var2_3) {
                                    i = var4_5;
                                    $i$a$-repeat-CheckIndex$doCheck$1$1 = 0;
                                    this.L$0 = var3_4;
                                    this.I$0 = var2_3;
                                    this.I$1 = var4_5;
                                    this.I$2 = i;
                                    this.I$3 = $i$a$-repeat-CheckIndex$doCheck$1$1;
                                    this.label = 1;
                                    v0 = DelayKt.delay((long)1000L, (Continuation)this);
                                    if (v0 == var7_2) {
                                        return var7_2;
                                    }
                                    ** GOTO lbl30
                                }
                                break;
                            }
                            case 1: {
                                $i$a$-repeat-CheckIndex$doCheck$1$1 = this.I$3;
                                i = this.I$2;
                                var4_5 = this.I$1;
                                var2_3 = this.I$0;
                                var3_4 = (Options)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl30:
                                // 2 sources

                                v1 = var3_4.getOut();
                                Intrinsics.checkNotNull((Object)v1);
                                v1.println("  " + (5 - i) + "...");
                                ++var4_5;
                                ** GOTO lbl8
                            }
                        }
                        return Unit.INSTANCE;
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)1, null);
                PrintStream printStream5 = opts.getOut();
                Intrinsics.checkNotNull((Object)printStream5);
                printStream5.println("Writing...");
                this.exorciseIndex(result);
                PrintStream printStream6 = opts.getOut();
                Intrinsics.checkNotNull((Object)printStream6);
                printStream6.println("OK");
                PrintStream printStream7 = opts.getOut();
                Intrinsics.checkNotNull((Object)printStream7);
                SegmentInfos segmentInfos = result.getNewSegments();
                Intrinsics.checkNotNull((Object)segmentInfos);
                printStream7.println("Wrote new segments file \"" + segmentInfos.getSegmentsFileName() + "\"");
            }
        }
        PrintStream printStream8 = opts.getOut();
        Intrinsics.checkNotNull((Object)printStream8);
        printStream8.println();
        return result.getClean() ? 0 : 1;
    }

    private static final int checkIndex$lambda$1(String a, String b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        long genA = SegmentInfos.Companion.generationFromSegmentsFileName(a);
        long genB = SegmentInfos.Companion.generationFromSegmentsFileName(b);
        return -LongExtKt.compare(LongCompanionObject.INSTANCE, genA, genB);
    }

    private static final int checkIndex$lambda$2(CheckIndex this$0, SegmentCommitInfo info1, SegmentCommitInfo info2) {
        Intrinsics.checkNotNullParameter((Object)info1, (String)"info1");
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info2");
        try {
            return LongExtKt.compare(LongCompanionObject.INSTANCE, info1.sizeInBytes(), info2.sizeInBytes());
        }
        catch (IOException e) {
            PrintStream printStream = this$0.infoStream;
            Intrinsics.checkNotNull((Object)printStream);
            CheckIndex.Companion.msg(printStream, "ERROR: IOException occurred when comparing SegmentCommitInfo file sizes");
            if (this$0.infoStream != null) {
                Throwable throwable = e;
                PrintStream printStream2 = this$0.infoStream;
                Intrinsics.checkNotNull((Object)printStream2);
                ThrowableExtKt.printStackTrace(throwable, printStream2);
            }
            return 0;
        }
    }

    private static final Status.SegmentInfoStatus checkIndex$lambda$3(CheckIndex this$0, SegmentInfos $finalSis, SegmentCommitInfo $info, PrintStream $stream) {
        return this$0.testSegment($finalSis, $info, $stream);
    }

    private static final void runAsyncSegmentCheck$lambda$4(CompletableDeferred $deferred, Callable $asyncCallable) {
        try {
            $deferred.complete($asyncCallable.call());
        }
        catch (Throwable e) {
            $deferred.completeExceptionally(e);
        }
    }

    private static final Object callableToSupplier$lambda$5(Callable $callable) {
        Object t;
        try {
            t = $callable.call();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            throw new Exception(e);
        }
        return t;
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) throws IOException, InterruptedException {
        Companion.main(args);
    }

    public static final /* synthetic */ PrintStream access$getInfoStream$p(CheckIndex $this) {
        return $this.infoStream;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\t\u00a8\u0006\n"}, d2={"Lorg/gnit/lucenekmp/index/CheckIndex$CheckIndexException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "message", "", "<init>", "(Ljava/lang/String;)V", "cause", "", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "core"})
    public static final class CheckIndexException
    extends RuntimeException {
        public CheckIndexException(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
        }

        public CheckIndexException(@NotNull String message, @NotNull Throwable cause) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
            super(message, cause);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00d8\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\bH\u0002J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\tH\u0002J&\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012J\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012J\\\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u00122\u0006\u0010(\u001a\u00020 H\u0002J \u0010)\u001a\u00020\u00052\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0002J\u0016\u00100\u001a\u00020\u00052\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020 J4\u00104\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00072\b\b\u0002\u0010'\u001a\u00020\u00122\b\b\u0002\u0010(\u001a\u00020 2\b\b\u0002\u0010\u0011\u001a\u00020\u0012J\u001e\u00105\u001a\u0002062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012J\u001e\u00107\u001a\u0002082\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012J\u001e\u00109\u001a\u00020:2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020<2\u0006\u0010>\u001a\u00020\tH\u0002J$\u0010?\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00072\u0012\u0010@\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020B0AH\u0002J \u0010C\u001a\u00020\u00052\u0006\u0010D\u001a\u00020E2\u0006\u0010>\u001a\u00020\t2\u0006\u0010F\u001a\u00020:H\u0002J \u0010G\u001a\u00020H2\u0006\u0010D\u001a\u00020E2\u0006\u0010I\u001a\u00020 2\u0006\u0010(\u001a\u00020 H\u0002J\u0018\u0010J\u001a\u00020\u00122\u0006\u0010K\u001a\u00020\r2\u0006\u0010>\u001a\u00020\tH\u0002J(\u0010L\u001a\u00020\u00052\u0006\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020P2\u0006\u0010F\u001a\u0002082\u0006\u0010K\u001a\u00020\rH\u0002J(\u0010Q\u001a\u00020\u00052\u0006\u0010M\u001a\u00020R2\u0006\u0010O\u001a\u00020P2\u0006\u0010F\u001a\u0002082\u0006\u0010K\u001a\u00020\rH\u0002J\u001e\u0010S\u001a\u00020T2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012J\u001e\u0010U\u001a\u00020V2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010W\u001a\u00020\u00052\u0006\u0010X\u001a\u00020P2\u0006\u0010Y\u001a\u00020ZH\u0002J\u0018\u0010[\u001a\u00020\u00052\u0006\u0010X\u001a\u00020P2\u0006\u0010\\\u001a\u00020]H\u0002J \u0010^\u001a\u00020\u00052\u0006\u0010>\u001a\u00020\t2\u0006\u0010_\u001a\u00020`2\u0006\u0010a\u001a\u00020`H\u0002J \u0010b\u001a\u00020\u00052\u0006\u0010>\u001a\u00020\t2\u0006\u0010c\u001a\u00020d2\u0006\u0010e\u001a\u00020dH\u0002J \u0010f\u001a\u00020\u00052\u0006\u0010>\u001a\u00020\t2\u0006\u0010c\u001a\u00020g2\u0006\u0010e\u001a\u00020gH\u0002J \u0010h\u001a\u00020\u00052\u0006\u0010>\u001a\u00020\t2\u0006\u0010i\u001a\u00020j2\u0006\u0010k\u001a\u00020jH\u0002J \u0010l\u001a\u00020\u00052\u0006\u0010>\u001a\u00020\t2\u0006\u0010i\u001a\u00020m2\u0006\u0010k\u001a\u00020mH\u0002J \u0010n\u001a\u00020\u00052\u0006\u0010X\u001a\u00020P2\u0006\u0010o\u001a\u00020p2\u0006\u0010F\u001a\u00020VH\u0002J4\u0010q\u001a\u00020r2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00072\b\b\u0002\u0010'\u001a\u00020\u00122\b\b\u0002\u0010(\u001a\u00020 2\b\b\u0002\u0010\u0011\u001a\u00020\u0012J\b\u0010t\u001a\u00020\u0012H\u0002J\u0006\u0010s\u001a\u00020\u0012J\u001b\u0010u\u001a\u00020\u00052\f\u0010v\u001a\b\u0012\u0004\u0012\u00020\t0wH\u0007\u00a2\u0006\u0002\u0010xJ\u001b\u0010y\u001a\u00020 2\f\u0010v\u001a\b\u0012\u0004\u0012\u00020\t0wH\u0002\u00a2\u0006\u0002\u0010zJ\u0019\u0010{\u001a\u00020|2\f\u0010v\u001a\b\u0012\u0004\u0012\u00020\t0w\u00a2\u0006\u0002\u0010}J4\u0010~\u001a\u00020\u007f2\u0007\u0010\u0080\u0001\u001a\u00020\t2\b\u0010\u0081\u0001\u001a\u00030\u0082\u00012\u0007\u0010\f\u001a\u00030\u0083\u00012\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0014\u0010\u0084\u0001\u001a\u00030\u0085\u00012\b\u0010\u0086\u0001\u001a\u00030\u0087\u0001H\u0002R\u000e\u0010s\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0088\u0001"}, d2={"Lorg/gnit/lucenekmp/index/CheckIndex$Companion;", "", "<init>", "()V", "msg", "", "out", "Lorg/gnit/lucenekmp/jdkport/PrintStream;", "Lorg/gnit/lucenekmp/jdkport/ByteArrayOutputStream;", "", "testSort", "Lorg/gnit/lucenekmp/index/CheckIndex$Status$IndexSortStatus;", "reader", "Lorg/gnit/lucenekmp/index/CodecReader;", "sort", "Lorg/gnit/lucenekmp/search/Sort;", "infoStream", "failFast", "", "testLiveDocs", "Lorg/gnit/lucenekmp/index/CheckIndex$Status$LiveDocStatus;", "testFieldInfos", "Lorg/gnit/lucenekmp/index/CheckIndex$Status$FieldInfoStatus;", "testFieldNorms", "Lorg/gnit/lucenekmp/index/CheckIndex$Status$FieldNormStatus;", "checkFields", "Lorg/gnit/lucenekmp/index/CheckIndex$Status$TermIndexStatus;", "fields", "Lorg/gnit/lucenekmp/index/Fields;", "liveDocs", "Lorg/gnit/lucenekmp/util/Bits;", "maxDoc", "", "fieldInfos", "Lorg/gnit/lucenekmp/index/FieldInfos;", "normsProducer", "Lorg/gnit/lucenekmp/codecs/NormsProducer;", "doPrint", "isVectors", "verbose", "level", "checkTermsIntersect", "terms", "Lorg/gnit/lucenekmp/index/Terms;", "automaton", "Lorg/gnit/lucenekmp/util/automaton/Automaton;", "startTerm", "Lorg/gnit/lucenekmp/util/BytesRef;", "checkImpacts", "impacts", "Lorg/gnit/lucenekmp/index/Impacts;", "lastTarget", "testPostings", "testPoints", "Lorg/gnit/lucenekmp/index/CheckIndex$Status$PointsStatus;", "testVectors", "Lorg/gnit/lucenekmp/index/CheckIndex$Status$VectorValuesStatus;", "testHnswGraphs", "Lorg/gnit/lucenekmp/index/CheckIndex$Status$HnswGraphsStatus;", "getFieldReaderForName", "Lorg/gnit/lucenekmp/codecs/KnnVectorsReader;", "vectorsReader", "fieldName", "printHnswInfo", "fieldsStatus", "", "Lorg/gnit/lucenekmp/index/CheckIndex$Status$HnswGraphStatus;", "testHnswGraph", "hnswGraph", "Lorg/gnit/lucenekmp/util/hnsw/HnswGraph;", "status", "getConnectedNodesOnLevel", "Lorg/gnit/lucenekmp/internal/hppc/IntIntHashMap;", "numNodesOnLayer", "vectorsReaderSupportsSearch", "codecReader", "checkFloatVectorValues", "values", "Lorg/gnit/lucenekmp/index/FloatVectorValues;", "fieldInfo", "Lorg/gnit/lucenekmp/index/FieldInfo;", "checkByteVectorValues", "Lorg/gnit/lucenekmp/index/ByteVectorValues;", "testStoredFields", "Lorg/gnit/lucenekmp/index/CheckIndex$Status$StoredFieldStatus;", "testDocValues", "Lorg/gnit/lucenekmp/index/CheckIndex$Status$DocValuesStatus;", "checkDocValueSkipper", "fi", "skipper", "Lorg/gnit/lucenekmp/index/DocValuesSkipper;", "checkDVIterator", "producer", "Lorg/gnit/lucenekmp/index/CheckIndex$DocValuesIteratorSupplier;", "checkBinaryDocValues", "bdv", "Lorg/gnit/lucenekmp/index/BinaryDocValues;", "bdv2", "checkSortedDocValues", "dv", "Lorg/gnit/lucenekmp/index/SortedDocValues;", "dv2", "checkSortedSetDocValues", "Lorg/gnit/lucenekmp/index/SortedSetDocValues;", "checkSortedNumericDocValues", "ndv", "Lorg/gnit/lucenekmp/index/SortedNumericDocValues;", "ndv2", "checkNumericDocValues", "Lorg/gnit/lucenekmp/index/NumericDocValues;", "checkDocValues", "dvReader", "Lorg/gnit/lucenekmp/codecs/DocValuesProducer;", "testTermVectors", "Lorg/gnit/lucenekmp/index/CheckIndex$Status$TermVectorStatus;", "assertsOn", "testAsserts", "main", "args", "", "([Ljava/lang/String;)V", "doMain", "([Ljava/lang/String;)I", "parseOptions", "Lorg/gnit/lucenekmp/index/CheckIndex$Options;", "([Ljava/lang/String;)Lorg/gnit/lucenekmp/index/CheckIndex$Options;", "checkSoftDeletes", "Lorg/gnit/lucenekmp/index/CheckIndex$Status$SoftDeletesStatus;", "softDeletesField", "info", "Lorg/gnit/lucenekmp/index/SegmentCommitInfo;", "Lorg/gnit/lucenekmp/index/SegmentReader;", "nsToSec", "", "ns", "", "core"})
    @SourceDebugExtension(value={"SMAP\nCheckIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CheckIndex.kt\norg/gnit/lucenekmp/index/CheckIndex$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 4 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,4933:1\n1#2:4934\n3#3,8:4935\n3#3,8:4944\n3#3,8:4953\n3#3,8:4962\n3#3,8:4971\n3#3,8:4980\n3#3,8:4989\n3#3,8:4998\n10#4:4943\n10#4:4952\n10#4:4961\n10#4:4970\n10#4:4979\n10#4:4988\n10#4:4997\n10#4:5006\n*S KotlinDebug\n*F\n+ 1 CheckIndex.kt\norg/gnit/lucenekmp/index/CheckIndex$Companion\n*L\n1966#1:4935,8\n1974#1:4944,8\n2063#1:4953,8\n2082#1:4962,8\n2226#1:4971,8\n4179#1:4980,8\n4603#1:4989,8\n4701#1:4998,8\n1966#1:4943\n1974#1:4952\n2063#1:4961\n2082#1:4970\n2226#1:4979\n4179#1:4988\n4603#1:4997\n4701#1:5006\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final void msg(PrintStream out, ByteArrayOutputStream msg) {
            if (out != null) {
                out.println(msg.toString(StandardCharsets.Companion.getUTF_8()));
            }
        }

        private final void msg(PrintStream out, String msg) {
            if (out != null) {
                out.println(msg);
            }
        }

        @NotNull
        public final Status.IndexSortStatus testSort(@NotNull CodecReader reader2, @NotNull Sort sort2, @NotNull PrintStream infoStream, boolean failFast) throws IOException {
            Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
            Intrinsics.checkNotNullParameter((Object)sort2, (String)"sort");
            Intrinsics.checkNotNullParameter((Object)infoStream, (String)"infoStream");
            long startNS = org.gnit.lucenekmp.jdkport.System.INSTANCE.nanoTime();
            Status.IndexSortStatus status = new Status.IndexSortStatus();
            infoStream.print("    test: index sort..........");
            SortField[] fields = sort2.getSort();
            int[] reverseMul = new int[fields.length];
            LeafFieldComparator[] comparators = new LeafFieldComparator[fields.length];
            LeafReaderContext readerContext = new LeafReaderContext(reader2);
            int n = fields.length;
            for (int i = 0; i < n; ++i) {
                reverseMul[i] = fields[i].getReverse() ? -1 : 1;
                comparators[i] = fields[i].getComparator(1, Pruning.NONE).getLeafComparator(readerContext);
            }
            try {
                DocIdSetIterator docIdSetIterator;
                LeafMetaData metaData = reader2.getMetaData();
                FieldInfos fieldInfos = reader2.getFieldInfos();
                if (!(!metaData.getHasBlocks() || fieldInfos.getParentField() != null || metaData.getCreatedVersionMajor() < Version.Companion.getLUCENE_10_0_0().getMajor())) {
                    boolean $i$a$-check-CheckIndex$Companion$testSort$22 = false;
                    String $i$a$-check-CheckIndex$Companion$testSort$22 = "parent field is not set but the index has document blocks and was created with version: " + metaData.getCreatedVersionMajor();
                    throw new IllegalStateException($i$a$-check-CheckIndex$Companion$testSort$22.toString());
                }
                if (metaData.getHasBlocks() && fieldInfos.getParentField() != null) {
                    NumericDocValues numericDocValues = reader2.getNumericDocValues(fieldInfos.getParentField());
                    Intrinsics.checkNotNull((Object)numericDocValues);
                    docIdSetIterator = numericDocValues;
                } else {
                    docIdSetIterator = DocIdSetIterator.Companion.all(reader2.maxDoc());
                }
                DocIdSetIterator iter = docIdSetIterator;
                int prevDoc = iter.nextDoc();
                int nextDoc = 0;
                while (true) {
                    int n2;
                    int it = n2 = iter.nextDoc();
                    boolean bl = false;
                    nextDoc = it;
                    if (n2 == Integer.MAX_VALUE) break;
                    int cmp = 0;
                    int n3 = comparators.length;
                    for (int i = 0; i < n3; ++i) {
                        comparators[i].copy(0, prevDoc);
                        comparators[i].setBottom(0);
                        cmp = reverseMul[i] * comparators[i].compareBottom(nextDoc);
                        if (cmp != 0) break;
                    }
                    if (cmp > 0) {
                        throw new CheckIndexException("segment has indexSort=" + sort2 + " but docID=" + prevDoc + " sorts after docID=" + nextDoc);
                    }
                    prevDoc = nextDoc;
                }
                this.msg(infoStream, "OK [took " + this.nsToSec(org.gnit.lucenekmp.jdkport.System.INSTANCE.nanoTime() - startNS) + " sec]");
            }
            catch (Throwable e) {
                if (failFast) {
                    IOUtils.INSTANCE.rethrowAlways(e);
                    throw new KotlinNothingValueException();
                }
                this.msg(infoStream, "ERROR [" + e.getMessage() + "]");
                status.setError(e);
                ThrowableExtKt.printStackTrace(e, infoStream);
            }
            return status;
        }

        @NotNull
        public final Status.LiveDocStatus testLiveDocs(@NotNull CodecReader reader2, @NotNull PrintStream infoStream, boolean failFast) throws IOException {
            Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
            Intrinsics.checkNotNullParameter((Object)infoStream, (String)"infoStream");
            long startNS = org.gnit.lucenekmp.jdkport.System.INSTANCE.nanoTime();
            Status.LiveDocStatus status = new Status.LiveDocStatus();
            try {
                infoStream.print("    test: check live docs.....");
                int numDocs = reader2.numDocs();
                if (reader2.hasDeletions()) {
                    Bits liveDocs2 = reader2.getLiveDocs();
                    if (liveDocs2 == null) {
                        throw new CheckIndexException("segment should have deletions, but liveDocs is null");
                    }
                    int numLive = 0;
                    int n = liveDocs2.length();
                    for (int j = 0; j < n; ++j) {
                        if (!liveDocs2.get(j)) continue;
                        ++numLive;
                    }
                    if (numLive != numDocs) {
                        throw new CheckIndexException("liveDocs count mismatch: info=" + numDocs + ", vs bits=" + numLive);
                    }
                    status.setNumDeleted(reader2.numDeletedDocs());
                    this.msg(infoStream, "OK [" + status.getNumDeleted() + " deleted docs] [took " + this.nsToSec(org.gnit.lucenekmp.jdkport.System.INSTANCE.nanoTime() - startNS) + " sec]");
                } else {
                    Bits liveDocs3 = reader2.getLiveDocs();
                    if (liveDocs3 != null) {
                        int n = liveDocs3.length();
                        for (int j = 0; j < n; ++j) {
                            if (liveDocs3.get(j)) continue;
                            throw new CheckIndexException("liveDocs mismatch: info says no deletions but doc " + j + " is deleted.");
                        }
                    }
                    this.msg(infoStream, "OK [took " + this.nsToSec(org.gnit.lucenekmp.jdkport.System.INSTANCE.nanoTime() - startNS) + " sec]");
                }
            }
            catch (Throwable e) {
                if (failFast) {
                    IOUtils.INSTANCE.rethrowAlways(e);
                    throw new KotlinNothingValueException();
                }
                this.msg(infoStream, "ERROR [" + e.getMessage() + "]");
                status.setError(e);
                ThrowableExtKt.printStackTrace(e, infoStream);
            }
            return status;
        }

        @NotNull
        public final Status.FieldInfoStatus testFieldInfos(@NotNull CodecReader reader2, @NotNull PrintStream infoStream, boolean failFast) throws IOException {
            Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
            Intrinsics.checkNotNullParameter((Object)infoStream, (String)"infoStream");
            long startNS = org.gnit.lucenekmp.jdkport.System.INSTANCE.nanoTime();
            Status.FieldInfoStatus status = new Status.FieldInfoStatus();
            try {
                infoStream.print("    test: field infos.........");
                FieldInfos fieldInfos = reader2.getFieldInfos();
                for (FieldInfo f : fieldInfos) {
                    f.checkConsistency();
                }
                this.msg(infoStream, "OK [" + fieldInfos.size() + " fields] [took " + this.nsToSec(org.gnit.lucenekmp.jdkport.System.INSTANCE.nanoTime() - startNS) + " sec]");
                status.setTotFields(fieldInfos.size());
            }
            catch (Throwable e) {
                if (failFast) {
                    IOUtils.INSTANCE.rethrowAlways(e);
                    throw new KotlinNothingValueException();
                }
                this.msg(infoStream, "ERROR [" + e.getMessage() + "]");
                status.setError(e);
                ThrowableExtKt.printStackTrace(e, infoStream);
            }
            return status;
        }

        @NotNull
        public final Status.FieldNormStatus testFieldNorms(@NotNull CodecReader reader2, @NotNull PrintStream infoStream, boolean failFast) throws IOException {
            Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
            Intrinsics.checkNotNullParameter((Object)infoStream, (String)"infoStream");
            long startNS = org.gnit.lucenekmp.jdkport.System.INSTANCE.nanoTime();
            Status.FieldNormStatus status = new Status.FieldNormStatus();
            try {
                infoStream.print("    test: field norms.........");
                NormsProducer normsReader2 = reader2.getNormsReader();
                if (normsReader2 != null) {
                    normsReader2 = normsReader2.getMergeInstance();
                }
                for (FieldInfo info : reader2.getFieldInfos()) {
                    if (!info.hasNorms()) continue;
                    String string = info.getName();
                    NormsProducer normsProducer = normsReader2;
                    Intrinsics.checkNotNull((Object)normsProducer);
                    this.checkNumericDocValues(string, normsProducer.getNorms(info), normsReader2.getNorms(info));
                    status.setTotFields(status.getTotFields() + 1L);
                    status.getTotFields();
                }
                this.msg(infoStream, "OK [" + status.getTotFields() + " fields] [took " + this.nsToSec(org.gnit.lucenekmp.jdkport.System.INSTANCE.nanoTime() - startNS) + " sec]");
            }
            catch (Throwable e) {
                if (failFast) {
                    IOUtils.INSTANCE.rethrowAlways(e);
                    throw new KotlinNothingValueException();
                }
                this.msg(infoStream, "ERROR [" + e.getMessage() + "]");
                status.setError(e);
                ThrowableExtKt.printStackTrace(e, infoStream);
            }
            return status;
        }

        private final Status.TermIndexStatus checkFields(Fields fields, Bits liveDocs2, int maxDoc, FieldInfos fieldInfos, NormsProducer normsProducer, boolean doPrint, boolean isVectors, PrintStream infoStream, boolean verbose, int level) throws IOException {
            long startNS = doPrint ? org.gnit.lucenekmp.jdkport.System.INSTANCE.nanoTime() : 0L;
            Status.TermIndexStatus status = new Status.TermIndexStatus();
            int computedFieldCount = 0;
            PostingsEnum postings = null;
            String lastField = null;
            for (String field : fields) {
                BytesRef startTerm;
                int seekCount;
                Object stats;
                BytesRef term;
                boolean expectedHasFreqs;
                if (lastField != null && field.compareTo(lastField) <= 0) {
                    throw new CheckIndexException("fields out of order: lastField=" + lastField + " field=" + field);
                }
                lastField = field;
                FieldInfo fieldInfo = fieldInfos.fieldInfo(field);
                if (fieldInfo == null) {
                    throw new CheckIndexException("fieldsEnum inconsistent with fieldInfos, no fieldInfos for: " + field);
                }
                if (fieldInfo.getIndexOptions() == IndexOptions.NONE) {
                    throw new CheckIndexException("fieldsEnum inconsistent with fieldInfos, isIndexed == false for: " + field);
                }
                ++computedFieldCount;
                Terms terms = fields.terms(field);
                if (terms == null) continue;
                if (terms.getDocCount() > maxDoc) {
                    throw new CheckIndexException("docCount > maxDoc for field: " + field + ", docCount=" + terms.getDocCount() + ", maxDoc=" + maxDoc);
                }
                boolean hasFreqs = terms.hasFreqs();
                boolean hasPositions = terms.hasPositions();
                boolean hasPayloads = terms.hasPayloads();
                boolean hasOffsets = terms.hasOffsets();
                BytesRef maxTerm = null;
                BytesRef minTerm = null;
                if (isVectors) {
                    maxTerm = null;
                    minTerm = null;
                } else {
                    boolean $i$f$assert;
                    boolean condition$iv;
                    BytesRef bb = terms.getMin();
                    if (bb != null) {
                        condition$iv = bb.isValid();
                        $i$f$assert = false;
                        if (_Assertions.ENABLED && !condition$iv) {
                            boolean $i$a$-assert-AssertKt$assert$22 = false;
                            String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
                            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
                        }
                        minTerm = BytesRef.Companion.deepCopyOf(bb);
                    } else {
                        minTerm = null;
                    }
                    bb = terms.getMax();
                    if (bb != null) {
                        condition$iv = bb.isValid();
                        $i$f$assert = false;
                        if (_Assertions.ENABLED && !condition$iv) {
                            boolean bl = false;
                            String string = "assertion failed";
                            throw new AssertionError((Object)string);
                        }
                        maxTerm = BytesRef.Companion.deepCopyOf(bb);
                        if (minTerm == null) {
                            throw new CheckIndexException("field \"" + field + "\" has null minTerm but non-null maxTerm");
                        }
                    } else {
                        maxTerm = null;
                        if (minTerm != null) {
                            throw new CheckIndexException("field \"" + field + "\" has non-null minTerm but null maxTerm");
                        }
                    }
                }
                boolean bl = expectedHasFreqs = isVectors || fieldInfo.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS) >= 0;
                if (hasFreqs != expectedHasFreqs) {
                    throw new CheckIndexException("field \"" + field + "\" should have hasFreqs=" + expectedHasFreqs + " but got " + hasFreqs);
                }
                if (!isVectors) {
                    boolean expectedHasOffsets;
                    boolean expectedHasPositions;
                    boolean bl2 = expectedHasPositions = fieldInfo.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
                    if (hasPositions != expectedHasPositions) {
                        throw new CheckIndexException("field \"" + field + "\" should have hasPositions=" + expectedHasPositions + " but got " + hasPositions);
                    }
                    boolean expectedHasPayloads = fieldInfo.hasPayloads();
                    if (hasPayloads != expectedHasPayloads) {
                        throw new CheckIndexException("field \"" + field + "\" should have hasPayloads=" + expectedHasPayloads + " but got " + hasPayloads);
                    }
                    boolean bl3 = expectedHasOffsets = fieldInfo.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
                    if (hasOffsets != expectedHasOffsets) {
                        throw new CheckIndexException("field \"" + field + "\" should have hasOffsets=" + expectedHasOffsets + " but got " + hasOffsets);
                    }
                }
                TermsEnum termsEnum = terms.iterator();
                boolean hasOrd = true;
                long termCountStart = status.getDelTermCount() + status.getTermCount();
                BytesRefBuilder lastTerm = null;
                long sumTotalTermFreq = 0L;
                long sumDocFreq = 0L;
                FixedBitSet visitedDocs = new FixedBitSet(maxDoc);
                block3: while ((term = termsEnum.next()) != null) {
                    int doc;
                    int doc2;
                    int docFreq;
                    boolean condition$iv = term.isValid();
                    boolean $i$f$assert = false;
                    if (_Assertions.ENABLED && !condition$iv) {
                        boolean $i$a$-assert-AssertKt$assert$32 = false;
                        String $i$a$-assert-AssertKt$assert$32 = "assertion failed";
                        throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$32);
                    }
                    if (lastTerm == null) {
                        lastTerm = new BytesRefBuilder();
                        lastTerm.copyBytes(term);
                    } else {
                        if (lastTerm.get().compareTo(term) >= 0) {
                            throw new CheckIndexException("terms out of order: lastTerm=" + lastTerm.get() + " term=" + term);
                        }
                        lastTerm.copyBytes(term);
                    }
                    if (!isVectors) {
                        if (minTerm == null) {
                            condition$iv = maxTerm == null;
                            $i$f$assert = false;
                            if (_Assertions.ENABLED && !condition$iv) {
                                boolean $i$a$-assert-AssertKt$assert$42 = false;
                                String $i$a$-assert-AssertKt$assert$42 = "assertion failed";
                                throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$42);
                            }
                            throw new CheckIndexException("field=\"" + field + "\": invalid term: term=" + term + ", minTerm=" + minTerm);
                        }
                        if (term.compareTo(minTerm) < 0) {
                            throw new CheckIndexException("field=\"" + field + "\": invalid term: term=" + term + ", minTerm=" + minTerm);
                        }
                        BytesRef bytesRef = maxTerm;
                        Intrinsics.checkNotNull((Object)bytesRef);
                        if (term.compareTo(bytesRef) > 0) {
                            throw new CheckIndexException("field=\"" + field + "\": invalid term: term=" + term + ", maxTerm=" + maxTerm);
                        }
                    }
                    if ((docFreq = termsEnum.docFreq()) <= 0) {
                        throw new CheckIndexException("docfreq: " + docFreq + " is out of bounds");
                    }
                    sumDocFreq += (long)docFreq;
                    postings = termsEnum.postings(postings, PostingsEnum.Companion.getALL());
                    if (!hasFreqs && termsEnum.totalTermFreq() != (long)termsEnum.docFreq()) {
                        throw new CheckIndexException("field \"" + field + "\" hasFreqs is false, but TermsEnum.totalTermFreq()=" + termsEnum.totalTermFreq() + " (should be " + termsEnum.docFreq() + ")");
                    }
                    if (hasOrd) {
                        long ordExpected;
                        long ord = -1L;
                        try {
                            ord = termsEnum.ord();
                        }
                        catch (UnsupportedOperationException uoe) {
                            hasOrd = false;
                        }
                        if (hasOrd && ord != (ordExpected = status.getDelTermCount() + status.getTermCount() - termCountStart)) {
                            throw new CheckIndexException("ord mismatch: TermsEnum has ord=" + ord + " vs actual=" + ordExpected);
                        }
                    }
                    int lastDoc = -1;
                    int docCount = 0;
                    boolean hasNonDeletedDocs = false;
                    long totalTermFreq = 0L;
                    while ((doc2 = postings.nextDoc()) != Integer.MAX_VALUE) {
                        visitedDocs.set(doc2);
                        int freq = postings.freq();
                        if (freq <= 0) {
                            throw new CheckIndexException("term " + term + ": doc " + doc2 + ": freq " + freq + " is out of bounds");
                        }
                        if (!hasFreqs && postings.freq() != 1) {
                            throw new CheckIndexException("term " + term + ": doc " + doc2 + ": freq " + freq + " != 1 when Terms.hasFreqs() is false");
                        }
                        totalTermFreq += (long)freq;
                        if (liveDocs2 == null || liveDocs2.get(doc2)) {
                            hasNonDeletedDocs = true;
                            long l = status.getTotFreq();
                            status.setTotFreq(l + 1L);
                            if (freq >= 0) {
                                status.setTotPos(status.getTotPos() + (long)freq);
                            }
                        }
                        ++docCount;
                        if (doc2 <= lastDoc) {
                            throw new CheckIndexException("term " + term + ": doc " + doc2 + " <= lastDoc " + lastDoc);
                        }
                        if (doc2 >= maxDoc) {
                            throw new CheckIndexException("term " + term + ": doc " + doc2 + " >= maxDoc " + maxDoc);
                        }
                        lastDoc = doc2;
                        int lastPos = -1;
                        int lastOffset = 0;
                        if (!hasPositions) continue;
                        for (int j = 0; j < freq; ++j) {
                            int pos = postings.nextPosition();
                            if (pos < 0) {
                                throw new CheckIndexException("term " + term + ": doc " + doc2 + ": pos " + pos + " is out of bounds");
                            }
                            if (pos > 0x7FFFFF7F) {
                                throw new CheckIndexException("term " + term + ": doc " + doc2 + ": pos " + pos + " > IndexWriter.MAX_POSITION=2147483519");
                            }
                            if (pos < lastPos) {
                                throw new CheckIndexException("term " + term + ": doc " + doc2 + ": pos " + pos + " < lastPos " + lastPos);
                            }
                            lastPos = pos;
                            BytesRef payload = postings.getPayload();
                            if (payload != null) {
                                boolean condition$iv2 = payload.isValid();
                                boolean $i$f$assert2 = false;
                                if (_Assertions.ENABLED && !condition$iv2) {
                                    boolean $i$a$-assert-AssertKt$assert$52 = false;
                                    String $i$a$-assert-AssertKt$assert$52 = "assertion failed";
                                    throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$52);
                                }
                            }
                            if (payload != null && payload.getLength() < 1) {
                                throw new CheckIndexException("term " + term + ": doc " + doc2 + ": pos " + pos + " payload length is out of bounds " + payload.getLength());
                            }
                            if (!hasOffsets) continue;
                            int startOffset = postings.startOffset();
                            int endOffset = postings.endOffset();
                            if (startOffset < 0) {
                                throw new CheckIndexException("term " + term + ": doc " + doc2 + ": pos " + pos + ": startOffset " + startOffset + " is out of bounds");
                            }
                            if (startOffset < lastOffset) {
                                throw new CheckIndexException("term " + term + ": doc " + doc2 + ": pos " + pos + ": startOffset " + startOffset + " < lastStartOffset " + lastOffset + "; consider using the FixBrokenOffsets tool in Lucene's backward-codecs module to correct your index");
                            }
                            if (endOffset < 0) {
                                throw new CheckIndexException("term " + term + ": doc " + doc2 + ": pos " + pos + ": endOffset " + endOffset + " is out of bounds");
                            }
                            if (endOffset < startOffset) {
                                throw new CheckIndexException("term " + term + ": doc " + doc2 + ": pos " + pos + ": endOffset " + endOffset + " < startOffset " + startOffset);
                            }
                            lastOffset = startOffset;
                        }
                    }
                    if (hasNonDeletedDocs) {
                        doc2 = status.getTermCount();
                        status.setTermCount(doc2 + 1L);
                        v4 = doc2;
                    } else {
                        doc2 = status.getDelTermCount();
                        status.setDelTermCount(doc2 + 1L);
                        v4 = doc2;
                    }
                    long totalTermFreq2 = termsEnum.totalTermFreq();
                    if (docCount != docFreq) {
                        throw new CheckIndexException("term " + term + " docFreq=" + docFreq + " != tot docs w/o deletions " + docCount);
                    }
                    if (docFreq > terms.getDocCount()) {
                        throw new CheckIndexException("term " + term + " docFreq=" + docFreq + " > docCount=" + terms.getDocCount());
                    }
                    if (totalTermFreq2 <= 0L) {
                        throw new CheckIndexException("totalTermFreq: " + totalTermFreq2 + " is out of bounds");
                    }
                    sumTotalTermFreq += totalTermFreq;
                    if (totalTermFreq != totalTermFreq2) {
                        throw new CheckIndexException("term " + term + " totalTermFreq=" + totalTermFreq2 + " != recomputed totalTermFreq=" + totalTermFreq);
                    }
                    if (totalTermFreq2 < (long)docFreq) {
                        throw new CheckIndexException("totalTermFreq: " + totalTermFreq2 + " is out of bounds, docFreq=" + docFreq);
                    }
                    if (hasPositions) {
                        for (idx = 0; idx < 7; ++idx) {
                            skipDocID = (int)((long)(idx + 1) * (long)maxDoc / (long)8);
                            docID = (postings = termsEnum.postings(postings, PostingsEnum.Companion.getALL())).advance(skipDocID);
                            if (docID == Integer.MAX_VALUE) break;
                            if (docID < skipDocID) {
                                throw new CheckIndexException("term " + term + ": advance(docID=" + skipDocID + ") returned docID=" + docID);
                            }
                            int freq = postings.freq();
                            if (freq <= 0) {
                                throw new CheckIndexException("termFreq " + freq + " is out of bounds");
                            }
                            int lastPosition = -1;
                            int lastOffset = 0;
                            for (int posUpto = 0; posUpto < freq; ++posUpto) {
                                int pos = postings.nextPosition();
                                if (pos < 0) {
                                    throw new CheckIndexException("position " + pos + " is out of bounds");
                                }
                                if (pos < lastPosition) {
                                    throw new CheckIndexException("position " + pos + " is < lastPosition " + lastPosition);
                                }
                                lastPosition = pos;
                                if (!hasOffsets) continue;
                                int startOffset = postings.startOffset();
                                int endOffset = postings.endOffset();
                                if (!isVectors) {
                                    if (startOffset < 0) {
                                        throw new CheckIndexException("term " + term + ": doc " + docID + ": pos " + pos + ": startOffset " + startOffset + " is out of bounds");
                                    }
                                    if (startOffset < lastOffset) {
                                        throw new CheckIndexException("term " + term + ": doc " + docID + ": pos " + pos + ": startOffset " + startOffset + " < lastStartOffset " + lastOffset);
                                    }
                                    if (endOffset < 0) {
                                        throw new CheckIndexException("term " + term + ": doc " + docID + ": pos " + pos + ": endOffset " + endOffset + " is out of bounds");
                                    }
                                    if (endOffset < startOffset) {
                                        throw new CheckIndexException("term " + term + ": doc " + docID + ": pos " + pos + ": endOffset " + endOffset + " < startOffset " + startOffset);
                                    }
                                }
                                lastOffset = startOffset;
                            }
                            int nextDocID = postings.nextDoc();
                            if (nextDocID == Integer.MAX_VALUE) break;
                            if (nextDocID <= docID) {
                                throw new CheckIndexException("term " + term + ": advance(docID=" + skipDocID + "), then .next() returned docID=" + nextDocID + " vs prev docID=" + docID);
                            }
                            if (!isVectors) {
                                continue;
                            }
                            break;
                        }
                    } else {
                        for (idx = 0; idx < 7; ++idx) {
                            skipDocID = (int)((long)(idx + 1) * (long)maxDoc / (long)8);
                            docID = (postings = termsEnum.postings(postings, 0)).advance(skipDocID);
                            if (docID == Integer.MAX_VALUE) break;
                            if (docID < skipDocID) {
                                throw new CheckIndexException("term " + term + ": advance(docID=" + skipDocID + ") returned docID=" + docID);
                            }
                            int nextDocID = postings.nextDoc();
                            if (nextDocID == Integer.MAX_VALUE) break;
                            if (nextDocID <= docID) {
                                throw new CheckIndexException("term " + term + ": advance(docID=" + skipDocID + "), then .next() returned docID=" + nextDocID + " vs prev docID=" + docID);
                            }
                            if (!isVectors) {
                                continue;
                            }
                            break;
                        }
                    }
                    if (level < 3 && docFreq <= 1024 && (status.getTermCount() + status.getDelTermCount()) % (long)1024 != 0L) continue;
                    if (level >= 3) {
                        int max = -1;
                        int maxFreq = 0;
                        ImpactsEnum impactsEnum = termsEnum.impacts(PostingsEnum.Companion.getFREQS());
                        postings = termsEnum.postings(postings, PostingsEnum.Companion.getFREQS());
                        doc = impactsEnum.nextDoc();
                        while (true) {
                            if (postings.nextDoc() != doc) {
                                throw new CheckIndexException("Wrong next doc: " + doc + ", expected " + postings.docID());
                            }
                            if (doc == Integer.MAX_VALUE) break;
                            if (postings.freq() != impactsEnum.freq()) {
                                throw new CheckIndexException("Wrong freq, expected " + postings.freq() + ", but got " + impactsEnum.freq());
                            }
                            if (doc > max) {
                                impactsEnum.advanceShallow(doc);
                                Impacts impacts2 = impactsEnum.getImpacts();
                                this.checkImpacts(impacts2, doc);
                                max = impacts2.getDocIdUpTo(0);
                                List<Impact> impacts0 = impacts2.getImpacts(0);
                                maxFreq = impacts0.get(impacts0.size() - 1).getFreq();
                            }
                            if (impactsEnum.freq() > maxFreq) {
                                throw new CheckIndexException("freq " + impactsEnum.freq() + " is greater than the max freq according to impacts " + maxFreq);
                            }
                            doc = impactsEnum.nextDoc();
                        }
                    }
                    ImpactsEnum impactsEnum = termsEnum.impacts(PostingsEnum.Companion.getFREQS());
                    postings = termsEnum.postings(postings, PostingsEnum.Companion.getFREQS());
                    int max = -1;
                    int maxFreq = 0;
                    block10: do {
                        List<Impact> perLevelImpacts;
                        int impactsLevel;
                        int n;
                        Impacts impacts3;
                        int delta;
                        doc = impactsEnum.docID();
                        boolean advance = false;
                        int target = 0;
                        if ((field.hashCode() + doc & 1) == 1) {
                            advance = false;
                            target = doc + 1;
                        } else {
                            advance = true;
                            delta = Math.min(1 + (31 * field.hashCode() + doc & 0x1FF), Integer.MAX_VALUE - doc);
                            target = impactsEnum.docID() + delta;
                        }
                        if (target > max && target % 2 == 1) {
                            delta = Math.min(31 * field.hashCode() + target & 0x1FF, Integer.MAX_VALUE - target);
                            max = target + delta;
                            impactsEnum.advanceShallow(target);
                            impacts3 = impactsEnum.getImpacts();
                            this.checkImpacts(impacts3, doc);
                            maxFreq = Integer.MAX_VALUE;
                            n = impacts3.numLevels();
                            for (impactsLevel = 0; impactsLevel < n; ++impactsLevel) {
                                if (impacts3.getDocIdUpTo(impactsLevel) < max) continue;
                                perLevelImpacts = impacts3.getImpacts(impactsLevel);
                                maxFreq = perLevelImpacts.get(perLevelImpacts.size() - 1).getFreq();
                                break;
                            }
                        }
                        int n2 = doc = advance ? impactsEnum.advance(target) : impactsEnum.nextDoc();
                        if (postings.advance(target) != doc) {
                            throw new CheckIndexException("Impacts do not advance to the same document as postings for target " + target + ", postings: " + postings.docID() + ", impacts: " + doc);
                        }
                        if (doc == Integer.MAX_VALUE) continue block3;
                        if (postings.freq() != impactsEnum.freq()) {
                            throw new CheckIndexException("Wrong freq, expected " + postings.freq() + ", but got " + impactsEnum.freq());
                        }
                        if (doc < max) continue;
                        delta = Math.min(31 * field.hashCode() + target & 0x1FF, Integer.MAX_VALUE - doc);
                        max = doc + delta;
                        impactsEnum.advanceShallow(doc);
                        impacts3 = impactsEnum.getImpacts();
                        this.checkImpacts(impacts3, doc);
                        maxFreq = Integer.MAX_VALUE;
                        n = impacts3.numLevels();
                        for (impactsLevel = 0; impactsLevel < n; ++impactsLevel) {
                            if (impacts3.getDocIdUpTo(impactsLevel) < max) continue;
                            perLevelImpacts = impacts3.getImpacts(impactsLevel);
                            maxFreq = perLevelImpacts.get(perLevelImpacts.size() - 1).getFreq();
                            continue block10;
                        }
                    } while (impactsEnum.freq() <= maxFreq);
                    throw new CheckIndexException("Term frequency " + impactsEnum.freq() + " is greater than the max freq according to impacts " + maxFreq);
                }
                if (minTerm != null && status.getTermCount() + status.getDelTermCount() == 0L) {
                    throw new CheckIndexException("field=\"" + field + "\": minTerm is non-null yet we saw no terms: " + minTerm);
                }
                Terms fieldTerms = fields.terms(field);
                if (fieldTerms == null) continue;
                long fieldTermCount = status.getDelTermCount() + status.getTermCount() - termCountStart;
                if (fieldTerms.getStats() == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                if (status.getBlockTreeStats() == null) {
                    status.setBlockTreeStats(new HashMap());
                }
                Map<String, Object> map2 = status.getBlockTreeStats();
                Intrinsics.checkNotNull(map2);
                map2.put(field, stats);
                Terms terms2 = fields.terms(field);
                Intrinsics.checkNotNull((Object)terms2);
                long actualSumDocFreq = terms2.getSumDocFreq();
                if (sumDocFreq != actualSumDocFreq) {
                    throw new CheckIndexException("sumDocFreq for field " + field + "=" + actualSumDocFreq + " != recomputed sumDocFreq=" + sumDocFreq);
                }
                Terms terms3 = fields.terms(field);
                Intrinsics.checkNotNull((Object)terms3);
                long actualSumTotalTermFreq = terms3.getSumTotalTermFreq();
                if (sumTotalTermFreq != actualSumTotalTermFreq) {
                    throw new CheckIndexException("sumTotalTermFreq for field " + field + "=" + actualSumTotalTermFreq + " != recomputed sumTotalTermFreq=" + sumTotalTermFreq);
                }
                if (!hasFreqs && sumTotalTermFreq != sumDocFreq) {
                    throw new CheckIndexException("sumTotalTermFreq for field " + field + " should be " + sumDocFreq + ", got sumTotalTermFreq=" + sumTotalTermFreq);
                }
                int v = fieldTerms.getDocCount();
                if (visitedDocs.cardinality() != v) {
                    throw new CheckIndexException("docCount for field " + field + "=" + v + " != recomputed docCount=" + visitedDocs.cardinality());
                }
                if (fieldInfo.hasNorms() && !isVectors) {
                    NormsProducer normsProducer2 = normsProducer;
                    Intrinsics.checkNotNull((Object)normsProducer2);
                    NumericDocValues norms = normsProducer2.getNorms(fieldInfo);
                    int actualCount = 0;
                    Companion $this$checkFields_u24lambda_u242 = this;
                    boolean bl4 = false;
                    int doc = norms.nextDoc();
                    while (doc != Integer.MAX_VALUE) {
                        if (liveDocs2 != null && !liveDocs2.get(doc)) {
                            doc = norms.nextDoc();
                            continue;
                        }
                        long norm = norms.longValue();
                        if (norm != 0L) {
                            ++actualCount;
                            if (!visitedDocs.get(doc)) {
                                throw new CheckIndexException("Document " + doc + " doesn't have terms according to postings but has a norm value that is not zero: " + LongExtKt.toUnsignedString(LongCompanionObject.INSTANCE, norm));
                            }
                        } else if (visitedDocs.get(doc)) {
                            throw new CheckIndexException("Document " + doc + " has terms according to postings but its norm value is 0, which may only be used on documents that have no terms");
                        }
                        doc = norms.nextDoc();
                    }
                    int expectedCount = 0;
                    int doc3 = visitedDocs.nextSetBit(0);
                    while (doc3 != Integer.MAX_VALUE) {
                        if (liveDocs2 != null && !liveDocs2.get(doc3)) {
                            doc3 = doc3 + 1 >= visitedDocs.length() ? Integer.MAX_VALUE : visitedDocs.nextSetBit(doc3 + 1);
                            continue;
                        }
                        ++expectedCount;
                        doc3 = doc3 + 1 >= visitedDocs.length() ? Integer.MAX_VALUE : visitedDocs.nextSetBit(doc3 + 1);
                    }
                    if (expectedCount != actualCount) {
                        throw new CheckIndexException("actual norm count: " + actualCount + " but expected: " + expectedCount);
                    }
                }
                if (lastTerm != null) {
                    if (termsEnum.seekCeil(lastTerm.get()) != TermsEnum.SeekStatus.FOUND) {
                        throw new CheckIndexException("seek to last term " + lastTerm.get() + " failed");
                    }
                    if (!Intrinsics.areEqual((Object)termsEnum.term(), (Object)lastTerm.get())) {
                        throw new CheckIndexException("seek to last term " + lastTerm.get() + " returned FOUND but seeked to the wrong term " + termsEnum.term());
                    }
                    int expectedDocFreq = termsEnum.docFreq();
                    PostingsEnum d = termsEnum.postings(null, 0);
                    int docFreq = 0;
                    while (d.nextDoc() != Integer.MAX_VALUE) {
                        ++docFreq;
                    }
                    if (docFreq != expectedDocFreq) {
                        throw new CheckIndexException("docFreq for last term " + lastTerm.get() + "=" + expectedDocFreq + " != recomputed docFreq=" + docFreq);
                    }
                }
                long termCount = -1L;
                if (fieldTermCount > 0L) {
                    Terms terms4 = fields.terms(field);
                    Intrinsics.checkNotNull((Object)terms4);
                    termCount = terms4.size();
                    if (termCount != -1L && termCount != fieldTermCount) {
                        throw new CheckIndexException("termCount mismatch " + termCount + " vs " + fieldTermCount);
                    }
                }
                if (hasOrd && status.getTermCount() - termCountStart > 0L && (seekCount = (int)Math.min(10000L, termCount)) > 0) {
                    int i;
                    BytesRef[] seekTerms = new BytesRef[seekCount];
                    for (i = seekCount - 1; -1 < i; --i) {
                        long ord = (long)i * (termCount / (long)seekCount);
                        termsEnum.seekExact(ord);
                        long actualOrd = termsEnum.ord();
                        if (actualOrd != ord) {
                            throw new CheckIndexException("seek to ord " + ord + " returned ord " + actualOrd);
                        }
                        BytesRef bytesRef = termsEnum.term();
                        Intrinsics.checkNotNull((Object)bytesRef);
                        seekTerms[i] = BytesRef.Companion.deepCopyOf(bytesRef);
                    }
                    for (i = seekCount - 1; -1 < i; --i) {
                        if (termsEnum.seekCeil(seekTerms[i]) != TermsEnum.SeekStatus.FOUND) {
                            throw new CheckIndexException("seek to existing term " + seekTerms[i] + " failed");
                        }
                        if (!Intrinsics.areEqual((Object)termsEnum.term(), (Object)seekTerms[i])) {
                            throw new CheckIndexException("seek to existing term " + seekTerms[i] + " returned FOUND but seeked to the wrong term " + termsEnum.term());
                        }
                        if ((postings = termsEnum.postings(postings, 0)) != null) continue;
                        throw new CheckIndexException("null DocsEnum from to existing term " + seekTerms[i]);
                    }
                }
                Object[] seekTerms = new Automaton[]{Automata.INSTANCE.makeAnyBinary(), Automata.INSTANCE.makeCharRange(97, 101), Automata.INSTANCE.makeAnyBinary()};
                Automaton automaton = Operations.INSTANCE.concatenate(CollectionsKt.mutableListOf((Object[])seekTerms));
                BytesRef bytesRef = startTerm = null;
                Intrinsics.checkNotNull(bytesRef);
                this.checkTermsIntersect(terms, automaton, bytesRef);
                startTerm = new BytesRef();
                this.checkTermsIntersect(terms, automaton, startTerm);
                automaton = Automata.INSTANCE.makeNonEmptyBinary();
                byte[] byArray = new byte[]{108};
                startTerm = new BytesRef(byArray);
                this.checkTermsIntersect(terms, automaton, startTerm);
                byArray = new byte[]{-1, -1, -1, -1};
                startTerm = new BytesRef(byArray);
                this.checkTermsIntersect(terms, automaton, startTerm);
            }
            int fieldCount = fields.size();
            if (fieldCount != -1) {
                if (fieldCount < 0) {
                    throw new CheckIndexException("invalid fieldCount: " + fieldCount);
                }
                if (fieldCount != computedFieldCount) {
                    throw new CheckIndexException("fieldCount mismatch " + fieldCount + " vs recomputed field count " + computedFieldCount);
                }
            }
            if (doPrint) {
                this.msg(infoStream, "OK [" + status.getTermCount() + " terms; " + status.getTotFreq() + " terms/docs pairs; " + status.getTotPos() + " tokens] [took " + this.nsToSec(org.gnit.lucenekmp.jdkport.System.INSTANCE.nanoTime() - startNS) + " sec]");
            }
            if (verbose && status.getBlockTreeStats() != null && infoStream != null && status.getTermCount() > 0L) {
                Map<String, Object> map3 = status.getBlockTreeStats();
                Intrinsics.checkNotNull(map3);
                for (Map.Entry<String, Object> ent : map3.entrySet()) {
                    infoStream.println("      field \"" + ent.getKey() + "\":");
                    infoStream.println("      " + StringsKt.replace$default((String)ent.getValue().toString(), (String)"\n", (String)"\n      ", (boolean)false, (int)4, null));
                }
            }
            return status;
        }

        private final void checkTermsIntersect(Terms terms, Automaton automaton, BytesRef startTerm) throws IOException {
            BytesRef filteredTerm;
            Automaton automaton2 = automaton;
            TermsEnum allTerms = terms.iterator();
            automaton2 = Operations.INSTANCE.determinize(automaton2, 10000);
            CompiledAutomaton compiledAutomaton = new CompiledAutomaton(automaton2, false, true, true);
            ByteRunAutomaton runAutomaton = new ByteRunAutomaton(automaton2, true);
            TermsEnum filteredTerms = terms.intersect(compiledAutomaton, startTerm);
            BytesRef term = null;
            if (startTerm != null) {
                switch (WhenMappings.$EnumSwitchMapping$0[allTerms.seekCeil(startTerm).ordinal()]) {
                    case 1: {
                        v0 = allTerms.next();
                        break;
                    }
                    case 2: {
                        v0 = allTerms.term();
                        break;
                    }
                    case 3: {
                        v0 = null;
                        break;
                    }
                    default: {
                        v0 = null;
                        break;
                    }
                }
            } else {
                v0 = term = allTerms.next();
            }
            while (term != null) {
                if (runAutomaton.run(term.getBytes(), term.getOffset(), term.getLength()) && !Intrinsics.areEqual((Object)term, (Object)(filteredTerm = filteredTerms.next()))) {
                    throw new CheckIndexException("Expected next filtered term: " + term + ", but got " + filteredTerm);
                }
                term = allTerms.next();
            }
            filteredTerm = filteredTerms.next();
            if (filteredTerm != null) {
                throw new CheckIndexException("Expected exhausted TermsEnum, but got " + filteredTerm);
            }
        }

        public final void checkImpacts(@NotNull Impacts impacts2, int lastTarget) {
            int impactsLevel;
            Intrinsics.checkNotNullParameter((Object)impacts2, (String)"impacts");
            int numLevels = impacts2.numLevels();
            if (numLevels < 1) {
                throw new CheckIndexException("The number of impact levels must be >= 1, got " + numLevels);
            }
            int docIdUpTo0 = impacts2.getDocIdUpTo(0);
            if (docIdUpTo0 < lastTarget) {
                throw new CheckIndexException("getDocIdUpTo returned " + docIdUpTo0 + " on level 0, which is less than the target " + lastTarget);
            }
            for (impactsLevel = 1; impactsLevel < numLevels; ++impactsLevel) {
                int previousDocIdUpTo;
                int docIdUpTo = impacts2.getDocIdUpTo(impactsLevel);
                if (docIdUpTo >= (previousDocIdUpTo = impacts2.getDocIdUpTo(impactsLevel - 1))) continue;
                throw new CheckIndexException("Decreasing return for getDocIdUpTo: level " + (impactsLevel - 1) + " returned " + previousDocIdUpTo + " but level " + impactsLevel + " returned " + docIdUpTo + " for target " + lastTarget);
            }
            for (impactsLevel = 0; impactsLevel < numLevels; ++impactsLevel) {
                Impact impact;
                List<Impact> perLevelImpacts = impacts2.getImpacts(impactsLevel);
                if (perLevelImpacts.isEmpty()) {
                    throw new CheckIndexException("Got empty list of impacts on level " + impactsLevel);
                }
                Impact first = perLevelImpacts.get(0);
                if (first.getFreq() < 1) {
                    throw new CheckIndexException("First impact had a freq <= 0: " + first);
                }
                if (first.getNorm() == 0L) {
                    throw new CheckIndexException("First impact had a norm == 0: " + first);
                }
                Impact previous = first;
                int n = perLevelImpacts.size();
                for (int i = 1; i < n; ++i) {
                    impact = perLevelImpacts.get(i);
                    if (impact.getFreq() > previous.getFreq()) {
                        if (LongExtKt.compareUnsigned(LongCompanionObject.INSTANCE, impact.getNorm(), previous.getNorm()) > 0) continue;
                    }
                    throw new CheckIndexException("Impacts are not ordered or contain dups, got " + previous + " then " + impact);
                }
                if (impactsLevel <= 0) continue;
                Iterator<Impact> previousIt = impacts2.getImpacts(impactsLevel - 1).iterator();
                previous = previousIt.next();
                Iterator<Impact> it = perLevelImpacts.iterator();
                impact = it.next();
                while (previousIt.hasNext()) {
                    previous = previousIt.next();
                    if (previous.getFreq() <= impact.getFreq() && LongExtKt.compareUnsigned(LongCompanionObject.INSTANCE, previous.getNorm(), impact.getNorm()) >= 0) continue;
                    if (!it.hasNext()) {
                        throw new CheckIndexException("Found impact " + previous + " on level " + (impactsLevel - 1) + " but no impact on level " + impactsLevel + " triggers a better score: " + perLevelImpacts);
                    }
                    impact = it.next();
                }
            }
        }

        @NotNull
        public final Status.TermIndexStatus testPostings(@NotNull CodecReader reader2, @NotNull PrintStream infoStream, boolean verbose, int level, boolean failFast) throws IOException {
            Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
            Intrinsics.checkNotNullParameter((Object)infoStream, (String)"infoStream");
            Status.TermIndexStatus status = null;
            int maxDoc = reader2.maxDoc();
            try {
                infoStream.print("    test: terms, freq, prox...");
                FieldsProducer fields = reader2.getPostingsReader();
                if (fields == null) {
                    return new Status.TermIndexStatus();
                }
                fields = fields.getMergeInstance();
                FieldInfos fieldInfos = reader2.getFieldInfos();
                NormsProducer normsProducer = reader2.getNormsReader();
                if (normsProducer != null) {
                    normsProducer = normsProducer.getMergeInstance();
                }
                Fields fields2 = fields;
                Bits bits = reader2.getLiveDocs();
                Intrinsics.checkNotNull((Object)bits);
                NormsProducer normsProducer2 = normsProducer;
                Intrinsics.checkNotNull((Object)normsProducer2);
                status = this.checkFields(fields2, bits, maxDoc, fieldInfos, normsProducer2, true, false, infoStream, verbose, level);
            }
            catch (Throwable e) {
                if (failFast) {
                    IOUtils.INSTANCE.rethrowAlways(e);
                    throw new KotlinNothingValueException();
                }
                this.msg(infoStream, "ERROR: " + e);
                status = new Status.TermIndexStatus();
                status.setError(e);
                ThrowableExtKt.printStackTrace(e, infoStream);
            }
            return status;
        }

        public static /* synthetic */ Status.TermIndexStatus testPostings$default(Companion companion, CodecReader codecReader, PrintStream printStream, boolean bl, int n, boolean bl2, int n2, Object object) throws IOException {
            if ((n2 & 4) != 0) {
                bl = false;
            }
            if ((n2 & 8) != 0) {
                n = 3;
            }
            if ((n2 & 0x10) != 0) {
                bl2 = false;
            }
            return companion.testPostings(codecReader, printStream, bl, n, bl2);
        }

        @NotNull
        public final Status.PointsStatus testPoints(@NotNull CodecReader reader2, @NotNull PrintStream infoStream, boolean failFast) throws IOException {
            Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
            Intrinsics.checkNotNullParameter((Object)infoStream, (String)"infoStream");
            infoStream.print("    test: points..............");
            long startNS = org.gnit.lucenekmp.jdkport.System.INSTANCE.nanoTime();
            FieldInfos fieldInfos = reader2.getFieldInfos();
            Status.PointsStatus status = new Status.PointsStatus();
            try {
                if (fieldInfos.hasPointValues()) {
                    PointsReader pointsReader2 = reader2.getPointsReader();
                    if (pointsReader2 == null) {
                        throw new CheckIndexException("there are fields with points, but reader.@ointsReader is null");
                    }
                    for (FieldInfo fieldInfo : fieldInfos) {
                        PointValues values2;
                        if (fieldInfo.getPointDimensionCount() <= 0 || (values2 = pointsReader2.getValues(fieldInfo.getName())) == null) continue;
                        int n = status.getTotalValueFields();
                        status.setTotalValueFields(n + 1);
                        long size2 = values2.size();
                        int docCount = values2.getDocCount();
                        long crossCost = values2.estimatePointCount(new ConstantRelationIntersectVisitor(PointValues.Relation.CELL_CROSSES_QUERY));
                        if (crossCost < size2 / (long)2) {
                            throw new CheckIndexException("estimatePointCount should return >= size/2 when all cells match");
                        }
                        long insideCost = values2.estimatePointCount(new ConstantRelationIntersectVisitor(PointValues.Relation.CELL_INSIDE_QUERY));
                        if (insideCost < size2) {
                            throw new CheckIndexException("estimatePointCount should return >= size when all cells fully match");
                        }
                        long outsideCost = values2.estimatePointCount(new ConstantRelationIntersectVisitor(PointValues.Relation.CELL_OUTSIDE_QUERY));
                        if (outsideCost != 0L) {
                            throw new CheckIndexException("estimatePointCount should return 0 when no cells match");
                        }
                        VerifyPointsVisitor visitor2 = new VerifyPointsVisitor(fieldInfo.getName(), reader2.maxDoc(), values2);
                        values2.intersect(visitor2);
                        if (visitor2.getPointCountSeen() != size2) {
                            throw new CheckIndexException("point values for field \"" + fieldInfo.getName() + "\" claims to have size=" + size2 + " points, but in fact has " + visitor2.getPointCountSeen());
                        }
                        if (visitor2.getDocCountSeen() != (long)docCount) {
                            throw new CheckIndexException("point values for field \"" + fieldInfo.getName() + "\" claims to have docCount=" + docCount + " but in fact has " + visitor2.getDocCountSeen());
                        }
                        status.setTotalValuePoints(status.getTotalValuePoints() + visitor2.getPointCountSeen());
                    }
                }
                this.msg(infoStream, "OK [" + status.getTotalValueFields() + " fields, " + status.getTotalValuePoints() + " points] [took " + this.nsToSec(org.gnit.lucenekmp.jdkport.System.INSTANCE.nanoTime() - startNS) + " sec]");
            }
            catch (Throwable e) {
                if (failFast) {
                    IOUtils.INSTANCE.rethrowAlways(e);
                    throw new KotlinNothingValueException();
                }
                this.msg(infoStream, "ERROR: " + e);
                status.setError(e);
                ThrowableExtKt.printStackTrace(e, infoStream);
            }
            return status;
        }

        @NotNull
        public final Status.VectorValuesStatus testVectors(@NotNull CodecReader reader2, @NotNull PrintStream infoStream, boolean failFast) throws IOException {
            Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
            Intrinsics.checkNotNullParameter((Object)infoStream, (String)"infoStream");
            infoStream.print("    test: vectors.............");
            long startNS = org.gnit.lucenekmp.jdkport.System.INSTANCE.nanoTime();
            FieldInfos fieldInfos = reader2.getFieldInfos();
            Status.VectorValuesStatus status = new Status.VectorValuesStatus();
            try {
                if (fieldInfos.hasVectorValues()) {
                    block6: for (FieldInfo fieldInfo : fieldInfos) {
                        if (!fieldInfo.hasVectorValues()) continue;
                        int dimension = fieldInfo.getVectorDimension();
                        if (dimension <= 0) {
                            throw new CheckIndexException("Field \"" + fieldInfo.getName() + "\" has vector values but dimension is " + dimension);
                        }
                        if (reader2.getFloatVectorValues(fieldInfo.getName()) == null && reader2.getByteVectorValues(fieldInfo.getName()) == null) continue;
                        int n = status.getTotalKnnVectorFields();
                        status.setTotalKnnVectorFields(n + 1);
                        switch (WhenMappings.$EnumSwitchMapping$1[fieldInfo.getVectorEncoding().ordinal()]) {
                            case 1: {
                                ByteVectorValues byteVectorValues = reader2.getByteVectorValues(fieldInfo.getName());
                                if (byteVectorValues == null) {
                                    String string = "Required value was null.";
                                    throw new IllegalArgumentException(string.toString());
                                }
                                this.checkByteVectorValues(byteVectorValues, fieldInfo, status, reader2);
                                continue block6;
                            }
                            case 2: {
                                FloatVectorValues floatVectorValues = reader2.getFloatVectorValues(fieldInfo.getName());
                                if (floatVectorValues == null) {
                                    String string = "Required value was null.";
                                    throw new IllegalArgumentException(string.toString());
                                }
                                this.checkFloatVectorValues(floatVectorValues, fieldInfo, status, reader2);
                                continue block6;
                            }
                        }
                        throw new CheckIndexException("Field \"" + fieldInfo.getName() + "\" has unexpected vector encoding: " + fieldInfo.getVectorEncoding());
                    }
                }
                this.msg(infoStream, "OK [" + status.getTotalKnnVectorFields() + " fields, " + status.getTotalVectorValues() + " vectors] [took " + this.nsToSec(org.gnit.lucenekmp.jdkport.System.INSTANCE.nanoTime() - startNS) + " sec]");
            }
            catch (Throwable e) {
                if (failFast) {
                    IOUtils.INSTANCE.rethrowAlways(e);
                    throw new KotlinNothingValueException();
                }
                this.msg(infoStream, "ERROR: " + e);
                status.setError(e);
                ThrowableExtKt.printStackTrace(e, infoStream);
            }
            return status;
        }

        @NotNull
        public final Status.HnswGraphsStatus testHnswGraphs(@NotNull CodecReader reader2, @NotNull PrintStream infoStream, boolean failFast) throws IOException {
            Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
            Intrinsics.checkNotNullParameter((Object)infoStream, (String)"infoStream");
            infoStream.print("    test: hnsw graphs.........");
            long startNS = org.gnit.lucenekmp.jdkport.System.INSTANCE.nanoTime();
            Status.HnswGraphsStatus status = new Status.HnswGraphsStatus();
            KnnVectorsReader knnVectorsReader = reader2.getVectorReader();
            Intrinsics.checkNotNull((Object)knnVectorsReader);
            KnnVectorsReader vectorsReader = knnVectorsReader;
            FieldInfos fieldInfos = reader2.getFieldInfos();
            try {
                if (fieldInfos.hasVectorValues()) {
                    for (FieldInfo fieldInfo : fieldInfos) {
                        HnswGraph hnswGraph;
                        KnnVectorsReader fieldReader;
                        if (!fieldInfo.hasVectorValues() || !((fieldReader = this.getFieldReaderForName(vectorsReader, fieldInfo.getName())) instanceof HnswGraphProvider)) continue;
                        Intrinsics.checkNotNull((Object)((HnswGraphProvider)((Object)fieldReader)).getGraph(fieldInfo.getName()));
                        this.testHnswGraph(hnswGraph, fieldInfo.getName(), status);
                    }
                }
                this.msg(infoStream, "OK [" + status.getHnswGraphsStatusByField().size() + " fields] [took " + this.nsToSec(org.gnit.lucenekmp.jdkport.System.INSTANCE.nanoTime() - startNS) + " sec]");
                this.printHnswInfo(infoStream, status.getHnswGraphsStatusByField());
            }
            catch (Exception e) {
                if (failFast) {
                    IOUtils.INSTANCE.rethrowAlways(e);
                    throw new KotlinNothingValueException();
                }
                this.msg(infoStream, "ERROR: " + e);
                status.setError(e);
                ThrowableExtKt.printStackTrace(e, infoStream);
            }
            return status;
        }

        private final KnnVectorsReader getFieldReaderForName(KnnVectorsReader vectorsReader, String fieldName) {
            KnnVectorsReader knnVectorsReader;
            if (vectorsReader instanceof PerFieldKnnVectorsFormat.FieldsReader) {
                KnnVectorsReader knnVectorsReader2 = ((PerFieldKnnVectorsFormat.FieldsReader)vectorsReader).getFieldReader(fieldName);
                knnVectorsReader = knnVectorsReader2;
                Intrinsics.checkNotNull((Object)knnVectorsReader2);
            } else {
                knnVectorsReader = vectorsReader;
            }
            return knnVectorsReader;
        }

        private final void printHnswInfo(PrintStream infoStream, Map<String, Status.HnswGraphStatus> fieldsStatus) {
            for (Map.Entry<String, Status.HnswGraphStatus> entry : fieldsStatus.entrySet()) {
                String fieldName = entry.getKey();
                Status.HnswGraphStatus status = entry.getValue();
                this.msg(infoStream, "      hnsw field name: " + fieldName);
                Integer[] integerArray = status.getNumNodesAtLevel();
                Intrinsics.checkNotNull((Object)integerArray);
                int n = integerArray.length;
                String[] stringArray = status.getConnectednessAtLevel();
                Intrinsics.checkNotNull((Object)stringArray);
                int numLevels = Math.min(n, stringArray.length);
                for (int level = numLevels - 1; -1 < level; --level) {
                    Integer[] integerArray2 = status.getNumNodesAtLevel();
                    Intrinsics.checkNotNull((Object)integerArray2);
                    int numNodes = integerArray2[level];
                    String[] stringArray2 = status.getConnectednessAtLevel();
                    Intrinsics.checkNotNull((Object)stringArray2);
                    String connectedness = stringArray2[level];
                    this.msg(infoStream, "        level " + level + ": " + numNodes + " nodes, " + connectedness + " connected");
                }
            }
        }

        private final void testHnswGraph(HnswGraph hnswGraph, String fieldName, Status.HnswGraphsStatus status) throws IOException, CheckIndexException {
            if (hnswGraph != null) {
                status.getHnswGraphsStatusByField().put(fieldName, new Status.HnswGraphStatus());
                int numLevels = hnswGraph.numLevels();
                Status.HnswGraphStatus hnswGraphStatus = status.getHnswGraphsStatusByField().get(fieldName);
                Intrinsics.checkNotNull((Object)hnswGraphStatus);
                hnswGraphStatus.setNumNodesAtLevel(new Integer[numLevels]);
                Status.HnswGraphStatus hnswGraphStatus2 = status.getHnswGraphsStatusByField().get(fieldName);
                Intrinsics.checkNotNull((Object)hnswGraphStatus2);
                hnswGraphStatus2.setConnectednessAtLevel(new String[numLevels]);
                for (int level = numLevels - 1; -1 < level; --level) {
                    BitSet nodesOnThisLevel = new FixedBitSet(hnswGraph.size());
                    HnswGraph.NodesIterator nodesIterator = hnswGraph.getNodesOnLevel(level);
                    while (nodesIterator.hasNext()) {
                        nodesOnThisLevel.set(nodesIterator.nextInt());
                    }
                    nodesIterator = hnswGraph.getNodesOnLevel(level);
                    block2: while (nodesIterator.hasNext()) {
                        int node = nodesIterator.nextInt();
                        if (node < 0 || node > hnswGraph.size() - 1) {
                            throw new CheckIndexException("Field \"" + fieldName + "\" has node: " + node + " not in the expected range [0, " + (hnswGraph.size() - 1) + "]");
                        }
                        hnswGraph.seek(level, node);
                        int nbr = 0;
                        int lastNeighbor = -1;
                        int firstNeighbor = -1;
                        while (true) {
                            int n;
                            int it = n = hnswGraph.nextNeighbor();
                            boolean bl = false;
                            nbr = it;
                            if (n == Integer.MAX_VALUE) continue block2;
                            if (!nodesOnThisLevel.get(nbr)) {
                                throw new CheckIndexException("Field \"" + fieldName + "\" has node: " + node + " with a neighbor " + nbr + " which is not on its level (" + level + ")");
                            }
                            if (firstNeighbor == -1) {
                                firstNeighbor = nbr;
                            }
                            if (nbr < lastNeighbor) {
                                throw new CheckIndexException("Field \"" + fieldName + "\" has neighbors out of order for node " + node + ": " + nbr + "<" + lastNeighbor + " 1st=" + firstNeighbor);
                            }
                            if (nbr == lastNeighbor) {
                                throw new CheckIndexException("Field \"" + fieldName + "\" has repeated neighbors of node " + node + " with value " + nbr);
                            }
                            lastNeighbor = nbr;
                        }
                    }
                    int numNodesOnLayer = nodesIterator.size();
                    Status.HnswGraphStatus hnswGraphStatus3 = status.getHnswGraphsStatusByField().get(fieldName);
                    Intrinsics.checkNotNull((Object)hnswGraphStatus3);
                    Integer[] integerArray = hnswGraphStatus3.getNumNodesAtLevel();
                    Intrinsics.checkNotNull((Object)integerArray);
                    integerArray[level] = numNodesOnLayer;
                    IntIntHashMap connectedNodes = this.getConnectedNodesOnLevel(hnswGraph, numNodesOnLayer, level);
                    Status.HnswGraphStatus hnswGraphStatus4 = status.getHnswGraphsStatusByField().get(fieldName);
                    Intrinsics.checkNotNull((Object)hnswGraphStatus4);
                    String[] stringArray = hnswGraphStatus4.getConnectednessAtLevel();
                    Intrinsics.checkNotNull((Object)stringArray);
                    stringArray[level] = connectedNodes.size() + "/" + numNodesOnLayer;
                }
            }
        }

        private final IntIntHashMap getConnectedNodesOnLevel(HnswGraph hnswGraph, int numNodesOnLayer, int level) throws IOException {
            IntIntHashMap connectedNodes = new IntIntHashMap(numNodesOnLayer, 0.0, 2, null);
            int entryPoint = hnswGraph.entryNode();
            ArrayDeque stack = new ArrayDeque();
            ArrayDequeExtKt.push(stack, entryPoint);
            block0: while (!stack.isEmpty()) {
                int node = ((Number)ArrayDequeExtKt.pop(stack)).intValue();
                if (connectedNodes.containsKey(node)) continue;
                connectedNodes.put(node, 1);
                hnswGraph.seek(level, node);
                int friendOrd = 0;
                while (true) {
                    int n;
                    int it = n = hnswGraph.nextNeighbor();
                    boolean bl = false;
                    friendOrd = it;
                    if (n == Integer.MAX_VALUE) continue block0;
                    ArrayDequeExtKt.push(stack, friendOrd);
                }
            }
            return connectedNodes;
        }

        private final boolean vectorsReaderSupportsSearch(CodecReader codecReader, String fieldName) {
            KnnVectorsReader knnVectorsReader = codecReader.getVectorReader();
            Intrinsics.checkNotNull((Object)knnVectorsReader);
            KnnVectorsReader vectorsReader = knnVectorsReader;
            if (vectorsReader instanceof PerFieldKnnVectorsFormat.FieldsReader) {
                KnnVectorsReader knnVectorsReader2 = ((PerFieldKnnVectorsFormat.FieldsReader)vectorsReader).getFieldReader(fieldName);
                Intrinsics.checkNotNull((Object)knnVectorsReader2);
                vectorsReader = knnVectorsReader2;
            }
            return !(vectorsReader instanceof FlatVectorsReader);
        }

        private final void checkFloatVectorValues(FloatVectorValues values2, FieldInfo fieldInfo, Status.VectorValuesStatus status, CodecReader codecReader) throws IOException {
            int count;
            int everyNdoc = Math.max(values2.size() / 64, 1);
            for (count = 0; count < values2.size(); ++count) {
                int valueLength;
                if (values2.ordToDoc(count) % everyNdoc == 0) {
                    KnnCollector collector2 = new TopKnnCollector(10, Integer.MAX_VALUE, null, 4, null);
                    if (this.vectorsReaderSupportsSearch(codecReader, fieldInfo.getName())) {
                        KnnVectorsReader knnVectorsReader = codecReader.getVectorReader();
                        Intrinsics.checkNotNull((Object)knnVectorsReader);
                        knnVectorsReader.search(fieldInfo.getName(), values2.vectorValue(count), collector2, null);
                        TopDocs docs = collector2.topDocs();
                        ScoreDoc[] scoreDocArray = docs.getScoreDocs();
                        Intrinsics.checkNotNull((Object)scoreDocArray);
                        if (scoreDocArray.length == 0) {
                            throw new CheckIndexException("Field \"" + fieldInfo.getName() + "\" failed to search k nearest neighbors");
                        }
                    }
                }
                if ((valueLength = values2.vectorValue(count).length) == fieldInfo.getVectorDimension()) continue;
                throw new CheckIndexException("Field \"" + fieldInfo.getName() + "\" has a value whose dimension=" + valueLength + " not matching the field's dimension=" + fieldInfo.getVectorDimension());
            }
            if (count != values2.size()) {
                throw new CheckIndexException("Field \"" + fieldInfo.getName() + "\" has size=" + values2.size() + " but when iterated, returns " + count + " docs with values");
            }
            status.setTotalVectorValues(status.getTotalVectorValues() + (long)count);
        }

        private final void checkByteVectorValues(ByteVectorValues values2, FieldInfo fieldInfo, Status.VectorValuesStatus status, CodecReader codecReader) throws IOException {
            int count;
            int everyNdoc = Math.max(values2.size() / 64, 1);
            boolean supportsSearch = this.vectorsReaderSupportsSearch(codecReader, fieldInfo.getName());
            for (count = 0; count < values2.size(); ++count) {
                int valueLength;
                if (supportsSearch && values2.ordToDoc(count) % everyNdoc == 0) {
                    KnnCollector collector2 = new TopKnnCollector(10, Integer.MAX_VALUE, null, 4, null);
                    KnnVectorsReader knnVectorsReader = codecReader.getVectorReader();
                    Intrinsics.checkNotNull((Object)knnVectorsReader);
                    knnVectorsReader.search(fieldInfo.getName(), values2.vectorValue(count), collector2, (Bits)null);
                    TopDocs docs = collector2.topDocs();
                    ScoreDoc[] scoreDocArray = docs.getScoreDocs();
                    Intrinsics.checkNotNull((Object)scoreDocArray);
                    if (scoreDocArray.length == 0) {
                        throw new CheckIndexException("Field \"" + fieldInfo.getName() + "\" failed to search k nearest neighbors");
                    }
                }
                if ((valueLength = values2.vectorValue(count).length) == fieldInfo.getVectorDimension()) continue;
                throw new CheckIndexException("Field \"" + fieldInfo.getName() + "\" has a value whose dimension=" + valueLength + " not matching the field's dimension=" + fieldInfo.getVectorDimension());
            }
            if (count != values2.size()) {
                throw new CheckIndexException("Field \"" + fieldInfo.getName() + "\" has size=" + values2.size() + " but when iterated, returns " + count + " docs with values");
            }
            status.setTotalVectorValues(status.getTotalVectorValues() + (long)count);
        }

        @NotNull
        public final Status.StoredFieldStatus testStoredFields(@NotNull CodecReader reader2, @NotNull PrintStream infoStream, boolean failFast) throws IOException {
            Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
            Intrinsics.checkNotNullParameter((Object)infoStream, (String)"infoStream");
            long startNS = org.gnit.lucenekmp.jdkport.System.INSTANCE.nanoTime();
            Status.StoredFieldStatus status = new Status.StoredFieldStatus();
            try {
                infoStream.print("    test: stored fields.......");
                Bits liveDocs2 = reader2.getLiveDocs();
                StoredFieldsReader storedFieldsReader = reader2.getFieldsReader();
                Intrinsics.checkNotNull((Object)storedFieldsReader);
                StoredFieldsReader storedFields2 = storedFieldsReader.getMergeInstance();
                int n = reader2.maxDoc();
                for (int j = 0; j < n; ++j) {
                    DocumentStoredFieldVisitor visitor2 = new DocumentStoredFieldVisitor();
                    if ((j & 3) == 0) {
                        storedFields2.prefetch(j);
                    }
                    storedFields2.document(j, visitor2);
                    Document doc = visitor2.getDocument();
                    if (liveDocs2 != null && !liveDocs2.get(j)) continue;
                    int n2 = status.getDocCount();
                    status.setDocCount(n2 + 1);
                    status.setTotFields(status.getTotFields() + (long)doc.getFields().size());
                }
                if (status.getDocCount() != reader2.numDocs()) {
                    throw new CheckIndexException("docCount=" + status.getDocCount() + " but saw " + status.getDocCount() + " undeleted docs");
                }
                this.msg(infoStream, "OK [" + status.getTotFields() + " total field count; avg " + (float)status.getTotFields() / (float)status.getDocCount() + " fields per doc] [took " + this.nsToSec(org.gnit.lucenekmp.jdkport.System.INSTANCE.nanoTime() - startNS) + " sec]");
            }
            catch (Throwable e) {
                if (failFast) {
                    IOUtils.INSTANCE.rethrowAlways(e);
                    throw new KotlinNothingValueException();
                }
                this.msg(infoStream, "ERROR [" + e.getMessage() + "]");
                status.setError(e);
                ThrowableExtKt.printStackTrace(e, infoStream);
            }
            return status;
        }

        @NotNull
        public final Status.DocValuesStatus testDocValues(@NotNull CodecReader reader2, @NotNull PrintStream infoStream, boolean failFast) throws IOException {
            Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
            Intrinsics.checkNotNullParameter((Object)infoStream, (String)"infoStream");
            long startNS = org.gnit.lucenekmp.jdkport.System.INSTANCE.nanoTime();
            Status.DocValuesStatus status = new Status.DocValuesStatus();
            try {
                infoStream.print("    test: docvalues...........");
                DocValuesProducer dvReader = reader2.getDocValuesReader();
                if (dvReader != null) {
                    dvReader = dvReader.getMergeInstance();
                }
                for (FieldInfo fieldInfo : reader2.getFieldInfos()) {
                    if (fieldInfo.getDocValuesType() == DocValuesType.NONE) continue;
                    long l = status.getTotalValueFields();
                    status.setTotalValueFields(l + 1L);
                    DocValuesProducer docValuesProducer = dvReader;
                    Intrinsics.checkNotNull((Object)docValuesProducer);
                    this.checkDocValues(fieldInfo, docValuesProducer, status);
                }
                this.msg(infoStream, "OK [" + status.getTotalValueFields() + " docvalues fields; " + status.getTotalBinaryFields() + " BINARY; " + status.getTotalNumericFields() + " NUMERIC; " + status.getTotalSortedFields() + " SORTED; " + status.getTotalSortedNumericFields() + " SORTED_NUMERIC; " + status.getTotalSortedSetFields() + " SORTED_SET; " + status.getTotalSkippingIndex() + " SKIPPING INDEX] [took " + this.nsToSec(org.gnit.lucenekmp.jdkport.System.INSTANCE.nanoTime() - startNS) + " sec]");
            }
            catch (Throwable e) {
                if (failFast) {
                    IOUtils.INSTANCE.rethrowAlways(e);
                    throw new KotlinNothingValueException();
                }
                this.msg(infoStream, "ERROR [" + e.getMessage() + "]");
                status.setError(e);
                ThrowableExtKt.printStackTrace(e, infoStream);
            }
            return status;
        }

        private final void checkDocValueSkipper(FieldInfo fi, DocValuesSkipper skipper) throws IOException {
            String fieldName = fi.getName();
            if (skipper.maxDocID(0) != -1) {
                throw new CheckIndexException("binary dv iterator for field: " + fieldName + " should start at docID=-1, but got " + skipper.maxDocID(0));
            }
            if (skipper.docCount() > 0 && skipper.minValue() > skipper.maxValue()) {
                throw new CheckIndexException("skipper dv iterator for field: " + fieldName + " reports wrong global value range, got  " + skipper.minValue() + " > " + skipper.maxValue());
            }
            int docCount = 0;
            int doc = 0;
            while (true) {
                doc = skipper.maxDocID(0) + 1;
                skipper.advance(doc);
                if (skipper.maxDocID(0) == Integer.MAX_VALUE) break;
                if (skipper.minDocID(0) < doc) {
                    throw new CheckIndexException("skipper dv iterator for field: " + fieldName + " reports wrong minDocID, got " + skipper.minDocID(0) + " < " + doc);
                }
                int levels = skipper.numLevels();
                for (int level = 0; level < levels; ++level) {
                    if (skipper.minDocID(level) > skipper.maxDocID(level)) {
                        throw new CheckIndexException("skipper dv iterator for field: " + fieldName + " reports wrong doc range, got " + skipper.minDocID(level) + " > " + skipper.maxDocID(level));
                    }
                    if (skipper.minValue() > skipper.minValue(level)) {
                        throw new CheckIndexException("skipper dv iterator for field: " + fieldName + " : global minValue  " + skipper.minValue() + " , got  " + skipper.minValue(level));
                    }
                    if (skipper.maxValue() < skipper.maxValue(level)) {
                        throw new CheckIndexException("skipper dv iterator for field: " + fieldName + " : global maxValue  " + skipper.maxValue() + " , got  " + skipper.maxValue(level));
                    }
                    if (skipper.minValue(level) <= skipper.maxValue(level)) continue;
                    throw new CheckIndexException("skipper dv iterator for field: " + fieldName + " reports wrong value range, got  " + skipper.minValue(level) + " > " + skipper.maxValue(level));
                }
                docCount += skipper.docCount(0);
            }
            if (skipper.docCount() != docCount) {
                throw new CheckIndexException("skipper dv iterator for field: " + fieldName + " inconsistent docCount, got " + skipper.docCount() + " != " + docCount);
            }
        }

        private final void checkDVIterator(FieldInfo fi, DocValuesIteratorSupplier producer2) throws IOException {
            int doc2;
            String field = fi.getName();
            DocValuesIterator it1 = null;
            it1 = producer2.get(fi);
            DocValuesIterator it2 = null;
            it2 = producer2.get(fi);
            int i = 0;
            Companion $this$checkDVIterator_u24lambda_u245 = this;
            int n = 0;
            int doc = it1.nextDoc();
            while (true) {
                int n2 = i;
                i = n2 + 1;
                if (n2 % 10 == 1) {
                    doc2 = it2.advance(doc - 1);
                    if (doc2 < doc - 1) {
                        throw new CheckIndexException("dv iterator field=" + field + ": doc=" + (doc - 1) + " went backwords (got: " + doc2 + ")");
                    }
                    if (doc2 == doc - 1) {
                        doc2 = it2.nextDoc();
                    }
                    if (doc2 != doc) {
                        throw new CheckIndexException("dv iterator field=" + field + ": doc=" + doc + " was not found through advance() (got: " + doc2 + ")");
                    }
                    if (it2.docID() != doc) {
                        throw new CheckIndexException("dv iterator field=" + field + ": doc=" + doc + " reports wrong doc ID (got: " + it2.docID() + ")");
                    }
                }
                if (doc == Integer.MAX_VALUE) break;
                doc = it1.nextDoc();
            }
            it1 = producer2.get(fi);
            it2 = producer2.get(fi);
            i = 0;
            int lastDoc = -1;
            int doc3 = it1.nextDoc();
            while (doc3 != Integer.MAX_VALUE) {
                n = i;
                i = n + 1;
                if (n % 13 == 1) {
                    boolean found;
                    if (doc3 - 1 == lastDoc != (found = it2.advanceExact(doc3 - 1))) {
                        throw new CheckIndexException("dv iterator field=" + field + ": doc=" + (doc3 - 1) + " disagrees about whether document exists (got: " + found + ")");
                    }
                    if (it2.docID() != doc3 - 1) {
                        throw new CheckIndexException("dv iterator field=" + field + ": doc=" + (doc3 - 1) + " reports wrong doc ID (got: " + it2.docID() + ")");
                    }
                    boolean found2 = it2.advanceExact(doc3 - 1);
                    if (found != found2) {
                        throw new CheckIndexException("dv iterator field=" + field + ": doc=" + (doc3 - 1) + " has unstable advanceExact");
                    }
                    if (i % 2 == 0) {
                        doc2 = it2.nextDoc();
                        if (doc3 != doc2) {
                            throw new CheckIndexException("dv iterator field=" + field + ": doc=" + doc3 + " was not found through advance() (got: " + doc2 + ")");
                        }
                        if (it2.docID() != doc3) {
                            throw new CheckIndexException("dv iterator field=" + field + ": doc=" + doc3 + " reports wrong doc ID (got: " + it2.docID() + ")");
                        }
                    }
                }
                lastDoc = doc3;
                doc3 = it1.nextDoc();
            }
        }

        private final void checkBinaryDocValues(String fieldName, BinaryDocValues bdv, BinaryDocValues bdv2) throws IOException {
            if (bdv.docID() != -1) {
                throw new CheckIndexException("binary dv iterator for field: " + fieldName + " should start at docID=-1, but got " + bdv.docID());
            }
            int doc = bdv.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                BytesRef value;
                Intrinsics.checkNotNull((Object)bdv.binaryValue());
                value.isValid();
                if (!bdv2.advanceExact(doc)) {
                    throw new CheckIndexException("advanceExact did not find matching doc ID: " + doc);
                }
                BytesRef value2 = bdv2.binaryValue();
                if (!Intrinsics.areEqual((Object)value, (Object)value2)) {
                    throw new CheckIndexException("nextDoc and advanceExact report different values: " + value + " != " + value2);
                }
                doc = bdv.nextDoc();
            }
        }

        private final void checkSortedDocValues(String fieldName, SortedDocValues dv, SortedDocValues dv2) throws IOException {
            if (dv.docID() != -1) {
                throw new CheckIndexException("sorted dv iterator for field: " + fieldName + " should start at docID=-1, but got " + dv.docID());
            }
            int maxOrd = dv.getValueCount() - 1;
            FixedBitSet seenOrds = new FixedBitSet(dv.getValueCount());
            int maxOrd2 = -1;
            int doc = dv.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                int ord = dv.ordValue();
                if (ord == -1) {
                    throw new CheckIndexException("dv for field: " + fieldName + " has -1 ord");
                }
                if (ord < -1 || ord > maxOrd) {
                    throw new CheckIndexException("ord out of bounds: " + ord);
                }
                maxOrd2 = Math.max(maxOrd2, ord);
                seenOrds.set(ord);
                if (!dv2.advanceExact(doc)) {
                    throw new CheckIndexException("advanceExact did not find matching doc ID: " + doc);
                }
                int ord2 = dv2.ordValue();
                if (ord != ord2) {
                    throw new CheckIndexException("nextDoc and advanceExact report different ords: " + ord + " != " + ord2);
                }
                doc = dv.nextDoc();
            }
            if (maxOrd != maxOrd2) {
                throw new CheckIndexException("dv for field: " + fieldName + " reports wrong maxOrd=" + maxOrd + " but this is not the case: " + maxOrd2);
            }
            if (seenOrds.cardinality() != dv.getValueCount()) {
                throw new CheckIndexException("dv for field: " + fieldName + " has holes in its ords, valueCount=" + dv.getValueCount() + " but only used: " + seenOrds.cardinality());
            }
            BytesRef lastValue = null;
            int i = 0;
            if (i <= maxOrd) {
                while (true) {
                    BytesRef term;
                    Intrinsics.checkNotNull((Object)dv.lookupOrd(i));
                    term.isValid();
                    if (lastValue != null && term.compareTo(lastValue) <= 0) {
                        throw new CheckIndexException("dv for field: " + fieldName + " has ords out of order: " + lastValue + " >=" + term);
                    }
                    lastValue = BytesRef.Companion.deepCopyOf(term);
                    if (i == maxOrd) break;
                    ++i;
                }
            }
        }

        private final void checkSortedSetDocValues(String fieldName, SortedSetDocValues dv, SortedSetDocValues dv2) throws IOException {
            long maxOrd = dv.getValueCount() - 1L;
            LongBitSet seenOrds = new LongBitSet(dv.getValueCount());
            long maxOrd2 = -1L;
            int docID = dv.nextDoc();
            while (docID != Integer.MAX_VALUE) {
                int count = dv.docValueCount();
                if (count == 0) {
                    throw new CheckIndexException("sortedset dv for field: " + fieldName + " returned docValueCount=0 for docID=" + docID);
                }
                if (!dv2.advanceExact(docID)) {
                    throw new CheckIndexException("advanceExact did not find matching doc ID: " + docID);
                }
                int count2 = dv2.docValueCount();
                if (count != count2) {
                    throw new CheckIndexException("advanceExact reports different value count: " + count + " != " + count2);
                }
                long lastOrd = -1L;
                int ordCount = 0;
                for (int i = 0; i < count; ++i) {
                    long ord2;
                    if (count != dv.docValueCount()) {
                        throw new CheckIndexException("value count changed from " + count + " to " + dv.docValueCount() + " during iterating over all values");
                    }
                    long ord = dv.nextOrd();
                    if (ord != (ord2 = dv2.nextOrd())) {
                        throw new CheckIndexException("advanceExact reports different value: " + ord + " != " + ord2);
                    }
                    if (ord <= lastOrd) {
                        throw new CheckIndexException("ords out of order: " + ord + " <= " + lastOrd + " for doc: " + docID);
                    }
                    if (!(0L <= ord ? ord <= maxOrd : false)) {
                        throw new CheckIndexException("ord out of bounds: " + ord);
                    }
                    lastOrd = ord;
                    maxOrd2 = Math.max(maxOrd2, ord);
                    seenOrds.set(ord);
                    ++ordCount;
                }
                if (dv.docValueCount() != dv2.docValueCount()) {
                    throw new CheckIndexException("dv and dv2 report different values count after iterating over all values: " + dv.docValueCount() + " != " + dv2.docValueCount());
                }
                if (ordCount == 0) {
                    throw new CheckIndexException("dv for field: " + fieldName + " returned docID=" + docID + " yet has no ordinals");
                }
                docID = dv.nextDoc();
            }
            if (maxOrd != maxOrd2) {
                throw new CheckIndexException("dv for field: " + fieldName + " reports wrong maxOrd=" + maxOrd + " but this is not the case: " + maxOrd2);
            }
            if (seenOrds.cardinality() != dv.getValueCount()) {
                throw new CheckIndexException("dv for field: " + fieldName + " has holes in its ords, valueCount=" + dv.getValueCount() + " but only used: " + seenOrds.cardinality());
            }
            BytesRef lastValue = null;
            long i = 0L;
            if (i <= maxOrd) {
                while (true) {
                    BytesRef term;
                    Intrinsics.checkNotNull((Object)dv.lookupOrd(i));
                    boolean condition$iv = term.isValid();
                    boolean $i$f$assert = false;
                    if (_Assertions.ENABLED && !condition$iv) {
                        boolean bl = false;
                        String string = "assertion failed";
                        throw new AssertionError((Object)string);
                    }
                    if (lastValue != null && term.compareTo(lastValue) <= 0) {
                        throw new CheckIndexException("dv for field: " + fieldName + " has ords out of order: " + lastValue + " >=" + term);
                    }
                    lastValue = BytesRef.Companion.deepCopyOf(term);
                    if (i == maxOrd) break;
                    ++i;
                }
            }
        }

        private final void checkSortedNumericDocValues(String fieldName, SortedNumericDocValues ndv, SortedNumericDocValues ndv2) throws IOException {
            if (ndv.docID() != -1) {
                throw new CheckIndexException("dv iterator for field: " + fieldName + " should start at docID=-1, but got " + ndv.docID());
            }
            int docID = ndv.nextDoc();
            while (docID != Integer.MAX_VALUE) {
                int count = ndv.docValueCount();
                if (count == 0) {
                    throw new CheckIndexException("sorted numeric dv for field: " + fieldName + " returned docValueCount=0 for docID=" + docID);
                }
                if (!ndv2.advanceExact(docID)) {
                    throw new CheckIndexException("advanceExact did not find matching doc ID: " + docID);
                }
                int count2 = ndv2.docValueCount();
                if (count != count2) {
                    throw new CheckIndexException("advanceExact reports different value count: " + count + " != " + count2);
                }
                long previous = Long.MIN_VALUE;
                for (int j = 0; j < count; ++j) {
                    long value = ndv.nextValue();
                    if (value < previous) {
                        throw new CheckIndexException("values out of order: " + value + " < " + previous + " for doc: " + docID);
                    }
                    previous = value;
                    long value2 = ndv2.nextValue();
                    if (value == value2) continue;
                    throw new CheckIndexException("advanceExact reports different value: " + value + " != " + value2);
                }
                docID = ndv.nextDoc();
            }
        }

        private final void checkNumericDocValues(String fieldName, NumericDocValues ndv, NumericDocValues ndv2) throws IOException {
            if (ndv.docID() != -1) {
                throw new CheckIndexException("dv iterator for field: " + fieldName + " should start at docID=-1, but got " + ndv.docID());
            }
            int doc = ndv.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                long value = ndv.longValue();
                if (!ndv2.advanceExact(doc)) {
                    throw new CheckIndexException("advanceExact did not find matching doc ID: " + doc);
                }
                long value2 = ndv2.longValue();
                if (value != value2) {
                    throw new CheckIndexException("advanceExact reports different value: " + value + " != " + value2);
                }
                doc = ndv.nextDoc();
            }
        }

        private final void checkDocValues(FieldInfo fi, DocValuesProducer dvReader, Status.DocValuesStatus status) throws Exception {
            if (fi.docValuesSkipIndexType() != DocValuesSkipIndexType.NONE) {
                long l = status.getTotalSkippingIndex();
                status.setTotalSkippingIndex(l + 1L);
                DocValuesSkipper docValuesSkipper = dvReader.getSkipper(fi);
                Intrinsics.checkNotNull((Object)docValuesSkipper);
                this.checkDocValueSkipper(fi, docValuesSkipper);
            }
            switch (WhenMappings.$EnumSwitchMapping$2[fi.getDocValuesType().ordinal()]) {
                case 1: {
                    long l = status.getTotalSortedFields();
                    status.setTotalSortedFields(l + 1L);
                    this.checkDVIterator(fi, arg_0 -> Companion.checkDocValues$lambda$6(dvReader, arg_0));
                    this.checkSortedDocValues(fi.getName(), dvReader.getSorted(fi), dvReader.getSorted(fi));
                    break;
                }
                case 2: {
                    long l = status.getTotalSortedNumericFields();
                    status.setTotalSortedNumericFields(l + 1L);
                    this.checkDVIterator(fi, arg_0 -> Companion.checkDocValues$lambda$7(dvReader, arg_0));
                    this.checkSortedNumericDocValues(fi.getName(), dvReader.getSortedNumeric(fi), dvReader.getSortedNumeric(fi));
                    break;
                }
                case 3: {
                    long l = status.getTotalSortedSetFields();
                    status.setTotalSortedSetFields(l + 1L);
                    this.checkDVIterator(fi, arg_0 -> Companion.checkDocValues$lambda$8(dvReader, arg_0));
                    this.checkSortedSetDocValues(fi.getName(), dvReader.getSortedSet(fi), dvReader.getSortedSet(fi));
                    break;
                }
                case 4: {
                    long l = status.getTotalBinaryFields();
                    status.setTotalBinaryFields(l + 1L);
                    this.checkDVIterator(fi, arg_0 -> Companion.checkDocValues$lambda$9(dvReader, arg_0));
                    this.checkBinaryDocValues(fi.getName(), dvReader.getBinary(fi), dvReader.getBinary(fi));
                    break;
                }
                case 5: {
                    long l = status.getTotalNumericFields();
                    status.setTotalNumericFields(l + 1L);
                    this.checkDVIterator(fi, arg_0 -> Companion.checkDocValues$lambda$10(dvReader, arg_0));
                    this.checkNumericDocValues(fi.getName(), dvReader.getNumeric(fi), dvReader.getNumeric(fi));
                    break;
                }
                case 6: {
                    throw new AssertionError();
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        /*
         * Unable to fully structure code
         */
        @NotNull
        public final Status.TermVectorStatus testTermVectors(@NotNull CodecReader reader, @NotNull PrintStream infoStream, boolean verbose, int level, boolean failFast) throws IOException {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            Intrinsics.checkNotNullParameter((Object)infoStream, (String)"infoStream");
            startNS = org.gnit.lucenekmp.jdkport.System.INSTANCE.nanoTime();
            status = new Status.TermVectorStatus();
            fieldInfos = reader.getFieldInfos();
            try {
                infoStream.print("    test: term vectors........");
                postings = null;
                postingsDocs = null;
                liveDocs = reader.getLiveDocs();
                postingsFields = null;
                if (level >= 3) {
                    postingsFields = reader.getPostingsReader();
                    if (postingsFields != null) {
                        postingsFields = postingsFields.getMergeInstance();
                    }
                } else {
                    postingsFields = null;
                }
                if ((vectorsReader = reader.getTermVectorsReader()) != null) {
                    vectorsReader = vectorsReader.getMergeInstance();
                    var16_17 = reader.maxDoc();
                    for (j = 0; j < var16_17; ++j) {
                        if ((j & 3) == 0) {
                            vectorsReader.prefetch(j);
                        }
                        if ((tfv = vectorsReader.get(j)) == null) continue;
                        this.checkFields(tfv, null, 1, fieldInfos, null, false, true, infoStream, verbose, level);
                        v0 = doStats = liveDocs == null || liveDocs.get(j) != false;
                        if (doStats) {
                            var19_21 = status.getDocCount();
                            status.setDocCount(var19_21 + 1);
                        }
                        block3: for (String field : tfv) {
                            if (doStats) {
                                var21_24 = status.getTotVectors();
                                status.setTotVectors(var21_24 + 1L);
                            }
                            Intrinsics.checkNotNull((Object)fieldInfos.fieldInfo(field));
                            if (!fieldInfo.hasTermVectors()) {
                                throw new CheckIndexException("docID=" + j + " has term vectors for field=" + field + " but FieldInfo has storeTermVector=false");
                            }
                            if (level < 3) continue;
                            Intrinsics.checkNotNull((Object)tfv.terms(field));
                            termsEnum = terms.iterator();
                            postingsHasFreq = fieldInfo.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS) >= 0;
                            postingsHasPayload = fieldInfo.hasPayloads();
                            vectorsHasPayload = terms.hasPayloads();
                            if (postingsFields == null) {
                                throw new CheckIndexException("vector field=" + field + " does not exist in postings; doc=" + j);
                            }
                            postingsTerms = postingsFields.terms(field);
                            if (postingsTerms == null) {
                                throw new CheckIndexException("vector field=" + field + " does not exist in postings; doc=" + j);
                            }
                            postingsTermsEnum = postingsTerms.iterator();
                            hasProx = terms.hasOffsets() != false || terms.hasPositions() != false;
                            seekExactCounter = 0;
                            term = null;
                            block4: while (true) {
                                it = var32_35 = termsEnum.next();
                                $i$a$-also-CheckIndex$Companion$testTermVectors$1 = false;
                                term = it;
                                if (var32_35 == null) continue block3;
                                postings = termsEnum.postings(postings, PostingsEnum.Companion.getALL());
                                termExists = false;
                                if ((seekExactCounter++ & 1) == 0) {
                                    v1 = term;
                                    Intrinsics.checkNotNull((Object)v1);
                                    termExists = postingsTermsEnum.seekExact(v1);
                                } else {
                                    v2 = term;
                                    Intrinsics.checkNotNull((Object)v2);
                                    termExistsSupplier = postingsTermsEnum.prepareSeekExact(v2);
                                    v3 = termExists = termExistsSupplier != null && termExistsSupplier.get() != false;
                                }
                                if (!termExists) {
                                    throw new CheckIndexException("vector term=" + term + " field=" + field + " doc=" + j + " does not exist in postings (null or not found)");
                                }
                                advanceDoc = (postingsDocs = postingsTermsEnum.postings(postingsDocs, PostingsEnum.Companion.getALL())).advance(j);
                                if (advanceDoc != j) {
                                    throw new CheckIndexException("vector term=" + term + " field=" + field + ": doc=" + j + " was not found in postings (got: " + advanceDoc + ")");
                                }
                                doc = postings.nextDoc();
                                if (doc != 0) {
                                    throw new CheckIndexException("vector for doc " + j + " didn't return docID=0: got docID=" + doc);
                                }
                                if (!postingsHasFreq) continue;
                                tf = postings.freq();
                                if (postingsHasFreq && postingsDocs.freq() != tf) {
                                    throw new CheckIndexException("vector term=" + term + " field=" + field + " doc=" + j + ": freq=" + tf + " differs from postings freq=" + postingsDocs.freq());
                                }
                                if (!hasProx) continue;
                                i = 0;
                                while (true) {
                                    if (i < tf) ** break;
                                    continue block4;
                                    pos = postings.nextPosition();
                                    if (postingsTerms.hasPositions()) {
                                        postingsPos = postingsDocs.nextPosition();
                                        if (terms.hasPositions() && pos != postingsPos) {
                                            throw new CheckIndexException("vector term=" + term + " field=" + field + " doc=" + j + ": pos=" + pos + " differs from postings pos=" + postingsPos);
                                        }
                                    }
                                    startOffset = postings.startOffset();
                                    endOffset = postings.endOffset();
                                    if (startOffset != -1 && endOffset != -1 && postingsTerms.hasOffsets()) {
                                        postingsStartOffset = postingsDocs.startOffset();
                                        postingsEndOffset = postingsDocs.endOffset();
                                        if (startOffset != postingsStartOffset) {
                                            throw new CheckIndexException("vector term=" + term + " field=" + field + " doc=" + j + ": startOffset=" + startOffset + " differs from postings startOffset=" + postingsStartOffset);
                                        }
                                        if (endOffset != postingsEndOffset) {
                                            throw new CheckIndexException("vector term=" + term + " field=" + field + " doc=" + j + ": endOffset=" + endOffset + " differs from postings endOffset=" + postingsEndOffset);
                                        }
                                    }
                                    if ((payload = postings.getPayload()) != null) {
                                        condition$iv = vectorsHasPayload;
                                        $i$f$assert = false;
                                        if (_Assertions.ENABLED && !condition$iv) {
                                            $i$a$-assert-AssertKt$assert$1 = false;
                                            var43_51 = "assertion failed";
                                            throw new AssertionError((Object)var43_51);
                                        }
                                    }
                                    if (postingsHasPayload && vectorsHasPayload) {
                                        if (payload == null) {
                                            if (postingsDocs.getPayload() != null) {
                                                throw new CheckIndexException("vector term=" + term + " field=" + field + " doc=" + j + " has no payload but postings does: " + postingsDocs.getPayload());
                                            }
                                        } else {
                                            if (postingsDocs.getPayload() == null) {
                                                throw new CheckIndexException("vector term=" + term + " field=" + field + " doc=" + j + " has payload=" + payload + " but postings does not.");
                                            }
                                            postingsPayload = postingsDocs.getPayload();
                                            if (!Intrinsics.areEqual((Object)payload, (Object)postingsPayload)) {
                                                throw new CheckIndexException("vector term=" + term + " field=" + field + " doc=" + j + " has payload=" + payload + " but differs from postings payload=" + postingsPayload);
                                            }
                                        }
                                    }
                                    ++i;
                                }
                                break;
                            }
                        }
                    }
                }
                vectorAvg = status.getDocCount() == 0 ? 0.0f : (float)status.getTotVectors() / (float)status.getDocCount();
                this.msg(infoStream, "OK [" + status.getTotVectors() + " total term vector count; avg " + vectorAvg + " term/freq vector fields per doc] [took " + this.nsToSec(org.gnit.lucenekmp.jdkport.System.INSTANCE.nanoTime() - startNS) + " sec]");
            }
            catch (Throwable e) {
                if (failFast) {
                    IOUtils.INSTANCE.rethrowAlways(e);
                    throw new KotlinNothingValueException();
                }
                this.msg(infoStream, "ERROR [" + e.getMessage() + "]");
                status.setError(e);
                ThrowableExtKt.printStackTrace(e, infoStream);
            }
            return status;
        }

        public static /* synthetic */ Status.TermVectorStatus testTermVectors$default(Companion companion, CodecReader codecReader, PrintStream printStream, boolean bl, int n, boolean bl2, int n2, Object object) throws IOException {
            if ((n2 & 4) != 0) {
                bl = false;
            }
            if ((n2 & 8) != 0) {
                n = 2;
            }
            if ((n2 & 0x10) != 0) {
                bl2 = false;
            }
            return companion.testTermVectors(codecReader, printStream, bl, n, bl2);
        }

        private final boolean testAsserts() {
            assertsOn = true;
            return true;
        }

        public final boolean assertsOn() {
            boolean condition$iv = this.testAsserts();
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            return assertsOn;
        }

        @JvmStatic
        public final void main(@NotNull String[] args) throws IOException, InterruptedException {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            int exitCode = this.doMain(args);
            ExitProcessKt.exitProcess(exitCode);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final int doMain(String[] args) throws IOException, InterruptedException {
            AutoCloseable autoCloseable;
            Options opts = null;
            try {
                opts = this.parseOptions(args);
            }
            catch (IllegalArgumentException e) {
                System.out.println((Object)e.getMessage());
                return 1;
            }
            if (!this.assertsOn()) {
                String e = "\nNOTE: testing will be more thorough if you run java with '-ea:org.apache.lucene...', so assertions are enabled";
                System.out.println((Object)e);
            }
            System.out.println((Object)("\nOpening index @ " + opts.getIndexPath() + "\n"));
            Directory directory = null;
            String string = opts.getIndexPath();
            Intrinsics.checkNotNull((Object)string);
            Path path = Path.Companion.get$default((Path.Companion)Path.Companion, (String)string, (boolean)false, (int)1, null);
            try {
                FSDirectory fSDirectory;
                if (opts.getDirImpl() == null) {
                    fSDirectory = FSDirectory.Companion.open$default(FSDirectory.Companion, path, null, 2, null);
                } else {
                    String string2 = opts.getDirImpl();
                    Intrinsics.checkNotNull((Object)string2);
                    fSDirectory = CommandLineUtil.INSTANCE.newFSDirectory(string2, path);
                }
                autoCloseable = fSDirectory;
            }
            catch (Throwable t) {
                System.out.println((Object)("ERROR: could not open directory \"" + opts.getIndexPath() + "\"; exiting"));
                System.out.println((Object)ExceptionsKt.stackTraceToString((Throwable)t));
                return 1;
            }
            directory = autoCloseable;
            autoCloseable = directory;
            Throwable throwable = null;
            try {
                int n;
                FSDirectory dir = (FSDirectory)autoCloseable;
                boolean bl = false;
                AutoCloseable autoCloseable2 = new CheckIndex(dir, null, 2, null);
                Throwable throwable2 = null;
                try {
                    CheckIndex checker = (CheckIndex)autoCloseable2;
                    boolean bl2 = false;
                    ByteArrayOutputStream output = new ByteArrayOutputStream(0, 1, null);
                    opts.setOut(new PrintStream(output, true, StandardCharsets.Companion.getUTF_8()));
                    n = checker.doCheck(opts);
                }
                catch (Throwable throwable3) {
                    try {
                        try {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, throwable2);
                            throw throwable4;
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                }
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
                int n2 = n;
                return n2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }

        @NotNull
        public final Options parseOptions(@NotNull String[] args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            Options opts = new Options();
            int i = 0;
            while (i < args.length) {
                String arg;
                switch (arg = args[i]) {
                    case "-level": {
                        if (!(i != args.length - 1)) {
                            boolean $i$a$-require-CheckIndex$Companion$parseOptions$72 = false;
                            String $i$a$-require-CheckIndex$Companion$parseOptions$72 = "ERROR: missing value for -level option";
                            throw new IllegalArgumentException($i$a$-require-CheckIndex$Companion$parseOptions$72.toString());
                        }
                        int n = i;
                        i = n + 1;
                        int level = Integer.parseInt(args[i]);
                        Level.INSTANCE.checkIfLevelInBounds(level);
                        opts.setLevel(level);
                        break;
                    }
                    case "-exorcise": {
                        opts.setDoExorcise(true);
                        break;
                    }
                    case "-verbose": {
                        opts.setVerbose(true);
                        break;
                    }
                    case "-segment": {
                        if (!(i != args.length - 1)) {
                            boolean $i$a$-require-CheckIndex$Companion$parseOptions$92 = false;
                            String $i$a$-require-CheckIndex$Companion$parseOptions$92 = "ERROR: missing name for -segment option";
                            throw new IllegalArgumentException($i$a$-require-CheckIndex$Companion$parseOptions$92.toString());
                        }
                        int n = i;
                        i = n + 1;
                        List<String> list = opts.getOnlySegments();
                        Intrinsics.checkNotNull(list);
                        list.add(args[i]);
                        break;
                    }
                    case "-dir-impl": {
                        if (!(i != args.length - 1)) {
                            boolean $i$a$-require-CheckIndex$Companion$parseOptions$102 = false;
                            String $i$a$-require-CheckIndex$Companion$parseOptions$102 = "ERROR: missing value for -dir-impl option";
                            throw new IllegalArgumentException($i$a$-require-CheckIndex$Companion$parseOptions$102.toString());
                        }
                        int n = i;
                        i = n + 1;
                        opts.setDirImpl(args[i]);
                        break;
                    }
                    case "-threadCount": {
                        if (!(i != args.length - 1)) {
                            boolean $i$a$-require-CheckIndex$Companion$parseOptions$112 = false;
                            String $i$a$-require-CheckIndex$Companion$parseOptions$112 = "-threadCount requires a following number";
                            throw new IllegalArgumentException($i$a$-require-CheckIndex$Companion$parseOptions$112.toString());
                        }
                        int n = i;
                        i = n + 1;
                        opts.setThreadCount(Integer.parseInt(args[i]));
                        if (opts.getThreadCount() > 0) break;
                        boolean $i$a$-require-CheckIndex$Companion$parseOptions$122 = false;
                        String $i$a$-require-CheckIndex$Companion$parseOptions$122 = "-threadCount requires a number larger than 0, but got: " + opts.getThreadCount();
                        throw new IllegalArgumentException($i$a$-require-CheckIndex$Companion$parseOptions$122.toString());
                    }
                    default: {
                        if (!(opts.getIndexPath() == null)) {
                            boolean bl = false;
                            String string = "ERROR: unexpected extra argument '" + args[i] + "'";
                            throw new IllegalArgumentException(string.toString());
                        }
                        opts.setIndexPath(args[i]);
                    }
                }
                int n = i;
                i = n + 1;
            }
            if (opts.getIndexPath() == null) {
                boolean $i$a$-requireNotNull-CheckIndex$Companion$parseOptions$82 = false;
                String $i$a$-requireNotNull-CheckIndex$Companion$parseOptions$82 = "\nERROR: index path not specified\nUsage: java org.apache.lucene.index.CheckIndex pathToIndex [-exorcise] [-level X] [-segment X] [-segment Y] [-threadCount X] [-dir-impl X]\n\n  -exorcise: actually write a new segments_N file, removing any problematic segments\n  -level X: sets the detail level of the check. The higher the value, the more checks are done.\n         1 - (Default) Checksum checks only.\n         2 - All level 1 checks + logical integrity checks.\n         3 - All level 2 checks + slow checks.\n  -codec X: when exorcising, codec to write the new segments_N file with\n  -verbose: print additional details\n  -segment X: only check the specified segments.  This can be specified multiple\n              times, to check more than one segment, e.g. '-segment _2 -segment _a'.\n              You can't use this with the -exorcise option\n  -threadCount X: number of threads used to check index concurrently.\n                  When not specified, this will default to the number of CPU cores.\n                  When '-threadCount 1' is used, index checking will be performed sequentially.\n  -dir-impl X: use a specific " + Reflection.getOrCreateKotlinClass(FSDirectory.class).getSimpleName() + " implementation. If no package is specified the org.apache.lucene.store package will be used.\nCheckIndex only verifies file checksums as default.\nUse -level with value of '2' or higher if you also want to check segment file contents.\n\n**WARNING**: -exorcise *LOSES DATA*. This should only be used on an emergency basis as it will cause\ndocuments (perhaps many) to be permanently removed from the index.  Always make\na backup copy of your index before running this!  Do not run this tool on an index\nthat is actively being written to.  You have been warned!\n\nRun without -exorcise, this tool will open the index, report version information\nand report any exceptions it hits and what action it would take if -exorcise were\nspecified.  With -exorcise, this tool will remove any segments that have issues and\nwrite a new segments_N file.  This means all documents contained in the affected\nsegments will be removed.\n\nThis tool exits with exit code 1 if the index cannot be opened or has any\ncorruption, else 0.\n";
                throw new IllegalArgumentException($i$a$-requireNotNull-CheckIndex$Companion$parseOptions$82.toString());
            }
            List<String> list = opts.getOnlySegments();
            Intrinsics.checkNotNull(list);
            if (list.isEmpty()) {
                opts.setOnlySegments(null);
            } else if (!(!opts.getDoExorcise())) {
                boolean bl = false;
                String string = "ERROR: cannot specify both -exorcise and -segment";
                throw new IllegalArgumentException(string.toString());
            }
            return opts;
        }

        private final Status.SoftDeletesStatus checkSoftDeletes(String softDeletesField, SegmentCommitInfo info, SegmentReader reader2, PrintStream infoStream, boolean failFast) throws IOException {
            Status.SoftDeletesStatus status;
            block5: {
                status = new Status.SoftDeletesStatus();
                if (infoStream != null) {
                    infoStream.print("    test: check soft deletes.....");
                }
                try {
                    DocIdSetIterator docIdSetIterator = FieldExistsQuery.Companion.getDocValuesDocIdSetIterator(softDeletesField, reader2);
                    Intrinsics.checkNotNull((Object)docIdSetIterator);
                    Bits bits = reader2.getLiveDocs();
                    Intrinsics.checkNotNull((Object)bits);
                    int softDeletes = PendingSoftDeletes.Companion.countSoftDeletes(docIdSetIterator, bits);
                    if (softDeletes != info.getSoftDelCount()) {
                        throw new CheckIndexException("actual soft deletes: " + softDeletes + " but expected: " + info.getSoftDelCount());
                    }
                }
                catch (Exception e) {
                    if (failFast) {
                        IOUtils.INSTANCE.rethrowAlways(e);
                        throw new KotlinNothingValueException();
                    }
                    this.msg(infoStream, "ERROR [" + e.getMessage() + "]");
                    status.setError(e);
                    if (infoStream == null) break block5;
                    ThrowableExtKt.printStackTrace(e, infoStream);
                }
            }
            return status;
        }

        private final double nsToSec(long ns) {
            return (double)ns / (double)TimeUnit.SECONDS.toNanos(1L);
        }

        private static final DocValuesIterator checkDocValues$lambda$6(DocValuesProducer $dvReader, FieldInfo field) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            return $dvReader.getSorted(field);
        }

        private static final DocValuesIterator checkDocValues$lambda$7(DocValuesProducer $dvReader, FieldInfo field) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            return $dvReader.getSortedNumeric(field);
        }

        private static final DocValuesIterator checkDocValues$lambda$8(DocValuesProducer $dvReader, FieldInfo field) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            return $dvReader.getSortedSet(field);
        }

        private static final DocValuesIterator checkDocValues$lambda$9(DocValuesProducer $dvReader, FieldInfo field) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            return $dvReader.getBinary(field);
        }

        private static final DocValuesIterator checkDocValues$lambda$10(DocValuesProducer $dvReader, FieldInfo field) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            return $dvReader.getNumeric(field);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;
            public static final /* synthetic */ int[] $EnumSwitchMapping$2;

            static {
                int[] nArray = new int[TermsEnum.SeekStatus.values().length];
                try {
                    nArray[TermsEnum.SeekStatus.FOUND.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TermsEnum.SeekStatus.NOT_FOUND.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TermsEnum.SeekStatus.END.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[VectorEncoding.values().length];
                try {
                    nArray[VectorEncoding.BYTE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[VectorEncoding.FLOAT32.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
                nArray = new int[DocValuesType.values().length];
                try {
                    nArray[DocValuesType.SORTED.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DocValuesType.SORTED_NUMERIC.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DocValuesType.SORTED_SET.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DocValuesType.BINARY.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DocValuesType.NUMERIC.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DocValuesType.NONE.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$2 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/gnit/lucenekmp/index/CheckIndex$ConstantRelationIntersectVisitor;", "Lorg/gnit/lucenekmp/index/PointValues$IntersectVisitor;", "relation", "Lorg/gnit/lucenekmp/index/PointValues$Relation;", "<init>", "(Lorg/gnit/lucenekmp/index/PointValues$Relation;)V", "getRelation", "()Lorg/gnit/lucenekmp/index/PointValues$Relation;", "visit", "", "docID", "", "packedValue", "", "compare", "minPackedValue", "maxPackedValue", "core"})
    private static final class ConstantRelationIntersectVisitor
    implements PointValues.IntersectVisitor {
        @NotNull
        private final PointValues.Relation relation;

        public ConstantRelationIntersectVisitor(@NotNull PointValues.Relation relation) {
            Intrinsics.checkNotNullParameter((Object)((Object)relation), (String)"relation");
            this.relation = relation;
        }

        @NotNull
        public final PointValues.Relation getRelation() {
            return this.relation;
        }

        @Override
        public void visit(int docID) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void visit(int docID, @NotNull byte[] packedValue) throws IOException {
            Intrinsics.checkNotNullParameter((Object)packedValue, (String)"packedValue");
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public PointValues.Relation compare(@NotNull byte[] minPackedValue, @NotNull byte[] maxPackedValue) {
            Intrinsics.checkNotNullParameter((Object)minPackedValue, (String)"minPackedValue");
            Intrinsics.checkNotNullParameter((Object)maxPackedValue, (String)"maxPackedValue");
            return this.relation;
        }

        @Override
        public void visit(@NotNull DocIdSetIterator iterator2) throws IOException {
            PointValues.IntersectVisitor.super.visit(iterator2);
        }

        @Override
        public void visit(@NotNull IntsRef ref) throws IOException {
            PointValues.IntersectVisitor.super.visit(ref);
        }

        @Override
        public void visit(@NotNull DocIdSetIterator iterator2, @NotNull byte[] packedValue) throws IOException {
            PointValues.IntersectVisitor.super.visit(iterator2, packedValue);
        }

        @Override
        public void grow(int count) {
            PointValues.IntersectVisitor.super.grow(count);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006\u00c0\u0006\u0003"}, d2={"Lorg/gnit/lucenekmp/index/CheckIndex$DocValuesIteratorSupplier;", "", "get", "Lorg/gnit/lucenekmp/index/DocValuesIterator;", "fi", "Lorg/gnit/lucenekmp/index/FieldInfo;", "core"})
    public static interface DocValuesIteratorSupplier {
        @NotNull
        public DocValuesIterator get(@NotNull FieldInfo var1) throws IOException;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/index/CheckIndex$Level;", "", "<init>", "()V", "MIN_VALUE", "", "MAX_VALUE", "DEFAULT_VALUE", "MIN_LEVEL_FOR_CHECKSUM_CHECKS", "MIN_LEVEL_FOR_INTEGRITY_CHECKS", "MIN_LEVEL_FOR_SLOW_CHECKS", "checkIfLevelInBounds", "", "levelVal", "core"})
    public static final class Level {
        @NotNull
        public static final Level INSTANCE = new Level();
        public static final int MIN_VALUE = 1;
        public static final int MAX_VALUE = 3;
        public static final int DEFAULT_VALUE = 1;
        public static final int MIN_LEVEL_FOR_CHECKSUM_CHECKS = 1;
        public static final int MIN_LEVEL_FOR_INTEGRITY_CHECKS = 2;
        public static final int MIN_LEVEL_FOR_SLOW_CHECKS = 3;

        private Level() {
        }

        public final void checkIfLevelInBounds(int levelVal) throws IllegalArgumentException {
            if (!(1 <= levelVal ? levelVal < 4 : false)) {
                boolean bl = false;
                String string = "ERROR: given value: '" + levelVal + "' for -level option is out of bounds. Please use a value from '1'->'3'";
                throw new IllegalArgumentException(string.toString());
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R\"\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001c\u0010\"\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001f\"\u0004\b$\u0010!R\u001c\u0010%\u001a\u0004\u0018\u00010&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*\u00a8\u0006+"}, d2={"Lorg/gnit/lucenekmp/index/CheckIndex$Options;", "", "<init>", "()V", "doExorcise", "", "getDoExorcise", "()Z", "setDoExorcise", "(Z)V", "verbose", "getVerbose", "setVerbose", "level", "", "getLevel", "()I", "setLevel", "(I)V", "threadCount", "getThreadCount", "setThreadCount", "onlySegments", "", "", "getOnlySegments", "()Ljava/util/List;", "setOnlySegments", "(Ljava/util/List;)V", "indexPath", "getIndexPath", "()Ljava/lang/String;", "setIndexPath", "(Ljava/lang/String;)V", "dirImpl", "getDirImpl", "setDirImpl", "out", "Lorg/gnit/lucenekmp/jdkport/PrintStream;", "getOut", "()Lorg/gnit/lucenekmp/jdkport/PrintStream;", "setOut", "(Lorg/gnit/lucenekmp/jdkport/PrintStream;)V", "core"})
    public static final class Options {
        private boolean doExorcise;
        private boolean verbose;
        private int level = 1;
        private int threadCount;
        @Nullable
        private List<String> onlySegments = new ArrayList();
        @Nullable
        private String indexPath;
        @Nullable
        private String dirImpl;
        @Nullable
        private PrintStream out;

        public final boolean getDoExorcise() {
            return this.doExorcise;
        }

        public final void setDoExorcise(boolean bl) {
            this.doExorcise = bl;
        }

        public final boolean getVerbose() {
            return this.verbose;
        }

        public final void setVerbose(boolean bl) {
            this.verbose = bl;
        }

        public final int getLevel() {
            return this.level;
        }

        public final void setLevel(int n) {
            this.level = n;
        }

        public final int getThreadCount() {
            return this.threadCount;
        }

        public final void setThreadCount(int n) {
            this.threadCount = n;
        }

        @Nullable
        public final List<String> getOnlySegments() {
            return this.onlySegments;
        }

        public final void setOnlySegments(@Nullable List<String> list) {
            this.onlySegments = list;
        }

        @Nullable
        public final String getIndexPath() {
            return this.indexPath;
        }

        public final void setIndexPath(@Nullable String string) {
            this.indexPath = string;
        }

        @Nullable
        public final String getDirImpl() {
            return this.dirImpl;
        }

        public final void setDirImpl(@Nullable String string) {
            this.dirImpl = string;
        }

        @Nullable
        public final PrintStream getOut() {
            return this.out;
        }

        public final void setOut(@Nullable PrintStream printStream) {
            this.out = printStream;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010%\n\u0002\b\u0013\u0018\u00002\u00020\u0001:\u000eJKLMNOPQRSTUVWB\t\b\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R \u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0007\"\u0004\b!\u0010\tR \u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u001c\"\u0004\b%\u0010\u001eR\u001c\u0010&\u001a\u0004\u0018\u00010'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001c\u0010,\u001a\u0004\u0018\u00010-X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u001a\u00102\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\u0016\"\u0004\b4\u0010\u0018R\u001a\u00105\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010\u0016\"\u0004\b7\u0010\u0018R\u001a\u00108\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010\u0007\"\u0004\b:\u0010\tR\u001a\u0010;\u001a\u00020<X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R\u001a\u0010A\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010\u0007\"\u0004\bC\u0010\tR(\u0010D\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e\u0018\u00010EX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010G\"\u0004\bH\u0010I\u00a8\u0006X"}, d2={"Lorg/gnit/lucenekmp/index/CheckIndex$Status;", "", "<init>", "()V", "clean", "", "getClean", "()Z", "setClean", "(Z)V", "missingSegments", "getMissingSegments", "setMissingSegments", "segmentsFileName", "", "getSegmentsFileName", "()Ljava/lang/String;", "setSegmentsFileName", "(Ljava/lang/String;)V", "numSegments", "", "getNumSegments", "()I", "setNumSegments", "(I)V", "segmentsChecked", "", "getSegmentsChecked", "()Ljava/util/List;", "setSegmentsChecked", "(Ljava/util/List;)V", "toolOutOfDate", "getToolOutOfDate", "setToolOutOfDate", "segmentInfos", "Lorg/gnit/lucenekmp/index/CheckIndex$Status$SegmentInfoStatus;", "getSegmentInfos", "setSegmentInfos", "dir", "Lorg/gnit/lucenekmp/store/Directory;", "getDir", "()Lorg/gnit/lucenekmp/store/Directory;", "setDir", "(Lorg/gnit/lucenekmp/store/Directory;)V", "newSegments", "Lorg/gnit/lucenekmp/index/SegmentInfos;", "getNewSegments", "()Lorg/gnit/lucenekmp/index/SegmentInfos;", "setNewSegments", "(Lorg/gnit/lucenekmp/index/SegmentInfos;)V", "totLoseDocCount", "getTotLoseDocCount", "setTotLoseDocCount", "numBadSegments", "getNumBadSegments", "setNumBadSegments", "partial", "getPartial", "setPartial", "maxSegmentName", "", "getMaxSegmentName", "()J", "setMaxSegmentName", "(J)V", "validCounter", "getValidCounter", "setValidCounter", "userData", "", "getUserData", "()Ljava/util/Map;", "setUserData", "(Ljava/util/Map;)V", "SegmentInfoStatus", "LiveDocStatus", "FieldInfoStatus", "FieldNormStatus", "TermIndexStatus", "StoredFieldStatus", "TermVectorStatus", "DocValuesStatus", "PointsStatus", "VectorValuesStatus", "HnswGraphStatus", "HnswGraphsStatus", "IndexSortStatus", "SoftDeletesStatus", "core"})
    public static final class Status {
        private boolean clean;
        private boolean missingSegments;
        @Nullable
        private String segmentsFileName;
        private int numSegments;
        @NotNull
        private List<String> segmentsChecked = new ArrayList();
        private boolean toolOutOfDate;
        @NotNull
        private List<SegmentInfoStatus> segmentInfos = new ArrayList();
        @Nullable
        private Directory dir;
        @Nullable
        private SegmentInfos newSegments;
        private int totLoseDocCount;
        private int numBadSegments;
        private boolean partial;
        private long maxSegmentName;
        private boolean validCounter;
        @Nullable
        private Map<String, String> userData;

        public final boolean getClean() {
            return this.clean;
        }

        public final void setClean(boolean bl) {
            this.clean = bl;
        }

        public final boolean getMissingSegments() {
            return this.missingSegments;
        }

        public final void setMissingSegments(boolean bl) {
            this.missingSegments = bl;
        }

        @Nullable
        public final String getSegmentsFileName() {
            return this.segmentsFileName;
        }

        public final void setSegmentsFileName(@Nullable String string) {
            this.segmentsFileName = string;
        }

        public final int getNumSegments() {
            return this.numSegments;
        }

        public final void setNumSegments(int n) {
            this.numSegments = n;
        }

        @NotNull
        public final List<String> getSegmentsChecked() {
            return this.segmentsChecked;
        }

        public final void setSegmentsChecked(@NotNull List<String> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.segmentsChecked = list;
        }

        public final boolean getToolOutOfDate() {
            return this.toolOutOfDate;
        }

        public final void setToolOutOfDate(boolean bl) {
            this.toolOutOfDate = bl;
        }

        @NotNull
        public final List<SegmentInfoStatus> getSegmentInfos() {
            return this.segmentInfos;
        }

        public final void setSegmentInfos(@NotNull List<SegmentInfoStatus> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.segmentInfos = list;
        }

        @Nullable
        public final Directory getDir() {
            return this.dir;
        }

        public final void setDir(@Nullable Directory directory) {
            this.dir = directory;
        }

        @Nullable
        public final SegmentInfos getNewSegments() {
            return this.newSegments;
        }

        public final void setNewSegments(@Nullable SegmentInfos segmentInfos) {
            this.newSegments = segmentInfos;
        }

        public final int getTotLoseDocCount() {
            return this.totLoseDocCount;
        }

        public final void setTotLoseDocCount(int n) {
            this.totLoseDocCount = n;
        }

        public final int getNumBadSegments() {
            return this.numBadSegments;
        }

        public final void setNumBadSegments(int n) {
            this.numBadSegments = n;
        }

        public final boolean getPartial() {
            return this.partial;
        }

        public final void setPartial(boolean bl) {
            this.partial = bl;
        }

        public final long getMaxSegmentName() {
            return this.maxSegmentName;
        }

        public final void setMaxSegmentName(long l) {
            this.maxSegmentName = l;
        }

        public final boolean getValidCounter() {
            return this.validCounter;
        }

        public final void setValidCounter(boolean bl) {
            this.validCounter = bl;
        }

        @Nullable
        public final Map<String, String> getUserData() {
            return this.userData;
        }

        public final void setUserData(@Nullable Map<String, String> map2) {
            this.userData = map2;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0017\n\u0002\u0010\u0003\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\t\b\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR\u001a\u0010\u0010\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\tR\u001a\u0010\u0013\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0007\"\u0004\b\u0015\u0010\tR\u001a\u0010\u0016\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0007\"\u0004\b\u0018\u0010\tR\u001a\u0010\u0019\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0007\"\u0004\b\u001b\u0010\tR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u0006\""}, d2={"Lorg/gnit/lucenekmp/index/CheckIndex$Status$DocValuesStatus;", "", "<init>", "()V", "totalValueFields", "", "getTotalValueFields", "()J", "setTotalValueFields", "(J)V", "totalNumericFields", "getTotalNumericFields", "setTotalNumericFields", "totalBinaryFields", "getTotalBinaryFields", "setTotalBinaryFields", "totalSortedFields", "getTotalSortedFields", "setTotalSortedFields", "totalSortedNumericFields", "getTotalSortedNumericFields", "setTotalSortedNumericFields", "totalSortedSetFields", "getTotalSortedSetFields", "setTotalSortedSetFields", "totalSkippingIndex", "getTotalSkippingIndex", "setTotalSkippingIndex", "error", "", "getError", "()Ljava/lang/Throwable;", "setError", "(Ljava/lang/Throwable;)V", "core"})
        public static final class DocValuesStatus {
            private long totalValueFields;
            private long totalNumericFields;
            private long totalBinaryFields;
            private long totalSortedFields;
            private long totalSortedNumericFields;
            private long totalSortedSetFields;
            private long totalSkippingIndex;
            @Nullable
            private Throwable error;

            public final long getTotalValueFields() {
                return this.totalValueFields;
            }

            public final void setTotalValueFields(long l) {
                this.totalValueFields = l;
            }

            public final long getTotalNumericFields() {
                return this.totalNumericFields;
            }

            public final void setTotalNumericFields(long l) {
                this.totalNumericFields = l;
            }

            public final long getTotalBinaryFields() {
                return this.totalBinaryFields;
            }

            public final void setTotalBinaryFields(long l) {
                this.totalBinaryFields = l;
            }

            public final long getTotalSortedFields() {
                return this.totalSortedFields;
            }

            public final void setTotalSortedFields(long l) {
                this.totalSortedFields = l;
            }

            public final long getTotalSortedNumericFields() {
                return this.totalSortedNumericFields;
            }

            public final void setTotalSortedNumericFields(long l) {
                this.totalSortedNumericFields = l;
            }

            public final long getTotalSortedSetFields() {
                return this.totalSortedSetFields;
            }

            public final void setTotalSortedSetFields(long l) {
                this.totalSortedSetFields = l;
            }

            public final long getTotalSkippingIndex() {
                return this.totalSkippingIndex;
            }

            public final void setTotalSkippingIndex(long l) {
                this.totalSkippingIndex = l;
            }

            @Nullable
            public final Throwable getError() {
                return this.error;
            }

            public final void setError(@Nullable Throwable throwable) {
                this.error = throwable;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/gnit/lucenekmp/index/CheckIndex$Status$FieldInfoStatus;", "", "<init>", "()V", "totFields", "", "getTotFields", "()J", "setTotFields", "(J)V", "error", "", "getError", "()Ljava/lang/Throwable;", "setError", "(Ljava/lang/Throwable;)V", "core"})
        public static final class FieldInfoStatus {
            private long totFields;
            @Nullable
            private Throwable error;

            public final long getTotFields() {
                return this.totFields;
            }

            public final void setTotFields(long l) {
                this.totFields = l;
            }

            @Nullable
            public final Throwable getError() {
                return this.error;
            }

            public final void setError(@Nullable Throwable throwable) {
                this.error = throwable;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/gnit/lucenekmp/index/CheckIndex$Status$FieldNormStatus;", "", "<init>", "()V", "totFields", "", "getTotFields", "()J", "setTotFields", "(J)V", "error", "", "getError", "()Ljava/lang/Throwable;", "setError", "(Ljava/lang/Throwable;)V", "core"})
        public static final class FieldNormStatus {
            private long totFields;
            @Nullable
            private Throwable error;

            public final long getTotFields() {
                return this.totFields;
            }

            public final void setTotFields(long l) {
                this.totFields = l;
            }

            @Nullable
            public final Throwable getError() {
                return this.error;
            }

            public final void setError(@Nullable Throwable throwable) {
                this.error = throwable;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\t\b\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003R$\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR$\u0010\f\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0012\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lorg/gnit/lucenekmp/index/CheckIndex$Status$HnswGraphStatus;", "", "<init>", "()V", "numNodesAtLevel", "", "", "getNumNodesAtLevel", "()[Ljava/lang/Integer;", "setNumNodesAtLevel", "([Ljava/lang/Integer;)V", "[Ljava/lang/Integer;", "connectednessAtLevel", "", "getConnectednessAtLevel", "()[Ljava/lang/String;", "setConnectednessAtLevel", "([Ljava/lang/String;)V", "[Ljava/lang/String;", "core"})
        public static final class HnswGraphStatus {
            @Nullable
            private Integer[] numNodesAtLevel;
            @Nullable
            private String[] connectednessAtLevel;

            @Nullable
            public final Integer[] getNumNodesAtLevel() {
                return this.numNodesAtLevel;
            }

            public final void setNumNodesAtLevel(@Nullable Integer[] integerArray) {
                this.numNodesAtLevel = integerArray;
            }

            @Nullable
            public final String[] getConnectednessAtLevel() {
                return this.connectednessAtLevel;
            }

            public final void setConnectednessAtLevel(@Nullable String[] stringArray) {
                this.connectednessAtLevel = stringArray;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\t\b\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003R&\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/gnit/lucenekmp/index/CheckIndex$Status$HnswGraphsStatus;", "", "<init>", "()V", "hnswGraphsStatusByField", "", "", "Lorg/gnit/lucenekmp/index/CheckIndex$Status$HnswGraphStatus;", "getHnswGraphsStatusByField", "()Ljava/util/Map;", "setHnswGraphsStatusByField", "(Ljava/util/Map;)V", "error", "", "getError", "()Ljava/lang/Throwable;", "setError", "(Ljava/lang/Throwable;)V", "core"})
        public static final class HnswGraphsStatus {
            @NotNull
            private Map<String, HnswGraphStatus> hnswGraphsStatusByField = new HashMap();
            @Nullable
            private Throwable error;

            @NotNull
            public final Map<String, HnswGraphStatus> getHnswGraphsStatusByField() {
                return this.hnswGraphsStatusByField;
            }

            public final void setHnswGraphsStatusByField(@NotNull Map<String, HnswGraphStatus> map2) {
                Intrinsics.checkNotNullParameter(map2, (String)"<set-?>");
                this.hnswGraphsStatusByField = map2;
            }

            @Nullable
            public final Throwable getError() {
                return this.error;
            }

            public final void setError(@Nullable Throwable throwable) {
                this.error = throwable;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\t\b\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/gnit/lucenekmp/index/CheckIndex$Status$IndexSortStatus;", "", "<init>", "()V", "error", "", "getError", "()Ljava/lang/Throwable;", "setError", "(Ljava/lang/Throwable;)V", "core"})
        public static final class IndexSortStatus {
            @Nullable
            private Throwable error;

            @Nullable
            public final Throwable getError() {
                return this.error;
            }

            public final void setError(@Nullable Throwable throwable) {
                this.error = throwable;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/gnit/lucenekmp/index/CheckIndex$Status$LiveDocStatus;", "", "<init>", "()V", "numDeleted", "", "getNumDeleted", "()I", "setNumDeleted", "(I)V", "error", "", "getError", "()Ljava/lang/Throwable;", "setError", "(Ljava/lang/Throwable;)V", "core"})
        public static final class LiveDocStatus {
            private int numDeleted;
            @Nullable
            private Throwable error;

            public final int getNumDeleted() {
                return this.numDeleted;
            }

            public final void setNumDeleted(int n) {
                this.numDeleted = n;
            }

            @Nullable
            public final Throwable getError() {
                return this.error;
            }

            public final void setError(@Nullable Throwable throwable) {
                this.error = throwable;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\t\b\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lorg/gnit/lucenekmp/index/CheckIndex$Status$PointsStatus;", "", "<init>", "()V", "totalValuePoints", "", "getTotalValuePoints", "()J", "setTotalValuePoints", "(J)V", "totalValueFields", "", "getTotalValueFields", "()I", "setTotalValueFields", "(I)V", "error", "", "getError", "()Ljava/lang/Throwable;", "setError", "(Ljava/lang/Throwable;)V", "core"})
        public static final class PointsStatus {
            private long totalValuePoints;
            private int totalValueFields;
            @Nullable
            private Throwable error;

            public final long getTotalValuePoints() {
                return this.totalValuePoints;
            }

            public final void setTotalValuePoints(long l) {
                this.totalValuePoints = l;
            }

            public final int getTotalValueFields() {
                return this.totalValueFields;
            }

            public final void setTotalValueFields(int n) {
                this.totalValueFields = n;
            }

            @Nullable
            public final Throwable getError() {
                return this.error;
            }

            public final void setError(@Nullable Throwable throwable) {
                this.error = throwable;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\t\b\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0013\"\u0004\b\u001e\u0010\u0015R\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0019\"\u0004\b'\u0010\u001bR\u001a\u0010(\u001a\u00020)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001a\u0010.\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u0019\"\u0004\b0\u0010\u001bR\u001a\u00101\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u0013\"\u0004\b3\u0010\u0015R(\u00104\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u000105X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u001c\u0010:\u001a\u0004\u0018\u00010;X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R\u001c\u0010@\u001a\u0004\u0018\u00010AX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010C\"\u0004\bD\u0010ER\u001c\u0010F\u001a\u0004\u0018\u00010GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bH\u0010I\"\u0004\bJ\u0010KR\u001c\u0010L\u001a\u0004\u0018\u00010MX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bN\u0010O\"\u0004\bP\u0010QR\u001c\u0010R\u001a\u0004\u0018\u00010SX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bT\u0010U\"\u0004\bV\u0010WR\u001c\u0010X\u001a\u0004\u0018\u00010YX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bZ\u0010[\"\u0004\b\\\u0010]R\u001c\u0010^\u001a\u0004\u0018\u00010_X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b`\u0010a\"\u0004\bb\u0010cR\u001c\u0010d\u001a\u0004\u0018\u00010eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bf\u0010g\"\u0004\bh\u0010iR\u001c\u0010j\u001a\u0004\u0018\u00010kX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bl\u0010m\"\u0004\bn\u0010oR\u001c\u0010p\u001a\u0004\u0018\u00010qX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\br\u0010s\"\u0004\bt\u0010uR\u001c\u0010v\u001a\u0004\u0018\u00010wX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bx\u0010y\"\u0004\bz\u0010{R\u001e\u0010|\u001a\u0004\u0018\u00010}X\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0004\b~\u0010\u007f\"\u0006\b\u0080\u0001\u0010\u0081\u0001R\"\u0010\u0082\u0001\u001a\u0005\u0018\u00010\u0083\u0001X\u0086\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u0084\u0001\u0010\u0085\u0001\"\u0006\b\u0086\u0001\u0010\u0087\u0001\u00a8\u0006\u0088\u0001"}, d2={"Lorg/gnit/lucenekmp/index/CheckIndex$Status$SegmentInfoStatus;", "", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "codec", "Lorg/gnit/lucenekmp/codecs/Codec;", "getCodec", "()Lorg/gnit/lucenekmp/codecs/Codec;", "setCodec", "(Lorg/gnit/lucenekmp/codecs/Codec;)V", "maxDoc", "", "getMaxDoc", "()I", "setMaxDoc", "(I)V", "compound", "", "getCompound", "()Z", "setCompound", "(Z)V", "numFiles", "getNumFiles", "setNumFiles", "sizeMB", "", "getSizeMB", "()D", "setSizeMB", "(D)V", "hasDeletions", "getHasDeletions", "setHasDeletions", "deletionsGen", "", "getDeletionsGen", "()J", "setDeletionsGen", "(J)V", "openReaderPassed", "getOpenReaderPassed", "setOpenReaderPassed", "toLoseDocCount", "getToLoseDocCount", "setToLoseDocCount", "diagnostics", "", "getDiagnostics", "()Ljava/util/Map;", "setDiagnostics", "(Ljava/util/Map;)V", "liveDocStatus", "Lorg/gnit/lucenekmp/index/CheckIndex$Status$LiveDocStatus;", "getLiveDocStatus", "()Lorg/gnit/lucenekmp/index/CheckIndex$Status$LiveDocStatus;", "setLiveDocStatus", "(Lorg/gnit/lucenekmp/index/CheckIndex$Status$LiveDocStatus;)V", "fieldInfoStatus", "Lorg/gnit/lucenekmp/index/CheckIndex$Status$FieldInfoStatus;", "getFieldInfoStatus", "()Lorg/gnit/lucenekmp/index/CheckIndex$Status$FieldInfoStatus;", "setFieldInfoStatus", "(Lorg/gnit/lucenekmp/index/CheckIndex$Status$FieldInfoStatus;)V", "fieldNormStatus", "Lorg/gnit/lucenekmp/index/CheckIndex$Status$FieldNormStatus;", "getFieldNormStatus", "()Lorg/gnit/lucenekmp/index/CheckIndex$Status$FieldNormStatus;", "setFieldNormStatus", "(Lorg/gnit/lucenekmp/index/CheckIndex$Status$FieldNormStatus;)V", "termIndexStatus", "Lorg/gnit/lucenekmp/index/CheckIndex$Status$TermIndexStatus;", "getTermIndexStatus", "()Lorg/gnit/lucenekmp/index/CheckIndex$Status$TermIndexStatus;", "setTermIndexStatus", "(Lorg/gnit/lucenekmp/index/CheckIndex$Status$TermIndexStatus;)V", "storedFieldStatus", "Lorg/gnit/lucenekmp/index/CheckIndex$Status$StoredFieldStatus;", "getStoredFieldStatus", "()Lorg/gnit/lucenekmp/index/CheckIndex$Status$StoredFieldStatus;", "setStoredFieldStatus", "(Lorg/gnit/lucenekmp/index/CheckIndex$Status$StoredFieldStatus;)V", "termVectorStatus", "Lorg/gnit/lucenekmp/index/CheckIndex$Status$TermVectorStatus;", "getTermVectorStatus", "()Lorg/gnit/lucenekmp/index/CheckIndex$Status$TermVectorStatus;", "setTermVectorStatus", "(Lorg/gnit/lucenekmp/index/CheckIndex$Status$TermVectorStatus;)V", "docValuesStatus", "Lorg/gnit/lucenekmp/index/CheckIndex$Status$DocValuesStatus;", "getDocValuesStatus", "()Lorg/gnit/lucenekmp/index/CheckIndex$Status$DocValuesStatus;", "setDocValuesStatus", "(Lorg/gnit/lucenekmp/index/CheckIndex$Status$DocValuesStatus;)V", "pointsStatus", "Lorg/gnit/lucenekmp/index/CheckIndex$Status$PointsStatus;", "getPointsStatus", "()Lorg/gnit/lucenekmp/index/CheckIndex$Status$PointsStatus;", "setPointsStatus", "(Lorg/gnit/lucenekmp/index/CheckIndex$Status$PointsStatus;)V", "indexSortStatus", "Lorg/gnit/lucenekmp/index/CheckIndex$Status$IndexSortStatus;", "getIndexSortStatus", "()Lorg/gnit/lucenekmp/index/CheckIndex$Status$IndexSortStatus;", "setIndexSortStatus", "(Lorg/gnit/lucenekmp/index/CheckIndex$Status$IndexSortStatus;)V", "vectorValuesStatus", "Lorg/gnit/lucenekmp/index/CheckIndex$Status$VectorValuesStatus;", "getVectorValuesStatus", "()Lorg/gnit/lucenekmp/index/CheckIndex$Status$VectorValuesStatus;", "setVectorValuesStatus", "(Lorg/gnit/lucenekmp/index/CheckIndex$Status$VectorValuesStatus;)V", "hnswGraphsStatus", "Lorg/gnit/lucenekmp/index/CheckIndex$Status$HnswGraphsStatus;", "getHnswGraphsStatus", "()Lorg/gnit/lucenekmp/index/CheckIndex$Status$HnswGraphsStatus;", "setHnswGraphsStatus", "(Lorg/gnit/lucenekmp/index/CheckIndex$Status$HnswGraphsStatus;)V", "softDeletesStatus", "Lorg/gnit/lucenekmp/index/CheckIndex$Status$SoftDeletesStatus;", "getSoftDeletesStatus", "()Lorg/gnit/lucenekmp/index/CheckIndex$Status$SoftDeletesStatus;", "setSoftDeletesStatus", "(Lorg/gnit/lucenekmp/index/CheckIndex$Status$SoftDeletesStatus;)V", "error", "", "getError", "()Ljava/lang/Throwable;", "setError", "(Ljava/lang/Throwable;)V", "core"})
        public static final class SegmentInfoStatus {
            @Nullable
            private String name;
            @Nullable
            private Codec codec;
            private int maxDoc;
            private boolean compound;
            private int numFiles;
            private double sizeMB;
            private boolean hasDeletions;
            private long deletionsGen;
            private boolean openReaderPassed;
            private int toLoseDocCount;
            @Nullable
            private Map<String, String> diagnostics;
            @Nullable
            private LiveDocStatus liveDocStatus;
            @Nullable
            private FieldInfoStatus fieldInfoStatus;
            @Nullable
            private FieldNormStatus fieldNormStatus;
            @Nullable
            private TermIndexStatus termIndexStatus;
            @Nullable
            private StoredFieldStatus storedFieldStatus;
            @Nullable
            private TermVectorStatus termVectorStatus;
            @Nullable
            private DocValuesStatus docValuesStatus;
            @Nullable
            private PointsStatus pointsStatus;
            @Nullable
            private IndexSortStatus indexSortStatus;
            @Nullable
            private VectorValuesStatus vectorValuesStatus;
            @Nullable
            private HnswGraphsStatus hnswGraphsStatus;
            @Nullable
            private SoftDeletesStatus softDeletesStatus;
            @Nullable
            private Throwable error;

            @Nullable
            public final String getName() {
                return this.name;
            }

            public final void setName(@Nullable String string) {
                this.name = string;
            }

            @Nullable
            public final Codec getCodec() {
                return this.codec;
            }

            public final void setCodec(@Nullable Codec codec) {
                this.codec = codec;
            }

            public final int getMaxDoc() {
                return this.maxDoc;
            }

            public final void setMaxDoc(int n) {
                this.maxDoc = n;
            }

            public final boolean getCompound() {
                return this.compound;
            }

            public final void setCompound(boolean bl) {
                this.compound = bl;
            }

            public final int getNumFiles() {
                return this.numFiles;
            }

            public final void setNumFiles(int n) {
                this.numFiles = n;
            }

            public final double getSizeMB() {
                return this.sizeMB;
            }

            public final void setSizeMB(double d) {
                this.sizeMB = d;
            }

            public final boolean getHasDeletions() {
                return this.hasDeletions;
            }

            public final void setHasDeletions(boolean bl) {
                this.hasDeletions = bl;
            }

            public final long getDeletionsGen() {
                return this.deletionsGen;
            }

            public final void setDeletionsGen(long l) {
                this.deletionsGen = l;
            }

            public final boolean getOpenReaderPassed() {
                return this.openReaderPassed;
            }

            public final void setOpenReaderPassed(boolean bl) {
                this.openReaderPassed = bl;
            }

            public final int getToLoseDocCount() {
                return this.toLoseDocCount;
            }

            public final void setToLoseDocCount(int n) {
                this.toLoseDocCount = n;
            }

            @Nullable
            public final Map<String, String> getDiagnostics() {
                return this.diagnostics;
            }

            public final void setDiagnostics(@Nullable Map<String, String> map2) {
                this.diagnostics = map2;
            }

            @Nullable
            public final LiveDocStatus getLiveDocStatus() {
                return this.liveDocStatus;
            }

            public final void setLiveDocStatus(@Nullable LiveDocStatus liveDocStatus) {
                this.liveDocStatus = liveDocStatus;
            }

            @Nullable
            public final FieldInfoStatus getFieldInfoStatus() {
                return this.fieldInfoStatus;
            }

            public final void setFieldInfoStatus(@Nullable FieldInfoStatus fieldInfoStatus) {
                this.fieldInfoStatus = fieldInfoStatus;
            }

            @Nullable
            public final FieldNormStatus getFieldNormStatus() {
                return this.fieldNormStatus;
            }

            public final void setFieldNormStatus(@Nullable FieldNormStatus fieldNormStatus) {
                this.fieldNormStatus = fieldNormStatus;
            }

            @Nullable
            public final TermIndexStatus getTermIndexStatus() {
                return this.termIndexStatus;
            }

            public final void setTermIndexStatus(@Nullable TermIndexStatus termIndexStatus) {
                this.termIndexStatus = termIndexStatus;
            }

            @Nullable
            public final StoredFieldStatus getStoredFieldStatus() {
                return this.storedFieldStatus;
            }

            public final void setStoredFieldStatus(@Nullable StoredFieldStatus storedFieldStatus) {
                this.storedFieldStatus = storedFieldStatus;
            }

            @Nullable
            public final TermVectorStatus getTermVectorStatus() {
                return this.termVectorStatus;
            }

            public final void setTermVectorStatus(@Nullable TermVectorStatus termVectorStatus) {
                this.termVectorStatus = termVectorStatus;
            }

            @Nullable
            public final DocValuesStatus getDocValuesStatus() {
                return this.docValuesStatus;
            }

            public final void setDocValuesStatus(@Nullable DocValuesStatus docValuesStatus) {
                this.docValuesStatus = docValuesStatus;
            }

            @Nullable
            public final PointsStatus getPointsStatus() {
                return this.pointsStatus;
            }

            public final void setPointsStatus(@Nullable PointsStatus pointsStatus) {
                this.pointsStatus = pointsStatus;
            }

            @Nullable
            public final IndexSortStatus getIndexSortStatus() {
                return this.indexSortStatus;
            }

            public final void setIndexSortStatus(@Nullable IndexSortStatus indexSortStatus) {
                this.indexSortStatus = indexSortStatus;
            }

            @Nullable
            public final VectorValuesStatus getVectorValuesStatus() {
                return this.vectorValuesStatus;
            }

            public final void setVectorValuesStatus(@Nullable VectorValuesStatus vectorValuesStatus) {
                this.vectorValuesStatus = vectorValuesStatus;
            }

            @Nullable
            public final HnswGraphsStatus getHnswGraphsStatus() {
                return this.hnswGraphsStatus;
            }

            public final void setHnswGraphsStatus(@Nullable HnswGraphsStatus hnswGraphsStatus) {
                this.hnswGraphsStatus = hnswGraphsStatus;
            }

            @Nullable
            public final SoftDeletesStatus getSoftDeletesStatus() {
                return this.softDeletesStatus;
            }

            public final void setSoftDeletesStatus(@Nullable SoftDeletesStatus softDeletesStatus) {
                this.softDeletesStatus = softDeletesStatus;
            }

            @Nullable
            public final Throwable getError() {
                return this.error;
            }

            public final void setError(@Nullable Throwable throwable) {
                this.error = throwable;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\t\b\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/gnit/lucenekmp/index/CheckIndex$Status$SoftDeletesStatus;", "", "<init>", "()V", "error", "", "getError", "()Ljava/lang/Throwable;", "setError", "(Ljava/lang/Throwable;)V", "core"})
        public static final class SoftDeletesStatus {
            @Nullable
            private Throwable error;

            @Nullable
            public final Throwable getError() {
                return this.error;
            }

            public final void setError(@Nullable Throwable throwable) {
                this.error = throwable;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\t\b\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lorg/gnit/lucenekmp/index/CheckIndex$Status$StoredFieldStatus;", "", "<init>", "()V", "docCount", "", "getDocCount", "()I", "setDocCount", "(I)V", "totFields", "", "getTotFields", "()J", "setTotFields", "(J)V", "error", "", "getError", "()Ljava/lang/Throwable;", "setError", "(Ljava/lang/Throwable;)V", "core"})
        public static final class StoredFieldStatus {
            private int docCount;
            private long totFields;
            @Nullable
            private Throwable error;

            public final int getDocCount() {
                return this.docCount;
            }

            public final void setDocCount(int n) {
                this.docCount = n;
            }

            public final long getTotFields() {
                return this.totFields;
            }

            public final void setTotFields(long l) {
                this.totFields = l;
            }

            @Nullable
            public final Throwable getError() {
                return this.error;
            }

            public final void setError(@Nullable Throwable throwable) {
                this.error = throwable;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\t\b\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR\u001a\u0010\u0010\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\tR\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R(\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Lorg/gnit/lucenekmp/index/CheckIndex$Status$TermIndexStatus;", "", "<init>", "()V", "termCount", "", "getTermCount", "()J", "setTermCount", "(J)V", "delTermCount", "getDelTermCount", "setDelTermCount", "totFreq", "getTotFreq", "setTotFreq", "totPos", "getTotPos", "setTotPos", "error", "", "getError", "()Ljava/lang/Throwable;", "setError", "(Ljava/lang/Throwable;)V", "blockTreeStats", "", "", "getBlockTreeStats", "()Ljava/util/Map;", "setBlockTreeStats", "(Ljava/util/Map;)V", "core"})
        public static final class TermIndexStatus {
            private long termCount;
            private long delTermCount;
            private long totFreq;
            private long totPos;
            @Nullable
            private Throwable error;
            @Nullable
            private Map<String, Object> blockTreeStats;

            public final long getTermCount() {
                return this.termCount;
            }

            public final void setTermCount(long l) {
                this.termCount = l;
            }

            public final long getDelTermCount() {
                return this.delTermCount;
            }

            public final void setDelTermCount(long l) {
                this.delTermCount = l;
            }

            public final long getTotFreq() {
                return this.totFreq;
            }

            public final void setTotFreq(long l) {
                this.totFreq = l;
            }

            public final long getTotPos() {
                return this.totPos;
            }

            public final void setTotPos(long l) {
                this.totPos = l;
            }

            @Nullable
            public final Throwable getError() {
                return this.error;
            }

            public final void setError(@Nullable Throwable throwable) {
                this.error = throwable;
            }

            @Nullable
            public final Map<String, Object> getBlockTreeStats() {
                return this.blockTreeStats;
            }

            public final void setBlockTreeStats(@Nullable Map<String, Object> map2) {
                this.blockTreeStats = map2;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\t\b\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lorg/gnit/lucenekmp/index/CheckIndex$Status$TermVectorStatus;", "", "<init>", "()V", "docCount", "", "getDocCount", "()I", "setDocCount", "(I)V", "totVectors", "", "getTotVectors", "()J", "setTotVectors", "(J)V", "error", "", "getError", "()Ljava/lang/Throwable;", "setError", "(Ljava/lang/Throwable;)V", "core"})
        public static final class TermVectorStatus {
            private int docCount;
            private long totVectors;
            @Nullable
            private Throwable error;

            public final int getDocCount() {
                return this.docCount;
            }

            public final void setDocCount(int n) {
                this.docCount = n;
            }

            public final long getTotVectors() {
                return this.totVectors;
            }

            public final void setTotVectors(long l) {
                this.totVectors = l;
            }

            @Nullable
            public final Throwable getError() {
                return this.error;
            }

            public final void setError(@Nullable Throwable throwable) {
                this.error = throwable;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\t\b\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lorg/gnit/lucenekmp/index/CheckIndex$Status$VectorValuesStatus;", "", "<init>", "()V", "totalVectorValues", "", "getTotalVectorValues", "()J", "setTotalVectorValues", "(J)V", "totalKnnVectorFields", "", "getTotalKnnVectorFields", "()I", "setTotalKnnVectorFields", "(I)V", "error", "", "getError", "()Ljava/lang/Throwable;", "setError", "(Ljava/lang/Throwable;)V", "core"})
        public static final class VectorValuesStatus {
            private long totalVectorValues;
            private int totalKnnVectorFields;
            @Nullable
            private Throwable error;

            public final long getTotalVectorValues() {
                return this.totalVectorValues;
            }

            public final void setTotalVectorValues(long l) {
                this.totalVectorValues = l;
            }

            public final int getTotalKnnVectorFields() {
                return this.totalKnnVectorFields;
            }

            public final void setTotalKnnVectorFields(int n) {
                this.totalKnnVectorFields = n;
            }

            @Nullable
            public final Throwable getError() {
                return this.error;
            }

            public final void setError(@Nullable Throwable throwable) {
                this.error = throwable;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0005H\u0016J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0013H\u0016J\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020\u0013H\u0016J \u0010)\u001a\u00020\"2\u0006\u0010*\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001f\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u000e\u00a8\u0006+"}, d2={"Lorg/gnit/lucenekmp/index/CheckIndex$VerifyPointsVisitor;", "Lorg/gnit/lucenekmp/index/PointValues$IntersectVisitor;", "fieldName", "", "maxDoc", "", "values", "Lorg/gnit/lucenekmp/index/PointValues;", "<init>", "(Ljava/lang/String;ILorg/gnit/lucenekmp/index/PointValues;)V", "value", "", "pointCountSeen", "getPointCountSeen", "()J", "lastDocID", "docsSeen", "Lorg/gnit/lucenekmp/util/FixedBitSet;", "lastMinPackedValue", "", "lastMaxPackedValue", "lastPackedValue", "globalMinPackedValue", "globalMaxPackedValue", "packedBytesCount", "packedIndexBytesCount", "numDataDims", "numIndexDims", "bytesPerDim", "comparator", "Lorg/gnit/lucenekmp/util/ArrayUtil$Companion$ByteArrayComparator;", "docCountSeen", "getDocCountSeen", "visit", "", "docID", "packedValue", "compare", "Lorg/gnit/lucenekmp/index/PointValues$Relation;", "minPackedValue", "maxPackedValue", "checkPackedValue", "desc", "core"})
    public static final class VerifyPointsVisitor
    implements PointValues.IntersectVisitor {
        @NotNull
        private final String fieldName;
        private long pointCountSeen;
        private int lastDocID;
        @NotNull
        private final FixedBitSet docsSeen;
        @NotNull
        private final byte[] lastMinPackedValue;
        @NotNull
        private final byte[] lastMaxPackedValue;
        @NotNull
        private final byte[] lastPackedValue;
        @NotNull
        private final byte[] globalMinPackedValue;
        @NotNull
        private final byte[] globalMaxPackedValue;
        private final int packedBytesCount;
        private final int packedIndexBytesCount;
        private final int numDataDims;
        private final int numIndexDims;
        private final int bytesPerDim;
        @NotNull
        private final ArrayUtil.Companion.ByteArrayComparator comparator;

        public VerifyPointsVisitor(@NotNull String fieldName, int maxDoc, @NotNull PointValues values2) {
            Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
            Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
            this.fieldName = fieldName;
            this.lastDocID = -1;
            this.numDataDims = values2.getNumDimensions();
            this.numIndexDims = values2.getNumIndexDimensions();
            this.bytesPerDim = values2.getBytesPerDimension();
            this.comparator = ArrayUtil.Companion.getUnsignedComparator(this.bytesPerDim);
            this.packedBytesCount = this.numDataDims * this.bytesPerDim;
            this.packedIndexBytesCount = this.numIndexDims * this.bytesPerDim;
            this.globalMinPackedValue = values2.getMinPackedValue();
            this.globalMaxPackedValue = values2.getMaxPackedValue();
            this.docsSeen = new FixedBitSet(maxDoc);
            this.lastMinPackedValue = new byte[this.packedIndexBytesCount];
            this.lastMaxPackedValue = new byte[this.packedIndexBytesCount];
            this.lastPackedValue = new byte[this.packedBytesCount];
            if ((long)values2.getDocCount() > values2.size()) {
                throw new CheckIndexException("point values for field \"" + this.fieldName + "\" claims to have size=" + values2.size() + " points and inconsistent docCount=" + values2.getDocCount());
            }
            if (values2.getDocCount() > maxDoc) {
                throw new CheckIndexException("point values for field \"" + this.fieldName + "\" claims to have docCount=" + values2.getDocCount() + " but that's greater than maxDoc=" + maxDoc);
            }
            if (this.globalMinPackedValue == null) {
                if (values2.size() != 0L) {
                    throw new CheckIndexException("getMinPackedValue is null points for field \"" + this.fieldName + "\" yet size=" + values2.size());
                }
            } else if (this.globalMinPackedValue.length != this.packedIndexBytesCount) {
                throw new CheckIndexException("getMinPackedValue for field \"" + this.fieldName + "\" return length=" + this.globalMinPackedValue.length + " array, but should be " + this.packedBytesCount);
            }
            if (this.globalMaxPackedValue == null) {
                if (values2.size() != 0L) {
                    throw new CheckIndexException("getMaxPackedValue is null points for field \"" + this.fieldName + "\" yet size=" + values2.size());
                }
            } else if (this.globalMaxPackedValue.length != this.packedIndexBytesCount) {
                throw new CheckIndexException("getMaxPackedValue for field \"" + this.fieldName + "\" return length=" + this.globalMaxPackedValue.length + " array, but should be " + this.packedBytesCount);
            }
        }

        public final long getPointCountSeen() {
            return this.pointCountSeen;
        }

        public final long getDocCountSeen() {
            return this.docsSeen.cardinality();
        }

        @Override
        public void visit(int docID) {
            throw new CheckIndexException("codec called IntersectVisitor.visit without a packed value for docID=" + docID);
        }

        @Override
        public void visit(int docID, @NotNull byte[] packedValue) {
            Intrinsics.checkNotNullParameter((Object)packedValue, (String)"packedValue");
            this.checkPackedValue("packed value", packedValue, docID);
            long l = this.pointCountSeen;
            this.pointCountSeen = l + 1L;
            this.docsSeen.set(docID);
            int n = this.numIndexDims;
            for (int dim = 0; dim < n; ++dim) {
                int offset = this.bytesPerDim * dim;
                if (this.comparator.compare(packedValue, offset, this.lastMinPackedValue, offset) < 0) {
                    String string = Arrays.toString(packedValue);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    String string2 = Arrays.toString(this.lastMinPackedValue);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                    String string3 = Arrays.toString(this.lastMaxPackedValue);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
                    throw new CheckIndexException("packed points value " + string + " for field=\"" + this.fieldName + "\", docID=" + docID + " is out-of-bounds of the last cell min=" + string2 + " max=" + string3 + " dim=" + dim);
                }
                if (this.comparator.compare(packedValue, offset, this.lastMaxPackedValue, offset) <= 0) continue;
                String string = Arrays.toString(packedValue);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                String string4 = Arrays.toString(this.lastMinPackedValue);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
                String string5 = Arrays.toString(this.lastMaxPackedValue);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(...)");
                throw new CheckIndexException("packed points value " + string + " for field=\"" + this.fieldName + "\", docID=" + docID + " is out-of-bounds of the last cell min=" + string4 + " max=" + string5 + " dim=" + dim);
            }
            if (this.numDataDims == 1) {
                int cmp = this.comparator.compare(this.lastPackedValue, 0, packedValue, 0);
                if (cmp > 0) {
                    String string = Arrays.toString(packedValue);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    String string6 = Arrays.toString(this.lastPackedValue);
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toString(...)");
                    throw new CheckIndexException("packed points value " + string + " for field=\"" + this.fieldName + "\", for docID=" + docID + " is out-of-order vs the previous document's value " + string6);
                }
                if (cmp == 0 && docID < this.lastDocID) {
                    throw new CheckIndexException("packed points value is the same, but docID=" + docID + " is out of order vs previous docID=" + this.lastDocID + ", field=\"" + this.fieldName + "\"");
                }
                org.gnit.lucenekmp.jdkport.System.INSTANCE.arraycopy(packedValue, 0, this.lastPackedValue, 0, this.bytesPerDim);
                this.lastDocID = docID;
            }
        }

        @Override
        @NotNull
        public PointValues.Relation compare(@NotNull byte[] minPackedValue, @NotNull byte[] maxPackedValue) {
            Intrinsics.checkNotNullParameter((Object)minPackedValue, (String)"minPackedValue");
            Intrinsics.checkNotNullParameter((Object)maxPackedValue, (String)"maxPackedValue");
            this.checkPackedValue("min packed value", minPackedValue, -1);
            org.gnit.lucenekmp.jdkport.System.INSTANCE.arraycopy(minPackedValue, 0, this.lastMinPackedValue, 0, this.packedIndexBytesCount);
            this.checkPackedValue("max packed value", maxPackedValue, -1);
            org.gnit.lucenekmp.jdkport.System.INSTANCE.arraycopy(maxPackedValue, 0, this.lastMaxPackedValue, 0, this.packedIndexBytesCount);
            int n = this.numIndexDims;
            for (int dim = 0; dim < n; ++dim) {
                int offset = this.bytesPerDim * dim;
                if (this.comparator.compare(minPackedValue, offset, maxPackedValue, offset) > 0) {
                    String string = Arrays.toString(minPackedValue);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    String string2 = Arrays.toString(maxPackedValue);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                    throw new CheckIndexException("packed points cell minPackedValue " + string + " is out-of-bounds of the cell's maxPackedValue " + string2 + " dim=" + dim + " field=\"" + this.fieldName + "\"");
                }
                if (this.comparator.compare(minPackedValue, offset, this.globalMinPackedValue, offset) < 0) {
                    String string = Arrays.toString(minPackedValue);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    String string3 = Arrays.toString(this.globalMinPackedValue);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
                    throw new CheckIndexException("packed points cell minPackedValue " + string + " is out-of-bounds of the global minimum " + string3 + " dim=" + dim + " field=\"" + this.fieldName + "\"");
                }
                if (this.comparator.compare(maxPackedValue, offset, this.globalMinPackedValue, offset) < 0) {
                    String string = Arrays.toString(maxPackedValue);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    String string4 = Arrays.toString(this.globalMinPackedValue);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
                    throw new CheckIndexException("packed points cell maxPackedValue " + string + " is out-of-bounds of the global minimum " + string4 + " dim=" + dim + " field=\"" + this.fieldName + "\"");
                }
                if (this.comparator.compare(minPackedValue, offset, this.globalMaxPackedValue, offset) > 0) {
                    String string = Arrays.toString(minPackedValue);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    String string5 = Arrays.toString(this.globalMaxPackedValue);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(...)");
                    throw new CheckIndexException("packed points cell minPackedValue " + string + " is out-of-bounds of the global maximum " + string5 + " dim=" + dim + " field=\"" + this.fieldName + "\"");
                }
                if (this.comparator.compare(maxPackedValue, offset, this.globalMaxPackedValue, offset) <= 0) continue;
                String string = Arrays.toString(maxPackedValue);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                String string6 = Arrays.toString(this.globalMaxPackedValue);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toString(...)");
                throw new CheckIndexException("packed points cell maxPackedValue " + string + " is out-of-bounds of the global maximum " + string6 + " dim=" + dim + " field=\"" + this.fieldName + "\"");
            }
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }

        private final void checkPackedValue(String desc, byte[] packedValue, int docID) {
            if (packedValue == null) {
                throw new CheckIndexException(desc + " is null for docID=" + docID + " field=\"" + this.fieldName + "\"");
            }
            if (packedValue.length != (docID < 0 ? this.packedIndexBytesCount : this.packedBytesCount)) {
                throw new CheckIndexException(desc + " has incorrect length=" + packedValue.length + " vs expected=" + this.packedIndexBytesCount + " for docID=" + docID + " field=\"" + this.fieldName + "\"");
            }
        }

        @Override
        public void visit(@NotNull DocIdSetIterator iterator2) throws IOException {
            PointValues.IntersectVisitor.super.visit(iterator2);
        }

        @Override
        public void visit(@NotNull IntsRef ref) throws IOException {
            PointValues.IntersectVisitor.super.visit(ref);
        }

        @Override
        public void visit(@NotNull DocIdSetIterator iterator2, @NotNull byte[] packedValue) throws IOException {
            PointValues.IntersectVisitor.super.visit(iterator2, packedValue);
        }

        @Override
        public void grow(int count) {
            PointValues.IntersectVisitor.super.grow(count);
        }
    }
}

