/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.Job;
import org.gnit.lucenekmp.index.ApproximatePriorityQueue;
import org.gnit.lucenekmp.jdkport.Lock;
import org.gnit.lucenekmp.jdkport.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0000\u0018\u0000 #*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001#B\u0013\b\u0007\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\u0018H\u0086@\u00a2\u0006\u0002\u0010\u0019J$\u0010\u001a\u001a\u0004\u0018\u00018\u00002\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001d0\u001cH\u0086@\u00a2\u0006\u0002\u0010\u001eJ\u0013\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00028\u0000\u00a2\u0006\u0002\u0010!J\u0013\u0010\"\u001a\u00020\u001d2\u0006\u0010 \u001a\u00028\u0000\u00a2\u0006\u0002\u0010!R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u001f\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00100\n\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006$"}, d2={"Lorg/gnit/lucenekmp/index/ConcurrentApproximatePriorityQueue;", "T", "", "concurrency", "", "<init>", "(I)V", "getConcurrency", "()I", "locks", "", "Lorg/gnit/lucenekmp/jdkport/Lock;", "getLocks", "()[Lorg/gnit/lucenekmp/jdkport/Lock;", "[Lorg/gnit/lucenekmp/jdkport/Lock;", "queues", "Lorg/gnit/lucenekmp/index/ApproximatePriorityQueue;", "getQueues", "()[Lorg/gnit/lucenekmp/index/ApproximatePriorityQueue;", "[Lorg/gnit/lucenekmp/index/ApproximatePriorityQueue;", "add", "", "entry", "weight", "", "(Ljava/lang/Object;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "poll", "predicate", "Lkotlin/Function1;", "", "(Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "contains", "o", "(Ljava/lang/Object;)Z", "remove", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nConcurrentApproximatePriorityQueue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConcurrentApproximatePriorityQueue.kt\norg/gnit/lucenekmp/index/ConcurrentApproximatePriorityQueue\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 4 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,163:1\n1#2:164\n3#3,8:165\n10#4:173\n*S KotlinDebug\n*F\n+ 1 ConcurrentApproximatePriorityQueue.kt\norg/gnit/lucenekmp/index/ConcurrentApproximatePriorityQueue\n*L\n109#1:165,8\n109#1:173\n*E\n"})
public final class ConcurrentApproximatePriorityQueue<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int concurrency;
    @NotNull
    private final Lock[] locks;
    @NotNull
    private final ApproximatePriorityQueue<T>[] queues;
    public static final int MIN_CONCURRENCY = 1;
    public static final int MAX_CONCURRENCY = 256;

    @JvmOverloads
    public ConcurrentApproximatePriorityQueue(int concurrency) {
        if (!(concurrency >= 1 && concurrency <= 256)) {
            boolean $i$a$-require-ConcurrentApproximatePriorityQueue$22 = false;
            String $i$a$-require-ConcurrentApproximatePriorityQueue$22 = "concurrency must be in [1, 256], got " + concurrency;
            throw new IllegalArgumentException($i$a$-require-ConcurrentApproximatePriorityQueue$22.toString());
        }
        this.concurrency = concurrency;
        this.locks = new Lock[concurrency];
        ApproximatePriorityQueue[] queues = new ApproximatePriorityQueue[concurrency];
        this.queues = queues;
        for (int i = 0; i < concurrency; ++i) {
            queues[i] = new ApproximatePriorityQueue();
            this.locks[i] = new ReentrantLock();
        }
    }

    public /* synthetic */ ConcurrentApproximatePriorityQueue(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = ConcurrentApproximatePriorityQueue.Companion.getConcurrency();
        }
        this(n);
    }

    public final int getConcurrency() {
        return this.concurrency;
    }

    @NotNull
    public final Lock[] getLocks() {
        return this.locks;
    }

    @NotNull
    public final ApproximatePriorityQueue<T>[] getQueues() {
        return this.queues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Object add(T entry, long weight, @NotNull Continuation<? super Unit> $completion) {
        Job job2 = (Job)$completion.getContext().get((CoroutineContext.Key)Job.Key);
        int threadHash = job2 != null ? job2.hashCode() & 0xFFFF : 0;
        int n = this.concurrency;
        for (int i = 0; i < n; ++i) {
            int index = (threadHash + i) % this.concurrency;
            Lock lock2 = this.locks[index];
            ApproximatePriorityQueue<T> queue2 = this.queues[index];
            if (!lock2.tryLock()) continue;
            try {
                queue2.add(entry, weight);
                Unit unit = Unit.INSTANCE;
                return unit;
            }
            finally {
                lock2.unlock();
            }
        }
        int index = threadHash % this.concurrency;
        Lock lock3 = this.locks[index];
        ApproximatePriorityQueue<T> queue3 = this.queues[index];
        lock3.lock();
        try {
            queue3.add(entry, weight);
        }
        finally {
            lock3.unlock();
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Object poll(@NotNull Function1<? super T, Boolean> predicate, @NotNull Continuation<? super T> $completion) {
        T entry;
        ApproximatePriorityQueue<Object> queue2;
        Lock lock2;
        int index;
        int i;
        Job job2 = (Job)$completion.getContext().get((CoroutineContext.Key)Job.Key);
        int threadHash = job2 != null ? job2.hashCode() & 0xFFFF : 0;
        int n = this.concurrency;
        for (i = 0; i < n; ++i) {
            index = (threadHash + i) % this.concurrency;
            lock2 = this.locks[index];
            queue2 = this.queues[index];
            if (!lock2.tryLock()) continue;
            try {
                entry = queue2.poll(predicate);
                if (entry == null) continue;
                T t = entry;
                return t;
            }
            finally {
                lock2.unlock();
            }
        }
        n = this.concurrency;
        for (i = 0; i < n; ++i) {
            index = (threadHash + i) % this.concurrency;
            lock2 = this.locks[index];
            queue2 = this.queues[index];
            lock2.lock();
            try {
                entry = queue2.poll(predicate);
                if (entry == null) continue;
                T t = entry;
                return t;
            }
            finally {
                lock2.unlock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean contains(T o) {
        boolean bl;
        boolean assertionsAreEnabled = false;
        boolean it = bl = true;
        boolean bl2 = false;
        assertionsAreEnabled = it;
        boolean condition$iv = bl;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean $i$a$-assert-AssertKt$assert$22 = false;
            String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
        }
        if (!assertionsAreEnabled) {
            throw new AssertionError((Object)"contains should only be used for assertions");
        }
        int n = this.concurrency;
        for (int i = 0; i < n; ++i) {
            Lock lock2 = this.locks[i];
            ApproximatePriorityQueue<T> queue2 = this.queues[i];
            lock2.lock();
            try {
                if (!queue2.contains(o)) continue;
                boolean bl3 = true;
                return bl3;
            }
            finally {
                lock2.unlock();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean remove(T o) {
        int n = this.concurrency;
        for (int i = 0; i < n; ++i) {
            Lock lock2 = this.locks[i];
            ApproximatePriorityQueue<T> queue2 = this.queues[i];
            lock2.lock();
            try {
                if (!queue2.remove(o)) continue;
                boolean bl = true;
                return bl;
            }
            finally {
                lock2.unlock();
            }
        }
        return false;
    }

    @JvmOverloads
    public ConcurrentApproximatePriorityQueue() {
        this(0, 1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/gnit/lucenekmp/index/ConcurrentApproximatePriorityQueue$Companion;", "", "<init>", "()V", "MIN_CONCURRENCY", "", "MAX_CONCURRENCY", "getConcurrency", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final int getConcurrency() {
            int coreCount = 1;
            int concurrency = coreCount / 4;
            concurrency = Math.max(1, concurrency);
            concurrency = Math.min(256, concurrency);
            return concurrency;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

