/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import dev.scottpierce.envvar.EnvVar;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.concurrent.atomics.AtomicsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.TimeoutKt;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.gnit.lucenekmp.index.ConcurrentMergeScheduler;
import org.gnit.lucenekmp.index.MergePolicy;
import org.gnit.lucenekmp.index.MergeRateLimiter;
import org.gnit.lucenekmp.index.MergeScheduler;
import org.gnit.lucenekmp.index.MergeTrigger;
import org.gnit.lucenekmp.index.SegmentCommitInfo;
import org.gnit.lucenekmp.internal.tests.TestSecrets;
import org.gnit.lucenekmp.jdkport.AtomicIntExtKt;
import org.gnit.lucenekmp.jdkport.Executor;
import org.gnit.lucenekmp.jdkport.InterruptedException;
import org.gnit.lucenekmp.jdkport.LinkedBlockingQueue;
import org.gnit.lucenekmp.jdkport.System;
import org.gnit.lucenekmp.jdkport.ThreadPoolExecutor;
import org.gnit.lucenekmp.jdkport.TimeUnit;
import org.gnit.lucenekmp.jdkport.UncheckedIOException;
import org.gnit.lucenekmp.store.AlreadyClosedException;
import org.gnit.lucenekmp.store.Directory;
import org.gnit.lucenekmp.store.FilterDirectory;
import org.gnit.lucenekmp.store.IOContext;
import org.gnit.lucenekmp.store.IndexOutput;
import org.gnit.lucenekmp.store.RateLimitedIndexOutput;
import org.gnit.lucenekmp.store.RateLimiter;
import org.gnit.lucenekmp.util.CollectionUtil;
import org.gnit.lucenekmp.util.InfoStream;
import org.gnit.lucenekmp.util.ThreadInterruptedException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 a2\u00020\u0001:\u0003_`aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010)\u001a\u00020*2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u000e\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020\u001aJ\u000e\u0010-\u001a\u00020*2\u0006\u0010.\u001a\u00020\u0015J\u0006\u0010/\u001a\u00020\u0015J\u0006\u00100\u001a\u00020*J\u0006\u00101\u001a\u00020*J\u0006\u00104\u001a\u00020*J\u0010\u0010!\u001a\u0002052\u0006\u00106\u001a\u000207H\u0016J\u0018\u00108\u001a\u0002092\u0006\u00106\u001a\u0002072\u0006\u0010:\u001a\u000209H\u0016J\b\u0010;\u001a\u00020*H\u0004J\u0010\u0010<\u001a\u00020*2\u0006\u0010=\u001a\u000209H\u0002J\b\u0010>\u001a\u00020*H\u0016J\u000e\u0010?\u001a\u00020*H\u0086@\u00a2\u0006\u0002\u0010@J\u0006\u0010\u0010\u001a\u00020\nJ\u0018\u0010A\u001a\u00020*2\u0006\u0010B\u001a\u00020C2\u0006\u0010=\u001a\u000209H\u0016J\u001e\u00106\u001a\u00020*2\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020GH\u0096@\u00a2\u0006\u0002\u0010HJ\u0016\u0010I\u001a\u00020\u001a2\u0006\u0010D\u001a\u00020EH\u0084@\u00a2\u0006\u0002\u0010JJ\u000e\u0010K\u001a\u00020*H\u0084@\u00a2\u0006\u0002\u0010@J\u0018\u0010L\u001a\u00020*2\u0006\u0010D\u001a\u00020E2\u0006\u00106\u001a\u000207H\u0004J\u001c\u0010M\u001a\u00060\u0006R\u00020\u00002\u0006\u0010D\u001a\u00020E2\u0006\u00106\u001a\u000207H\u0004J\u0016\u0010N\u001a\u00020*2\u0006\u0010D\u001a\u00020EH\u0086@\u00a2\u0006\u0002\u0010JJ\u0010\u0010O\u001a\u00020*2\u0006\u0010P\u001a\u00020QH\u0004J\u0006\u0010S\u001a\u00020*J\u0006\u0010T\u001a\u00020*J\b\u0010U\u001a\u00020VH\u0016J\u0018\u0010W\u001a\u00020\u001a2\u0006\u0010X\u001a\u00020Y2\u0006\u00106\u001a\u000207H\u0002J\u0018\u0010Z\u001a\u00020*2\u0006\u0010[\u001a\u0002072\u0006\u0010\\\u001a\u00020]H\u0002J\b\u0010^\u001a\u00020*H\u0004R\u001e\u0010\u0004\u001a\f\u0012\b\u0012\u00060\u0006R\u00020\u00000\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u001a\u0010\u0010\u001a\u00020\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\u001a@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u001f\u001a\b\u0018\u00010 R\u00020\u0000X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020&X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u00102\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u0017R\u000e\u0010R\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006b"}, d2={"Lorg/gnit/lucenekmp/index/ConcurrentMergeScheduler;", "Lorg/gnit/lucenekmp/index/MergeScheduler;", "<init>", "()V", "mergeThreads", "", "Lorg/gnit/lucenekmp/index/ConcurrentMergeScheduler$MergeThread;", "getMergeThreads", "()Ljava/util/List;", "value", "", "maxThreadCount", "getMaxThreadCount", "()I", "maxMergeCount", "getMaxMergeCount", "mergeThreadCount", "getMergeThreadCount", "setMergeThreadCount", "(I)V", "targetMBPerSec", "", "getTargetMBPerSec", "()D", "setTargetMBPerSec", "(D)V", "", "autoIOThrottle", "getAutoIOThrottle", "()Z", "forceMergeMBPerSec", "intraMergeExecutor", "Lorg/gnit/lucenekmp/index/ConcurrentMergeScheduler$CachedExecutor;", "getIntraMergeExecutor", "()Lorg/gnit/lucenekmp/index/ConcurrentMergeScheduler$CachedExecutor;", "setIntraMergeExecutor", "(Lorg/gnit/lucenekmp/index/ConcurrentMergeScheduler$CachedExecutor;)V", "stallMutex", "Lkotlinx/coroutines/sync/Mutex;", "getStallMutex", "()Lkotlinx/coroutines/sync/Mutex;", "setMaxMergesAndThreads", "", "setDefaultMaxMergesAndThreads", "spins", "setForceMergeMBPerSec", "v", "getForceMergeMBPerSec", "enableAutoIOThrottle", "disableAutoIOThrottle", "iORateLimitMBPerSec", "getIORateLimitMBPerSec", "removeMergeThread", "Lorg/gnit/lucenekmp/jdkport/Executor;", "merge", "Lorg/gnit/lucenekmp/index/MergePolicy$OneMerge;", "wrapForMerge", "Lorg/gnit/lucenekmp/store/Directory;", "in", "updateMergeThreads", "initDynamicDefaults", "directory", "close", "sync", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "initialize", "infoStream", "Lorg/gnit/lucenekmp/util/InfoStream;", "mergeSource", "Lorg/gnit/lucenekmp/index/MergeScheduler$MergeSource;", "trigger", "Lorg/gnit/lucenekmp/index/MergeTrigger;", "(Lorg/gnit/lucenekmp/index/MergeScheduler$MergeSource;Lorg/gnit/lucenekmp/index/MergeTrigger;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "maybeStall", "(Lorg/gnit/lucenekmp/index/MergeScheduler$MergeSource;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "doStall", "doMerge", "getMergeThread", "runOnMergeFinished", "handleMergeException", "exc", "", "suppressExceptions", "setSuppressExceptions", "clearSuppressExceptions", "toString", "", "isBacklog", "now", "", "updateIOThrottle", "newMerge", "rateLimiter", "Lorg/gnit/lucenekmp/index/MergeRateLimiter;", "targetMBPerSecChanged", "MergeThread", "CachedExecutor", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nConcurrentMergeScheduler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConcurrentMergeScheduler.kt\norg/gnit/lucenekmp/index/ConcurrentMergeScheduler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 4 CoroutineScope.kt\nkotlinx/coroutines/CoroutineScopeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1025:1\n1#2:1026\n8#3,2:1027\n8#3,2:1039\n375#4:1029\n375#4:1030\n375#4:1033\n375#4:1037\n1761#5,2:1031\n1763#5:1034\n1761#5,2:1035\n1763#5:1038\n*S KotlinDebug\n*F\n+ 1 ConcurrentMergeScheduler.kt\norg/gnit/lucenekmp/index/ConcurrentMergeScheduler\n*L\n250#1:1027,2\n676#1:1039,2\n460#1:1029\n480#1:1030\n607#1:1033\n676#1:1037\n607#1:1031,2\n607#1:1034\n676#1:1035,2\n676#1:1038\n*E\n"})
public class ConcurrentMergeScheduler
extends MergeScheduler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<MergeThread> mergeThreads = new ArrayList();
    private int maxThreadCount = -1;
    private int maxMergeCount = -1;
    private int mergeThreadCount;
    private double targetMBPerSec = 20.0;
    private boolean autoIOThrottle;
    private double forceMergeMBPerSec = Double.POSITIVE_INFINITY;
    @Nullable
    private CachedExecutor intraMergeExecutor;
    @NotNull
    private final Mutex stallMutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
    private boolean suppressExceptions;
    public static final int AUTO_DETECT_MERGES_AND_THREADS = -1;
    @NotNull
    public static final String DEFAULT_CPU_CORE_COUNT_PROPERTY = "lucene.cms.override_core_count";
    private static final double MIN_MERGE_MB_PER_SEC = 5.0;
    private static final double MAX_MERGE_MB_PER_SEC = 10240.0;
    private static final double START_MB_PER_SEC = 20.0;
    private static final double MIN_BIG_MERGE_MB = 50.0;

    @NotNull
    protected final List<MergeThread> getMergeThreads() {
        return this.mergeThreads;
    }

    public final int getMaxThreadCount() {
        return this.maxThreadCount;
    }

    public final int getMaxMergeCount() {
        return this.maxMergeCount;
    }

    protected final int getMergeThreadCount() {
        return this.mergeThreadCount;
    }

    protected final void setMergeThreadCount(int n) {
        this.mergeThreadCount = n;
    }

    protected final double getTargetMBPerSec() {
        return this.targetMBPerSec;
    }

    protected final void setTargetMBPerSec(double d) {
        this.targetMBPerSec = d;
    }

    public final boolean getAutoIOThrottle() {
        return this.autoIOThrottle;
    }

    @Nullable
    protected final CachedExecutor getIntraMergeExecutor() {
        return this.intraMergeExecutor;
    }

    protected final void setIntraMergeExecutor(@Nullable CachedExecutor cachedExecutor) {
        this.intraMergeExecutor = cachedExecutor;
    }

    @NotNull
    protected final Mutex getStallMutex() {
        return this.stallMutex;
    }

    public final void setMaxMergesAndThreads(int maxMergeCount, int maxThreadCount) {
        if (maxMergeCount == -1 && maxThreadCount == -1) {
            this.maxMergeCount = -1;
            this.maxThreadCount = -1;
        } else if (!(maxMergeCount != -1)) {
            boolean $i$a$-require-ConcurrentMergeScheduler$setMaxMergesAndThreads$62 = false;
            String $i$a$-require-ConcurrentMergeScheduler$setMaxMergesAndThreads$62 = "both maxMergeCount and maxThreadCount must be AUTO_DETECT_MERGES_AND_THREADS";
            throw new IllegalArgumentException($i$a$-require-ConcurrentMergeScheduler$setMaxMergesAndThreads$62.toString());
        }
        if (!(maxThreadCount != -1)) {
            boolean $i$a$-require-ConcurrentMergeScheduler$setMaxMergesAndThreads$72 = false;
            String $i$a$-require-ConcurrentMergeScheduler$setMaxMergesAndThreads$72 = "both maxMergeCount and maxThreadCount must be AUTO_DETECT_MERGES_AND_THREADS";
            throw new IllegalArgumentException($i$a$-require-ConcurrentMergeScheduler$setMaxMergesAndThreads$72.toString());
        }
        if (!(maxThreadCount >= 1)) {
            boolean $i$a$-require-ConcurrentMergeScheduler$setMaxMergesAndThreads$82 = false;
            String $i$a$-require-ConcurrentMergeScheduler$setMaxMergesAndThreads$82 = "maxThreadCount should be at least 1";
            throw new IllegalArgumentException($i$a$-require-ConcurrentMergeScheduler$setMaxMergesAndThreads$82.toString());
        }
        if (!(maxMergeCount >= 1)) {
            boolean $i$a$-require-ConcurrentMergeScheduler$setMaxMergesAndThreads$92 = false;
            String $i$a$-require-ConcurrentMergeScheduler$setMaxMergesAndThreads$92 = "maxMergeCount should be at least 1";
            throw new IllegalArgumentException($i$a$-require-ConcurrentMergeScheduler$setMaxMergesAndThreads$92.toString());
        }
        if (!(maxThreadCount <= maxMergeCount)) {
            boolean bl = false;
            String string = "maxThreadCount should be <= maxMergeCount (= " + maxMergeCount + ")";
            throw new IllegalArgumentException(string.toString());
        }
        this.maxThreadCount = maxThreadCount;
        this.maxMergeCount = maxMergeCount;
    }

    public final void setDefaultMaxMergesAndThreads(boolean spins) {
        if (spins) {
            this.maxThreadCount = 1;
            this.maxMergeCount = 6;
        } else {
            int coreCount = 1;
            try {
                String value = EnvVar.INSTANCE.get(DEFAULT_CPU_CORE_COUNT_PROPERTY);
                if (value != null) {
                    coreCount = Integer.parseInt(value);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.maxThreadCount = Math.max(1, coreCount / 2);
            this.maxMergeCount = this.maxThreadCount + 5;
        }
    }

    public final void setForceMergeMBPerSec(double v) {
        this.forceMergeMBPerSec = v;
        this.updateMergeThreads();
    }

    public final double getForceMergeMBPerSec() {
        return this.forceMergeMBPerSec;
    }

    public final void enableAutoIOThrottle() {
        this.autoIOThrottle = true;
        this.targetMBPerSec = 20.0;
        this.updateMergeThreads();
    }

    public final void disableAutoIOThrottle() {
        this.autoIOThrottle = false;
        this.updateMergeThreads();
    }

    public final double getIORateLimitMBPerSec() {
        return this.autoIOThrottle ? this.targetMBPerSec : Double.POSITIVE_INFINITY;
    }

    public final void removeMergeThread() {
        CompletableJob currentThread = JobKt.Job$default(null, (int)1, null);
        int n = ((Collection)this.mergeThreads).size();
        for (int i = 0; i < n; ++i) {
            if (this.mergeThreads.get(i) != currentThread) continue;
            this.mergeThreads.remove(i);
            return;
        }
        boolean condition$iv = false;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED) {
            boolean bl = false;
            String string = "merge thread " + currentThread + " was not found";
            throw new AssertionError((Object)string);
        }
    }

    @Override
    @NotNull
    public Executor getIntraMergeExecutor(@NotNull MergePolicy.OneMerge merge2) {
        Intrinsics.checkNotNullParameter((Object)merge2, (String)"merge");
        if (this.intraMergeExecutor == null) {
            boolean bl = false;
            String string = "scaledExecutor is not initialized";
            throw new IllegalStateException(string.toString());
        }
        if ((double)merge2.getEstimatedMergeBytes() < 5.24288E7) {
            return super.getIntraMergeExecutor(merge2);
        }
        CachedExecutor cachedExecutor = this.intraMergeExecutor;
        Intrinsics.checkNotNull((Object)cachedExecutor);
        return cachedExecutor;
    }

    @Override
    @NotNull
    public Directory wrapForMerge(@NotNull MergePolicy.OneMerge merge2, @NotNull Directory in) {
        Intrinsics.checkNotNullParameter((Object)merge2, (String)"merge");
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        CompletableJob mergeThread = JobKt.Job$default(null, (int)1, null);
        Intrinsics.checkNotNull((Object)mergeThread, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.index.ConcurrentMergeScheduler.MergeThread");
        RateLimiter rateLimiter = ((MergeThread)mergeThread).getRateLimiter();
        return new FilterDirectory(in, rateLimiter){
            final /* synthetic */ Directory $in;
            final /* synthetic */ RateLimiter $rateLimiter;
            {
                this.$in = $in;
                this.$rateLimiter = $rateLimiter;
                super($in);
            }

            public IndexOutput createOutput(String name, IOContext context) throws IOException {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                this.ensureOpen();
                boolean condition$iv = context.getContext() == IOContext.Context.MERGE;
                boolean $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    boolean bl = false;
                    String string = "got context=" + context.getContext();
                    throw new AssertionError((Object)string);
                }
                return new RateLimitedIndexOutput(this.$rateLimiter, this.$in.createOutput(name, context));
            }
        };
    }

    protected final void updateMergeThreads() {
        List activeMerges = new ArrayList();
        int threadIdx = 0;
        while (threadIdx < this.mergeThreads.size()) {
            MergeThread mergeThread = this.mergeThreads.get(threadIdx);
            if (!mergeThread.isAlive()) {
                this.mergeThreads.remove(threadIdx);
                continue;
            }
            activeMerges.add(mergeThread);
            ++threadIdx;
        }
        CollectionUtil.INSTANCE.timSort(activeMerges);
        int activeMergeCount = activeMerges.size();
        int bigMergeCount = 0;
        for (threadIdx = activeMergeCount - 1; threadIdx >= 0; --threadIdx) {
            MergeThread mergeThread = (MergeThread)activeMerges.get(threadIdx);
            if (!((double)mergeThread.getMerge().getEstimatedMergeBytes() > 5.24288E7)) continue;
            bigMergeCount = 1 + threadIdx;
            break;
        }
        long now = System.INSTANCE.nanoTime();
        StringBuilder message = null;
        if (this.verbose()) {
            message = new StringBuilder();
            message.append("updateMergeThreads ioThrottle=" + this.autoIOThrottle + " targetMBPerSec=" + this.targetMBPerSec);
        } else {
            message = null;
        }
        for (threadIdx = 0; threadIdx < activeMergeCount; ++threadIdx) {
            boolean doPause;
            MergeThread mergeThread = (MergeThread)activeMerges.get(threadIdx);
            MergePolicy.OneMerge merge2 = mergeThread.getMerge();
            boolean bl = doPause = threadIdx < bigMergeCount - this.maxThreadCount;
            double newMBPerSec = doPause ? 0.0 : (merge2.getMaxNumSegments() != -1 ? this.forceMergeMBPerSec : (!this.autoIOThrottle ? Double.POSITIVE_INFINITY : ((double)merge2.getEstimatedMergeBytes() < 5.24288E7 ? Double.POSITIVE_INFINITY : this.targetMBPerSec)));
            MergeRateLimiter rateLimiter = mergeThread.getRateLimiter();
            double curMBPerSec = rateLimiter.getMBPerSec();
            if (this.verbose()) {
                long mergeStartNS = merge2.getMergeStartNS();
                if (mergeStartNS == -1L) {
                    mergeStartNS = now;
                }
                StringBuilder stringBuilder = message;
                Intrinsics.checkNotNull((Object)stringBuilder);
                stringBuilder.append('\n');
                message.append("merge thread " + mergeThread.getName() + " estSize=" + ConcurrentMergeScheduler.Companion.bytesToMB(merge2.getEstimatedMergeBytes()) + " MB (written=" + ConcurrentMergeScheduler.Companion.bytesToMB(rateLimiter.getTotalBytesWritten()) + " MB) runTime=" + ConcurrentMergeScheduler.Companion.nsToSec(now - mergeStartNS) + "fs (stopped=" + ConcurrentMergeScheduler.Companion.nsToSec(rateLimiter.getTotalStoppedNS()) + "s, paused=" + ConcurrentMergeScheduler.Companion.nsToSec(rateLimiter.getTotalPausedNS()) + "s) rate=" + ConcurrentMergeScheduler.Companion.rateToString(rateLimiter.getMBPerSec()) + "\n");
                StringBuilder stringBuilder2 = !(newMBPerSec == curMBPerSec) ? (newMBPerSec == 0.0 ? message.append("  now stop") : (curMBPerSec == 0.0 ? (newMBPerSec == Double.POSITIVE_INFINITY ? message.append("  now resume") : message.append("  now resume to " + newMBPerSec + " MB/sec")) : message.append("  now change from " + curMBPerSec + " MB/sec to " + newMBPerSec + " MB/sec"))) : (curMBPerSec == 0.0 ? message.append("  leave stopped") : message.append("  leave running at " + curMBPerSec + " MB/sec"));
            }
            rateLimiter.setMBPerSec(newMBPerSec);
        }
        if (this.verbose()) {
            this.message(String.valueOf(message));
        }
    }

    private final void initDynamicDefaults(Directory directory) throws IOException {
        if (this.maxThreadCount == -1) {
            this.setDefaultMaxMergesAndThreads(false);
            if (this.verbose()) {
                this.message("initDynamicDefaults maxThreadCount=" + this.maxThreadCount + " maxMergeCount=" + this.maxMergeCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        super.close();
        try {
            BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ ConcurrentMergeScheduler this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = this.this$0.sync((Continuation<? super Unit>)((Continuation)this));
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }
        finally {
            if (this.intraMergeExecutor != null) {
                CachedExecutor cachedExecutor = this.intraMergeExecutor;
                Intrinsics.checkNotNull((Object)cachedExecutor);
                cachedExecutor.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Object sync(@NotNull Continuation<? super Unit> $completion) {
        boolean interrupted = false;
        try {
            while (true) {
                MergeThread toSync = null;
                for (MergeThread t : this.mergeThreads) {
                    if (!t.isAlive()) continue;
                    boolean $i$f$currentCoroutineContext = false;
                    if (t == $completion.getContext().get((CoroutineContext.Key)Job.Key)) continue;
                    toSync = t;
                    break;
                }
                if (toSync != null) {
                    try {
                        toSync.join();
                    }
                    catch (InterruptedException ie) {
                        interrupted = true;
                    }
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                boolean $i$f$currentCoroutineContext = false;
                CoroutineContext.Element element = $completion.getContext().get((CoroutineContext.Key)Job.Key);
                Intrinsics.checkNotNull((Object)element);
                Job.DefaultImpls.cancel$default((Job)((Job)element), null, (int)1, null);
            }
        }
        return Unit.INSTANCE;
    }

    public final int mergeThreadCount() {
        CompletableJob currentThread = JobKt.Job$default(null, (int)1, null);
        int count = 0;
        for (MergeThread mergeThread : this.mergeThreads) {
            if (currentThread == mergeThread || !mergeThread.isAlive() || mergeThread.getMerge().isAborted()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void initialize(@NotNull InfoStream infoStream, @NotNull Directory directory) throws IOException {
        Intrinsics.checkNotNullParameter((Object)infoStream, (String)"infoStream");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        super.initialize(infoStream, directory);
        this.initDynamicDefaults(directory);
        if (this.intraMergeExecutor == null) {
            this.intraMergeExecutor = new CachedExecutor();
        }
    }

    @Override
    @Nullable
    public Object merge(@NotNull MergeScheduler.MergeSource mergeSource, @NotNull MergeTrigger trigger, @NotNull Continuation<? super Unit> $completion) {
        return ConcurrentMergeScheduler.merge$suspendImpl(this, mergeSource, trigger, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    static /* synthetic */ Object merge$suspendImpl(ConcurrentMergeScheduler $this, MergeScheduler.MergeSource mergeSource, MergeTrigger trigger, Continuation<? super Unit> $completion) {
        if (!($completion instanceof merge.1)) ** GOTO lbl-1000
        var8_4 = $completion;
        if ((var8_4.label & -2147483648) != 0) {
            var8_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ ConcurrentMergeScheduler this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ConcurrentMergeScheduler.merge$suspendImpl(this.this$0, null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (trigger == MergeTrigger.CLOSING) {
                    $this.targetMBPerSec = 10240.0;
                    $this.updateMergeThreads();
                }
                if ($this.verbose()) {
                    $this.message("now merge");
                    $this.message("  index(source): " + mergeSource);
                }
lbl19:
                // 4 sources

                while (true) {
                    $continuation.L$0 = $this;
                    $continuation.L$1 = mergeSource;
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)trigger);
                    $continuation.label = 1;
                    v0 = $this.maybeStall(mergeSource, (Continuation<? super Boolean>)$continuation);
                    if (v0 == var9_6) {
                        return var9_6;
                    }
                    ** GOTO lbl34
                    break;
                }
            }
            case 1: {
                trigger = (MergeTrigger)$continuation.L$2;
                mergeSource = (MergeScheduler.MergeSource)$continuation.L$1;
                $this = (ConcurrentMergeScheduler)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl34:
                // 2 sources

                if (((Boolean)v0).booleanValue()) {
                    merge = mergeSource.getNextMerge();
                    if (merge == null) {
                        if ($this.verbose()) {
                            $this.message("  no more merges pending; now return");
                        }
                        return Unit.INSTANCE;
                    }
                    success = false;
                    try {
                        newMergeThread = $this.getMergeThread(mergeSource, merge);
                        $this.mergeThreads.add(newMergeThread);
                        $this.updateIOThrottle(newMergeThread.getMerge(), newMergeThread.getRateLimiter());
                        if ($this.verbose()) {
                            $this.message("    launch new thread [" + newMergeThread.getName() + "]");
                        }
                        newMergeThread.start();
                        $this.updateMergeThreads();
                        success = true;
                    }
                    catch (Throwable var6_10) {
                        mergeSource.onMergeFinished(merge);
                        throw var6_10;
                    }
                    ** continue;
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    protected final Object maybeStall(@NotNull MergeScheduler.MergeSource mergeSource, @NotNull Continuation<? super Boolean> $completion) {
        if (!($completion instanceof maybeStall.1)) ** GOTO lbl-1000
        var14_3 = $completion;
        if ((var14_3.label & -2147483648) != 0) {
            var14_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                long J$0;
                /* synthetic */ Object result;
                final /* synthetic */ ConcurrentMergeScheduler this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.maybeStall(null, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var15_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                startStallTime = 0L;
lbl13:
                // 3 sources

                while (mergeSource.hasPendingMerges() && this.mergeThreadCount() >= this.maxMergeCount) {
                    $this$any$iv = this.mergeThreads;
                    $i$f$any = false;
                    if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl19
                    v0 = false;
                    ** GOTO lbl29
lbl19:
                    // 2 sources

                    for (T element$iv : $this$any$iv) {
                        it = (MergeThread)element$iv;
                        $i$a$-any-ConcurrentMergeScheduler$maybeStall$2 = false;
                        $completion$iv = $continuation;
                        $i$f$currentCoroutineContext = false;
                        if (!(it.getJob() == $continuation.getContext().get((CoroutineContext.Key)Job.Key))) continue;
                        v0 = true;
                        ** GOTO lbl29
                    }
                    v0 = false;
lbl29:
                    // 3 sources

                    if (v0) {
                        return Boxing.boxBoolean((boolean)false);
                    }
                    if (startStallTime == 0L) {
                        startStallTime = System.INSTANCE.currentTimeMillis();
                        if (this.verbose()) {
                            this.message("    too many merges; stalling...");
                        }
                    }
                    $continuation.L$0 = mergeSource;
                    $continuation.J$0 = startStallTime;
                    $continuation.label = 1;
                    v1 = this.doStall((Continuation<? super Unit>)$continuation);
                    if (v1 != var15_5) continue;
                    return var15_5;
                }
                break;
            }
            case 1: {
                startStallTime = $continuation.J$0;
                mergeSource = (MergeScheduler.MergeSource)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
                ** GOTO lbl13
            }
        }
        if (this.verbose() && startStallTime != 0L) {
            this.message("  stalled for " + (System.INSTANCE.currentTimeMillis() - startStallTime) + " ms");
        }
        return Boxing.boxBoolean((boolean)true);
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    protected final Object doStall(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof doStall.1)) ** GOTO lbl-1000
        var4_2 = $completion;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ ConcurrentMergeScheduler this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.doStall((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = TimeoutKt.withTimeoutOrNull((long)250L, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    Object L$0;
                    int I$0;
                    int label;
                    final /* synthetic */ ConcurrentMergeScheduler this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object $result) {
                        var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                $this$withLock_u24default$iv = this.this$0.getStallMutex();
                                owner$iv = null;
                                $i$f$withLock = 0;
                                this.L$0 = $this$withLock_u24default$iv;
                                this.I$0 = $i$f$withLock;
                                this.label = 1;
                                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)this);
                                if (v0 == var7_2) {
                                    return var7_2;
                                }
                                ** GOTO lbl21
                            }
                            case 1: {
                                $i$f$withLock = this.I$0;
                                owner$iv = null;
                                $this$withLock_u24default$iv = (Mutex)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl21:
                                // 2 sources

                                try {
                                    $i$a$-withLock$default-ConcurrentMergeScheduler$doStall$2$1 = false;
                                    var5_8 = Unit.INSTANCE;
                                }
                                finally {
                                    $this$withLock_u24default$iv.unlock(owner$iv);
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v0 != var5_4) goto lbl18
lbl17:
                // 1 sources

                return var5_4;
lbl18:
                // 1 sources

                ** GOTO lbl24
            }
            case 1: {
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl24:
                    // 2 sources

                    (Unit)v0;
                }
                catch (CancellationException ie) {
                    throw new ThreadInterruptedException(ie);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    protected final void doMerge(@NotNull MergeScheduler.MergeSource mergeSource, @NotNull MergePolicy.OneMerge merge2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)mergeSource, (String)"mergeSource");
        Intrinsics.checkNotNullParameter((Object)merge2, (String)"merge");
        mergeSource.merge(merge2);
    }

    @NotNull
    protected final MergeThread getMergeThread(@NotNull MergeScheduler.MergeSource mergeSource, @NotNull MergePolicy.OneMerge merge2) {
        Intrinsics.checkNotNullParameter((Object)mergeSource, (String)"mergeSource");
        Intrinsics.checkNotNullParameter((Object)merge2, (String)"merge");
        MergeThread thread = new MergeThread(this, mergeSource, merge2, null, 4, null);
        return thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object runOnMergeFinished(@NotNull MergeScheduler.MergeSource mergeSource, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof runOnMergeFinished.1)) ** GOTO lbl-1000
        var12_3 = $completion;
        if ((var12_3.label & -2147483648) != 0) {
            var12_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ ConcurrentMergeScheduler this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.runOnMergeFinished(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var13_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$any$iv = this.mergeThreads;
                $i$f$any = false;
                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl17
                v0 = false;
                ** GOTO lbl27
lbl17:
                // 2 sources

                for (T element$iv : $this$any$iv) {
                    it = (MergeThread)element$iv;
                    $i$a$-any-ConcurrentMergeScheduler$runOnMergeFinished$2 = false;
                    $completion$iv = $continuation;
                    $i$f$currentCoroutineContext = false;
                    if (!(it.getJob() == $continuation.getContext().get((CoroutineContext.Key)Job.Key))) continue;
                    v0 = true;
                    ** GOTO lbl27
                }
                v0 = false;
lbl27:
                // 3 sources

                condition$iv = v0;
                $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    $i$a$-assert-ConcurrentMergeScheduler$runOnMergeFinished$3 = false;
                    var5_14 = "caller is not a merge thread";
                    throw new AssertionError((Object)var5_14);
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)mergeSource);
                $continuation.label = 1;
                v1 = this.merge(mergeSource, MergeTrigger.MERGE_FINISHED, (Continuation<? super Unit>)$continuation);
                ** if (v1 != var13_5) goto lbl41
lbl40:
                // 1 sources

                return var13_5;
lbl41:
                // 1 sources

                ** GOTO lbl61
            }
            case 1: {
                mergeSource = (MergeScheduler.MergeSource)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
                    ** GOTO lbl61
                }
                catch (AlreadyClosedException condition$iv) {
                    ** GOTO lbl61
                }
                catch (IOException ioe) {
                    throw new UncheckedIOException(ioe);
                }
            }
            catch (Throwable var3_10) {
                throw var3_10;
            }
            {
                finally {
                    this.removeMergeThread();
                    this.updateMergeThreads();
                    if (this.stallMutex.isLocked()) {
                        Mutex.DefaultImpls.unlock$default((Mutex)this.stallMutex, null, (int)1, null);
                    }
                }
lbl61:
                // 3 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    protected final void handleMergeException(@NotNull Throwable exc) {
        Intrinsics.checkNotNullParameter((Object)exc, (String)"exc");
        throw new MergePolicy.MergeException(exc);
    }

    public final void setSuppressExceptions() {
        if (this.verbose()) {
            this.message("will suppress merge exceptions");
        }
        this.suppressExceptions = true;
    }

    public final void clearSuppressExceptions() {
        if (this.verbose()) {
            this.message("will not suppress merge exceptions");
        }
        this.suppressExceptions = false;
    }

    @NotNull
    public String toString() {
        return Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + ": maxThreadCount=" + this.maxThreadCount + ", maxMergeCount=" + this.maxMergeCount + ", ioThrottle=" + this.autoIOThrottle;
    }

    private final boolean isBacklog(long now, MergePolicy.OneMerge merge2) {
        double mergeMB = ConcurrentMergeScheduler.Companion.bytesToMB(merge2.getEstimatedMergeBytes());
        for (MergeThread mergeThread : this.mergeThreads) {
            double otherMergeMB;
            double ratio;
            long mergeStartNS = mergeThread.getMerge().getMergeStartNS();
            if (!mergeThread.isAlive() || mergeThread.getMerge() == merge2 || mergeStartNS == -1L || !((double)mergeThread.getMerge().getEstimatedMergeBytes() >= 5.24288E7) || !(ConcurrentMergeScheduler.Companion.nsToSec(now - mergeStartNS) > 3.0) || !((ratio = (otherMergeMB = ConcurrentMergeScheduler.Companion.bytesToMB(mergeThread.getMerge().getEstimatedMergeBytes())) / mergeMB) > 0.3) || !(ratio < 3.0)) continue;
            return true;
        }
        return false;
    }

    private final void updateIOThrottle(MergePolicy.OneMerge newMerge, MergeRateLimiter rateLimiter) throws IOException {
        if (!this.autoIOThrottle) {
            return;
        }
        double mergeMB = ConcurrentMergeScheduler.Companion.bytesToMB(newMerge.getEstimatedMergeBytes());
        if (mergeMB < 50.0) {
            return;
        }
        long now = System.INSTANCE.nanoTime();
        boolean newBacklog = this.isBacklog(now, newMerge);
        boolean curBacklog = false;
        if (!newBacklog) {
            if (this.mergeThreads.size() > this.maxThreadCount) {
                curBacklog = true;
            } else {
                for (MergeThread mergeThread : this.mergeThreads) {
                    if (!this.isBacklog(now, mergeThread.getMerge())) continue;
                    curBacklog = true;
                    break;
                }
            }
        }
        double curMBPerSec = this.targetMBPerSec;
        if (newBacklog) {
            this.targetMBPerSec *= 1.2;
            if (this.targetMBPerSec > 10240.0) {
                this.targetMBPerSec = 10240.0;
            }
            if (this.verbose()) {
                if (curMBPerSec == this.targetMBPerSec) {
                    this.message("io throttle: new merge backlog; leave IO rate at ceiling " + this.targetMBPerSec + " MB/sec");
                } else {
                    this.message("io throttle: new merge backlog; increase IO rate to " + this.targetMBPerSec + " MB/sec");
                }
            }
        } else if (curBacklog) {
            if (this.verbose()) {
                this.message("io throttle: current merge backlog; leave IO rate at " + this.targetMBPerSec + " MB/sec");
            }
        } else {
            this.targetMBPerSec /= 1.1;
            if (this.targetMBPerSec < 5.0) {
                this.targetMBPerSec = 5.0;
            }
            if (this.verbose()) {
                if (curMBPerSec == this.targetMBPerSec) {
                    this.message("io throttle: no merge backlog; leave IO rate at floor " + this.targetMBPerSec + " MB/sec");
                } else {
                    this.message("io throttle: no merge backlog; decrease IO rate to " + this.targetMBPerSec + " MB/sec");
                }
            }
        }
        double rate = newMerge.getMaxNumSegments() != -1 ? this.forceMergeMBPerSec : this.targetMBPerSec;
        rateLimiter.setMBPerSec(rate);
        this.targetMBPerSecChanged();
    }

    protected final void targetMBPerSecChanged() {
    }

    private static final void _init_$lambda$10(ConcurrentMergeScheduler obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        obj.setSuppressExceptions();
    }

    static {
        TestSecrets.INSTANCE.setConcurrentMergeSchedulerAccess(ConcurrentMergeScheduler::_init_$lambda$10);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\f\u001a\u00020\rJ\u0014\u0010\u000e\u001a\u00020\r2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0016R\u001a\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\n\n\u0002\u0010\t\u0012\u0004\b\u0007\u0010\bR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/gnit/lucenekmp/index/ConcurrentMergeScheduler$CachedExecutor;", "Lorg/gnit/lucenekmp/jdkport/Executor;", "<init>", "(Lorg/gnit/lucenekmp/index/ConcurrentMergeScheduler;)V", "activeCount", "Lkotlin/concurrent/atomics/AtomicInt;", "Lorg/gnit/lucenekmp/jdkport/AtomicInteger;", "getActiveCount$annotations", "()V", "Ljava/util/concurrent/atomic/AtomicInteger;", "executor", "Lorg/gnit/lucenekmp/jdkport/ThreadPoolExecutor;", "shutdown", "", "execute", "command", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "core"})
    @SourceDebugExtension(value={"SMAP\nConcurrentMergeScheduler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConcurrentMergeScheduler.kt\norg/gnit/lucenekmp/index/ConcurrentMergeScheduler$CachedExecutor\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n*L\n1#1,1025:1\n8#2,2:1026\n8#2,2:1028\n*S KotlinDebug\n*F\n+ 1 ConcurrentMergeScheduler.kt\norg/gnit/lucenekmp/index/ConcurrentMergeScheduler$CachedExecutor\n*L\n943#1:1026,2\n961#1:1028,2\n*E\n"})
    public final class CachedExecutor
    implements Executor {
        @NotNull
        private final AtomicInteger activeCount = new AtomicInteger(0);
        @NotNull
        private final ThreadPoolExecutor executor = new ThreadPoolExecutor(0, 1024, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue(0, 1, null), null, null, 96, null);

        private static /* synthetic */ void getActiveCount$annotations() {
        }

        public final void shutdown() {
            this.executor.shutdown();
        }

        @Override
        public void execute(@NotNull Runnable command) {
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            boolean isThreadAvailable = false;
            int max = ConcurrentMergeScheduler.this.getMaxThreadCount() - ConcurrentMergeScheduler.this.getMergeThreads().size() - 1;
            int value = AtomicIntExtKt.get(this.activeCount);
            if (value < max) {
                AtomicsKt.incrementAndFetch((AtomicInteger)this.activeCount);
                boolean condition$iv = AtomicIntExtKt.get(this.activeCount) > 0;
                boolean $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    boolean bl = false;
                    String string = "active count must be greater than 0 after increment";
                    throw new AssertionError((Object)string);
                }
                isThreadAvailable = true;
            } else {
                isThreadAvailable = false;
            }
            if (isThreadAvailable) {
                this.executor.execute(() -> CachedExecutor.execute$lambda$2(command, ConcurrentMergeScheduler.this, this));
            } else {
                command.run();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final void execute$lambda$2(Runnable $command, ConcurrentMergeScheduler this$0, CachedExecutor this$1) {
            try {
                $command.run();
            }
            catch (Throwable exc) {
                block7: {
                    try {
                        if (this$0.suppressExceptions) break block7;
                        this$0.handleMergeException(exc);
                    }
                    catch (Throwable throwable) {
                        AtomicsKt.decrementAndFetch((AtomicInteger)this$1.activeCount);
                        boolean condition$iv = AtomicIntExtKt.get(this$1.activeCount) >= 0;
                        boolean $i$f$assert = false;
                        if (_Assertions.ENABLED && !condition$iv) {
                            boolean bl = false;
                            String string = "unexpected negative active count";
                            throw new AssertionError((Object)string);
                        }
                        throw throwable;
                    }
                }
                AtomicsKt.decrementAndFetch((AtomicInteger)this$1.activeCount);
                boolean condition$iv = AtomicIntExtKt.get(this$1.activeCount) >= 0;
                boolean $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    boolean $i$a$-assert-ConcurrentMergeScheduler$CachedExecutor$execute$2$22 = false;
                    String $i$a$-assert-ConcurrentMergeScheduler$CachedExecutor$execute$2$22 = "unexpected negative active count";
                    throw new AssertionError((Object)$i$a$-assert-ConcurrentMergeScheduler$CachedExecutor$execute$2$22);
                }
            }
            AtomicsKt.decrementAndFetch((AtomicInteger)this$1.activeCount);
            boolean condition$iv = AtomicIntExtKt.get(this$1.activeCount) >= 0;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean $i$a$-assert-ConcurrentMergeScheduler$CachedExecutor$execute$2$32 = false;
                String $i$a$-assert-ConcurrentMergeScheduler$CachedExecutor$execute$2$32 = "unexpected negative active count";
                throw new AssertionError((Object)$i$a$-assert-ConcurrentMergeScheduler$CachedExecutor$execute$2$32);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\tH\u0002J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0011H\u0002J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/gnit/lucenekmp/index/ConcurrentMergeScheduler$Companion;", "", "<init>", "()V", "AUTO_DETECT_MERGES_AND_THREADS", "", "DEFAULT_CPU_CORE_COUNT_PROPERTY", "", "MIN_MERGE_MB_PER_SEC", "", "MAX_MERGE_MB_PER_SEC", "START_MB_PER_SEC", "MIN_BIG_MERGE_MB", "rateToString", "mbPerSec", "nsToSec", "ns", "", "bytesToMB", "bytes", "getSegmentName", "merge", "Lorg/gnit/lucenekmp/index/MergePolicy$OneMerge;", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final String rateToString(double mbPerSec) {
            double d = mbPerSec;
            return d == 0.0 ? "stopped" : (d == Double.POSITIVE_INFINITY ? "unlimited" : mbPerSec + " MB/sec");
        }

        private final double nsToSec(long ns) {
            return (double)ns / (double)TimeUnit.SECONDS.toNanos(1L);
        }

        private final double bytesToMB(long bytes) {
            return (double)bytes / 1024.0 / 1024.0;
        }

        private final String getSegmentName(MergePolicy.OneMerge merge2) {
            String string;
            if (merge2.getInfo() != null) {
                SegmentCommitInfo segmentCommitInfo = merge2.getInfo();
                Intrinsics.checkNotNull((Object)segmentCommitInfo);
                string = segmentCommitInfo.getInfo().getName();
            } else {
                string = "_na_";
            }
            return string;
        }

        public static final /* synthetic */ String access$getSegmentName(Companion $this, MergePolicy.OneMerge merge2) {
            return $this.getSegmentName(merge2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0094\u0004\u0018\u00002\f\u0012\b\u0012\u00060\u0000R\u00020\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u001aJ\u0015\u0010\u001c\u001a\u00020\u001d2\n\u0010\u001e\u001a\u00060\u0000R\u00020\u0002H\u0096\u0002J\u000e\u0010\u001f\u001a\u00020\u001aH\u0082@\u00a2\u0006\u0002\u0010 R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006!"}, d2={"Lorg/gnit/lucenekmp/index/ConcurrentMergeScheduler$MergeThread;", "", "Lorg/gnit/lucenekmp/index/ConcurrentMergeScheduler;", "mergeSource", "Lorg/gnit/lucenekmp/index/MergeScheduler$MergeSource;", "merge", "Lorg/gnit/lucenekmp/index/MergePolicy$OneMerge;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lorg/gnit/lucenekmp/index/ConcurrentMergeScheduler;Lorg/gnit/lucenekmp/index/MergeScheduler$MergeSource;Lorg/gnit/lucenekmp/index/MergePolicy$OneMerge;Lkotlinx/coroutines/CoroutineScope;)V", "getMerge", "()Lorg/gnit/lucenekmp/index/MergePolicy$OneMerge;", "rateLimiter", "Lorg/gnit/lucenekmp/index/MergeRateLimiter;", "getRateLimiter", "()Lorg/gnit/lucenekmp/index/MergeRateLimiter;", "job", "Lkotlinx/coroutines/Job;", "getJob", "()Lkotlinx/coroutines/Job;", "getName", "", "isAlive", "", "start", "", "join", "compareTo", "", "other", "runMerge", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "core"})
    protected class MergeThread
    implements Comparable<MergeThread> {
        @NotNull
        private final MergeScheduler.MergeSource mergeSource;
        @NotNull
        private final MergePolicy.OneMerge merge;
        @NotNull
        private final MergeRateLimiter rateLimiter;
        @NotNull
        private final Job job;
        final /* synthetic */ ConcurrentMergeScheduler this$0;

        public MergeThread(@NotNull ConcurrentMergeScheduler this$0, @NotNull MergeScheduler.MergeSource mergeSource, @NotNull MergePolicy.OneMerge merge2, CoroutineScope scope) {
            Intrinsics.checkNotNullParameter((Object)mergeSource, (String)"mergeSource");
            Intrinsics.checkNotNullParameter((Object)merge2, (String)"merge");
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            this.this$0 = this$0;
            this.mergeSource = mergeSource;
            this.merge = merge2;
            this.rateLimiter = new MergeRateLimiter(this.merge.getMergeProgress());
            this.job = BuildersKt.launch$default((CoroutineScope)scope, null, (CoroutineStart)CoroutineStart.LAZY, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ MergeThread this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = MergeThread.access$runMerge(this.this$0, (Continuation)this);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }

        public /* synthetic */ MergeThread(ConcurrentMergeScheduler concurrentMergeScheduler, MergeScheduler.MergeSource mergeSource, MergePolicy.OneMerge oneMerge, CoroutineScope coroutineScope, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)Dispatchers.getDefault().plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)));
            }
            this(concurrentMergeScheduler, mergeSource, oneMerge, coroutineScope);
        }

        @NotNull
        public final MergePolicy.OneMerge getMerge() {
            return this.merge;
        }

        @NotNull
        public final MergeRateLimiter getRateLimiter() {
            return this.rateLimiter;
        }

        @NotNull
        public final Job getJob() {
            return this.job;
        }

        @NotNull
        public final String getName() {
            return "Lucene Merge Thread #" + this.this$0.getMergeThreadCount();
        }

        public final boolean isAlive() {
            return this.job.isActive();
        }

        public final void start() {
            this.job.start();
        }

        public final void join() {
            BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ MergeThread this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = this.this$0.getJob().join((Continuation)this);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }

        @Override
        public int compareTo(@NotNull MergeThread other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return Intrinsics.compare((long)other.merge.getEstimatedMergeBytes(), (long)this.merge.getEstimatedMergeBytes());
        }

        /*
         * Unable to fully structure code
         */
        private final Object runMerge(Continuation<? super Unit> $completion) {
            if (!($completion instanceof runMerge.1)) ** GOTO lbl-1000
            var4_2 = $completion;
            if ((var4_2.label & -2147483648) != 0) {
                var4_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    /* synthetic */ Object result;
                    final /* synthetic */ MergeThread this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return MergeThread.access$runMerge(this.this$0, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    if (this.this$0.verbose()) {
                        this.this$0.message("merge thread " + this.getName() + " start");
                    }
                    this.this$0.doMerge(this.mergeSource, this.merge);
                    if (this.this$0.verbose()) {
                        this.this$0.message("merge thread " + this.getName() + " merge segment [" + org.gnit.lucenekmp.index.ConcurrentMergeScheduler$Companion.access$getSegmentName(ConcurrentMergeScheduler.Companion, this.merge) + "] done estSize=" + org.gnit.lucenekmp.index.ConcurrentMergeScheduler$Companion.access$bytesToMB(ConcurrentMergeScheduler.Companion, this.merge.getEstimatedMergeBytes()) + " MB (written=" + org.gnit.lucenekmp.index.ConcurrentMergeScheduler$Companion.access$bytesToMB(ConcurrentMergeScheduler.Companion, this.rateLimiter.getTotalBytesWritten()) + " MB) runTime=" + org.gnit.lucenekmp.index.ConcurrentMergeScheduler$Companion.access$nsToSec(ConcurrentMergeScheduler.Companion, System.INSTANCE.nanoTime() - this.merge.getMergeStartNS()) + "s (stopped=" + org.gnit.lucenekmp.index.ConcurrentMergeScheduler$Companion.access$nsToSec(ConcurrentMergeScheduler.Companion, this.rateLimiter.getTotalStoppedNS()) + "s, paused=" + org.gnit.lucenekmp.index.ConcurrentMergeScheduler$Companion.access$nsToSec(ConcurrentMergeScheduler.Companion, this.rateLimiter.getTotalPausedNS()) + "s) rate=" + org.gnit.lucenekmp.index.ConcurrentMergeScheduler$Companion.access$rateToString(ConcurrentMergeScheduler.Companion, this.rateLimiter.getMBPerSec()));
                    }
                    $continuation.label = 1;
                    v0 = this.this$0.runOnMergeFinished(this.mergeSource, (Continuation<? super Unit>)$continuation);
                    ** if (v0 != var5_4) goto lbl23
lbl22:
                    // 1 sources

                    return var5_4;
lbl23:
                    // 1 sources

                    ** GOTO lbl29
                }
                case 1: {
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl29:
                        // 2 sources

                        if (this.this$0.verbose()) {
                            this.this$0.message("merge thread " + this.getName() + " end");
                        }
                    }
                    catch (Throwable exc) {
                        if (exc instanceof MergePolicy.MergeAbortedException || ConcurrentMergeScheduler.access$getSuppressExceptions$p(this.this$0)) ** GOTO lbl36
                        this.this$0.handleMergeException(exc);
                    }
lbl36:
                    // 3 sources

                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        public static final /* synthetic */ Object access$runMerge(MergeThread $this, Continuation $completion) {
            return $this.runMerge((Continuation<? super Unit>)$completion);
        }
    }
}

