/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.index.MergeState;
import org.gnit.lucenekmp.util.PriorityQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\b&\u0018\u0000 \r*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0004\n\u000b\f\rB\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H&J\u000f\u0010\b\u001a\u0004\u0018\u00018\u0000H&\u00a2\u0006\u0002\u0010\t\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/index/DocIDMerger;", "T", "Lorg/gnit/lucenekmp/index/DocIDMerger$Sub;", "", "<init>", "()V", "reset", "", "next", "()Lorg/gnit/lucenekmp/index/DocIDMerger$Sub;", "Sub", "SequentialDocIDMerger", "SortedDocIDMerger", "Companion", "core"})
public abstract class DocIDMerger<T extends Sub> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private DocIDMerger() {
    }

    public abstract void reset() throws IOException;

    @Nullable
    public abstract T next() throws IOException;

    public /* synthetic */ DocIDMerger(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\b\b\u0001\u0010\u0006*\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00060\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ,\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\b\b\u0001\u0010\u0006*\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00060\t2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/index/DocIDMerger$Companion;", "", "<init>", "()V", "of", "Lorg/gnit/lucenekmp/index/DocIDMerger;", "T", "Lorg/gnit/lucenekmp/index/DocIDMerger$Sub;", "subs", "", "maxCount", "", "indexIsSorted", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T extends Sub> DocIDMerger<T> of(@NotNull List<T> subs, int maxCount, boolean indexIsSorted) throws IOException {
            Intrinsics.checkNotNullParameter(subs, (String)"subs");
            return indexIsSorted && maxCount > 1 ? (DocIDMerger)new SortedDocIDMerger<T>(subs, maxCount) : (DocIDMerger)new SequentialDocIDMerger<T>(subs);
        }

        @NotNull
        public final <T extends Sub> DocIDMerger<T> of(@NotNull List<T> subs, boolean indexIsSorted) throws IOException {
            Intrinsics.checkNotNullParameter(subs, (String)"subs");
            return this.of(subs, subs.size(), indexIsSorted);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\u000f\u0010\u000e\u001a\u0004\u0018\u00018\u0001H\u0016\u00a2\u0006\u0002\u0010\u000fR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0004\u0018\u00018\u0001X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/gnit/lucenekmp/index/DocIDMerger$SequentialDocIDMerger;", "T", "Lorg/gnit/lucenekmp/index/DocIDMerger$Sub;", "Lorg/gnit/lucenekmp/index/DocIDMerger;", "subs", "", "<init>", "(Ljava/util/List;)V", "current", "Lorg/gnit/lucenekmp/index/DocIDMerger$Sub;", "nextIndex", "", "reset", "", "next", "()Lorg/gnit/lucenekmp/index/DocIDMerger$Sub;", "core"})
    private static final class SequentialDocIDMerger<T extends Sub>
    extends DocIDMerger<T> {
        @NotNull
        private final List<T> subs;
        @Nullable
        private T current;
        private int nextIndex;

        public SequentialDocIDMerger(@NotNull List<T> subs) {
            Intrinsics.checkNotNullParameter(subs, (String)"subs");
            super(null);
            this.subs = subs;
            this.reset();
        }

        @Override
        public void reset() throws IOException {
            if (!((Collection)this.subs).isEmpty()) {
                this.current = (Sub)this.subs.get(0);
                this.nextIndex = 1;
            } else {
                this.current = null;
                this.nextIndex = 0;
            }
        }

        @Override
        @Nullable
        public T next() throws IOException {
            while (true) {
                T t = this.current;
                Intrinsics.checkNotNull(t);
                if (((Sub)t).nextMappedDoc() != Integer.MAX_VALUE) break;
                if (this.nextIndex == this.subs.size()) {
                    this.current = null;
                    return null;
                }
                this.current = (Sub)this.subs.get(this.nextIndex);
                int n = this.nextIndex;
                this.nextIndex = n + 1;
            }
            return this.current;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001d\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\u000f\u0010\u0012\u001a\u0004\u0018\u00018\u0001H\u0016\u00a2\u0006\u0002\u0010\u0013R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u0004\u0018\u00018\u0001X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/gnit/lucenekmp/index/DocIDMerger$SortedDocIDMerger;", "T", "Lorg/gnit/lucenekmp/index/DocIDMerger$Sub;", "Lorg/gnit/lucenekmp/index/DocIDMerger;", "subs", "", "maxCount", "", "<init>", "(Ljava/util/List;I)V", "current", "Lorg/gnit/lucenekmp/index/DocIDMerger$Sub;", "queue", "Lorg/gnit/lucenekmp/util/PriorityQueue;", "queueMinDocID", "setQueueMinDocID", "", "reset", "next", "()Lorg/gnit/lucenekmp/index/DocIDMerger$Sub;", "core"})
    private static final class SortedDocIDMerger<T extends Sub>
    extends DocIDMerger<T> {
        @NotNull
        private final List<T> subs;
        @Nullable
        private T current;
        @NotNull
        private final PriorityQueue<T> queue;
        private int queueMinDocID;

        public SortedDocIDMerger(@NotNull List<T> subs, int maxCount) {
            Intrinsics.checkNotNullParameter(subs, (String)"subs");
            super(null);
            if (!(maxCount > 1)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.subs = subs;
            int n = maxCount - 1;
            this.queue = new PriorityQueue<T>(n){

                @Override
                public boolean lessThan(T a, T b) {
                    Intrinsics.checkNotNullParameter(a, (String)"a");
                    Intrinsics.checkNotNullParameter(b, (String)"b");
                    if (!(((Sub)a).getMappedDocID() != ((Sub)b).getMappedDocID())) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    return ((Sub)a).getMappedDocID() < ((Sub)b).getMappedDocID();
                }
            };
            this.reset();
        }

        public final void setQueueMinDocID() {
            this.queueMinDocID = this.queue.size() > 0 ? ((Sub)this.queue.top()).getMappedDocID() : Integer.MAX_VALUE;
        }

        @Override
        public void reset() throws IOException {
            this.queue.clear();
            this.current = null;
            boolean first = true;
            for (Sub sub : this.subs) {
                if (first) {
                    sub.setMappedDocID(-1);
                    this.current = sub;
                    first = false;
                    continue;
                }
                if (sub.nextMappedDoc() == Integer.MAX_VALUE) continue;
                this.queue.add(sub);
            }
            this.setQueueMinDocID();
        }

        @Override
        @Nullable
        public T next() throws IOException {
            T t = this.current;
            Intrinsics.checkNotNull(t);
            int nextDoc = ((Sub)t).nextMappedDoc();
            if (nextDoc < this.queueMinDocID) {
                return this.current;
            }
            if (nextDoc == Integer.MAX_VALUE) {
                this.current = this.queue.size() == 0 ? null : (Sub)this.queue.pop();
            } else if (this.queue.size() > 0) {
                if (!(this.queueMinDocID == ((Sub)this.queue.top()).getMappedDocID())) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                if (!(nextDoc > this.queueMinDocID)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                Sub newCurrent = (Sub)this.queue.top();
                T t2 = this.current;
                Intrinsics.checkNotNull(t2);
                this.queue.updateTop(t2);
                this.current = newCurrent;
            }
            this.setQueueMinDocID();
            return this.current;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000e\u001a\u00020\tH&J\u0006\u0010\u000f\u001a\u00020\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lorg/gnit/lucenekmp/index/DocIDMerger$Sub;", "", "docMap", "Lorg/gnit/lucenekmp/index/MergeState$DocMap;", "<init>", "(Lorg/gnit/lucenekmp/index/MergeState$DocMap;)V", "getDocMap", "()Lorg/gnit/lucenekmp/index/MergeState$DocMap;", "mappedDocID", "", "getMappedDocID", "()I", "setMappedDocID", "(I)V", "nextDoc", "nextMappedDoc", "core"})
    @SourceDebugExtension(value={"SMAP\nDocIDMerger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocIDMerger.kt\norg/gnit/lucenekmp/index/DocIDMerger$Sub\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,188:1\n1#2:189\n*E\n"})
    public static abstract class Sub {
        @NotNull
        private final MergeState.DocMap docMap;
        private int mappedDocID;

        protected Sub(@NotNull MergeState.DocMap docMap) {
            Intrinsics.checkNotNullParameter((Object)docMap, (String)"docMap");
            this.docMap = docMap;
        }

        @NotNull
        public final MergeState.DocMap getDocMap() {
            return this.docMap;
        }

        public final int getMappedDocID() {
            return this.mappedDocID;
        }

        public final void setMappedDocID(int n) {
            this.mappedDocID = n;
        }

        public abstract int nextDoc() throws IOException;

        public final int nextMappedDoc() throws IOException {
            int n;
            int doc;
            int mappedDoc;
            do {
                int n2;
                if ((doc = this.nextDoc()) != Integer.MAX_VALUE) continue;
                int it = n2 = Integer.MAX_VALUE;
                boolean bl = false;
                this.mappedDocID = it;
                return n2;
            } while ((mappedDoc = this.docMap.get(doc)) == -1);
            int it = n = mappedDoc;
            boolean bl = false;
            this.mappedDocID = it;
            return n;
        }
    }
}

