/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.index.BinaryDocValues;
import org.gnit.lucenekmp.index.DocValuesType;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.LeafReader;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.gnit.lucenekmp.index.NumericDocValues;
import org.gnit.lucenekmp.index.SingletonSortedNumericDocValues;
import org.gnit.lucenekmp.index.SingletonSortedSetDocValues;
import org.gnit.lucenekmp.index.SortedDocValues;
import org.gnit.lucenekmp.index.SortedNumericDocValues;
import org.gnit.lucenekmp.index.SortedSetDocValues;
import org.gnit.lucenekmp.util.BytesRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\tJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\rJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\u000bJ\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0007J1\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u0018\"\u00020\u0019H\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0016\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010 \u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J'\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0012\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0018\"\u00020\u0016\u00a2\u0006\u0002\u0010&\u00a8\u0006'"}, d2={"Lorg/gnit/lucenekmp/index/DocValues;", "", "<init>", "()V", "emptyBinary", "Lorg/gnit/lucenekmp/index/BinaryDocValues;", "emptyNumeric", "Lorg/gnit/lucenekmp/index/NumericDocValues;", "emptySorted", "Lorg/gnit/lucenekmp/index/SortedDocValues;", "emptySortedNumeric", "Lorg/gnit/lucenekmp/index/SortedNumericDocValues;", "emptySortedSet", "Lorg/gnit/lucenekmp/index/SortedSetDocValues;", "singleton", "dv", "unwrapSingleton", "checkField", "", "in", "Lorg/gnit/lucenekmp/index/LeafReader;", "field", "", "expected", "", "Lorg/gnit/lucenekmp/index/DocValuesType;", "(Lorg/gnit/lucenekmp/index/LeafReader;Ljava/lang/String;[Lorg/gnit/lucenekmp/index/DocValuesType;)V", "getNumeric", "reader", "getBinary", "getSorted", "getSortedNumeric", "getSortedSet", "isCacheable", "", "ctx", "Lorg/gnit/lucenekmp/index/LeafReaderContext;", "fields", "(Lorg/gnit/lucenekmp/index/LeafReaderContext;[Ljava/lang/String;)Z", "core"})
public final class DocValues {
    @NotNull
    public static final DocValues INSTANCE = new DocValues();

    private DocValues() {
    }

    @NotNull
    public final BinaryDocValues emptyBinary() {
        return new BinaryDocValues(){
            private int doc;
            {
                this.doc = -1;
            }

            public int advance(int target) {
                int n;
                int it = n = Integer.MAX_VALUE;
                boolean bl = false;
                this.doc = it;
                return n;
            }

            public boolean advanceExact(int target) throws IOException {
                this.doc = target;
                return false;
            }

            public int docID() {
                return this.doc;
            }

            public int nextDoc() {
                int n;
                int it = n = Integer.MAX_VALUE;
                boolean bl = false;
                this.doc = it;
                return n;
            }

            public long cost() {
                return 0L;
            }

            public BytesRef binaryValue() {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
        };
    }

    @NotNull
    public final NumericDocValues emptyNumeric() {
        return new NumericDocValues(){
            private int doc;
            {
                this.doc = -1;
            }

            public int advance(int target) {
                int n;
                int it = n = Integer.MAX_VALUE;
                boolean bl = false;
                this.doc = it;
                return n;
            }

            public boolean advanceExact(int target) throws IOException {
                this.doc = target;
                return false;
            }

            public int docID() {
                return this.doc;
            }

            public int nextDoc() {
                int n;
                int it = n = Integer.MAX_VALUE;
                boolean bl = false;
                this.doc = it;
                return n;
            }

            public long cost() {
                return 0L;
            }

            public long longValue() {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
        };
    }

    @NotNull
    public final SortedDocValues emptySorted() {
        BytesRef empty2 = new BytesRef();
        return new SortedDocValues(empty2){
            private int doc;
            final /* synthetic */ BytesRef $empty;
            {
                this.$empty = $empty;
                this.doc = -1;
            }

            public int advance(int target) {
                int n;
                int it = n = Integer.MAX_VALUE;
                boolean bl = false;
                this.doc = it;
                return n;
            }

            public boolean advanceExact(int target) throws IOException {
                this.doc = target;
                return false;
            }

            public int docID() {
                return this.doc;
            }

            public int nextDoc() {
                int n;
                int it = n = Integer.MAX_VALUE;
                boolean bl = false;
                this.doc = it;
                return n;
            }

            public long cost() {
                return 0L;
            }

            public int ordValue() {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }

            public BytesRef lookupOrd(int ord) {
                return this.$empty;
            }

            public int getValueCount() {
                return 0;
            }
        };
    }

    @NotNull
    public final SortedNumericDocValues emptySortedNumeric() {
        return this.singleton(this.emptyNumeric());
    }

    @NotNull
    public final SortedSetDocValues emptySortedSet() {
        return this.singleton(this.emptySorted());
    }

    @NotNull
    public final SortedSetDocValues singleton(@NotNull SortedDocValues dv) {
        Intrinsics.checkNotNullParameter((Object)dv, (String)"dv");
        return new SingletonSortedSetDocValues(dv);
    }

    @Nullable
    public final SortedDocValues unwrapSingleton(@NotNull SortedSetDocValues dv) {
        Intrinsics.checkNotNullParameter((Object)dv, (String)"dv");
        return dv instanceof SingletonSortedSetDocValues ? ((SingletonSortedSetDocValues)dv).getSortedDocValues() : null;
    }

    @Nullable
    public final NumericDocValues unwrapSingleton(@NotNull SortedNumericDocValues dv) {
        Intrinsics.checkNotNullParameter((Object)dv, (String)"dv");
        return dv instanceof SingletonSortedNumericDocValues ? ((SingletonSortedNumericDocValues)dv).getNumericDocValues() : null;
    }

    @NotNull
    public final SortedNumericDocValues singleton(@NotNull NumericDocValues dv) {
        Intrinsics.checkNotNullParameter((Object)dv, (String)"dv");
        return new SingletonSortedNumericDocValues(dv);
    }

    private final void checkField(LeafReader in, String field, DocValuesType ... expected) {
        FieldInfo fi = in.getFieldInfos().fieldInfo(field);
        if (fi != null) {
            String string;
            DocValuesType actual = fi.getDocValuesType();
            if (expected.length == 1) {
                string = "(expected=" + expected[0];
            } else {
                String string2 = Arrays.toString((Object[])expected);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                string = "(expected one of " + string2;
            }
            throw new IllegalStateException("unexpected docvalues type " + actual + " for field '" + field + "' " + string + "). Re-index with correct docvalues type.");
        }
    }

    @NotNull
    public final NumericDocValues getNumeric(@NotNull LeafReader reader2, @NotNull String field) throws IOException {
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        NumericDocValues dv = reader2.getNumericDocValues(field);
        if (dv == null) {
            DocValuesType[] docValuesTypeArray = new DocValuesType[]{DocValuesType.NUMERIC};
            this.checkField(reader2, field, docValuesTypeArray);
            return this.emptyNumeric();
        }
        return dv;
    }

    @NotNull
    public final BinaryDocValues getBinary(@NotNull LeafReader reader2, @NotNull String field) throws IOException {
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        BinaryDocValues dv = reader2.getBinaryDocValues(field);
        if (dv == null) {
            DocValuesType[] docValuesTypeArray = new DocValuesType[]{DocValuesType.BINARY};
            this.checkField(reader2, field, docValuesTypeArray);
            return this.emptyBinary();
        }
        return dv;
    }

    @NotNull
    public final SortedDocValues getSorted(@NotNull LeafReader reader2, @NotNull String field) throws IOException {
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        SortedDocValues dv = reader2.getSortedDocValues(field);
        if (dv == null) {
            DocValuesType[] docValuesTypeArray = new DocValuesType[]{DocValuesType.SORTED};
            this.checkField(reader2, field, docValuesTypeArray);
            return this.emptySorted();
        }
        return dv;
    }

    @NotNull
    public final SortedNumericDocValues getSortedNumeric(@NotNull LeafReader reader2, @NotNull String field) throws IOException {
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        SortedNumericDocValues dv = reader2.getSortedNumericDocValues(field);
        if (dv == null) {
            NumericDocValues single = reader2.getNumericDocValues(field);
            if (single == null) {
                DocValuesType[] docValuesTypeArray = new DocValuesType[]{DocValuesType.SORTED_NUMERIC, DocValuesType.NUMERIC};
                this.checkField(reader2, field, docValuesTypeArray);
                return this.emptySortedNumeric();
            }
            return this.singleton(single);
        }
        return dv;
    }

    @NotNull
    public final SortedSetDocValues getSortedSet(@NotNull LeafReader reader2, @NotNull String field) throws IOException {
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        SortedSetDocValues dv = reader2.getSortedSetDocValues(field);
        if (dv == null) {
            SortedDocValues sorted = reader2.getSortedDocValues(field);
            if (sorted == null) {
                DocValuesType[] docValuesTypeArray = new DocValuesType[]{DocValuesType.SORTED, DocValuesType.SORTED_SET};
                this.checkField(reader2, field, docValuesTypeArray);
                return this.emptySortedSet();
            }
            dv = this.singleton(sorted);
        }
        return dv;
    }

    public final boolean isCacheable(@NotNull LeafReaderContext ctx, String ... fields) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)fields, (String)"fields");
        for (String field : fields) {
            FieldInfo fi = ctx.reader().getFieldInfos().fieldInfo(field);
            if (fi == null || fi.getDocValuesGen() <= -1L) continue;
            return false;
        }
        return true;
    }
}

