/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.util.Collection;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.IntCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongCompanionObject;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.index.BinaryDocValues;
import org.gnit.lucenekmp.index.DocValuesIterator;
import org.gnit.lucenekmp.index.DocValuesType;
import org.gnit.lucenekmp.index.NumericDocValues;
import org.gnit.lucenekmp.jdkport.IntExtKt;
import org.gnit.lucenekmp.jdkport.LongExtKt;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.IntroSorter;
import org.gnit.lucenekmp.util.PriorityQueue;
import org.gnit.lucenekmp.util.packed.PackedInts;
import org.gnit.lucenekmp.util.packed.PagedMutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\b&\u0018\u0000 92\u00020\u0001:\u0003789B)\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0005H&J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020'H&J\u0018\u0010$\u001a\u00020%2\u0006\u0010(\u001a\u00020\u00032\u0006\u0010)\u001a\u00020*H&J\b\u0010)\u001a\u00020*H&J\u0006\u0010+\u001a\u00020%J\b\u0010,\u001a\u00020\u0016H\u0016J\u0006\u0010 \u001a\u00020\u0003J\u0010\u0010-\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0003H\u0016J\u000e\u0010$\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0003J\u0018\u0010.\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u0005H\u0002J\u0018\u00100\u001a\u00020%2\u0006\u00101\u001a\u00020\u00032\u0006\u00102\u001a\u00020\u0003H\u0014J\u0010\u00103\u001a\u00020%2\u0006\u0010 \u001a\u00020\u0003H\u0014J\u0010\u00104\u001a\u00020%2\u0006\u0010 \u001a\u00020\u0003H\u0014J\b\u00105\u001a\u00020%H\u0004J\b\u00106\u001a\u00020\u0005H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\r\"\u0004\b\"\u0010#\u00a8\u0006:"}, d2={"Lorg/gnit/lucenekmp/index/DocValuesFieldUpdates;", "Lorg/gnit/lucenekmp/util/Accountable;", "maxDoc", "", "delGen", "", "field", "", "type", "Lorg/gnit/lucenekmp/index/DocValuesType;", "<init>", "(IJLjava/lang/String;Lorg/gnit/lucenekmp/index/DocValuesType;)V", "getMaxDoc", "()I", "getDelGen", "()J", "getField", "()Ljava/lang/String;", "getType", "()Lorg/gnit/lucenekmp/index/DocValuesType;", "bitsPerValue", "value", "", "finished", "getFinished", "()Z", "docs", "Lorg/gnit/lucenekmp/util/packed/PagedMutable;", "getDocs", "()Lorg/gnit/lucenekmp/util/packed/PagedMutable;", "setDocs", "(Lorg/gnit/lucenekmp/util/packed/PagedMutable;)V", "size", "getSize", "setSize", "(I)V", "add", "", "doc", "Lorg/gnit/lucenekmp/util/BytesRef;", "docId", "iterator", "Lorg/gnit/lucenekmp/index/DocValuesFieldUpdates$Iterator;", "finish", "any", "reset", "addInternal", "hasValueMask", "swap", "i", "j", "grow", "resize", "ensureFinished", "ramBytesUsed", "Iterator", "AbstractIterator", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nDocValuesFieldUpdates.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocValuesFieldUpdates.kt\norg/gnit/lucenekmp/index/DocValuesFieldUpdates\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 4 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,430:1\n1#2:431\n3#3,8:432\n10#4:440\n*S KotlinDebug\n*F\n+ 1 DocValuesFieldUpdates.kt\norg/gnit/lucenekmp/index/DocValuesFieldUpdates\n*L\n246#1:432,8\n246#1:440\n*E\n"})
public abstract class DocValuesFieldUpdates
implements Accountable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int maxDoc;
    private final long delGen;
    @NotNull
    private final String field;
    @NotNull
    private final DocValuesType type;
    private final int bitsPerValue;
    private boolean finished;
    @NotNull
    private PagedMutable docs;
    private int size;
    protected static final int PAGE_SIZE = 1024;
    private static final long HAS_VALUE_MASK = 1L;
    private static final long HAS_NO_VALUE_MASK = 0L;
    private static final int SHIFT = 1;

    protected DocValuesFieldUpdates(int maxDoc, long delGen, @NotNull String field, @NotNull DocValuesType type) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.maxDoc = maxDoc;
        this.delGen = delGen;
        this.field = field;
        this.type = type;
        this.bitsPerValue = PackedInts.INSTANCE.bitsRequired(this.maxDoc - 1) + 1;
        this.docs = new PagedMutable(1L, 1024, this.bitsPerValue, 0.25f);
    }

    protected final int getMaxDoc() {
        return this.maxDoc;
    }

    public final long getDelGen() {
        return this.delGen;
    }

    @NotNull
    public final String getField() {
        return this.field;
    }

    @NotNull
    public final DocValuesType getType() {
        return this.type;
    }

    public final boolean getFinished() {
        return this.finished;
    }

    @NotNull
    protected final PagedMutable getDocs() {
        return this.docs;
    }

    protected final void setDocs(@NotNull PagedMutable pagedMutable) {
        Intrinsics.checkNotNullParameter((Object)pagedMutable, (String)"<set-?>");
        this.docs = pagedMutable;
    }

    protected final int getSize() {
        return this.size;
    }

    protected final void setSize(int n) {
        this.size = n;
    }

    public abstract void add(int var1, long var2);

    public abstract void add(int var1, @NotNull BytesRef var2);

    public abstract void add(int var1, @NotNull Iterator var2);

    @NotNull
    public abstract Iterator iterator();

    public final void finish() {
        if (!(!this.finished)) {
            boolean $i$a$-check-DocValuesFieldUpdates$finish$22 = false;
            String $i$a$-check-DocValuesFieldUpdates$finish$22 = "already finished";
            throw new IllegalStateException($i$a$-check-DocValuesFieldUpdates$finish$22.toString());
        }
        this.finished = true;
        if ((long)this.size < this.docs.size()) {
            this.resize(this.size);
        }
        if (this.size > 0) {
            PackedInts.Mutable ords = PackedInts.INSTANCE.getMutable(this.size, PackedInts.INSTANCE.bitsRequired(this.size - 1), 0.25f);
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                ords.set(i, i);
            }
            new IntroSorter(ords, this){
                private long pivotDoc;
                private int pivotOrd;
                final /* synthetic */ PackedInts.Mutable $ords;
                final /* synthetic */ DocValuesFieldUpdates this$0;
                {
                    this.$ords = $ords;
                    this.this$0 = $receiver;
                }

                protected void swap(int i, int j) {
                    long tmpOrd = this.$ords.get(i);
                    this.$ords.set(i, this.$ords.get(j));
                    this.$ords.set(j, tmpOrd);
                    this.this$0.swap(i, j);
                }

                protected int compare(int i, int j) {
                    int cmp = LongExtKt.compare(LongCompanionObject.INSTANCE, this.this$0.getDocs().get(i) >>> 1, this.this$0.getDocs().get(j) >>> 1);
                    if (cmp == 0) {
                        cmp = (int)(this.$ords.get(i) - this.$ords.get(j));
                    }
                    return cmp;
                }

                public final long getPivotDoc() {
                    return this.pivotDoc;
                }

                public final void setPivotDoc(long l) {
                    this.pivotDoc = l;
                }

                public final int getPivotOrd() {
                    return this.pivotOrd;
                }

                public final void setPivotOrd(int n) {
                    this.pivotOrd = n;
                }

                protected void setPivot(int i) {
                    this.pivotDoc = this.this$0.getDocs().get(i) >>> 1;
                    this.pivotOrd = (int)this.$ords.get(i);
                }

                protected int comparePivot(int j) {
                    int cmp = LongExtKt.compare(LongCompanionObject.INSTANCE, this.pivotDoc, this.this$0.getDocs().get(j) >>> 1);
                    if (cmp == 0) {
                        cmp = this.pivotOrd - (int)this.$ords.get(j);
                    }
                    return cmp;
                }
            }.sort(0, this.size);
        }
    }

    public boolean any() {
        return this.size > 0;
    }

    public final int size() {
        return this.size;
    }

    public void reset(int doc) {
        this.addInternal(doc, 0L);
    }

    public final int add(int doc) {
        return this.addInternal(doc, 1L);
    }

    private final int addInternal(int doc, long hasValueMask) {
        if (!(!this.finished)) {
            boolean $i$a$-check-DocValuesFieldUpdates$addInternal$32 = false;
            String $i$a$-check-DocValuesFieldUpdates$addInternal$32 = "already finished";
            throw new IllegalStateException($i$a$-check-DocValuesFieldUpdates$addInternal$32.toString());
        }
        boolean condition$iv = doc < this.maxDoc;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        if (!(this.size != Integer.MAX_VALUE)) {
            boolean bl = false;
            String string = "cannot support more than Integer.MAX_VALUE doc/value entries";
            throw new IllegalStateException(string.toString());
        }
        if (this.docs.size() == (long)this.size) {
            this.grow(this.size + 1);
        }
        this.docs.set(this.size, (long)doc << 1 | hasValueMask);
        ++this.size;
        return this.size - 1;
    }

    protected void swap(int i, int j) {
        long tmpDoc = this.docs.get(j);
        this.docs.set(j, this.docs.get(i));
        this.docs.set(i, tmpDoc);
    }

    protected void grow(int size2) {
        this.docs = (PagedMutable)this.docs.grow(size2);
    }

    protected void resize(int size2) {
        this.docs = (PagedMutable)this.docs.resize(size2);
    }

    protected final void ensureFinished() {
        if (!this.finished) {
            boolean bl = false;
            String string = "call finish first";
            throw new IllegalStateException(string.toString());
        }
    }

    @Override
    public long ramBytesUsed() {
        return this.docs.ramBytesUsed() + (long)8 + (long)8 + (long)2 + (long)8 + (long)4;
    }

    @Override
    @NotNull
    public Collection<Accountable> getChildResources() {
        return Accountable.super.getChildResources();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000e\u001a\u00020\u0003H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u0007H$J\b\u0010\u0011\u001a\u00020\u0003H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/gnit/lucenekmp/index/DocValuesFieldUpdates$AbstractIterator;", "Lorg/gnit/lucenekmp/index/DocValuesFieldUpdates$Iterator;", "size", "", "docs", "Lorg/gnit/lucenekmp/util/packed/PagedMutable;", "delGen", "", "<init>", "(ILorg/gnit/lucenekmp/util/packed/PagedMutable;J)V", "idx", "doc", "hasValue", "", "nextDoc", "set", "", "docID", "core"})
    @SourceDebugExtension(value={"SMAP\nDocValuesFieldUpdates.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocValuesFieldUpdates.kt\norg/gnit/lucenekmp/index/DocValuesFieldUpdates$AbstractIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,430:1\n1#2:431\n*E\n"})
    public static abstract class AbstractIterator
    extends Iterator {
        private final int size;
        @NotNull
        private final PagedMutable docs;
        private final long delGen;
        private long idx;
        private int doc;
        private boolean hasValue;

        public AbstractIterator(int size2, @NotNull PagedMutable docs, long delGen) {
            Intrinsics.checkNotNullParameter((Object)docs, (String)"docs");
            this.size = size2;
            this.docs = docs;
            this.delGen = delGen;
            this.doc = -1;
        }

        @Override
        public int nextDoc() {
            long nextLongDoc;
            if (this.idx >= (long)this.size) {
                int n;
                int it = n = Integer.MAX_VALUE;
                boolean bl = false;
                this.doc = it;
                return n;
            }
            long longDoc = this.docs.get(this.idx);
            ++this.idx;
            while (this.idx < (long)this.size && longDoc >>> 1 == (nextLongDoc = this.docs.get(this.idx)) >>> 1) {
                longDoc = nextLongDoc;
                long l = this.idx;
                this.idx = l + 1L;
            }
            boolean bl = this.hasValue = (longDoc & 1L) > 0L;
            if (this.hasValue) {
                this.set(this.idx - 1L);
            }
            this.doc = (int)(longDoc >> 1);
            return this.doc;
        }

        protected abstract void set(long var1);

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public long delGen() {
            return this.delGen;
        }

        @Override
        public boolean hasValue() {
            return this.hasValue;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\n\u001a\u0004\u0018\u00010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r\u00a2\u0006\u0002\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/gnit/lucenekmp/index/DocValuesFieldUpdates$Companion;", "", "<init>", "()V", "PAGE_SIZE", "", "HAS_VALUE_MASK", "", "HAS_NO_VALUE_MASK", "SHIFT", "mergedIterator", "Lorg/gnit/lucenekmp/index/DocValuesFieldUpdates$Iterator;", "subs", "", "([Lorg/gnit/lucenekmp/index/DocValuesFieldUpdates$Iterator;)Lorg/gnit/lucenekmp/index/DocValuesFieldUpdates$Iterator;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Iterator mergedIterator(@NotNull Iterator[] subs) {
            Intrinsics.checkNotNullParameter((Object)subs, (String)"subs");
            if (subs.length == 1) {
                return subs[0];
            }
            int n = subs.length;
            PriorityQueue queue2 = new PriorityQueue<Iterator>(n){

                public boolean lessThan(Iterator a, Iterator b) {
                    Intrinsics.checkNotNullParameter((Object)a, (String)"a");
                    Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                    int cmp = IntExtKt.compare(IntCompanionObject.INSTANCE, a.docID(), b.docID());
                    if (cmp == 0) {
                        cmp = LongExtKt.compare(LongCompanionObject.INSTANCE, b.delGen(), a.delGen());
                        boolean condition$iv = cmp != 0;
                        boolean $i$f$assert = false;
                        if (_Assertions.ENABLED && !condition$iv) {
                            boolean bl = false;
                            String string = "assertion failed";
                            throw new AssertionError((Object)string);
                        }
                    }
                    return cmp < 0;
                }
            };
            for (Iterator sub : subs) {
                if (sub.nextDoc() == Integer.MAX_VALUE) continue;
                queue2.add(sub);
            }
            if (queue2.size() == 0) {
                return null;
            }
            return new Iterator(queue2){
                private int doc;
                final /* synthetic */ PriorityQueue<Iterator> $queue;
                {
                    this.$queue = $queue;
                    this.doc = -1;
                }

                public int nextDoc() {
                    while (true) {
                        if (this.$queue.size() == 0) {
                            this.doc = Integer.MAX_VALUE;
                            break;
                        }
                        int newDoc = this.$queue.top().docID();
                        if (newDoc != this.doc) {
                            boolean condition$iv = newDoc > this.doc;
                            boolean $i$f$assert = false;
                            if (_Assertions.ENABLED && !condition$iv) {
                                boolean bl = false;
                                String string = "doc=" + this.doc + " newDoc=" + newDoc;
                                throw new AssertionError((Object)string);
                            }
                            this.doc = newDoc;
                            break;
                        }
                        Iterator iterator2 = this.$queue.top().nextDoc() == Integer.MAX_VALUE ? this.$queue.pop() : this.$queue.updateTop();
                    }
                    return this.doc;
                }

                public int docID() {
                    return this.doc;
                }

                public long longValue() {
                    return this.$queue.top().longValue();
                }

                public BytesRef binaryValue() {
                    return this.$queue.top().binaryValue();
                }

                public long delGen() {
                    throw new UnsupportedOperationException();
                }

                public boolean hasValue() {
                    return this.$queue.top().hasValue();
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0007H&J\b\u0010\f\u001a\u00020\nH&J\b\u0010\r\u001a\u00020\u000eH&J\b\u0010\u000f\u001a\u00020\nH&J\b\u0010\u0010\u001a\u00020\u0005H&\u00a8\u0006\u0012"}, d2={"Lorg/gnit/lucenekmp/index/DocValuesFieldUpdates$Iterator;", "Lorg/gnit/lucenekmp/index/DocValuesIterator;", "<init>", "()V", "advanceExact", "", "target", "", "advance", "cost", "", "nextDoc", "longValue", "binaryValue", "Lorg/gnit/lucenekmp/util/BytesRef;", "delGen", "hasValue", "Companion", "core"})
    public static abstract class Iterator
    extends DocValuesIterator {
        @NotNull
        public static final Companion Companion = new Companion(null);

        @Override
        public boolean advanceExact(int target) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int advance(int target) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long cost() {
            throw new UnsupportedOperationException();
        }

        @Override
        public abstract int nextDoc();

        public abstract long longValue();

        @NotNull
        public abstract BytesRef binaryValue();

        public abstract long delGen();

        public abstract boolean hasValue();

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\n"}, d2={"Lorg/gnit/lucenekmp/index/DocValuesFieldUpdates$Iterator$Companion;", "", "<init>", "()V", "asBinaryDocValues", "Lorg/gnit/lucenekmp/index/BinaryDocValues;", "iterator", "Lorg/gnit/lucenekmp/index/DocValuesFieldUpdates$Iterator;", "asNumericDocValues", "Lorg/gnit/lucenekmp/index/NumericDocValues;", "core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final BinaryDocValues asBinaryDocValues(@NotNull Iterator iterator2) {
                Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
                return new BinaryDocValues(iterator2){
                    final /* synthetic */ Iterator $iterator;
                    {
                        this.$iterator = $iterator;
                    }

                    public int docID() {
                        return this.$iterator.docID();
                    }

                    public BytesRef binaryValue() {
                        return this.$iterator.binaryValue();
                    }

                    public boolean advanceExact(int target) {
                        return this.$iterator.advanceExact(target);
                    }

                    public int nextDoc() {
                        return this.$iterator.nextDoc();
                    }

                    public int advance(int target) {
                        return this.$iterator.advance(target);
                    }

                    public long cost() {
                        return this.$iterator.cost();
                    }
                };
            }

            @NotNull
            public final NumericDocValues asNumericDocValues(@NotNull Iterator iterator2) {
                Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
                return new NumericDocValues(iterator2){
                    final /* synthetic */ Iterator $iterator;
                    {
                        this.$iterator = $iterator;
                    }

                    public long longValue() {
                        return this.$iterator.longValue();
                    }

                    public boolean advanceExact(int target) {
                        throw new UnsupportedOperationException();
                    }

                    public int docID() {
                        return this.$iterator.docID();
                    }

                    public int nextDoc() {
                        return this.$iterator.nextDoc();
                    }

                    public int advance(int target) {
                        return this.$iterator.advance(target);
                    }

                    public long cost() {
                        return this.$iterator.cost();
                    }
                };
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

