/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.search.DocIdSet;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.util.BitSetIterator;
import org.gnit.lucenekmp.util.FixedBitSet;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0006\u0010\u0006\u001a\u00020\u0007R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/gnit/lucenekmp/index/DocsWithFieldSet;", "Lorg/gnit/lucenekmp/search/DocIdSet;", "<init>", "()V", "set", "Lorg/gnit/lucenekmp/util/FixedBitSet;", "cardinality", "", "lastDocId", "add", "", "docID", "ramBytesUsed", "", "iterator", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nDocsWithFieldSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocsWithFieldSet.kt\norg/gnit/lucenekmp/index/DocsWithFieldSet\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,58:1\n1#2:59\n*E\n"})
public final class DocsWithFieldSet
extends DocIdSet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private FixedBitSet set;
    private int cardinality;
    private int lastDocId = -1;
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.Companion.shallowSizeOfInstance(Reflection.getOrCreateKotlinClass(DocsWithFieldSet.class));

    public final void add(int docID) {
        if (!(docID > this.lastDocId)) {
            boolean bl = false;
            String string = "Out of order doc ids: last=" + this.lastDocId + ", next=" + docID;
            throw new IllegalArgumentException(string.toString());
        }
        if (this.set != null) {
            FixedBitSet fixedBitSet = this.set;
            Intrinsics.checkNotNull((Object)fixedBitSet);
            FixedBitSet fixedBitSet2 = this.set = FixedBitSet.Companion.ensureCapacity(fixedBitSet, docID);
            Intrinsics.checkNotNull((Object)fixedBitSet2);
            fixedBitSet2.set(docID);
        } else if (docID != this.cardinality) {
            FixedBitSet fixedBitSet = this.set = new FixedBitSet(docID + 1);
            Intrinsics.checkNotNull((Object)fixedBitSet);
            fixedBitSet.set(0, this.cardinality);
            FixedBitSet fixedBitSet3 = this.set;
            Intrinsics.checkNotNull((Object)fixedBitSet3);
            fixedBitSet3.set(docID);
        }
        this.lastDocId = docID;
        int n = this.cardinality;
        this.cardinality = n + 1;
    }

    @Override
    public long ramBytesUsed() {
        long l;
        if (this.set == null) {
            l = 0L;
        } else {
            FixedBitSet fixedBitSet = this.set;
            Intrinsics.checkNotNull((Object)fixedBitSet);
            l = fixedBitSet.ramBytesUsed();
        }
        return BASE_RAM_BYTES_USED + l;
    }

    @Override
    @NotNull
    public DocIdSetIterator iterator() {
        DocIdSetIterator docIdSetIterator;
        if (this.set != null) {
            FixedBitSet fixedBitSet = this.set;
            Intrinsics.checkNotNull((Object)fixedBitSet);
            docIdSetIterator = new BitSetIterator(fixedBitSet, this.cardinality);
        } else {
            docIdSetIterator = DocIdSetIterator.Companion.all(this.cardinality);
        }
        return docIdSetIterator;
    }

    public final int cardinality() {
        return this.cardinality;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gnit/lucenekmp/index/DocsWithFieldSet$Companion;", "", "<init>", "()V", "BASE_RAM_BYTES_USED", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

