/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArrayDeque;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Clock;
import kotlin.time.Duration;
import kotlin.time.DurationUnit;
import kotlin.time.Instant;
import org.gnit.lucenekmp.index.DocumentsWriter;
import org.gnit.lucenekmp.index.DocumentsWriterDeleteQueue;
import org.gnit.lucenekmp.index.DocumentsWriterFlushControl;
import org.gnit.lucenekmp.index.DocumentsWriterPerThread;
import org.gnit.lucenekmp.index.DocumentsWriterPerThreadPool;
import org.gnit.lucenekmp.index.DocumentsWriterStallControl;
import org.gnit.lucenekmp.index.FlushPolicy;
import org.gnit.lucenekmp.index.LiveIndexWriterConfig;
import org.gnit.lucenekmp.jdkport.ArrayDequeExtKt;
import org.gnit.lucenekmp.store.AlreadyClosedException;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.InfoStream;
import org.gnit.lucenekmp.util.ThreadInterruptedException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0016\u0018\u00002\u00020\u00012\u00060\u0002j\u0002`\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u000e\u001a\u00020\rJ\u0006\u00109\u001a\u00020\rJ\b\u0010:\u001a\u00020\rH\u0002J\b\u0010;\u001a\u00020\u001bH\u0002J\u0010\u0010<\u001a\u00020\u001b2\u0006\u0010=\u001a\u00020\rH\u0002J\b\u0010>\u001a\u00020\rH\u0002J\u0010\u0010?\u001a\u0004\u0018\u00010!2\u0006\u0010@\u001a\u00020!J\u001a\u0010A\u001a\u0004\u0018\u00010!2\u0006\u0010@\u001a\u00020!2\u0006\u0010B\u001a\u00020\u001bH\u0002J\u0010\u0010C\u001a\u00020\u001b2\u0006\u0010D\u001a\u00020\u001bH\u0002J\u000e\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020!J\b\u0010K\u001a\u00020\u001bH\u0002J\u0006\u0010L\u001a\u00020FJ\u000e\u0010M\u001a\u00020F2\u0006\u0010@\u001a\u00020!J\u000e\u0010N\u001a\u00020F2\u0006\u0010@\u001a\u00020!J\u0010\u0010O\u001a\u00020F2\u0006\u0010@\u001a\u00020!H\u0002J\u0010\u0010P\u001a\u00020!2\u0006\u0010@\u001a\u00020!H\u0002J\u0010\u0010Q\u001a\u00020F2\u0006\u0010@\u001a\u00020!H\u0002J\u0006\u0010R\u001a\u00020\u001bJ\u0006\u0010S\u001a\u00020FJ\u0006\u0010T\u001a\u00020!J\u000e\u0010U\u001a\u00020\rH\u0086@\u00a2\u0006\u0002\u0010VJ\u0010\u0010W\u001a\u00020\u001b2\u0006\u0010X\u001a\u00020YH\u0002J\u0010\u0010Z\u001a\u00020F2\u0006\u0010[\u001a\u00020YH\u0002J\u0006\u0010\\\u001a\u00020FJ\u000e\u0010]\u001a\u00020\u001b2\u0006\u0010[\u001a\u00020YJ\u0006\u0010^\u001a\u00020FJ\u0006\u0010_\u001a\u00020FJ\u0006\u0010`\u001a\u00020\u0014J\u0006\u0010a\u001a\u00020\u0014J\u0006\u0010b\u001a\u00020\u0014J\u0006\u0010c\u001a\u00020FJ\u0006\u0010d\u001a\u00020\u001bJ\u0006\u0010e\u001a\u000208J\u0006\u0010f\u001a\u00020!J\b\u0010g\u001a\u0004\u0018\u00010!J\u0006\u0010j\u001a\u00020\u001bJ\u0006\u0010k\u001a\u00020FJ\b\u0010l\u001a\u0004\u0018\u00010!J\b\u0010m\u001a\u00020\rH\u0016J\b\u0010n\u001a\u00020FH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\n\n\u0002\u0010\u001a\u0012\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u001b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020!0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010'\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0012R\u000e\u0010)\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010*\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u0012R\u000e\u0010,\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010.\u001a\u00020/\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u000e\u00102\u001a\u000203X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u000205X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010H\u001a\u00020IX\u0082.\u00a2\u0006\b\n\u0000\u0012\u0004\bJ\u0010\u0019R\u0011\u0010h\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\bi\u0010\u0012\u00a8\u0006o"}, d2={"Lorg/gnit/lucenekmp/index/DocumentsWriterFlushControl;", "Lorg/gnit/lucenekmp/util/Accountable;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "documentsWriter", "Lorg/gnit/lucenekmp/index/DocumentsWriter;", "config", "Lorg/gnit/lucenekmp/index/LiveIndexWriterConfig;", "<init>", "(Lorg/gnit/lucenekmp/index/DocumentsWriter;Lorg/gnit/lucenekmp/index/LiveIndexWriterConfig;)V", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "hardMaxBytesPerDWPT", "", "activeBytes", "value", "flushingBytes", "getFlushingBytes", "()J", "numPending", "", "numDocsSinceStalled", "flushDeletes", "Lkotlin/concurrent/atomics/AtomicBoolean;", "getFlushDeletes$annotations", "()V", "Ljava/util/concurrent/atomic/AtomicBoolean;", "", "isFullFlush", "()Z", "fullFlushMarkDone", "flushQueue", "Lkotlin/collections/ArrayDeque;", "Lorg/gnit/lucenekmp/index/DocumentsWriterPerThread;", "blockedFlushes", "flushingWriters", "", "maxConfiguredRamBuffer", "", "peakActiveBytes", "getPeakActiveBytes", "peakFlushBytes", "peakNetBytes", "getPeakNetBytes", "peakDelta", "flushByRAMWasDisabled", "stallControl", "Lorg/gnit/lucenekmp/index/DocumentsWriterStallControl;", "getStallControl", "()Lorg/gnit/lucenekmp/index/DocumentsWriterStallControl;", "perThreadPool", "Lorg/gnit/lucenekmp/index/DocumentsWriterPerThreadPool;", "flushPolicy", "Lorg/gnit/lucenekmp/index/FlushPolicy;", "closed", "infoStream", "Lorg/gnit/lucenekmp/util/InfoStream;", "netBytes", "stallLimitBytes", "assertMemory", "updatePeaks", "delta", "ramBufferGranularity", "doAfterDocument", "perThread", "checkout", "markPending", "assertNumDocsSinceStalled", "stalled", "doAfterFlush", "", "dwpt", "stallStartNS", "Lkotlin/time/Instant;", "getStallStartNS$annotations", "updateStallState", "waitForFlush", "setFlushPending", "doOnAbort", "checkoutAndBlock", "checkOutForFlush", "addFlushingDWPT", "getApplyAllDeletes", "setApplyAllDeletes", "obtainAndLock", "markForFullFlush", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "assertActiveDeleteQueue", "queue", "Lorg/gnit/lucenekmp/index/DocumentsWriterDeleteQueue;", "pruneBlockedQueue", "flushingQueue", "finishFullFlush", "assertBlockedFlushes", "abortFullFlushes", "abortPendingFlushes", "numQueuedFlushes", "numBlockedFlushes", "numFlushingDWPT", "waitIfStalled", "anyStalledThreads", "getInfoStream", "findLargestNonPendingWriter", "checkoutLargestNonPendingWriter", "deleteBytesUsed", "getDeleteBytesUsed", "getAndResetApplyAllDeletes", "doOnDelete", "nextPendingFlush", "ramBytesUsed", "close", "core"})
@SourceDebugExtension(value={"SMAP\nDocumentsWriterFlushControl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentsWriterFlushControl.kt\norg/gnit/lucenekmp/index/DocumentsWriterFlushControl\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,801:1\n8#2,2:802\n3#2,8:804\n3#2,8:813\n3#2,8:822\n3#2,8:831\n3#2,8:840\n3#2,8:849\n3#2,8:858\n3#2,8:867\n3#2,8:876\n3#2,8:885\n3#2,8:894\n3#2,8:903\n3#2,8:912\n3#2,8:921\n8#2,2:930\n8#2,2:932\n3#2,8:934\n3#2,8:943\n3#2,8:952\n3#2,8:961\n3#2,8:970\n8#2,2:979\n8#2,2:981\n8#2,2:983\n8#2,2:985\n8#2,2:988\n3#2,8:990\n3#2,8:999\n3#2,8:1008\n3#2,8:1017\n8#2,2:1026\n3#2,8:1028\n3#2,8:1037\n3#2,8:1046\n3#2,8:1055\n3#2,8:1064\n3#2,8:1073\n10#3:812\n10#3:821\n10#3:830\n10#3:839\n10#3:848\n10#3:857\n10#3:866\n10#3:875\n10#3:884\n10#3:893\n10#3:902\n10#3:911\n10#3:920\n10#3:929\n10#3:942\n10#3:951\n10#3:960\n10#3:969\n10#3:978\n10#3:998\n10#3:1007\n10#3:1016\n10#3:1025\n10#3:1036\n10#3:1045\n10#3:1054\n10#3:1063\n10#3:1072\n10#3:1081\n1#4:987\n*S KotlinDebug\n*F\n+ 1 DocumentsWriterFlushControl.kt\norg/gnit/lucenekmp/index/DocumentsWriterFlushControl\n*L\n149#1:802,2\n236#1:804,8\n239#1:813,8\n250#1:822,8\n268#1:831,8\n298#1:840,8\n303#1:849,8\n376#1:858,8\n384#1:867,8\n394#1:876,8\n395#1:885,8\n401#1:894,8\n406#1:903,8\n415#1:912,8\n416#1:921,8\n417#1:930,2\n418#1:932,2\n422#1:934,8\n433#1:943,8\n434#1:952,8\n435#1:961,8\n440#1:970,8\n449#1:979,2\n484#1:981,2\n505#1:983,2\n508#1:985,2\n537#1:988,2\n541#1:990,8\n549#1:999,8\n555#1:1008,8\n556#1:1017,8\n563#1:1026,2\n590#1:1028,8\n591#1:1037,8\n592#1:1046,8\n595#1:1055,8\n597#1:1064,8\n609#1:1073,8\n236#1:812\n239#1:821\n250#1:830\n268#1:839\n298#1:848\n303#1:857\n376#1:866\n384#1:875\n394#1:884\n395#1:893\n401#1:902\n406#1:911\n415#1:920\n416#1:929\n422#1:942\n433#1:951\n434#1:960\n435#1:969\n440#1:978\n541#1:998\n549#1:1007\n555#1:1016\n556#1:1025\n590#1:1036\n591#1:1045\n592#1:1054\n595#1:1063\n597#1:1072\n609#1:1081\n*E\n"})
public final class DocumentsWriterFlushControl
implements Accountable,
AutoCloseable {
    @NotNull
    private final DocumentsWriter documentsWriter;
    @NotNull
    private final LiveIndexWriterConfig config;
    @NotNull
    private final KLogger logger;
    private final long hardMaxBytesPerDWPT;
    private long activeBytes;
    private volatile long flushingBytes;
    private volatile int numPending;
    private int numDocsSinceStalled;
    @NotNull
    private final AtomicBoolean flushDeletes;
    private boolean isFullFlush;
    private boolean fullFlushMarkDone;
    @NotNull
    private final ArrayDeque<DocumentsWriterPerThread> flushQueue;
    @NotNull
    private final ArrayDeque<DocumentsWriterPerThread> blockedFlushes;
    @NotNull
    private final List<DocumentsWriterPerThread> flushingWriters;
    private double maxConfiguredRamBuffer;
    private long peakActiveBytes;
    private long peakFlushBytes;
    private long peakNetBytes;
    private long peakDelta;
    private boolean flushByRAMWasDisabled;
    @NotNull
    private final DocumentsWriterStallControl stallControl;
    @NotNull
    private final DocumentsWriterPerThreadPool perThreadPool;
    @NotNull
    private final FlushPolicy flushPolicy;
    private boolean closed;
    @NotNull
    private final InfoStream infoStream;
    private Instant stallStartNS;

    public DocumentsWriterFlushControl(@NotNull DocumentsWriter documentsWriter, @NotNull LiveIndexWriterConfig config) {
        Intrinsics.checkNotNullParameter((Object)documentsWriter, (String)"documentsWriter");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.documentsWriter = documentsWriter;
        this.config = config;
        this.logger = KotlinLogging.INSTANCE.logger(DocumentsWriterFlushControl::logger$lambda$0);
        this.hardMaxBytesPerDWPT = (long)this.config.getRAMPerThreadHardLimitMB() * 1024L * 1024L;
        this.flushDeletes = new AtomicBoolean(false);
        this.flushQueue = new ArrayDeque();
        this.blockedFlushes = new ArrayDeque();
        this.flushingWriters = new ArrayList();
        this.stallControl = new DocumentsWriterStallControl();
        this.perThreadPool = this.documentsWriter.getPerThreadPool();
        this.flushPolicy = this.config.getFlushPolicy();
        this.infoStream = this.config.getInfoStream();
    }

    public final long getFlushingBytes() {
        return this.flushingBytes;
    }

    private static /* synthetic */ void getFlushDeletes$annotations() {
    }

    public final boolean isFullFlush() {
        return this.isFullFlush;
    }

    public final long getPeakActiveBytes() {
        return this.peakActiveBytes;
    }

    public final long getPeakNetBytes() {
        return this.peakNetBytes;
    }

    @NotNull
    public final DocumentsWriterStallControl getStallControl() {
        return this.stallControl;
    }

    public final long activeBytes() {
        return this.activeBytes;
    }

    public final long netBytes() {
        return this.flushingBytes + this.activeBytes;
    }

    private final long stallLimitBytes() {
        double maxRamMB = this.config.getRAMBufferSizeMB();
        return !(maxRamMB == -1.0) ? (long)((double)2 * (maxRamMB * (double)1024 * (double)1024)) : Long.MAX_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean assertMemory() {
        double maxRamMB = this.config.getRAMBufferSizeMB();
        if (!(maxRamMB == -1.0) && !this.flushByRAMWasDisabled) {
            this.maxConfiguredRamBuffer = Math.max(maxRamMB, this.maxConfiguredRamBuffer);
            long ram = this.flushingBytes + this.activeBytes;
            long ramBufferBytes = (long)(this.maxConfiguredRamBuffer * (double)1024 * (double)1024);
            long expected = (long)2 * ramBufferBytes + (long)(this.numPending + this.numFlushingDWPT() + this.numBlockedFlushes()) * this.peakDelta + (long)this.numDocsSinceStalled * this.peakDelta;
            if (this.peakDelta < ramBufferBytes >> 1) {
                void condition$iv;
                boolean bl = ram <= expected;
                boolean $i$f$assert = false;
                if (_Assertions.ENABLED && condition$iv == false) {
                    boolean bl2 = false;
                    String string = "actual mem: " + ram + " byte, expected mem: " + expected + " byte, flush mem: " + this.flushingBytes + ", active mem: " + this.activeBytes + ", pending DWPT: " + this.numPending + ", flushing DWPT: " + this.numFlushingDWPT() + ", blocked DWPT: " + this.numBlockedFlushes() + ", peakDelta mem: " + this.peakDelta + " bytes, ramBufferBytes=" + ramBufferBytes + ", maxConfiguredRamBuffer=" + this.maxConfiguredRamBuffer;
                    throw new AssertionError((Object)string);
                }
            }
        } else {
            this.flushByRAMWasDisabled = true;
        }
        return true;
    }

    private final boolean updatePeaks(long delta) {
        this.peakActiveBytes = Math.max(this.peakActiveBytes, this.activeBytes);
        this.peakFlushBytes = Math.max(this.peakFlushBytes, this.flushingBytes);
        this.peakNetBytes = Math.max(this.peakNetBytes, this.netBytes());
        this.peakDelta = Math.max(this.peakDelta, delta);
        return true;
    }

    private final long ramBufferGranularity() {
        double ramBufferSizeMB = this.config.getRAMBufferSizeMB();
        if (ramBufferSizeMB == -1.0) {
            ramBufferSizeMB = this.config.getRAMPerThreadHardLimitMB();
        }
        long granularity = (long)(ramBufferSizeMB * 1024.0);
        granularity = Math.min(granularity, 16384L);
        return granularity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final DocumentsWriterPerThread doAfterDocument(@NotNull DocumentsWriterPerThread perThread) {
        boolean condition$iv;
        DocumentsWriterPerThread documentsWriterPerThread;
        Intrinsics.checkNotNullParameter((Object)perThread, (String)"perThread");
        long delta = perThread.getCommitLastBytesUsedDelta();
        if (this.config.getMaxBufferedDocs() == -1 && delta < this.ramBufferGranularity()) {
            return null;
        }
        perThread.commitLastBytesUsed(delta);
        try {
            if (perThread.isFlushPending()) {
                this.flushingBytes += delta;
                condition$iv = this.updatePeaks(delta);
                $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    boolean $i$a$-assert-AssertKt$assert$22 = false;
                    String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
                    throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
                }
            } else {
                this.activeBytes += delta;
                condition$iv = this.updatePeaks(delta);
                $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    boolean $i$a$-assert-AssertKt$assert$32 = false;
                    String $i$a$-assert-AssertKt$assert$32 = "assertion failed";
                    throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$32);
                }
                this.flushPolicy.onChange(this, perThread);
                if (!perThread.isFlushPending() && perThread.ramBytesUsed() > this.hardMaxBytesPerDWPT) {
                    this.setFlushPending(perThread);
                }
            }
            documentsWriterPerThread = this.checkout(perThread, false);
            boolean stalled = this.updateStallState();
            condition$iv = this.assertNumDocsSinceStalled(stalled) && this.assertMemory();
        }
        catch (Throwable throwable) {
            boolean stalled = this.updateStallState();
            boolean condition$iv2 = this.assertNumDocsSinceStalled(stalled) && this.assertMemory();
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv2) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            throw throwable;
        }
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean $i$a$-assert-AssertKt$assert$42 = false;
            String $i$a$-assert-AssertKt$assert$42 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$42);
        }
        return documentsWriterPerThread;
    }

    private final DocumentsWriterPerThread checkout(DocumentsWriterPerThread perThread, boolean markPending) {
        if (this.isFullFlush) {
            if (perThread.isFlushPending()) {
                this.checkoutAndBlock(perThread);
                return this.nextPendingFlush();
            }
        } else {
            if (markPending) {
                boolean condition$iv = !perThread.isFlushPending();
                boolean $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    boolean bl = false;
                    String string = "assertion failed";
                    throw new AssertionError((Object)string);
                }
                this.setFlushPending(perThread);
            }
            if (perThread.isFlushPending()) {
                return this.checkOutForFlush(perThread);
            }
        }
        return null;
    }

    private final boolean assertNumDocsSinceStalled(boolean stalled) {
        if (stalled) {
            int n = this.numDocsSinceStalled;
            this.numDocsSinceStalled = n + 1;
        } else {
            this.numDocsSinceStalled = 0;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doAfterFlush(@NotNull DocumentsWriterPerThread dwpt) {
        Intrinsics.checkNotNullParameter((Object)dwpt, (String)"dwpt");
        boolean condition$iv = this.flushingWriters.contains(dwpt);
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean $i$a$-assert-AssertKt$assert$22 = false;
            String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
        }
        try {
            this.flushingWriters.remove(dwpt);
            this.flushingBytes -= dwpt.getLastCommittedBytesUsed();
            this.logger.debug(() -> DocumentsWriterFlushControl.doAfterFlush$lambda$2(dwpt, this));
            condition$iv = this.assertMemory();
            $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
        }
        finally {
            this.updateStallState();
        }
    }

    private static /* synthetic */ void getStallStartNS$annotations() {
    }

    private final boolean updateStallState() {
        boolean stall;
        long limit = this.stallLimitBytes();
        boolean bl = stall = this.activeBytes + this.flushingBytes > limit && this.activeBytes < limit && !this.closed;
        if (this.infoStream.isEnabled("DWFC") && stall != this.stallControl.anyStalledThreads()) {
            if (stall) {
                this.infoStream.message("DW", "now stalling flushes: netBytes: " + (double)this.netBytes() / 1024.0 / 1024.0 + " MB flushBytes: " + (double)this.flushingBytes / 1024.0 / 1024.0 + " MB fullFlush: " + this.isFullFlush);
                this.stallStartNS = Clock.System.INSTANCE.now();
            } else {
                Instant instant = Clock.System.INSTANCE.now();
                Instant instant2 = this.stallStartNS;
                if (instant2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"stallStartNS");
                    instant2 = null;
                }
                this.infoStream.message("DW", "done stalling flushes for " + Duration.toString-impl$default((long)instant.minus-UwyO8pc(instant2), (DurationUnit)DurationUnit.MILLISECONDS, (int)0, (int)2, null) + " msec: netBytes: " + (double)this.netBytes() / 1024.0 / 1024.0 + " MB flushBytes: " + (double)this.flushingBytes / 1024.0 / 1024.0 + " MB fullFlush: " + this.isFullFlush);
            }
        }
        this.stallControl.updateStalled(stall);
        return stall;
    }

    public final void waitForFlush() {
        this.logger.debug(() -> DocumentsWriterFlushControl.waitForFlush$lambda$3(this));
        while (!((Collection)this.flushingWriters).isEmpty()) {
            try {
                this.logger.debug(() -> DocumentsWriterFlushControl.waitForFlush$lambda$4(this));
            }
            catch (CancellationException e) {
                throw new ThreadInterruptedException(e);
            }
        }
        this.logger.debug(DocumentsWriterFlushControl::waitForFlush$lambda$5);
    }

    public final void setFlushPending(@NotNull DocumentsWriterPerThread perThread) {
        Intrinsics.checkNotNullParameter((Object)perThread, (String)"perThread");
        boolean condition$iv = !perThread.isFlushPending();
        int $i$f$assert = 0;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        if (perThread.getNumDocsInRAM() > 0) {
            perThread.setFlushPending();
            long bytes = perThread.getLastCommittedBytesUsed();
            this.flushingBytes += bytes;
            this.activeBytes -= bytes;
            $i$f$assert = this.numPending;
            this.numPending = $i$f$assert + 1;
            this.logger.debug(() -> DocumentsWriterFlushControl.setFlushPending$lambda$6(perThread, this));
            boolean condition$iv2 = this.assertMemory();
            boolean $i$f$assert2 = false;
            if (_Assertions.ENABLED && !condition$iv2) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doOnAbort(@NotNull DocumentsWriterPerThread perThread) {
        Intrinsics.checkNotNullParameter((Object)perThread, (String)"perThread");
        try {
            boolean condition$iv = this.perThreadPool.isRegistered(perThread);
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean $i$a$-assert-AssertKt$assert$22 = false;
                String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
                throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
            }
            condition$iv = perThread.isHeldByCurrentThread();
            $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean $i$a$-assert-AssertKt$assert$32 = false;
                String $i$a$-assert-AssertKt$assert$32 = "assertion failed";
                throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$32);
            }
            if (perThread.isFlushPending()) {
                this.flushingBytes -= perThread.getLastCommittedBytesUsed();
            } else {
                this.activeBytes -= perThread.getLastCommittedBytesUsed();
            }
            condition$iv = this.assertMemory();
            $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean $i$a$-assert-AssertKt$assert$42 = false;
                String $i$a$-assert-AssertKt$assert$42 = "assertion failed";
                throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$42);
            }
        }
        finally {
            boolean checkedOut;
            this.updateStallState();
            boolean condition$iv = checkedOut = this.perThreadPool.checkout(perThread);
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean $i$a$-assert-AssertKt$assert$52 = false;
                String $i$a$-assert-AssertKt$assert$52 = "assertion failed";
                throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$52);
            }
        }
    }

    private final void checkoutAndBlock(DocumentsWriterPerThread perThread) {
        boolean checkedOut;
        int condition$iv = this.perThreadPool.isRegistered(perThread);
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && condition$iv == 0) {
            boolean $i$a$-assert-AssertKt$assert$22 = false;
            String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
        }
        condition$iv = perThread.isHeldByCurrentThread();
        $i$f$assert = false;
        if (_Assertions.ENABLED && condition$iv == 0) {
            boolean $i$a$-assert-AssertKt$assert$32 = false;
            String $i$a$-assert-AssertKt$assert$32 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$32);
        }
        condition$iv = perThread.isFlushPending();
        boolean $i$f$assert2 = false;
        if (_Assertions.ENABLED && condition$iv == 0) {
            boolean $i$a$-assert-DocumentsWriterFlushControl$checkoutAndBlock$32 = false;
            String $i$a$-assert-DocumentsWriterFlushControl$checkoutAndBlock$32 = "can not block non-pending threadstate";
            throw new AssertionError((Object)$i$a$-assert-DocumentsWriterFlushControl$checkoutAndBlock$32);
        }
        condition$iv = this.isFullFlush;
        $i$f$assert2 = false;
        if (_Assertions.ENABLED && condition$iv == 0) {
            boolean bl = false;
            String string = "can not block if fullFlush == false";
            throw new AssertionError((Object)string);
        }
        condition$iv = this.numPending;
        this.numPending = condition$iv + -1;
        this.blockedFlushes.add((Object)perThread);
        boolean condition$iv2 = checkedOut = this.perThreadPool.checkout(perThread);
        boolean $i$f$assert3 = false;
        if (_Assertions.ENABLED && !condition$iv2) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DocumentsWriterPerThread checkOutForFlush(DocumentsWriterPerThread perThread) {
        int condition$iv = perThread.isFlushPending();
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && condition$iv == 0) {
            boolean $i$a$-assert-AssertKt$assert$22 = false;
            String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
        }
        condition$iv = perThread.isHeldByCurrentThread();
        $i$f$assert = false;
        if (_Assertions.ENABLED && condition$iv == 0) {
            boolean $i$a$-assert-AssertKt$assert$32 = false;
            String $i$a$-assert-AssertKt$assert$32 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$32);
        }
        condition$iv = this.perThreadPool.isRegistered(perThread);
        $i$f$assert = false;
        if (_Assertions.ENABLED && condition$iv == 0) {
            boolean $i$a$-assert-AssertKt$assert$42 = false;
            String $i$a$-assert-AssertKt$assert$42 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$42);
        }
        try {
            boolean checkedOut;
            this.addFlushingDWPT(perThread);
            condition$iv = this.numPending;
            this.numPending = condition$iv + -1;
            boolean condition$iv2 = checkedOut = this.perThreadPool.checkout(perThread);
            boolean $i$f$assert2 = false;
            if (_Assertions.ENABLED && !condition$iv2) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            this.logger.debug(() -> DocumentsWriterFlushControl.checkOutForFlush$lambda$9(perThread, this));
            DocumentsWriterPerThread documentsWriterPerThread = perThread;
            return documentsWriterPerThread;
        }
        finally {
            this.updateStallState();
        }
    }

    private final void addFlushingDWPT(DocumentsWriterPerThread perThread) {
        boolean condition$iv = !this.flushingWriters.contains(perThread);
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "DWPT is already flushing";
            throw new AssertionError((Object)string);
        }
        this.flushingWriters.add(perThread);
        this.logger.debug(() -> DocumentsWriterFlushControl.addFlushingDWPT$lambda$11(perThread, this));
    }

    public final boolean getApplyAllDeletes() {
        return this.flushDeletes.get();
    }

    public final void setApplyAllDeletes() {
        this.flushDeletes.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final DocumentsWriterPerThread obtainAndLock() {
        while (!this.closed) {
            DocumentsWriterPerThread perThread = this.perThreadPool.getAndLock();
            if (Intrinsics.areEqual((Object)perThread.getDeleteQueue(), (Object)this.documentsWriter.getDeleteQueue())) {
                return perThread;
            }
            try {
                boolean condition$iv = this.isFullFlush && !this.fullFlushMarkDone;
                boolean $i$f$assert = false;
                if (!_Assertions.ENABLED || condition$iv) continue;
                boolean bl = false;
                String string = "found a stale DWPT but full flush mark phase is already done fullFlush: " + this.isFullFlush + " markDone: " + this.fullFlushMarkDone;
                throw new AssertionError((Object)string);
            }
            finally {
                perThread.unlock();
            }
        }
        throw new AlreadyClosedException("flush control is closed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object markForFullFlush(@NotNull Continuation<? super Long> $completion) {
        if (!($completion instanceof markForFullFlush.1)) ** GOTO lbl-1000
        var15_2 = $completion;
        if ((var15_2.label & -2147483648) != 0) {
            var15_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                long J$0;
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ DocumentsWriterFlushControl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.markForFullFlush((Continuation<? super Long>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var16_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                seqNo = 0L;
                var4_7 = this.isFullFlush == false;
                $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    $i$a$-assert-DocumentsWriterFlushControl$markForFullFlush$2 = false;
                    $i$a$-assert-DocumentsWriterFlushControl$markForFullFlush$2 = "called DWFC#markForFullFlush() while full flush is still running";
                    throw new AssertionError((Object)$i$a$-assert-DocumentsWriterFlushControl$markForFullFlush$2);
                }
                condition$iv = this.fullFlushMarkDone == false;
                $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    $i$a$-assert-DocumentsWriterFlushControl$markForFullFlush$3 = false;
                    $i$a$-assert-DocumentsWriterFlushControl$markForFullFlush$3 = "full flush collection marker is still set to true";
                    throw new AssertionError((Object)$i$a$-assert-DocumentsWriterFlushControl$markForFullFlush$3);
                }
                this.isFullFlush = true;
                flushingQueue = this.documentsWriter.getDeleteQueue();
                this.logger.debug((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, markForFullFlush$lambda$15(org.gnit.lucenekmp.index.DocumentsWriterFlushControl ), ()Ljava/lang/Object;)((DocumentsWriterFlushControl)this));
                $continuation.L$0 = flushingQueue;
                $continuation.J$0 = seqNo;
                $continuation.label = 1;
                v0 = this.perThreadPool.lockNewWriters((Continuation<? super Integer>)$continuation);
                if (v0 == var16_4) {
                    return var16_4;
                }
                ** GOTO lbl42
            }
            case 1: {
                seqNo = $continuation.J$0;
                flushingQueue = (DocumentsWriterDeleteQueue)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl42:
                // 3 sources

                var13_20 = this.documentsWriter;
                $continuation.L$0 = flushingQueue;
                $continuation.L$1 = var13_20;
                $continuation.J$0 = seqNo;
                $continuation.label = 2;
                v1 = this.perThreadPool.size((Continuation<? super Integer>)$continuation);
                ** if (v1 != var16_4) goto lbl51
lbl50:
                // 1 sources

                return var16_4;
lbl51:
                // 1 sources

                ** GOTO lbl60
            }
            case 2: {
                seqNo = $continuation.J$0;
                var13_20 = (DocumentsWriter)$continuation.L$1;
                flushingQueue = (DocumentsWriterDeleteQueue)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl60:
                // 2 sources

                seqNo = var13_20.resetDeleteQueue(((Number)v1).intValue());
                $continuation.L$0 = flushingQueue;
                $continuation.L$1 = null;
                $continuation.J$0 = seqNo;
                $continuation.label = 3;
                v2 = this.perThreadPool.unlockNewWriters((Continuation<? super Unit>)$continuation);
                ** if (v2 != var16_4) goto lbl68
lbl67:
                // 1 sources

                return var16_4;
lbl68:
                // 1 sources

                break;
            }
            case 3: {
                seqNo = $continuation.J$0;
                flushingQueue = (DocumentsWriterDeleteQueue)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
                break;
            }
        }
        catch (Throwable $i$f$assert) {
            $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)flushingQueue);
            $continuation.L$1 = $i$f$assert;
            $continuation.J$0 = seqNo;
            $continuation.label = 4;
            v3 = this.perThreadPool.unlockNewWriters((Continuation<? super Unit>)$continuation);
            if (v3 == var16_4) {
                return var16_4;
            }
            ** GOTO lbl90
        }
        {
            case 4: {
                seqNo = $continuation.J$0;
                $i$f$assert = (Throwable)$continuation.L$1;
                flushingQueue = (DocumentsWriterDeleteQueue)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl90:
                // 2 sources

                throw $i$f$assert;
            }
        }
        fullFlushBuffer = new ArrayList<E>();
        for (DocumentsWriterPerThread next : this.perThreadPool.filterAndLock((Function1<? super DocumentsWriterPerThread, Boolean>)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, markForFullFlush$lambda$16(org.gnit.lucenekmp.index.DocumentsWriterDeleteQueue org.gnit.lucenekmp.index.DocumentsWriterPerThread ), (Lorg/gnit/lucenekmp/index/DocumentsWriterPerThread;)Ljava/lang/Boolean;)((DocumentsWriterDeleteQueue)flushingQueue))) {
            try {
                if (next.getNumDocsInRAM() > 0) {
                    if (!next.isFlushPending()) {
                        this.setFlushPending(next);
                    }
                    if ((flushingDWPT = this.checkOutForFlush(next)) == null) {
                        $i$a$-checkNotNull-DocumentsWriterFlushControl$markForFullFlush$6 = false;
                        $i$a$-checkNotNull-DocumentsWriterFlushControl$markForFullFlush$6 = "DWPT must never be null here since we hold the lock and it holds documents";
                        throw new IllegalStateException($i$a$-checkNotNull-DocumentsWriterFlushControl$markForFullFlush$6.toString());
                    }
                    condition$iv = Intrinsics.areEqual((Object)next, (Object)flushingDWPT);
                    $i$f$assert = false;
                    if (_Assertions.ENABLED && !condition$iv) {
                        $i$a$-assert-DocumentsWriterFlushControl$markForFullFlush$7 = false;
                        $i$a$-assert-DocumentsWriterFlushControl$markForFullFlush$7 = "flushControl returned different DWPT";
                        throw new AssertionError((Object)$i$a$-assert-DocumentsWriterFlushControl$markForFullFlush$7);
                    }
                    Boxing.boxBoolean((boolean)fullFlushBuffer.add(flushingDWPT));
                    continue;
                }
                condition$iv = checkout = this.perThreadPool.checkout(next);
                $i$f$assert = false;
                if (!_Assertions.ENABLED || condition$iv) continue;
                $i$a$-assert-AssertKt$assert$1 = false;
                var12_35 = "assertion failed";
                throw new AssertionError((Object)var12_35);
            }
            finally {
                next.unlock();
            }
        }
        this.pruneBlockedQueue(flushingQueue);
        condition$iv = this.assertBlockedFlushes(this.documentsWriter.getDeleteQueue());
        $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            $i$a$-assert-AssertKt$assert$1 = false;
            $i$a$-assert-AssertKt$assert$1 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$1);
        }
        this.flushQueue.addAll((Collection)fullFlushBuffer);
        this.logger.debug((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, markForFullFlush$lambda$19(java.util.List org.gnit.lucenekmp.index.DocumentsWriterFlushControl ), ()Ljava/lang/Object;)((List)fullFlushBuffer, (DocumentsWriterFlushControl)this));
        this.updateStallState();
        this.fullFlushMarkDone = true;
        condition$iv = this.assertActiveDeleteQueue(this.documentsWriter.getDeleteQueue());
        $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            $i$a$-assert-AssertKt$assert$1 = false;
            $i$a$-assert-AssertKt$assert$1 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$1);
        }
        condition$iv = flushingQueue.getLastSequenceNumber() <= flushingQueue.getMaxSeqNo();
        $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            $i$a$-assert-AssertKt$assert$1 = false;
            var9_30 = "assertion failed";
            throw new AssertionError((Object)var9_30);
        }
        this.logger.debug((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, markForFullFlush$lambda$20(), ()Ljava/lang/Object;)());
        return Boxing.boxLong((long)seqNo);
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final boolean assertActiveDeleteQueue(DocumentsWriterDeleteQueue queue2) {
        for (DocumentsWriterPerThread next : this.perThreadPool) {
            boolean condition$iv = Intrinsics.areEqual((Object)next.getDeleteQueue(), (Object)queue2);
            boolean $i$f$assert = false;
            if (!_Assertions.ENABLED || condition$iv) continue;
            boolean bl = false;
            String string = "numDocs: " + next.getNumDocsInRAM();
            throw new AssertionError((Object)string);
        }
        return true;
    }

    private final void pruneBlockedQueue(DocumentsWriterDeleteQueue flushingQueue) {
        Iterator iterator2 = this.blockedFlushes.iterator();
        while (iterator2.hasNext()) {
            DocumentsWriterPerThread blockedFlush = (DocumentsWriterPerThread)iterator2.next();
            if (!Intrinsics.areEqual((Object)blockedFlush.getDeleteQueue(), (Object)flushingQueue)) continue;
            iterator2.remove();
            this.addFlushingDWPT(blockedFlush);
            this.flushQueue.add((Object)blockedFlush);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void finishFullFlush() {
        boolean condition$iv = this.isFullFlush;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean $i$a$-assert-AssertKt$assert$22 = false;
            String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
        }
        condition$iv = this.flushQueue.isEmpty();
        $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean $i$a$-assert-AssertKt$assert$32 = false;
            String $i$a$-assert-AssertKt$assert$32 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$32);
        }
        condition$iv = this.flushingWriters.isEmpty();
        $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean $i$a$-assert-AssertKt$assert$42 = false;
            String $i$a$-assert-AssertKt$assert$42 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$42);
        }
        try {
            if (!this.blockedFlushes.isEmpty()) {
                condition$iv = this.assertBlockedFlushes(this.documentsWriter.getDeleteQueue());
                $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    boolean $i$a$-assert-AssertKt$assert$52 = false;
                    String $i$a$-assert-AssertKt$assert$52 = "assertion failed";
                    throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$52);
                }
                this.pruneBlockedQueue(this.documentsWriter.getDeleteQueue());
                condition$iv = this.blockedFlushes.isEmpty();
                $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    boolean bl = false;
                    String string = "assertion failed";
                    throw new AssertionError((Object)string);
                }
            }
        }
        finally {
            this.fullFlushMarkDone = this.isFullFlush = false;
            this.logger.debug(DocumentsWriterFlushControl::finishFullFlush$lambda$22);
            this.updateStallState();
        }
    }

    public final boolean assertBlockedFlushes(@NotNull DocumentsWriterDeleteQueue flushingQueue) {
        Intrinsics.checkNotNullParameter((Object)flushingQueue, (String)"flushingQueue");
        for (DocumentsWriterPerThread blockedFlush : this.blockedFlushes) {
            boolean condition$iv = Intrinsics.areEqual((Object)blockedFlush.getDeleteQueue(), (Object)flushingQueue);
            boolean $i$f$assert = false;
            if (!_Assertions.ENABLED || condition$iv) continue;
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void abortFullFlushes() {
        try {
            this.abortPendingFlushes();
        }
        finally {
            this.fullFlushMarkDone = this.isFullFlush = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void abortPendingFlushes() {
        try {
            for (DocumentsWriterPerThread dwpt : this.flushQueue) {
                try {
                    this.documentsWriter.subtractFlushedNumDocs(dwpt.getNumDocsInRAM());
                    dwpt.abort();
                }
                catch (Exception exception) {}
                continue;
                finally {
                    this.doAfterFlush(dwpt);
                }
            }
            for (DocumentsWriterPerThread blockedFlush : this.blockedFlushes) {
                try {
                    this.addFlushingDWPT(blockedFlush);
                    this.documentsWriter.subtractFlushedNumDocs(blockedFlush.getNumDocsInRAM());
                    blockedFlush.abort();
                }
                catch (Exception exception) {}
                continue;
                finally {
                    this.doAfterFlush(blockedFlush);
                }
            }
        }
        finally {
            this.logger.debug(() -> DocumentsWriterFlushControl.abortPendingFlushes$lambda$23(this));
            this.flushQueue.clear();
            this.blockedFlushes.clear();
            this.updateStallState();
        }
    }

    public final int numQueuedFlushes() {
        return this.flushQueue.size();
    }

    public final int numBlockedFlushes() {
        return this.blockedFlushes.size();
    }

    public final int numFlushingDWPT() {
        return this.flushingWriters.size();
    }

    public final void waitIfStalled() {
        this.stallControl.waitIfStalled();
    }

    public final boolean anyStalledThreads() {
        return this.stallControl.anyStalledThreads();
    }

    @NotNull
    public final InfoStream getInfoStream() {
        return this.infoStream;
    }

    @NotNull
    public final DocumentsWriterPerThread findLargestNonPendingWriter() {
        DocumentsWriterPerThread maxRamUsingWriter = null;
        long maxRamSoFar = -1L;
        int count = 0;
        for (DocumentsWriterPerThread next : this.perThreadPool) {
            if (next.isFlushPending() || next.getNumDocsInRAM() <= 0) continue;
            long nextRam = next.getLastCommittedBytesUsed();
            if (this.infoStream.isEnabled("FP")) {
                this.infoStream.message("FP", "thread state has " + nextRam + " bytes; docInRAM=" + next.getNumDocsInRAM());
            }
            ++count;
            if (nextRam <= maxRamSoFar) continue;
            maxRamSoFar = nextRam;
            maxRamUsingWriter = next;
        }
        if (this.infoStream.isEnabled("FP")) {
            this.infoStream.message("FP", count + " in-use non-flushing threads states");
        }
        DocumentsWriterPerThread documentsWriterPerThread = maxRamUsingWriter;
        Intrinsics.checkNotNull(documentsWriterPerThread);
        return documentsWriterPerThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final DocumentsWriterPerThread checkoutLargestNonPendingWriter() {
        DocumentsWriterPerThread largestNonPendingWriter = this.findLargestNonPendingWriter();
        if (largestNonPendingWriter != null) {
            largestNonPendingWriter.lock();
            try {
                if (this.perThreadPool.isRegistered(largestNonPendingWriter)) {
                    DocumentsWriterPerThread documentsWriterPerThread;
                    try {
                        documentsWriterPerThread = this.checkout(largestNonPendingWriter, !largestNonPendingWriter.isFlushPending());
                        this.updateStallState();
                    }
                    catch (Throwable throwable) {
                        this.updateStallState();
                        throw throwable;
                    }
                    return documentsWriterPerThread;
                }
            }
            finally {
                largestNonPendingWriter.unlock();
            }
        }
        return null;
    }

    public final long getDeleteBytesUsed() {
        return this.documentsWriter.getDeleteQueue().ramBytesUsed();
    }

    public final boolean getAndResetApplyAllDeletes() {
        if (this.flushDeletes.get()) {
            this.flushDeletes.set(false);
            return true;
        }
        return false;
    }

    public final void doOnDelete() {
        this.flushPolicy.onChange(this, null);
        this.updateStallState();
    }

    @Nullable
    public final DocumentsWriterPerThread nextPendingFlush() {
        this.logger.debug(DocumentsWriterFlushControl::nextPendingFlush$lambda$24);
        DocumentsWriterPerThread next = ArrayDequeExtKt.poll(this.flushQueue);
        if (next == null) {
            this.logger.debug(() -> DocumentsWriterFlushControl.nextPendingFlush$lambda$25(this));
            return null;
        }
        this.logger.debug(() -> DocumentsWriterFlushControl.nextPendingFlush$lambda$26(next));
        return next;
    }

    @Override
    public long ramBytesUsed() {
        return this.activeBytes + this.flushingBytes + this.getDeleteBytesUsed();
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    @NotNull
    public Collection<Accountable> getChildResources() {
        return Accountable.super.getChildResources();
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object doAfterFlush$lambda$2(DocumentsWriterPerThread $dwpt, DocumentsWriterFlushControl this$0) {
        return "DWFC.doAfterFlush() seg=" + $dwpt.getSegmentInfo().getName() + " flushingWriters=" + this$0.flushingWriters.size() + " flushingBytes=" + this$0.flushingBytes;
    }

    private static final Object waitForFlush$lambda$3(DocumentsWriterFlushControl this$0) {
        return "DWFC.waitForFlush() enter: flushingWriters=" + this$0.flushingWriters.size() + " queued=" + this$0.flushQueue.size() + " blocked=" + this$0.blockedFlushes.size() + " fullFlush=" + this$0.isFullFlush;
    }

    private static final Object waitForFlush$lambda$4(DocumentsWriterFlushControl this$0) {
        return "DWFC.waitForFlush() loop: flushingWriters=" + this$0.flushingWriters.size() + " queued=" + this$0.flushQueue.size() + " blocked=" + this$0.blockedFlushes.size();
    }

    private static final Object waitForFlush$lambda$5() {
        return "DWFC.waitForFlush() exit";
    }

    private static final Object setFlushPending$lambda$6(DocumentsWriterPerThread $perThread, DocumentsWriterFlushControl this$0) {
        return "DWFC.setFlushPending() seg=" + $perThread.getSegmentInfo().getName() + " numDocs=" + $perThread.getNumDocsInRAM() + " numPending=" + this$0.numPending + " activeBytes=" + this$0.activeBytes + " flushingBytes=" + this$0.flushingBytes;
    }

    private static final Object checkOutForFlush$lambda$9(DocumentsWriterPerThread $perThread, DocumentsWriterFlushControl this$0) {
        return "DWFC.checkOutForFlush() seg=" + $perThread.getSegmentInfo().getName() + " numPending=" + this$0.numPending + " flushingWriters=" + this$0.flushingWriters.size();
    }

    private static final Object addFlushingDWPT$lambda$11(DocumentsWriterPerThread $perThread, DocumentsWriterFlushControl this$0) {
        return "DWFC.addFlushingDWPT() seg=" + $perThread.getSegmentInfo().getName() + " flushingWriters=" + this$0.flushingWriters.size();
    }

    private static final Object markForFullFlush$lambda$15(DocumentsWriterFlushControl this$0) {
        return "DWFC.markForFullFlush() enter: activeBytes=" + this$0.activeBytes + " flushingBytes=" + this$0.flushingBytes + " numPending=" + this$0.numPending;
    }

    private static final boolean markForFullFlush$lambda$16(DocumentsWriterDeleteQueue $flushingQueue, DocumentsWriterPerThread dwpt) {
        Intrinsics.checkNotNullParameter((Object)dwpt, (String)"dwpt");
        return Intrinsics.areEqual((Object)dwpt.getDeleteQueue(), (Object)$flushingQueue);
    }

    private static final Object markForFullFlush$lambda$19(List $fullFlushBuffer, DocumentsWriterFlushControl this$0) {
        return "DWFC.markForFullFlush() collected: toFlush=" + $fullFlushBuffer.size() + " queued=" + this$0.flushQueue.size() + " blocked=" + this$0.blockedFlushes.size();
    }

    private static final Object markForFullFlush$lambda$20() {
        return "DWFC.markForFullFlush() exit: seqNo will be set by resetDeleteQueue";
    }

    private static final Object finishFullFlush$lambda$22() {
        return "DWFC.finishFullFlush(): fullFlush cleared";
    }

    private static final Object abortPendingFlushes$lambda$23(DocumentsWriterFlushControl this$0) {
        return "DWFC.abortPendingFlushes(): clearing queues queued=" + this$0.flushQueue.size() + " blocked=" + this$0.blockedFlushes.size();
    }

    private static final Object nextPendingFlush$lambda$24() {
        return "DWFC.nextPendingFlush() called";
    }

    private static final Object nextPendingFlush$lambda$25(DocumentsWriterFlushControl this$0) {
        return "DWFC.nextPendingFlush() poll was null. queued=" + this$0.flushQueue.size() + " fullFlush=" + this$0.isFullFlush + " numPending=" + this$0.numPending;
    }

    private static final Object nextPendingFlush$lambda$26(DocumentsWriterPerThread $next) {
        return "DWFC.nextPendingFlush() -> seg=" + $next.getSegmentInfo().getName() + " docsInRAM=" + $next.getNumDocsInRAM();
    }
}

