/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArrayDeque;
import kotlin.concurrent.atomics.AtomicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.index.DocumentsWriterPerThread;
import org.gnit.lucenekmp.index.FrozenBufferedUpdates;
import org.gnit.lucenekmp.jdkport.ArrayDequeExtKt;
import org.gnit.lucenekmp.jdkport.ReentrantLock;
import org.gnit.lucenekmp.util.IOConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\"B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u000e\u001a\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\u0016\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0006J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001b\u001a\u00020\u00122\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u001dH\u0002J\u0014\u0010\u001e\u001a\u00020\u00122\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u001dJ\u0014\u0010\u001f\u001a\u00020\u00122\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u001dJ\u0006\u0010 \u001a\u00020!R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00060\bj\u0002`\tX\u0082\u0004\u00a2\u0006\n\n\u0002\u0010\u000b\u0012\u0004\b\n\u0010\u0003R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/gnit/lucenekmp/index/DocumentsWriterFlushQueue;", "", "<init>", "()V", "queue", "Lkotlin/collections/ArrayDeque;", "Lorg/gnit/lucenekmp/index/DocumentsWriterFlushQueue$FlushTicket;", "ticketCount", "Lkotlin/concurrent/atomics/AtomicInt;", "Lorg/gnit/lucenekmp/jdkport/AtomicInteger;", "getTicketCount$annotations", "Ljava/util/concurrent/atomic/AtomicInteger;", "purgeLock", "Lorg/gnit/lucenekmp/jdkport/ReentrantLock;", "addTicket", "ticketSupplier", "Lkotlin/Function0;", "incTickets", "", "decTickets", "addSegment", "ticket", "segment", "Lorg/gnit/lucenekmp/index/DocumentsWriterPerThread$FlushedSegment;", "markTicketFailed", "hasTickets", "", "innerPurge", "consumer", "Lorg/gnit/lucenekmp/util/IOConsumer;", "forcePurge", "tryPurge", "getTicketCount", "", "FlushTicket", "core"})
@SourceDebugExtension(value={"SMAP\nDocumentsWriterFlushQueue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentsWriterFlushQueue.kt\norg/gnit/lucenekmp/index/DocumentsWriterFlushQueue\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,181:1\n3#2,8:182\n3#2,8:191\n3#2,8:200\n3#2,8:209\n8#2,2:218\n3#2,8:220\n3#2,8:229\n10#3:190\n10#3:199\n10#3:208\n10#3:217\n10#3:228\n10#3:237\n*S KotlinDebug\n*F\n+ 1 DocumentsWriterFlushQueue.kt\norg/gnit/lucenekmp/index/DocumentsWriterFlushQueue\n*L\n52#1:182,8\n58#1:191,8\n64#1:200,8\n73#1:209,8\n80#1:218,2\n86#1:220,8\n104#1:229,8\n52#1:190\n58#1:199\n64#1:208\n73#1:217\n86#1:228\n104#1:237\n*E\n"})
public final class DocumentsWriterFlushQueue {
    @NotNull
    private final ArrayDeque<FlushTicket> queue = new ArrayDeque();
    @NotNull
    private final AtomicInteger ticketCount = new AtomicInteger(0);
    @NotNull
    private final ReentrantLock purgeLock = new ReentrantLock();

    private static /* synthetic */ void getTicketCount$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final FlushTicket addTicket(@NotNull Function0<FlushTicket> ticketSupplier) throws IOException {
        Intrinsics.checkNotNullParameter(ticketSupplier, (String)"ticketSupplier");
        this.incTickets();
        boolean success = false;
        try {
            FlushTicket ticket = (FlushTicket)ticketSupplier.invoke();
            if (ticket != null) {
                this.queue.add((Object)ticket);
                success = true;
            }
            FlushTicket flushTicket = ticket;
            return flushTicket;
        }
        finally {
            if (!success) {
                this.decTickets();
            }
        }
    }

    private final void incTickets() {
        int numTickets = AtomicsKt.incrementAndFetch((AtomicInteger)this.ticketCount);
        boolean condition$iv = numTickets > 0;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    private final void decTickets() {
        int numTickets = AtomicsKt.decrementAndFetch((AtomicInteger)this.ticketCount);
        boolean condition$iv = numTickets >= 0;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    public final void addSegment(@NotNull FlushTicket ticket, @NotNull DocumentsWriterPerThread.FlushedSegment segment) {
        Intrinsics.checkNotNullParameter((Object)ticket, (String)"ticket");
        Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
        boolean condition$iv = ticket.getHasSegment();
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        ticket.setSegment(segment);
    }

    public final void markTicketFailed(@NotNull FlushTicket ticket) {
        Intrinsics.checkNotNullParameter((Object)ticket, (String)"ticket");
        boolean condition$iv = ticket.getHasSegment();
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        ticket.setFailed();
    }

    public final boolean hasTickets() {
        boolean condition$iv = this.ticketCount.get() >= 0;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "ticketCount should be >= 0 but was: " + this.ticketCount.get();
            throw new AssertionError((Object)string);
        }
        return this.ticketCount.get() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void innerPurge(IOConsumer<FlushTicket> consumer) throws IOException {
        boolean condition$iv = this.purgeLock.isHeldByCurrentThread();
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean $i$a$-assert-AssertKt$assert$22 = false;
            String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
        }
        while (true) {
            FlushTicket head2;
            FlushTicket flushTicket = head2 = ArrayDequeExtKt.peek(this.queue);
            if (flushTicket == null) return;
            if (!flushTicket.canPublish()) return;
            boolean bl = true;
            boolean canPublish = bl;
            if (!canPublish) return;
            try {
                FlushTicket flushTicket2 = head2;
                Intrinsics.checkNotNull((Object)flushTicket2);
                consumer.accept(flushTicket2);
                continue;
            }
            finally {
                FlushTicket poll2 = ArrayDequeExtKt.poll(this.queue);
                this.decTickets();
                boolean condition$iv2 = Intrinsics.areEqual((Object)poll2, (Object)head2);
                boolean $i$f$assert2 = false;
                if (!_Assertions.ENABLED || condition$iv2) continue;
                boolean $i$a$-assert-AssertKt$assert$32 = false;
                String $i$a$-assert-AssertKt$assert$32 = "assertion failed";
                throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$32);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void forcePurge(@NotNull IOConsumer<FlushTicket> consumer) throws IOException {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        this.purgeLock.lock();
        try {
            this.innerPurge(consumer);
        }
        finally {
            this.purgeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void tryPurge(@NotNull IOConsumer<FlushTicket> consumer) throws IOException {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        if (this.purgeLock.tryLock()) {
            try {
                this.innerPurge(consumer);
            }
            finally {
                this.purgeLock.unlock();
            }
        }
    }

    public final int getTicketCount() {
        return this.ticketCount.get();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u000e\u001a\u00020\u0005J\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\u0012\u001a\u00020\u0010J\b\u0010\u0016\u001a\u0004\u0018\u00010\u0003R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lorg/gnit/lucenekmp/index/DocumentsWriterFlushQueue$FlushTicket;", "", "frozenUpdates", "Lorg/gnit/lucenekmp/index/FrozenBufferedUpdates;", "hasSegment", "", "<init>", "(Lorg/gnit/lucenekmp/index/FrozenBufferedUpdates;Z)V", "getHasSegment", "()Z", "segment", "Lorg/gnit/lucenekmp/index/DocumentsWriterPerThread$FlushedSegment;", "failed", "published", "canPublish", "markPublished", "", "setSegment", "setFailed", "flushedSegment", "getFlushedSegment", "()Lorg/gnit/lucenekmp/index/DocumentsWriterPerThread$FlushedSegment;", "getFrozenUpdates", "core"})
    @SourceDebugExtension(value={"SMAP\nDocumentsWriterFlushQueue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentsWriterFlushQueue.kt\norg/gnit/lucenekmp/index/DocumentsWriterFlushQueue$FlushTicket\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,181:1\n8#2,2:182\n3#2,8:184\n3#2,8:193\n10#3:192\n10#3:201\n*S KotlinDebug\n*F\n+ 1 DocumentsWriterFlushQueue.kt\norg/gnit/lucenekmp/index/DocumentsWriterFlushQueue$FlushTicket\n*L\n154#1:182,2\n159#1:184,8\n164#1:193,8\n159#1:192\n164#1:201\n*E\n"})
    public static final class FlushTicket {
        @Nullable
        private final FrozenBufferedUpdates frozenUpdates;
        private final boolean hasSegment;
        @Nullable
        private DocumentsWriterPerThread.FlushedSegment segment;
        private boolean failed;
        private boolean published;

        public FlushTicket(@Nullable FrozenBufferedUpdates frozenUpdates, boolean hasSegment) {
            this.frozenUpdates = frozenUpdates;
            this.hasSegment = hasSegment;
        }

        public final boolean getHasSegment() {
            return this.hasSegment;
        }

        public final boolean canPublish() {
            return !this.hasSegment || this.segment != null || this.failed;
        }

        public final void markPublished() {
            boolean condition$iv = !this.published;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "ticket was already published - can not publish twice";
                throw new AssertionError((Object)string);
            }
            this.published = true;
        }

        public final void setSegment(@NotNull DocumentsWriterPerThread.FlushedSegment segment) {
            Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
            boolean condition$iv = !this.failed;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            this.segment = segment;
        }

        public final void setFailed() {
            boolean condition$iv = this.segment == null;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            this.failed = true;
        }

        @Nullable
        public final DocumentsWriterPerThread.FlushedSegment getFlushedSegment() {
            return this.segment;
        }

        @Nullable
        public final FrozenBufferedUpdates getFrozenUpdates() {
            return this.frozenUpdates;
        }
    }
}

