/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.atomics.AtomicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Clock;
import kotlin.time.Duration;
import kotlin.time.DurationUnit;
import kotlin.time.Instant;
import org.gnit.lucenekmp.codecs.Codec;
import org.gnit.lucenekmp.document.NumericDocValuesField;
import org.gnit.lucenekmp.index.BufferedUpdates;
import org.gnit.lucenekmp.index.DocumentsWriter;
import org.gnit.lucenekmp.index.DocumentsWriterDeleteQueue;
import org.gnit.lucenekmp.index.FieldInfos;
import org.gnit.lucenekmp.index.FrozenBufferedUpdates;
import org.gnit.lucenekmp.index.IndexWriter;
import org.gnit.lucenekmp.index.IndexableField;
import org.gnit.lucenekmp.index.IndexingChain;
import org.gnit.lucenekmp.index.LiveIndexWriterConfig;
import org.gnit.lucenekmp.index.PendingSoftDeletes;
import org.gnit.lucenekmp.index.SegmentCommitInfo;
import org.gnit.lucenekmp.index.SegmentInfo;
import org.gnit.lucenekmp.index.SegmentWriteState;
import org.gnit.lucenekmp.index.Sorter;
import org.gnit.lucenekmp.jdkport.Condition;
import org.gnit.lucenekmp.jdkport.InterruptedException;
import org.gnit.lucenekmp.jdkport.Lock;
import org.gnit.lucenekmp.jdkport.ReentrantLock;
import org.gnit.lucenekmp.jdkport.TimeUnit;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.store.Directory;
import org.gnit.lucenekmp.store.FlushInfo;
import org.gnit.lucenekmp.store.IOContext;
import org.gnit.lucenekmp.store.TrackingDirectoryWrapper;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.Bits;
import org.gnit.lucenekmp.util.FixedBitSet;
import org.gnit.lucenekmp.util.InfoStream;
import org.gnit.lucenekmp.util.SetOnce;
import org.gnit.lucenekmp.util.StringHelper;
import org.gnit.lucenekmp.util.Version;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008c\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001f\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u0084\u00012\u00020\u00012\u00020\u0002:\u0004\u0083\u0001\u0084\u0001BO\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001cH\u0002J\u0006\u0010 \u001a\u00020\u001eJ\u000e\u0010G\u001a\u00020\u001e2\u0006\u0010H\u001a\u00020\u0006J\b\u0010I\u001a\u00020\u001eH\u0002J@\u0010J\u001a\u0002032\u0016\u0010K\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020M0L0L2\f\u0010N\u001a\b\u0012\u0002\b\u0003\u0018\u00010O2\u0006\u0010P\u001a\u00020Q2\n\u0010R\u001a\u00060Sj\u0002`TJ$\u0010U\u001a\b\u0012\u0004\u0012\u00020M0L2\f\u0010V\u001a\b\u0012\u0004\u0012\u00020M0L2\u0006\u0010D\u001a\u00020MH\u0002J\u001e\u0010W\u001a\u0002032\f\u0010N\u001a\b\u0012\u0002\b\u0003\u0018\u00010O2\u0006\u0010X\u001a\u00020\u0004H\u0002J\u0010\u0010Y\u001a\u00020\u001e2\u0006\u0010Z\u001a\u00020\u0004H\u0002J\b\u0010[\u001a\u0004\u0018\u00010\\J\u0010\u0010]\u001a\u0004\u0018\u00010^2\u0006\u0010P\u001a\u00020QJ\u0018\u0010_\u001a\u00020\u001e2\u0006\u0010`\u001a\u00020\u00062\u0006\u0010P\u001a\u00020QH\u0002J\f\u0010c\u001a\b\u0012\u0004\u0012\u00020\u00060bJ\u0018\u0010d\u001a\u00020e2\u0006\u0010f\u001a\u00020g2\u0006\u0010h\u001a\u00020iH\u0002J \u0010j\u001a\u00020\u001e2\u0006\u0010k\u001a\u00020^2\b\u0010h\u001a\u0004\u0018\u00010i2\u0006\u0010P\u001a\u00020QJ\u0006\u0010l\u001a\u00020-J\b\u0010m\u001a\u000203H\u0016J\b\u0010r\u001a\u00020\u0006H\u0016J\u0006\u0010s\u001a\u00020\u0013J\u0006\u0010u\u001a\u00020\u001eJ\u000e\u0010v\u001a\u00020\u001e2\u0006\u0010w\u001a\u000203J\b\u0010?\u001a\u00020\u001eH\u0016J\b\u0010z\u001a\u00020\u001eH\u0016J\b\u0010{\u001a\u00020\u0013H\u0016J\u0018\u0010{\u001a\u00020\u00132\u0006\u0010|\u001a\u0002032\u0006\u0010}\u001a\u00020~H\u0016J\t\u0010\u0080\u0001\u001a\u00020\u001eH\u0016J\n\u0010\u0081\u0001\u001a\u00030\u0082\u0001H\u0016J\u0006\u00107\u001a\u00020\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\n\n\u0002\u0010\u001a\u0012\u0004\b\u0018\u0010\u0019R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\t\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010/\u001a\u00020\u00132\u0006\u0010.\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0014\u00101\u001a\b\u0012\u0004\u0012\u00020\u001302X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u00104\u001a\u0002032\u0006\u0010.\u001a\u000203@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0014\u00107\u001a\b\u0012\u0004\u0012\u00020\u001302X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u000209X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010:\u001a\u00020\u00042\u0006\u0010.\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<R\u000e\u0010=\u001a\u00020>X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020@X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020BX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010C\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010D\u001a\n\u0012\u0004\u0012\u00020F\u0018\u00010EX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010a\u001a\b\u0012\u0004\u0012\u00020\u00060bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010n\u001a\b\u0012\u0004\u0012\u00020\u00010o8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bp\u0010qR\u0011\u0010t\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\bt\u00100R\u0011\u0010x\u001a\u0002038F\u00a2\u0006\u0006\u001a\u0004\by\u00106R\u0011\u0010\u007f\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u007f\u00100\u00a8\u0006\u0085\u0001"}, d2={"Lorg/gnit/lucenekmp/index/DocumentsWriterPerThread;", "Lorg/gnit/lucenekmp/util/Accountable;", "Lorg/gnit/lucenekmp/jdkport/Lock;", "indexMajorVersionCreated", "", "segmentName", "", "directoryOrig", "Lorg/gnit/lucenekmp/store/Directory;", "directory", "indexWriterConfig", "Lorg/gnit/lucenekmp/index/LiveIndexWriterConfig;", "deleteQueue", "Lorg/gnit/lucenekmp/index/DocumentsWriterDeleteQueue;", "fieldInfos", "Lorg/gnit/lucenekmp/index/FieldInfos$Builder;", "pendingNumDocs", "Lkotlin/concurrent/atomics/AtomicLong;", "enableTestPoints", "", "<init>", "(ILjava/lang/String;Lorg/gnit/lucenekmp/store/Directory;Lorg/gnit/lucenekmp/store/Directory;Lorg/gnit/lucenekmp/index/LiveIndexWriterConfig;Lorg/gnit/lucenekmp/index/DocumentsWriterDeleteQueue;Lorg/gnit/lucenekmp/index/FieldInfos$Builder;Ljava/util/concurrent/atomic/AtomicLong;Z)V", "getDeleteQueue", "()Lorg/gnit/lucenekmp/index/DocumentsWriterDeleteQueue;", "getPendingNumDocs$annotations", "()V", "Ljava/util/concurrent/atomic/AtomicLong;", "abortingException", "", "onAbortingException", "", "throwable", "abort", "codec", "Lorg/gnit/lucenekmp/codecs/Codec;", "getCodec", "()Lorg/gnit/lucenekmp/codecs/Codec;", "Lorg/gnit/lucenekmp/store/TrackingDirectoryWrapper;", "getDirectory", "()Lorg/gnit/lucenekmp/store/TrackingDirectoryWrapper;", "indexingChain", "Lorg/gnit/lucenekmp/index/IndexingChain;", "pendingUpdates", "Lorg/gnit/lucenekmp/index/BufferedUpdates;", "segmentInfo", "Lorg/gnit/lucenekmp/index/SegmentInfo;", "value", "isAborted", "()Z", "flushPending", "Lorg/gnit/lucenekmp/util/SetOnce;", "", "lastCommittedBytesUsed", "getLastCommittedBytesUsed", "()J", "hasFlushed", "infoStream", "Lorg/gnit/lucenekmp/util/InfoStream;", "numDocsInRAM", "getNumDocsInRAM", "()I", "deleteSlice", "Lorg/gnit/lucenekmp/index/DocumentsWriterDeleteQueue$DeleteSlice;", "lock", "Lorg/gnit/lucenekmp/jdkport/ReentrantLock;", "deleteDocIDs", "", "numDeletedDocIds", "parentField", "Lorg/gnit/lucenekmp/index/IndexingChain$ReservedField;", "Lorg/gnit/lucenekmp/document/NumericDocValuesField;", "testPoint", "message", "reserveOneDoc", "updateDocuments", "docs", "", "Lorg/gnit/lucenekmp/index/IndexableField;", "deleteNode", "Lorg/gnit/lucenekmp/index/DocumentsWriterDeleteQueue$Node;", "flushNotifications", "Lorg/gnit/lucenekmp/index/DocumentsWriter$FlushNotifications;", "onNewDocOnRAM", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "addParentField", "doc", "finishDocuments", "docIdUpTo", "deleteLastDocs", "docCount", "prepareFlush", "Lorg/gnit/lucenekmp/index/FrozenBufferedUpdates;", "flush", "Lorg/gnit/lucenekmp/index/DocumentsWriterPerThread$FlushedSegment;", "maybeAbort", "location", "filesToDelete", "", "pendingFilesToDelete", "sortLiveDocs", "Lorg/gnit/lucenekmp/util/FixedBitSet;", "liveDocs", "Lorg/gnit/lucenekmp/util/Bits;", "sortMap", "Lorg/gnit/lucenekmp/index/Sorter$DocMap;", "sealFlushedSegment", "flushedSegment", "getSegmentInfo", "ramBytesUsed", "childResources", "", "getChildResources", "()Ljava/util/Collection;", "toString", "isFlushPending", "isQueueAdvanced", "setFlushPending", "commitLastBytesUsed", "delta", "commitLastBytesUsedDelta", "getCommitLastBytesUsedDelta", "lockInterruptibly", "tryLock", "time", "unit", "Lorg/gnit/lucenekmp/jdkport/TimeUnit;", "isHeldByCurrentThread", "unlock", "newCondition", "Lorg/gnit/lucenekmp/jdkport/Condition;", "FlushedSegment", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nDocumentsWriterPerThread.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentsWriterPerThread.kt\norg/gnit/lucenekmp/index/DocumentsWriterPerThread\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,792:1\n8#2,2:793\n3#2,8:795\n8#2,2:804\n3#2,8:806\n8#2,2:815\n8#2,2:817\n3#2,8:819\n3#2,8:828\n3#2,8:837\n3#2,8:846\n8#2,2:855\n3#2,8:857\n3#2,8:866\n3#2,8:875\n3#2,8:884\n3#2,8:893\n3#2,8:902\n8#2,2:911\n3#2,8:913\n10#3:803\n10#3:814\n10#3:827\n10#3:836\n10#3:845\n10#3:854\n10#3:865\n10#3:874\n10#3:883\n10#3:892\n10#3:901\n10#3:910\n10#3:921\n*S KotlinDebug\n*F\n+ 1 DocumentsWriterPerThread.kt\norg/gnit/lucenekmp/index/DocumentsWriterPerThread\n*L\n506#1:793,2\n524#1:795,8\n53#1:804,2\n132#1:806,8\n160#1:815,2\n264#1:817,2\n309#1:819,8\n316#1:828,8\n326#1:837,8\n327#1:846,8\n328#1:855,2\n387#1:857,8\n563#1:866,8\n633#1:875,8\n684#1:884,8\n692#1:893,8\n731#1:902,8\n732#1:911,2\n744#1:913,8\n524#1:803\n132#1:814\n309#1:827\n316#1:836\n326#1:845\n327#1:854\n387#1:865\n563#1:874\n633#1:883\n684#1:892\n692#1:901\n731#1:910\n744#1:921\n*E\n"})
public final class DocumentsWriterPerThread
implements Accountable,
Lock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int indexMajorVersionCreated;
    @NotNull
    private final LiveIndexWriterConfig indexWriterConfig;
    @NotNull
    private final DocumentsWriterDeleteQueue deleteQueue;
    @NotNull
    private final FieldInfos.Builder fieldInfos;
    @NotNull
    private final AtomicLong pendingNumDocs;
    @Nullable
    private Throwable abortingException;
    @NotNull
    private final Codec codec;
    @NotNull
    private final TrackingDirectoryWrapper directory;
    @NotNull
    private final IndexingChain indexingChain;
    @NotNull
    private final BufferedUpdates pendingUpdates;
    @NotNull
    private final SegmentInfo segmentInfo;
    private boolean isAborted;
    @NotNull
    private final SetOnce<Boolean> flushPending;
    private volatile long lastCommittedBytesUsed;
    @NotNull
    private final SetOnce<Boolean> hasFlushed;
    @NotNull
    private final InfoStream infoStream;
    private int numDocsInRAM;
    @NotNull
    private final DocumentsWriterDeleteQueue.DeleteSlice deleteSlice;
    private final boolean enableTestPoints;
    @NotNull
    private final ReentrantLock lock;
    @NotNull
    private int[] deleteDocIDs;
    private int numDeletedDocIds;
    @Nullable
    private final IndexingChain.ReservedField<NumericDocValuesField> parentField;
    @NotNull
    private final Set<String> filesToDelete;
    private static final boolean INFO_VERBOSE = false;

    public DocumentsWriterPerThread(int indexMajorVersionCreated, @NotNull String segmentName, @NotNull Directory directoryOrig, @NotNull Directory directory, @NotNull LiveIndexWriterConfig indexWriterConfig, @NotNull DocumentsWriterDeleteQueue deleteQueue, @NotNull FieldInfos.Builder fieldInfos, @NotNull AtomicLong pendingNumDocs, boolean enableTestPoints) {
        Intrinsics.checkNotNullParameter((Object)segmentName, (String)"segmentName");
        Intrinsics.checkNotNullParameter((Object)directoryOrig, (String)"directoryOrig");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)indexWriterConfig, (String)"indexWriterConfig");
        Intrinsics.checkNotNullParameter((Object)deleteQueue, (String)"deleteQueue");
        Intrinsics.checkNotNullParameter((Object)fieldInfos, (String)"fieldInfos");
        Intrinsics.checkNotNullParameter((Object)pendingNumDocs, (String)"pendingNumDocs");
        this.indexMajorVersionCreated = indexMajorVersionCreated;
        this.indexWriterConfig = indexWriterConfig;
        this.deleteQueue = deleteQueue;
        this.fieldInfos = fieldInfos;
        this.pendingNumDocs = pendingNumDocs;
        this.codec = this.indexWriterConfig.getCodec();
        this.directory = new TrackingDirectoryWrapper(directory);
        this.pendingUpdates = new BufferedUpdates(segmentName);
        this.flushPending = new SetOnce();
        this.hasFlushed = new SetOnce();
        this.infoStream = this.indexWriterConfig.getInfoStream();
        this.lock = new ReentrantLock();
        this.deleteDocIDs = new int[0];
        this.filesToDelete = new HashSet();
        boolean condition$iv = this.numDocsInRAM == 0;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "num docs " + this.numDocsInRAM;
            throw new AssertionError((Object)string);
        }
        this.deleteSlice = this.deleteQueue.newSlice();
        this.segmentInfo = new SegmentInfo(directoryOrig, Version.Companion.getLATEST(), Version.Companion.getLATEST(), segmentName, -1, false, false, this.codec, new LinkedHashMap(), StringHelper.INSTANCE.randomId(), new LinkedHashMap(), this.indexWriterConfig.getIndexSort());
        condition$iv = this.numDocsInRAM == 0;
        boolean $i$f$assert2 = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        this.enableTestPoints = enableTestPoints;
        this.indexingChain = new IndexingChain(this.indexMajorVersionCreated, this.segmentInfo, this.directory, this.fieldInfos, this.indexWriterConfig, (Function1<? super Throwable, Unit>)((Function1)arg_0 -> DocumentsWriterPerThread._init_$lambda$7(this, arg_0)));
        if (this.indexWriterConfig.getParentField() != null) {
            String string = this.indexWriterConfig.getParentField();
            Intrinsics.checkNotNull((Object)string);
            this.parentField = this.indexingChain.markAsReserved((IndexableField)new NumericDocValuesField(string, -1L));
        } else {
            this.parentField = null;
        }
    }

    @NotNull
    public final DocumentsWriterDeleteQueue getDeleteQueue() {
        return this.deleteQueue;
    }

    private static /* synthetic */ void getPendingNumDocs$annotations() {
    }

    private final void onAbortingException(Throwable throwable) {
        boolean condition$iv = this.abortingException == null;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "aborting exception has already been set";
            throw new AssertionError((Object)string);
        }
        this.abortingException = throwable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void abort() throws IOException {
        this.isAborted = true;
        this.pendingNumDocs.addAndGet(-((long)this.numDocsInRAM));
        try {
            if (this.infoStream.isEnabled("DWPT")) {
                this.infoStream.message("DWPT", "now abort");
            }
            try {
                this.indexingChain.abort();
            }
            finally {
                this.pendingUpdates.clear();
            }
        }
        finally {
            if (this.infoStream.isEnabled("DWPT")) {
                this.infoStream.message("DWPT", "done abort");
            }
        }
    }

    @NotNull
    public final Codec getCodec() {
        return this.codec;
    }

    @NotNull
    public final TrackingDirectoryWrapper getDirectory() {
        return this.directory;
    }

    public final boolean isAborted() {
        return this.isAborted;
    }

    public final long getLastCommittedBytesUsed() {
        return this.lastCommittedBytesUsed;
    }

    public final int getNumDocsInRAM() {
        return this.numDocsInRAM;
    }

    public final void testPoint(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (this.enableTestPoints) {
            boolean condition$iv = this.infoStream.isEnabled("TP");
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            this.infoStream.message("TP", message);
        }
    }

    private final void reserveOneDoc() {
        if (AtomicsKt.incrementAndFetch((AtomicLong)this.pendingNumDocs) > (long)IndexWriter.Companion.getActualMaxDocs()) {
            AtomicsKt.decrementAndFetch((AtomicLong)this.pendingNumDocs);
            throw new IllegalArgumentException("number of documents in the index cannot exceed " + IndexWriter.Companion.getActualMaxDocs());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long updateDocuments(@NotNull Iterable<? extends Iterable<? extends IndexableField>> docs, @Nullable DocumentsWriterDeleteQueue.Node<?> deleteNode, @NotNull DocumentsWriter.FlushNotifications flushNotifications2, @NotNull Runnable onNewDocOnRAM) throws IOException {
        Intrinsics.checkNotNullParameter(docs, (String)"docs");
        Intrinsics.checkNotNullParameter((Object)flushNotifications2, (String)"flushNotifications");
        Intrinsics.checkNotNullParameter((Object)onNewDocOnRAM, (String)"onNewDocOnRAM");
        try {
            long l;
            this.testPoint("DocumentsWriterPerThread addDocuments start");
            boolean condition$iv = this.abortingException == null;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean $i$a$-assert-DocumentsWriterPerThread$updateDocuments$22 = false;
                String $i$a$-assert-DocumentsWriterPerThread$updateDocuments$22 = "DWPT has hit aborting exception but is still indexing";
                throw new AssertionError((Object)$i$a$-assert-DocumentsWriterPerThread$updateDocuments$22);
            }
            int docsInRamBefore = this.numDocsInRAM;
            boolean allDocsIndexed = false;
            try {
                Iterator<? extends Iterable<? extends IndexableField>> iterator2 = docs.iterator();
                while (iterator2.hasNext()) {
                    Iterable<? extends IndexableField> doc = iterator2.next();
                    if (this.parentField != null) {
                        if (!iterator2.hasNext()) {
                            doc = this.addParentField(doc, this.parentField);
                        }
                    } else if (!(this.segmentInfo.getIndexSort() == null || !iterator2.hasNext() || this.indexMajorVersionCreated < Version.Companion.getLUCENE_10_0_0().getMajor())) {
                        boolean bl = false;
                        String string = "a parent field must be set in order to use document blocks with index sorting; see IndexWriterConfig#setParentField";
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.reserveOneDoc();
                    try {
                        int n = this.numDocsInRAM;
                        this.numDocsInRAM = n + 1;
                        this.indexingChain.processDocument(n, doc);
                    }
                    finally {
                        onNewDocOnRAM.run();
                    }
                }
                int numDocs = this.numDocsInRAM - docsInRamBefore;
                if (numDocs > 1) {
                    this.segmentInfo.setHasBlocks();
                }
                allDocsIndexed = true;
                l = this.finishDocuments(deleteNode, docsInRamBefore);
            }
            catch (Throwable throwable) {
                if (!allDocsIndexed && !this.isAborted) {
                    this.deleteLastDocs(this.numDocsInRAM - docsInRamBefore);
                }
                throw throwable;
            }
            return l;
        }
        finally {
            this.maybeAbort("updateDocuments", flushNotifications2);
        }
    }

    private final Iterable<IndexableField> addParentField(Iterable<? extends IndexableField> doc, IndexableField parentField) {
        return new Iterable<IndexableField>(doc, parentField){
            final /* synthetic */ Iterable $doc$inlined;
            final /* synthetic */ IndexableField $parentField$inlined;
            {
                this.$doc$inlined = iterable;
                this.$parentField$inlined = indexableField;
            }

            public Iterator<IndexableField> iterator() {
                boolean bl = false;
                Iterator<T> first = this.$doc$inlined.iterator();
                return new Iterator<IndexableField>(this.$parentField$inlined, first){
                    private IndexableField additionalField;
                    final /* synthetic */ Iterator<IndexableField> $first;
                    {
                        this.$first = $first;
                        this.additionalField = $parentField;
                    }

                    public final IndexableField getAdditionalField() {
                        return this.additionalField;
                    }

                    public final void setAdditionalField(IndexableField indexableField) {
                        this.additionalField = indexableField;
                    }

                    public boolean hasNext() {
                        return this.additionalField != null || this.$first.hasNext();
                    }

                    public IndexableField next() {
                        if (this.additionalField != null) {
                            IndexableField field = this.additionalField;
                            this.additionalField = null;
                            IndexableField indexableField = field;
                            Intrinsics.checkNotNull((Object)indexableField);
                            return indexableField;
                        }
                        if (this.$first.hasNext()) {
                            return this.$first.next();
                        }
                        throw new NoSuchElementException();
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                    }
                };
            }
        };
    }

    private final long finishDocuments(DocumentsWriterDeleteQueue.Node<?> deleteNode, int docIdUpTo) {
        long seqNo2 = 0L;
        if (deleteNode != null) {
            seqNo2 = this.deleteQueue.add(deleteNode, this.deleteSlice);
            boolean condition$iv = this.deleteSlice.isTail(deleteNode);
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "expected the delete term as the tail item";
                throw new AssertionError((Object)string);
            }
            this.deleteSlice.apply(this.pendingUpdates, docIdUpTo);
            return seqNo2;
        }
        seqNo2 = this.deleteQueue.updateSlice(this.deleteSlice);
        if (seqNo2 < 0L) {
            seqNo2 = -seqNo2;
            this.deleteSlice.apply(this.pendingUpdates, docIdUpTo);
        } else {
            this.deleteSlice.reset();
        }
        return seqNo2;
    }

    private final void deleteLastDocs(int docCount) {
        int from = this.numDocsInRAM - docCount;
        int to = this.numDocsInRAM;
        this.deleteDocIDs = ArrayUtil.Companion.grow(this.deleteDocIDs, this.numDeletedDocIds + (to - from));
        int docId = from;
        while (docId < to) {
            int n = this.numDeletedDocIds;
            this.numDeletedDocIds = n + 1;
            this.deleteDocIDs[n] = docId++;
        }
    }

    @Nullable
    public final FrozenBufferedUpdates prepareFlush() {
        boolean condition$iv = this.numDocsInRAM > 0;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean $i$a$-assert-AssertKt$assert$22 = false;
            String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
        }
        FrozenBufferedUpdates globalUpdates = this.deleteQueue.freezeGlobalBuffer(this.deleteSlice);
        if (this.deleteSlice != null) {
            this.deleteSlice.apply(this.pendingUpdates, this.numDocsInRAM);
            boolean condition$iv2 = this.deleteSlice.isEmpty();
            boolean $i$f$assert2 = false;
            if (_Assertions.ENABLED && !condition$iv2) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            this.deleteSlice.reset();
        }
        return globalUpdates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public final FlushedSegment flush(@NotNull DocumentsWriter.FlushNotifications flushNotifications2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)flushNotifications2, (String)"flushNotifications");
        boolean condition$iv = Intrinsics.areEqual((Object)this.flushPending.get(), (Object)true);
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean $i$a$-assert-AssertKt$assert$22 = false;
            String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
        }
        condition$iv = this.numDocsInRAM > 0;
        $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean $i$a$-assert-AssertKt$assert$32 = false;
            String $i$a$-assert-AssertKt$assert$32 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$32);
        }
        condition$iv = this.deleteSlice.isEmpty();
        boolean $i$f$assert2 = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "all deletes must be applied in prepareFlush";
            throw new AssertionError((Object)string);
        }
        this.segmentInfo.setMaxDoc(this.numDocsInRAM);
        SegmentWriteState flushState = new SegmentWriteState(this.infoStream, this.directory, this.segmentInfo, this.fieldInfos.finish(), this.pendingUpdates, new IOContext(new FlushInfo(this.numDocsInRAM, this.lastCommittedBytesUsed)));
        double startMBUsed = (double)this.lastCommittedBytesUsed / 1024.0 / 1024.0;
        if (this.numDeletedDocIds > 0) {
            flushState.setLiveDocs(new FixedBitSet(this.numDocsInRAM));
            FixedBitSet fixedBitSet = flushState.getLiveDocs();
            Intrinsics.checkNotNull((Object)fixedBitSet);
            fixedBitSet.set(0, this.numDocsInRAM);
            int n = this.numDeletedDocIds;
            for (int i = 0; i < n; ++i) {
                FixedBitSet fixedBitSet2 = flushState.getLiveDocs();
                Intrinsics.checkNotNull((Object)fixedBitSet2);
                fixedBitSet2.clear(this.deleteDocIDs[i]);
            }
            flushState.setDelCountOnFlush(this.numDeletedDocIds);
            this.deleteDocIDs = new int[0];
        }
        if (this.isAborted) {
            if (this.infoStream.isEnabled("DWPT")) {
                this.infoStream.message("DWPT", "flush: skip because aborting is set");
            }
            return null;
        }
        Instant t0 = Clock.System.INSTANCE.now();
        if (this.infoStream.isEnabled("DWPT")) {
            this.infoStream.message("DWPT", "flush postings as segment " + flushState.getSegmentInfo().getName() + " numDocs=" + this.numDocsInRAM);
        }
        Sorter.DocMap sortMap = null;
        try {
            DocIdSetIterator docIdSetIterator;
            if (this.indexWriterConfig.getSoftDeletesField() != null) {
                String string = this.indexWriterConfig.getSoftDeletesField();
                Intrinsics.checkNotNull((Object)string);
                docIdSetIterator = this.indexingChain.getHasDocValues(string);
            } else {
                docIdSetIterator = null;
            }
            DocIdSetIterator softDeletedDocs = docIdSetIterator;
            sortMap = this.indexingChain.flush(flushState);
            if (softDeletedDocs == null) {
                flushState.setSoftDelCountOnFlush(0);
            } else {
                void condition$iv2;
                FixedBitSet fixedBitSet = flushState.getLiveDocs();
                Intrinsics.checkNotNull((Object)fixedBitSet);
                flushState.setSoftDelCountOnFlush(PendingSoftDeletes.Companion.countSoftDeletes(softDeletedDocs, fixedBitSet));
                boolean bl = flushState.getSegmentInfo().maxDoc() >= flushState.getSoftDelCountOnFlush() + flushState.getDelCountOnFlush();
                boolean $i$f$assert3 = false;
                if (_Assertions.ENABLED && condition$iv2 == false) {
                    boolean bl2 = false;
                    String string = "assertion failed";
                    throw new AssertionError((Object)string);
                }
            }
            this.pendingUpdates.clearDeleteTerms();
            this.segmentInfo.setFiles(new HashSet(this.directory.getCreatedFiles()));
            SegmentCommitInfo segmentInfoPerCommit = new SegmentCommitInfo(this.segmentInfo, 0, flushState.getSoftDelCountOnFlush(), -1L, -1L, -1L, StringHelper.INSTANCE.randomId());
            if (this.infoStream.isEnabled("DWPT")) {
                this.infoStream.message("DWPT", "new segment has " + (flushState.getLiveDocs() == null ? 0 : flushState.getDelCountOnFlush()) + " deleted docs");
                this.infoStream.message("DWPT", "new segment has " + flushState.getSoftDelCountOnFlush() + " soft-deleted docs");
                FieldInfos fieldInfos = flushState.getFieldInfos();
                Intrinsics.checkNotNull((Object)fieldInfos);
                this.infoStream.message("DWPT", "new segment has " + (fieldInfos.hasTermVectors() ? "vectors" : "no vectors") + "; " + (flushState.getFieldInfos().hasNorms() ? "norms" : "no norms") + "; " + (flushState.getFieldInfos().hasDocValues() ? "docValues" : "no docValues") + "; " + (flushState.getFieldInfos().hasProx() ? "prox" : "no prox") + "; " + (flushState.getFieldInfos().hasFreq() ? "freqs" : "no freqs"));
                this.infoStream.message("DWPT", "flushedFiles=" + segmentInfoPerCommit.files());
                this.infoStream.message("DWPT", "flushed codec=" + this.codec);
            }
            BufferedUpdates segmentDeletes = null;
            if (this.pendingUpdates.getDeleteQueries().isEmpty() && this.pendingUpdates.getNumFieldUpdates().get() == 0) {
                this.pendingUpdates.clear();
                segmentDeletes = null;
            } else {
                segmentDeletes = this.pendingUpdates;
            }
            if (this.infoStream.isEnabled("DWPT")) {
                double newSegmentSize = (double)segmentInfoPerCommit.sizeInBytes() / 1024.0 / 1024.0;
                this.infoStream.message("DWPT", "flushed: segment=" + this.segmentInfo.getName() + " ramUsed=" + startMBUsed + " MB newFlushedSize=" + newSegmentSize + " MB docs/MB=" + (double)flushState.getSegmentInfo().maxDoc() / newSegmentSize);
            }
            if (this.segmentInfo == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            FieldInfos fieldInfos = flushState.getFieldInfos();
            Intrinsics.checkNotNull((Object)fieldInfos);
            FlushedSegment fs = new FlushedSegment(this.infoStream, segmentInfoPerCommit, fieldInfos, segmentDeletes, flushState.getLiveDocs(), flushState.getDelCountOnFlush(), sortMap);
            this.sealFlushedSegment(fs, sortMap, flushNotifications2);
            if (this.infoStream.isEnabled("DWPT")) {
                this.infoStream.message("DWPT", "flush time " + Duration.toString-impl$default((long)Clock.System.INSTANCE.now().minus-UwyO8pc(t0), (DurationUnit)DurationUnit.MILLISECONDS, (int)0, (int)2, null) + " ms");
            }
            FlushedSegment flushedSegment = fs;
            return flushedSegment;
        }
        catch (Throwable t) {
            this.onAbortingException(t);
            throw t;
        }
        finally {
            this.maybeAbort("flush", flushNotifications2);
            this.hasFlushed.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void maybeAbort(String location, DocumentsWriter.FlushNotifications flushNotifications2) throws IOException {
        if (this.abortingException != null && !this.isAborted) {
            try {
                this.abort();
            }
            finally {
                Throwable throwable = this.abortingException;
                Intrinsics.checkNotNull((Object)throwable);
                flushNotifications2.onTragicEvent(throwable, location);
            }
        }
    }

    @NotNull
    public final Set<String> pendingFilesToDelete() {
        return this.filesToDelete;
    }

    private final FixedBitSet sortLiveDocs(Bits liveDocs2, Sorter.DocMap sortMap) {
        boolean condition$iv = liveDocs2 != null && sortMap != null;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        FixedBitSet sortedLiveDocs = new FixedBitSet(liveDocs2.length());
        sortedLiveDocs.set(0, liveDocs2.length());
        int n = liveDocs2.length();
        for (int i = 0; i < n; ++i) {
            if (liveDocs2.get(i)) continue;
            sortedLiveDocs.clear(sortMap.oldToNew(i));
        }
        return sortedLiveDocs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sealFlushedSegment(@NotNull FlushedSegment flushedSegment, @Nullable Sorter.DocMap sortMap, @NotNull DocumentsWriter.FlushNotifications flushNotifications2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)flushedSegment, (String)"flushedSegment");
        Intrinsics.checkNotNullParameter((Object)flushNotifications2, (String)"flushNotifications");
        SegmentCommitInfo newSegment = flushedSegment.getSegmentInfo();
        IndexWriter.Companion.setDiagnostics(newSegment.getInfo(), "flush");
        IOContext context = new IOContext(new FlushInfo(newSegment.getInfo().maxDoc(), newSegment.sizeInBytes()));
        boolean success = false;
        try {
            if (this.indexWriterConfig.getUseCompoundFile()) {
                Set<String> originalFiles = newSegment.getInfo().files();
                IndexWriter.Companion.createCompoundFile(this.infoStream, new TrackingDirectoryWrapper(this.directory), newSegment.getInfo(), context, arg_0 -> DocumentsWriterPerThread.sealFlushedSegment$lambda$8(flushNotifications2, arg_0));
                this.filesToDelete.addAll((Collection<String>)originalFiles);
                newSegment.getInfo().setUseCompoundFile(true);
            }
            this.codec.segmentInfoFormat().write(this.directory, newSegment.getInfo(), context);
            if (flushedSegment.getLiveDocs() != null) {
                int delCount = flushedSegment.getDelCount();
                boolean condition$iv = delCount > 0;
                boolean $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    boolean bl = false;
                    String string = "assertion failed";
                    throw new AssertionError((Object)string);
                }
                if (this.infoStream.isEnabled("DWPT")) {
                    this.infoStream.message("DWPT", "flush: write " + delCount + " deletes gen=" + flushedSegment.getSegmentInfo().getDelGen());
                }
                SegmentCommitInfo info = flushedSegment.getSegmentInfo();
                Codec codec = info.getInfo().getCodec();
                FixedBitSet bits = sortMap == null ? flushedSegment.getLiveDocs() : this.sortLiveDocs(flushedSegment.getLiveDocs(), sortMap);
                codec.liveDocsFormat().writeLiveDocs(bits, this.directory, info, delCount, context);
                newSegment.setDelCount(delCount);
                newSegment.advanceDelGen();
            }
            success = true;
        }
        catch (Throwable throwable) {
            if (this.infoStream.isEnabled("DWPT")) {
                this.infoStream.message("DWPT", "hit exception creating compound file for newly flushed segment " + newSegment.getInfo().getName());
            }
            throw throwable;
        }
    }

    @NotNull
    public final SegmentInfo getSegmentInfo() {
        return this.segmentInfo;
    }

    @Override
    public long ramBytesUsed() {
        boolean condition$iv = this.lock.isHeldByCurrentThread();
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        return (long)this.deleteDocIDs.length * 4L + this.pendingUpdates.ramBytesUsed() + this.indexingChain.ramBytesUsed();
    }

    @Override
    @NotNull
    public Collection<Accountable> getChildResources() {
        boolean condition$iv = this.lock.isHeldByCurrentThread();
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        Object[] objectArray = new Accountable[]{this.pendingUpdates, this.indexingChain};
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }

    @NotNull
    public String toString() {
        return "DocumentsWriterPerThread [pendingDeletes=" + this.pendingUpdates + ", segment=" + this.segmentInfo.getName() + ", aborted=" + this.isAborted + ", numDocsInRAM=" + this.numDocsInRAM + ", deleteQueue=" + this.deleteQueue + ", " + this.numDeletedDocIds + " deleted docIds]";
    }

    public final boolean isFlushPending() {
        return Intrinsics.areEqual((Object)this.flushPending.get(), (Object)true);
    }

    public final boolean isQueueAdvanced() {
        return this.deleteQueue.isAdvanced();
    }

    public final void setFlushPending() {
        this.flushPending.set(true);
    }

    public final void commitLastBytesUsed(long delta) {
        boolean condition$iv = this.isHeldByCurrentThread();
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        condition$iv = this.getCommitLastBytesUsedDelta() == delta;
        boolean $i$f$assert2 = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "delta has changed";
            throw new AssertionError((Object)string);
        }
        this.lastCommittedBytesUsed += delta;
    }

    public final long getCommitLastBytesUsedDelta() {
        boolean condition$iv = this.isHeldByCurrentThread();
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        long delta = this.ramBytesUsed() - this.lastCommittedBytesUsed;
        return delta;
    }

    @Override
    public void lock() {
        this.lock.lock();
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.lock.lockInterruptibly();
    }

    @Override
    public boolean tryLock() {
        return this.lock.tryLock();
    }

    @Override
    public boolean tryLock(long time, @NotNull TimeUnit unit) throws InterruptedException {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        return this.lock.tryLock(time, unit);
    }

    public final boolean isHeldByCurrentThread() {
        return this.lock.isHeldByCurrentThread();
    }

    @Override
    public void unlock() {
        this.lock.unlock();
    }

    @Override
    @NotNull
    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }

    public final boolean hasFlushed() {
        return Intrinsics.areEqual((Object)this.hasFlushed.get(), (Object)true);
    }

    private static final Unit _init_$lambda$7(DocumentsWriterPerThread this$0, Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        this$0.onAbortingException(throwable);
        return Unit.INSTANCE;
    }

    private static final void sealFlushedSegment$lambda$8(DocumentsWriter.FlushNotifications $flushNotifications, Collection files) {
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        $flushNotifications.deleteUnusedFiles(files);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gnit/lucenekmp/index/DocumentsWriterPerThread$Companion;", "", "<init>", "()V", "INFO_VERBOSE", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\b\u001a\u0004\u0018\u00010\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lorg/gnit/lucenekmp/index/DocumentsWriterPerThread$FlushedSegment;", "", "infoStream", "Lorg/gnit/lucenekmp/util/InfoStream;", "segmentInfo", "Lorg/gnit/lucenekmp/index/SegmentCommitInfo;", "fieldInfos", "Lorg/gnit/lucenekmp/index/FieldInfos;", "segmentUpdates", "Lorg/gnit/lucenekmp/index/BufferedUpdates;", "liveDocs", "Lorg/gnit/lucenekmp/util/FixedBitSet;", "delCount", "", "sortMap", "Lorg/gnit/lucenekmp/index/Sorter$DocMap;", "<init>", "(Lorg/gnit/lucenekmp/util/InfoStream;Lorg/gnit/lucenekmp/index/SegmentCommitInfo;Lorg/gnit/lucenekmp/index/FieldInfos;Lorg/gnit/lucenekmp/index/BufferedUpdates;Lorg/gnit/lucenekmp/util/FixedBitSet;ILorg/gnit/lucenekmp/index/Sorter$DocMap;)V", "getSegmentInfo", "()Lorg/gnit/lucenekmp/index/SegmentCommitInfo;", "getFieldInfos", "()Lorg/gnit/lucenekmp/index/FieldInfos;", "getLiveDocs", "()Lorg/gnit/lucenekmp/util/FixedBitSet;", "getDelCount", "()I", "getSortMap", "()Lorg/gnit/lucenekmp/index/Sorter$DocMap;", "Lorg/gnit/lucenekmp/index/FrozenBufferedUpdates;", "getSegmentUpdates", "()Lorg/gnit/lucenekmp/index/FrozenBufferedUpdates;", "core"})
    public static final class FlushedSegment {
        @NotNull
        private final SegmentCommitInfo segmentInfo;
        @NotNull
        private final FieldInfos fieldInfos;
        @Nullable
        private final FixedBitSet liveDocs;
        private final int delCount;
        @Nullable
        private final Sorter.DocMap sortMap;
        @Nullable
        private final FrozenBufferedUpdates segmentUpdates;

        public FlushedSegment(@NotNull InfoStream infoStream, @NotNull SegmentCommitInfo segmentInfo, @NotNull FieldInfos fieldInfos, @Nullable BufferedUpdates segmentUpdates, @Nullable FixedBitSet liveDocs2, int delCount, @Nullable Sorter.DocMap sortMap) {
            Intrinsics.checkNotNullParameter((Object)infoStream, (String)"infoStream");
            Intrinsics.checkNotNullParameter((Object)segmentInfo, (String)"segmentInfo");
            Intrinsics.checkNotNullParameter((Object)fieldInfos, (String)"fieldInfos");
            this.segmentInfo = segmentInfo;
            this.fieldInfos = fieldInfos;
            this.liveDocs = liveDocs2;
            this.delCount = delCount;
            this.sortMap = sortMap;
            this.segmentUpdates = segmentUpdates != null && segmentUpdates.any() ? new FrozenBufferedUpdates(infoStream, segmentUpdates, this.segmentInfo) : null;
        }

        @NotNull
        public final SegmentCommitInfo getSegmentInfo() {
            return this.segmentInfo;
        }

        @NotNull
        public final FieldInfos getFieldInfos() {
            return this.fieldInfos;
        }

        @Nullable
        public final FixedBitSet getLiveDocs() {
            return this.liveDocs;
        }

        public final int getDelCount() {
            return this.delCount;
        }

        @Nullable
        public final Sorter.DocMap getSortMap() {
            return this.sortMap;
        }

        @Nullable
        public final FrozenBufferedUpdates getSegmentUpdates() {
            return this.segmentUpdates;
        }
    }
}

