/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.index.DocValuesSkipIndexType;
import org.gnit.lucenekmp.index.DocValuesType;
import org.gnit.lucenekmp.index.IndexOptions;
import org.gnit.lucenekmp.index.PointValues;
import org.gnit.lucenekmp.index.VectorEncoding;
import org.gnit.lucenekmp.index.VectorSimilarityFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0010\u0002\n\u0002\b\u0019\u0018\u0000 P2\u00020\u0001:\u0001PB\u00a3\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0005\u0012\u0006\u0010\u0015\u001a\u00020\u0005\u0012\u0006\u0010\u0016\u001a\u00020\u0005\u0012\u0006\u0010\u0017\u001a\u00020\u0005\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\u001c\u001a\u00020\u0007\u0012\u0006\u0010\u001d\u001a\u00020\u0007\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0006\u00107\u001a\u000208J\u000e\u00109\u001a\u0002082\u0006\u0010:\u001a\u00020\u0000J\u001e\u0010;\u001a\u0002082\u0006\u0010<\u001a\u00020\u00052\u0006\u0010=\u001a\u00020\u00052\u0006\u0010>\u001a\u00020\u0005J\u0006\u0010?\u001a\u00020\u000fJ\u0006\u0010E\u001a\u000208J\u0006\u0010F\u001a\u000208J\u0006\u0010G\u001a\u00020\u0007J\u0006\u0010H\u001a\u000208J\u0006\u0010I\u001a\u00020\u0007J\u0006\u0010J\u001a\u00020\u0007J\u0006\u0010K\u001a\u00020\u0007J\u0006\u0010L\u001a\u00020\u0007J\u0012\u0010M\u001a\u0004\u0018\u00010\u00032\b\u0010N\u001a\u0004\u0018\u00010\u0003J\u0018\u0010O\u001a\u0004\u0018\u00010\u00032\u0006\u0010N\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0003J\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0014\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010#R\u001e\u0010\u0015\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010#R\u001e\u0010\u0016\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010#R\u0011\u0010\u0017\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010#R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0011\u0010/\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0011\u0010\u001d\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u00100R\u000e\u00101\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u00102\u001a\u00020\r2\u0006\u0010&\u001a\u00020\r@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010@\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00118F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bA\u0010B\"\u0004\bC\u0010D\u00a8\u0006Q"}, d2={"Lorg/gnit/lucenekmp/index/FieldInfo;", "", "name", "", "number", "", "storeTermVector", "", "omitNorms", "storePayloads", "indexOptions", "Lorg/gnit/lucenekmp/index/IndexOptions;", "docValues", "Lorg/gnit/lucenekmp/index/DocValuesType;", "docValuesSkipIndex", "Lorg/gnit/lucenekmp/index/DocValuesSkipIndexType;", "dvGen", "", "attributes", "", "pointDimensionCount", "pointIndexDimensionCount", "pointNumBytes", "vectorDimension", "vectorEncoding", "Lorg/gnit/lucenekmp/index/VectorEncoding;", "vectorSimilarityFunction", "Lorg/gnit/lucenekmp/index/VectorSimilarityFunction;", "softDeletesField", "isParentField", "<init>", "(Ljava/lang/String;IZZZLorg/gnit/lucenekmp/index/IndexOptions;Lorg/gnit/lucenekmp/index/DocValuesType;Lorg/gnit/lucenekmp/index/DocValuesSkipIndexType;JLjava/util/Map;IIIILorg/gnit/lucenekmp/index/VectorEncoding;Lorg/gnit/lucenekmp/index/VectorSimilarityFunction;ZZ)V", "getName", "()Ljava/lang/String;", "getNumber", "()I", "getIndexOptions", "()Lorg/gnit/lucenekmp/index/IndexOptions;", "value", "getPointDimensionCount", "getPointIndexDimensionCount", "getPointNumBytes", "getVectorDimension", "getVectorEncoding", "()Lorg/gnit/lucenekmp/index/VectorEncoding;", "getVectorSimilarityFunction", "()Lorg/gnit/lucenekmp/index/VectorSimilarityFunction;", "isSoftDeletesField", "()Z", "initializing", "docValuesType", "getDocValuesType", "()Lorg/gnit/lucenekmp/index/DocValuesType;", "setDocValuesType", "(Lorg/gnit/lucenekmp/index/DocValuesType;)V", "checkConsistency", "", "verifySameSchema", "o", "setPointDimensions", "dimensionCount", "indexDimensionCount", "numBytes", "docValuesSkipIndexType", "docValuesGen", "getDocValuesGen", "()J", "setDocValuesGen", "(J)V", "setStoreTermVectors", "setStorePayloads", "omitsNorms", "setOmitsNorms", "hasNorms", "hasPayloads", "hasTermVectors", "hasVectorValues", "getAttribute", "key", "putAttribute", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nFieldInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FieldInfo.kt\norg/gnit/lucenekmp/index/FieldInfo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,591:1\n1#2:592\n*E\n"})
public final class FieldInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    private final int number;
    private boolean storeTermVector;
    private boolean omitNorms;
    @NotNull
    private final IndexOptions indexOptions;
    private boolean storePayloads;
    @NotNull
    private Map<String, String> attributes;
    private long dvGen;
    private int pointDimensionCount;
    private int pointIndexDimensionCount;
    private int pointNumBytes;
    private final int vectorDimension;
    @NotNull
    private final VectorEncoding vectorEncoding;
    @NotNull
    private final VectorSimilarityFunction vectorSimilarityFunction;
    private final boolean isSoftDeletesField;
    private final boolean isParentField;
    private boolean initializing;
    @NotNull
    private DocValuesType docValuesType;
    @NotNull
    private final DocValuesSkipIndexType docValuesSkipIndex;

    public FieldInfo(@NotNull String name, int number, boolean storeTermVector, boolean omitNorms, boolean storePayloads, @NotNull IndexOptions indexOptions, @NotNull DocValuesType docValues, @NotNull DocValuesSkipIndexType docValuesSkipIndex, long dvGen, @NotNull Map<String, String> attributes, int pointDimensionCount, int pointIndexDimensionCount, int pointNumBytes, int vectorDimension, @NotNull VectorEncoding vectorEncoding, @NotNull VectorSimilarityFunction vectorSimilarityFunction, boolean softDeletesField, boolean isParentField) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)indexOptions), (String)"indexOptions");
        Intrinsics.checkNotNullParameter((Object)((Object)docValues), (String)"docValues");
        Intrinsics.checkNotNullParameter((Object)((Object)docValuesSkipIndex), (String)"docValuesSkipIndex");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter((Object)((Object)vectorEncoding), (String)"vectorEncoding");
        Intrinsics.checkNotNullParameter((Object)((Object)vectorSimilarityFunction), (String)"vectorSimilarityFunction");
        this.name = name;
        this.number = number;
        this.docValuesType = DocValuesType.NONE;
        this.initializing = true;
        this.setDocValuesType(docValues);
        this.docValuesSkipIndex = docValuesSkipIndex;
        this.indexOptions = indexOptions;
        if (indexOptions != IndexOptions.NONE) {
            this.storeTermVector = storeTermVector;
            this.storePayloads = storePayloads;
            this.omitNorms = omitNorms;
        } else {
            this.storeTermVector = false;
            this.storePayloads = false;
            this.omitNorms = false;
        }
        this.dvGen = dvGen;
        this.attributes = attributes;
        this.pointDimensionCount = pointDimensionCount;
        this.pointIndexDimensionCount = pointIndexDimensionCount;
        this.pointNumBytes = pointNumBytes;
        this.vectorDimension = vectorDimension;
        this.vectorEncoding = vectorEncoding;
        this.vectorSimilarityFunction = vectorSimilarityFunction;
        this.isSoftDeletesField = softDeletesField;
        this.isParentField = isParentField;
        this.initializing = false;
        this.checkConsistency();
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final int getNumber() {
        return this.number;
    }

    @NotNull
    public final IndexOptions getIndexOptions() {
        return this.indexOptions;
    }

    public final int getPointDimensionCount() {
        return this.pointDimensionCount;
    }

    public final int getPointIndexDimensionCount() {
        return this.pointIndexDimensionCount;
    }

    public final int getPointNumBytes() {
        return this.pointNumBytes;
    }

    public final int getVectorDimension() {
        return this.vectorDimension;
    }

    @NotNull
    public final VectorEncoding getVectorEncoding() {
        return this.vectorEncoding;
    }

    @NotNull
    public final VectorSimilarityFunction getVectorSimilarityFunction() {
        return this.vectorSimilarityFunction;
    }

    public final boolean isSoftDeletesField() {
        return this.isSoftDeletesField;
    }

    public final boolean isParentField() {
        return this.isParentField;
    }

    @NotNull
    public final DocValuesType getDocValuesType() {
        return this.docValuesType;
    }

    public final void setDocValuesType(@NotNull DocValuesType value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        if (!(this.docValuesType == DocValuesType.NONE || value == DocValuesType.NONE || this.docValuesType == value)) {
            boolean bl = false;
            String string = "cannot change DocValues type from " + this.docValuesType + " to " + value + " for field \"" + this.name + "\"";
            throw new IllegalArgumentException(string.toString());
        }
        this.docValuesType = value;
        if (!this.initializing) {
            this.checkConsistency();
        }
    }

    public final void checkConsistency() {
        if (this.indexOptions == null) {
            boolean $i$a$-requireNotNull-FieldInfo$checkConsistency$22 = false;
            String $i$a$-requireNotNull-FieldInfo$checkConsistency$22 = "IndexOptions must not be null (field: '" + this.name + "')";
            throw new IllegalArgumentException($i$a$-requireNotNull-FieldInfo$checkConsistency$22.toString());
        }
        if (this.indexOptions != IndexOptions.NONE) {
            if (!(this.indexOptions.compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0 || !this.storePayloads)) {
                boolean $i$a$-require-FieldInfo$checkConsistency$142 = false;
                String $i$a$-require-FieldInfo$checkConsistency$142 = "indexed field '" + this.name + "' cannot have payloads without positions";
                throw new IllegalArgumentException($i$a$-require-FieldInfo$checkConsistency$142.toString());
            }
        } else {
            if (!(!this.storeTermVector)) {
                boolean $i$a$-require-FieldInfo$checkConsistency$172 = false;
                String $i$a$-require-FieldInfo$checkConsistency$172 = "non-indexed field '" + this.name + "' cannot store term vectors";
                throw new IllegalArgumentException($i$a$-require-FieldInfo$checkConsistency$172.toString());
            }
            if (!(!this.storePayloads)) {
                boolean $i$a$-require-FieldInfo$checkConsistency$182 = false;
                String $i$a$-require-FieldInfo$checkConsistency$182 = "non-indexed field '" + this.name + "' cannot store payloads";
                throw new IllegalArgumentException($i$a$-require-FieldInfo$checkConsistency$182.toString());
            }
            if (!(!this.omitNorms)) {
                boolean $i$a$-require-FieldInfo$checkConsistency$192 = false;
                String $i$a$-require-FieldInfo$checkConsistency$192 = "non-indexed field '" + this.name + "' cannot omit norms";
                throw new IllegalArgumentException($i$a$-require-FieldInfo$checkConsistency$192.toString());
            }
        }
        if (!this.docValuesSkipIndex.isCompatibleWith(this.docValuesType)) {
            boolean $i$a$-require-FieldInfo$checkConsistency$202 = false;
            String $i$a$-require-FieldInfo$checkConsistency$202 = "field '" + this.name + "' cannot have docValuesSkipIndexType=" + this.docValuesSkipIndex + " with doc values type " + this.docValuesType;
            throw new IllegalArgumentException($i$a$-require-FieldInfo$checkConsistency$202.toString());
        }
        if (!(this.dvGen == -1L || this.docValuesType != DocValuesType.NONE)) {
            boolean $i$a$-require-FieldInfo$checkConsistency$212 = false;
            String $i$a$-require-FieldInfo$checkConsistency$212 = "field '" + this.name + "' cannot have a docvalues update generation without having docvalues";
            throw new IllegalArgumentException($i$a$-require-FieldInfo$checkConsistency$212.toString());
        }
        if (!(this.pointDimensionCount >= 0)) {
            boolean $i$a$-require-FieldInfo$checkConsistency$222 = false;
            String $i$a$-require-FieldInfo$checkConsistency$222 = "pointDimensionCount must be >= 0; got " + this.pointDimensionCount + " (field: '" + this.name + "')";
            throw new IllegalArgumentException($i$a$-require-FieldInfo$checkConsistency$222.toString());
        }
        if (!(this.pointIndexDimensionCount >= 0)) {
            boolean $i$a$-require-FieldInfo$checkConsistency$232 = false;
            String $i$a$-require-FieldInfo$checkConsistency$232 = "pointIndexDimensionCount must be >= 0; got " + this.pointIndexDimensionCount + " (field: '" + this.name + "')";
            throw new IllegalArgumentException($i$a$-require-FieldInfo$checkConsistency$232.toString());
        }
        if (!(this.pointNumBytes >= 0)) {
            boolean $i$a$-require-FieldInfo$checkConsistency$242 = false;
            String $i$a$-require-FieldInfo$checkConsistency$242 = "pointNumBytes must be >= 0; got " + this.pointNumBytes + " (field: '" + this.name + "')";
            throw new IllegalArgumentException($i$a$-require-FieldInfo$checkConsistency$242.toString());
        }
        if (!(this.pointDimensionCount == 0 || this.pointNumBytes != 0)) {
            boolean $i$a$-require-FieldInfo$checkConsistency$252 = false;
            String $i$a$-require-FieldInfo$checkConsistency$252 = "pointNumBytes must be > 0 when pointDimensionCount=" + this.pointDimensionCount + " (field: '" + this.name + "')";
            throw new IllegalArgumentException($i$a$-require-FieldInfo$checkConsistency$252.toString());
        }
        if (!(this.pointIndexDimensionCount == 0 || this.pointDimensionCount != 0)) {
            boolean $i$a$-require-FieldInfo$checkConsistency$262 = false;
            String $i$a$-require-FieldInfo$checkConsistency$262 = "pointIndexDimensionCount must be 0 when pointDimensionCount=0 (field: '" + this.name + "')";
            throw new IllegalArgumentException($i$a$-require-FieldInfo$checkConsistency$262.toString());
        }
        if (!(this.pointNumBytes == 0 || this.pointDimensionCount != 0)) {
            boolean $i$a$-require-FieldInfo$checkConsistency$272 = false;
            String $i$a$-require-FieldInfo$checkConsistency$272 = "pointDimensionCount must be > 0 when pointNumBytes=" + this.pointNumBytes + " (field: '" + this.name + "')";
            throw new IllegalArgumentException($i$a$-require-FieldInfo$checkConsistency$272.toString());
        }
        if (this.vectorSimilarityFunction == null) {
            boolean $i$a$-requireNotNull-FieldInfo$checkConsistency$152 = false;
            String $i$a$-requireNotNull-FieldInfo$checkConsistency$152 = "Vector similarity function must not be null (field: '" + this.name + "')";
            throw new IllegalArgumentException($i$a$-requireNotNull-FieldInfo$checkConsistency$152.toString());
        }
        if (!(this.vectorDimension >= 0)) {
            boolean $i$a$-require-FieldInfo$checkConsistency$282 = false;
            String $i$a$-require-FieldInfo$checkConsistency$282 = "vectorDimension must be >=0; got " + this.vectorDimension + " (field: '" + this.name + "')";
            throw new IllegalArgumentException($i$a$-require-FieldInfo$checkConsistency$282.toString());
        }
        if (!(!this.isSoftDeletesField || !this.isParentField)) {
            boolean bl = false;
            String string = "field can't be used as soft-deletes field and parent document field (field: '" + this.name + "')";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final void verifySameSchema(@NotNull FieldInfo o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        String fieldName = this.name;
        Companion.verifySameIndexOptions(fieldName, this.indexOptions, o.indexOptions);
        if (this.indexOptions != IndexOptions.NONE) {
            Companion.verifySameOmitNorms(fieldName, this.omitNorms, o.omitNorms);
            Companion.verifySameStoreTermVectors(fieldName, this.storeTermVector, o.storeTermVector);
        }
        Companion.verifySameDocValuesType(fieldName, this.docValuesType, o.docValuesType);
        Companion.verifySameDocValuesSkipIndex(fieldName, this.docValuesSkipIndex, o.docValuesSkipIndex);
        Companion.verifySamePointsOptions(fieldName, this.pointDimensionCount, this.pointIndexDimensionCount, this.pointNumBytes, o.pointDimensionCount, o.pointIndexDimensionCount, o.pointNumBytes);
        Companion.verifySameVectorOptions(fieldName, this.vectorDimension, this.vectorEncoding, this.vectorSimilarityFunction, o.vectorDimension, o.vectorEncoding, o.vectorSimilarityFunction);
    }

    public final void setPointDimensions(int dimensionCount, int indexDimensionCount, int numBytes) {
        if (!(dimensionCount > 0)) {
            boolean $i$a$-require-FieldInfo$setPointDimensions$92 = false;
            String $i$a$-require-FieldInfo$setPointDimensions$92 = "point dimension count must be >= 0; got " + dimensionCount + " for field=\"" + this.name + "\"";
            throw new IllegalArgumentException($i$a$-require-FieldInfo$setPointDimensions$92.toString());
        }
        if (!(indexDimensionCount <= PointValues.Companion.getMAX_INDEX_DIMENSIONS())) {
            boolean $i$a$-require-FieldInfo$setPointDimensions$102 = false;
            String $i$a$-require-FieldInfo$setPointDimensions$102 = "point index dimension count must be < PointValues.MAX_INDEX_DIMENSIONS (= " + PointValues.Companion.getMAX_INDEX_DIMENSIONS() + "); got " + indexDimensionCount + " for field=\"" + this.name + "\"";
            throw new IllegalArgumentException($i$a$-require-FieldInfo$setPointDimensions$102.toString());
        }
        if (!(indexDimensionCount <= dimensionCount)) {
            boolean $i$a$-require-FieldInfo$setPointDimensions$112 = false;
            String $i$a$-require-FieldInfo$setPointDimensions$112 = "point index dimension count must be <= point dimension count (= " + dimensionCount + "); got " + indexDimensionCount + " for field=\"" + this.name + "\"";
            throw new IllegalArgumentException($i$a$-require-FieldInfo$setPointDimensions$112.toString());
        }
        if (!(numBytes > 0)) {
            boolean $i$a$-require-FieldInfo$setPointDimensions$122 = false;
            String $i$a$-require-FieldInfo$setPointDimensions$122 = "point numBytes must be >= 0; got " + numBytes + " for field=\"" + this.name + "\"";
            throw new IllegalArgumentException($i$a$-require-FieldInfo$setPointDimensions$122.toString());
        }
        if (!(numBytes <= 16)) {
            boolean $i$a$-require-FieldInfo$setPointDimensions$132 = false;
            String $i$a$-require-FieldInfo$setPointDimensions$132 = "point numBytes must be <= PointValues.MAX_NUM_BYTES (= 16); got " + numBytes + " for field=\"" + this.name + "\"";
            throw new IllegalArgumentException($i$a$-require-FieldInfo$setPointDimensions$132.toString());
        }
        if (!(this.pointDimensionCount == 0 || this.pointDimensionCount == dimensionCount)) {
            boolean $i$a$-require-FieldInfo$setPointDimensions$142 = false;
            String $i$a$-require-FieldInfo$setPointDimensions$142 = "cannot change point dimension count from " + this.pointDimensionCount + " to " + dimensionCount + " for field=\"" + this.name + "\"";
            throw new IllegalArgumentException($i$a$-require-FieldInfo$setPointDimensions$142.toString());
        }
        if (!(this.pointIndexDimensionCount == 0 || this.pointIndexDimensionCount == indexDimensionCount)) {
            boolean $i$a$-require-FieldInfo$setPointDimensions$152 = false;
            String $i$a$-require-FieldInfo$setPointDimensions$152 = "cannot change point index dimension count from " + this.pointIndexDimensionCount + " to " + indexDimensionCount + " for field=\"" + this.name + "\"";
            throw new IllegalArgumentException($i$a$-require-FieldInfo$setPointDimensions$152.toString());
        }
        if (!(this.pointNumBytes == 0 || this.pointNumBytes == numBytes)) {
            boolean bl = false;
            String string = "cannot change point numBytes from " + this.pointNumBytes + " to " + numBytes + " for field=\"" + this.name + "\"";
            throw new IllegalArgumentException(string.toString());
        }
        this.pointDimensionCount = dimensionCount;
        this.pointIndexDimensionCount = indexDimensionCount;
        this.pointNumBytes = numBytes;
        this.checkConsistency();
    }

    @NotNull
    public final DocValuesSkipIndexType docValuesSkipIndexType() {
        return this.docValuesSkipIndex;
    }

    public final long getDocValuesGen() {
        return this.dvGen;
    }

    public final void setDocValuesGen(long dvGen) {
        this.dvGen = dvGen;
        this.checkConsistency();
    }

    public final void setStoreTermVectors() {
        this.storeTermVector = true;
        this.checkConsistency();
    }

    public final void setStorePayloads() {
        if (this.indexOptions.compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0) {
            this.storePayloads = true;
        }
        this.checkConsistency();
    }

    public final boolean omitsNorms() {
        return this.omitNorms;
    }

    public final void setOmitsNorms() {
        if (!(this.indexOptions != IndexOptions.NONE)) {
            boolean bl = false;
            String string = "cannot omit norms: this field is not indexed";
            throw new IllegalStateException(string.toString());
        }
        this.omitNorms = true;
        this.checkConsistency();
    }

    public final boolean hasNorms() {
        return this.indexOptions != IndexOptions.NONE && !this.omitNorms;
    }

    public final boolean hasPayloads() {
        return this.storePayloads;
    }

    public final boolean hasTermVectors() {
        return this.storeTermVector;
    }

    public final boolean hasVectorValues() {
        return this.vectorDimension > 0;
    }

    @Nullable
    public final String getAttribute(@Nullable String key) {
        return this.attributes.get(key);
    }

    @Nullable
    public final String putAttribute(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Map<String, String> newMap = this.attributes;
        String oldValue = newMap.get(key);
        newMap.put(key, value);
        this.attributes = newMap;
        return oldValue;
    }

    @NotNull
    public final Map<String, String> attributes() {
        return this.attributes;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\tJ$\u0010\u000b\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\rJ$\u0010\u000f\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011J \u0010\u0013\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015J \u0010\u0017\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0015J@\u0010\u001a\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u001cJH\u0010\"\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010#\u001a\u00020\u001c2\b\u0010$\u001a\u0004\u0018\u00010%2\b\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020\u001c2\b\u0010)\u001a\u0004\u0018\u00010%2\b\u0010*\u001a\u0004\u0018\u00010'\u00a8\u0006+"}, d2={"Lorg/gnit/lucenekmp/index/FieldInfo$Companion;", "", "<init>", "()V", "verifySameIndexOptions", "", "fieldName", "", "indexOptions1", "Lorg/gnit/lucenekmp/index/IndexOptions;", "indexOptions2", "verifySameDocValuesType", "docValuesType1", "Lorg/gnit/lucenekmp/index/DocValuesType;", "docValuesType2", "verifySameDocValuesSkipIndex", "hasDocValuesSkipIndex1", "Lorg/gnit/lucenekmp/index/DocValuesSkipIndexType;", "hasDocValuesSkipIndex2", "verifySameStoreTermVectors", "storeTermVector1", "", "storeTermVector2", "verifySameOmitNorms", "omitNorms1", "omitNorms2", "verifySamePointsOptions", "pointDimensionCount1", "", "indexDimensionCount1", "numBytes1", "pointDimensionCount2", "indexDimensionCount2", "numBytes2", "verifySameVectorOptions", "vd1", "ve1", "Lorg/gnit/lucenekmp/index/VectorEncoding;", "vsf1", "Lorg/gnit/lucenekmp/index/VectorSimilarityFunction;", "vd2", "ve2", "vsf2", "core"})
    public static final class Companion {
        private Companion() {
        }

        public final void verifySameIndexOptions(@Nullable String fieldName, @Nullable IndexOptions indexOptions1, @Nullable IndexOptions indexOptions2) {
            if (!(indexOptions1 == indexOptions2)) {
                boolean bl = false;
                String string = "cannot change field \"" + fieldName + "\" from index options=" + indexOptions1 + " to inconsistent index options=" + indexOptions2;
                throw new IllegalArgumentException(string.toString());
            }
        }

        public final void verifySameDocValuesType(@Nullable String fieldName, @Nullable DocValuesType docValuesType1, @Nullable DocValuesType docValuesType2) {
            if (!(docValuesType1 == docValuesType2)) {
                boolean bl = false;
                String string = "cannot change field \"" + fieldName + "\" from doc values type=" + docValuesType1 + " to inconsistent doc values type=" + docValuesType2;
                throw new IllegalArgumentException(string.toString());
            }
        }

        public final void verifySameDocValuesSkipIndex(@Nullable String fieldName, @Nullable DocValuesSkipIndexType hasDocValuesSkipIndex1, @Nullable DocValuesSkipIndexType hasDocValuesSkipIndex2) {
            if (!(hasDocValuesSkipIndex1 == hasDocValuesSkipIndex2)) {
                boolean bl = false;
                String string = "cannot change field \"" + fieldName + "\" from docValuesSkipIndexType=" + hasDocValuesSkipIndex1 + " to inconsistent docValuesSkipIndexType=" + hasDocValuesSkipIndex2;
                throw new IllegalArgumentException(string.toString());
            }
        }

        public final void verifySameStoreTermVectors(@Nullable String fieldName, boolean storeTermVector1, boolean storeTermVector2) {
            if (!(storeTermVector1 == storeTermVector2)) {
                boolean bl = false;
                String string = "cannot change field \"" + fieldName + "\" from storeTermVector=" + storeTermVector1 + " to inconsistent storeTermVector=" + storeTermVector2;
                throw new IllegalArgumentException(string.toString());
            }
        }

        public final void verifySameOmitNorms(@Nullable String fieldName, boolean omitNorms1, boolean omitNorms2) {
            if (!(omitNorms1 == omitNorms2)) {
                boolean bl = false;
                String string = "cannot change field \"" + fieldName + "\" from omitNorms=" + omitNorms1 + " to inconsistent omitNorms=" + omitNorms2;
                throw new IllegalArgumentException(string.toString());
            }
        }

        public final void verifySamePointsOptions(@Nullable String fieldName, int pointDimensionCount1, int indexDimensionCount1, int numBytes1, int pointDimensionCount2, int indexDimensionCount2, int numBytes2) {
            if (!(pointDimensionCount1 == pointDimensionCount2 && indexDimensionCount1 == indexDimensionCount2 && numBytes1 == numBytes2)) {
                boolean bl = false;
                String string = "cannot change field \"" + fieldName + "\" from points dimensionCount=" + pointDimensionCount1 + ", indexDimensionCount=" + indexDimensionCount1 + ", numBytes=" + numBytes1 + " to inconsistent dimensionCount=" + pointDimensionCount2 + ", indexDimensionCount=" + indexDimensionCount2 + ", numBytes=" + numBytes2;
                throw new IllegalArgumentException(string.toString());
            }
        }

        public final void verifySameVectorOptions(@Nullable String fieldName, int vd1, @Nullable VectorEncoding ve1, @Nullable VectorSimilarityFunction vsf1, int vd2, @Nullable VectorEncoding ve2, @Nullable VectorSimilarityFunction vsf2) {
            if (!(vd1 == vd2 && vsf1 == vsf2 && ve1 == ve2)) {
                boolean bl = false;
                String string = "cannot change field \"" + fieldName + "\" from vector dimension=" + vd1 + ", vector encoding=" + ve1 + ", vector similarity function=" + vsf1 + " to inconsistent vector dimension=" + vd2 + ", vector encoding=" + ve2 + ", vector similarity function=" + vsf2;
                throw new IllegalArgumentException(string.toString());
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

