/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.codecs.FieldsConsumer;
import org.gnit.lucenekmp.codecs.NormsProducer;
import org.gnit.lucenekmp.index.BufferedUpdates;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.FieldInfos;
import org.gnit.lucenekmp.index.FieldInvertState;
import org.gnit.lucenekmp.index.Fields;
import org.gnit.lucenekmp.index.FilterLeafReader;
import org.gnit.lucenekmp.index.FreqProxFields;
import org.gnit.lucenekmp.index.FreqProxTermsWriterPerField;
import org.gnit.lucenekmp.index.FrozenBufferedUpdates;
import org.gnit.lucenekmp.index.IndexOptions;
import org.gnit.lucenekmp.index.PostingsEnum;
import org.gnit.lucenekmp.index.SegmentWriteState;
import org.gnit.lucenekmp.index.Sorter;
import org.gnit.lucenekmp.index.Term;
import org.gnit.lucenekmp.index.Terms;
import org.gnit.lucenekmp.index.TermsEnum;
import org.gnit.lucenekmp.index.TermsHash;
import org.gnit.lucenekmp.index.TermsHashPerField;
import org.gnit.lucenekmp.jdkport.System;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.store.ByteBuffersDataInput;
import org.gnit.lucenekmp.store.ByteBuffersDataOutput;
import org.gnit.lucenekmp.store.DataOutput;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.ByteBlockPool;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.CollectionUtil;
import org.gnit.lucenekmp.util.Counter;
import org.gnit.lucenekmp.util.FixedBitSet;
import org.gnit.lucenekmp.util.IntBlockPool;
import org.gnit.lucenekmp.util.IntsRef;
import org.gnit.lucenekmp.util.LSBRadixSorter;
import org.gnit.lucenekmp.util.LongsRef;
import org.gnit.lucenekmp.util.TimSorter;
import org.gnit.lucenekmp.util.automaton.CompiledAutomaton;
import org.gnit.lucenekmp.util.packed.PackedInts;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0004\u001f !\"B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0001\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J6\u0010\u0011\u001a\u00020\f2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00132\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016\u00a8\u0006#"}, d2={"Lorg/gnit/lucenekmp/index/FreqProxTermsWriter;", "Lorg/gnit/lucenekmp/index/TermsHash;", "intBlockAllocator", "Lorg/gnit/lucenekmp/util/IntBlockPool$Allocator;", "byteBlockAllocator", "Lorg/gnit/lucenekmp/util/ByteBlockPool$Allocator;", "bytesUsed", "Lorg/gnit/lucenekmp/util/Counter;", "termVectors", "<init>", "(Lorg/gnit/lucenekmp/util/IntBlockPool$Allocator;Lorg/gnit/lucenekmp/util/ByteBlockPool$Allocator;Lorg/gnit/lucenekmp/util/Counter;Lorg/gnit/lucenekmp/index/TermsHash;)V", "applyDeletes", "", "state", "Lorg/gnit/lucenekmp/index/SegmentWriteState;", "fields", "Lorg/gnit/lucenekmp/index/Fields;", "flush", "fieldsToFlush", "", "", "Lorg/gnit/lucenekmp/index/TermsHashPerField;", "sortMap", "Lorg/gnit/lucenekmp/index/Sorter$DocMap;", "norms", "Lorg/gnit/lucenekmp/codecs/NormsProducer;", "addField", "invertState", "Lorg/gnit/lucenekmp/index/FieldInvertState;", "fieldInfo", "Lorg/gnit/lucenekmp/index/FieldInfo;", "SortingTerms", "SortingTermsEnum", "SortingDocsEnum", "SortingPostingsEnum", "core"})
@SourceDebugExtension(value={"SMAP\nFreqProxTermsWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FreqProxTermsWriter.kt\norg/gnit/lucenekmp/index/FreqProxTermsWriter\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,512:1\n3#2,8:513\n3#2,8:522\n3#2,8:531\n10#3:521\n10#3:530\n10#3:539\n1#4:540\n*S KotlinDebug\n*F\n+ 1 FreqProxTermsWriter.kt\norg/gnit/lucenekmp/index/FreqProxTermsWriter\n*L\n79#1:513,8\n85#1:522,8\n46#1:531,8\n79#1:521\n85#1:530\n46#1:539\n*E\n"})
public final class FreqProxTermsWriter
extends TermsHash {
    public FreqProxTermsWriter(@NotNull IntBlockPool.Allocator intBlockAllocator, @NotNull ByteBlockPool.Allocator byteBlockAllocator, @NotNull Counter bytesUsed, @NotNull TermsHash termVectors2) {
        Intrinsics.checkNotNullParameter((Object)intBlockAllocator, (String)"intBlockAllocator");
        Intrinsics.checkNotNullParameter((Object)byteBlockAllocator, (String)"byteBlockAllocator");
        Intrinsics.checkNotNullParameter((Object)bytesUsed, (String)"bytesUsed");
        Intrinsics.checkNotNullParameter((Object)termVectors2, (String)"termVectors");
        super(intBlockAllocator, byteBlockAllocator, bytesUsed, termVectors2);
    }

    private final void applyDeletes(SegmentWriteState state2, Fields fields) throws IOException {
        if (state2.getSegUpdates() != null && state2.getSegUpdates().getDeleteTerms().size() > 0) {
            BufferedUpdates.DeletedTerms segDeletes = state2.getSegUpdates().getDeleteTerms();
            FrozenBufferedUpdates.TermDocsIterator iterator2 = new FrozenBufferedUpdates.TermDocsIterator(fields, true);
            segDeletes.forEachOrdered((arg_0, arg_1) -> FreqProxTermsWriter.applyDeletes$lambda$1(iterator2, state2, arg_0, arg_1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(@NotNull Map<String, TermsHashPerField> fieldsToFlush, @NotNull SegmentWriteState state2, @Nullable Sorter.DocMap sortMap, @NotNull NormsProducer norms) throws IOException {
        Intrinsics.checkNotNullParameter(fieldsToFlush, (String)"fieldsToFlush");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        Intrinsics.checkNotNullParameter((Object)norms, (String)"norms");
        super.flush(fieldsToFlush, state2, sortMap, norms);
        List allFields = new ArrayList();
        for (TermsHashPerField f : fieldsToFlush.values()) {
            Intrinsics.checkNotNull((Object)f, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.index.FreqProxTermsWriterPerField");
            FreqProxTermsWriterPerField perField = (FreqProxTermsWriterPerField)f;
            if (perField.getNumTerms() <= 0) continue;
            perField.sortTerms();
            boolean condition$iv = perField.getIndexOptions() != IndexOptions.NONE;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            allFields.add(perField);
        }
        FieldInfos fieldInfos = state2.getFieldInfos();
        Intrinsics.checkNotNull((Object)fieldInfos);
        if (!fieldInfos.hasPostings()) {
            boolean condition$iv = allFields.isEmpty();
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean $i$a$-assert-AssertKt$assert$22 = false;
                String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
                throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
            }
            return;
        }
        CollectionUtil.INSTANCE.introSort(allFields);
        Ref.ObjectRef fields = new Ref.ObjectRef();
        fields.element = new FreqProxFields(allFields);
        this.applyDeletes(state2, (Fields)fields.element);
        if (sortMap != null) {
            Sorter.DocMap docMap = sortMap;
            FieldInfos infos = state2.getFieldInfos();
            fields.element = new FilterLeafReader.FilterFields((Ref.ObjectRef<Fields>)fields, infos, docMap){
                final /* synthetic */ FieldInfos $infos;
                final /* synthetic */ Sorter.DocMap $docMap;
                {
                    this.$infos = $infos;
                    this.$docMap = $docMap;
                    super((Fields)$fields.element);
                }

                public Terms terms(String field) throws IOException {
                    SortingTerms sortingTerms;
                    Terms terms = this.getIn().terms(field);
                    if (terms == null) {
                        sortingTerms = null;
                    } else {
                        String string = field;
                        Intrinsics.checkNotNull((Object)string);
                        FieldInfo fieldInfo = this.$infos.fieldInfo(string);
                        Intrinsics.checkNotNull((Object)fieldInfo);
                        sortingTerms = new SortingTerms(terms, fieldInfo.getIndexOptions(), this.$docMap);
                    }
                    return sortingTerms;
                }
            };
        }
        AutoCloseable autoCloseable = state2.getSegmentInfo().getCodec().postingsFormat().fieldsConsumer(state2);
        Throwable throwable = null;
        try {
            FieldsConsumer consumer = (FieldsConsumer)autoCloseable;
            boolean bl = false;
            consumer.write((Fields)fields.element, norms);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Override
    @NotNull
    public TermsHashPerField addField(@NotNull FieldInvertState invertState, @NotNull FieldInfo fieldInfo) {
        Intrinsics.checkNotNullParameter((Object)invertState, (String)"invertState");
        Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
        TermsHash termsHash = this;
        TermsHash termsHash2 = this.getNextTermsHash();
        Intrinsics.checkNotNull((Object)termsHash2);
        return new FreqProxTermsWriterPerField(invertState, termsHash, fieldInfo, termsHash2.addField(invertState, fieldInfo));
    }

    private static final void applyDeletes$lambda$1(FrozenBufferedUpdates.TermDocsIterator $iterator, SegmentWriteState $state, Term term, int docId) {
        Intrinsics.checkNotNullParameter((Object)term, (String)"term");
        DocIdSetIterator postings = $iterator.nextTerm(term.field(), term.bytes());
        if (postings != null) {
            boolean condition$iv = docId < Integer.MAX_VALUE;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean $i$a$-assert-AssertKt$assert$22 = false;
                String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
                throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
            }
            int doc = 0;
            while (true) {
                int n;
                int it = n = postings.nextDoc();
                boolean bl = false;
                doc = it;
                if (n >= docId) break;
                if ($state.getLiveDocs() == null) {
                    $state.setLiveDocs(new FixedBitSet($state.getSegmentInfo().maxDoc()));
                    FixedBitSet fixedBitSet = $state.getLiveDocs();
                    Intrinsics.checkNotNull((Object)fixedBitSet);
                    fixedBitSet.set(0, $state.getSegmentInfo().maxDoc());
                }
                FixedBitSet fixedBitSet = $state.getLiveDocs();
                Intrinsics.checkNotNull((Object)fixedBitSet);
                if (!fixedBitSet.getAndClear(doc)) continue;
                n = $state.getDelCountOnFlush();
                $state.setDelCountOnFlush(n + 1);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0001J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nH\u0016J\b\u0010\u0015\u001a\u00020\nH\u0016J\b\u0010\u0016\u001a\u00020\nH\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\nH\u0016J\b\u0010\u001a\u001a\u00020\nH\u0016J\b\u0010\u001b\u001a\u00020\nH\u0016J\b\u0010\u001c\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u001d\u001a\u0004\u0018\u00010\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006!"}, d2={"Lorg/gnit/lucenekmp/index/FreqProxTermsWriter$SortingDocsEnum;", "Lorg/gnit/lucenekmp/index/PostingsEnum;", "<init>", "()V", "sorter", "Lorg/gnit/lucenekmp/util/LSBRadixSorter;", "in", "docs", "", "docIt", "", "upTo", "reset", "", "docMap", "Lorg/gnit/lucenekmp/index/Sorter$DocMap;", "wrapped", "getWrapped", "()Lorg/gnit/lucenekmp/index/PostingsEnum;", "advance", "target", "docID", "nextDoc", "cost", "", "freq", "nextPosition", "startOffset", "endOffset", "payload", "Lorg/gnit/lucenekmp/util/BytesRef;", "getPayload", "()Lorg/gnit/lucenekmp/util/BytesRef;", "core"})
    public static final class SortingDocsEnum
    extends PostingsEnum {
        @NotNull
        private final LSBRadixSorter sorter = new LSBRadixSorter();
        @Nullable
        private PostingsEnum in;
        @NotNull
        private int[] docs = IntsRef.Companion.getEMPTY_INTS();
        private int docIt;
        private int upTo;

        public final void reset(@NotNull Sorter.DocMap docMap, @NotNull PostingsEnum in) throws IOException {
            Intrinsics.checkNotNullParameter((Object)docMap, (String)"docMap");
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            this.in = in;
            int i = 0;
            int doc = in.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                if (this.docs.length <= i) {
                    this.docs = ArrayUtil.Companion.grow(this.docs);
                }
                this.docs[i++] = docMap.oldToNew(doc);
                doc = in.nextDoc();
            }
            this.upTo = i;
            if (this.docs.length == this.upTo) {
                this.docs = ArrayUtil.Companion.grow(this.docs);
            }
            this.docs[this.upTo] = Integer.MAX_VALUE;
            int maxDoc = docMap.size();
            int numBits = PackedInts.INSTANCE.bitsRequired(Math.max(0, maxDoc - 1));
            this.sorter.sort(numBits, this.docs, this.upTo);
            this.docIt = -1;
        }

        @Nullable
        public final PostingsEnum getWrapped() {
            return this.in;
        }

        @Override
        public int advance(int target) throws IOException {
            return this.slowAdvance(target);
        }

        @Override
        public int docID() {
            return this.docIt < 0 ? -1 : this.docs[this.docIt];
        }

        @Override
        public int nextDoc() throws IOException {
            ++this.docIt;
            return this.docs[this.docIt];
        }

        @Override
        public long cost() {
            return this.upTo;
        }

        @Override
        public int freq() throws IOException {
            return 1;
        }

        @Override
        public int nextPosition() throws IOException {
            return -1;
        }

        @Override
        public int startOffset() throws IOException {
            return -1;
        }

        @Override
        public int endOffset() throws IOException {
            return -1;
        }

        @Override
        @Nullable
        public BytesRef getPayload() {
            return null;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u00011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J\u0018\u0010#\u001a\u00020 2\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\u000bH\u0016J\b\u0010(\u001a\u00020\u000bH\u0016J\b\u0010\u0015\u001a\u00020\u000bH\u0016J\b\u0010)\u001a\u00020\u000bH\u0016J\b\u0010*\u001a\u00020\u000bH\u0016J\b\u0010+\u001a\u00020\u000bH\u0016J\b\u0010\u0014\u001a\u00020\u000bH\u0016J\b\u0010/\u001a\u000200H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0016\u001a\u0004\u0018\u00010\u00178VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010,\u001a\u0004\u0018\u00010\u00018F\u00a2\u0006\u0006\u001a\u0004\b-\u0010.\u00a8\u00062"}, d2={"Lorg/gnit/lucenekmp/index/FreqProxTermsWriter$SortingPostingsEnum;", "Lorg/gnit/lucenekmp/index/PostingsEnum;", "<init>", "()V", "sorter", "Lorg/gnit/lucenekmp/index/FreqProxTermsWriter$SortingPostingsEnum$DocOffsetSorter;", "docs", "", "offsets", "", "upto", "", "postingInput", "Lorg/gnit/lucenekmp/store/ByteBuffersDataInput;", "in", "storePositions", "", "storeOffsets", "docIt", "pos", "startOffset", "endOffset", "payload", "Lorg/gnit/lucenekmp/util/BytesRef;", "getPayload", "()Lorg/gnit/lucenekmp/util/BytesRef;", "setPayload", "(Lorg/gnit/lucenekmp/util/BytesRef;)V", "currFreq", "buffer", "Lorg/gnit/lucenekmp/store/ByteBuffersDataOutput;", "reset", "", "docMap", "Lorg/gnit/lucenekmp/index/Sorter$DocMap;", "addPositions", "out", "Lorg/gnit/lucenekmp/store/DataOutput;", "advance", "target", "docID", "freq", "nextDoc", "nextPosition", "wrapped", "getWrapped", "()Lorg/gnit/lucenekmp/index/PostingsEnum;", "cost", "", "DocOffsetSorter", "core"})
    @SourceDebugExtension(value={"SMAP\nFreqProxTermsWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FreqProxTermsWriter.kt\norg/gnit/lucenekmp/index/FreqProxTermsWriter$SortingPostingsEnum\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,512:1\n1#2:513\n*E\n"})
    public static final class SortingPostingsEnum
    extends PostingsEnum {
        @Nullable
        private DocOffsetSorter sorter;
        @NotNull
        private int[] docs = IntsRef.Companion.getEMPTY_INTS();
        @NotNull
        private long[] offsets = LongsRef.Companion.getEMPTY_LONGS();
        private int upto;
        @Nullable
        private ByteBuffersDataInput postingInput;
        @Nullable
        private PostingsEnum in;
        private boolean storePositions;
        private boolean storeOffsets;
        private int docIt;
        private int pos;
        private int startOffset;
        private int endOffset;
        @Nullable
        private BytesRef payload = new BytesRef();
        private int currFreq;
        @NotNull
        private final ByteBuffersDataOutput buffer = ByteBuffersDataOutput.Companion.newResettableInstance();

        @Override
        @Nullable
        public BytesRef getPayload() {
            BytesRef bytesRef = this.getPayload();
            Intrinsics.checkNotNull((Object)bytesRef);
            return bytesRef.getLength() == 0 ? null : this.getPayload();
        }

        public void setPayload(@Nullable BytesRef bytesRef) {
            this.payload = bytesRef;
        }

        public final void reset(@NotNull Sorter.DocMap docMap, @NotNull PostingsEnum in, boolean storePositions, boolean storeOffsets) throws IOException {
            Intrinsics.checkNotNullParameter((Object)docMap, (String)"docMap");
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            this.in = in;
            this.storePositions = storePositions;
            this.storeOffsets = storeOffsets;
            if (this.sorter == null) {
                int numTempSlots = docMap.size() / 8;
                this.sorter = new DocOffsetSorter(numTempSlots);
            }
            this.docIt = -1;
            this.startOffset = -1;
            this.endOffset = -1;
            this.buffer.reset();
            int doc = 0;
            int i = 0;
            while (true) {
                int n;
                int it = n = in.nextDoc();
                boolean bl = false;
                doc = it;
                if (n == Integer.MAX_VALUE) break;
                if (i == this.docs.length) {
                    int newLength = ArrayUtil.Companion.oversize(i + 1, 4);
                    this.docs = ArrayUtil.Companion.growExact(this.docs, newLength);
                    this.offsets = ArrayUtil.Companion.growExact(this.offsets, newLength);
                }
                this.docs[i] = docMap.oldToNew(doc);
                this.offsets[i] = this.buffer.size();
                this.addPositions(in, this.buffer);
                ++i;
            }
            this.upto = i;
            DocOffsetSorter docOffsetSorter = this.sorter;
            Intrinsics.checkNotNull((Object)docOffsetSorter);
            docOffsetSorter.reset(this.docs, this.offsets);
            DocOffsetSorter docOffsetSorter2 = this.sorter;
            Intrinsics.checkNotNull((Object)docOffsetSorter2);
            docOffsetSorter2.sort(0, this.upto);
            this.postingInput = this.buffer.toDataInput();
        }

        private final void addPositions(PostingsEnum in, DataOutput out) throws IOException {
            int freq = in.freq();
            out.writeVInt(freq);
            if (this.storePositions) {
                int previousPosition = 0;
                int previousEndOffset = 0;
                for (int i = 0; i < freq; ++i) {
                    int pos = in.nextPosition();
                    BytesRef payload = in.getPayload();
                    int token = pos - previousPosition << 1 | (payload == null ? 0 : 1);
                    out.writeVInt(token);
                    previousPosition = pos;
                    if (this.storeOffsets) {
                        int startOffset = in.startOffset();
                        int endOffset = in.endOffset();
                        out.writeVInt(startOffset - previousEndOffset);
                        out.writeVInt(endOffset - startOffset);
                        previousEndOffset = endOffset;
                    }
                    if (payload == null) continue;
                    out.writeVInt(payload.getLength());
                    out.writeBytes(payload.getBytes(), payload.getOffset(), payload.getLength());
                }
            }
        }

        @Override
        public int advance(int target) throws IOException {
            return this.slowAdvance(target);
        }

        @Override
        public int docID() {
            return this.docIt < 0 ? -1 : (this.docIt >= this.upto ? Integer.MAX_VALUE : this.docs[this.docIt]);
        }

        @Override
        public int endOffset() throws IOException {
            return this.endOffset;
        }

        @Override
        public int freq() throws IOException {
            return this.currFreq;
        }

        @Override
        public int nextDoc() throws IOException {
            ++this.docIt;
            if (this.docIt >= this.upto) {
                return Integer.MAX_VALUE;
            }
            ByteBuffersDataInput byteBuffersDataInput = this.postingInput;
            Intrinsics.checkNotNull((Object)byteBuffersDataInput);
            byteBuffersDataInput.seek(this.offsets[this.docIt]);
            ByteBuffersDataInput byteBuffersDataInput2 = this.postingInput;
            Intrinsics.checkNotNull((Object)byteBuffersDataInput2);
            this.currFreq = byteBuffersDataInput2.readVInt();
            this.pos = 0;
            this.endOffset = 0;
            return this.docs[this.docIt];
        }

        @Override
        public int nextPosition() throws IOException {
            if (!this.storePositions) {
                return -1;
            }
            ByteBuffersDataInput byteBuffersDataInput = this.postingInput;
            Intrinsics.checkNotNull((Object)byteBuffersDataInput);
            int token = byteBuffersDataInput.readVInt();
            this.pos += token >>> 1;
            if (this.storeOffsets) {
                ByteBuffersDataInput byteBuffersDataInput2 = this.postingInput;
                Intrinsics.checkNotNull((Object)byteBuffersDataInput2);
                this.startOffset = this.endOffset + byteBuffersDataInput2.readVInt();
                ByteBuffersDataInput byteBuffersDataInput3 = this.postingInput;
                Intrinsics.checkNotNull((Object)byteBuffersDataInput3);
                this.endOffset = this.startOffset + byteBuffersDataInput3.readVInt();
            }
            if ((token & 1) != 0) {
                BytesRef bytesRef = this.getPayload();
                Intrinsics.checkNotNull((Object)bytesRef);
                bytesRef.setOffset(0);
                BytesRef bytesRef2 = this.getPayload();
                Intrinsics.checkNotNull((Object)bytesRef2);
                ByteBuffersDataInput byteBuffersDataInput4 = this.postingInput;
                Intrinsics.checkNotNull((Object)byteBuffersDataInput4);
                bytesRef2.setLength(byteBuffersDataInput4.readVInt());
                BytesRef bytesRef3 = this.getPayload();
                Intrinsics.checkNotNull((Object)bytesRef3);
                int n = bytesRef3.getLength();
                BytesRef bytesRef4 = this.getPayload();
                Intrinsics.checkNotNull((Object)bytesRef4);
                if (n > bytesRef4.getBytes().length) {
                    BytesRef bytesRef5 = this.getPayload();
                    Intrinsics.checkNotNull((Object)bytesRef5);
                    BytesRef bytesRef6 = this.getPayload();
                    Intrinsics.checkNotNull((Object)bytesRef6);
                    bytesRef5.setBytes(new byte[ArrayUtil.Companion.oversize(bytesRef6.getLength(), 1)]);
                }
                ByteBuffersDataInput byteBuffersDataInput5 = this.postingInput;
                Intrinsics.checkNotNull((Object)byteBuffersDataInput5);
                BytesRef bytesRef7 = this.getPayload();
                Intrinsics.checkNotNull((Object)bytesRef7);
                byte[] byArray = bytesRef7.getBytes();
                BytesRef bytesRef8 = this.getPayload();
                Intrinsics.checkNotNull((Object)bytesRef8);
                byteBuffersDataInput5.readBytes(byArray, 0, bytesRef8.getLength());
            } else {
                BytesRef bytesRef = this.getPayload();
                Intrinsics.checkNotNull((Object)bytesRef);
                bytesRef.setLength(0);
            }
            return this.pos;
        }

        @Override
        public int startOffset() throws IOException {
            return this.startOffset;
        }

        @Nullable
        public final PostingsEnum getWrapped() {
            return this.in;
        }

        @Override
        public long cost() {
            PostingsEnum postingsEnum = this.in;
            Intrinsics.checkNotNull((Object)postingsEnum);
            return postingsEnum.cost();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\f\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0014J\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0014J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003H\u0014J\u0018\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003H\u0014J\u0018\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0014J\u0018\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/gnit/lucenekmp/index/FreqProxTermsWriter$SortingPostingsEnum$DocOffsetSorter;", "Lorg/gnit/lucenekmp/util/TimSorter;", "numTempSlots", "", "<init>", "(I)V", "docs", "", "offsets", "", "tmpDocs", "tmpOffsets", "reset", "", "compare", "i", "j", "swap", "copy", "src", "dest", "save", "len", "restore", "compareSaved", "core"})
        private static final class DocOffsetSorter
        extends TimSorter {
            private int[] docs;
            private long[] offsets;
            @NotNull
            private int[] tmpDocs = IntsRef.Companion.getEMPTY_INTS();
            @NotNull
            private long[] tmpOffsets = LongsRef.Companion.getEMPTY_LONGS();

            public DocOffsetSorter(int numTempSlots) {
                super(numTempSlots);
            }

            public final void reset(@NotNull int[] docs, @NotNull long[] offsets) {
                Intrinsics.checkNotNullParameter((Object)docs, (String)"docs");
                Intrinsics.checkNotNullParameter((Object)offsets, (String)"offsets");
                this.docs = docs;
                this.offsets = offsets;
            }

            @Override
            protected int compare(int i, int j) {
                int[] nArray = this.docs;
                if (this.docs == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"docs");
                    nArray = null;
                }
                int n = nArray[i];
                int[] nArray2 = this.docs;
                if (this.docs == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"docs");
                    nArray2 = null;
                }
                return n - nArray2[j];
            }

            @Override
            protected void swap(int i, int j) {
                int[] nArray = this.docs;
                if (this.docs == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"docs");
                    nArray = null;
                }
                int tmpDoc = nArray[i];
                int[] nArray2 = this.docs;
                if (this.docs == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"docs");
                    nArray2 = null;
                }
                int[] nArray3 = this.docs;
                if (this.docs == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"docs");
                    nArray3 = null;
                }
                nArray2[i] = nArray3[j];
                int[] nArray4 = this.docs;
                if (this.docs == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"docs");
                    nArray4 = null;
                }
                nArray4[j] = tmpDoc;
                long[] lArray = this.offsets;
                if (this.offsets == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
                    lArray = null;
                }
                long tmpOffset = lArray[i];
                long[] lArray2 = this.offsets;
                if (this.offsets == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
                    lArray2 = null;
                }
                long[] lArray3 = this.offsets;
                if (this.offsets == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
                    lArray3 = null;
                }
                lArray2[i] = lArray3[j];
                long[] lArray4 = this.offsets;
                if (this.offsets == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
                    lArray4 = null;
                }
                lArray4[j] = tmpOffset;
            }

            @Override
            protected void copy(int src, int dest) {
                int[] nArray = this.docs;
                if (this.docs == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"docs");
                    nArray = null;
                }
                int[] nArray2 = this.docs;
                if (this.docs == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"docs");
                    nArray2 = null;
                }
                nArray[dest] = nArray2[src];
                long[] lArray = this.offsets;
                if (this.offsets == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
                    lArray = null;
                }
                long[] lArray2 = this.offsets;
                if (this.offsets == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
                    lArray2 = null;
                }
                lArray[dest] = lArray2[src];
            }

            @Override
            protected void save(int i, int len) {
                if (this.tmpDocs.length < len) {
                    this.tmpDocs = new int[ArrayUtil.Companion.oversize(len, 4)];
                    this.tmpOffsets = new long[this.tmpDocs.length];
                }
                int[] nArray = this.docs;
                if (this.docs == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"docs");
                    nArray = null;
                }
                System.INSTANCE.arraycopy(nArray, i, this.tmpDocs, 0, len);
                long[] lArray = this.offsets;
                if (this.offsets == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
                    lArray = null;
                }
                System.INSTANCE.arraycopy(lArray, i, this.tmpOffsets, 0, len);
            }

            @Override
            protected void restore(int i, int j) {
                int[] nArray = this.docs;
                if (this.docs == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"docs");
                    nArray = null;
                }
                nArray[j] = this.tmpDocs[i];
                long[] lArray = this.offsets;
                if (this.offsets == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
                    lArray = null;
                }
                lArray[j] = this.tmpOffsets[i];
            }

            @Override
            protected int compareSaved(int i, int j) {
                int n = this.tmpDocs[i];
                int[] nArray = this.docs;
                if (this.docs == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"docs");
                    nArray = null;
                }
                return n - nArray[j];
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lorg/gnit/lucenekmp/index/FreqProxTermsWriter$SortingTerms;", "Lorg/gnit/lucenekmp/index/FilterLeafReader$FilterTerms;", "in", "Lorg/gnit/lucenekmp/index/Terms;", "indexOptions", "Lorg/gnit/lucenekmp/index/IndexOptions;", "docMap", "Lorg/gnit/lucenekmp/index/Sorter$DocMap;", "<init>", "(Lorg/gnit/lucenekmp/index/Terms;Lorg/gnit/lucenekmp/index/IndexOptions;Lorg/gnit/lucenekmp/index/Sorter$DocMap;)V", "iterator", "Lorg/gnit/lucenekmp/index/TermsEnum;", "intersect", "compiled", "Lorg/gnit/lucenekmp/util/automaton/CompiledAutomaton;", "startTerm", "Lorg/gnit/lucenekmp/util/BytesRef;", "sumTotalTermFreq", "", "getSumTotalTermFreq", "()J", "core"})
    public static final class SortingTerms
    extends FilterLeafReader.FilterTerms {
        @NotNull
        private final IndexOptions indexOptions;
        @NotNull
        private final Sorter.DocMap docMap;

        public SortingTerms(@NotNull Terms in, @NotNull IndexOptions indexOptions, @NotNull Sorter.DocMap docMap) {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            Intrinsics.checkNotNullParameter((Object)((Object)indexOptions), (String)"indexOptions");
            Intrinsics.checkNotNullParameter((Object)docMap, (String)"docMap");
            super(in);
            this.indexOptions = indexOptions;
            this.docMap = docMap;
        }

        @Override
        @NotNull
        public TermsEnum iterator() throws IOException {
            return new SortingTermsEnum(this.getIn().iterator(), this.docMap, this.indexOptions);
        }

        @Override
        @NotNull
        public TermsEnum intersect(@NotNull CompiledAutomaton compiled, @Nullable BytesRef startTerm) throws IOException {
            Intrinsics.checkNotNullParameter((Object)compiled, (String)"compiled");
            return new SortingTermsEnum(this.getIn().intersect(compiled, startTerm), this.docMap, this.indexOptions);
        }

        @Override
        public long getSumTotalTermFreq() {
            throw new UnsupportedOperationException("sumTotalTermFreq is not supported by SortingTerms");
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/gnit/lucenekmp/index/FreqProxTermsWriter$SortingTermsEnum;", "Lorg/gnit/lucenekmp/index/FilterLeafReader$FilterTermsEnum;", "in", "Lorg/gnit/lucenekmp/index/TermsEnum;", "docMap", "Lorg/gnit/lucenekmp/index/Sorter$DocMap;", "indexOptions", "Lorg/gnit/lucenekmp/index/IndexOptions;", "<init>", "(Lorg/gnit/lucenekmp/index/TermsEnum;Lorg/gnit/lucenekmp/index/Sorter$DocMap;Lorg/gnit/lucenekmp/index/IndexOptions;)V", "getDocMap", "()Lorg/gnit/lucenekmp/index/Sorter$DocMap;", "postings", "Lorg/gnit/lucenekmp/index/PostingsEnum;", "reuse", "flags", "", "core"})
    private static final class SortingTermsEnum
    extends FilterLeafReader.FilterTermsEnum {
        @NotNull
        private final Sorter.DocMap docMap;
        @NotNull
        private final IndexOptions indexOptions;

        public SortingTermsEnum(@NotNull TermsEnum in, @NotNull Sorter.DocMap docMap, @NotNull IndexOptions indexOptions) {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            Intrinsics.checkNotNullParameter((Object)docMap, (String)"docMap");
            Intrinsics.checkNotNullParameter((Object)((Object)indexOptions), (String)"indexOptions");
            super(in);
            this.docMap = docMap;
            this.indexOptions = indexOptions;
        }

        @NotNull
        public final Sorter.DocMap getDocMap() {
            return this.docMap;
        }

        @Override
        @NotNull
        public PostingsEnum postings(@Nullable PostingsEnum reuse, int flags) throws IOException {
            if (this.indexOptions.compareTo((Enum)IndexOptions.DOCS_AND_FREQS) >= 0 && PostingsEnum.Companion.featureRequested(flags, PostingsEnum.Companion.getFREQS())) {
                PostingsEnum inReuse = null;
                SortingPostingsEnum wrapReuse = null;
                if (reuse != null && reuse instanceof SortingPostingsEnum) {
                    wrapReuse = (SortingPostingsEnum)reuse;
                    inReuse = wrapReuse.getWrapped();
                } else {
                    wrapReuse = new SortingPostingsEnum();
                    inReuse = reuse;
                }
                PostingsEnum inDocsAndPositions = this.getIn().postings(inReuse, flags);
                boolean storePositions = this.indexOptions.compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
                boolean storeOffsets = this.indexOptions.compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
                wrapReuse.reset(this.docMap, inDocsAndPositions, storePositions, storeOffsets);
                return wrapReuse;
            }
            PostingsEnum inReuse = null;
            SortingDocsEnum wrapReuse = null;
            if (reuse != null && reuse instanceof SortingDocsEnum) {
                wrapReuse = (SortingDocsEnum)reuse;
                inReuse = wrapReuse.getWrapped();
            } else {
                wrapReuse = new SortingDocsEnum();
                inReuse = reuse;
            }
            PostingsEnum inDocs = this.getIn().postings(inReuse, flags);
            wrapReuse.reset(this.docMap, inDocs);
            return wrapReuse;
        }
    }
}

