/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.analysis.tokenattributes.OffsetAttribute;
import org.gnit.lucenekmp.analysis.tokenattributes.PayloadAttribute;
import org.gnit.lucenekmp.analysis.tokenattributes.TermFrequencyAttribute;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.FieldInvertState;
import org.gnit.lucenekmp.index.IndexOptions;
import org.gnit.lucenekmp.index.IndexableField;
import org.gnit.lucenekmp.index.ParallelPostingsArray;
import org.gnit.lucenekmp.index.TermsHash;
import org.gnit.lucenekmp.index.TermsHashPerField;
import org.gnit.lucenekmp.jdkport.Math;
import org.gnit.lucenekmp.jdkport.System;
import org.gnit.lucenekmp.util.ByteBlockPool;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.IntBlockPool;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001BB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0001\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010,\u001a\u00020-H\u0016J\u0018\u0010.\u001a\u00020\u000f2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u000fH\u0016J\u0016\u00102\u001a\u00020-2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u000204J\u0016\u00106\u001a\u00020-2\u0006\u00103\u001a\u0002042\u0006\u00107\u001a\u000204J\u0018\u00108\u001a\u00020-2\u0006\u00103\u001a\u0002042\u0006\u00109\u001a\u000204H\u0016J\u0018\u0010:\u001a\u00020-2\u0006\u00103\u001a\u0002042\u0006\u00109\u001a\u000204H\u0016J\b\u0010>\u001a\u00020-H\u0016J\u0010\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u000204H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\u0014\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001c\u0010\"\u001a\u0004\u0018\u00010#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0011\"\u0004\b*\u0010+R\u0014\u0010;\u001a\u0002048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010=\u00a8\u0006C"}, d2={"Lorg/gnit/lucenekmp/index/FreqProxTermsWriterPerField;", "Lorg/gnit/lucenekmp/index/TermsHashPerField;", "invertState", "Lorg/gnit/lucenekmp/index/FieldInvertState;", "termsHash", "Lorg/gnit/lucenekmp/index/TermsHash;", "fieldInfo", "Lorg/gnit/lucenekmp/index/FieldInfo;", "nextPerField", "<init>", "(Lorg/gnit/lucenekmp/index/FieldInvertState;Lorg/gnit/lucenekmp/index/TermsHash;Lorg/gnit/lucenekmp/index/FieldInfo;Lorg/gnit/lucenekmp/index/TermsHashPerField;)V", "freqProxPostingsArray", "Lorg/gnit/lucenekmp/index/FreqProxTermsWriterPerField$FreqProxPostingsArray;", "fieldState", "hasFreq", "", "getHasFreq", "()Z", "hasProx", "getHasProx", "hasOffsets", "getHasOffsets", "payloadAttribute", "Lorg/gnit/lucenekmp/analysis/tokenattributes/PayloadAttribute;", "getPayloadAttribute", "()Lorg/gnit/lucenekmp/analysis/tokenattributes/PayloadAttribute;", "setPayloadAttribute", "(Lorg/gnit/lucenekmp/analysis/tokenattributes/PayloadAttribute;)V", "offsetAttribute", "Lorg/gnit/lucenekmp/analysis/tokenattributes/OffsetAttribute;", "getOffsetAttribute", "()Lorg/gnit/lucenekmp/analysis/tokenattributes/OffsetAttribute;", "setOffsetAttribute", "(Lorg/gnit/lucenekmp/analysis/tokenattributes/OffsetAttribute;)V", "termFreqAtt", "Lorg/gnit/lucenekmp/analysis/tokenattributes/TermFrequencyAttribute;", "getTermFreqAtt", "()Lorg/gnit/lucenekmp/analysis/tokenattributes/TermFrequencyAttribute;", "setTermFreqAtt", "(Lorg/gnit/lucenekmp/analysis/tokenattributes/TermFrequencyAttribute;)V", "sawPayloads", "getSawPayloads", "setSawPayloads", "(Z)V", "finish", "", "start", "field", "Lorg/gnit/lucenekmp/index/IndexableField;", "first", "writeProx", "termID", "", "proxCode", "writeOffsets", "offsetAccum", "newTerm", "docID", "addTerm", "termFreq", "getTermFreq", "()I", "newPostingsArray", "createPostingsArray", "Lorg/gnit/lucenekmp/index/ParallelPostingsArray;", "size", "FreqProxPostingsArray", "core"})
@SourceDebugExtension(value={"SMAP\nFreqProxTermsWriterPerField.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FreqProxTermsWriterPerField.kt\norg/gnit/lucenekmp/index/FreqProxTermsWriterPerField\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,271:1\n3#2,8:272\n3#2,8:281\n3#2,8:290\n3#2,8:299\n3#2,8:308\n3#2,8:317\n3#2,8:326\n8#2,2:335\n3#2,8:337\n10#3:280\n10#3:289\n10#3:298\n10#3:307\n10#3:316\n10#3:325\n10#3:334\n10#3:345\n*S KotlinDebug\n*F\n+ 1 FreqProxTermsWriterPerField.kt\norg/gnit/lucenekmp/index/FreqProxTermsWriterPerField\n*L\n79#1:272,8\n86#1:281,8\n97#1:290,8\n109#1:299,8\n118#1:308,8\n121#1:317,8\n128#1:326,8\n135#1:335,2\n163#1:337,8\n79#1:280\n86#1:289\n97#1:298\n109#1:307\n118#1:316\n121#1:325\n128#1:334\n163#1:345\n*E\n"})
public final class FreqProxTermsWriterPerField
extends TermsHashPerField {
    @NotNull
    private final FieldInfo fieldInfo;
    @Nullable
    private FreqProxPostingsArray freqProxPostingsArray;
    @NotNull
    private final FieldInvertState fieldState;
    private final boolean hasFreq;
    private final boolean hasProx;
    private final boolean hasOffsets;
    @Nullable
    private PayloadAttribute payloadAttribute;
    @Nullable
    private OffsetAttribute offsetAttribute;
    @Nullable
    private TermFrequencyAttribute termFreqAtt;
    private boolean sawPayloads;

    public FreqProxTermsWriterPerField(@NotNull FieldInvertState invertState, @NotNull TermsHash termsHash, @NotNull FieldInfo fieldInfo, @NotNull TermsHashPerField nextPerField) {
        Intrinsics.checkNotNullParameter((Object)invertState, (String)"invertState");
        Intrinsics.checkNotNullParameter((Object)termsHash, (String)"termsHash");
        Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
        Intrinsics.checkNotNullParameter((Object)nextPerField, (String)"nextPerField");
        int n = fieldInfo.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0 ? 2 : 1;
        IntBlockPool intBlockPool = termsHash.getIntPool();
        ByteBlockPool byteBlockPool = termsHash.getBytePool();
        ByteBlockPool byteBlockPool2 = termsHash.getTermBytePool();
        Intrinsics.checkNotNull((Object)byteBlockPool2);
        super(n, intBlockPool, byteBlockPool, byteBlockPool2, termsHash.getBytesUsed(), nextPerField, fieldInfo.getName(), fieldInfo.getIndexOptions());
        this.fieldInfo = fieldInfo;
        this.fieldState = invertState;
        this.hasFreq = this.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS) >= 0;
        this.hasProx = this.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
        this.hasOffsets = this.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
    }

    public final boolean getHasFreq() {
        return this.hasFreq;
    }

    public final boolean getHasProx() {
        return this.hasProx;
    }

    public final boolean getHasOffsets() {
        return this.hasOffsets;
    }

    @Nullable
    public final PayloadAttribute getPayloadAttribute() {
        return this.payloadAttribute;
    }

    public final void setPayloadAttribute(@Nullable PayloadAttribute payloadAttribute) {
        this.payloadAttribute = payloadAttribute;
    }

    @Nullable
    public final OffsetAttribute getOffsetAttribute() {
        return this.offsetAttribute;
    }

    public final void setOffsetAttribute(@Nullable OffsetAttribute offsetAttribute) {
        this.offsetAttribute = offsetAttribute;
    }

    @Nullable
    public final TermFrequencyAttribute getTermFreqAtt() {
        return this.termFreqAtt;
    }

    public final void setTermFreqAtt(@Nullable TermFrequencyAttribute termFrequencyAttribute) {
        this.termFreqAtt = termFrequencyAttribute;
    }

    public final boolean getSawPayloads() {
        return this.sawPayloads;
    }

    public final void setSawPayloads(boolean bl) {
        this.sawPayloads = bl;
    }

    @Override
    public void finish() throws IOException {
        super.finish();
        if (this.sawPayloads) {
            this.fieldInfo.setStorePayloads();
        }
    }

    @Override
    public boolean start(@NotNull IndexableField field, boolean first) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        super.start(field, first);
        this.termFreqAtt = this.fieldState.getTermFreqAttribute();
        this.payloadAttribute = this.fieldState.getPayloadAttribute();
        this.offsetAttribute = this.fieldState.getOffsetAttribute();
        return true;
    }

    public final void writeProx(int termID, int proxCode) {
        if (this.payloadAttribute == null) {
            this.writeVInt(1, proxCode << 1);
        } else {
            PayloadAttribute payloadAttribute = this.payloadAttribute;
            Intrinsics.checkNotNull((Object)payloadAttribute);
            BytesRef payload = payloadAttribute.getPayload();
            if (payload != null && payload.getLength() > 0) {
                this.writeVInt(1, proxCode << 1 | 1);
                this.writeVInt(1, payload.getLength());
                this.writeBytes(1, payload.getBytes(), payload.getOffset(), payload.getLength());
                this.sawPayloads = true;
            } else {
                this.writeVInt(1, proxCode << 1);
            }
        }
        boolean condition$iv = this.getPostingsArray() == this.freqProxPostingsArray;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        FreqProxPostingsArray freqProxPostingsArray = this.freqProxPostingsArray;
        Intrinsics.checkNotNull((Object)freqProxPostingsArray);
        int[] nArray = freqProxPostingsArray.getLastPositions();
        Intrinsics.checkNotNull((Object)nArray);
        nArray[termID] = this.fieldState.getPosition();
    }

    public final void writeOffsets(int termID, int offsetAccum) {
        OffsetAttribute offsetAttribute = this.offsetAttribute;
        Intrinsics.checkNotNull((Object)offsetAttribute);
        int startOffset = offsetAccum + offsetAttribute.startOffset();
        OffsetAttribute offsetAttribute2 = this.offsetAttribute;
        Intrinsics.checkNotNull((Object)offsetAttribute2);
        int endOffset = offsetAccum + offsetAttribute2.endOffset();
        FreqProxPostingsArray freqProxPostingsArray = this.freqProxPostingsArray;
        Intrinsics.checkNotNull((Object)freqProxPostingsArray);
        int[] nArray = freqProxPostingsArray.getLastOffsets();
        Intrinsics.checkNotNull((Object)nArray);
        boolean condition$iv = startOffset - nArray[termID] >= 0;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        FreqProxPostingsArray freqProxPostingsArray2 = this.freqProxPostingsArray;
        Intrinsics.checkNotNull((Object)freqProxPostingsArray2);
        int[] nArray2 = freqProxPostingsArray2.getLastOffsets();
        Intrinsics.checkNotNull((Object)nArray2);
        this.writeVInt(1, startOffset - nArray2[termID]);
        this.writeVInt(1, endOffset - startOffset);
        FreqProxPostingsArray freqProxPostingsArray3 = this.freqProxPostingsArray;
        Intrinsics.checkNotNull((Object)freqProxPostingsArray3);
        int[] nArray3 = freqProxPostingsArray3.getLastOffsets();
        Intrinsics.checkNotNull((Object)nArray3);
        nArray3[termID] = startOffset;
    }

    @Override
    public void newTerm(int termID, int docID) {
        FreqProxPostingsArray freqProxPostingsArray = this.freqProxPostingsArray;
        Intrinsics.checkNotNull((Object)freqProxPostingsArray);
        FreqProxPostingsArray postings = freqProxPostingsArray;
        postings.getLastDocIDs()[termID] = docID;
        if (!this.hasFreq) {
            condition$iv = postings.getTermFreqs() == null;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean $i$a$-assert-AssertKt$assert$22 = false;
                String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
                throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
            }
            postings.getLastDocCodes()[termID] = docID;
            this.fieldState.setMaxTermFrequency(java.lang.Math.max(1, this.fieldState.getMaxTermFrequency()));
        } else {
            postings.getLastDocCodes()[termID] = docID << 1;
            int[] nArray = postings.getTermFreqs();
            Intrinsics.checkNotNull((Object)nArray);
            nArray[termID] = this.getTermFreq();
            if (this.hasProx) {
                this.writeProx(termID, this.fieldState.getPosition());
                if (this.hasOffsets) {
                    this.writeOffsets(termID, this.fieldState.getOffset());
                }
            } else {
                condition$iv = !this.hasOffsets;
                boolean $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    boolean bl = false;
                    String string = "assertion failed";
                    throw new AssertionError((Object)string);
                }
            }
            int[] nArray2 = postings.getTermFreqs();
            Intrinsics.checkNotNull((Object)nArray2);
            this.fieldState.setMaxTermFrequency(java.lang.Math.max(nArray2[termID], this.fieldState.getMaxTermFrequency()));
        }
        FieldInvertState fieldInvertState = this.fieldState;
        int n = fieldInvertState.getUniqueTermCount();
        fieldInvertState.setUniqueTermCount(n + 1);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void addTerm(int termID, int docID) {
        block21: {
            block20: {
                v0 = this.freqProxPostingsArray;
                Intrinsics.checkNotNull((Object)v0);
                postings = v0;
                if (!this.hasFreq) ** GOTO lbl-1000
                v1 = postings.getTermFreqs();
                Intrinsics.checkNotNull((Object)v1);
                if (v1[termID] > 0) lbl-1000:
                // 2 sources

                {
                    v2 = true;
                } else {
                    v2 = false;
                }
                condition$iv = v2;
                $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    $i$a$-assert-AssertKt$assert$1 = false;
                    $i$a$-assert-AssertKt$assert$1 = "assertion failed";
                    throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$1);
                }
                if (this.hasFreq) break block20;
                condition$iv = postings.getTermFreqs() == null;
                $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    $i$a$-assert-AssertKt$assert$1 = false;
                    $i$a$-assert-AssertKt$assert$1 = "assertion failed";
                    throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$1);
                }
                if (this.termFreqAtt == null) ** GOTO lbl-1000
                v3 = this.termFreqAtt;
                Intrinsics.checkNotNull((Object)v3);
                if (v3.getTermFrequency() == 1) lbl-1000:
                // 2 sources

                {
                    v4 = true;
                } else {
                    v4 = false;
                }
                if (!v4) {
                    $i$a$-check-FreqProxTermsWriterPerField$addTerm$1 = false;
                    $i$a$-check-FreqProxTermsWriterPerField$addTerm$1 = "field \"" + this.getFieldName() + "\": must index term freq while using custom TermFrequencyAttribute";
                    throw new IllegalStateException($i$a$-check-FreqProxTermsWriterPerField$addTerm$1.toString());
                }
                if (docID != postings.getLastDocIDs()[termID]) {
                    condition$iv = docID > postings.getLastDocIDs()[termID];
                    $i$f$assert = false;
                    if (_Assertions.ENABLED && !condition$iv) {
                        $i$a$-assert-AssertKt$assert$1 = false;
                        $i$a$-assert-AssertKt$assert$1 = "assertion failed";
                        throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$1);
                    }
                    this.writeVInt(0, postings.getLastDocCodes()[termID]);
                    postings.getLastDocCodes()[termID] = docID - postings.getLastDocIDs()[termID];
                    postings.getLastDocIDs()[termID] = docID;
                    condition$iv = this.fieldState;
                    $i$a$-check-FreqProxTermsWriterPerField$addTerm$1 = condition$iv.getUniqueTermCount();
                    condition$iv.setUniqueTermCount($i$a$-check-FreqProxTermsWriterPerField$addTerm$1 + 1);
                }
                break block21;
            }
            if (docID != postings.getLastDocIDs()[termID]) {
                condition$iv = docID > postings.getLastDocIDs()[termID];
                $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    $i$a$-assert-FreqProxTermsWriterPerField$addTerm$2 = false;
                    $i$a$-assert-AssertKt$assert$1 = "id: " + docID + " postings ID: " + postings.getLastDocIDs()[termID] + " termID: " + termID;
                    throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$1);
                }
                v5 = postings.getTermFreqs();
                Intrinsics.checkNotNull((Object)v5);
                if (1 == v5[termID]) {
                    this.writeVInt(0, postings.getLastDocCodes()[termID] | 1);
                } else {
                    this.writeVInt(0, postings.getLastDocCodes()[termID]);
                    v6 = postings.getTermFreqs();
                    Intrinsics.checkNotNull((Object)v6);
                    this.writeVInt(0, v6[termID]);
                }
                v7 = postings.getTermFreqs();
                Intrinsics.checkNotNull((Object)v7);
                v7[termID] = this.getTermFreq();
                v8 = postings.getTermFreqs();
                Intrinsics.checkNotNull((Object)v8);
                this.fieldState.setMaxTermFrequency(java.lang.Math.max(v8[termID], this.fieldState.getMaxTermFrequency()));
                postings.getLastDocCodes()[termID] = docID - postings.getLastDocIDs()[termID] << 1;
                postings.getLastDocIDs()[termID] = docID;
                if (this.hasProx) {
                    this.writeProx(termID, this.fieldState.getPosition());
                    if (this.hasOffsets) {
                        v9 = postings.getLastOffsets();
                        Intrinsics.checkNotNull((Object)v9);
                        v9[termID] = 0;
                        this.writeOffsets(termID, this.fieldState.getOffset());
                    }
                } else {
                    condition$iv = this.hasOffsets == false;
                    $i$f$assert = false;
                    if (_Assertions.ENABLED && !condition$iv) {
                        $i$a$-assert-AssertKt$assert$1 = false;
                        var7_16 = "assertion failed";
                        throw new AssertionError((Object)var7_16);
                    }
                }
                var4_6 = this.fieldState;
                var5_20 = var4_6.getUniqueTermCount();
                var4_6.setUniqueTermCount(var5_20 + 1);
            } else {
                v10 = postings.getTermFreqs();
                Intrinsics.checkNotNull((Object)v10);
                v11 = postings.getTermFreqs();
                Intrinsics.checkNotNull((Object)v11);
                v10[termID] = Math.INSTANCE.addExact(v11[termID], this.getTermFreq());
                v12 = this.fieldState.getMaxTermFrequency();
                v13 = postings.getTermFreqs();
                Intrinsics.checkNotNull((Object)v13);
                this.fieldState.setMaxTermFrequency(java.lang.Math.max(v12, v13[termID]));
                if (this.hasProx) {
                    v14 = this.fieldState.getPosition();
                    v15 = postings.getLastPositions();
                    Intrinsics.checkNotNull((Object)v15);
                    this.writeProx(termID, v14 - v15[termID]);
                    if (this.hasOffsets) {
                        this.writeOffsets(termID, this.fieldState.getOffset());
                    }
                }
            }
        }
    }

    private final int getTermFreq() {
        int freq;
        if (this.termFreqAtt == null) {
            v0 = 1;
        } else {
            TermFrequencyAttribute termFrequencyAttribute = this.termFreqAtt;
            Intrinsics.checkNotNull((Object)termFrequencyAttribute);
            v0 = freq = termFrequencyAttribute.getTermFrequency();
        }
        if (freq != 1 && !(!this.hasProx)) {
            boolean bl = false;
            String string = "field \"" + this.getFieldName() + "\": cannot index positions while using custom TermFrequencyAttribute";
            throw new IllegalStateException(string.toString());
        }
        return freq;
    }

    @Override
    public void newPostingsArray() {
        ParallelPostingsArray parallelPostingsArray = this.getPostingsArray();
        Intrinsics.checkNotNull((Object)parallelPostingsArray, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.index.FreqProxTermsWriterPerField.FreqProxPostingsArray");
        this.freqProxPostingsArray = (FreqProxPostingsArray)parallelPostingsArray;
    }

    @Override
    @NotNull
    public ParallelPostingsArray createPostingsArray(int size2) {
        boolean hasFreq = this.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS) >= 0;
        boolean hasProx = this.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
        boolean hasOffsets = this.getIndexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
        return new FreqProxPostingsArray(size2, hasFreq, hasProx, hasOffsets);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0012\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00012\u0006\u0010 \u001a\u00020\u0003H\u0016J\b\u0010!\u001a\u00020\u0003H\u0016R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u001a\u0010\u0013\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000fR\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\r\"\u0004\b\u0018\u0010\u000fR\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\r\"\u0004\b\u001b\u0010\u000f\u00a8\u0006\""}, d2={"Lorg/gnit/lucenekmp/index/FreqProxTermsWriterPerField$FreqProxPostingsArray;", "Lorg/gnit/lucenekmp/index/ParallelPostingsArray;", "size", "", "writeFreqs", "", "writeProx", "writeOffsets", "<init>", "(IZZZ)V", "termFreqs", "", "getTermFreqs", "()[I", "setTermFreqs", "([I)V", "lastDocIDs", "getLastDocIDs", "setLastDocIDs", "lastDocCodes", "getLastDocCodes", "setLastDocCodes", "lastPositions", "getLastPositions", "setLastPositions", "lastOffsets", "getLastOffsets", "setLastOffsets", "newInstance", "copyTo", "", "toArray", "numToCopy", "bytesPerPosting", "core"})
    @SourceDebugExtension(value={"SMAP\nFreqProxTermsWriterPerField.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FreqProxTermsWriterPerField.kt\norg/gnit/lucenekmp/index/FreqProxTermsWriterPerField$FreqProxPostingsArray\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,271:1\n3#2,8:272\n3#2,8:281\n10#3:280\n10#3:289\n*S KotlinDebug\n*F\n+ 1 FreqProxTermsWriterPerField.kt\norg/gnit/lucenekmp/index/FreqProxTermsWriterPerField$FreqProxPostingsArray\n*L\n223#1:272,8\n234#1:281,8\n223#1:280\n234#1:289\n*E\n"})
    public static final class FreqProxPostingsArray
    extends ParallelPostingsArray {
        @Nullable
        private int[] termFreqs;
        @NotNull
        private int[] lastDocIDs;
        @NotNull
        private int[] lastDocCodes;
        @Nullable
        private int[] lastPositions;
        @Nullable
        private int[] lastOffsets;

        public FreqProxPostingsArray(int size2, boolean writeFreqs, boolean writeProx, boolean writeOffsets) {
            super(size2);
            if (writeFreqs) {
                this.termFreqs = new int[size2];
            }
            this.lastDocIDs = new int[size2];
            this.lastDocCodes = new int[size2];
            if (writeProx) {
                this.lastPositions = new int[size2];
                if (writeOffsets) {
                    this.lastOffsets = new int[size2];
                }
            } else {
                boolean condition$iv = !writeOffsets;
                boolean $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    boolean bl = false;
                    String string = "assertion failed";
                    throw new AssertionError((Object)string);
                }
            }
        }

        @Nullable
        public final int[] getTermFreqs() {
            return this.termFreqs;
        }

        public final void setTermFreqs(@Nullable int[] nArray) {
            this.termFreqs = nArray;
        }

        @NotNull
        public final int[] getLastDocIDs() {
            return this.lastDocIDs;
        }

        public final void setLastDocIDs(@NotNull int[] nArray) {
            Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
            this.lastDocIDs = nArray;
        }

        @NotNull
        public final int[] getLastDocCodes() {
            return this.lastDocCodes;
        }

        public final void setLastDocCodes(@NotNull int[] nArray) {
            Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
            this.lastDocCodes = nArray;
        }

        @Nullable
        public final int[] getLastPositions() {
            return this.lastPositions;
        }

        public final void setLastPositions(@Nullable int[] nArray) {
            this.lastPositions = nArray;
        }

        @Nullable
        public final int[] getLastOffsets() {
            return this.lastOffsets;
        }

        public final void setLastOffsets(@Nullable int[] nArray) {
            this.lastOffsets = nArray;
        }

        @Override
        @NotNull
        public ParallelPostingsArray newInstance(int size2) {
            return new FreqProxPostingsArray(size2, this.termFreqs != null, this.lastPositions != null, this.lastOffsets != null);
        }

        @Override
        public void copyTo(@NotNull ParallelPostingsArray toArray, int numToCopy) {
            Intrinsics.checkNotNullParameter((Object)toArray, (String)"toArray");
            boolean condition$iv = toArray instanceof FreqProxPostingsArray;
            boolean $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
            FreqProxPostingsArray to = (FreqProxPostingsArray)toArray;
            super.copyTo(toArray, numToCopy);
            System.INSTANCE.arraycopy(this.lastDocIDs, 0, to.lastDocIDs, 0, numToCopy);
            System.INSTANCE.arraycopy(this.lastDocCodes, 0, to.lastDocCodes, 0, numToCopy);
            if (this.lastPositions != null) {
                int[] nArray = to.lastPositions;
                if (to.lastPositions == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                Intrinsics.checkNotNull((Object)this.lastPositions);
                Intrinsics.checkNotNull((Object)to.lastPositions);
                System.INSTANCE.arraycopy(this.lastPositions, 0, to.lastPositions, 0, numToCopy);
            }
            if (this.lastOffsets != null) {
                int[] nArray = to.lastOffsets;
                if (to.lastOffsets == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                Intrinsics.checkNotNull((Object)this.lastOffsets);
                Intrinsics.checkNotNull((Object)to.lastOffsets);
                System.INSTANCE.arraycopy(this.lastOffsets, 0, to.lastOffsets, 0, numToCopy);
            }
            if (this.termFreqs != null) {
                int[] nArray = to.termFreqs;
                if (to.termFreqs == null) {
                    String string = "Required value was null.";
                    throw new IllegalStateException(string.toString());
                }
                Intrinsics.checkNotNull((Object)this.termFreqs);
                Intrinsics.checkNotNull((Object)to.termFreqs);
                System.INSTANCE.arraycopy(this.termFreqs, 0, to.termFreqs, 0, numToCopy);
            }
        }

        @Override
        public int bytesPerPosting() {
            int bytes = 20;
            if (this.lastPositions != null) {
                bytes += 4;
            }
            if (this.lastOffsets != null) {
                bytes += 4;
            }
            if (this.termFreqs != null) {
                bytes += 4;
            }
            return bytes;
        }
    }
}

