/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.index;

import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.index.BinaryDocValuesFieldUpdates;
import org.gnit.lucenekmp.index.BufferedUpdates;
import org.gnit.lucenekmp.index.BufferedUpdatesStream;
import org.gnit.lucenekmp.index.DocValuesFieldUpdates;
import org.gnit.lucenekmp.index.FieldTermIterator;
import org.gnit.lucenekmp.index.FieldUpdatesBuffer;
import org.gnit.lucenekmp.index.Fields;
import org.gnit.lucenekmp.index.FrozenBufferedUpdates;
import org.gnit.lucenekmp.index.LeafReader;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.gnit.lucenekmp.index.NumericDocValuesFieldUpdates;
import org.gnit.lucenekmp.index.PostingsEnum;
import org.gnit.lucenekmp.index.PrefixCodedTerms;
import org.gnit.lucenekmp.index.SegmentCommitInfo;
import org.gnit.lucenekmp.index.Term;
import org.gnit.lucenekmp.index.Terms;
import org.gnit.lucenekmp.index.TermsEnum;
import org.gnit.lucenekmp.jdkport.CountDownLatch;
import org.gnit.lucenekmp.jdkport.ReentrantLock;
import org.gnit.lucenekmp.jdkport.System;
import org.gnit.lucenekmp.jdkport.TimeUnit;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.search.IndexSearcher;
import org.gnit.lucenekmp.search.Query;
import org.gnit.lucenekmp.search.ScoreMode;
import org.gnit.lucenekmp.search.Scorer;
import org.gnit.lucenekmp.search.Weight;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.InfoStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 B2\u00020\u0001:\u0002ABB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u00100\u001a\u000201J\u0006\u00102\u001a\u000203J\u0006\u00104\u001a\u000203J\u0006\u00105\u001a\u000201J\u001c\u00106\u001a\u00020%2\f\u00107\u001a\b\u0012\u0004\u0012\u0002080\u0011H\u0086@\u00a2\u0006\u0002\u00109J\u001b\u0010:\u001a\u00020%2\f\u00107\u001a\b\u0012\u0004\u0012\u0002080\u0011H\u0002\u00a2\u0006\u0002\u0010;J\u001c\u0010<\u001a\u00020%2\f\u00107\u001a\b\u0012\u0004\u0012\u0002080\u0011H\u0082@\u00a2\u0006\u0002\u00109J\u001c\u0010=\u001a\u00020%2\f\u00107\u001a\b\u0012\u0004\u0012\u0002080\u0011H\u0082@\u00a2\u0006\u0002\u00109J\u000e\u0010>\u001a\u0002032\u0006\u0010/\u001a\u00020%J\u0006\u0010/\u001a\u00020%J\b\u0010?\u001a\u00020\"H\u0016J\u0006\u0010@\u001a\u000201R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0019\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010$\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010,\u001a\u00020+\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u000e\u0010/\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lorg/gnit/lucenekmp/index/FrozenBufferedUpdates;", "", "infoStream", "Lorg/gnit/lucenekmp/util/InfoStream;", "updates", "Lorg/gnit/lucenekmp/index/BufferedUpdates;", "privateSegment", "Lorg/gnit/lucenekmp/index/SegmentCommitInfo;", "<init>", "(Lorg/gnit/lucenekmp/util/InfoStream;Lorg/gnit/lucenekmp/index/BufferedUpdates;Lorg/gnit/lucenekmp/index/SegmentCommitInfo;)V", "getPrivateSegment", "()Lorg/gnit/lucenekmp/index/SegmentCommitInfo;", "deleteTerms", "Lorg/gnit/lucenekmp/index/PrefixCodedTerms;", "getDeleteTerms", "()Lorg/gnit/lucenekmp/index/PrefixCodedTerms;", "deleteQueries", "", "Lorg/gnit/lucenekmp/search/Query;", "getDeleteQueries", "()[Lorg/gnit/lucenekmp/search/Query;", "[Lorg/gnit/lucenekmp/search/Query;", "deleteQueryLimits", "", "getDeleteQueryLimits", "()[I", "applied", "Lorg/gnit/lucenekmp/jdkport/CountDownLatch;", "getApplied", "()Lorg/gnit/lucenekmp/jdkport/CountDownLatch;", "applyLock", "Lorg/gnit/lucenekmp/jdkport/ReentrantLock;", "fieldUpdates", "", "", "Lorg/gnit/lucenekmp/index/FieldUpdatesBuffer;", "totalDelCount", "", "getTotalDelCount", "()J", "setTotalDelCount", "(J)V", "fieldUpdatesCount", "", "bytesUsed", "getBytesUsed", "()I", "delGen", "tryLock", "", "lock", "", "unlock", "isApplied", "apply", "segStates", "Lorg/gnit/lucenekmp/index/BufferedUpdatesStream$SegmentState;", "([Lorg/gnit/lucenekmp/index/BufferedUpdatesStream$SegmentState;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "applyDocValuesUpdates", "([Lorg/gnit/lucenekmp/index/BufferedUpdatesStream$SegmentState;)J", "applyQueryDeletes", "applyTermDeletes", "setDelGen", "toString", "any", "TermDocsIterator", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nFrozenBufferedUpdates.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrozenBufferedUpdates.kt\norg/gnit/lucenekmp/index/FrozenBufferedUpdates\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,622:1\n8#2,2:623\n3#2,8:627\n3#2,8:636\n3#2,8:646\n3#2,8:655\n3#2,8:664\n3#2,8:673\n8#2,2:682\n8#2,2:684\n3#2,8:686\n1869#3,2:625\n10#4:635\n10#4:644\n10#4:654\n10#4:663\n10#4:672\n10#4:681\n10#4:694\n1#5:645\n*S KotlinDebug\n*F\n+ 1 FrozenBufferedUpdates.kt\norg/gnit/lucenekmp/index/FrozenBufferedUpdates\n*L\n59#1:623,2\n119#1:627,8\n128#1:636,8\n131#1:646,8\n134#1:655,8\n135#1:664,8\n271#1:673,8\n278#1:682,2\n329#1:684,2\n335#1:686,8\n83#1:625,2\n119#1:635\n128#1:644\n131#1:654\n134#1:663\n135#1:672\n271#1:681\n335#1:694\n*E\n"})
public final class FrozenBufferedUpdates {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InfoStream infoStream;
    @Nullable
    private final SegmentCommitInfo privateSegment;
    @NotNull
    private final PrefixCodedTerms deleteTerms;
    @NotNull
    private final Query[] deleteQueries;
    @NotNull
    private final int[] deleteQueryLimits;
    @NotNull
    private final CountDownLatch applied;
    @NotNull
    private final ReentrantLock applyLock;
    @NotNull
    private final Map<String, FieldUpdatesBuffer> fieldUpdates;
    private long totalDelCount;
    private final int fieldUpdatesCount;
    private final int bytesUsed;
    private long delGen;
    public static final int BYTES_PER_DEL_QUERY = 32;

    /*
     * WARNING - void declaration
     */
    public FrozenBufferedUpdates(@NotNull InfoStream infoStream, @NotNull BufferedUpdates updates, @Nullable SegmentCommitInfo privateSegment) {
        void condition$iv;
        Intrinsics.checkNotNullParameter((Object)infoStream, (String)"infoStream");
        Intrinsics.checkNotNullParameter((Object)updates, (String)"updates");
        this.infoStream = infoStream;
        this.privateSegment = privateSegment;
        this.applied = new CountDownLatch(1);
        this.applyLock = new ReentrantLock();
        this.delGen = -1L;
        boolean bl = this.privateSegment == null || updates.getDeleteTerms().isEmpty();
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && condition$iv == false) {
            boolean $i$a$-assert-FrozenBufferedUpdates$22 = false;
            String $i$a$-assert-FrozenBufferedUpdates$22 = "segment private packet should only have del queries";
            throw new AssertionError((Object)$i$a$-assert-FrozenBufferedUpdates$22);
        }
        PrefixCodedTerms.Builder builder = new PrefixCodedTerms.Builder();
        updates.getDeleteTerms().forEachOrdered((arg_0, arg_1) -> FrozenBufferedUpdates._init_$lambda$1(builder, arg_0, arg_1));
        this.deleteTerms = builder.finish();
        this.deleteQueries = new Query[updates.getDeleteQueries().size()];
        this.deleteQueryLimits = new int[updates.getDeleteQueries().size()];
        int upto = 0;
        for (Map.Entry<Query, Integer> ent : updates.getDeleteQueries().entrySet()) {
            this.deleteQueries[upto] = ent.getKey();
            this.deleteQueryLimits[upto] = ((Number)ent.getValue()).intValue();
            ++upto;
        }
        Iterable $this$forEach$iv = updates.getFieldUpdates().values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FieldUpdatesBuffer obj = (FieldUpdatesBuffer)element$iv;
            boolean bl2 = false;
            obj.finish();
        }
        this.fieldUpdates = MapsKt.toMutableMap(updates.getFieldUpdates());
        this.fieldUpdatesCount = updates.getNumFieldUpdates().get();
        this.bytesUsed = (int)(this.deleteTerms.ramBytesUsed() + (long)this.deleteQueries.length * 32L + updates.getFieldUpdatesBytesUsed().get());
        if (this.infoStream != null && this.infoStream.isEnabled("BD")) {
            this.infoStream.message("BD", "compressed " + updates.ramBytesUsed() + " to " + this.bytesUsed + " bytes (" + 100.0 * (double)this.bytesUsed / (double)updates.ramBytesUsed() + "%) for deletes/updates; private segment " + this.privateSegment);
        }
    }

    @Nullable
    public final SegmentCommitInfo getPrivateSegment() {
        return this.privateSegment;
    }

    @NotNull
    public final PrefixCodedTerms getDeleteTerms() {
        return this.deleteTerms;
    }

    @NotNull
    public final Query[] getDeleteQueries() {
        return this.deleteQueries;
    }

    @NotNull
    public final int[] getDeleteQueryLimits() {
        return this.deleteQueryLimits;
    }

    @NotNull
    public final CountDownLatch getApplied() {
        return this.applied;
    }

    public final long getTotalDelCount() {
        return this.totalDelCount;
    }

    public final void setTotalDelCount(long l) {
        this.totalDelCount = l;
    }

    public final int getBytesUsed() {
        return this.bytesUsed;
    }

    public final boolean tryLock() {
        return this.applyLock.tryLock();
    }

    public final void lock() {
        this.applyLock.lock();
    }

    public final void unlock() {
        this.applyLock.unlock();
    }

    public final boolean isApplied() {
        boolean condition$iv = this.applyLock.isHeldByCurrentThread();
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        return this.applied.getCount() == 0L;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object apply(@NotNull BufferedUpdatesStream.SegmentState[] segStates, @NotNull Continuation<? super Long> $completion) {
        if (!($completion instanceof apply.1)) ** GOTO lbl-1000
        var12_3 = $completion;
        if ((var12_3.label & -2147483648) != 0) {
            var12_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                long J$0;
                /* synthetic */ Object result;
                final /* synthetic */ FrozenBufferedUpdates this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.apply(null, (Continuation<? super Long>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var13_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                condition$iv = this.applyLock.isHeldByCurrentThread();
                $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    $i$a$-assert-AssertKt$assert$1 = false;
                    $i$a$-assert-AssertKt$assert$1 = "assertion failed";
                    throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$1);
                }
                if (!(this.delGen != -1L)) {
                    $i$a$-require-FrozenBufferedUpdates$apply$2 = false;
                    var4_17 = "gen is not yet set; call BufferedUpdatesStream.push first";
                    throw new IllegalArgumentException(var4_17.toString());
                }
                condition$iv = this.applied.getCount() != 0L;
                $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    $i$a$-assert-AssertKt$assert$1 = false;
                    $i$a$-assert-AssertKt$assert$1 = "assertion failed";
                    throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$1);
                }
                if (this.privateSegment != null) {
                    condition$iv = segStates.length == 1;
                    $i$f$assert = false;
                    if (_Assertions.ENABLED && !condition$iv) {
                        $i$a$-assert-AssertKt$assert$1 = false;
                        $i$a$-assert-AssertKt$assert$1 = "assertion failed";
                        throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$1);
                    }
                    condition$iv = this.privateSegment == segStates[0].getReader().getOriginalSegmentInfo();
                    $i$f$assert = false;
                    if (_Assertions.ENABLED && !condition$iv) {
                        $i$a$-assert-AssertKt$assert$1 = false;
                        var6_15 = "assertion failed";
                        throw new AssertionError((Object)var6_15);
                    }
                }
                var8_18 = this.totalDelCount;
                var7_19 = this;
                $continuation.L$0 = segStates;
                $continuation.L$1 = var7_19;
                $continuation.J$0 = var8_18;
                $continuation.label = 1;
                v0 = this.applyTermDeletes(segStates, (Continuation<? super Long>)$continuation);
                if (v0 == var13_5) {
                    return var13_5;
                }
                ** GOTO lbl57
            }
            case 1: {
                var8_18 = $continuation.J$0;
                var7_19 = (FrozenBufferedUpdates)$continuation.L$1;
                segStates = (BufferedUpdatesStream.SegmentState[])$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl57:
                // 2 sources

                var10_20 = v0;
                var7_19.totalDelCount = var8_18 + ((Number)var10_20).longValue();
                var8_18 = this.totalDelCount;
                var7_19 = this;
                $continuation.L$0 = segStates;
                $continuation.L$1 = var7_19;
                $continuation.J$0 = var8_18;
                $continuation.label = 2;
                v1 = this.applyQueryDeletes(segStates, (Continuation<? super Long>)$continuation);
                if (v1 == var13_5) {
                    return var13_5;
                }
                ** GOTO lbl75
            }
            case 2: {
                var8_18 = $continuation.J$0;
                var7_19 = (FrozenBufferedUpdates)$continuation.L$1;
                segStates = (BufferedUpdatesStream.SegmentState[])$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl75:
                // 2 sources

                var10_20 = v1;
                var7_19.totalDelCount = var8_18 + ((Number)var10_20).longValue();
                this.totalDelCount += this.applyDocValuesUpdates(segStates);
                return Boxing.boxLong((long)this.totalDelCount);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final long applyDocValuesUpdates(BufferedUpdatesStream.SegmentState[] segStates) throws IOException {
        if (this.fieldUpdates.isEmpty()) {
            return 0L;
        }
        long startNS = System.INSTANCE.nanoTime();
        long updateCount = 0L;
        int n = segStates.length;
        for (int i = 0; i < n; ++i) {
            boolean isSegmentPrivateDeletes;
            BufferedUpdatesStream.SegmentState segState = segStates[i];
            if (this.delGen < segState.getDelGen() || segState.getRld().refCount() == 1) continue;
            boolean bl = isSegmentPrivateDeletes = this.privateSegment != null;
            if (this.fieldUpdates.isEmpty()) continue;
            updateCount += FrozenBufferedUpdates.Companion.applyDocValuesUpdates(segState, this.fieldUpdates, this.delGen, isSegmentPrivateDeletes);
        }
        if (this.infoStream.isEnabled("BD")) {
            this.infoStream.message("BD", "applyDocValuesUpdates " + (double)(System.INSTANCE.nanoTime() - startNS) / (double)TimeUnit.MILLISECONDS.toNanos(1L) + " msec for " + segStates.length + " segments, " + this.fieldUpdatesCount + " field updates; " + updateCount + " new updates");
        }
        return updateCount;
    }

    /*
     * Unable to fully structure code
     */
    private final Object applyQueryDeletes(BufferedUpdatesStream.SegmentState[] segStates, Continuation<? super Long> $completion) {
        block21: {
            block19: {
                block20: {
                    if (!($completion instanceof applyQueryDeletes.1)) ** GOTO lbl-1000
                    var24_3 = $completion;
                    if ((var24_3.label & -2147483648) != 0) {
                        var24_3.label -= -2147483648;
                    } else lbl-1000:
                    // 2 sources

                    {
                        $continuation = new ContinuationImpl(this, $completion){
                            Object L$0;
                            Object L$1;
                            Object L$2;
                            Object L$3;
                            Object L$4;
                            Object L$5;
                            Object L$6;
                            Object L$7;
                            Object L$8;
                            long J$0;
                            long J$1;
                            int I$0;
                            int I$1;
                            int I$2;
                            int I$3;
                            int I$4;
                            /* synthetic */ Object result;
                            final /* synthetic */ FrozenBufferedUpdates this$0;
                            int label;
                            {
                                this.this$0 = this$0;
                                super($completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object $result) {
                                this.result = $result;
                                this.label |= Integer.MIN_VALUE;
                                return FrozenBufferedUpdates.access$applyQueryDeletes(this.this$0, null, (Continuation)this);
                            }
                        };
                    }
                    $result = $continuation.result;
                    var25_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    block0 : switch ($continuation.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            if (this.deleteQueries.length == 0) {
                                return Boxing.boxLong((long)0L);
                            }
                            startNS = System.INSTANCE.nanoTime();
                            delCount = 0L;
                            var7_8 = 0;
                            var8_9 = segStates.length;
lbl18:
                            // 2 sources

                            while (var7_8 < var8_9) {
                                segState = segStates[var7_8];
                                if (this.delGen < segState.getDelGen() || segState.getRld().refCount() == 1) break block19;
                                readerContext = segState.getReader().getContext();
                                i = 0;
                                var12_13 = this.deleteQueries.length;
lbl24:
                                // 2 sources

                                while (i < var12_13) {
                                    query = this.deleteQueries[i];
                                    limit = 0;
                                    if (this.delGen == segState.getDelGen()) {
                                        if (this.privateSegment == null) {
                                            var16_17 = "Required value was null.";
                                            throw new IllegalStateException(var16_17.toString());
                                        }
                                        limit = this.deleteQueryLimits[i];
                                    } else {
                                        limit = 0x7FFFFFFF;
                                    }
                                    searcher = new IndexSearcher(readerContext.reader(), null, 2, null);
                                    searcher.setQueryCache(null);
                                    query = searcher.rewrite(query);
                                    weight = searcher.createWeight(query, ScoreMode.COMPLETE_NO_SCORES, 1.0f);
                                    scorer = weight.scorer(readerContext);
                                    if (scorer == null) break block0;
                                    it = scorer.iterator();
                                    if (segState.getRld().getSortMap() == null || limit == 0x7FFFFFFF) break block0;
                                    if (this.privateSegment == null) {
                                        var20_22 = "Required value was null.";
                                        throw new IllegalStateException(var20_22.toString());
                                    }
                                    docID = new Ref.IntRef();
lbl46:
                                    // 3 sources

                                    while (true) {
                                        it = var20_21 = it.nextDoc();
                                        $i$a$-also-FrozenBufferedUpdates$applyQueryDeletes$2 = false;
                                        docID.element = it;
                                        if (var20_21 == 0x7FFFFFFF) break block0;
                                        v0 = segState.getRld().getSortMap();
                                        Intrinsics.checkNotNull((Object)v0);
                                        if (v0.newToOld(docID.element) >= limit) continue;
                                        $continuation.L$0 = segStates;
                                        $continuation.L$1 = segState;
                                        $continuation.L$2 = readerContext;
                                        $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)query);
                                        $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)searcher);
                                        $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)weight);
                                        $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)scorer);
                                        $continuation.L$7 = it;
                                        $continuation.L$8 = docID;
                                        $continuation.J$0 = startNS;
                                        $continuation.J$1 = delCount;
                                        $continuation.I$0 = var7_8;
                                        $continuation.I$1 = var8_9;
                                        $continuation.I$2 = i;
                                        $continuation.I$3 = var12_13;
                                        $continuation.I$4 = limit;
                                        $continuation.label = 1;
                                        v1 = segState.getRld().delete(docID.element, (Continuation<? super Boolean>)$continuation);
                                        if (v1 == var25_5) {
                                            return var25_5;
                                        }
                                        ** GOTO lbl96
                                        break;
                                    }
                                }
                                break block19;
                            }
                            break block21;
                        }
                        case 1: {
                            limit = $continuation.I$4;
                            var12_13 = $continuation.I$3;
                            i = $continuation.I$2;
                            var8_9 = $continuation.I$1;
                            var7_8 = $continuation.I$0;
                            delCount = $continuation.J$1;
                            startNS = $continuation.J$0;
                            docID = (Ref.IntRef)$continuation.L$8;
                            it = (DocIdSetIterator)$continuation.L$7;
                            scorer = (Scorer)$continuation.L$6;
                            weight = (Weight)$continuation.L$5;
                            searcher = (IndexSearcher)$continuation.L$4;
                            query = (Query)$continuation.L$3;
                            readerContext = (LeafReaderContext)$continuation.L$2;
                            segState = (BufferedUpdatesStream.SegmentState)$continuation.L$1;
                            segStates = (BufferedUpdatesStream.SegmentState[])$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl96:
                            // 2 sources

                            if (!((Boolean)v1).booleanValue()) ** GOTO lbl46
                            var20_23 = delCount;
                            delCount = var20_23 + 1L;
                            ** continue;
                        }
                    }
                    docID = new Ref.IntRef();
lbl101:
                    // 3 sources

                    while (true) {
                        it = var20_21 = it.nextDoc();
                        $i$a$-also-FrozenBufferedUpdates$applyQueryDeletes$3 = false;
                        docID.element = it;
                        if (var20_21 >= limit) break block20;
                        $continuation.L$0 = segStates;
                        $continuation.L$1 = segState;
                        $continuation.L$2 = readerContext;
                        $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)query);
                        $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)searcher);
                        $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)weight);
                        $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)scorer);
                        $continuation.L$7 = it;
                        $continuation.L$8 = docID;
                        $continuation.J$0 = startNS;
                        $continuation.J$1 = delCount;
                        $continuation.I$0 = var7_8;
                        $continuation.I$1 = var8_9;
                        $continuation.I$2 = i;
                        $continuation.I$3 = var12_13;
                        $continuation.I$4 = limit;
                        $continuation.label = 2;
                        v2 = segState.getRld().delete(docID.element, (Continuation<? super Boolean>)$continuation);
                        if (v2 == var25_5) {
                            return var25_5;
                        }
                        ** GOTO lbl146
                        break;
                    }
                    {
                        case 2: {
                            limit = $continuation.I$4;
                            var12_13 = $continuation.I$3;
                            i = $continuation.I$2;
                            var8_9 = $continuation.I$1;
                            var7_8 = $continuation.I$0;
                            delCount = $continuation.J$1;
                            startNS = $continuation.J$0;
                            docID = (Ref.IntRef)$continuation.L$8;
                            it = (DocIdSetIterator)$continuation.L$7;
                            scorer = (Scorer)$continuation.L$6;
                            weight = (Weight)$continuation.L$5;
                            searcher = (IndexSearcher)$continuation.L$4;
                            query = (Query)$continuation.L$3;
                            readerContext = (LeafReaderContext)$continuation.L$2;
                            segState = (BufferedUpdatesStream.SegmentState)$continuation.L$1;
                            segStates = (BufferedUpdatesStream.SegmentState[])$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl146:
                            // 2 sources

                            if (!((Boolean)v2).booleanValue()) ** GOTO lbl101
                            var20_24 = delCount;
                            delCount = var20_24 + 1L;
                            ** continue;
                        }
                    }
                }
                ++i;
                ** GOTO lbl24
            }
            ++var7_8;
            ** GOTO lbl18
        }
        if (this.infoStream.isEnabled("BD")) {
            this.infoStream.message("BD", "applyQueryDeletes took " + (double)(System.INSTANCE.nanoTime() - startNS) / (double)TimeUnit.MILLISECONDS.toNanos(1L) + " msec for " + segStates.length + " segments and " + this.deleteQueries.length + " queries; " + delCount + " new deletions");
        }
        return Boxing.boxLong((long)delCount);
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private final Object applyTermDeletes(BufferedUpdatesStream.SegmentState[] segStates, Continuation<? super Long> $completion) {
        if (!($completion instanceof applyTermDeletes.1)) ** GOTO lbl-1000
        var19_3 = $completion;
        if ((var19_3.label & -2147483648) != 0) {
            var19_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                long J$0;
                long J$1;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ FrozenBufferedUpdates this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return FrozenBufferedUpdates.access$applyTermDeletes(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var20_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.deleteTerms.size() == 0L) {
                    return Boxing.boxLong((long)0L);
                }
                condition$iv = this.privateSegment == null;
                $i$f$assert = false;
                if (_Assertions.ENABLED && !condition$iv) {
                    $i$a$-assert-AssertKt$assert$1 = false;
                    var6_11 = "assertion failed";
                    throw new AssertionError((Object)var6_11);
                }
                startNS = System.INSTANCE.nanoTime();
                delCount = 0L;
                var8_13 = segStates.length;
                break;
            }
            case 1: {
                var8_13 = $continuation.I$1;
                var7_12 = $continuation.I$0;
                delCount = $continuation.J$1;
                startNS = $continuation.J$0;
                docID = (Ref.IntRef)$continuation.L$6;
                iterator = (DocIdSetIterator)$continuation.L$5;
                termDocsIterator = (TermDocsIterator)$continuation.L$4;
                delTerm = (Ref.ObjectRef)$continuation.L$3;
                iter = (FieldTermIterator)$continuation.L$2;
                segState = (BufferedUpdatesStream.SegmentState)$continuation.L$1;
                segStates = (BufferedUpdatesStream.SegmentState[])$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
                while (true) {
                    if (((Boolean)v0).booleanValue()) {
                        var15_24 = delCount;
                        delCount = var15_24 + 1L;
                    }
                    ** GOTO lbl70
                    break;
                }
            }
            default: {
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
        }
        block5: for (var7_12 = 0; var7_12 < var8_13; ++var7_12) {
            segState = segStates[var7_12];
            var10_15 = segState.getDelGen() != this.delGen;
            $i$f$assert = false;
            if (_Assertions.ENABLED && condition$iv == false) {
                $i$a$-assert-FrozenBufferedUpdates$applyTermDeletes$2 = false;
                var13_21 = "segState.delGen=" + segState.getDelGen() + " vs this.gen=" + this.delGen;
                throw new AssertionError(var13_21);
            }
            if (segState.getDelGen() > this.delGen || segState.getRld().refCount() == 1) continue;
            iter = this.deleteTerms.iterator();
            delTerm = new Ref.ObjectRef();
            termDocsIterator = new TermDocsIterator(segState.getReader(), true);
            while (true) {
                it = var13_21 = iter.next();
                $i$a$-also-FrozenBufferedUpdates$applyTermDeletes$3 = false;
                delTerm.element = it;
                if (var13_21 == null) continue block5;
                v1 = iter.field();
                Intrinsics.checkNotNull((Object)v1);
                v2 = delTerm.element;
                Intrinsics.checkNotNull((Object)v2);
                iterator = termDocsIterator.nextTerm(v1, (BytesRef)v2);
                if (iterator == null) continue;
                docID = new Ref.IntRef();
lbl70:
                // 2 sources

                it = var15_23 = iterator.nextDoc();
                $i$a$-also-FrozenBufferedUpdates$applyTermDeletes$4 = false;
                docID.element = it;
                if (var15_23 != 0x7FFFFFFF) break;
            }
            $continuation.L$0 = segStates;
            $continuation.L$1 = segState;
            $continuation.L$2 = iter;
            $continuation.L$3 = delTerm;
            $continuation.L$4 = termDocsIterator;
            $continuation.L$5 = iterator;
            $continuation.L$6 = docID;
            $continuation.J$0 = startNS;
            $continuation.J$1 = delCount;
            $continuation.I$0 = var7_12;
            $continuation.I$1 = var8_13;
            $continuation.label = 1;
            if ((v0 = segState.getRld().delete(docID.element, (Continuation<? super Boolean>)$continuation)) != var20_5) ** continue;
            return var20_5;
        }
        if (this.infoStream.isEnabled("BD")) {
            this.infoStream.message("BD", "applyTermDeletes took " + (double)(System.INSTANCE.nanoTime() - startNS) / (double)TimeUnit.MILLISECONDS.toNanos(1L) + " msec for " + segStates.length + " segments and " + this.deleteTerms.size() + " del terms; " + delCount + " new deletions");
        }
        return Boxing.boxLong((long)delCount);
    }

    public final void setDelGen(long delGen) {
        boolean condition$iv = this.delGen == -1L;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "delGen was already previously set to " + this.delGen;
            throw new AssertionError((Object)string);
        }
        this.delGen = delGen;
        this.deleteTerms.setDelGen(delGen);
    }

    public final long delGen() {
        boolean condition$iv = this.delGen != -1L;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        return this.delGen;
    }

    @NotNull
    public String toString() {
        String s = "delGen=" + this.delGen;
        if (this.deleteTerms.size() != 0L) {
            s = s + " unique deleteTerms=" + this.deleteTerms.size();
        }
        if (!(this.deleteQueries.length == 0)) {
            s = s + " numDeleteQueries=" + this.deleteQueries.length;
        }
        if (!this.fieldUpdates.isEmpty()) {
            s = s + " fieldUpdates=" + this.fieldUpdatesCount;
        }
        if (this.bytesUsed != 0) {
            s = s + " bytesUsed=" + this.bytesUsed;
        }
        if (this.privateSegment != null) {
            s = s + " privateSegment=" + this.privateSegment;
        }
        return s;
    }

    public final boolean any() {
        return this.deleteTerms.size() > 0L || !(this.deleteQueries.length == 0) || this.fieldUpdatesCount > 0;
    }

    private static final void _init_$lambda$1(PrefixCodedTerms.Builder $builder, Term term, int docId) {
        Intrinsics.checkNotNullParameter((Object)term, (String)"term");
        $builder.add(term);
    }

    public static final /* synthetic */ Object access$applyQueryDeletes(FrozenBufferedUpdates $this, BufferedUpdatesStream.SegmentState[] segStates, Continuation $completion) {
        return $this.applyQueryDeletes(segStates, (Continuation<? super Long>)$completion);
    }

    public static final /* synthetic */ Object access$applyTermDeletes(FrozenBufferedUpdates $this, BufferedUpdatesStream.SegmentState[] segStates, Continuation $completion) {
        return $this.applyTermDeletes(segStates, (Continuation<? super Long>)$completion);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/gnit/lucenekmp/index/FrozenBufferedUpdates$Companion;", "", "<init>", "()V", "BYTES_PER_DEL_QUERY", "", "applyDocValuesUpdates", "", "segState", "Lorg/gnit/lucenekmp/index/BufferedUpdatesStream$SegmentState;", "updates", "", "", "Lorg/gnit/lucenekmp/index/FieldUpdatesBuffer;", "delGen", "segmentPrivateDeletes", "", "core"})
    @SourceDebugExtension(value={"SMAP\nFrozenBufferedUpdates.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrozenBufferedUpdates.kt\norg/gnit/lucenekmp/index/FrozenBufferedUpdates$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 4 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,622:1\n1#2:623\n3#3,8:624\n10#4:632\n*S KotlinDebug\n*F\n+ 1 FrozenBufferedUpdates.kt\norg/gnit/lucenekmp/index/FrozenBufferedUpdates$Companion\n*L\n528#1:624,8\n528#1:632\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Unable to fully structure code
         */
        private final long applyDocValuesUpdates(BufferedUpdatesStream.SegmentState segState, Map<String, FieldUpdatesBuffer> updates, long delGen, boolean segmentPrivateDeletes) throws IOException {
            updateCount = 0L;
            resolvedUpdates = new ArrayList<E>();
            block0: for (Map.Entry<String, FieldUpdatesBuffer> fieldUpdate : updates.entrySet()) {
                updateField = fieldUpdate.getKey();
                dvUpdates = null;
                value = fieldUpdate.getValue();
                isNumeric = value.isNumeric();
                iterator = value.iterator();
                bufferedUpdate = null;
                termDocsIterator = new TermDocsIterator(segState.getReader(), iterator.isSortedTerms());
                block1: while (true) {
                    it = var18_16 = iterator.next();
                    $i$a$-also-FrozenBufferedUpdates$Companion$applyDocValuesUpdates$1 = false;
                    bufferedUpdate = it;
                    if (var18_16 == null) continue block0;
                    v0 = bufferedUpdate;
                    Intrinsics.checkNotNull((Object)v0);
                    v1 = v0.getTermField();
                    Intrinsics.checkNotNull((Object)v1);
                    v2 = bufferedUpdate.getTermValue();
                    Intrinsics.checkNotNull((Object)v2);
                    docIdSetIterator = termDocsIterator.nextTerm(v1, v2);
                    if (docIdSetIterator == null) continue;
                    limit = 0;
                    if (delGen == segState.getDelGen()) {
                        condition$iv = segmentPrivateDeletes;
                        $i$f$assert = false;
                        if (_Assertions.ENABLED && !condition$iv) {
                            $i$a$-assert-AssertKt$assert$1 = false;
                            $i$a$-assert-AssertKt$assert$1 = "assertion failed";
                            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$1);
                        }
                        limit = bufferedUpdate.getDocUpTo();
                    } else {
                        limit = 0x7FFFFFFF;
                    }
                    binaryValue = null;
                    longValue = 0L;
                    if (!bufferedUpdate.getHasValue()) {
                        longValue = -1L;
                        binaryValue = null;
                    } else {
                        longValue = bufferedUpdate.getNumericValue();
                        binaryValue = bufferedUpdate.getBinaryValue();
                    }
                    if (dvUpdates == null) {
                        dvUpdates = isNumeric != false ? (value.hasSingleValue() != false ? (DocValuesFieldUpdates)new NumericDocValuesFieldUpdates.SingleValueNumericDocValuesFieldUpdates(delGen, updateField, segState.getReader().maxDoc(), value.getNumericValue(0)) : (DocValuesFieldUpdates)new NumericDocValuesFieldUpdates(delGen, updateField, value.getMinNumeric(), value.getMaxNumeric(), segState.getReader().maxDoc())) : (DocValuesFieldUpdates)new BinaryDocValuesFieldUpdates(delGen, updateField, segState.getReader().maxDoc());
                        resolvedUpdates.add(dvUpdates);
                    }
                    docIdConsumer = null;
                    update = dvUpdates;
                    docIdConsumer = bufferedUpdate.getHasValue() == false ? (Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, applyDocValuesUpdates$lambda$1(org.gnit.lucenekmp.index.DocValuesFieldUpdates int ), (Ljava/lang/Integer;)Lkotlin/Unit;)(update) : (isNumeric != false ? (Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, applyDocValuesUpdates$lambda$2(org.gnit.lucenekmp.index.DocValuesFieldUpdates long int ), (Ljava/lang/Integer;)Lkotlin/Unit;)((DocValuesFieldUpdates)update, (long)longValue) : (Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, applyDocValuesUpdates$lambda$3(org.gnit.lucenekmp.index.DocValuesFieldUpdates org.gnit.lucenekmp.util.BytesRef int ), (Ljava/lang/Integer;)Lkotlin/Unit;)((DocValuesFieldUpdates)update, (BytesRef)binaryValue));
                    acceptDocs = segState.getRld().getLiveDocs();
                    if (segState.getRld().getSortMap() != null && segmentPrivateDeletes) {
                        doc = 0;
                        while (true) {
                            it = var27_29 = docIdSetIterator.nextDoc();
                            $i$a$-also-FrozenBufferedUpdates$Companion$applyDocValuesUpdates$5 = false;
                            doc = it;
                            if (var27_29 == 0x7FFFFFFF) continue block1;
                            if (acceptDocs != null && !acceptDocs.get(doc)) continue;
                            v3 = segState.getRld().getSortMap();
                            Intrinsics.checkNotNull((Object)v3);
                            if (v3.newToOld(doc) >= limit) continue;
                            docIdConsumer.invoke((Object)doc);
                            var27_30 = updateCount;
                            updateCount = var27_30 + 1L;
                        }
                    }
                    doc = 0;
                    while (true) {
                        it = var27_29 = docIdSetIterator.nextDoc();
                        $i$a$-also-FrozenBufferedUpdates$Companion$applyDocValuesUpdates$6 = false;
                        doc = it;
                        if (var27_29 != 0x7FFFFFFF && doc < limit) ** break;
                        continue block1;
                        if (acceptDocs != null && !acceptDocs.get(doc)) continue;
                        docIdConsumer.invoke((Object)doc);
                        var27_31 = updateCount;
                        updateCount = var27_31 + 1L;
                    }
                    break;
                }
            }
            for (DocValuesFieldUpdates update : resolvedUpdates) {
                if (!update.any()) continue;
                update.finish();
                segState.getRld().addDVUpdate(update);
            }
            return updateCount;
        }

        private static final Unit applyDocValuesUpdates$lambda$1(DocValuesFieldUpdates $update, int doc) {
            $update.reset(doc);
            return Unit.INSTANCE;
        }

        private static final Unit applyDocValuesUpdates$lambda$2(DocValuesFieldUpdates $update, long $longValue, int doc) {
            $update.add(doc, $longValue);
            return Unit.INSTANCE;
        }

        private static final Unit applyDocValuesUpdates$lambda$3(DocValuesFieldUpdates $update, BytesRef $binaryValue, int doc) {
            BytesRef bytesRef = $binaryValue;
            Intrinsics.checkNotNull((Object)bytesRef);
            $update.add(doc, bytesRef);
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001:\u0001 B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\nB\u0019\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\rJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u0015J\u0010\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006!"}, d2={"Lorg/gnit/lucenekmp/index/FrozenBufferedUpdates$TermDocsIterator;", "", "provider", "Lorg/gnit/lucenekmp/index/FrozenBufferedUpdates$TermDocsIterator$TermsProvider;", "sortedTerms", "", "<init>", "(Lorg/gnit/lucenekmp/index/FrozenBufferedUpdates$TermDocsIterator$TermsProvider;Z)V", "fields", "Lorg/gnit/lucenekmp/index/Fields;", "(Lorg/gnit/lucenekmp/index/Fields;Z)V", "reader", "Lorg/gnit/lucenekmp/index/LeafReader;", "(Lorg/gnit/lucenekmp/index/LeafReader;Z)V", "field", "", "termsEnum", "Lorg/gnit/lucenekmp/index/TermsEnum;", "postingsEnum", "Lorg/gnit/lucenekmp/index/PostingsEnum;", "readerTerm", "Lorg/gnit/lucenekmp/util/BytesRef;", "lastTerm", "setField", "", "nextTerm", "Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "term", "assertSorted", "docs", "getDocs", "()Lorg/gnit/lucenekmp/search/DocIdSetIterator;", "TermsProvider", "core"})
    @SourceDebugExtension(value={"SMAP\nFrozenBufferedUpdates.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrozenBufferedUpdates.kt\norg/gnit/lucenekmp/index/FrozenBufferedUpdates$TermDocsIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 4 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,622:1\n1#2:623\n3#3,8:624\n3#3,8:633\n3#3,8:642\n8#3,2:651\n10#4:632\n10#4:641\n10#4:650\n*S KotlinDebug\n*F\n+ 1 FrozenBufferedUpdates.kt\norg/gnit/lucenekmp/index/FrozenBufferedUpdates$TermDocsIterator\n*L\n405#1:624,8\n422#1:633,8\n457#1:642,8\n458#1:651,2\n405#1:632\n422#1:641\n457#1:650\n*E\n"})
    public static final class TermDocsIterator {
        @NotNull
        private final TermsProvider provider;
        private final boolean sortedTerms;
        @Nullable
        private String field;
        @Nullable
        private TermsEnum termsEnum;
        @Nullable
        private PostingsEnum postingsEnum;
        @Nullable
        private BytesRef readerTerm;
        @Nullable
        private BytesRef lastTerm;

        public TermDocsIterator(@NotNull TermsProvider provider, boolean sortedTerms) {
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            this.provider = provider;
            this.sortedTerms = sortedTerms;
        }

        public TermDocsIterator(@NotNull Fields fields, boolean sortedTerms) {
            Intrinsics.checkNotNullParameter((Object)fields, (String)"fields");
            this(arg_0 -> TermDocsIterator._init_$lambda$0(fields, arg_0), sortedTerms);
        }

        public TermDocsIterator(@NotNull LeafReader reader2, boolean sortedTerms) {
            Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
            this(arg_0 -> TermDocsIterator._init_$lambda$1(reader2, arg_0), sortedTerms);
        }

        private final void setField(String field) throws IOException {
            if (this.field == null || !Intrinsics.areEqual((Object)this.field, (Object)field)) {
                this.field = field;
                Terms terms = this.provider.terms(field);
                if (terms != null) {
                    this.termsEnum = terms.iterator();
                    if (this.sortedTerms) {
                        Object var3_3;
                        Object it = var3_3 = null;
                        boolean bl = false;
                        this.lastTerm = it;
                        boolean condition$iv = true;
                        boolean $i$f$assert = false;
                        if (_Assertions.ENABLED) {
                            // empty if block
                        }
                        TermsEnum termsEnum = this.termsEnum;
                        Intrinsics.checkNotNull((Object)termsEnum);
                        this.readerTerm = termsEnum.next();
                    }
                } else {
                    this.termsEnum = null;
                }
            }
        }

        @Nullable
        public final DocIdSetIterator nextTerm(@NotNull String field, @NotNull BytesRef term) throws IOException {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)term, (String)"term");
            this.setField(field);
            if (this.termsEnum != null) {
                if (this.sortedTerms) {
                    boolean condition$iv = this.assertSorted(term);
                    boolean $i$f$assert = false;
                    if (_Assertions.ENABLED && !condition$iv) {
                        boolean bl = false;
                        String string = "assertion failed";
                        throw new AssertionError((Object)string);
                    }
                    BytesRef bytesRef = this.readerTerm;
                    Intrinsics.checkNotNull((Object)bytesRef);
                    int cmp = term.compareTo(bytesRef);
                    if (cmp < 0) {
                        return null;
                    }
                    if (cmp == 0) {
                        return this.getDocs();
                    }
                    TermsEnum termsEnum = this.termsEnum;
                    Intrinsics.checkNotNull((Object)termsEnum);
                    TermsEnum.SeekStatus status = termsEnum.seekCeil(term);
                    switch (WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
                        case 1: {
                            return this.getDocs();
                        }
                        case 2: {
                            TermsEnum termsEnum2 = this.termsEnum;
                            Intrinsics.checkNotNull((Object)termsEnum2);
                            this.readerTerm = termsEnum2.term();
                            return null;
                        }
                        case 3: {
                            this.termsEnum = null;
                            return null;
                        }
                    }
                    throw new AssertionError((Object)"unknown status");
                }
                TermsEnum termsEnum = this.termsEnum;
                Intrinsics.checkNotNull((Object)termsEnum);
                if (termsEnum.seekExact(term)) {
                    return this.getDocs();
                }
            }
            return null;
        }

        /*
         * Unable to fully structure code
         */
        private final boolean assertSorted(BytesRef term) {
            condition$iv = this.sortedTerms;
            $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                $i$a$-assert-AssertKt$assert$1 = false;
                var5_5 = "assertion failed";
                throw new AssertionError((Object)var5_5);
            }
            if (this.lastTerm == null) ** GOTO lbl-1000
            v0 = this.lastTerm;
            Intrinsics.checkNotNull((Object)v0);
            if (term.compareTo(v0) >= 0) lbl-1000:
            // 2 sources

            {
                v1 = true;
            } else {
                v1 = false;
            }
            condition$iv = v1;
            $i$f$assert = false;
            if (_Assertions.ENABLED && !condition$iv) {
                $i$a$-assert-FrozenBufferedUpdates$TermDocsIterator$assertSorted$1 = false;
                v2 = term.utf8ToString();
                v3 = this.lastTerm;
                Intrinsics.checkNotNull((Object)v3);
                var5_6 = "boom: " + v2 + " last: " + v3.utf8ToString();
                throw new AssertionError((Object)var5_6);
            }
            this.lastTerm = BytesRef.Companion.deepCopyOf(term);
            return true;
        }

        private final DocIdSetIterator getDocs() {
            PostingsEnum postingsEnum;
            if (this.termsEnum == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            TermsEnum termsEnum = this.termsEnum;
            Intrinsics.checkNotNull((Object)termsEnum);
            PostingsEnum it = postingsEnum = termsEnum.postings(this.postingsEnum, 0);
            boolean bl = false;
            this.postingsEnum = it;
            return postingsEnum;
        }

        private static final Terms _init_$lambda$0(Fields $fields, String field) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Terms terms = $fields.terms(field);
            Intrinsics.checkNotNull((Object)terms);
            return terms;
        }

        private static final Terms _init_$lambda$1(LeafReader $reader, String field) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Terms terms = $reader.terms(field);
            Intrinsics.checkNotNull((Object)terms);
            return terms;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00e0\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006\u00c0\u0006\u0003"}, d2={"Lorg/gnit/lucenekmp/index/FrozenBufferedUpdates$TermDocsIterator$TermsProvider;", "", "terms", "Lorg/gnit/lucenekmp/index/Terms;", "field", "", "core"})
        public static interface TermsProvider {
            @NotNull
            public Terms terms(@NotNull String var1) throws IOException;
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[TermsEnum.SeekStatus.values().length];
                try {
                    nArray[TermsEnum.SeekStatus.FOUND.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TermsEnum.SeekStatus.NOT_FOUND.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TermsEnum.SeekStatus.END.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

